/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef jit_MIROpsGenerated_h
#define jit_MIROpsGenerated_h

/* This file is generated by jit/GenerateMIRFiles.py. Do not edit! */

#define MIR_OPCODE_LIST(_)\
_(Start)\
_(OsrEntry)\
_(Nop)\
_(LimitedTruncate)\
_(Constant)\
_(WasmNullConstant)\
_(WasmFloatConstant)\
_(Parameter)\
_(Callee)\
_(IsConstructing)\
_(TableSwitch)\
_(Goto)\
_(Test)\
_(Return)\
_(Throw)\
_(NewArray)\
_(NewArrayDynamicLength)\
_(NewTypedArray)\
_(NewTypedArrayDynamicLength)\
_(NewTypedArrayFromArray)\
_(NewTypedArrayFromArrayBuffer)\
_(NewObject)\
_(NewPlainObject)\
_(NewArrayObject)\
_(NewIterator)\
_(ObjectState)\
_(ArrayState)\
_(MutateProto)\
_(InitPropGetterSetter)\
_(InitElemGetterSetter)\
_(Call)\
_(ApplyArgs)\
_(ApplyArgsObj)\
_(ApplyArray)\
_(ConstructArray)\
_(Bail)\
_(Unreachable)\
_(EncodeSnapshot)\
_(AssertRecoveredOnBailout)\
_(AssertFloat32)\
_(Compare)\
_(SameValueDouble)\
_(SameValue)\
_(Box)\
_(Unbox)\
_(AssertRange)\
_(AssertClass)\
_(AssertShape)\
_(CreateThisWithTemplate)\
_(CreateThis)\
_(CreateArgumentsObject)\
_(CreateInlinedArgumentsObject)\
_(GetInlinedArgument)\
_(GetArgumentsObjectArg)\
_(SetArgumentsObjectArg)\
_(LoadArgumentsObjectArg)\
_(ArgumentsObjectLength)\
_(GuardArgumentsObjectFlags)\
_(ReturnFromCtor)\
_(ToDouble)\
_(ToFloat32)\
_(WasmUnsignedToDouble)\
_(WasmUnsignedToFloat32)\
_(WrapInt64ToInt32)\
_(ExtendInt32ToInt64)\
_(WasmBuiltinTruncateToInt64)\
_(WasmTruncateToInt64)\
_(WasmTruncateToInt32)\
_(WasmBoxValue)\
_(WasmAnyRefFromJSObject)\
_(Int32ToIntPtr)\
_(NonNegativeIntPtrToInt32)\
_(IntPtrToDouble)\
_(AdjustDataViewLength)\
_(Int64ToFloatingPoint)\
_(BuiltinInt64ToFloatingPoint)\
_(ToNumberInt32)\
_(ToIntegerInt32)\
_(TruncateToInt32)\
_(WasmBuiltinTruncateToInt32)\
_(ToBigInt)\
_(ToInt64)\
_(TruncateBigIntToInt64)\
_(Int64ToBigInt)\
_(ToString)\
_(BitNot)\
_(TypeOf)\
_(ToAsyncIter)\
_(ToPropertyKeyCache)\
_(BitAnd)\
_(BitOr)\
_(BitXor)\
_(Lsh)\
_(Rsh)\
_(Ursh)\
_(SignExtendInt32)\
_(SignExtendInt64)\
_(MinMax)\
_(MinMaxArray)\
_(Abs)\
_(Clz)\
_(Ctz)\
_(Popcnt)\
_(Sqrt)\
_(CopySign)\
_(Atan2)\
_(Hypot)\
_(Pow)\
_(PowHalf)\
_(Random)\
_(Sign)\
_(MathFunction)\
_(Add)\
_(Sub)\
_(Mul)\
_(Div)\
_(WasmBuiltinDivI64)\
_(Mod)\
_(WasmBuiltinModD)\
_(WasmBuiltinModI64)\
_(BigIntAdd)\
_(BigIntSub)\
_(BigIntMul)\
_(BigIntDiv)\
_(BigIntMod)\
_(BigIntPow)\
_(BigIntBitAnd)\
_(BigIntBitOr)\
_(BigIntBitXor)\
_(BigIntLsh)\
_(BigIntRsh)\
_(BigIntIncrement)\
_(BigIntDecrement)\
_(BigIntNegate)\
_(BigIntBitNot)\
_(Concat)\
_(CharCodeAt)\
_(FromCharCode)\
_(FromCodePoint)\
_(StringConvertCase)\
_(StringSplit)\
_(BoxNonStrictThis)\
_(ImplicitThis)\
_(ArrowNewTarget)\
_(Phi)\
_(Beta)\
_(NaNToZero)\
_(OsrValue)\
_(OsrEnvironmentChain)\
_(OsrArgumentsObject)\
_(OsrReturnValue)\
_(BinaryCache)\
_(UnaryCache)\
_(CheckOverRecursed)\
_(InterruptCheck)\
_(WasmInterruptCheck)\
_(WasmTrap)\
_(LexicalCheck)\
_(ThrowRuntimeLexicalError)\
_(ThrowMsg)\
_(GlobalDeclInstantiation)\
_(RegExp)\
_(RegExpMatcher)\
_(RegExpSearcher)\
_(RegExpTester)\
_(RegExpPrototypeOptimizable)\
_(RegExpInstanceOptimizable)\
_(GetFirstDollarIndex)\
_(StringReplace)\
_(Substr)\
_(ModuleMetadata)\
_(DynamicImport)\
_(Lambda)\
_(LambdaArrow)\
_(FunctionWithProto)\
_(SetFunName)\
_(Slots)\
_(Elements)\
_(InitializedLength)\
_(SetInitializedLength)\
_(ArrayLength)\
_(SetArrayLength)\
_(FunctionLength)\
_(FunctionName)\
_(GetNextEntryForIterator)\
_(ArrayBufferByteLength)\
_(ArrayBufferViewLength)\
_(ArrayBufferViewByteOffset)\
_(ArrayBufferViewElements)\
_(TypedArrayElementSize)\
_(GuardHasAttachedArrayBuffer)\
_(GuardNumberToIntPtrIndex)\
_(KeepAliveObject)\
_(Not)\
_(BoundsCheck)\
_(BoundsCheckLower)\
_(SpectreMaskIndex)\
_(LoadElement)\
_(LoadElementAndUnbox)\
_(LoadElementHole)\
_(StoreElement)\
_(StoreHoleValueElement)\
_(StoreElementHole)\
_(ArrayPopShift)\
_(ArrayPush)\
_(ArraySlice)\
_(ArrayJoin)\
_(LoadUnboxedScalar)\
_(LoadDataViewElement)\
_(LoadTypedArrayElementHole)\
_(StoreUnboxedScalar)\
_(StoreDataViewElement)\
_(StoreTypedArrayElementHole)\
_(EffectiveAddress)\
_(ClampToUint8)\
_(LoadFixedSlot)\
_(LoadFixedSlotAndUnbox)\
_(LoadDynamicSlotAndUnbox)\
_(StoreFixedSlot)\
_(GetPropertyCache)\
_(HomeObjectSuperBase)\
_(GetPropSuperCache)\
_(BindNameCache)\
_(CallBindVar)\
_(GuardShape)\
_(GuardProto)\
_(GuardNullProto)\
_(GuardIsNativeObject)\
_(GuardIsProxy)\
_(GuardIsNotDOMProxy)\
_(GuardIsNotProxy)\
_(ProxyGet)\
_(ProxyGetByValue)\
_(ProxyHasProp)\
_(ProxySet)\
_(ProxySetByValue)\
_(CallSetArrayLength)\
_(MegamorphicLoadSlot)\
_(MegamorphicLoadSlotByValue)\
_(MegamorphicStoreSlot)\
_(MegamorphicHasProp)\
_(GuardIsNotArrayBufferMaybeShared)\
_(GuardIsTypedArray)\
_(NurseryObject)\
_(GuardValue)\
_(GuardNullOrUndefined)\
_(GuardFunctionFlags)\
_(GuardFunctionIsNonBuiltinCtor)\
_(GuardFunctionKind)\
_(GuardFunctionScript)\
_(GuardObjectIdentity)\
_(GuardSpecificFunction)\
_(GuardSpecificAtom)\
_(GuardSpecificSymbol)\
_(GuardStringToIndex)\
_(GuardStringToInt32)\
_(GuardStringToDouble)\
_(GuardNoDenseElements)\
_(GuardTagNotEqual)\
_(LoadDynamicSlot)\
_(FunctionEnvironment)\
_(NewLexicalEnvironmentObject)\
_(NewClassBodyEnvironmentObject)\
_(CopyLexicalEnvironmentObject)\
_(HomeObject)\
_(AddAndStoreSlot)\
_(AllocateAndStoreSlot)\
_(StoreDynamicSlot)\
_(GetNameCache)\
_(CallGetIntrinsicValue)\
_(DeleteProperty)\
_(DeleteElement)\
_(SetPropertyCache)\
_(CallSetElement)\
_(SetDOMProperty)\
_(GetDOMProperty)\
_(GetDOMMember)\
_(LoadDOMExpandoValue)\
_(LoadDOMExpandoValueGuardGeneration)\
_(LoadDOMExpandoValueIgnoreGeneration)\
_(GuardDOMExpandoMissingOrGuardShape)\
_(StringLength)\
_(Floor)\
_(Ceil)\
_(Round)\
_(Trunc)\
_(NearbyInt)\
_(GetIteratorCache)\
_(OptimizeSpreadCallCache)\
_(IteratorMore)\
_(IsNoIter)\
_(IteratorEnd)\
_(InCache)\
_(InArray)\
_(GuardElementNotHole)\
_(CheckPrivateFieldCache)\
_(HasOwnCache)\
_(InstanceOf)\
_(InstanceOfCache)\
_(ArgumentsLength)\
_(GetFrameArgument)\
_(NewTarget)\
_(Rest)\
_(PostWriteBarrier)\
_(PostWriteElementBarrier)\
_(NewNamedLambdaObject)\
_(NewCallObject)\
_(NewStringObject)\
_(IsCallable)\
_(IsConstructor)\
_(IsCrossRealmArrayConstructor)\
_(IsObject)\
_(IsNullOrUndefined)\
_(HasClass)\
_(GuardToClass)\
_(IsArray)\
_(IsTypedArray)\
_(ObjectClassToString)\
_(CheckReturn)\
_(CheckThis)\
_(AsyncResolve)\
_(GeneratorReturn)\
_(AsyncAwait)\
_(CheckThisReinit)\
_(Generator)\
_(CanSkipAwait)\
_(MaybeExtractAwaitValue)\
_(IncrementWarmUpCounter)\
_(AtomicIsLockFree)\
_(CompareExchangeTypedArrayElement)\
_(AtomicExchangeTypedArrayElement)\
_(AtomicTypedArrayElementBinop)\
_(Debugger)\
_(CheckIsObj)\
_(CheckObjCoercible)\
_(CheckClassHeritage)\
_(DebugCheckSelfHosted)\
_(FinishBoundFunctionInit)\
_(IsPackedArray)\
_(GuardArrayIsPacked)\
_(GetPrototypeOf)\
_(ObjectWithProto)\
_(ObjectStaticProto)\
_(BuiltinObject)\
_(SuperFunction)\
_(InitHomeObject)\
_(IsTypedArrayConstructor)\
_(LoadValueTag)\
_(LoadWrapperTarget)\
_(GuardHasGetterSetter)\
_(GuardIsExtensible)\
_(GuardInt32IsNonNegative)\
_(GuardIndexGreaterThanDenseInitLength)\
_(GuardIndexIsValidUpdateOrAdd)\
_(CallAddOrUpdateSparseElement)\
_(CallGetSparseElement)\
_(CallNativeGetElement)\
_(CallObjectHasSparseElement)\
_(BigIntAsIntN)\
_(BigIntAsUintN)\
_(WasmNeg)\
_(WasmLoadTls)\
_(WasmHeapBase)\
_(WasmBoundsCheck)\
_(WasmExtendU32Index)\
_(WasmWrapU32Index)\
_(WasmAddOffset)\
_(WasmAlignmentCheck)\
_(WasmLoad)\
_(WasmStore)\
_(AsmJSLoadHeap)\
_(AsmJSStoreHeap)\
_(WasmFence)\
_(WasmCompareExchangeHeap)\
_(WasmAtomicExchangeHeap)\
_(WasmAtomicBinopHeap)\
_(WasmLoadGlobalVar)\
_(WasmLoadGlobalCell)\
_(WasmStoreGlobalVar)\
_(WasmStoreGlobalCell)\
_(WasmStoreStackResult)\
_(WasmDerivedPointer)\
_(WasmStoreRef)\
_(WasmParameter)\
_(WasmReturn)\
_(WasmReturnVoid)\
_(WasmStackArg)\
_(WasmRegisterResult)\
_(WasmFloatRegisterResult)\
_(WasmRegister64Result)\
_(WasmStackResultArea)\
_(WasmStackResult)\
_(WasmCall)\
_(WasmSelect)\
_(WasmReinterpret)\
_(Rotate)\
_(WasmBitselectSimd128)\
_(WasmBinarySimd128)\
_(WasmBinarySimd128WithConstant)\
_(WasmShiftSimd128)\
_(WasmShuffleSimd128)\
_(WasmReplaceLaneSimd128)\
_(WasmUnarySimd128)\
_(WasmScalarToSimd128)\
_(WasmReduceSimd128)\
_(WasmLoadLaneSimd128)\
_(WasmStoreLaneSimd128)\
_(UnreachableResult)\
_(IonToWasmCall)

#define MIR_OPCODE_CLASS_GENERATED \
class MStart : public MNullaryInstruction {\
  explicit MStart() : MNullaryInstruction(classOpcode) {\
  }\
 public:\
  INSTRUCTION_HEADER(Start)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MOsrEntry : public MNullaryInstruction {\
  explicit MOsrEntry() : MNullaryInstruction(classOpcode) {\
    setResultType(MIRType::Pointer);\
  }\
 public:\
  INSTRUCTION_HEADER(OsrEntry)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MNop : public MNullaryInstruction {\
  explicit MNop() : MNullaryInstruction(classOpcode) {\
  }\
 public:\
  INSTRUCTION_HEADER(Nop)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  ALLOW_CLONE(MNop)\
};\
\
class MCallee : public MNullaryInstruction {\
  explicit MCallee() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(Callee)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsConstructing : public MNullaryInstruction {\
  explicit MIsConstructing() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsConstructing)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MThrow : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MThrow(MDefinition* ins) : MUnaryInstruction(classOpcode, ins) {\
  }\
 public:\
  INSTRUCTION_HEADER(Throw)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, ins))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewArrayDynamicLength : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::InitialHeap initialHeap_;\
  explicit MNewArrayDynamicLength(MDefinition* length, JSObject* templateObject, gc::InitialHeap initialHeap) : MUnaryInstruction(classOpcode, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::InitialHeap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewArrayDynamicLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, length))\
  AliasSet getAliasSet() const override;\
};\
\
class MNewTypedArrayDynamicLength : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::InitialHeap initialHeap_;\
  explicit MNewTypedArrayDynamicLength(MDefinition* length, JSObject* templateObject, gc::InitialHeap initialHeap) : MUnaryInstruction(classOpcode, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::InitialHeap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayDynamicLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, length))\
  AliasSet getAliasSet() const override;\
};\
\
class MNewTypedArrayFromArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::InitialHeap initialHeap_;\
  explicit MNewTypedArrayFromArray(MDefinition* array, JSObject* templateObject, gc::InitialHeap initialHeap) : MUnaryInstruction(classOpcode, array), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::InitialHeap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayFromArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewTypedArrayFromArrayBuffer : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  CompilerGCPointer<JSObject*> templateObject_;\
  gc::InitialHeap initialHeap_;\
  explicit MNewTypedArrayFromArrayBuffer(MDefinition* arrayBuffer, MDefinition* byteOffset, MDefinition* length, JSObject* templateObject, gc::InitialHeap initialHeap) : MTernaryInstruction(classOpcode, arrayBuffer, byteOffset, length), templateObject_(templateObject), initialHeap_(initialHeap) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObject() const { return templateObject_; }\
  gc::InitialHeap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(NewTypedArrayFromArrayBuffer)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, arrayBuffer), (1, byteOffset), (2, length))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMutateProto : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMutateProto(MDefinition* object, MDefinition* value) : MBinaryInstruction(classOpcode, object, value) {\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(MutateProto)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MInitPropGetterSetter : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MInitPropGetterSetter(MDefinition* object, MDefinition* value, PropertyName* name) : MBinaryInstruction(classOpcode, object, value), name_(name) {\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(InitPropGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
};\
\
class MInitElemGetterSetter : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, ObjectPolicy<2>>::Data {\
  explicit MInitElemGetterSetter(MDefinition* object, MDefinition* id, MDefinition* value) : MTernaryInstruction(classOpcode, object, id, value) {\
  }\
 public:\
  INSTRUCTION_HEADER(InitElemGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, id), (2, value))\
};\
\
class MEncodeSnapshot : public MNullaryInstruction {\
  explicit MEncodeSnapshot() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(EncodeSnapshot)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MSameValueDouble : public MBinaryInstruction, public MixPolicy<DoublePolicy<0>, DoublePolicy<1>>::Data {\
  explicit MSameValueDouble(MDefinition* left, MDefinition* right) : MBinaryInstruction(classOpcode, left, right) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SameValueDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, left), (1, right))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSameValueDouble)\
};\
\
class MSameValue : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MSameValue(MDefinition* left, MDefinition* right) : MBinaryInstruction(classOpcode, left, right) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(SameValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, left), (1, right))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSameValue)\
};\
\
class MCreateThis : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MCreateThis(MDefinition* callee, MDefinition* newTarget) : MBinaryInstruction(classOpcode, callee, newTarget) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CreateThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, callee), (1, newTarget))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGetArgumentsObjectArg : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  size_t argno_;\
  explicit MGetArgumentsObjectArg(MDefinition* argsObject, size_t argno) : MUnaryInstruction(classOpcode, argsObject), argno_(argno) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  size_t argno() const { return argno_; }\
  INSTRUCTION_HEADER(GetArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MSetArgumentsObjectArg : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  size_t argno_;\
  explicit MSetArgumentsObjectArg(MDefinition* argsObject, MDefinition* value, size_t argno) : MBinaryInstruction(classOpcode, argsObject, value), argno_(argno) {\
  }\
 public:\
  size_t argno() const { return argno_; }\
  INSTRUCTION_HEADER(SetArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, value))\
  AliasSet getAliasSet() const override;\
};\
\
class MLoadArgumentsObjectArg : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MLoadArgumentsObjectArg(MDefinition* argsObject, MDefinition* index) : MBinaryInstruction(classOpcode, argsObject, index) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadArgumentsObjectArg)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArgumentsObjectLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArgumentsObjectLength(MDefinition* argsObject) : MUnaryInstruction(classOpcode, argsObject) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArgumentsObjectLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardArgumentsObjectFlags : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  uint32_t flags_;\
  explicit MGuardArgumentsObjectFlags(MDefinition* argsObject, uint32_t flags) : MUnaryInstruction(classOpcode, argsObject), flags_(flags) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint32_t flags() const { return flags_; }\
  INSTRUCTION_HEADER(GuardArgumentsObjectFlags)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, argsObject))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MReturnFromCtor : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MReturnFromCtor(MDefinition* value, MDefinition* object) : MBinaryInstruction(classOpcode, value, object) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ReturnFromCtor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmUnsignedToDouble : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmUnsignedToDouble(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmUnsignedToDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmBoxValue : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MWasmBoxValue(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setResultType(MIRType::RefOrNull);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmBoxValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MWasmAnyRefFromJSObject : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmAnyRefFromJSObject(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setResultType(MIRType::RefOrNull);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmAnyRefFromJSObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MToAsyncIter : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MToAsyncIter(MDefinition* iterator, MDefinition* nextMethod) : MBinaryInstruction(classOpcode, iterator, nextMethod) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ToAsyncIter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator), (1, nextMethod))\
};\
\
class MToPropertyKeyCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MToPropertyKeyCache(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ToPropertyKeyCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
};\
\
class MAtan2 : public MBinaryInstruction, public MixPolicy<DoublePolicy<0>, DoublePolicy<1>>::Data {\
  explicit MAtan2(MDefinition* y, MDefinition* x) : MBinaryInstruction(classOpcode, y, x) {\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(Atan2)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, y), (1, x))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MAtan2)\
};\
\
class MRandom : public MNullaryInstruction {\
  explicit MRandom() : MNullaryInstruction(classOpcode) {\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(Random)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override;\
  ALLOW_CLONE(MRandom)\
};\
\
class MCharCodeAt : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCharCodeAt(MDefinition* string, MDefinition* index) : MBinaryInstruction(classOpcode, string, index) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(CharCodeAt)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MCharCodeAt)\
};\
\
class MFromCharCode : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCharCode(MDefinition* code) : MUnaryInstruction(classOpcode, code) {\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCharCode)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, code))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MFromCharCode)\
};\
\
class MFromCodePoint : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MFromCodePoint(MDefinition* codePoint) : MUnaryInstruction(classOpcode, codePoint) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FromCodePoint)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, codePoint))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MFromCodePoint)\
};\
\
class MStringSplit : public MBinaryInstruction, public MixPolicy<StringPolicy<0>, StringPolicy<1>>::Data {\
  explicit MStringSplit(MDefinition* string, MDefinition* separator) : MBinaryInstruction(classOpcode, string, separator) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(StringSplit)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, separator))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MBoxNonStrictThis : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<JSObject*> globalThis_;\
  explicit MBoxNonStrictThis(MDefinition* def, JSObject* globalThis) : MUnaryInstruction(classOpcode, def), globalThis_(globalThis) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* globalThis() const { return globalThis_; }\
  INSTRUCTION_HEADER(BoxNonStrictThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MImplicitThis : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MImplicitThis(MDefinition* envChain, PropertyName* name) : MUnaryInstruction(classOpcode, envChain), name_(name) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(ImplicitThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envChain))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MArrowNewTarget : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrowNewTarget(MDefinition* callee) : MUnaryInstruction(classOpcode, callee) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrowNewTarget)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, callee))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MUnaryCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MUnaryCache(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(UnaryCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
};\
\
class MCheckOverRecursed : public MNullaryInstruction {\
  explicit MCheckOverRecursed() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(CheckOverRecursed)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MInterruptCheck : public MNullaryInstruction {\
  explicit MInterruptCheck() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(InterruptCheck)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MThrowRuntimeLexicalError : public MNullaryInstruction {\
  unsigned errorNumber_;\
  explicit MThrowRuntimeLexicalError(unsigned errorNumber) : MNullaryInstruction(classOpcode), errorNumber_(errorNumber) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  unsigned errorNumber() const { return errorNumber_; }\
  INSTRUCTION_HEADER(ThrowRuntimeLexicalError)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override;\
};\
\
class MGlobalDeclInstantiation : public MNullaryInstruction {\
  explicit MGlobalDeclInstantiation() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(GlobalDeclInstantiation)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MRegExp : public MNullaryInstruction {\
  CompilerGCPointer<RegExpObject*> source_;\
  bool hasShared_;\
  explicit MRegExp(RegExpObject* source, bool hasShared) : MNullaryInstruction(classOpcode), source_(source), hasShared_(hasShared) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  RegExpObject* source() const { return source_; }\
  bool hasShared() const { return hasShared_; }\
  INSTRUCTION_HEADER(RegExp)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MRegExpMatcher : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MRegExpMatcher(MDefinition* regexp, MDefinition* string, MDefinition* lastIndex) : MTernaryInstruction(classOpcode, regexp, string, lastIndex) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpMatcher)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string), (2, lastIndex))\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MRegExpSearcher : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MRegExpSearcher(MDefinition* regexp, MDefinition* string, MDefinition* lastIndex) : MTernaryInstruction(classOpcode, regexp, string, lastIndex) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpSearcher)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string), (2, lastIndex))\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MRegExpTester : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MRegExpTester(MDefinition* regexp, MDefinition* string, MDefinition* lastIndex) : MTernaryInstruction(classOpcode, regexp, string, lastIndex) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpTester)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, regexp), (1, string), (2, lastIndex))\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MRegExpPrototypeOptimizable : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MRegExpPrototypeOptimizable(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpPrototypeOptimizable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MRegExpInstanceOptimizable : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MRegExpInstanceOptimizable(MDefinition* object, MDefinition* proto) : MBinaryInstruction(classOpcode, object, proto) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(RegExpInstanceOptimizable)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, proto))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MSubstr : public MTernaryInstruction, public MixPolicy<StringPolicy<0>, UnboxedInt32Policy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MSubstr(MDefinition* string, MDefinition* begin, MDefinition* length) : MTernaryInstruction(classOpcode, string, begin, length) {\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(Substr)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string), (1, begin), (2, length))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MModuleMetadata : public MNullaryInstruction {\
  CompilerGCPointer<JSObject*> module_;\
  explicit MModuleMetadata(JSObject* module) : MNullaryInstruction(classOpcode), module_(module) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* module() const { return module_; }\
  INSTRUCTION_HEADER(ModuleMetadata)\
  TRIVIAL_NEW_WRAPPERS\
};\
\
class MDynamicImport : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MDynamicImport(MDefinition* specifier) : MUnaryInstruction(classOpcode, specifier) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(DynamicImport)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, specifier))\
};\
\
class MSetFunName : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  uint8_t prefixKind_;\
  explicit MSetFunName(MDefinition* fun, MDefinition* name, uint8_t prefixKind) : MBinaryInstruction(classOpcode, fun, name), prefixKind_(prefixKind) {\
    setResultType(MIRType::None);\
  }\
 public:\
  uint8_t prefixKind() const { return prefixKind_; }\
  INSTRUCTION_HEADER(SetFunName)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, fun), (1, name))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSlots : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MSlots(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Slots);\
  }\
 public:\
  INSTRUCTION_HEADER(Slots)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MSlots)\
};\
\
class MElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Elements);\
  }\
 public:\
  INSTRUCTION_HEADER(Elements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MElements)\
};\
\
class MInitializedLength : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MInitializedLength(MDefinition* elements) : MUnaryInstruction(classOpcode, elements) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(InitializedLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MInitializedLength)\
};\
\
class MSetInitializedLength : public MBinaryInstruction, public NoTypePolicy::Data {\
  explicit MSetInitializedLength(MDefinition* elements, MDefinition* index) : MBinaryInstruction(classOpcode, elements, index) {\
  }\
 public:\
  INSTRUCTION_HEADER(SetInitializedLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements), (1, index))\
  AliasSet getAliasSet() const override;\
  ALLOW_CLONE(MSetInitializedLength)\
};\
\
class MArrayLength : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MArrayLength(MDefinition* elements) : MUnaryInstruction(classOpcode, elements) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MArrayLength)\
};\
\
class MSetArrayLength : public MBinaryInstruction, public NoTypePolicy::Data {\
  explicit MSetArrayLength(MDefinition* elements, MDefinition* index) : MBinaryInstruction(classOpcode, elements, index) {\
  }\
 public:\
  INSTRUCTION_HEADER(SetArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, elements), (1, index))\
  AliasSet getAliasSet() const override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override;\
};\
\
class MFunctionLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionLength(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MFunctionName : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionName(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionName)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayBufferByteLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferByteLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferByteLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MArrayBufferViewLength : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewLength(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MArrayBufferViewByteOffset : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewByteOffset(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::IntPtr);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewByteOffset)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MArrayBufferViewElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MArrayBufferViewElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Elements);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayBufferViewElements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  ALLOW_CLONE(MArrayBufferViewElements)\
};\
\
class MTypedArrayElementSize : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MTypedArrayElementSize(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(TypedArrayElementSize)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
};\
\
class MGuardHasAttachedArrayBuffer : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardHasAttachedArrayBuffer(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardHasAttachedArrayBuffer)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MKeepAliveObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MKeepAliveObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setResultType(MIRType::None);\
  }\
 public:\
  INSTRUCTION_HEADER(KeepAliveObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
};\
\
class MArrayPush : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MArrayPush(MDefinition* object, MDefinition* value) : MBinaryInstruction(classOpcode, object, value) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayPush)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  AliasSet getAliasSet() const override;\
  void computeRange(TempAllocator& alloc) override;\
  ALLOW_CLONE(MArrayPush)\
};\
\
class MArraySlice : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, UnboxedInt32Policy<2>>::Data {\
  CompilerGCPointer<JSObject*> templateObj_;\
  gc::InitialHeap initialHeap_;\
  explicit MArraySlice(MDefinition* object, MDefinition* begin, MDefinition* end, JSObject* templateObj, gc::InitialHeap initialHeap) : MTernaryInstruction(classOpcode, object, begin, end), templateObj_(templateObj), initialHeap_(initialHeap) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  JSObject* templateObj() const { return templateObj_; }\
  gc::InitialHeap initialHeap() const { return initialHeap_; }\
  INSTRUCTION_HEADER(ArraySlice)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, begin), (2, end))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MArrayJoin : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, StringPolicy<1>>::Data {\
  explicit MArrayJoin(MDefinition* array, MDefinition* sep) : MBinaryInstruction(classOpcode, array, sep) {\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(ArrayJoin)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array), (1, sep))\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MHomeObjectSuperBase : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MHomeObjectSuperBase(MDefinition* homeObject) : MUnaryInstruction(classOpcode, homeObject) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(HomeObjectSuperBase)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, homeObject))\
  AliasSet getAliasSet() const override;\
};\
\
class MBindNameCache : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MBindNameCache(MDefinition* envChain) : MUnaryInstruction(classOpcode, envChain) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(BindNameCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envChain))\
};\
\
class MCallBindVar : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MCallBindVar(MDefinition* environmentChain) : MUnaryInstruction(classOpcode, environmentChain) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(CallBindVar)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, environmentChain))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardShape : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MGuardShape(MDefinition* object, Shape* shape) : MUnaryInstruction(classOpcode, object), shape_(shape) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(GuardShape)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardIsNativeObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNativeObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNativeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsProxy(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNotDOMProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotDOMProxy(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotDOMProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsNotProxy : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotProxy(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotProxy)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MProxyGet : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  jsid id_;\
  explicit MProxyGet(MDefinition* proxy, jsid id) : MUnaryInstruction(classOpcode, proxy), id_(id) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  jsid id() const { return id_; }\
  INSTRUCTION_HEADER(ProxyGet)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxyGetByValue : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MProxyGetByValue(MDefinition* proxy, MDefinition* idVal) : MBinaryInstruction(classOpcode, proxy, idVal) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(ProxyGetByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxyHasProp : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool hasOwn_;\
  explicit MProxyHasProp(MDefinition* proxy, MDefinition* idVal, bool hasOwn) : MBinaryInstruction(classOpcode, proxy, idVal), hasOwn_(hasOwn) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool hasOwn() const { return hasOwn_; }\
  INSTRUCTION_HEADER(ProxyHasProp)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxySet : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  jsid id_;\
  bool strict_;\
  explicit MProxySet(MDefinition* proxy, MDefinition* rhs, jsid id, bool strict) : MBinaryInstruction(classOpcode, proxy, rhs), id_(id), strict_(strict) {\
  }\
 public:\
  jsid id() const { return id_; }\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(ProxySet)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MProxySetByValue : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>, BoxPolicy<2>>::Data {\
  bool strict_;\
  explicit MProxySetByValue(MDefinition* proxy, MDefinition* idVal, MDefinition* rhs, bool strict) : MTernaryInstruction(classOpcode, proxy, idVal, rhs), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(ProxySetByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy), (1, idVal), (2, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallSetArrayLength : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool strict_;\
  explicit MCallSetArrayLength(MDefinition* obj, MDefinition* rhs, bool strict) : MBinaryInstruction(classOpcode, obj, rhs), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(CallSetArrayLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, obj), (1, rhs))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicLoadSlot : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MMegamorphicLoadSlot(MDefinition* object, PropertyName* name) : MUnaryInstruction(classOpcode, object), name_(name) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(MegamorphicLoadSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicLoadSlotByValue : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MMegamorphicLoadSlotByValue(MDefinition* object, MDefinition* idVal) : MBinaryInstruction(classOpcode, object, idVal) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(MegamorphicLoadSlotByValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, idVal))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicStoreSlot : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MMegamorphicStoreSlot(MDefinition* object, MDefinition* rhs, PropertyName* name) : MBinaryInstruction(classOpcode, object, rhs), name_(name) {\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(MegamorphicStoreSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, rhs))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MMegamorphicHasProp : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  bool hasOwn_;\
  explicit MMegamorphicHasProp(MDefinition* object, MDefinition* idVal, bool hasOwn) : MBinaryInstruction(classOpcode, object, idVal), hasOwn_(hasOwn) {\
    setGuard();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool hasOwn() const { return hasOwn_; }\
  INSTRUCTION_HEADER(MegamorphicHasProp)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, idVal))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGuardIsNotArrayBufferMaybeShared : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsNotArrayBufferMaybeShared(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsNotArrayBufferMaybeShared)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIsTypedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsTypedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsTypedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNurseryObject : public MNullaryInstruction {\
  uint32_t nurseryIndex_;\
  explicit MNurseryObject(uint32_t nurseryIndex) : MNullaryInstruction(classOpcode), nurseryIndex_(nurseryIndex) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint32_t nurseryIndex() const { return nurseryIndex_; }\
  INSTRUCTION_HEADER(NurseryObject)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardNullOrUndefined : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGuardNullOrUndefined(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardNullOrUndefined)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardFunctionIsNonBuiltinCtor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardFunctionIsNonBuiltinCtor(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardFunctionIsNonBuiltinCtor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardFunctionKind : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  FunctionFlags::FunctionKind expected_;\
  bool bailOnEquality_;\
  explicit MGuardFunctionKind(MDefinition* function, FunctionFlags::FunctionKind expected, bool bailOnEquality) : MUnaryInstruction(classOpcode, function), expected_(expected), bailOnEquality_(bailOnEquality) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  FunctionFlags::FunctionKind expected() const { return expected_; }\
  bool bailOnEquality() const { return bailOnEquality_; }\
  INSTRUCTION_HEADER(GuardFunctionKind)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardFunctionScript : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<BaseScript*> expected_;\
  uint16_t nargs_;\
  FunctionFlags flags_;\
  explicit MGuardFunctionScript(MDefinition* function, BaseScript* expected, uint16_t nargs, FunctionFlags flags) : MUnaryInstruction(classOpcode, function), expected_(expected), nargs_(nargs), flags_(flags) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  BaseScript* expected() const { return expected_; }\
  uint16_t nargs() const { return nargs_; }\
  FunctionFlags flags() const { return flags_; }\
  INSTRUCTION_HEADER(GuardFunctionScript)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardSpecificAtom : public MUnaryInstruction, public StringPolicy<0>::Data {\
  CompilerGCPointer<JSAtom*> atom_;\
  explicit MGuardSpecificAtom(MDefinition* str, JSAtom* atom) : MUnaryInstruction(classOpcode, str), atom_(atom) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  JSAtom* atom() const { return atom_; }\
  INSTRUCTION_HEADER(GuardSpecificAtom)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, str))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MGuardStringToIndex : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToIndex(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToIndex)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardStringToInt32 : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToInt32(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToInt32)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardStringToDouble : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MGuardStringToDouble(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Double);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardStringToDouble)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardNoDenseElements : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardNoDenseElements(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardNoDenseElements)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
};\
\
class MFunctionEnvironment : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MFunctionEnvironment(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(FunctionEnvironment)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MNewClassBodyEnvironmentObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  CompilerGCPointer<ClassBodyScope*> scope_;\
  explicit MNewClassBodyEnvironmentObject(MDefinition* enclosing, ClassBodyScope* scope) : MUnaryInstruction(classOpcode, enclosing), scope_(scope) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  ClassBodyScope* scope() const { return scope_; }\
  INSTRUCTION_HEADER(NewClassBodyEnvironmentObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, enclosing))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCopyLexicalEnvironmentObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  bool copySlots_;\
  explicit MCopyLexicalEnvironmentObject(MDefinition* env, bool copySlots) : MUnaryInstruction(classOpcode, env), copySlots_(copySlots) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  bool copySlots() const { return copySlots_; }\
  INSTRUCTION_HEADER(CopyLexicalEnvironmentObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, env))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MHomeObject : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MHomeObject(MDefinition* function) : MUnaryInstruction(classOpcode, function) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(HomeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MAllocateAndStoreSlot : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  uint32_t slotOffset_;\
  CompilerGCPointer<Shape*> shape_;\
  uint32_t numNewSlots_;\
  explicit MAllocateAndStoreSlot(MDefinition* object, MDefinition* value, uint32_t slotOffset, Shape* shape, uint32_t numNewSlots) : MBinaryInstruction(classOpcode, object, value), slotOffset_(slotOffset), shape_(shape), numNewSlots_(numNewSlots) {\
  }\
 public:\
  uint32_t slotOffset() const { return slotOffset_; }\
  Shape* shape() const { return shape_; }\
  uint32_t numNewSlots() const { return numNewSlots_; }\
  INSTRUCTION_HEADER(AllocateAndStoreSlot)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, value))\
  AliasSet getAliasSet() const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGetNameCache : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGetNameCache(MDefinition* envObj) : MUnaryInstruction(classOpcode, envObj) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetNameCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, envObj))\
};\
\
class MCallGetIntrinsicValue : public MNullaryInstruction {\
  CompilerGCPointer<PropertyName*> name_;\
  explicit MCallGetIntrinsicValue(PropertyName* name) : MNullaryInstruction(classOpcode), name_(name) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  INSTRUCTION_HEADER(CallGetIntrinsicValue)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MDeleteProperty : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<PropertyName*> name_;\
  bool strict_;\
  explicit MDeleteProperty(MDefinition* value, PropertyName* name, bool strict) : MUnaryInstruction(classOpcode, value), name_(name), strict_(strict) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  PropertyName* name() const { return name_; }\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(DeleteProperty)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MDeleteElement : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  bool strict_;\
  explicit MDeleteElement(MDefinition* value, MDefinition* index, bool strict) : MBinaryInstruction(classOpcode, value, index), strict_(strict) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(DeleteElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, index))\
};\
\
class MLoadDOMExpandoValue : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadDOMExpandoValue(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadDOMExpandoValue)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLoadDOMExpandoValueIgnoreGeneration : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadDOMExpandoValueIgnoreGeneration(MDefinition* proxy) : MUnaryInstruction(classOpcode, proxy) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadDOMExpandoValueIgnoreGeneration)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, proxy))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardDOMExpandoMissingOrGuardShape : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  CompilerGCPointer<Shape*> shape_;\
  explicit MGuardDOMExpandoMissingOrGuardShape(MDefinition* expando, Shape* shape) : MUnaryInstruction(classOpcode, expando), shape_(shape) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(GuardDOMExpandoMissingOrGuardShape)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, expando))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
};\
\
class MStringLength : public MUnaryInstruction, public StringPolicy<0>::Data {\
  explicit MStringLength(MDefinition* string) : MUnaryInstruction(classOpcode, string) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(StringLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, string))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MStringLength)\
};\
\
class MOptimizeSpreadCallCache : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MOptimizeSpreadCallCache(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(OptimizeSpreadCallCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MIteratorMore : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIteratorMore(MDefinition* iterator) : MUnaryInstruction(classOpcode, iterator) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(IteratorMore)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator))\
};\
\
class MIsNoIter : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MIsNoIter(MDefinition* def) : MUnaryInstruction(classOpcode, def) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsNoIter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, def))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MIteratorEnd : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIteratorEnd(MDefinition* iterator) : MUnaryInstruction(classOpcode, iterator) {\
  }\
 public:\
  INSTRUCTION_HEADER(IteratorEnd)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, iterator))\
};\
\
class MInstanceOfCache : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MInstanceOfCache(MDefinition* obj, MDefinition* proto) : MBinaryInstruction(classOpcode, obj, proto) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(InstanceOfCache)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, obj), (1, proto))\
};\
\
class MArgumentsLength : public MNullaryInstruction {\
  explicit MArgumentsLength() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(ArgumentsLength)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  void computeRange(TempAllocator& alloc) override;\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
};\
\
class MGetFrameArgument : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MGetFrameArgument(MDefinition* index) : MUnaryInstruction(classOpcode, index) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetFrameArgument)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MNewTarget : public MNullaryInstruction {\
  explicit MNewTarget() : MNullaryInstruction(classOpcode) {\
    setMovable();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(NewTarget)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MRest : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  unsigned numFormals_;\
  CompilerGCPointer<Shape*> shape_;\
  explicit MRest(MDefinition* numActuals, unsigned numFormals, Shape* shape) : MUnaryInstruction(classOpcode, numActuals), numFormals_(numFormals), shape_(shape) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  unsigned numFormals() const { return numFormals_; }\
  Shape* shape() const { return shape_; }\
  INSTRUCTION_HEADER(Rest)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, numActuals))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MNewNamedLambdaObject : public MNullaryInstruction {\
  CompilerGCPointer<NamedLambdaObject*> templateObj_;\
  explicit MNewNamedLambdaObject(NamedLambdaObject* templateObj) : MNullaryInstruction(classOpcode), templateObj_(templateObj) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  NamedLambdaObject* templateObj() const { return templateObj_; }\
  INSTRUCTION_HEADER(NewNamedLambdaObject)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MIsConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsCrossRealmArrayConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsCrossRealmArrayConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsCrossRealmArrayConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsObject : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MIsObject(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MIsNullOrUndefined : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MIsNullOrUndefined(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsNullOrUndefined)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MObjectClassToString : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MObjectClassToString(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::String);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectClassToString)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCheckReturn : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MCheckReturn(MDefinition* returnValue, MDefinition* thisValue) : MBinaryInstruction(classOpcode, returnValue, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckReturn)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, returnValue), (1, thisValue))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MCheckThis : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckThis(MDefinition* thisValue) : MUnaryInstruction(classOpcode, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckThis)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, thisValue))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MAsyncResolve : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  AsyncFunctionResolveKind resolveKind_;\
  explicit MAsyncResolve(MDefinition* generator, MDefinition* valueOrReason, AsyncFunctionResolveKind resolveKind) : MBinaryInstruction(classOpcode, generator, valueOrReason), resolveKind_(resolveKind) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  AsyncFunctionResolveKind resolveKind() const { return resolveKind_; }\
  INSTRUCTION_HEADER(AsyncResolve)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, generator), (1, valueOrReason))\
};\
\
class MGeneratorReturn : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MGeneratorReturn(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(GeneratorReturn)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MAsyncAwait : public MBinaryInstruction, public MixPolicy<BoxPolicy<0>, ObjectPolicy<1>>::Data {\
  explicit MAsyncAwait(MDefinition* value, MDefinition* generator) : MBinaryInstruction(classOpcode, value, generator) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(AsyncAwait)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value), (1, generator))\
};\
\
class MCheckThisReinit : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckThisReinit(MDefinition* thisValue) : MUnaryInstruction(classOpcode, thisValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckThisReinit)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, thisValue))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCanSkipAwait : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCanSkipAwait(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(CanSkipAwait)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
};\
\
class MIncrementWarmUpCounter : public MNullaryInstruction {\
  CompilerGCPointer<JSScript*> script_;\
  explicit MIncrementWarmUpCounter(JSScript* script) : MNullaryInstruction(classOpcode), script_(script) {\
  }\
 public:\
  JSScript* script() const { return script_; }\
  INSTRUCTION_HEADER(IncrementWarmUpCounter)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MCheckIsObj : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  uint8_t checkKind_;\
  explicit MCheckIsObj(MDefinition* value, uint8_t checkKind) : MUnaryInstruction(classOpcode, value), checkKind_(checkKind) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  uint8_t checkKind() const { return checkKind_; }\
  INSTRUCTION_HEADER(CheckIsObj)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCheckObjCoercible : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckObjCoercible(MDefinition* checkValue) : MUnaryInstruction(classOpcode, checkValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckObjCoercible)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, checkValue))\
  AliasSet getAliasSet() const override;\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
};\
\
class MCheckClassHeritage : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MCheckClassHeritage(MDefinition* heritage) : MUnaryInstruction(classOpcode, heritage) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CheckClassHeritage)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, heritage))\
};\
\
class MDebugCheckSelfHosted : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MDebugCheckSelfHosted(MDefinition* checkValue) : MUnaryInstruction(classOpcode, checkValue) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(DebugCheckSelfHosted)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, checkValue))\
};\
\
class MFinishBoundFunctionInit : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, ObjectPolicy<1>, UnboxedInt32Policy<2>>::Data {\
  explicit MFinishBoundFunctionInit(MDefinition* bound, MDefinition* target, MDefinition* argCount) : MTernaryInstruction(classOpcode, bound, target, argCount) {\
  }\
 public:\
  INSTRUCTION_HEADER(FinishBoundFunctionInit)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, bound), (1, target), (2, argCount))\
};\
\
class MIsPackedArray : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsPackedArray(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsPackedArray)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
};\
\
class MGuardArrayIsPacked : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardArrayIsPacked(MDefinition* array) : MUnaryInstruction(classOpcode, array) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardArrayIsPacked)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, array))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGetPrototypeOf : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGetPrototypeOf(MDefinition* target) : MUnaryInstruction(classOpcode, target) {\
    setGuard();\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(GetPrototypeOf)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, target))\
};\
\
class MObjectWithProto : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MObjectWithProto(MDefinition* prototype) : MUnaryInstruction(classOpcode, prototype) {\
    setGuard();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(ObjectWithProto)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, prototype))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MBuiltinObject : public MNullaryInstruction {\
  BuiltinObjectKind builtinObjectKind_;\
  explicit MBuiltinObject(BuiltinObjectKind builtinObjectKind) : MNullaryInstruction(classOpcode), builtinObjectKind_(builtinObjectKind) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  BuiltinObjectKind builtinObjectKind() const { return builtinObjectKind_; }\
  INSTRUCTION_HEADER(BuiltinObject)\
  TRIVIAL_NEW_WRAPPERS\
  bool possiblyCalls() const override { return true; }\
};\
\
class MSuperFunction : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MSuperFunction(MDefinition* callee) : MUnaryInstruction(classOpcode, callee) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(SuperFunction)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, callee))\
  AliasSet getAliasSet() const override;\
};\
\
class MInitHomeObject : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, BoxPolicy<1>>::Data {\
  explicit MInitHomeObject(MDefinition* function, MDefinition* homeObject) : MBinaryInstruction(classOpcode, function, homeObject) {\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(InitHomeObject)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, function), (1, homeObject))\
  AliasSet getAliasSet() const override;\
};\
\
class MIsTypedArrayConstructor : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MIsTypedArrayConstructor(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(IsTypedArrayConstructor)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MLoadValueTag : public MUnaryInstruction, public BoxPolicy<0>::Data {\
  explicit MLoadValueTag(MDefinition* value) : MUnaryInstruction(classOpcode, value) {\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadValueTag)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, value))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MLoadWrapperTarget : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MLoadWrapperTarget(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(LoadWrapperTarget)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardHasGetterSetter : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  jsid propId_;\
  CompilerGCPointer<GetterSetter*> getterSetter_;\
  explicit MGuardHasGetterSetter(MDefinition* object, jsid propId, GetterSetter* getterSetter) : MUnaryInstruction(classOpcode, object), propId_(propId), getterSetter_(getterSetter) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  jsid propId() const { return propId_; }\
  GetterSetter* getterSetter() const { return getterSetter_; }\
  INSTRUCTION_HEADER(GuardHasGetterSetter)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override;\
  bool possiblyCalls() const override { return true; }\
};\
\
class MGuardIsExtensible : public MUnaryInstruction, public ObjectPolicy<0>::Data {\
  explicit MGuardIsExtensible(MDefinition* object) : MUnaryInstruction(classOpcode, object) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Object);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIsExtensible)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardInt32IsNonNegative : public MUnaryInstruction, public UnboxedInt32Policy<0>::Data {\
  explicit MGuardInt32IsNonNegative(MDefinition* index) : MUnaryInstruction(classOpcode, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardInt32IsNonNegative)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, index))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  MDefinition* foldsTo(TempAllocator& alloc) override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIndexGreaterThanDenseInitLength : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MGuardIndexGreaterThanDenseInitLength(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIndexGreaterThanDenseInitLength)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MGuardIndexIsValidUpdateOrAdd : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MGuardIndexIsValidUpdateOrAdd(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setMovable();\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(GuardIndexIsValidUpdateOrAdd)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
};\
\
class MCallAddOrUpdateSparseElement : public MTernaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>, BoxPolicy<2>>::Data {\
  bool strict_;\
  explicit MCallAddOrUpdateSparseElement(MDefinition* object, MDefinition* index, MDefinition* value, bool strict) : MTernaryInstruction(classOpcode, object, index, value), strict_(strict) {\
  }\
 public:\
  bool strict() const { return strict_; }\
  INSTRUCTION_HEADER(CallAddOrUpdateSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index), (2, value))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallGetSparseElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallGetSparseElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CallGetSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallNativeGetElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallNativeGetElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setResultType(MIRType::Value);\
  }\
 public:\
  INSTRUCTION_HEADER(CallNativeGetElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  bool possiblyCalls() const override { return true; }\
};\
\
class MCallObjectHasSparseElement : public MBinaryInstruction, public MixPolicy<ObjectPolicy<0>, UnboxedInt32Policy<1>>::Data {\
  explicit MCallObjectHasSparseElement(MDefinition* object, MDefinition* index) : MBinaryInstruction(classOpcode, object, index) {\
    setGuard();\
    setResultType(MIRType::Boolean);\
  }\
 public:\
  INSTRUCTION_HEADER(CallObjectHasSparseElement)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, object), (1, index))\
  AliasSet getAliasSet() const override;\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
};\
\
class MBigIntAsIntN : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, BigIntPolicy<1>>::Data {\
  explicit MBigIntAsIntN(MDefinition* bits, MDefinition* input) : MBinaryInstruction(classOpcode, bits, input) {\
    setMovable();\
    setResultType(MIRType::BigInt);\
  }\
 public:\
  INSTRUCTION_HEADER(BigIntAsIntN)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, bits), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MBigIntAsIntN)\
};\
\
class MBigIntAsUintN : public MBinaryInstruction, public MixPolicy<UnboxedInt32Policy<0>, BigIntPolicy<1>>::Data {\
  explicit MBigIntAsUintN(MDefinition* bits, MDefinition* input) : MBinaryInstruction(classOpcode, bits, input) {\
    setMovable();\
    setResultType(MIRType::BigInt);\
  }\
 public:\
  INSTRUCTION_HEADER(BigIntAsUintN)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, bits), (1, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override { return congruentIfOperandsEqual(ins); }\
  bool possiblyCalls() const override { return true; }\
  [[nodiscard]] bool writeRecoverData(\
    CompactBufferWriter& writer) const override;\
  bool canRecoverOnBailout() const override { return true; }\
  ALLOW_CLONE(MBigIntAsUintN)\
};\
\
class MWasmExtendU32Index : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmExtendU32Index(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Int64);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmExtendU32Index)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MWasmWrapU32Index : public MUnaryInstruction, public NoTypePolicy::Data {\
  explicit MWasmWrapU32Index(MDefinition* input) : MUnaryInstruction(classOpcode, input) {\
    setResultType(MIRType::Int32);\
  }\
 public:\
  INSTRUCTION_HEADER(WasmWrapU32Index)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, input))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
};\
\
class MWasmFence : public MNullaryInstruction {\
  explicit MWasmFence() : MNullaryInstruction(classOpcode) {\
    setGuard();\
  }\
 public:\
  INSTRUCTION_HEADER(WasmFence)\
  TRIVIAL_NEW_WRAPPERS\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  ALLOW_CLONE(MWasmFence)\
};\
\
class MWasmShiftSimd128 : public MBinaryInstruction, public NoTypePolicy::Data {\
  wasm::SimdOp simdOp_;\
  explicit MWasmShiftSimd128(MDefinition* lhs, MDefinition* rhs, wasm::SimdOp simdOp) : MBinaryInstruction(classOpcode, lhs, rhs), simdOp_(simdOp) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  wasm::SimdOp simdOp() const { return simdOp_; }\
  INSTRUCTION_HEADER(WasmShiftSimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, lhs), (1, rhs))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmShiftSimd128)\
};\
\
class MWasmShuffleSimd128 : public MBinaryInstruction, public NoTypePolicy::Data {\
  SimdConstant control_;\
  explicit MWasmShuffleSimd128(MDefinition* lhs, MDefinition* rhs, SimdConstant control) : MBinaryInstruction(classOpcode, lhs, rhs), control_(control) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  SimdConstant control() const { return control_; }\
  INSTRUCTION_HEADER(WasmShuffleSimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, lhs), (1, rhs))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmShuffleSimd128)\
};\
\
class MWasmUnarySimd128 : public MUnaryInstruction, public NoTypePolicy::Data {\
  wasm::SimdOp simdOp_;\
  explicit MWasmUnarySimd128(MDefinition* src, wasm::SimdOp simdOp) : MUnaryInstruction(classOpcode, src), simdOp_(simdOp) {\
    setMovable();\
    setResultType(MIRType::Simd128);\
  }\
 public:\
  wasm::SimdOp simdOp() const { return simdOp_; }\
  INSTRUCTION_HEADER(WasmUnarySimd128)\
  TRIVIAL_NEW_WRAPPERS\
  NAMED_OPERANDS((0, src))\
  AliasSet getAliasSet() const override { return AliasSet::None(); }\
  bool congruentTo(const MDefinition* ins) const override;\
  ALLOW_CLONE(MWasmUnarySimd128)\
};\


#define NON_GC_POINTER_TYPE_ASSERTIONS_GENERATED \
static_assert(!std::is_base_of_v<gc::Cell, AsyncFunctionResolveKind>, "Ensure that AsyncFunctionResolveKind is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, BuiltinObjectKind>, "Ensure that BuiltinObjectKind is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, FunctionFlags>, "Ensure that FunctionFlags is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, FunctionFlags::FunctionKind>, "Ensure that FunctionFlags::FunctionKind is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, SimdConstant>, "Ensure that SimdConstant is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, bool>, "Ensure that bool is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, gc::InitialHeap>, "Ensure that gc::InitialHeap is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, jsid>, "Ensure that jsid is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, size_t>, "Ensure that size_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint16_t>, "Ensure that uint16_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint32_t>, "Ensure that uint32_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, uint8_t>, "Ensure that uint8_t is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, unsigned>, "Ensure that unsigned is added to the gc_pointer_types list in GenerateMIRFiles.py.");\
static_assert(!std::is_base_of_v<gc::Cell, wasm::SimdOp>, "Ensure that wasm::SimdOp is added to the gc_pointer_types list in GenerateMIRFiles.py.");



#endif // jit_MIROpsGenerated_h
