/*
**  Copyright (c) 2005, 2007, 2008 Sendmail, Inc. and its suppliers.
**    All rights reserved.
**
**  Copyright (c) 2009-2012, The Trusted Domain Project.  All rights reserved.
*/

#ifndef _UTIL_H_
#define _UTIL_H_

#include "build-config.h"

/* system includes */
#include <sys/types.h>
#include <sys/time.h>
#ifdef USE_UNBOUND
# include <sys/select.h>
#endif /* USE_UNBOUND */
#ifdef HAVE_STDBOOL_H
# include <stdbool.h>
#endif /* HAVE_STDBOOL_H */

/* prototypes */
extern int dkim_addrcmp(char *, char *);
extern int dkim_check_dns_reply(unsigned char *ansbuf, size_t anslen,
                                     int xclass, int xtype);
extern void dkim_clobber_array(char **);
extern void dkim_collapse(char *);
extern char **dkim_copy_array(char **);
extern _Bool dkim_hdrlist(char *, size_t, char **, _Bool);
extern int dkim_hexchar(int c);
extern void dkim_lowerhdr(char *);
extern void dkim_min_timeval(struct timeval *, struct timeval *,
                                  struct timeval *, struct timeval **);
extern int dkim_qp_decode(const char *, char *, int);
extern int dkim_qp_encode(const char *, char *, int);

#ifdef NEED_FAST_STRTOUL
extern unsigned long dkim_strtoul(const char *str, char **endptr,
                                       int base);
extern unsigned long long dkim_strtoull(const char *str, char **endptr,
                                             int base);
#endif /* NEED_FAST_STRTOUL */

#endif /* ! _UTIL_H_ */
