/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.git;

import org.apiguardian.api.API;
import org.opentest4j.reporting.events.api.ChildElement;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.core.Infrastructure;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * The {@code repository} element of the Git namespace.
 *
 * @since 0.2.0
 */
@API(status = EXPERIMENTAL, since = "0.2.0")
public class Repository extends ChildElement<Infrastructure, Repository> {

	/**
	 * Qualified name of the {@code repository} element.
	 */
	public static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_GIT, "repository");

	private static final QualifiedName ORIGIN_URL = QualifiedName.of(Namespace.REPORTING_GIT, "originUrl");

	Repository(Context context) {
		super(context, ELEMENT);
	}

	/**
	 * Set the {@code originUrl} attribute of this element.
	 *
	 * @param originUrl the URL of the 'origin' remote
	 * @return this element
	 */
	public Repository withOriginUrl(String originUrl) {
		withAttribute(ORIGIN_URL, originUrl);
		return this;
	}
}
