/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.root;

import org.apiguardian.api.API;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.events.api.DocumentWriter;
import org.opentest4j.reporting.events.api.Element;
import org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

import java.nio.file.Path;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * The {@code events} element of the events namespace.
 *
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public class Events extends Element<Events> {

	/**
	 * Qualified name of the {@code events} element.
	 */
	public static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_EVENTS, "events");

	private Events(Context context) {
		super(context, ELEMENT);
	}

	/**
	 * Create a new {@link DocumentWriter} for the event-based reporting format.
	 *
	 * @param namespaceRegistry the namespace registry to use
	 * @param xmlFile           the file to write to
	 * @return the new {@link DocumentWriter}
	 * @throws Exception if an error initializing the XML writing infrastructure or writing to the XML file occurs
	 */
	public static DocumentWriter<Events> createDocumentWriter(NamespaceRegistry namespaceRegistry, Path xmlFile)
			throws Exception {
		return DocumentWriter.create(ELEMENT, namespaceRegistry, xmlFile);
	}

}
