/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.core.htmlreport;

import org.apiguardian.api.API;

import java.nio.file.Path;
import java.util.List;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * Writer of HTML reports for event-based and hierarchical XML report files.
 *
 * @since 0.2.0
 */
@API(status = EXPERIMENTAL, since = "0.2.0")
public interface HtmlReportWriter {

	/**
	 * Write an HTML report for the supplied XML files.
	 *
	 * <p>The supplied XML files may be in the event-based or hierarchical format.
	 *
	 * @param xmlFiles XML files in event-based or hierarchical format
	 * @param htmlFile the target HTML file
	 * @throws Exception if an error occurs during creation of the HTML report
	 */
	void writeHtmlReport(List<Path> xmlFiles, Path htmlFile) throws Exception;

}
