package support

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CommunicationDirection enumerates the values for communication direction.
type CommunicationDirection string

const (
	// Inbound ...
	Inbound CommunicationDirection = "inbound"
	// Outbound ...
	Outbound CommunicationDirection = "outbound"
)

// PossibleCommunicationDirectionValues returns an array of possible values for the CommunicationDirection const type.
func PossibleCommunicationDirectionValues() []CommunicationDirection {
	return []CommunicationDirection{Inbound, Outbound}
}

// CommunicationType enumerates the values for communication type.
type CommunicationType string

const (
	// Phone ...
	Phone CommunicationType = "phone"
	// Web ...
	Web CommunicationType = "web"
)

// PossibleCommunicationTypeValues returns an array of possible values for the CommunicationType const type.
func PossibleCommunicationTypeValues() []CommunicationType {
	return []CommunicationType{Phone, Web}
}

// PreferredContactMethod enumerates the values for preferred contact method.
type PreferredContactMethod string

const (
	// PreferredContactMethodEmail ...
	PreferredContactMethodEmail PreferredContactMethod = "email"
	// PreferredContactMethodPhone ...
	PreferredContactMethodPhone PreferredContactMethod = "phone"
)

// PossiblePreferredContactMethodValues returns an array of possible values for the PreferredContactMethod const type.
func PossiblePreferredContactMethodValues() []PreferredContactMethod {
	return []PreferredContactMethod{PreferredContactMethodEmail, PreferredContactMethodPhone}
}

// SeverityLevel enumerates the values for severity level.
type SeverityLevel string

const (
	// Critical ...
	Critical SeverityLevel = "critical"
	// Minimal ...
	Minimal SeverityLevel = "minimal"
	// Moderate ...
	Moderate SeverityLevel = "moderate"
)

// PossibleSeverityLevelValues returns an array of possible values for the SeverityLevel const type.
func PossibleSeverityLevelValues() []SeverityLevel {
	return []SeverityLevel{Critical, Minimal, Moderate}
}

// Type enumerates the values for type.
type Type string

const (
	// MicrosoftSupportcommunications ...
	MicrosoftSupportcommunications Type = "Microsoft.Support/communications"
	// MicrosoftSupportsupportTickets ...
	MicrosoftSupportsupportTickets Type = "Microsoft.Support/supportTickets"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{MicrosoftSupportcommunications, MicrosoftSupportsupportTickets}
}
