package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDtsJobs invokes the dts.StopDtsJobs API synchronously
func (client *Client) StopDtsJobs(request *StopDtsJobsRequest) (response *StopDtsJobsResponse, err error) {
	response = CreateStopDtsJobsResponse()
	err = client.DoAction(request, response)
	return
}

// StopDtsJobsWithChan invokes the dts.StopDtsJobs API asynchronously
func (client *Client) StopDtsJobsWithChan(request *StopDtsJobsRequest) (<-chan *StopDtsJobsResponse, <-chan error) {
	responseChan := make(chan *StopDtsJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDtsJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDtsJobsWithCallback invokes the dts.StopDtsJobs API asynchronously
func (client *Client) StopDtsJobsWithCallback(request *StopDtsJobsRequest, callback func(response *StopDtsJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDtsJobsResponse
		var err error
		defer close(result)
		response, err = client.StopDtsJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDtsJobsRequest is the request struct for api StopDtsJobs
type StopDtsJobsRequest struct {
	*requests.RpcRequest
	DtsJobIds string `position:"Query" name:"DtsJobIds"`
}

// StopDtsJobsResponse is the response struct for api StopDtsJobs
type StopDtsJobsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateStopDtsJobsRequest creates a request to invoke StopDtsJobs API
func CreateStopDtsJobsRequest() (request *StopDtsJobsRequest) {
	request = &StopDtsJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "StopDtsJobs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDtsJobsResponse creates a response to parse from StopDtsJobs response
func CreateStopDtsJobsResponse() (response *StopDtsJobsResponse) {
	response = &StopDtsJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
