package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataStreams invokes the elasticsearch.ListDataStreams API synchronously
func (client *Client) ListDataStreams(request *ListDataStreamsRequest) (response *ListDataStreamsResponse, err error) {
	response = CreateListDataStreamsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataStreamsWithChan invokes the elasticsearch.ListDataStreams API asynchronously
func (client *Client) ListDataStreamsWithChan(request *ListDataStreamsRequest) (<-chan *ListDataStreamsResponse, <-chan error) {
	responseChan := make(chan *ListDataStreamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataStreams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataStreamsWithCallback invokes the elasticsearch.ListDataStreams API asynchronously
func (client *Client) ListDataStreamsWithCallback(request *ListDataStreamsRequest, callback func(response *ListDataStreamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataStreamsResponse
		var err error
		defer close(result)
		response, err = client.ListDataStreams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataStreamsRequest is the request struct for api ListDataStreams
type ListDataStreamsRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"InstanceId"`
	IsManaged  requests.Boolean `position:"Query" name:"isManaged"`
	Name       string           `position:"Query" name:"name"`
}

// ListDataStreamsResponse is the response struct for api ListDataStreams
type ListDataStreamsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Headers   Headers      `json:"Headers" xml:"Headers"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListDataStreamsRequest creates a request to invoke ListDataStreams API
func CreateListDataStreamsRequest() (request *ListDataStreamsRequest) {
	request = &ListDataStreamsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDataStreams", "/openapi/instances/[InstanceId]/data-streams", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDataStreamsResponse creates a response to parse from ListDataStreams response
func CreateListDataStreamsResponse() (response *ListDataStreamsResponse) {
	response = &ListDataStreamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
