package geoip

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGeoipInstances invokes the geoip.DescribeGeoipInstances API synchronously
func (client *Client) DescribeGeoipInstances(request *DescribeGeoipInstancesRequest) (response *DescribeGeoipInstancesResponse, err error) {
	response = CreateDescribeGeoipInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGeoipInstancesWithChan invokes the geoip.DescribeGeoipInstances API asynchronously
func (client *Client) DescribeGeoipInstancesWithChan(request *DescribeGeoipInstancesRequest) (<-chan *DescribeGeoipInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeGeoipInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGeoipInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGeoipInstancesWithCallback invokes the geoip.DescribeGeoipInstances API asynchronously
func (client *Client) DescribeGeoipInstancesWithCallback(request *DescribeGeoipInstancesRequest, callback func(response *DescribeGeoipInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGeoipInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGeoipInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGeoipInstancesRequest is the request struct for api DescribeGeoipInstances
type DescribeGeoipInstancesRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGeoipInstancesResponse is the response struct for api DescribeGeoipInstances
type DescribeGeoipInstancesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	GeoipInstances GeoipInstances `json:"GeoipInstances" xml:"GeoipInstances"`
}

// CreateDescribeGeoipInstancesRequest creates a request to invoke DescribeGeoipInstances API
func CreateDescribeGeoipInstancesRequest() (request *DescribeGeoipInstancesRequest) {
	request = &DescribeGeoipInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("geoip", "2020-01-01", "DescribeGeoipInstances", "geoip", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGeoipInstancesResponse creates a response to parse from DescribeGeoipInstances response
func CreateDescribeGeoipInstancesResponse() (response *DescribeGeoipInstancesResponse) {
	response = &DescribeGeoipInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
