package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AlterTable invokes the openanalytics_open.AlterTable API synchronously
func (client *Client) AlterTable(request *AlterTableRequest) (response *AlterTableResponse, err error) {
	response = CreateAlterTableResponse()
	err = client.DoAction(request, response)
	return
}

// AlterTableWithChan invokes the openanalytics_open.AlterTable API asynchronously
func (client *Client) AlterTableWithChan(request *AlterTableRequest) (<-chan *AlterTableResponse, <-chan error) {
	responseChan := make(chan *AlterTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AlterTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AlterTableWithCallback invokes the openanalytics_open.AlterTable API asynchronously
func (client *Client) AlterTableWithCallback(request *AlterTableRequest, callback func(response *AlterTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AlterTableResponse
		var err error
		defer close(result)
		response, err = client.AlterTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AlterTableRequest is the request struct for api AlterTable
type AlterTableRequest struct {
	*requests.RpcRequest
	NewTableName string `position:"Query" name:"NewTableName"`
	Col          string `position:"Query" name:"Col"`
	OldTableName string `position:"Query" name:"OldTableName"`
	OldDbName    string `position:"Query" name:"OldDbName"`
	NewDbName    string `position:"Query" name:"NewDbName"`
	Parameters   string `position:"Query" name:"Parameters"`
}

// AlterTableResponse is the response struct for api AlterTable
type AlterTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAlterTableRequest creates a request to invoke AlterTable API
func CreateAlterTableRequest() (request *AlterTableRequest) {
	request = &AlterTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "AlterTable", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAlterTableResponse creates a response to parse from AlterTable response
func CreateAlterTableResponse() (response *AlterTableResponse) {
	response = &AlterTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
