package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindNodeLabel invokes the retailcloud.BindNodeLabel API synchronously
func (client *Client) BindNodeLabel(request *BindNodeLabelRequest) (response *BindNodeLabelResponse, err error) {
	response = CreateBindNodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// BindNodeLabelWithChan invokes the retailcloud.BindNodeLabel API asynchronously
func (client *Client) BindNodeLabelWithChan(request *BindNodeLabelRequest) (<-chan *BindNodeLabelResponse, <-chan error) {
	responseChan := make(chan *BindNodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindNodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindNodeLabelWithCallback invokes the retailcloud.BindNodeLabel API asynchronously
func (client *Client) BindNodeLabelWithCallback(request *BindNodeLabelRequest, callback func(response *BindNodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindNodeLabelResponse
		var err error
		defer close(result)
		response, err = client.BindNodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindNodeLabelRequest is the request struct for api BindNodeLabel
type BindNodeLabelRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	LabelKey   string `position:"Query" name:"LabelKey"`
	LabelValue string `position:"Query" name:"LabelValue"`
	ClusterId  string `position:"Query" name:"ClusterId"`
}

// BindNodeLabelResponse is the response struct for api BindNodeLabel
type BindNodeLabelResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBindNodeLabelRequest creates a request to invoke BindNodeLabel API
func CreateBindNodeLabelRequest() (request *BindNodeLabelRequest) {
	request = &BindNodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "BindNodeLabel", "", "")
	request.Method = requests.POST
	return
}

// CreateBindNodeLabelResponse creates a response to parse from BindNodeLabel response
func CreateBindNodeLabelResponse() (response *BindNodeLabelResponse) {
	response = &BindNodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
