/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascentInPoints;
    int descentInPoints;
    int indent;
    int wrapIndent;
    int wrapWidth;
    int[] segments;
    char[] segmentsChars;
    int[] tabs;
    StyleItem[] styles;
    int stylesCount;
    long layout;
    long context;
    long attrList;
    long selAttrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        super(device);
        device = this.device;
        this.context = GDK.gdk_pango_context_get();
        if (this.context == 0L) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, GTK.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_font_description(this.layout, device.systemFont.handle);
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        OS.pango_layout_set_auto_dir(this.layout, false);
        this.text = "";
        this.descentInPoints = -1;
        this.ascentInPoints = -1;
        this.wrapWidth = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        int i;
        int nSegments;
        if (this.attrList != 0L) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        byte[] buffer = Converter.wcsToMbcs(segmentsText, false);
        OS.pango_layout_set_text(this.layout, buffer, buffer.length);
        if (this.stylesCount == 2 && this.styles[0].style == null && this.ascentInPoints == -1 && this.descentInPoints == -1 && this.segments == null) {
            return;
        }
        long ptr = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        this.selAttrList = OS.pango_attr_list_new();
        PangoAttribute attribute = new PangoAttribute();
        char[] chars = null;
        int segementsLength = segmentsText.length();
        int offsetCount = nSegments = segementsLength - this.text.length();
        int[] lineOffsets = null;
        if ((this.ascentInPoints != -1 || this.descentInPoints != -1) && segementsLength > 0) {
            int lineIndex;
            PangoRectangle rect = new PangoRectangle();
            if (this.ascentInPoints != -1) {
                rect.y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints) * 1024);
            }
            rect.height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), Math.max(0, this.ascentInPoints) + Math.max(0, this.descentInPoints)) * 1024;
            int lineCount = OS.pango_layout_get_line_count(this.layout);
            chars = new char[segementsLength + lineCount * 2];
            lineOffsets = new int[lineCount];
            int oldPos = 0;
            PangoLayoutLine line = new PangoLayoutLine();
            for (lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
                long linePtr = OS.pango_layout_get_line(this.layout, lineIndex);
                OS.memmove(line, linePtr, (long)PangoLayoutLine.sizeof);
                int bytePos = line.start_index;
                int offset = lineIndex * 6;
                long attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset;
                attribute.end_index = bytePos + offset + 3;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr));
                attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset + 3;
                attribute.end_index = bytePos + offset + 6;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr));
                int pos = (int)OS.g_utf16_pointer_to_offset(ptr, ptr + (long)bytePos);
                chars[pos + lineIndex * 2] = 8203;
                chars[pos + lineIndex * 2 + 1] = 65279;
                segmentsText.getChars(oldPos, pos, chars, oldPos + lineIndex * 2);
                lineOffsets[lineIndex] = pos + lineIndex * 2;
                oldPos = pos;
            }
            segmentsText.getChars(oldPos, segementsLength, chars, oldPos + lineIndex * 2);
            buffer = Converter.wcsToMbcs(chars, false);
            OS.pango_layout_set_text(this.layout, buffer, buffer.length);
            ptr = OS.pango_layout_get_text(this.layout);
            offsetCount += 2 * lineCount;
        } else {
            chars = new char[segementsLength];
            segmentsText.getChars(0, segementsLength, chars, 0);
        }
        this.invalidOffsets = new int[offsetCount];
        if (offsetCount > 0) {
            offsetCount = 0;
            int lineIndex = 0;
            int segmentCount = 0;
            for (i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\u200b' && lineOffsets != null && lineIndex < lineOffsets.length && i == lineOffsets[lineIndex]) {
                    this.invalidOffsets[offsetCount++] = i++;
                    this.invalidOffsets[offsetCount++] = i;
                    ++lineIndex;
                    continue;
                }
                if (segmentCount >= nSegments || i - offsetCount != this.segments[segmentCount]) continue;
                this.invalidOffsets[offsetCount++] = i;
                ++segmentCount;
            }
        }
        int strlen = C.strlen(ptr);
        Font defaultFont = this.font != null ? this.font : this.device.systemFont;
        for (i = 0; i < this.stylesCount - 1; ++i) {
            int rise;
            GlyphMetrics metrics;
            Color background;
            Color foreground;
            GdkRGBA rgba;
            long attr;
            StyleItem styleItem = this.styles[i];
            TextStyle style = styleItem.style;
            if (style == null) continue;
            int start = this.translateOffset(styleItem.start);
            int end = this.translateOffset(this.styles[i + 1].start - 1);
            int byteStart = (int)(OS.g_utf16_offset_to_pointer(ptr, start) - ptr);
            int byteEnd = (int)(OS.g_utf16_offset_to_pointer(ptr, end + 1) - ptr);
            byteStart = Math.min(byteStart, strlen);
            byteEnd = Math.min(byteEnd, strlen);
            Font font = style.font;
            if (font != null && !font.isDisposed() && !defaultFont.equals(font)) {
                attr = OS.pango_attr_font_desc_new(font.handle);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr));
            }
            if (style.underline) {
                int underlineStyle = 0;
                switch (style.underlineStyle) {
                    case 0: {
                        underlineStyle = 1;
                        break;
                    }
                    case 1: {
                        underlineStyle = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        underlineStyle = 4;
                        break;
                    }
                    case 4: {
                        if (style.foreground == null) {
                            GdkRGBA linkRGBA = this.device.getSystemColor((int)36).handle;
                            long attr2 = OS.pango_attr_foreground_new((short)(linkRGBA.red * 65535.0), (short)(linkRGBA.green * 65535.0), (short)(linkRGBA.blue * 65535.0));
                            OS.memmove(attribute, attr2, (long)PangoAttribute.sizeof);
                            attribute.start_index = byteStart;
                            attribute.end_index = byteEnd;
                            OS.memmove(attr2, attribute, (long)PangoAttribute.sizeof);
                            OS.pango_attr_list_insert(this.attrList, attr2);
                        }
                        underlineStyle = 1;
                    }
                }
                long attr3 = OS.pango_attr_underline_new(underlineStyle);
                OS.memmove(attribute, attr3, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr3, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr3);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr3));
                if (style.underlineColor != null) {
                    rgba = style.underlineColor.handle;
                    attr3 = OS.pango_attr_underline_color_new((short)(rgba.red * 65535.0), (short)(rgba.green * 65535.0), (short)(rgba.blue * 65535.0));
                    if (attr3 != 0L) {
                        OS.memmove(attribute, attr3, (long)PangoAttribute.sizeof);
                        attribute.start_index = byteStart;
                        attribute.end_index = byteEnd;
                        OS.memmove(attr3, attribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, attr3);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr3));
                    }
                }
            }
            if (style.strikeout) {
                attr = OS.pango_attr_strikethrough_new(true);
                OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr));
                if (style.strikeoutColor != null) {
                    GdkRGBA rgba2 = style.strikeoutColor.handle;
                    attr = OS.pango_attr_strikethrough_color_new((short)(rgba2.red * 65535.0), (short)(rgba2.green * 65535.0), (short)(rgba2.blue * 65535.0));
                    if (attr != 0L) {
                        OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
                        attribute.start_index = byteStart;
                        attribute.end_index = byteEnd;
                        OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
                        OS.pango_attr_list_insert(this.attrList, attr);
                        OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr));
                    }
                }
            }
            if ((foreground = style.foreground) != null && !foreground.isDisposed()) {
                rgba = foreground.handle;
                long attr4 = OS.pango_attr_foreground_new((short)(rgba.red * 65535.0), (short)(rgba.green * 65535.0), (short)(rgba.blue * 65535.0));
                OS.memmove(attribute, attr4, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr4, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr4);
            }
            if ((background = style.background) != null && !background.isDisposed()) {
                GdkRGBA rgba3 = background.handle;
                long attr5 = OS.pango_attr_background_new((short)(rgba3.red * 65535.0), (short)(rgba3.green * 65535.0), (short)(rgba3.blue * 65535.0));
                OS.memmove(attribute, attr5, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr5, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr5);
            }
            if ((metrics = style.metrics) != null) {
                PangoRectangle rect = new PangoRectangle();
                rect.y = -(DPIUtil.autoScaleUp((Drawable)this.getDevice(), metrics.ascent) * 1024);
                rect.height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), metrics.ascent + metrics.descent) * 1024;
                rect.width = DPIUtil.autoScaleUp((Drawable)this.getDevice(), metrics.width) * 1024;
                long attr6 = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr6, (long)PangoAttribute.sizeof);
                attribute.start_index = byteStart;
                attribute.end_index = byteEnd;
                OS.memmove(attr6, attribute, (long)PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr6);
                OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr6));
            }
            if ((rise = style.rise) == 0) continue;
            long attr7 = OS.pango_attr_rise_new(DPIUtil.autoScaleUp((Drawable)this.getDevice(), rise) * 1024);
            OS.memmove(attribute, attr7, (long)PangoAttribute.sizeof);
            attribute.start_index = byteStart;
            attribute.end_index = byteEnd;
            OS.memmove(attr7, attribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(this.attrList, attr7);
            OS.pango_attr_list_insert(this.selAttrList, OS.pango_attribute_copy(attr7));
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    int[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right - left, width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        for (int i = 0; i < peaks; ++i) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    @Override
    void destroy() {
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        this.segments = null;
        this.segmentsChars = null;
        if (this.layout != 0L) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0L;
        if (this.context != 0L) {
            OS.g_object_unref(this.context);
        }
        this.context = 0L;
    }

    public void draw(GC gc, int x, int y) {
        x = DPIUtil.autoScaleUp((Drawable)this.getDevice(), x);
        y = DPIUtil.autoScaleUp((Drawable)this.getDevice(), y);
        this.drawInPixels(gc, x, y);
    }

    void drawInPixels(GC gc, int x, int y) {
        this.drawInPixels(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkLayout();
        x = DPIUtil.autoScaleUp((Drawable)this.getDevice(), x);
        y = DPIUtil.autoScaleUp((Drawable)this.getDevice(), y);
        this.drawInPixels(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    void drawInPixels(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.drawInPixels(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        x = DPIUtil.autoScaleUp((Drawable)this.getDevice(), x);
        y = DPIUtil.autoScaleUp((Drawable)this.getDevice(), y);
        this.drawInPixels(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, flags);
    }

    void drawInPixels(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        gc.checkGC(1);
        int length = this.text.length();
        x += Math.min(this.indent, this.wrapIndent);
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        GCData data = gc.data;
        long cairo = data.cairo;
        if ((flags & 0x30000) != 0 && (hasSelection || (flags & 0x100000) != 0)) {
            long[] attrs = new long[1];
            int[] nAttrs = new int[1];
            PangoLogAttr logAttr = new PangoLogAttr();
            PangoRectangle rect = new PangoRectangle();
            int lineCount = OS.pango_layout_get_line_count(this.layout);
            long ptr = OS.pango_layout_get_text(this.layout);
            long iter = OS.pango_layout_get_iter(this.layout);
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            Cairo.cairo_save(cairo);
            GdkRGBA rgba = selectionBackground.handle;
            Cairo.cairo_set_source_rgba(cairo, rgba.red, rgba.green, rgba.blue, rgba.alpha);
            int lineIndex = 0;
            do {
                int lineEnd;
                OS.pango_layout_iter_get_line_extents(iter, null, rect);
                if (OS.pango_layout_iter_next_line(iter)) {
                    int bytePos = OS.pango_layout_iter_get_index(iter);
                    lineEnd = (int)OS.g_utf16_pointer_to_offset(ptr, ptr + (long)bytePos);
                } else {
                    lineEnd = (int)OS.g_utf16_strlen(ptr, -1L);
                }
                boolean extent = false;
                if (lineIndex == lineCount - 1 && (flags & 0x100000) != 0) {
                    extent = true;
                } else {
                    if (attrs[0] == 0L) {
                        OS.pango_layout_get_log_attrs(this.layout, attrs, nAttrs);
                    }
                    OS.memmove(logAttr, attrs[0] + (long)(lineEnd * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
                    if (!logAttr.is_line_break) {
                        if (selectionStart <= lineEnd && lineEnd <= selectionEnd) {
                            extent = true;
                        }
                    } else if (selectionStart <= lineEnd && lineEnd < selectionEnd && (flags & 0x10000) != 0) {
                        extent = true;
                    }
                }
                if (!extent) continue;
                int lineX = x + OS.PANGO_PIXELS(rect.x) + OS.PANGO_PIXELS(rect.width);
                int lineY = y + OS.PANGO_PIXELS(rect.y);
                int height = OS.PANGO_PIXELS(rect.height);
                if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
                    height = Math.max(height, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
                }
                int width = (flags & 0x10000) != 0 ? Short.MAX_VALUE : height / 3;
                Cairo.cairo_rectangle(cairo, lineX, lineY, width, height);
                Cairo.cairo_fill(cairo);
            } while (++lineIndex < lineCount);
            OS.pango_layout_iter_free(iter);
            if (attrs[0] != 0L) {
                OS.g_free(attrs[0]);
            }
            Cairo.cairo_restore(cairo);
        }
        if (length == 0) {
            return;
        }
        if (!hasSelection) {
            if ((data.style & 0x8000000) != 0) {
                Cairo.cairo_save(cairo);
                Cairo.cairo_scale(cairo, -1.0, 1.0);
                Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
            }
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layout);
            this.drawBorder(gc, x, y, null);
            if ((data.style & 0x8000000) != 0) {
                Cairo.cairo_restore(cairo);
            }
        } else {
            boolean fullSelection;
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            length = (int)OS.g_utf16_strlen(OS.pango_layout_get_text(this.layout), -1L);
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            boolean bl = fullSelection = selectionStart == 0 && selectionEnd == length - 1;
            if (fullSelection) {
                long ptr = OS.pango_layout_get_text(this.layout);
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_save(cairo);
                    Cairo.cairo_scale(cairo, -1.0, 1.0);
                    Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
                }
                this.drawWithCairo(gc, x, y, 0, C.strlen(ptr), fullSelection, selectionForeground.handle, selectionBackground.handle);
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(cairo);
                }
            } else {
                long ptr = OS.pango_layout_get_text(this.layout);
                int byteSelStart = (int)(OS.g_utf16_offset_to_pointer(ptr, selectionStart) - ptr);
                int byteSelEnd = (int)(OS.g_utf16_offset_to_pointer(ptr, selectionEnd + 1) - ptr);
                int strlen = C.strlen(ptr);
                byteSelStart = Math.min(byteSelStart, strlen);
                byteSelEnd = Math.min(byteSelEnd, strlen);
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_save(cairo);
                    Cairo.cairo_scale(cairo, -1.0, 1.0);
                    Cairo.cairo_translate(cairo, -2 * x - this.width(), 0.0);
                }
                this.drawWithCairo(gc, x, y, byteSelStart, byteSelEnd, fullSelection, selectionForeground.handle, selectionBackground.handle);
                if ((data.style & 0x8000000) != 0) {
                    Cairo.cairo_restore(cairo);
                }
            }
        }
        Cairo.cairo_new_path(cairo);
    }

    void drawWithCairo(GC gc, int x, int y, int start, int end, boolean fullSelection, GdkRGBA fg, GdkRGBA bg) {
        int[] ranges;
        long rgn;
        GCData data = gc.data;
        long cairo = data.cairo;
        Cairo.cairo_save(cairo);
        if (!fullSelection) {
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layout);
            this.drawBorder(gc, x, y, null);
        }
        if ((rgn = GDK.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges = new int[]{start, end}, ranges.length / 2)) != 0L) {
            GDK.gdk_cairo_region(cairo, rgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_source_rgba(cairo, bg.red, bg.green, bg.blue, bg.alpha);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_region_destroy(rgn);
        }
        Cairo.cairo_set_source_rgba(cairo, fg.red, fg.green, fg.blue, fg.alpha);
        Cairo.cairo_move_to(cairo, x, y);
        OS.pango_layout_set_attributes(this.layout, this.selAttrList);
        OS.pango_cairo_show_layout(cairo, this.layout);
        OS.pango_layout_set_attributes(this.layout, this.attrList);
        this.drawBorder(gc, x, y, fg);
        Cairo.cairo_restore(cairo);
    }

    void drawBorder(GC gc, int x, int y, GdkRGBA selectionColor) {
        GCData data = gc.data;
        long cairo = data.cairo;
        long ptr = OS.pango_layout_get_text(this.layout);
        Cairo.cairo_save(cairo);
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            int byteEnd;
            boolean drawBorder;
            TextStyle style = this.styles[i].style;
            if (style == null) continue;
            boolean bl = drawBorder = style.borderStyle != 0;
            if (!drawBorder || style.isAdherentBorder(this.styles[i + 1].style)) continue;
            int start = this.styles[i].start;
            for (int j = i; j > 0 && style.isAdherentBorder(this.styles[j - 1].style); --j) {
                start = this.styles[j - 1].start;
            }
            start = this.translateOffset(start);
            int end = this.translateOffset(this.styles[i + 1].start - 1);
            int byteStart = (int)(OS.g_utf16_offset_to_pointer(ptr, start) - ptr);
            int[] ranges = new int[]{byteStart, byteEnd = (int)(OS.g_utf16_offset_to_pointer(ptr, end + 1) - ptr)};
            long rgn = GDK.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
            if (rgn == 0L) continue;
            int[] nRects = new int[1];
            long[] rects = new long[1];
            Region.cairo_region_get_rectangles(rgn, rects, nRects);
            cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
            GdkRGBA colorRGBA = null;
            if (colorRGBA == null && style.borderColor != null) {
                colorRGBA = style.borderColor.handle;
            }
            if (colorRGBA == null && selectionColor != null) {
                colorRGBA = selectionColor;
            }
            if (colorRGBA == null && style.foreground != null) {
                colorRGBA = style.foreground.handle;
            }
            if (colorRGBA == null) {
                colorRGBA = data.foregroundRGBA;
            }
            boolean width = true;
            float[] dashes = null;
            switch (style.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                    break;
                }
                case 4: {
                    dashes = width ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                }
            }
            Cairo.cairo_set_source_rgba(cairo, colorRGBA.red, colorRGBA.green, colorRGBA.blue, colorRGBA.alpha);
            Cairo.cairo_set_line_width(cairo, (double)width);
            if (dashes != null) {
                double[] cairoDashes = new double[dashes.length];
                for (int j = 0; j < cairoDashes.length; ++j) {
                    cairoDashes[j] = !width || data.lineStyle == 6 ? (double)dashes[j] : (double)(dashes[j] * (float)width);
                }
                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, 0.0);
            } else {
                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
            }
            for (int j = 0; j < nRects[0]; ++j) {
                Cairo.memmove(rect, rects[0] + (long)(j * cairo_rectangle_int_t.sizeof), (long)cairo_rectangle_int_t.sizeof);
                Cairo.cairo_rectangle(cairo, (double)rect.x + 0.5, (double)rect.y + 0.5, rect.width - 1, rect.height - 1);
            }
            Cairo.cairo_stroke(cairo);
            if (rects[0] != 0L) {
                OS.g_free(rects[0]);
            }
            Cairo.cairo_region_destroy(rgn);
        }
        Cairo.cairo_restore(cairo);
    }

    void freeRuns() {
        if (this.attrList == 0L) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0L);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0L;
        if (this.selAttrList != 0L) {
            OS.pango_attr_list_unref(this.selAttrList);
            this.selAttrList = 0L;
        }
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int align = OS.pango_layout_get_alignment(this.layout);
        boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
        switch (align) {
            case 0: {
                return rtl ? 131072 : 16384;
            }
            case 2: {
                return rtl ? 16384 : 131072;
            }
        }
        return 0x1000000;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascentInPoints;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        Rectangle bounds = DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels());
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        int totalLineheight = 0;
        for (int i = 0; i < lineCount; ++i) {
            totalLineheight += this.getLineBounds((int)i).height + OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
        }
        bounds.height = totalLineheight;
        return bounds;
    }

    Rectangle getBoundsInPixels() {
        this.checkLayout();
        this.computeRuns();
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_size(this.layout, w, h);
        int wrapWidth = OS.pango_layout_get_width(this.layout);
        w[0] = wrapWidth != -1 ? wrapWidth : w[0] + OS.pango_layout_get_indent(this.layout);
        int width = OS.PANGO_PIXELS(w[0]);
        int height = OS.PANGO_PIXELS(h[0]);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            height = Math.max(height, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        return new Rectangle(0, 0, width, height += OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout)));
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(start, end));
    }

    Rectangle getBoundsInPixels(int start, int end) {
        long linesRegion;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        long ptr = OS.pango_layout_get_text(this.layout);
        int byteStart = (int)(OS.g_utf16_offset_to_pointer(ptr, start) - ptr);
        int byteEnd = (int)(OS.g_utf16_offset_to_pointer(ptr, end + 1) - ptr);
        int strlen = C.strlen(ptr);
        int[] ranges = new int[]{byteStart = Math.min(byteStart, strlen), byteEnd = Math.min(byteEnd, strlen)};
        long clipRegion = GDK.gdk_pango_layout_get_clip_region(this.layout, 0, 0, ranges, 1);
        if (clipRegion == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        PangoRectangle pangoRect = new PangoRectangle();
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        if ((linesRegion = Cairo.cairo_region_create()) == 0L) {
            SWT.error(2);
        }
        int lineEnd = 0;
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, pangoRect);
            lineEnd = OS.pango_layout_iter_next_line(iter) ? OS.pango_layout_iter_get_index(iter) - 1 : strlen;
            if (byteStart > lineEnd) continue;
            rect.x = OS.PANGO_PIXELS(pangoRect.x);
            rect.y = OS.PANGO_PIXELS(pangoRect.y);
            rect.width = OS.PANGO_PIXELS(pangoRect.width);
            rect.height = OS.PANGO_PIXELS(pangoRect.height);
            Cairo.cairo_region_union_rectangle(linesRegion, rect);
        } while (lineEnd + 1 <= byteEnd);
        Cairo.cairo_region_intersect(clipRegion, linesRegion);
        Cairo.cairo_region_destroy(linesRegion);
        OS.pango_layout_iter_free(iter);
        Cairo.cairo_region_get_extents(clipRegion, rect);
        Cairo.cairo_region_destroy(clipRegion);
        rect.x += Math.min(this.indent, this.wrapIndent);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descentInPoints;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        int level = 0;
        PangoItem item = new PangoItem();
        PangoLayoutRun run = new PangoLayoutRun();
        long ptr = OS.pango_layout_get_text(this.layout);
        long byteOffset = OS.g_utf16_offset_to_pointer(ptr, offset) - ptr;
        int strlen = C.strlen(ptr);
        byteOffset = Math.min(byteOffset, (long)strlen);
        do {
            long runPtr;
            if ((runPtr = OS.pango_layout_iter_get_run(iter)) == 0L) continue;
            OS.memmove(run, runPtr, (long)PangoLayoutRun.sizeof);
            OS.memmove(item, run.item, (long)PangoItem.sizeof);
            if ((long)item.offset > byteOffset || byteOffset >= (long)(item.offset + item.length)) continue;
            level = item.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(iter));
        OS.pango_layout_iter_free(iter);
        return level;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(lineIndex));
    }

    Rectangle getLineBoundsInPixels(int lineIndex) {
        long iter;
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (0 > lineIndex || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        for (int i = 0; i < lineIndex; ++i) {
            OS.pango_layout_iter_next_line(iter);
        }
        PangoRectangle rect = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(iter, null, rect);
        OS.pango_layout_iter_free(iter);
        int x = OS.PANGO_PIXELS(rect.x);
        int y = OS.PANGO_PIXELS(rect.y);
        int width = OS.PANGO_PIXELS(rect.width);
        int height = OS.PANGO_PIXELS(rect.height);
        if (this.ascentInPoints != -1 && this.descentInPoints != -1) {
            height = Math.max(height, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.ascentInPoints + this.descentInPoints));
        }
        return new Rectangle(x += Math.min(this.indent, this.wrapIndent), y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(5);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        long ptr = OS.pango_layout_get_text(this.layout);
        long byteOffset = OS.g_utf16_offset_to_pointer(ptr, offset) - ptr;
        int strlen = C.strlen(ptr);
        byteOffset = Math.min(byteOffset, (long)strlen);
        long iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0L) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(iter) && (long)OS.pango_layout_iter_get_index(iter) <= byteOffset) {
            ++line;
        }
        OS.pango_layout_iter_free(iter);
        return line;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        int heightInPoints;
        int ascentInPoints;
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (0 > lineIndex || lineIndex >= lineCount) {
            SWT.error(6);
        }
        PangoLayoutLine line = new PangoLayoutLine();
        OS.memmove(line, OS.pango_layout_get_line(this.layout, lineIndex), (long)PangoLayoutLine.sizeof);
        if (line.runs == 0L) {
            long font = this.font != null ? this.font.handle : this.device.systemFont.handle;
            long lang = OS.pango_context_get_language(this.context);
            long metrics = OS.pango_context_get_metrics(this.context, font, lang);
            int ascent = OS.pango_font_metrics_get_ascent(metrics);
            int descent = OS.pango_font_metrics_get_descent(metrics);
            ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(ascent));
            heightInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(ascent + descent));
            OS.pango_font_metrics_unref(metrics);
        } else {
            PangoRectangle rect = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, lineIndex), null, rect);
            ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(-rect.y));
            heightInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), OS.PANGO_PIXELS(rect.height));
        }
        heightInPoints = Math.max(this.ascentInPoints + this.descentInPoints, heightInPoints);
        ascentInPoints = Math.max(this.ascentInPoints, ascentInPoints);
        int descentInPoints = heightInPoints - ascentInPoints;
        return FontMetrics.gtk_new(ascentInPoints, descentInPoints, 0);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        int[] offsets = new int[lineCount + 1];
        long ptr = OS.pango_layout_get_text(this.layout);
        PangoLayoutLine line = new PangoLayoutLine();
        for (int i = 0; i < lineCount; ++i) {
            long linePtr = OS.pango_layout_get_line(this.layout, i);
            OS.memmove(line, linePtr, (long)PangoLayoutLine.sizeof);
            int pos = (int)OS.g_utf16_pointer_to_offset(ptr, ptr + (long)line.start_index);
            offsets[i] = this.untranslateOffset(pos);
        }
        offsets[lineCount] = this.text.length();
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(offset, trailing));
    }

    Point getLocationInPixels(int offset, boolean trailing) {
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        long ptr = OS.pango_layout_get_text(this.layout);
        int byteOffset = (int)(OS.g_utf16_offset_to_pointer(ptr, offset) - ptr);
        int strlen = C.strlen(ptr);
        byteOffset = Math.min(byteOffset, strlen);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, byteOffset, pos);
        int x = trailing ? pos.x + pos.width : pos.x;
        int y = pos.y;
        x = OS.PANGO_PIXELS(x);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            x = this.width() - x;
        }
        return new Point(x += Math.min(this.indent, this.wrapIndent), OS.PANGO_PIXELS(y));
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        if (forward) {
            if (offset == length) {
                return length;
            }
        } else if (offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        long[] attrs = new long[1];
        int[] nAttrs = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, attrs, nAttrs);
        if (attrs[0] == 0L) {
            return offset + step;
        }
        long ptr = OS.pango_layout_get_text(this.layout);
        int utf8Offset = (int)OS.g_utf16_offset_to_utf8_offset(ptr, this.translateOffset(offset));
        int utf8Length = (int)OS.g_utf8_strlen(ptr, -1L);
        utf8Offset += step;
        PangoLogAttr logAttr = new PangoLogAttr();
        while (0 <= utf8Offset && utf8Offset <= utf8Length) {
            OS.memmove(logAttr, attrs[0] + (long)(utf8Offset * PangoLogAttr.sizeof), (long)PangoLogAttr.sizeof);
            boolean found = false;
            boolean limit = false;
            if ((movement & 2) != 0 && logAttr.is_cursor_position) {
                found = true;
            }
            if ((movement & 4) != 0) {
                if (forward) {
                    if (logAttr.is_word_end) {
                        found = true;
                    }
                } else if (logAttr.is_word_start) {
                    found = true;
                }
            }
            if ((movement & 0x10) != 0) {
                if (logAttr.is_word_start) {
                    found = true;
                }
                if (logAttr.is_sentence_end) {
                    found = true;
                }
            }
            if ((movement & 8) != 0) {
                if (logAttr.is_word_end) {
                    found = true;
                }
                if (logAttr.is_sentence_start) {
                    found = true;
                }
            }
            if (forward) {
                if (utf8Offset == utf8Length) {
                    limit = true;
                }
            } else if (utf8Offset == 0) {
                limit = true;
            }
            if (found || limit) {
                int testOffset = (int)OS.g_utf8_offset_to_utf16_offset(ptr, utf8Offset);
                if (found && this.invalidOffsets != null) {
                    for (int i = 0; i < this.invalidOffsets.length; ++i) {
                        if (testOffset != this.invalidOffsets[i]) continue;
                        found = false;
                        break;
                    }
                }
                if (found || limit) {
                    offset = this.untranslateOffset(testOffset);
                    break;
                }
            }
            utf8Offset += step;
        }
        OS.g_free(attrs[0]);
        return Math.min(Math.max(0, offset), length);
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), trailing);
    }

    int getOffsetInPixels(Point point, int[] trailing) {
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        return this.getOffset(new Point(x, y), trailing);
    }

    int getOffsetInPixels(int x, int y, int[] trailing) {
        long iter;
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        x -= Math.min(this.indent, this.wrapIndent);
        if (OS.pango_context_get_base_dir(this.context) == 1) {
            x = this.width() - x;
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0L) {
            SWT.error(2);
        }
        PangoRectangle rect = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, rect);
            rect.y = OS.PANGO_PIXELS(rect.y);
            rect.height = OS.PANGO_PIXELS(rect.height);
            if (rect.y > y || y >= rect.y + rect.height) continue;
            rect.x = OS.PANGO_PIXELS(rect.x);
            rect.width = OS.PANGO_PIXELS(rect.width);
            if (x >= rect.x + rect.width) {
                x = rect.x + rect.width - 1;
            }
            if (x >= rect.x) break;
            x = rect.x;
            break;
        } while (OS.pango_layout_iter_next_line(iter));
        OS.pango_layout_iter_free(iter);
        int[] index = new int[1];
        int[] piTrailing = new int[1];
        OS.pango_layout_xy_to_index(this.layout, x * 1024, y * 1024, index, piTrailing);
        long ptr = OS.pango_layout_get_text(this.layout);
        int offset = (int)OS.g_utf16_pointer_to_offset(ptr, ptr + (long)index[0]);
        if (trailing != null) {
            trailing[0] = piTrailing[0];
            if (piTrailing[0] != 0) {
                trailing[0] = (int)OS.g_utf8_offset_to_utf16_offset(ptr, OS.g_utf8_pointer_to_offset(ptr, ptr + (long)index[0]) + (long)piTrailing[0]) - offset;
            }
        }
        return this.untranslateOffset(offset);
    }

    public int getOrientation() {
        this.checkLayout();
        int baseDir = OS.pango_context_get_base_dir(this.context);
        return baseDir == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int offset, int movement) {
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.stylesCount * 2];
        int count = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].start;
            result[count++] = this.styles[i + 1].start - 1;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator;
        int defaultSeparator;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int n = defaultSeparator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getSpacingInPixels());
    }

    int getSpacingInPixels() {
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            StyleItem item = this.styles[i];
            if (item.start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.stylesCount];
        int count = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].style;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        return this.getOrientation();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.layout == 0L;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
        int align = 1;
        switch (alignment) {
            case 16384: {
                align = rtl ? 2 : 0;
                break;
            }
            case 131072: {
                align = rtl ? 0 : 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, align);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascentInPoints == ascent) {
            return;
        }
        this.freeRuns();
        this.ascentInPoints = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descentInPoints == descent) {
            return;
        }
        this.freeRuns();
        this.descentInPoints = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.freeRuns();
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : this.device.systemFont.handle);
    }

    public void setIndent(int indent) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), indent));
    }

    void setIndentInPixels(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.indent = indent;
        OS.pango_layout_set_indent(this.layout, (indent - this.wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, justify);
    }

    public void setOrientation(int orientation) {
        int baseDir;
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        int n = baseDir = orientation == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == baseDir) {
            return;
        }
        this.freeRuns();
        OS.pango_context_set_base_dir(this.context, baseDir);
        OS.pango_layout_context_changed(this.layout);
        int align = OS.pango_layout_get_alignment(this.layout);
        if (align != 1) {
            align = align == 0 ? 2 : 0;
            OS.pango_layout_set_alignment(this.layout, align);
        }
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        this.setSpacingInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), spacing));
    }

    void setSpacingInPixels(int spacing) {
        OS.pango_layout_set_spacing(this.layout, spacing * 1024);
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i;
            for (i = 0; i < segmentsChars.length && this.segmentsChars[i] == segmentsChars[i]; ++i) {
            }
            if (i == segmentsChars.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = segmentsChars;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int newLength;
        int modifyStart;
        int modifyEnd;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        if (start > 0 && TextLayout.isAlef(this.text.charAt(start)) && TextLayout.isLam(this.text.charAt(start - 1))) {
            --start;
        }
        if (end < length - 1 && TextLayout.isLam(this.text.charAt(end)) && TextLayout.isAlef(this.text.charAt(end + 1))) {
            ++end;
        }
        int low = -1;
        int high = this.stylesCount;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (0 <= high && high < this.stylesCount) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        for (modifyEnd = modifyStart = high; modifyEnd < this.stylesCount && this.styles[modifyEnd + 1].start <= end; ++modifyEnd) {
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                int newLength2 = this.stylesCount + 2;
                if (newLength2 > this.styles.length) {
                    int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                    StyleItem[] newStyles = new StyleItem[newSize];
                    System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                    this.styles = newStyles;
                }
                System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                this.styles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                this.styles[modifyStart + 2] = item;
                this.stylesCount = newLength2;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
            int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
            StyleItem[] newStyles = new StyleItem[newSize];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        this.styles[modifyStart + 1] = item;
        this.styles[modifyStart + 2].start = end + 1;
        this.stylesCount = newLength;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), tabs));
    }

    void setTabsInPixels(int[] tabs) {
        if (Arrays.equals(this.tabs, tabs)) {
            return;
        }
        this.tabs = tabs;
        if (tabs == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            long tabArray = OS.pango_tab_array_new(tabs.length, true);
            if (tabArray != 0L) {
                for (int i = 0; i < tabs.length; ++i) {
                    OS.pango_tab_array_set_tab(tabArray, i, 0L, tabs[i]);
                }
                OS.pango_layout_set_tabs(this.layout, tabArray);
                OS.pango_tab_array_free(tabArray);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int textDirection) {
        this.checkLayout();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        this.setWidthInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), width));
    }

    void setWidthInPixels(int width) {
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
        this.setWidth();
    }

    void setWidth() {
        if (this.wrapWidth == -1) {
            OS.pango_layout_set_width(this.layout, -1);
            boolean rtl = OS.pango_context_get_base_dir(this.context) == 1;
            OS.pango_layout_set_alignment(this.layout, rtl ? 2 : 0);
        } else {
            int margin = Math.min(this.indent, this.wrapIndent);
            OS.pango_layout_set_width(this.layout, (this.wrapWidth - margin) * 1024);
        }
    }

    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        if (wrapIndent < 0) {
            return;
        }
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), wrapIndent));
    }

    void setWrapIndentInPixels(int wrapIndent) {
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        this.wrapIndent = wrapIndent;
        OS.pango_layout_set_indent(this.layout, (this.indent - wrapIndent) * 1024);
        if (this.wrapWidth != -1) {
            this.setWidth();
        }
    }

    static final boolean isLam(int ch) {
        return ch == 1604;
    }

    static final boolean isAlef(int ch) {
        switch (ch) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        for (int i = 0; i < this.invalidOffsets.length && offset >= this.invalidOffsets[i]; ++offset, ++i) {
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int i;
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        for (i = 0; i < this.invalidOffsets.length && offset > this.invalidOffsets[i]; ++i) {
        }
        return offset - i;
    }

    int width() {
        int wrapWidth = OS.pango_layout_get_width(this.layout);
        if (wrapWidth != -1) {
            return OS.PANGO_PIXELS(wrapWidth);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_pixel_size(this.layout, w, h);
        return w[0];
    }

    public void setDefaultTabWidth(int tabLength) {
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

