/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    long shellHandle;
    long tooltipsHandle;
    long tooltipWindow;
    long group;
    long modalGroup;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean showWithParent;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    GdkGeometry geometry;
    Control lastActive;
    ToolTip[] toolTips;
    boolean ignoreFocusOut;
    boolean ignoreFocusIn;
    boolean ignoreFocusOutAfterGrab;
    boolean grabbedFocus;
    Region originalRegion;
    static final int MAXIMUM_TRIM = 128;
    static final int BORDER = 3;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0L, false);
    }

    Shell(Display display, Shell parent, int style, long handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0L) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
                this.state |= 0x400000;
            }
        }
        this.geometry = new GdkGeometry();
        this.reskinWidget();
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0L, false);
    }

    public static Shell gtk_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, long handle) {
        return new Shell(display, null, 8, handle, false);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        if (parent != null && ((style &= 0xBFFFFFFF) & 0x4000) != 0) {
            style &= 0xFFFFFB1F;
        }
        int mask = 229376;
        if ((style & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void addToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != null) continue;
            this.toolTips[i] = toolTip;
            return;
        }
        ToolTip[] newToolTips = new ToolTip[this.toolTips.length + 4];
        newToolTips[this.toolTips.length] = toolTip;
        System.arraycopy(this.toolTips, 0, newToolTips, 0, this.toolTips.length);
        this.toolTips = newToolTips;
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.shellHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        GdkRectangle rect = new GdkRectangle();
        if (!GTK.GTK4) {
            long window = this.gtk_widget_get_window(this.shellHandle);
            GDK.gdk_window_get_frame_extents(window, rect);
        }
        int trimWidth = Math.max(0, rect.width - width);
        int trimHeight = Math.max(0, rect.height - height);
        if (trimWidth > 128 || trimHeight > 128 || this.isCustomResize()) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        int trimStyle = hasTitle ? (hasResize ? 4 : (hasBorder ? 3 : 5)) : (hasResize ? 2 : (hasBorder ? 1 : 0));
        Rectangle bounds = this.getBoundsInPixels();
        int widthAdjustment = this.display.trimWidths[trimStyle] - trimWidth;
        int heightAdjustment = this.display.trimHeights[trimStyle] - trimHeight;
        if (widthAdjustment == 0 && heightAdjustment == 0) {
            return;
        }
        bounds.width += widthAdjustment;
        bounds.height += heightAdjustment;
        this.oldWidth += widthAdjustment;
        this.oldHeight += heightAdjustment;
        if (!this.getMaximized()) {
            this.resizeBounds(width + widthAdjustment, height + heightAdjustment, false);
        }
        this.display.trimWidths[trimStyle] = trimWidth;
        this.display.trimHeights[trimStyle] = trimHeight;
    }

    void bringToTop(boolean force) {
        if (!GTK.gtk_widget_get_visible(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell activeShell = display.activeShell;
        if (activeShell == this) {
            return;
        }
        if (!force) {
            long focusHandle;
            if (activeShell == null) {
                return;
            }
            if (!display.activePending && (focusHandle = GTK.gtk_window_get_focus(activeShell.shellHandle)) != 0L && !GTK.gtk_widget_has_focus(focusHandle)) {
                return;
            }
        }
        boolean xFocus = false;
        if (activeShell != null) {
            display.activeShell = null;
            display.activePending = true;
        }
        long gdkResource = GTK.GTK4 ? this.gtk_widget_get_surface(this.shellHandle) : this.gtk_widget_get_window(this.shellHandle);
        if (xFocus || (this.style & 0x4000) != 0) {
            if (OS.isX11()) {
                long gdkDisplay = GDK.gdk_window_get_display(gdkResource);
                long xDisplay = GDK.gdk_x11_display_get_xdisplay(gdkDisplay);
                long xWindow = GTK.GTK4 ? GDK.gdk_x11_surface_get_xid(gdkResource) : GDK.gdk_x11_window_get_xid(gdkResource);
                GDK.gdk_x11_display_error_trap_push(gdkDisplay);
                OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
                GDK.gdk_x11_display_error_trap_pop_ignored(gdkDisplay);
            } else {
                GTK.gtk_grab_add(this.shellHandle);
                long gdkDisplay = GTK.GTK4 ? GDK.gdk_surface_get_display(gdkResource) : GDK.gdk_window_get_display(gdkResource);
                long seat = GDK.gdk_display_get_default_seat(gdkDisplay);
                if (!GTK.GTK4) {
                    GDK.gdk_window_show(gdkResource);
                }
                GDK.gdk_seat_grab(seat, gdkResource, 15, true, 0L, 0L, 0L, 0L);
                this.grabbedFocus = true;
                this.ignoreFocusOutAfterGrab = true;
            }
        } else if (GTK.GTK4) {
            GDK.gdk_toplevel_focus(gdkResource, display.lastUserEventTime);
        } else {
            GDK.gdk_window_focus(gdkResource, display.lastUserEventTime);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBoundsInPixels();
        Rectangle parentRect = this.display.mapInPixels(this.parent, null, this.parent.getClientAreaInPixels());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = DPIUtil.autoScaleUp(this.parent.getMonitor().getClientArea());
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocationInPixels(x, y);
    }

    @Override
    void checkBorder() {
    }

    @Override
    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        int border = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        trim.x -= trimWidth / 2 + border;
        trim.y -= trimHeight - trimWidth / 2 + border;
        trim.width += trimWidth + border * 2;
        trim.height += trimHeight + border * 2;
        if (this.menuBar != null) {
            this.forceResize();
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.menuBar.handle, allocation);
            int menuBarHeight = allocation.height;
            trim.y -= menuBarHeight;
            trim.height += menuBarHeight;
        }
        return trim;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0xA;
        if (this.shellHandle == 0L) {
            boolean isChildShell;
            boolean bl = isChildShell = this.parent != null;
            if (this.handle == 0L) {
                int type = 0;
                if (isChildShell && (this.style & 0x4000) != 0) {
                    type = 1;
                }
                this.shellHandle = GTK.GTK4 ? GTK.gtk_window_new() : GTK.gtk_window_new(type);
            } else {
                this.shellHandle = GTK.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0L) {
                this.error(2);
            }
            if (isChildShell) {
                if (GTK.GTK4) {
                    GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                    GTK.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                } else {
                    if (!OS.isX11()) {
                        Composite topLevelParent = this.parent;
                        while (topLevelParent != null && (topLevelParent.style & 0x4000) != 0) {
                            topLevelParent = this.parent.getParent();
                        }
                        if (topLevelParent != null) {
                            GTK.gtk_window_set_transient_for(this.shellHandle, topLevelParent.topHandle());
                        } else {
                            GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                        }
                        GTK.gtk_window_set_attached_to(this.shellHandle, this.parent.topHandle());
                        if (this.parent != topLevelParent && this.isMappedToPopup()) {
                            this.parent.popupChild = this;
                        }
                    } else {
                        GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                    }
                    GTK.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                    if ((this.style & 0x80) == 0) {
                        GTK.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
                    }
                }
            } else if ((this.style & 0x4000) != 0) {
                GTK.gtk_window_set_keep_above(this.shellHandle, true);
            }
            GTK.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0x10) != 0) {
                GTK.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                GTK.gtk_window_set_resizable(this.shellHandle, false);
            }
            if ((this.style & 0xCF8) == 0) {
                this.gtk_container_set_border_width(this.shellHandle, 1);
            }
            if ((this.style & 4) != 0) {
                GTK.gtk_window_set_type_hint(this.shellHandle, 5);
            }
            if ((this.style & 8) != 0) {
                GTK.gtk_window_set_decorated(this.shellHandle, false);
            }
            if (!OS.isX11() && (this.style & 0x4F0) == 0) {
                GTK.gtk_window_set_decorated(this.shellHandle, false);
            }
            if (this.isCustomResize()) {
                this.gtk_container_set_border_width(this.shellHandle, 3);
            }
        }
        this.createHandle(index, false, true);
        this.vboxHandle = this.gtk_box_new(1, false, 0);
        if (this.vboxHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK.gtk_box_append(this.vboxHandle, this.scrolledHandle);
        } else {
            GTK.gtk_container_add(this.vboxHandle, this.scrolledHandle);
            this.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
        }
        this.group = GTK.gtk_window_group_new();
        if (this.group == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    long filterProc(long xEvent, long gdkEvent, long data2) {
        if (!OS.isX11()) {
            return 0L;
        }
        int eventType = OS.X_EVENT_TYPE(xEvent);
        if (eventType != 10 && eventType != 9) {
            return 0L;
        }
        XFocusChangeEvent xFocusEvent = new XFocusChangeEvent();
        OS.memmove(xFocusEvent, xEvent, (long)XFocusChangeEvent.sizeof);
        switch (eventType) {
            case 9: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0L;
                switch (xFocusEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        GDK.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
                return 0L;
            }
            case 10: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0L;
                switch (xFocusEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell == this) {
                            display.activeShell = null;
                            display.activePending = false;
                        }
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        GDK.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
            }
        }
        return 0L;
    }

    @Override
    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    @Override
    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    @Override
    boolean hasBorder() {
        return false;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect(this.shellHandle, OS.dpi_changed, this.display.notifyProc, 104L);
        if (GTK.GTK4) {
            GTK.gtk_widget_realize(this.shellHandle);
            long gdkSurface = this.gtk_widget_get_surface(this.shellHandle);
            OS.g_signal_connect(gdkSurface, OS.notify_state, this.display.notifyProc, this.shellHandle);
            OS.g_signal_connect(this.handle, OS.resize, this.display.resizeProc, 0L);
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[59], 0, this.display.getClosure(59), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.getClosure(10), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
        }
        if (GTK.GTK4) {
            OS.g_signal_connect_closure(this.shellHandle, OS.close_request, this.display.getClosure(99), false);
            long keyController = GTK.gtk_event_controller_key_new();
            GTK.gtk_widget_add_controller(this.shellHandle, keyController);
            GTK.gtk_event_controller_set_propagation_phase(keyController, 3);
            OS.g_signal_connect(keyController, OS.key_pressed, this.display.keyPressReleaseProc, 89L);
            long focusController = GTK.gtk_event_controller_focus_new();
            GTK.gtk_widget_add_controller(this.shellHandle, focusController);
            OS.g_signal_connect(focusController, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(focusController, OS.leave, this.display.focusProc, 87L);
            long enterLeaveController = GTK.gtk_event_controller_motion_new();
            GTK.gtk_widget_add_controller(this.shellHandle, enterLeaveController);
            long enterMotionAddress = this.display.enterMotionScrollCallback.getAddress();
            OS.g_signal_connect(enterLeaveController, OS.enter, enterMotionAddress, 95L);
            if (this.isCustomResize()) {
                long motionController = GTK.gtk_event_controller_motion_new();
                GTK.gtk_widget_add_controller(this.shellHandle, motionController);
                GTK.gtk_event_controller_set_propagation_phase(motionController, 3);
                OS.g_signal_connect(motionController, OS.motion, enterMotionAddress, 97L);
                long leaveAddress = this.display.leaveCallback.getAddress();
                OS.g_signal_connect(enterLeaveController, OS.leave, leaveAddress, 96L);
            }
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.getClosure(11), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        }
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.getClosure(35), false);
        if (this.isCustomResize() && !GTK.GTK4) {
            int mask = 13060;
            GTK.gtk_widget_add_events(this.shellHandle, mask);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[18], 0, this.display.getClosure(18), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        }
    }

    @Override
    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    boolean isCustomResize() {
        return (this.style & 8) == 0 && (this.style & 0x4010) == 16400;
    }

    @Override
    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean isMappedToPopup() {
        return this.parent != null && (this.parent.style & 0x4000) != 0;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    @Override
    void releaseParent() {
    }

    @Override
    public void requestLayout() {
        this.layout(null, 4);
    }

    @Override
    long topHandle() {
        return this.shellHandle;
    }

    @Override
    long paintHandle() {
        if (GTK.GTK4) {
            return this.handle;
        }
        return super.paintHandle();
    }

    void fixActiveShell() {
        if (this.display.activeShell == this && (this.style & 0x4000) != 0) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shells = this.display.getShells();
                for (int i = 0; i < shells.length; ++i) {
                    if (shells[i] == null || !shells[i].isVisible()) continue;
                    shell = shells[i];
                    break;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell newShell, Control control) {
        String toolTipText;
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((toolTipText = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(newShell, toolTipText);
        }
    }

    @Override
    void fixStyle(long handle) {
    }

    @Override
    void forceResize() {
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, allocation);
        if (!OS.isX11()) {
            int border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
            int boxWidth = this.oldWidth - 2 * border;
            int boxHeight = this.oldHeight - 2 * border;
            if (boxWidth != allocation.width || boxHeight != allocation.height) {
                allocation.width = Math.max(boxWidth, allocation.width);
                allocation.height = Math.max(boxHeight, allocation.height);
            }
        }
        this.forceResize(allocation.width, allocation.height);
    }

    void forceResize(int width, int height) {
        int border;
        int clientWidth = 0;
        if ((this.style & 0x8000000) != 0) {
            clientWidth = this.getClientWidth();
        }
        GtkAllocation allocation = new GtkAllocation();
        allocation.x = border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        allocation.y = border;
        allocation.width = width;
        allocation.height = height;
        GtkRequisition minimumSize = new GtkRequisition();
        GtkRequisition naturalSize = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.vboxHandle, minimumSize, naturalSize);
        if (!OS.isX11()) {
            if (GTK.GTK4) {
                double[] window_offset_x = new double[1];
                double[] window_offset_y = new double[1];
                boolean validTranslation = GTK.gtk_widget_translate_coordinates(this.vboxHandle, this.shellHandle, 0.0, 0.0, window_offset_x, window_offset_y);
                if (validTranslation && !this.isMappedToPopup()) {
                    allocation.x = (int)((double)allocation.x + window_offset_x[0]);
                    allocation.y = (int)((double)allocation.y + window_offset_y[0]);
                }
            } else {
                int[] dest_x = new int[1];
                int[] dest_y = new int[1];
                GTK.gtk_widget_translate_coordinates(this.vboxHandle, this.shellHandle, 0, 0, dest_x, dest_y);
                if (dest_x[0] != -1 && dest_y[0] != -1 && !this.isMappedToPopup()) {
                    allocation.x += dest_x[0];
                    allocation.y += dest_y[0];
                }
            }
        }
        if (GTK.GTK4) {
            GTK.gtk_widget_size_allocate(this.vboxHandle, allocation, -1);
        } else {
            GTK.gtk_widget_size_allocate(this.vboxHandle, allocation);
        }
        if ((this.style & 0x8000000) != 0) {
            this.moveChildren(clientWidth);
        }
    }

    public int getAlpha() {
        boolean composited;
        this.checkWidget();
        if (GTK.GTK4) {
            long display = GDK.gdk_display_get_default();
            composited = GDK.gdk_display_is_composited(display);
        } else {
            long screen = GTK.gtk_widget_get_screen(this.shellHandle);
            composited = GDK.gdk_screen_is_composited(screen);
        }
        if (composited) {
            return (int)(GTK.gtk_widget_get_opacity(this.shellHandle) * 255.0);
        }
        return 255;
    }

    int getResizeMode(double x, double y) {
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.shellHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        int mode = 0;
        if (y >= (double)(height - border)) {
            mode = 11;
            if (x >= (double)(width - border - 16)) {
                mode = 15;
            } else if (x <= (double)(border + 16)) {
                mode = 16;
            }
        } else if (x >= (double)(width - border)) {
            mode = 12;
            if (y >= (double)(height - border - 16)) {
                mode = 15;
            } else if (y <= (double)(border + 16)) {
                mode = 14;
            }
        } else if (y <= (double)border) {
            mode = 10;
            if (x <= (double)(border + 16)) {
                mode = 17;
            } else if (x >= (double)(width - border - 16)) {
                mode = 14;
            }
        } else if (x <= (double)border) {
            mode = 13;
            if (y <= (double)(border + 16)) {
                mode = 17;
            } else if (y >= (double)(height - border - 16)) {
                mode = 16;
            }
        }
        return mode;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    @Override
    Point getLocationInPixels() {
        this.checkWidget();
        if (!this.getVisible() && this.moved) {
            this.setLocationInPixels(this.oldX, this.oldY);
        }
        int[] x = new int[1];
        int[] y = new int[1];
        if (!GTK.GTK4) {
            GTK.gtk_window_get_position(this.shellHandle, x, y);
        }
        return new Point(x[0], y[0]);
    }

    @Override
    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMinimumSizeInPixels());
    }

    Point getMinimumSizeInPixels() {
        this.checkWidget();
        int width = Math.max(1, this.geometry.min_width + this.trimWidth());
        int height = Math.max(1, this.geometry.min_height + this.trimHeight());
        return new Point(width, height);
    }

    public Point getMaximumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMaximumSizeInPixels());
    }

    Point getMaximumSizeInPixels() {
        this.checkWidget();
        int width = Math.min(Integer.MAX_VALUE, this.geometry.max_width + this.trimWidth());
        int height = Math.min(Integer.MAX_VALUE, this.geometry.max_height + this.trimHeight());
        return new Point(width, height);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null && control != modal) {
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    @Override
    Point getSizeInPixels() {
        this.checkWidget();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        return new Point(width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    @Override
    public boolean getVisible() {
        this.checkWidget();
        return GTK.gtk_widget_get_visible(this.shellHandle);
    }

    @Override
    public Region getRegion() {
        this.checkWidget();
        if (this.originalRegion != null) {
            return this.originalRegion;
        }
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    @Override
    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        Shell[] shells;
        this.checkWidget();
        int count = 0;
        Shell[] shellArray = shells = this.display.getShells();
        int n = shellArray.length;
        for (int i = 0; i < n; ++i) {
            Shell activeshell;
            Composite shell = activeshell = shellArray[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell != this) continue;
            ++count;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        Shell[] shellArray2 = shells;
        int n2 = shellArray2.length;
        for (int i = 0; i < n2; ++i) {
            Shell activeshell;
            Composite shell = activeshell = shellArray2[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell != this) continue;
            result[index++] = activeshell;
        }
        return result;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                if (OS.isX11() && (this.style & 0x4000) != 0 && (this.style & 0x80000) == 0) {
                    this.forceActive();
                }
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
                int[] eventButton = new int[1];
                GDK.gdk_event_get_button(event, eventButton);
                if (eventButton[0] == 1) {
                    this.display.resizeLocationX = eventRX[0];
                    this.display.resizeLocationY = eventRY[0];
                    int[] x = new int[1];
                    int[] y = new int[1];
                    GTK.gtk_window_get_position(this.shellHandle, x, y);
                    this.display.resizeBoundsX = x[0];
                    this.display.resizeBoundsY = y[0];
                    GtkAllocation allocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(this.shellHandle, allocation);
                    this.display.resizeBoundsWidth = allocation.width;
                    this.display.resizeBoundsHeight = allocation.height;
                }
            }
            if (this.requiresUngrab()) {
                long seat = GDK.gdk_event_get_seat(event);
                GDK.gdk_seat_ungrab(seat);
                GTK.gtk_grab_remove(this.shellHandle);
            }
            return 0L;
        }
        return super.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_configure_event(long widget, long event) {
        int[] x = new int[1];
        int[] y = new int[1];
        GTK.gtk_window_get_position(this.shellHandle, x, y);
        if (!this.isVisible()) {
            return 0L;
        }
        if (!this.moved || this.oldX != x[0] || this.oldY != y[0]) {
            this.moved = true;
            this.oldX = x[0];
            this.oldY = y[0];
            this.sendEvent(10);
        }
        return 0L;
    }

    @Override
    long gtk_close_request(long widget) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    @Override
    long gtk_delete_event(long widget, long event) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    @Override
    long gtk_enter_notify_event(long widget, long event) {
        if (widget != this.shellHandle) {
            return super.gtk_enter_notify_event(widget, event);
        }
        return 0L;
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] width = new int[1];
                int[] height = new int[1];
                long window = this.gtk_widget_get_window(widget);
                this.gdk_window_get_size(window, width, height);
                int border = this.gtk_container_get_border_width_or_margin(widget);
                long context = GTK.gtk_widget_get_style_context(this.shellHandle);
                GTK.gtk_style_context_save(context);
                GTK.gtk_render_frame(context, cairo, 0.0, 0.0, width[0], border);
                GTK.gtk_render_frame(context, cairo, 0.0, height[0] - border, width[0], border);
                GTK.gtk_render_frame(context, cairo, 0.0, border, border, height[0] - border - border);
                GTK.gtk_render_frame(context, cairo, width[0] - border, border, border, height[0] - border - border);
                GTK.gtk_render_frame(context, cairo, 10.0, 10.0, width[0] - 20, height[0] - 20);
                GTK.gtk_style_context_restore(context);
                return 1L;
            }
            if (GTK.GTK4) {
                super.gtk_draw(widget, cairo);
            }
            return 0L;
        }
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        switch ((int)directionType) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0 || control.getShell() != this) break;
                int traversal = directionType == 0L ? 16 : 8;
                control.traverse(traversal);
                return 1L;
            }
        }
        return super.gtk_focus(widget, directionType);
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_in_event(widget, event);
        }
        this.display.activeShell = this;
        this.display.activePending = false;
        if (!this.ignoreFocusIn) {
            this.sendEvent(26);
        } else {
            this.ignoreFocusIn = false;
        }
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_out_event(widget, event);
        }
        Display display = this.display;
        if (!this.ignoreFocusOut && !this.ignoreFocusOutAfterGrab) {
            this.sendEvent(27);
            this.setActiveControl(null);
        }
        this.ignoreFocusOutAfterGrab = false;
        if (display.activeShell == this && !this.ignoreFocusOut) {
            display.activeShell = null;
            display.activePending = false;
        }
        return 0L;
    }

    @Override
    long gtk_leave_notify_event(long widget, long event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] state = new int[1];
                if (GTK.GTK4) {
                    state[0] = GDK.gdk_event_get_modifier_state(event);
                } else {
                    GDK.gdk_event_get_state(event, state);
                }
                if ((state[0] & 0x100) == 0) {
                    if (GTK.GTK4) {
                        GTK.gtk_widget_set_cursor(this.shellHandle, 0L);
                    } else {
                        long window = this.gtk_widget_get_window(this.shellHandle);
                        GDK.gdk_window_set_cursor(window, 0L);
                    }
                    this.display.resizeMode = 0;
                }
            }
            return 0L;
        }
        return super.gtk_leave_notify_event(widget, event);
    }

    @Override
    long gtk_map(long widget) {
        if (GTK.GTK4) {
            this.mapped = true;
        }
        return super.gtk_map(widget);
    }

    @Override
    long gtk_move_focus(long widget, long directionType) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            long focusHandle = control.focusHandle();
            GTK.gtk_widget_child_focus(focusHandle, (int)directionType);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1L;
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] state = new int[1];
                if (GTK.GTK4) {
                    state[0] = GDK.gdk_event_get_modifier_state(event);
                } else {
                    GDK.gdk_event_get_state(event, state);
                }
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
                if ((state[0] & 0x100) != 0) {
                    int border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
                    int dx = (int)(eventRX[0] - this.display.resizeLocationX);
                    int dy = (int)(eventRY[0] - this.display.resizeLocationY);
                    int x = this.display.resizeBoundsX;
                    int y = this.display.resizeBoundsY;
                    int width = this.display.resizeBoundsWidth;
                    int height = this.display.resizeBoundsHeight;
                    int newWidth = Math.max(width - dx, Math.max(this.geometry.min_width, border + border));
                    int newHeight = Math.max(height - dy, Math.max(this.geometry.min_height, border + border));
                    switch (this.display.resizeMode) {
                        case 13: {
                            x += width - newWidth;
                            width = newWidth;
                            break;
                        }
                        case 17: {
                            x += width - newWidth;
                            width = newWidth;
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 10: {
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 14: {
                            width = Math.max(width + dx, Math.max(this.geometry.min_width, border + border));
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 12: {
                            width = Math.max(width + dx, Math.max(this.geometry.min_width, border + border));
                            break;
                        }
                        case 15: {
                            width = Math.max(width + dx, Math.max(this.geometry.min_width, border + border));
                            height = Math.max(height + dy, Math.max(this.geometry.min_height, border + border));
                            break;
                        }
                        case 11: {
                            height = Math.max(height + dy, Math.max(this.geometry.min_height, border + border));
                            break;
                        }
                        case 16: {
                            x += width - newWidth;
                            width = newWidth;
                            height = Math.max(height + dy, Math.max(this.geometry.min_height, border + border));
                        }
                    }
                    if (x != this.display.resizeBoundsX || y != this.display.resizeBoundsY) {
                        if (!GTK.GTK4) {
                            GDK.gdk_window_move_resize(this.gtk_widget_get_window(this.shellHandle), x, y, width, height);
                        }
                    } else {
                        GTK.gtk_window_resize(this.shellHandle, width, height);
                    }
                } else {
                    double[] eventX = new double[1];
                    double[] eventY = new double[1];
                    if (GTK.GTK4) {
                        GDK.gdk_event_get_position(event, eventX, eventY);
                    } else {
                        GDK.gdk_event_get_coords(event, eventX, eventY);
                    }
                    int mode = this.getResizeMode(eventX[0], eventY[0]);
                    if (mode != this.display.resizeMode) {
                        long cursor = this.display.getSystemCursor((int)mode).handle;
                        if (GTK.GTK4) {
                            GTK.gtk_widget_set_cursor(this.shellHandle, cursor);
                        } else {
                            long window = this.gtk_widget_get_window(this.shellHandle);
                            GDK.gdk_window_set_cursor(window, cursor);
                        }
                        this.display.resizeMode = mode;
                    }
                }
            }
            return 0L;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        if (widget == this.shellHandle) {
            Control focusControl;
            if ((this.state & 0x10) != 0) {
                return 1L;
            }
            if (this.menuBar != null && !this.menuBar.isDisposed() && (focusControl = this.display.getFocusControl()) != null && (focusControl.hooks(1) || focusControl.filters(1))) {
                long[] accel = new long[1];
                long setting = GTK.gtk_settings_get_default();
                OS.g_object_get(setting, GTK.gtk_menu_bar_accel, accel, 0L);
                if (accel[0] != 0L) {
                    int[] keyval = new int[1];
                    int[] mods = new int[1];
                    GTK.gtk_accelerator_parse(accel[0], keyval, mods);
                    OS.g_free(accel[0]);
                    if (keyval[0] != 0) {
                        int[] key = new int[1];
                        int[] state = new int[1];
                        if (GTK.GTK4) {
                            key[0] = GDK.gdk_key_event_get_keyval(event);
                            state[0] = GDK.gdk_event_get_modifier_state(event);
                        } else {
                            GDK.gdk_event_get_keyval(event, key);
                            GDK.gdk_event_get_state(event, state);
                        }
                        int mask = GTK.gtk_accelerator_get_default_mod_mask();
                        if (key[0] == keyval[0] && (state[0] & mask) == (mods[0] & mask)) {
                            return focusControl.gtk_key_press_event(focusControl.focusHandle(), event);
                        }
                    }
                }
            }
            return 0L;
        }
        return super.gtk_key_press_event(widget, event);
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        int[] widthA = new int[1];
        int[] heightA = new int[1];
        if (GTK.GTK4) {
            GTK.gtk_window_get_default_size(this.shellHandle, widthA, heightA);
        } else {
            GTK.gtk_window_get_size(this.shellHandle, widthA, heightA);
        }
        int width = widthA[0];
        int height = heightA[0];
        if (!(this.resized && this.oldWidth == width && this.oldHeight == height || !OS.isX11() && (this.style & 0x10) == 0)) {
            this.oldWidth = width;
            this.oldHeight = height;
            this.resizeBounds(width, height, true);
        }
        return 0L;
    }

    private void updateDecorations(long gdkResource) {
        String gtkCsdValue;
        if (OS.isX11() && (gtkCsdValue = System.getenv("GTK_CSD")) != null && gtkCsdValue.equals("1")) {
            return;
        }
        int decorations = 0;
        int functions = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x80) != 0) {
                decorations |= 0x20;
                functions |= 8;
            }
            if ((this.style & 0x400) != 0) {
                decorations |= 0x40;
                functions |= 0x10;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 4;
                functions |= 2;
            }
            if ((this.style & 0x800) != 0) {
                decorations |= 2;
            }
            if ((this.style & 0x40) != 0) {
                decorations |= 0x10;
            }
            if ((this.style & 0x20) != 0) {
                decorations |= 8;
            }
            if ((this.style & 0x40) != 0) {
                functions |= 0x20;
            }
            if ((this.style & 0x10) != 0) {
                decorations |= 2;
            }
            if ((this.style & 0x800000) == 0) {
                functions |= 4;
            }
        }
        if (!GTK.GTK4) {
            GDK.gdk_window_set_decorations(gdkResource, decorations);
            GDK.gdk_window_set_functions(gdkResource, functions);
        }
    }

    @Override
    long gtk_realize(long widget) {
        long result = super.gtk_realize(widget);
        long gdkResource = GTK.GTK4 ? this.gtk_widget_get_surface(this.shellHandle) : this.gtk_widget_get_window(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            this.updateDecorations(gdkResource);
        } else if ((this.style & 0x800000) != 0 && !GTK.GTK4) {
            GDK.gdk_window_set_functions(gdkResource, 5);
        }
        if ((this.style & 0x4000) != 0 && !GTK.GTK4) {
            GTK.gtk_window_set_keep_above(this.shellHandle, true);
        }
        return result;
    }

    @Override
    long gtk_window_state_event(long widget, long event) {
        GdkEventWindowState gdkEvent = new GdkEventWindowState();
        OS.memmove(gdkEvent, event, (long)GdkEventWindowState.sizeof);
        this.minimized = (gdkEvent.new_window_state & 2) != 0;
        this.maximized = (gdkEvent.new_window_state & 4) != 0;
        boolean bl = this.fullScreen = (gdkEvent.new_window_state & 0x10) != 0;
        if ((gdkEvent.changed_mask & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    @Override
    long notifyState(long object, long arg0) {
        assert (GTK.GTK4);
        int gdkSurfaceState = GDK.gdk_toplevel_get_state(object);
        this.minimized = (gdkSurfaceState & 2) != 0;
        this.maximized = (gdkSurfaceState & 4) != 0;
        boolean bl = this.fullScreen = (gdkSurfaceState & 0x10) != 0;
        if ((gdkSurfaceState & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    public void open() {
        Control focusControl;
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        boolean restored = this.restoreFocus();
        if (!restored) {
            restored = this.traverseGroup(true);
        }
        if (restored && (focusControl = this.display.getFocusControl()) instanceof Button && (focusControl.style & 8) != 0) {
            restored = false;
        }
        if (!restored) {
            if ((this.style & 0x4000) == 0) {
                this.display.focusEvent = 0;
            }
            if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
                this.defaultButton.setFocus();
            } else {
                this.setFocus();
            }
        }
    }

    @Override
    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if (!GTK.GTK4 && OS.isX11()) {
            Rectangle clipping = gc.getClipping();
            long shellWindow = this.gtk_widget_get_window(this.shellHandle);
            GdkRectangle rect = new GdkRectangle();
            GDK.gdk_window_get_frame_extents(shellWindow, rect);
            if (clipping.height < rect.height || clipping.width < rect.width) {
                System.err.println("Warning: the GC provided to Shell.print() has a smaller clipping than what is needed to print the Shell trimmings and content. Only the client area will be printed.");
                return super.print(gc);
            }
            long rootWindow = GDK.gdk_get_default_root_window();
            long pixbuf = GDK.gdk_pixbuf_get_from_window(rootWindow, rect.x, rect.y, rect.width, rect.height);
            if (pixbuf != 0L) {
                GDK.gdk_cairo_set_source_pixbuf(gc.handle, pixbuf, 0.0, 0.0);
                Cairo.cairo_paint(gc.handle);
                OS.g_object_unref(pixbuf);
                return true;
            }
        }
        return false;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    void removeTooTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != toolTip) continue;
            this.toolTips[i] = null;
            return;
        }
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        Shell[] shells = this.getShells();
        for (i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell == null) continue;
            shell.reskin(flags);
        }
        if (this.toolTips != null) {
            for (i = 0; i < this.toolTips.length; ++i) {
                ToolTip toolTip = this.toolTips[i];
                if (toolTip == null) continue;
                toolTip.reskin(flags);
            }
        }
        super.reskinChildren(flags);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int type) {
        int i;
        int index;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int length = Math.min(activate.length, deactivate.length);
        for (index = 0; index < length && activate[index] == deactivate[index]; ++index) {
        }
        for (i = deactivate.length - 1; i >= index; --i) {
            if (deactivate[i].isDisposed()) continue;
            deactivate[i].sendEvent(27);
        }
        for (i = activate.length - 1; i >= index; --i) {
            if (activate[i].isDisposed()) continue;
            Event event = new Event();
            event.detail = type;
            activate[i].sendEvent(26, event);
        }
    }

    public void setAlpha(int alpha) {
        boolean composited;
        this.checkWidget();
        if (GTK.GTK4) {
            long display = GDK.gdk_display_get_default();
            composited = GDK.gdk_display_is_composited(display);
        } else {
            long screen = GTK.gtk_widget_get_screen(this.shellHandle);
            composited = GDK.gdk_screen_is_composited(screen);
        }
        if (composited) {
            GTK.gtk_widget_set_opacity(this.shellHandle, (double)alpha / 255.0);
        }
    }

    void resizeBounds(int width, int height, boolean notify) {
        int border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        if (GTK.GTK4) {
            if (this.parent != null) {
                GtkAllocation allocation = new GtkAllocation();
                allocation.width = width;
                allocation.height = height;
                GTK.gtk_widget_size_allocate(this.shellHandle, allocation, -1);
            }
        } else {
            if (this.redrawWindow != 0L) {
                GDK.gdk_window_resize(this.redrawWindow, width, height);
            }
            if (this.enableWindow != 0L) {
                GDK.gdk_window_resize(this.enableWindow, width, height);
            }
        }
        int boxWidth = width - 2 * border;
        int boxHeight = height - 2 * border;
        if ((this.style & 0x10) == 0) {
            GTK.gtk_widget_set_size_request(this.vboxHandle, boxWidth, boxHeight);
        }
        this.forceResize(boxWidth, boxHeight);
        if (notify) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        width = Math.min(width, Short.MAX_VALUE);
        height = Math.min(height, Short.MAX_VALUE);
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (this.getMaximized()) {
            boolean sameExtent;
            Rectangle rect = this.getBoundsInPixels();
            boolean sameOrigin = !move || rect.x == x && rect.y == y;
            boolean bl = sameExtent = !resize || rect.width == width && rect.height == height;
            if (sameOrigin && sameExtent) {
                return 0;
            }
            this.setMaximized(false);
        }
        int result = 0;
        if (move && !GTK.GTK4) {
            int[] x_pos = new int[1];
            int[] y_pos = new int[1];
            GTK.gtk_window_get_position(this.shellHandle, x_pos, y_pos);
            GTK.gtk_window_move(this.shellHandle, x, y);
            for (int i = 0; i < 1000; ++i) {
                int[] x2_pos = new int[1];
                int[] y2_pos = new int[1];
                GTK.gtk_window_get_position(this.shellHandle, x2_pos, y2_pos);
                if (x2_pos[0] == x && y2_pos[0] == y) break;
            }
            if (x_pos[0] != x || y_pos[0] != y) {
                this.moved = true;
                this.oldX = x;
                this.oldY = y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x80;
            }
        }
        if (resize) {
            boolean changed;
            width = Math.max(1, Math.max(this.geometry.min_width, width - this.trimWidth()));
            if (this.geometry.max_width > 0) {
                width = Math.min(width, this.geometry.max_width);
            }
            height = Math.max(1, Math.max(this.geometry.min_height, height - this.trimHeight()));
            if (this.geometry.max_height > 0) {
                height = Math.min(height, this.geometry.max_height);
            }
            if ((this.style & 0x10) != 0 || this.geometry.min_height != 0 || this.geometry.min_width != 0 || this.geometry.max_height != 0 || this.geometry.max_width != 0) {
                if (GTK.GTK4) {
                    GTK.gtk_window_set_default_size(this.shellHandle, width, height);
                } else {
                    GTK.gtk_window_resize(this.shellHandle, width, height);
                }
            }
            boolean bl = changed = width != this.oldWidth || height != this.oldHeight;
            if (changed) {
                this.oldWidth = width;
                this.oldHeight = height;
                result |= 0x100;
            }
            this.resizeBounds(width, height, changed);
        }
        return result;
    }

    @Override
    void setCursor(long cursor) {
        if (GTK.GTK4) {
            if (this.enableSurface != 0L) {
                GDK.gdk_surface_set_cursor(this.enableSurface, cursor);
            }
        } else if (this.enableWindow != 0L) {
            GDK.gdk_window_set_cursor(this.enableWindow, cursor);
        }
        super.setCursor(cursor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && display.focusEvent != 16) {
            control = display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (GTK.GTK4) {
            if (enabled) {
                if (this.enableSurface != 0L) {
                    this.cleanupEnableSurface();
                }
            } else {
                long parentHandle = this.shellHandle;
                GTK.gtk_widget_realize(parentHandle);
                Rectangle bounds = this.getBoundsInPixels();
                this.enableSurface = GDK.gdk_surface_new_popup(parentHandle, false);
                if (this.enableSurface != 0L) {
                    if (this.cursor != null) {
                        GDK.gdk_surface_set_cursor(this.enableSurface, this.cursor.handle);
                    }
                    GdkRectangle anchor = new GdkRectangle();
                    anchor.width = bounds.width;
                    anchor.height = bounds.height;
                    long layout = GDK.gdk_popup_layout_new(anchor, 1, 1);
                    GDK.gdk_popup_present(this.enableSurface, bounds.width, bounds.height, layout);
                }
            }
        } else if (enabled) {
            if (this.enableWindow != 0L) {
                this.cleanupEnableWindow();
            }
        } else {
            long parentHandle = this.shellHandle;
            GTK.gtk_widget_realize(parentHandle);
            long window = this.gtk_widget_get_window(parentHandle);
            Rectangle rect = this.getBoundsInPixels();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = GDK.gdk_window_new(window, attributes, 0);
            if (this.enableWindow != 0L) {
                if (this.cursor != null) {
                    GDK.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                }
                GDK.gdk_window_set_user_data(this.enableWindow, parentHandle);
                GDK.gdk_window_show(this.enableWindow);
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (enabled && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (fullScreen) {
            GTK.gtk_window_fullscreen(this.shellHandle);
        } else {
            GTK.gtk_window_unfullscreen(this.shellHandle);
            if (this.maximized) {
                this.setMaximized(true);
            }
        }
        this.fullScreen = fullScreen;
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    @Override
    void setInitialBounds() {
        int width = 0;
        int height = 0;
        if ((this.state & 0x400000) != 0) {
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.shellHandle, allocation);
            width = allocation.width;
            height = allocation.height;
        } else {
            GdkRectangle dest = new GdkRectangle();
            if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
                long display = GDK.gdk_display_get_default();
                if (display != 0L) {
                    long monitor = GTK.GTK4 ? GDK.gdk_display_get_monitor_at_surface(display, this.paintSurface()) : GDK.gdk_display_get_monitor_at_window(display, this.paintWindow());
                    GDK.gdk_monitor_get_geometry(monitor, dest);
                    width = dest.width * 5 / 8;
                    height = dest.height * 5 / 8;
                }
            } else {
                long screen = GDK.gdk_screen_get_default();
                if (screen != 0L && GDK.gdk_screen_get_n_monitors(screen) > 1) {
                    int monitorNumber = GDK.gdk_screen_get_monitor_at_window(screen, this.paintWindow());
                    GDK.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
                    width = dest.width * 5 / 8;
                    height = dest.height * 5 / 8;
                }
            }
            if (width == 0 && height == 0 && !GTK.GTK4) {
                width = GDK.gdk_screen_width() * 5 / 8;
                height = GDK.gdk_screen_height() * 5 / 8;
            }
            if ((this.style & 0x10) != 0) {
                if (GTK.GTK4) {
                    GTK.gtk_window_set_default_size(this.shellHandle, width, height);
                } else {
                    GTK.gtk_window_resize(this.shellHandle, width, height);
                }
            }
        }
        this.resizeBounds(width, height, false);
    }

    @Override
    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (maximized) {
            GTK.gtk_window_maximize(this.shellHandle);
        } else {
            GTK.gtk_window_unmaximize(this.shellHandle);
        }
    }

    @Override
    public void setMenuBar(Menu menu) {
        long menuHandle;
        boolean both;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl = both = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            menuHandle = this.menuBar.handle;
            GTK.gtk_widget_hide(menuHandle);
            if (!GTK.GTK4) {
                this.destroyAccelGroup();
            }
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            menuHandle = menu.handle;
            GTK.gtk_widget_show(menuHandle);
            if (!GTK.GTK4) {
                this.createAccelGroup();
                this.menuBar.addAccelerators(this.accelGroup);
            }
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        this.resizeBounds(width, height, !both);
    }

    @Override
    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (!GTK.gtk_widget_get_visible(this.shellHandle)) {
            GTK.gtk_widget_show(this.shellHandle);
        }
        if (minimized) {
            if (GTK.GTK4) {
                GTK.gtk_window_minimize(this.shellHandle);
            } else {
                GTK.gtk_window_iconify(this.shellHandle);
            }
        } else {
            if (GTK.GTK4) {
                GTK.gtk_window_unminimize(this.shellHandle);
            } else {
                GTK.gtk_window_deiconify(this.shellHandle);
            }
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        this.setMinimumSize(new Point(width, height));
    }

    void setMinimumSizeInPixels(int width, int height) {
        this.checkWidget();
        this.geometry.min_width = Math.max(width, this.trimWidth()) - this.trimWidth();
        this.geometry.min_height = Math.max(height, this.trimHeight()) - this.trimHeight();
        int hint = 2;
        if (this.geometry.max_height > 0 || this.geometry.max_width > 0) {
            hint |= 4;
        }
        GTK.gtk_window_set_geometry_hints(this.shellHandle, 0L, this.geometry, hint);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        this.setMinimumSizeInPixels(DPIUtil.autoScaleUp(size));
    }

    void setMinimumSizeInPixels(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSizeInPixels(size.x, size.y);
    }

    public void setMaximumSize(int width, int height) {
        this.checkWidget();
        this.setMaximumSize(new Point(width, height));
    }

    public void setMaximumSize(Point size) {
        this.checkWidget();
        this.setMaximumSizeInPixels(DPIUtil.autoScaleUp(size));
    }

    void setMaximumSizeInPixels(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMaximumSizeInPixels(size.x, size.y);
    }

    void setMaximumSizeInPixels(int width, int height) {
        this.checkWidget();
        this.geometry.max_width = Math.max(width, this.trimWidth()) - this.trimWidth();
        this.geometry.max_height = Math.max(height, this.trimHeight()) - this.trimHeight();
        int hint = 4;
        if (this.geometry.min_width > 0 || this.geometry.min_height > 0) {
            hint |= 2;
        }
        GTK.gtk_window_set_geometry_hints(this.shellHandle, 0L, this.geometry, hint);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    @Override
    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null) {
            Rectangle bounds = region.getBounds();
            this.setSize(bounds.x + bounds.width, bounds.y + bounds.height);
        }
        Region regionToDispose = null;
        if ((this.style & 0x4000000) != 0) {
            if (this.originalRegion != null) {
                regionToDispose = this.region;
            }
            this.originalRegion = region;
            region = Shell.mirrorRegion(region);
        } else {
            this.originalRegion = null;
        }
        super.setRegion(region);
        if (regionToDispose != null) {
            regionToDispose.dispose();
        }
    }

    static void gdk_region_get_rectangles(long region, long[] rectangles, int[] n_rectangles) {
        int num = Cairo.cairo_region_num_rectangles(region);
        if (n_rectangles != null) {
            n_rectangles[0] = num;
        }
        rectangles[0] = OS.g_malloc(GdkRectangle.sizeof * num);
        for (int n = 0; n < num; ++n) {
            Cairo.cairo_region_get_rectangle(region, n, rectangles[0] + (long)(n * GdkRectangle.sizeof));
        }
    }

    static Region mirrorRegion(Region region) {
        if (region == null) {
            return null;
        }
        Region mirrored = new Region(region.getDevice());
        long rgn = region.handle;
        int[] nRects = new int[1];
        long[] rects = new long[1];
        Shell.gdk_region_get_rectangles(rgn, rects, nRects);
        Rectangle bounds = DPIUtil.autoScaleUp(region.getBounds());
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        for (int i = 0; i < nRects[0]; ++i) {
            Cairo.memmove(rect, rects[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            rect.x = bounds.x + bounds.width - rect.x - rect.width;
            Cairo.cairo_region_union_rectangle(mirrored.handle, rect);
        }
        if (rects[0] != 0L) {
            OS.g_free(rects[0]);
        }
        return mirrored;
    }

    @Override
    void setRelations() {
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        int length = string.length();
        char[] chars = new char[Math.max(6, length) + 1];
        string.getChars(0, length, chars, 0);
        for (int i = length; i < chars.length; ++i) {
            chars[i] = 32;
        }
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_window_set_title(this.shellHandle, buffer);
    }

    @Override
    public void setVisible(boolean visible) {
        int mask;
        this.checkWidget();
        if (this.moved) {
            this.setLocationInPixels(this.oldX, this.oldY);
        }
        if ((this.style & (mask = 229376)) != 0) {
            if (visible) {
                this.display.setModalShell(this);
                GTK.gtk_window_set_modal(this.shellHandle, true);
            } else {
                this.display.clearModal(this);
                GTK.gtk_window_set_modal(this.shellHandle, false);
            }
            if (this.parent != null && this.parent.getShell().getFullScreen()) {
                GTK.gtk_window_set_type_hint(this.shellHandle, 1);
            }
        } else {
            this.updateModal();
        }
        this.showWithParent = visible;
        if (GTK.gtk_widget_get_mapped(this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            if (this.oldWidth == 0 && this.oldHeight == 0) {
                int[] init_width = new int[1];
                int[] init_height = new int[1];
                GTK.gtk_window_get_size(this.shellHandle, init_width, init_height);
                GTK.gtk_window_resize(this.shellHandle, 1, 1);
                GTK.gtk_widget_show(this.shellHandle);
                GTK.gtk_window_resize(this.shellHandle, init_width[0], init_height[0]);
                this.resizeBounds(init_width[0], init_height[0], false);
            } else {
                GTK.gtk_widget_show(this.shellHandle);
            }
            if (GTK.GTK4) {
                if (this.enableSurface != 0L) {
                    int width = GDK.gdk_surface_get_width(this.enableSurface);
                    int height = GDK.gdk_surface_get_height(this.enableSurface);
                    long layout = GDK.gdk_toplevel_layout_new(this.geometry.min_width, this.geometry.min_height);
                    GDK.gdk_toplevel_present(this.enableSurface, width, height, layout);
                }
            } else if (this.enableWindow != 0L) {
                GDK.gdk_window_raise(this.enableWindow);
            }
            if (this.isDisposed()) {
                return;
            }
            if (!OS.isX11() || !GTK.GTK_IS_PLUG(this.shellHandle)) {
                Shell shell;
                this.display.dispatchEvents = GTK.GTK4 ? new int[]{3, 11, 12, 13, 14} : new int[]{2, 12, 13, 14, 15, 30, 32};
                Display display = this.display;
                display.putGdkEvents();
                boolean iconic = false;
                Shell shell2 = shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    if (!GTK.GTK4) {
                        GDK.gdk_threads_leave();
                    }
                    OS.g_main_context_iteration(0L, false);
                    if (this.isDisposed()) break;
                    boolean bl = iconic = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !iconic);
                display.dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!iconic) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            if ((this.style & mask) != 0) {
                this.gdk_pointer_ungrab(GTK.gtk_widget_get_window(this.shellHandle), 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocationInPixels();
                this.oldX = location.x;
                this.oldY = location.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSizeInPixels();
                this.oldWidth = size.x - this.trimWidth();
                this.oldHeight = size.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            this.checkAndUngrabFocus();
            GTK.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    @Override
    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        if (this.mapped) {
            this.setZOrder(sibling, above, false, false);
        }
    }

    @Override
    long shellMapProc(long handle, long arg0, long user_data) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0L;
    }

    @Override
    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            if (GTK.gtk_window_is_active(this.shellHandle)) {
                this.display.activeShell = this;
                this.display.activePending = true;
            }
            if (GTK.GTK4) {
                long child = GTK.gtk_widget_get_first_child(this.shellHandle);
                while (child != 0L) {
                    GTK.gtk_widget_unparent(child);
                    child = GTK.gtk_widget_get_next_sibling(child);
                }
            } else {
                long list = GTK.gtk_container_get_children(this.shellHandle);
                while (list != 0L) {
                    GTK.gtk_container_remove(this.shellHandle, OS.g_list_data(list));
                    list = OS.g_list_next(list);
                }
                OS.g_list_free(list);
            }
        }
        if (GTK.GTK4) {
            GTK.gtk_window_set_child(this.shellHandle, this.vboxHandle);
        } else {
            GTK.gtk_container_add(this.shellHandle, this.vboxHandle);
        }
        if (this.scrolledHandle != 0L) {
            GTK.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0L) {
            GTK.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0L) {
            GTK.gtk_widget_show(this.vboxHandle);
        }
    }

    @Override
    long sizeAllocateProc(long handle, long arg0, long user_data) {
        int offset = 16;
        int[] x = new int[1];
        int[] y = new int[1];
        if (GTK.GTK4) {
            double[] xDouble = new double[1];
            double[] yDouble = new double[1];
            this.display.getPointerPosition(xDouble, yDouble);
            x[0] = (int)xDouble[0];
            y[0] = (int)yDouble[0];
        } else {
            this.display.getWindowPointerPosition(0L, x, y, null);
        }
        y[0] = y[0] + offset;
        GdkRectangle dest = new GdkRectangle();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            long display = GDK.gdk_display_get_default();
            long monitor = GDK.gdk_display_get_monitor_at_point(display, x[0], y[0]);
            GDK.gdk_monitor_get_geometry(monitor, dest);
        } else {
            long screen = GDK.gdk_screen_get_default();
            if (screen != 0L) {
                int monitorNumber = GDK.gdk_screen_get_monitor_at_point(screen, x[0], y[0]);
                GDK.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
            }
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(handle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        if (x[0] + width > dest.x + dest.width) {
            x[0] = dest.x + dest.width - width;
        }
        if (y[0] + height > dest.y + dest.height) {
            y[0] = dest.y + dest.height - height;
        }
        GTK.gtk_window_move(handle, x[0], y[0]);
        return 0L;
    }

    @Override
    long sizeRequestProc(long handle, long arg0, long user_data) {
        GTK.gtk_widget_hide(handle);
        return 0L;
    }

    @Override
    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        if (this.isCustomResize()) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.trimHeights[4];
            }
            if (hasBorder) {
                return this.display.trimHeights[3];
            }
            return this.display.trimHeights[5];
        }
        if (hasResize) {
            return this.display.trimHeights[2];
        }
        if (hasBorder) {
            return this.display.trimHeights[1];
        }
        return this.display.trimHeights[0];
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        if (this.isCustomResize()) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.trimWidths[4];
            }
            if (hasBorder) {
                return this.display.trimWidths[3];
            }
            return this.display.trimWidths[5];
        }
        if (hasResize) {
            return this.display.trimWidths[2];
        }
        if (hasBorder) {
            return this.display.trimWidths[1];
        }
        return this.display.trimWidths[0];
    }

    void updateModal() {
        if (OS.isX11() && GTK.GTK_IS_PLUG(this.shellHandle)) {
            return;
        }
        long group = 0L;
        boolean isModalShell = false;
        if (this.display.getModalDialog() == null) {
            Shell modal = this.getModalShell();
            int mask = 229376;
            Composite shell = null;
            if (modal == null) {
                if ((this.style & mask) != 0) {
                    shell = this;
                    isModalShell = GTK.gtk_window_get_modal(this.shellHandle);
                    if (isModalShell) {
                        GTK.gtk_window_set_modal(this.shellHandle, false);
                    }
                }
            } else {
                shell = modal;
            }
            Shell topModalShell = shell;
            while (shell != null) {
                if ((shell.style & mask) == 0) {
                    group = shell.getShell().group;
                    break;
                }
                topModalShell = shell;
                shell = shell.parent;
            }
            if (group == 0L && topModalShell != null) {
                group = topModalShell.getShell().group;
            }
        }
        if (group == 0L) {
            group = GTK.gtk_window_get_group(0L);
        }
        if (group != 0L) {
            GTK.gtk_window_group_add_window(group, this.shellHandle);
            if (isModalShell) {
                GTK.gtk_window_set_modal(this.shellHandle, true);
            }
        } else if (this.modalGroup != 0L) {
            GTK.gtk_window_group_remove_window(this.modalGroup, this.shellHandle);
        }
        this.modalGroup = group;
    }

    void updateMinimized(boolean minimized) {
        Shell[] shells = this.getShells();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell;
            boolean update = false;
            for (shell = shells[i]; shell != null && shell != this && !shell.isUndecorated(); shell = (Shell)shell.getParent()) {
            }
            if (shell != null && shell != this) {
                update = true;
            }
            if (!update) continue;
            if (minimized) {
                if (!shells[i].isVisible()) continue;
                shells[i].showWithParent = true;
                GTK.gtk_widget_hide(shells[i].shellHandle);
                continue;
            }
            if (!shells[i].showWithParent) continue;
            shells[i].showWithParent = false;
            GTK.gtk_widget_show(shells[i].shellHandle);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        Widget disposed = this.display.removeWidget(this.shellHandle);
        if (this.shellHandle != 0L && !(disposed instanceof Shell)) {
            SWT.error(51, null, ". Wrong widgetTable entry: " + disposed + " removed for shell: " + this + this.display.dumpWidgetTableInfo());
        }
        if (Display.strictChecks) {
            Shell[] shells;
            for (Shell shell : shells = this.display.getShells()) {
                if (shell != this) continue;
                SWT.error(51, null, ". Disposed shell still in the widgetTable: " + this + this.display.dumpWidgetTableInfo());
            }
        }
    }

    boolean requiresUngrab() {
        return !OS.isX11() && (this.style & 0x4000) != 0 && (this.style & 0x80000) == 0;
    }

    void checkAndUngrabFocus() {
        if (this.requiresUngrab() && !this.isMappedToPopup() && this.grabbedFocus) {
            long display;
            if (GTK.GTK4) {
                long gdkResource = this.gtk_widget_get_surface(this.shellHandle);
                display = GDK.gdk_surface_get_display(gdkResource);
            } else {
                long gdkResource = this.gtk_widget_get_window(this.shellHandle);
                display = GDK.gdk_window_get_display(gdkResource);
            }
            long seat = GDK.gdk_display_get_default_seat(display);
            GDK.gdk_seat_ungrab(seat);
            GTK.gtk_grab_remove(this.shellHandle);
            this.grabbedFocus = false;
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        this.checkAndUngrabFocus();
        if (this.popupChild != null && this.popupChild.shellHandle != 0L && !this.popupChild.isDisposed()) {
            this.popupChild.dispose();
        }
        GTK.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    @Override
    Rectangle getBoundsInPixels() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        if ((this.state & 0x200000) == 0) {
            if (!GTK.GTK4) {
                GTK.gtk_window_get_position(this.shellHandle, x, y);
            }
        } else if (!GTK.GTK4) {
            GDK.gdk_window_get_root_origin(GTK.gtk_widget_get_window(this.shellHandle), x, y);
        }
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            border = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        return new Rectangle(x[0], y[0], width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0L;
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i;
        Shell[] shells = this.getShells();
        for (i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell == null || shell.isDisposed()) continue;
            shell.release(false);
        }
        if (this.toolTips != null) {
            for (i = 0; i < this.toolTips.length; ++i) {
                ToolTip toolTip = this.toolTips[i];
                if (toolTip == null || toolTip.isDisposed()) continue;
                toolTip.dispose();
            }
            this.toolTips = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        Region regionToDispose = null;
        if (this.originalRegion != null) {
            regionToDispose = this.region;
        }
        super.releaseWidget();
        this.destroyAccelGroup();
        this.display.clearModal(this);
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.group != 0L) {
            OS.g_object_unref(this.group);
        }
        this.modalGroup = 0L;
        this.group = 0L;
        this.lastActive = null;
        if (regionToDispose != null) {
            regionToDispose.dispose();
        }
    }

    void setToolTipText(long tipWidget, String string) {
        byte[] buffer = null;
        if (string != null && !string.isEmpty()) {
            char[] chars = this.fixMnemonic(string, false, true);
            buffer = Converter.wcsToMbcs(chars, true);
        }
        GTK.gtk_widget_set_tooltip_text(tipWidget, buffer);
    }

    @Override
    Point getWindowOrigin() {
        if (!this.mapped) {
            return this.getLocationInPixels();
        }
        return super.getWindowOrigin();
    }

    @Override
    Point getSurfaceOrigin() {
        if (!this.mapped) {
            return this.getLocationInPixels();
        }
        return super.getSurfaceOrigin();
    }
}

