package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRuleList invokes the aegis.DescribeRuleList API synchronously
// api document: https://help.aliyun.com/api/aegis/describerulelist.html
func (client *Client) DescribeRuleList(request *DescribeRuleListRequest) (response *DescribeRuleListResponse, err error) {
	response = CreateDescribeRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRuleListWithChan invokes the aegis.DescribeRuleList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describerulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRuleListWithChan(request *DescribeRuleListRequest) (<-chan *DescribeRuleListResponse, <-chan error) {
	responseChan := make(chan *DescribeRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRuleListWithCallback invokes the aegis.DescribeRuleList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describerulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRuleListWithCallback(request *DescribeRuleListRequest, callback func(response *DescribeRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRuleListResponse
		var err error
		defer close(result)
		response, err = client.DescribeRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRuleListRequest is the request struct for api DescribeRuleList
type DescribeRuleListRequest struct {
	*requests.RpcRequest
	WarnLevel   string           `position:"Query" name:"WarnLevel"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Remark      string           `position:"Query" name:"Remark"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Id          requests.Integer `position:"Query" name:"Id"`
	Lang        string           `position:"Query" name:"Lang"`
	ExGroupId   string           `position:"Query" name:"ExGroupId"`
}

// DescribeRuleListResponse is the response struct for api DescribeRuleList
type DescribeRuleListResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Success   bool        `json:"Success" xml:"Success"`
	PageInfo  PageInfo    `json:"PageInfo" xml:"PageInfo"`
	Rules     []RulesItem `json:"Rules" xml:"Rules"`
}

// CreateDescribeRuleListRequest creates a request to invoke DescribeRuleList API
func CreateDescribeRuleListRequest() (request *DescribeRuleListRequest) {
	request = &DescribeRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeRuleList", "vipaegis", "openAPI")
	return
}

// CreateDescribeRuleListResponse creates a response to parse from DescribeRuleList response
func CreateDescribeRuleListResponse() (response *DescribeRuleListResponse) {
	response = &DescribeRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
