package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenVbrHealthCheck invokes the cbn.DescribeCenVbrHealthCheck API synchronously
func (client *Client) DescribeCenVbrHealthCheck(request *DescribeCenVbrHealthCheckRequest) (response *DescribeCenVbrHealthCheckResponse, err error) {
	response = CreateDescribeCenVbrHealthCheckResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenVbrHealthCheckWithChan invokes the cbn.DescribeCenVbrHealthCheck API asynchronously
func (client *Client) DescribeCenVbrHealthCheckWithChan(request *DescribeCenVbrHealthCheckRequest) (<-chan *DescribeCenVbrHealthCheckResponse, <-chan error) {
	responseChan := make(chan *DescribeCenVbrHealthCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenVbrHealthCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenVbrHealthCheckWithCallback invokes the cbn.DescribeCenVbrHealthCheck API asynchronously
func (client *Client) DescribeCenVbrHealthCheckWithCallback(request *DescribeCenVbrHealthCheckRequest, callback func(response *DescribeCenVbrHealthCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenVbrHealthCheckResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenVbrHealthCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenVbrHealthCheckRequest is the request struct for api DescribeCenVbrHealthCheck
type DescribeCenVbrHealthCheckRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	VbrInstanceOwnerId   requests.Integer `position:"Query" name:"VbrInstanceOwnerId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	VbrInstanceRegionId  string           `position:"Query" name:"VbrInstanceRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VbrInstanceId        string           `position:"Query" name:"VbrInstanceId"`
}

// DescribeCenVbrHealthCheckResponse is the response struct for api DescribeCenVbrHealthCheck
type DescribeCenVbrHealthCheckResponse struct {
	*responses.BaseResponse
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	PageNumber      int             `json:"PageNumber" xml:"PageNumber"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	VbrHealthChecks VbrHealthChecks `json:"VbrHealthChecks" xml:"VbrHealthChecks"`
}

// CreateDescribeCenVbrHealthCheckRequest creates a request to invoke DescribeCenVbrHealthCheck API
func CreateDescribeCenVbrHealthCheckRequest() (request *DescribeCenVbrHealthCheckRequest) {
	request = &DescribeCenVbrHealthCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenVbrHealthCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCenVbrHealthCheckResponse creates a response to parse from DescribeCenVbrHealthCheck response
func CreateDescribeCenVbrHealthCheckResponse() (response *DescribeCenVbrHealthCheckResponse) {
	response = &DescribeCenVbrHealthCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
