package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProjectMember invokes the dataworks_public.DeleteProjectMember API synchronously
func (client *Client) DeleteProjectMember(request *DeleteProjectMemberRequest) (response *DeleteProjectMemberResponse, err error) {
	response = CreateDeleteProjectMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProjectMemberWithChan invokes the dataworks_public.DeleteProjectMember API asynchronously
func (client *Client) DeleteProjectMemberWithChan(request *DeleteProjectMemberRequest) (<-chan *DeleteProjectMemberResponse, <-chan error) {
	responseChan := make(chan *DeleteProjectMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProjectMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProjectMemberWithCallback invokes the dataworks_public.DeleteProjectMember API asynchronously
func (client *Client) DeleteProjectMemberWithCallback(request *DeleteProjectMemberRequest, callback func(response *DeleteProjectMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProjectMemberResponse
		var err error
		defer close(result)
		response, err = client.DeleteProjectMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProjectMemberRequest is the request struct for api DeleteProjectMember
type DeleteProjectMemberRequest struct {
	*requests.RpcRequest
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
	UserId    string           `position:"Query" name:"UserId"`
}

// DeleteProjectMemberResponse is the response struct for api DeleteProjectMember
type DeleteProjectMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProjectMemberRequest creates a request to invoke DeleteProjectMember API
func CreateDeleteProjectMemberRequest() (request *DeleteProjectMemberRequest) {
	request = &DeleteProjectMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteProjectMember", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProjectMemberResponse creates a response to parse from DeleteProjectMember response
func CreateDeleteProjectMemberResponse() (response *DeleteProjectMemberResponse) {
	response = &DeleteProjectMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
