package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIDEEventResult invokes the dataworks_public.UpdateIDEEventResult API synchronously
func (client *Client) UpdateIDEEventResult(request *UpdateIDEEventResultRequest) (response *UpdateIDEEventResultResponse, err error) {
	response = CreateUpdateIDEEventResultResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIDEEventResultWithChan invokes the dataworks_public.UpdateIDEEventResult API asynchronously
func (client *Client) UpdateIDEEventResultWithChan(request *UpdateIDEEventResultRequest) (<-chan *UpdateIDEEventResultResponse, <-chan error) {
	responseChan := make(chan *UpdateIDEEventResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIDEEventResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIDEEventResultWithCallback invokes the dataworks_public.UpdateIDEEventResult API asynchronously
func (client *Client) UpdateIDEEventResultWithCallback(request *UpdateIDEEventResultRequest, callback func(response *UpdateIDEEventResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIDEEventResultResponse
		var err error
		defer close(result)
		response, err = client.UpdateIDEEventResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIDEEventResultRequest is the request struct for api UpdateIDEEventResult
type UpdateIDEEventResultRequest struct {
	*requests.RpcRequest
	CheckResultTip string `position:"Body" name:"CheckResultTip"`
	CheckResult    string `position:"Body" name:"CheckResult"`
	MessageId      string `position:"Body" name:"MessageId"`
	ExtensionCode  string `position:"Body" name:"ExtensionCode"`
}

// UpdateIDEEventResultResponse is the response struct for api UpdateIDEEventResult
type UpdateIDEEventResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateIDEEventResultRequest creates a request to invoke UpdateIDEEventResult API
func CreateUpdateIDEEventResultRequest() (request *UpdateIDEEventResultRequest) {
	request = &UpdateIDEEventResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateIDEEventResult", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateIDEEventResultResponse creates a response to parse from UpdateIDEEventResult response
func CreateUpdateIDEEventResultResponse() (response *UpdateIDEEventResultResponse) {
	response = &UpdateIDEEventResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
