package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySingleDomainApiAvgDurationGroupTrend invokes the emas_appmonitor.QuerySingleDomainApiAvgDurationGroupTrend API synchronously
func (client *Client) QuerySingleDomainApiAvgDurationGroupTrend(request *QuerySingleDomainApiAvgDurationGroupTrendRequest) (response *QuerySingleDomainApiAvgDurationGroupTrendResponse, err error) {
	response = CreateQuerySingleDomainApiAvgDurationGroupTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySingleDomainApiAvgDurationGroupTrendWithChan invokes the emas_appmonitor.QuerySingleDomainApiAvgDurationGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiAvgDurationGroupTrendWithChan(request *QuerySingleDomainApiAvgDurationGroupTrendRequest) (<-chan *QuerySingleDomainApiAvgDurationGroupTrendResponse, <-chan error) {
	responseChan := make(chan *QuerySingleDomainApiAvgDurationGroupTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySingleDomainApiAvgDurationGroupTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySingleDomainApiAvgDurationGroupTrendWithCallback invokes the emas_appmonitor.QuerySingleDomainApiAvgDurationGroupTrend API asynchronously
func (client *Client) QuerySingleDomainApiAvgDurationGroupTrendWithCallback(request *QuerySingleDomainApiAvgDurationGroupTrendRequest, callback func(response *QuerySingleDomainApiAvgDurationGroupTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySingleDomainApiAvgDurationGroupTrendResponse
		var err error
		defer close(result)
		response, err = client.QuerySingleDomainApiAvgDurationGroupTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySingleDomainApiAvgDurationGroupTrendRequest is the request struct for api QuerySingleDomainApiAvgDurationGroupTrend
type QuerySingleDomainApiAvgDurationGroupTrendRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Group              string           `position:"Body" name:"Group"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
	Domain             string           `position:"Body" name:"Domain"`
}

// QuerySingleDomainApiAvgDurationGroupTrendResponse is the response struct for api QuerySingleDomainApiAvgDurationGroupTrend
type QuerySingleDomainApiAvgDurationGroupTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQuerySingleDomainApiAvgDurationGroupTrendRequest creates a request to invoke QuerySingleDomainApiAvgDurationGroupTrend API
func CreateQuerySingleDomainApiAvgDurationGroupTrendRequest() (request *QuerySingleDomainApiAvgDurationGroupTrendRequest) {
	request = &QuerySingleDomainApiAvgDurationGroupTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QuerySingleDomainApiAvgDurationGroupTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySingleDomainApiAvgDurationGroupTrendResponse creates a response to parse from QuerySingleDomainApiAvgDurationGroupTrend response
func CreateQuerySingleDomainApiAvgDurationGroupTrendResponse() (response *QuerySingleDomainApiAvgDurationGroupTrendResponse) {
	response = &QuerySingleDomainApiAvgDurationGroupTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
