package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckQuota invokes the ens.CheckQuota API synchronously
func (client *Client) CheckQuota(request *CheckQuotaRequest) (response *CheckQuotaResponse, err error) {
	response = CreateCheckQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// CheckQuotaWithChan invokes the ens.CheckQuota API asynchronously
func (client *Client) CheckQuotaWithChan(request *CheckQuotaRequest) (<-chan *CheckQuotaResponse, <-chan error) {
	responseChan := make(chan *CheckQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckQuotaWithCallback invokes the ens.CheckQuota API asynchronously
func (client *Client) CheckQuotaWithCallback(request *CheckQuotaRequest, callback func(response *CheckQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckQuotaResponse
		var err error
		defer close(result)
		response, err = client.CheckQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckQuotaRequest is the request struct for api CheckQuota
type CheckQuotaRequest struct {
	*requests.RpcRequest
	GroupUuid         string           `position:"Query" name:"GroupUuid"`
	ResourceAttribute string           `position:"Body" name:"ResourceAttribute"`
	AliUid            requests.Integer `position:"Query" name:"AliUid"`
}

// CheckQuotaResponse is the response struct for api CheckQuota
type CheckQuotaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Msg       string `json:"Msg" xml:"Msg"`
	Desc      string `json:"Desc" xml:"Desc"`
}

// CreateCheckQuotaRequest creates a request to invoke CheckQuota API
func CreateCheckQuotaRequest() (request *CheckQuotaRequest) {
	request = &CheckQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CheckQuota", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckQuotaResponse creates a response to parse from CheckQuota response
func CreateCheckQuotaResponse() (response *CheckQuotaResponse) {
	response = &CheckQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
