/**
# Copyright 2024 NVIDIA CORPORATION
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
**/

// WARNING: THIS FILE WAS AUTOMATICALLY GENERATED.
// Code generated by https://git.io/c-for-go. DO NOT EDIT.

package nvsandboxutils

/*
#cgo linux LDFLAGS: -Wl,--export-dynamic -Wl,--unresolved-symbols=ignore-in-object-files
#cgo darwin LDFLAGS: -Wl,-undefined,dynamic_lookup
#include "nvsandboxutils.h"
#include <stdlib.h>
#include "cgo_helpers.h"
*/
import "C"

const (
	// INPUT_LENGTH as defined in nvsandboxutils/nvsandboxutils.h
	INPUT_LENGTH = 256
	// MAX_FILE_PATH as defined in nvsandboxutils/nvsandboxutils.h
	MAX_FILE_PATH = 256
	// MAX_NAME_LENGTH as defined in nvsandboxutils/nvsandboxutils.h
	MAX_NAME_LENGTH = 256
)

// Ret as declared in nvsandboxutils/nvsandboxutils.h
type Ret int32

// Ret enumeration from nvsandboxutils/nvsandboxutils.h
const (
	SUCCESS                     Ret = iota
	ERROR_UNINITIALIZED         Ret = 1
	ERROR_NOT_SUPPORTED         Ret = 2
	ERROR_INVALID_ARG           Ret = 3
	ERROR_INSUFFICIENT_SIZE     Ret = 4
	ERROR_VERSION_NOT_SUPPORTED Ret = 5
	ERROR_LIBRARY_LOAD          Ret = 6
	ERROR_FUNCTION_NOT_FOUND    Ret = 7
	ERROR_DEVICE_NOT_FOUND      Ret = 8
	ERROR_NVML_LIB_CALL         Ret = 9
	ERROR_OUT_OF_MEMORY         Ret = 10
	ERROR_FILEPATH_NOT_FOUND    Ret = 11
	ERROR_UNKNOWN               Ret = 65535
)

// LogLevel as declared in nvsandboxutils/nvsandboxutils.h
type LogLevel int32

// LogLevel enumeration from nvsandboxutils/nvsandboxutils.h
const (
	LOG_LEVEL_FATAL LogLevel = iota
	LOG_LEVEL_ERROR LogLevel = 1
	LOG_LEVEL_WARN  LogLevel = 2
	LOG_LEVEL_DEBUG LogLevel = 3
	LOG_LEVEL_INFO  LogLevel = 4
	LOG_LEVEL_NONE  LogLevel = 65535
)

// RootfsInputType as declared in nvsandboxutils/nvsandboxutils.h
type RootfsInputType int32

// RootfsInputType enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_ROOTFS_DEFAULT RootfsInputType = iota
	NV_ROOTFS_PATH    RootfsInputType = 1
	NV_ROOTFS_PID     RootfsInputType = 2
)

// FileType as declared in nvsandboxutils/nvsandboxutils.h
type FileType int32

// FileType enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_DEV  FileType = iota
	NV_PROC FileType = 1
	NV_SYS  FileType = 2
)

// FileSystemSubType as declared in nvsandboxutils/nvsandboxutils.h
type FileSystemSubType int32

// FileSystemSubType enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_DEV_NVIDIA                                         FileSystemSubType = iota
	NV_DEV_DRI_CARD                                       FileSystemSubType = 1
	NV_DEV_DRI_RENDERD                                    FileSystemSubType = 2
	NV_DEV_DRI_CARD_SYMLINK                               FileSystemSubType = 3
	NV_DEV_DRI_RENDERD_SYMLINK                            FileSystemSubType = 4
	NV_DEV_NVIDIA_UVM                                     FileSystemSubType = 5
	NV_DEV_NVIDIA_UVM_TOOLS                               FileSystemSubType = 6
	NV_DEV_NVIDIA_MODESET                                 FileSystemSubType = 7
	NV_DEV_NVIDIA_CTL                                     FileSystemSubType = 8
	NV_DEV_GDRDRV                                         FileSystemSubType = 9
	NV_DEV_NVIDIA_CAPS_NVIDIA_CAP                         FileSystemSubType = 10
	NV_PROC_DRIVER_NVIDIA_GPUS_PCIBUSID                   FileSystemSubType = 11
	NV_PROC_DRIVER_NVIDIA_GPUS                            FileSystemSubType = 12
	NV_PROC_NVIDIA_PARAMS                                 FileSystemSubType = 13
	NV_PROC_NVIDIA_CAPS_MIG_MINORS                        FileSystemSubType = 14
	NV_PROC_DRIVER_NVIDIA_CAPABILITIES_GPU                FileSystemSubType = 15
	NV_PROC_DRIVER_NVIDIA_CAPABILITIES                    FileSystemSubType = 16
	NV_PROC_DRIVER_NVIDIA_CAPABILITIIES_GPU_MIG_CI_ACCESS FileSystemSubType = 17
	NV_SYS_MODULE_NVIDIA_DRIVER_PCIBUSID                  FileSystemSubType = 18
	NV_SYS_MODULE_NVIDIA_DRIVER                           FileSystemSubType = 19
	NV_NUM_SUBTYPE                                        FileSystemSubType = 20
)

// FileModule as declared in nvsandboxutils/nvsandboxutils.h
type FileModule int32

// FileModule enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_GPU                   FileModule = iota
	NV_MIG                   FileModule = 1
	NV_DRIVER_NVIDIA         FileModule = 2
	NV_DRIVER_NVIDIA_UVM     FileModule = 3
	NV_DRIVER_NVIDIA_MODESET FileModule = 4
	NV_DRIVER_GDRDRV         FileModule = 5
	NV_SYSTEM                FileModule = 6
)

// FileFlag as declared in nvsandboxutils/nvsandboxutils.h
type FileFlag int32

// FileFlag enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_FILE_FLAG_HINT        FileFlag = 1
	NV_FILE_FLAG_MASKOUT     FileFlag = 2
	NV_FILE_FLAG_CONTENT     FileFlag = 4
	NV_FILE_FLAG_DEPRECTATED FileFlag = 8
	NV_FILE_FLAG_CANDIDATES  FileFlag = 16
)

// GpuInputType as declared in nvsandboxutils/nvsandboxutils.h
type GpuInputType int32

// GpuInputType enumeration from nvsandboxutils/nvsandboxutils.h
const (
	NV_GPU_INPUT_GPU_UUID  GpuInputType = iota
	NV_GPU_INPUT_MIG_UUID  GpuInputType = 1
	NV_GPU_INPUT_PCI_ID    GpuInputType = 2
	NV_GPU_INPUT_PCI_INDEX GpuInputType = 3
)
