"use strict";
// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.findCustomEnumOption = exports.findCustomMessageOption = exports.findCustomScalarOption = void 0;
const protobuf_1 = require("@bufbuild/protobuf");
/**
 * @deprecated Please use extensions instead.
 *
 * Returns the value of a custom option with a scalar type.
 *
 * If no option is found, returns undefined.
 */
function findCustomScalarOption(desc, extensionNumber, scalarType) {
    const reader = createBinaryReader(desc, extensionNumber);
    if (reader) {
        switch (scalarType) {
            case protobuf_1.ScalarType.INT32:
                return reader.int32();
            case protobuf_1.ScalarType.UINT32:
                return reader.uint32();
            case protobuf_1.ScalarType.SINT32:
                return reader.sint32();
            case protobuf_1.ScalarType.FIXED32:
                return reader.fixed32();
            case protobuf_1.ScalarType.SFIXED32:
                return reader.sfixed32();
            case protobuf_1.ScalarType.FLOAT:
                return reader.float();
            case protobuf_1.ScalarType.DOUBLE:
                return reader.double();
            case protobuf_1.ScalarType.INT64:
                return reader.int64();
            case protobuf_1.ScalarType.SINT64:
                return reader.sint64();
            case protobuf_1.ScalarType.SFIXED64:
                return reader.sfixed64();
            case protobuf_1.ScalarType.UINT64:
                return reader.uint64();
            case protobuf_1.ScalarType.FIXED64:
                return reader.fixed64();
            case protobuf_1.ScalarType.BOOL:
                return reader.bool();
            case protobuf_1.ScalarType.BYTES:
                return reader.bytes();
            case protobuf_1.ScalarType.STRING:
                return reader.string();
            default: {
                break;
            }
        }
    }
    return undefined;
}
exports.findCustomScalarOption = findCustomScalarOption;
/**
 * @deprecated Please use extensions instead.
 *
 * Returns the value of a custom message option for the given descriptor and
 * extension number.
 * The msgType param is then used to deserialize the message for returning to
 * the caller.
 *
 * If no options are found, returns undefined.
 *
 * If the message option is unable to be read or deserialized, an error will
 * be thrown.
 */
function findCustomMessageOption(desc, extensionNumber, msgType) {
    const reader = createBinaryReader(desc, extensionNumber);
    if (reader) {
        try {
            const data = reader.bytes();
            return msgType.fromBinary(data);
        }
        catch (e) {
            const innerMessage = e instanceof Error ? e.message : String(e);
            throw new Error(`failed to access message option: ${innerMessage}`);
        }
    }
    return undefined;
}
exports.findCustomMessageOption = findCustomMessageOption;
/**
 * @deprecated Please use extensions instead.
 *
 * Returns the value of a custom enum option for the given descriptor and
 * extension number.
 *
 * If no options are found, returns undefined.
 */
function findCustomEnumOption(desc, extensionNumber) {
    return findCustomScalarOption(desc, extensionNumber, protobuf_1.ScalarType.INT32);
}
exports.findCustomEnumOption = findCustomEnumOption;
/**
 * Returns a binary reader for the given descriptor and extension number.
 */
function createBinaryReader(desc, extensionNumber) {
    const opt = desc.proto.options;
    let reader = undefined;
    if (opt !== undefined) {
        const unknownFields = protobuf_1.proto3.bin.listUnknownFields(opt);
        const field = unknownFields.find((f) => f.no === extensionNumber);
        if (field) {
            reader = new protobuf_1.BinaryReader(field.data);
        }
    }
    return reader;
}
