// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The encryption settings for an S3 Metadata journal table or inventory table configuration.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MetadataTableEncryptionConfiguration {
    /// <p>The encryption type specified for a metadata table. To specify server-side encryption with Key Management Service (KMS) keys (SSE-KMS), use the <code>aws:kms</code> value. To specify server-side encryption with Amazon S3 managed keys (SSE-S3), use the <code>AES256</code> value.</p>
    pub sse_algorithm: crate::types::TableSseAlgorithm,
    /// <p>If server-side encryption with Key Management Service (KMS) keys (SSE-KMS) is specified, you must also specify the KMS key Amazon Resource Name (ARN). You must specify a customer-managed KMS key that's located in the same Region as the general purpose bucket that corresponds to the metadata table configuration.</p>
    pub kms_key_arn: ::std::option::Option<::std::string::String>,
}
impl MetadataTableEncryptionConfiguration {
    /// <p>The encryption type specified for a metadata table. To specify server-side encryption with Key Management Service (KMS) keys (SSE-KMS), use the <code>aws:kms</code> value. To specify server-side encryption with Amazon S3 managed keys (SSE-S3), use the <code>AES256</code> value.</p>
    pub fn sse_algorithm(&self) -> &crate::types::TableSseAlgorithm {
        &self.sse_algorithm
    }
    /// <p>If server-side encryption with Key Management Service (KMS) keys (SSE-KMS) is specified, you must also specify the KMS key Amazon Resource Name (ARN). You must specify a customer-managed KMS key that's located in the same Region as the general purpose bucket that corresponds to the metadata table configuration.</p>
    pub fn kms_key_arn(&self) -> ::std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl MetadataTableEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`MetadataTableEncryptionConfiguration`](crate::types::MetadataTableEncryptionConfiguration).
    pub fn builder() -> crate::types::builders::MetadataTableEncryptionConfigurationBuilder {
        crate::types::builders::MetadataTableEncryptionConfigurationBuilder::default()
    }
}

/// A builder for [`MetadataTableEncryptionConfiguration`](crate::types::MetadataTableEncryptionConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MetadataTableEncryptionConfigurationBuilder {
    pub(crate) sse_algorithm: ::std::option::Option<crate::types::TableSseAlgorithm>,
    pub(crate) kms_key_arn: ::std::option::Option<::std::string::String>,
}
impl MetadataTableEncryptionConfigurationBuilder {
    /// <p>The encryption type specified for a metadata table. To specify server-side encryption with Key Management Service (KMS) keys (SSE-KMS), use the <code>aws:kms</code> value. To specify server-side encryption with Amazon S3 managed keys (SSE-S3), use the <code>AES256</code> value.</p>
    /// This field is required.
    pub fn sse_algorithm(mut self, input: crate::types::TableSseAlgorithm) -> Self {
        self.sse_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption type specified for a metadata table. To specify server-side encryption with Key Management Service (KMS) keys (SSE-KMS), use the <code>aws:kms</code> value. To specify server-side encryption with Amazon S3 managed keys (SSE-S3), use the <code>AES256</code> value.</p>
    pub fn set_sse_algorithm(mut self, input: ::std::option::Option<crate::types::TableSseAlgorithm>) -> Self {
        self.sse_algorithm = input;
        self
    }
    /// <p>The encryption type specified for a metadata table. To specify server-side encryption with Key Management Service (KMS) keys (SSE-KMS), use the <code>aws:kms</code> value. To specify server-side encryption with Amazon S3 managed keys (SSE-S3), use the <code>AES256</code> value.</p>
    pub fn get_sse_algorithm(&self) -> &::std::option::Option<crate::types::TableSseAlgorithm> {
        &self.sse_algorithm
    }
    /// <p>If server-side encryption with Key Management Service (KMS) keys (SSE-KMS) is specified, you must also specify the KMS key Amazon Resource Name (ARN). You must specify a customer-managed KMS key that's located in the same Region as the general purpose bucket that corresponds to the metadata table configuration.</p>
    pub fn kms_key_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.kms_key_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If server-side encryption with Key Management Service (KMS) keys (SSE-KMS) is specified, you must also specify the KMS key Amazon Resource Name (ARN). You must specify a customer-managed KMS key that's located in the same Region as the general purpose bucket that corresponds to the metadata table configuration.</p>
    pub fn set_kms_key_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.kms_key_arn = input;
        self
    }
    /// <p>If server-side encryption with Key Management Service (KMS) keys (SSE-KMS) is specified, you must also specify the KMS key Amazon Resource Name (ARN). You must specify a customer-managed KMS key that's located in the same Region as the general purpose bucket that corresponds to the metadata table configuration.</p>
    pub fn get_kms_key_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.kms_key_arn
    }
    /// Consumes the builder and constructs a [`MetadataTableEncryptionConfiguration`](crate::types::MetadataTableEncryptionConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`sse_algorithm`](crate::types::builders::MetadataTableEncryptionConfigurationBuilder::sse_algorithm)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::types::MetadataTableEncryptionConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MetadataTableEncryptionConfiguration {
            sse_algorithm: self.sse_algorithm.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "sse_algorithm",
                    "sse_algorithm was not specified but it is required when building MetadataTableEncryptionConfiguration",
                )
            })?,
            kms_key_arn: self.kms_key_arn,
        })
    }
}
