/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop;

import java.io.Serializable;
import org.rogach.scallop.CliOption;
import org.rogach.scallop.Formatter$;
import org.rogach.scallop.HelpInfo;
import org.rogach.scallop.Scallop;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ScallopHelpFormatter {
    public String formatHelp(Scallop s, String subcommandPrefix) {
        String formattedHelp = this.getOptionsHelp(s) + this.getTrailingArgsHelp(s) + this.getSubcommandsHelp(s, subcommandPrefix);
        Object object = Predef$.MODULE$.refArrayOps(formattedHelp.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<String, String> & Serializable)_$1 -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString((String)_$1))), (Function1<Object, Object>)(Function1<Object, boolean> & Serializable)x$0 -> ScallopHelpFormatter.formatHelp$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToChar(x$0))))), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    public String getOptionsHelp(Scallop s) {
        return Formatter$.MODULE$.format((List<Either<String, HelpInfo>>)this.getOptionLines(s).flatMap((Function1<Either, IterableOnce> & Serializable)x$1 -> {
            Object object;
            Either either = x$1;
            if (either instanceof Left) {
                String s = (String)((Left)either).value();
                object = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Left[]{package$.MODULE$.Left().apply(s)}));
            } else if (either instanceof Right) {
                CliOption o = (CliOption)((Right)either).value();
                object = o.helpInfo(s.getOptionShortNames(o)).map((Function1<HelpInfo, Right> & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2));
            } else {
                throw new MatchError(either);
            }
            return object;
        }), s.helpWidth(), this.needToAppendDefaultToDescription(s));
    }

    public List<Either<String, CliOption>> getOptionLines(Scallop s) {
        return this.joinWithEmptyLineSeparator((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new List[]{this.getMainOptionLines(s), this.getOptionGroupsLines(s), (List)((IterableOps)this.getNormalOptionLines(s).$plus$plus(this.getHelpLine(s))).$plus$plus(this.getVersionLine(s))})));
    }

    public List<Either<String, CliOption>> getMainOptionLines(Scallop s) {
        return s.mainOptions().map((Function1<CliOption, Right> & Serializable)_$3 -> package$.MODULE$.Right().apply(_$3));
    }

    public List<Either<String, CliOption>> getOptionGroupsLines(Scallop s) {
        return this.joinWithEmptyLineSeparator((List<List<Either<String, CliOption>>>)s.optionGroups().map((Function1<Tuple2, List> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String header = (String)tuple2._1();
            Seq options = (Seq)tuple2._2();
            return (List)((AbstractIterable)((List)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{header}))).filter((Function1<String, boolean> & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$4)))).map((Function1<String, Left> & Serializable)h -> package$.MODULE$.Left().apply(" " + h))).$plus$plus((IterableOnce)options.map((Function1<CliOption, Right> & Serializable)_$5 -> package$.MODULE$.Right().apply(_$5)));
        }));
    }

    public List<Either<String, CliOption>> getNormalOptionLines(Scallop s) {
        Set optionsInGroups = (Set)s.mainOptions().toSet().$plus$plus(s.optionGroups().flatMap((Function1<Tuple2, IterableOnce> & Serializable)_$6 -> (IterableOnce)_$6._2()));
        return ((List)((AbstractSeq)((List)((List)((List)s.opts().filter((Function1<CliOption, boolean> & Serializable)_$7 -> !_$7.isPositional())).filter((Function1<CliOption, boolean> & Serializable)_$8 -> !_$8.hidden())).filter((Function1<CliOption, boolean> & Serializable)o -> !optionsInGroups.contains(o))).filter((Function1<CliOption, boolean> & Serializable)o -> {
            String string2 = o.name();
            String string3 = "help";
            if (string2 == null) {
                if (string3 == null) return false;
            } else if (string2.equals(string3)) return false;
            String string4 = o.name();
            String string5 = "version";
            if (string4 == null) {
                if (string5 == null) return false;
                return true;
            } else if (string4.equals(string5)) return false;
            return true;
        })).sortBy((Function1<CliOption, String> & Serializable)_$9 -> _$9.name().toLowerCase(), (Ordering)Ordering$String$.MODULE$)).map((Function1<CliOption, Right> & Serializable)o -> package$.MODULE$.Right().apply(o));
    }

    public List<Either<String, CliOption>> getHelpLine(Scallop s) {
        CliOption helpOption = (CliOption)s.opts().find((Function1<CliOption, Object>)(Function1<CliOption, boolean> & Serializable)_$10 -> {
            String string2 = _$10.name();
            String string3 = "help";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).getOrElse(() -> ScallopHelpFormatter.$anonfun$3(s));
        return helpOption.hidden() ? package$.MODULE$.Nil() : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Right[]{package$.MODULE$.Right().apply(helpOption)}));
    }

    public List<Either<String, CliOption>> getVersionLine(Scallop s) {
        List list2;
        Option versionOption = s.opts().find((Function1<CliOption, Object>)(Function1<CliOption, boolean> & Serializable)_$11 -> {
            String string2 = _$11.name();
            String string3 = "version";
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).orElse(() -> ScallopHelpFormatter.$anonfun$5(s)).filterNot((Function1<CliOption, boolean> & Serializable)_$13 -> _$13.hidden());
        Option option = versionOption;
        if (None$.MODULE$.equals(option)) {
            list2 = package$.MODULE$.Nil();
        } else if (option instanceof Some) {
            CliOption o = (CliOption)((Some)option).value();
            list2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Right[]{package$.MODULE$.Right().apply(o)}));
        } else {
            throw new MatchError(option);
        }
        return list2;
    }

    public String getTrailingArgsHelp(Scallop s) {
        String string2;
        Object trailOpts = ((List)s.opts().filter((Function1<CliOption, boolean> & Serializable)_$14 -> _$14.isPositional())).filter((Function1<CliOption, boolean> & Serializable)_$15 -> !_$15.hidden());
        if (((List)trailOpts).isEmpty()) {
            string2 = "";
        } else {
            String trailHelp = Formatter$.MODULE$.format((List<Either<String, HelpInfo>>)((List)((List)trailOpts).flatMap((Function1<CliOption, IterableOnce> & Serializable)_$16 -> _$16.helpInfo(package$.MODULE$.Nil()))).map((Function1<HelpInfo, Right> & Serializable)_$17 -> package$.MODULE$.Right().apply(_$17)), s.helpWidth(), this.needToAppendDefaultToDescription(s));
            string2 = "\n\n" + this.getTrailingArgsSectionName() + "\n" + trailHelp;
        }
        return string2;
    }

    public String getTrailingArgsSectionName() {
        return " trailing arguments:";
    }

    public String getSubcommandsHelp(Scallop s, String subcommandPrefix) {
        return s.subbuilders().isEmpty() ? "" : (s.shortSubcommandsHelp() ? this.getShortSubcommandsHelp(s) : this.getLongSubcommandsHelp(s, subcommandPrefix));
    }

    public String getShortSubcommandsHelp(Scallop s) {
        int maxCommandLength = BoxesRunTime.unboxToInt(((AbstractIterable)s.subbuilders().map((Function1<Tuple2, int> & Serializable)_$18 -> StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString((String)_$18._1())))).max(Ordering$Int$.MODULE$));
        return "\n\n" + this.getSubcommandsSectionName() + "\n" + ((AbstractIterable)s.subbuilders().map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Scallop option = (Scallop)tuple2._2();
            return "  " + StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(name), maxCommandLength, ' ') + "   " + option.descr();
        })).mkString("\n");
    }

    public String getSubcommandsSectionName() {
        return "Subcommands:";
    }

    public String getLongSubcommandsHelp(Scallop s, String subcommandPrefix) {
        return "\n\n" + ((AbstractIterable)this.getSubcommandsWithNames(s).map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Scallop sub = (Scallop)tuple2._1();
            List names = (List)tuple2._2();
            return this.getSubcommandHelp(sub, subcommandPrefix, names);
        })).mkString("\n\n");
    }

    public List<Tuple2<Scallop, List<String>>> getSubcommandsWithNames(Scallop s) {
        return (List)s.subbuilders().groupBy((Function1<Tuple2, Scallop> & Serializable)_$19 -> (Scallop)_$19._2()).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Scallop subBuilder = (Scallop)tuple2._1();
            List names = (List)tuple2._2();
            return Tuple2$.MODULE$.apply(subBuilder, names.map((Function1<Tuple2, String> & Serializable)_$20 -> (String)_$20._1()));
        }).toList().sortBy((Function1<Tuple2, int> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Scallop subBuilder = (Scallop)tuple2._1();
            List names = (List)tuple2._2();
            return s.subbuilders().indexWhere((Function1<Tuple2<String, Scallop>, Object>)(Function1<Tuple2, boolean> & Serializable)_$21 -> {
                Object T2 = _$21._2();
                Scallop scallop = subBuilder;
                return !(T2 != null ? !T2.equals(scallop) : scallop != null);
            });
        }, (Ordering)Ordering$Int$.MODULE$);
    }

    public String getSubcommandHelp(Scallop sub, String namePrefix, List<String> names) {
        return ((AbstractIterable)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{this.getSubcommandHeader(sub, namePrefix, names), (String)sub.bann().getOrElse(ScallopHelpFormatter::getSubcommandHelp$$anonfun$1), this.getSubcommandOptionsHelp(sub, namePrefix + names.head() + " "), (String)sub.foot().getOrElse(ScallopHelpFormatter::getSubcommandHelp$$anonfun$2)}))).filter((Function1<String, boolean> & Serializable)_$22 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$22)))).mkString("\n");
    }

    public String getSubcommandHeader(Scallop sub, String namePrefix, List<String> names) {
        String name = names.size() == 1 ? (String)names.head() : (String)names.head() + " (alias: " + ((IterableOnceOps)names.tail()).mkString(", ") + ")";
        String description = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sub.descr())) ? " - " + sub.descr() : "";
        return this.getSubcommandHeaderPrefix() + namePrefix + name + description;
    }

    public String getSubcommandHeaderPrefix() {
        return "Subcommand: ";
    }

    public String getSubcommandOptionsHelp(Scallop sub, String namePrefix) {
        Object object = Predef$.MODULE$.refArrayOps(this.formatHelp(sub, namePrefix).split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1<String, boolean> & Serializable)_$23 -> !_$23.trim().startsWith("--version"))).mkString("\n");
    }

    public boolean needToAppendDefaultToDescription(Scallop s2) {
        return s2.appendDefaultToDescription() || s2.parent().exists((Function1<Scallop, Object>)(Function1<Scallop, boolean> & Serializable)s -> this.needToAppendDefaultToDescription((Scallop)s));
    }

    public String getChoiceHelpText(String description, Seq<String> choices) {
        return ((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{description, "Choices:", choices.mkString(", ")})).filter((Function1<String, boolean> & Serializable)_$24 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)_$24)))).mkString(" ");
    }

    private List<Either<String, CliOption>> joinWithEmptyLineSeparator(List<List<Either<String, CliOption>>> optionLists) {
        List<List<Either<String, CliOption>>> list2;
        ScallopHelpFormatter scallopHelpFormatter = this;
        List<List<Either<String, CliOption>>> list3 = optionLists;
        while ((list2 = list3) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            List list4 = $colon$colon.next$access$1();
            List first = (List)$colon$colon.head();
            if (!(list4 instanceof $colon$colon)) break;
            $colon$colon $colon$colon2 = ($colon$colon)list4;
            List list5 = $colon$colon2.next$access$1();
            List second = (List)$colon$colon2.head();
            List rest = list5;
            if (first.nonEmpty() && second.nonEmpty()) {
                ScallopHelpFormatter scallopHelpFormatter2 = scallopHelpFormatter;
                List list6 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Left[]{package$.MODULE$.Left().apply("")}));
                List list7 = second.$colon$colon$colon(list6).$colon$colon$colon(first);
                List list8 = rest.$colon$colon(list7);
                scallopHelpFormatter = scallopHelpFormatter2;
                list3 = list8;
                continue;
            }
            ScallopHelpFormatter scallopHelpFormatter3 = scallopHelpFormatter;
            List list9 = second.$colon$colon$colon(first);
            List list10 = rest.$colon$colon(list9);
            scallopHelpFormatter = scallopHelpFormatter3;
            list3 = list10;
        }
        return (List)list3.flatten(Predef$.MODULE$.$conforms());
    }

    private static final /* synthetic */ boolean formatHelp$$anonfun$2$$anonfun$1(char x$0) {
        return Character.isWhitespace(x$0);
    }

    private static final CliOption $anonfun$3(Scallop s$2) {
        return s$2.getHelpOption();
    }

    private static final Option $anonfun$5(Scallop s$3) {
        return s$3.vers().flatMap((Function1<String, Option> & Serializable)_$12 -> s$3.getVersionOption());
    }

    private static final String getSubcommandHelp$$anonfun$1() {
        return "";
    }

    private static final String getSubcommandHelp$$anonfun$2() {
        return "";
    }
}

