Example of illegal code:

```ada
procedure P is
   X : Integer with Volatile; -- error: local variable X is volatile
begin
   ...
end P;
```

This error is issued on the declaration of a volatile object (or type) inside a
subprogram. Such a declaration violates legality rule 3 of [section 7.1.3 of
SPARK Reference Manual]. Allowing such a declaration would make it impossible to
follow reads and writes to that piece of memory after the call returns, as
there would not be a unique name to refer to that memory.

If the motivation for declaring the variable as volatile is simply to prevent
compiler optimizations, rather than taking into account reads and writes
outside of the sequential flow of the program due to other tasks, or to the
hardware, then the variable can be declared with aspect `No_Caching`:

```ada
X : Integer with Volatile, No_Caching;
```

Such a variable is treated like a non-volatile variable by GNATprove, and can
be declared inside a subprogram.

If the motivation for declaring the variable as volatile is precisely to take
into account reads and writes outside of the sequential flow of the program,
then the variable should be declared outside of the subprogram.

This is not possible if the address of the variable is specified based on the
value of parameters of the subprogram. In that case, the subprogram body (or
the part of it that depends on the declaration of that local volatile variable)
should be marked as not in SPARK with aspect `SPARK_Mode => Off`. To mark only
part of a subprogram as not in SPARK, it should be hoisted as another
subprogram (possibly local to the original subprogram). Note that, in order to
call this subprogram from SPARK code, it should have a declaration separate
from its body, and that declaration should be in SPARK. To model the effect of
the subprogram, consider adding a `Global` contract if it is a procedure, and
making it `Volatile_Function` if it is a function.

[section 7.1.3 of SPARK Reference Manual]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_rm/packages.html#external-state-variables-and-types
