/* automatically generated by rust-bindgen 0.72.0 */

pub const MYSQL_SERVER_VERSION: &[u8; 7] = b"5.7.42\0";
pub const MYSQL_BASE_VERSION: &[u8; 11] = b"mysqld-5.7\0";
pub const MYSQL_SERVER_SUFFIX_DEF: &[u8; 1] = b"\0";
pub const MYSQL_VERSION_ID: u32 = 50742;
pub const MYSQL_PORT: u32 = 3306;
pub const MYSQL_PORT_DEFAULT: u32 = 0;
pub const MYSQL_UNIX_ADDR: &[u8; 28] = b"/var/run/mysqld/mysqld.sock\0";
pub const MYSQL_CONFIG_NAME: &[u8; 3] = b"my\0";
pub const MYSQL_COMPILATION_COMMENT: &[u8; 29] = b"MySQL Community Server (GPL)\0";
pub const MYSQL_AUTODETECT_CHARSET_NAME: &[u8; 5] = b"auto\0";
pub const MYSQL_ERRMSG_SIZE: u32 = 512;
pub const MYSQL_STMT_HEADER: u32 = 4;
pub const MYSQL_LONG_DATA_HEADER: u32 = 6;
pub const MYSQL_CLIENT_reserved1: u32 = 0;
pub const MYSQL_CLIENT_reserved2: u32 = 1;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN: u32 = 2;
pub const MYSQL_CLIENT_TRACE_PLUGIN: u32 = 3;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN_INTERFACE_VERSION: u32 = 256;
pub const MYSQL_CLIENT_TRACE_PLUGIN_INTERFACE_VERSION: u32 = 256;
pub const MYSQL_CLIENT_MAX_PLUGINS: u32 = 4;
pub const MYSQL_USERNAME_LENGTH: u32 = 96;
pub const MYSQL_NO_DATA: u32 = 100;
pub const MYSQL_DATA_TRUNCATED: u32 = 101;
pub type my_bool = ::std::os::raw::c_char;
pub type my_socket = ::std::os::raw::c_int;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_field_types {
    MYSQL_TYPE_DECIMAL = 0,
    MYSQL_TYPE_TINY = 1,
    MYSQL_TYPE_SHORT = 2,
    MYSQL_TYPE_LONG = 3,
    MYSQL_TYPE_FLOAT = 4,
    MYSQL_TYPE_DOUBLE = 5,
    MYSQL_TYPE_NULL = 6,
    MYSQL_TYPE_TIMESTAMP = 7,
    MYSQL_TYPE_LONGLONG = 8,
    MYSQL_TYPE_INT24 = 9,
    MYSQL_TYPE_DATE = 10,
    MYSQL_TYPE_TIME = 11,
    MYSQL_TYPE_DATETIME = 12,
    MYSQL_TYPE_YEAR = 13,
    MYSQL_TYPE_NEWDATE = 14,
    MYSQL_TYPE_VARCHAR = 15,
    MYSQL_TYPE_BIT = 16,
    MYSQL_TYPE_TIMESTAMP2 = 17,
    MYSQL_TYPE_DATETIME2 = 18,
    MYSQL_TYPE_TIME2 = 19,
    MYSQL_TYPE_JSON = 245,
    MYSQL_TYPE_NEWDECIMAL = 246,
    MYSQL_TYPE_ENUM = 247,
    MYSQL_TYPE_SET = 248,
    MYSQL_TYPE_TINY_BLOB = 249,
    MYSQL_TYPE_MEDIUM_BLOB = 250,
    MYSQL_TYPE_LONG_BLOB = 251,
    MYSQL_TYPE_BLOB = 252,
    MYSQL_TYPE_VAR_STRING = 253,
    MYSQL_TYPE_STRING = 254,
    MYSQL_TYPE_GEOMETRY = 255,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_vio {
    _unused: [u8; 0],
}
pub type Vio = st_vio;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_net {
    pub vio: *mut Vio,
    pub buff: *mut ::std::os::raw::c_uchar,
    pub buff_end: *mut ::std::os::raw::c_uchar,
    pub write_pos: *mut ::std::os::raw::c_uchar,
    pub read_pos: *mut ::std::os::raw::c_uchar,
    pub fd: my_socket,
    pub remain_in_buf: ::std::os::raw::c_ulong,
    pub length: ::std::os::raw::c_ulong,
    pub buf_length: ::std::os::raw::c_ulong,
    pub where_b: ::std::os::raw::c_ulong,
    pub max_packet: ::std::os::raw::c_ulong,
    pub max_packet_size: ::std::os::raw::c_ulong,
    pub pkt_nr: ::std::os::raw::c_uint,
    pub compress_pkt_nr: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub retry_count: ::std::os::raw::c_uint,
    pub fcntl: ::std::os::raw::c_int,
    pub return_status: *mut ::std::os::raw::c_uint,
    pub reading_or_writing: ::std::os::raw::c_uchar,
    pub save_char: ::std::os::raw::c_char,
    pub unused1: my_bool,
    pub unused2: my_bool,
    pub compress: my_bool,
    pub unused3: my_bool,
    pub unused: *mut ::std::os::raw::c_uchar,
    pub last_errno: ::std::os::raw::c_uint,
    pub error: ::std::os::raw::c_uchar,
    pub unused4: my_bool,
    pub unused5: my_bool,
    #[doc = " Client library error message buffer. Actually belongs to struct MYSQL."]
    pub last_error: [::std::os::raw::c_char; 512usize],
    #[doc = " Client library sqlstate buffer. Set along with the error message."]
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    #[doc = "Extension pointer, for the caller private use.\nAny program linking with the networking library can use this pointer,\nwhich is handy when private connection specific data needs to be\nmaintained.\nThe mysqld server process uses this pointer internally,\nto maintain the server internal instrumentation for the connection."]
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_net"][::std::mem::size_of::<st_net>() - 620usize];
    ["Alignment of st_net"][::std::mem::align_of::<st_net>() - 4usize];
    ["Offset of field: st_net::vio"][::std::mem::offset_of!(st_net, vio) - 0usize];
    ["Offset of field: st_net::buff"][::std::mem::offset_of!(st_net, buff) - 4usize];
    ["Offset of field: st_net::buff_end"][::std::mem::offset_of!(st_net, buff_end) - 8usize];
    ["Offset of field: st_net::write_pos"][::std::mem::offset_of!(st_net, write_pos) - 12usize];
    ["Offset of field: st_net::read_pos"][::std::mem::offset_of!(st_net, read_pos) - 16usize];
    ["Offset of field: st_net::fd"][::std::mem::offset_of!(st_net, fd) - 20usize];
    ["Offset of field: st_net::remain_in_buf"]
        [::std::mem::offset_of!(st_net, remain_in_buf) - 24usize];
    ["Offset of field: st_net::length"][::std::mem::offset_of!(st_net, length) - 28usize];
    ["Offset of field: st_net::buf_length"][::std::mem::offset_of!(st_net, buf_length) - 32usize];
    ["Offset of field: st_net::where_b"][::std::mem::offset_of!(st_net, where_b) - 36usize];
    ["Offset of field: st_net::max_packet"][::std::mem::offset_of!(st_net, max_packet) - 40usize];
    ["Offset of field: st_net::max_packet_size"]
        [::std::mem::offset_of!(st_net, max_packet_size) - 44usize];
    ["Offset of field: st_net::pkt_nr"][::std::mem::offset_of!(st_net, pkt_nr) - 48usize];
    ["Offset of field: st_net::compress_pkt_nr"]
        [::std::mem::offset_of!(st_net, compress_pkt_nr) - 52usize];
    ["Offset of field: st_net::write_timeout"]
        [::std::mem::offset_of!(st_net, write_timeout) - 56usize];
    ["Offset of field: st_net::read_timeout"]
        [::std::mem::offset_of!(st_net, read_timeout) - 60usize];
    ["Offset of field: st_net::retry_count"][::std::mem::offset_of!(st_net, retry_count) - 64usize];
    ["Offset of field: st_net::fcntl"][::std::mem::offset_of!(st_net, fcntl) - 68usize];
    ["Offset of field: st_net::return_status"]
        [::std::mem::offset_of!(st_net, return_status) - 72usize];
    ["Offset of field: st_net::reading_or_writing"]
        [::std::mem::offset_of!(st_net, reading_or_writing) - 76usize];
    ["Offset of field: st_net::save_char"][::std::mem::offset_of!(st_net, save_char) - 77usize];
    ["Offset of field: st_net::unused1"][::std::mem::offset_of!(st_net, unused1) - 78usize];
    ["Offset of field: st_net::unused2"][::std::mem::offset_of!(st_net, unused2) - 79usize];
    ["Offset of field: st_net::compress"][::std::mem::offset_of!(st_net, compress) - 80usize];
    ["Offset of field: st_net::unused3"][::std::mem::offset_of!(st_net, unused3) - 81usize];
    ["Offset of field: st_net::unused"][::std::mem::offset_of!(st_net, unused) - 84usize];
    ["Offset of field: st_net::last_errno"][::std::mem::offset_of!(st_net, last_errno) - 88usize];
    ["Offset of field: st_net::error"][::std::mem::offset_of!(st_net, error) - 92usize];
    ["Offset of field: st_net::unused4"][::std::mem::offset_of!(st_net, unused4) - 93usize];
    ["Offset of field: st_net::unused5"][::std::mem::offset_of!(st_net, unused5) - 94usize];
    ["Offset of field: st_net::last_error"][::std::mem::offset_of!(st_net, last_error) - 95usize];
    ["Offset of field: st_net::sqlstate"][::std::mem::offset_of!(st_net, sqlstate) - 607usize];
    ["Offset of field: st_net::extension"][::std::mem::offset_of!(st_net, extension) - 616usize];
};
pub type NET = st_net;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_enum_shutdown_level {
    SHUTDOWN_DEFAULT = 0,
    SHUTDOWN_WAIT_CONNECTIONS = 1,
    SHUTDOWN_WAIT_TRANSACTIONS = 2,
    SHUTDOWN_WAIT_UPDATES = 8,
    SHUTDOWN_WAIT_ALL_BUFFERS = 16,
    SHUTDOWN_WAIT_CRITICAL_BUFFERS = 17,
    KILL_QUERY = 254,
    KILL_CONNECTION = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_set_option {
    MYSQL_OPTION_MULTI_STATEMENTS_ON = 0,
    MYSQL_OPTION_MULTI_STATEMENTS_OFF = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_session_state_type {
    SESSION_TRACK_SYSTEM_VARIABLES = 0,
    SESSION_TRACK_SCHEMA = 1,
    SESSION_TRACK_STATE_CHANGE = 2,
    SESSION_TRACK_GTIDS = 3,
    SESSION_TRACK_TRANSACTION_CHARACTERISTICS = 4,
    SESSION_TRACK_TRANSACTION_STATE = 5,
}
unsafe extern "C" {
    pub fn mysql_errno_to_sqlstate(
        mysql_errno: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_timestamp_type {
    MYSQL_TIMESTAMP_NONE = -2,
    MYSQL_TIMESTAMP_ERROR = -1,
    MYSQL_TIMESTAMP_DATE = 0,
    MYSQL_TIMESTAMP_DATETIME = 1,
    MYSQL_TIMESTAMP_TIME = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_time {
    pub year: ::std::os::raw::c_uint,
    pub month: ::std::os::raw::c_uint,
    pub day: ::std::os::raw::c_uint,
    pub hour: ::std::os::raw::c_uint,
    pub minute: ::std::os::raw::c_uint,
    pub second: ::std::os::raw::c_uint,
    #[doc = "< microseconds"]
    pub second_part: ::std::os::raw::c_ulong,
    pub neg: my_bool,
    pub time_type: enum_mysql_timestamp_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_time"][::std::mem::size_of::<st_mysql_time>() - 36usize];
    ["Alignment of st_mysql_time"][::std::mem::align_of::<st_mysql_time>() - 4usize];
    ["Offset of field: st_mysql_time::year"][::std::mem::offset_of!(st_mysql_time, year) - 0usize];
    ["Offset of field: st_mysql_time::month"]
        [::std::mem::offset_of!(st_mysql_time, month) - 4usize];
    ["Offset of field: st_mysql_time::day"][::std::mem::offset_of!(st_mysql_time, day) - 8usize];
    ["Offset of field: st_mysql_time::hour"][::std::mem::offset_of!(st_mysql_time, hour) - 12usize];
    ["Offset of field: st_mysql_time::minute"]
        [::std::mem::offset_of!(st_mysql_time, minute) - 16usize];
    ["Offset of field: st_mysql_time::second"]
        [::std::mem::offset_of!(st_mysql_time, second) - 20usize];
    ["Offset of field: st_mysql_time::second_part"]
        [::std::mem::offset_of!(st_mysql_time, second_part) - 24usize];
    ["Offset of field: st_mysql_time::neg"][::std::mem::offset_of!(st_mysql_time, neg) - 28usize];
    ["Offset of field: st_mysql_time::time_type"]
        [::std::mem::offset_of!(st_mysql_time, time_type) - 32usize];
};
pub type MYSQL_TIME = st_mysql_time;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_list {
    pub prev: *mut st_list,
    pub next: *mut st_list,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_list"][::std::mem::size_of::<st_list>() - 12usize];
    ["Alignment of st_list"][::std::mem::align_of::<st_list>() - 4usize];
    ["Offset of field: st_list::prev"][::std::mem::offset_of!(st_list, prev) - 0usize];
    ["Offset of field: st_list::next"][::std::mem::offset_of!(st_list, next) - 4usize];
    ["Offset of field: st_list::data"][::std::mem::offset_of!(st_list, data) - 8usize];
};
pub type LIST = st_list;
pub type va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_client_plugin {
    pub type_: ::std::os::raw::c_int,
    pub interface_version: ::std::os::raw::c_uint,
    pub name: *const ::std::os::raw::c_char,
    pub author: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub version: [::std::os::raw::c_uint; 3usize],
    pub license: *const ::std::os::raw::c_char,
    pub mysql_api: *mut ::std::os::raw::c_void,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: usize,
            arg3: ::std::os::raw::c_int,
            arg4: va_list,
        ) -> ::std::os::raw::c_int,
    >,
    pub deinit: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
    pub options: ::std::option::Option<
        unsafe extern "C" fn(
            option: *const ::std::os::raw::c_char,
            arg1: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_client_plugin"][::std::mem::size_of::<st_mysql_client_plugin>() - 52usize];
    ["Alignment of st_mysql_client_plugin"]
        [::std::mem::align_of::<st_mysql_client_plugin>() - 4usize];
    ["Offset of field: st_mysql_client_plugin::type_"]
        [::std::mem::offset_of!(st_mysql_client_plugin, type_) - 0usize];
    ["Offset of field: st_mysql_client_plugin::interface_version"]
        [::std::mem::offset_of!(st_mysql_client_plugin, interface_version) - 4usize];
    ["Offset of field: st_mysql_client_plugin::name"]
        [::std::mem::offset_of!(st_mysql_client_plugin, name) - 8usize];
    ["Offset of field: st_mysql_client_plugin::author"]
        [::std::mem::offset_of!(st_mysql_client_plugin, author) - 12usize];
    ["Offset of field: st_mysql_client_plugin::desc"]
        [::std::mem::offset_of!(st_mysql_client_plugin, desc) - 16usize];
    ["Offset of field: st_mysql_client_plugin::version"]
        [::std::mem::offset_of!(st_mysql_client_plugin, version) - 20usize];
    ["Offset of field: st_mysql_client_plugin::license"]
        [::std::mem::offset_of!(st_mysql_client_plugin, license) - 32usize];
    ["Offset of field: st_mysql_client_plugin::mysql_api"]
        [::std::mem::offset_of!(st_mysql_client_plugin, mysql_api) - 36usize];
    ["Offset of field: st_mysql_client_plugin::init"]
        [::std::mem::offset_of!(st_mysql_client_plugin, init) - 40usize];
    ["Offset of field: st_mysql_client_plugin::deinit"]
        [::std::mem::offset_of!(st_mysql_client_plugin, deinit) - 44usize];
    ["Offset of field: st_mysql_client_plugin::options"]
        [::std::mem::offset_of!(st_mysql_client_plugin, options) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_plugin_vio_info {
    pub protocol: st_plugin_vio_info__bindgen_ty_1,
    #[doc = "< it's set, if the protocol is SOCKET or TCP"]
    pub socket: ::std::os::raw::c_int,
}
pub const st_plugin_vio_info_MYSQL_VIO_INVALID: st_plugin_vio_info__bindgen_ty_1 =
    st_plugin_vio_info__bindgen_ty_1::MYSQL_VIO_INVALID;
pub const st_plugin_vio_info_MYSQL_VIO_TCP: st_plugin_vio_info__bindgen_ty_1 =
    st_plugin_vio_info__bindgen_ty_1::MYSQL_VIO_TCP;
pub const st_plugin_vio_info_MYSQL_VIO_SOCKET: st_plugin_vio_info__bindgen_ty_1 =
    st_plugin_vio_info__bindgen_ty_1::MYSQL_VIO_SOCKET;
pub const st_plugin_vio_info_MYSQL_VIO_PIPE: st_plugin_vio_info__bindgen_ty_1 =
    st_plugin_vio_info__bindgen_ty_1::MYSQL_VIO_PIPE;
pub const st_plugin_vio_info_MYSQL_VIO_MEMORY: st_plugin_vio_info__bindgen_ty_1 =
    st_plugin_vio_info__bindgen_ty_1::MYSQL_VIO_MEMORY;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum st_plugin_vio_info__bindgen_ty_1 {
    MYSQL_VIO_INVALID = 0,
    MYSQL_VIO_TCP = 1,
    MYSQL_VIO_SOCKET = 2,
    MYSQL_VIO_PIPE = 3,
    MYSQL_VIO_MEMORY = 4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_plugin_vio_info"][::std::mem::size_of::<st_plugin_vio_info>() - 8usize];
    ["Alignment of st_plugin_vio_info"][::std::mem::align_of::<st_plugin_vio_info>() - 4usize];
    ["Offset of field: st_plugin_vio_info::protocol"]
        [::std::mem::offset_of!(st_plugin_vio_info, protocol) - 0usize];
    ["Offset of field: st_plugin_vio_info::socket"]
        [::std::mem::offset_of!(st_plugin_vio_info, socket) - 4usize];
};
pub type MYSQL_PLUGIN_VIO_INFO = st_plugin_vio_info;
#[doc = "Provides plugin access to communication channel"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_plugin_vio {
    #[doc = "Plugin provides a pointer reference and this function sets it to the\ncontents of any incoming packet. Returns the packet length, or -1 if\nthe plugin should terminate."]
    pub read_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut st_plugin_vio,
            buf: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Plugin provides a buffer with data and the length and this\nfunction sends it as a packet. Returns 0 on success, 1 on failure."]
    pub write_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut st_plugin_vio,
            packet: *const ::std::os::raw::c_uchar,
            packet_len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Fills in a st_plugin_vio_info structure, providing the information\nabout the connection."]
    pub info: ::std::option::Option<
        unsafe extern "C" fn(vio: *mut st_plugin_vio, info: *mut st_plugin_vio_info),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_plugin_vio"][::std::mem::size_of::<st_plugin_vio>() - 12usize];
    ["Alignment of st_plugin_vio"][::std::mem::align_of::<st_plugin_vio>() - 4usize];
    ["Offset of field: st_plugin_vio::read_packet"]
        [::std::mem::offset_of!(st_plugin_vio, read_packet) - 0usize];
    ["Offset of field: st_plugin_vio::write_packet"]
        [::std::mem::offset_of!(st_plugin_vio, write_packet) - 4usize];
    ["Offset of field: st_plugin_vio::info"][::std::mem::offset_of!(st_plugin_vio, info) - 8usize];
};
#[doc = "Provides plugin access to communication channel"]
pub type MYSQL_PLUGIN_VIO = st_plugin_vio;
unsafe extern "C" {
    #[doc = "loads a plugin and initializes it\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param ...    arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin(
        mysql: *mut st_mysql,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        ...
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "loads a plugin and initializes it, taking va_list as an argument\n\nThis is the same as mysql_load_plugin, but take va_list instead of\na list of arguments.\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param args   arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin_v(
        mysql: *mut st_mysql,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        args: va_list,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "finds an already loaded plugin by name, or loads it, if necessary\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_find_plugin(
        mysql: *mut st_mysql,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "adds a plugin structure to the list of loaded plugins\n\nThis is useful if an application has the necessary functionality\n(for example, a special load data handler) statically linked into\nthe application binary. It can use this function to register the plugin\ndirectly, avoiding the need to factor it out into a shared object.\n\n@param mysql  MYSQL structure. It is only used for error reporting\n@param plugin an st_mysql_client_plugin structure to register\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_register_plugin(
        mysql: *mut st_mysql,
        plugin: *mut st_mysql_client_plugin,
    ) -> *mut st_mysql_client_plugin;
}
unsafe extern "C" {
    #[doc = "set plugin options\n\nCan be used to set extra options and affect behavior for a plugin.\nThis function may be called multiple times to set several options\n\n@param plugin an st_mysql_client_plugin structure\n@param option a string which specifies the option to set\n@param value  value for the option.\n\n@retval 0 on success, 1 in case of failure"]
    pub fn mysql_plugin_options(
        plugin: *mut st_mysql_client_plugin,
        option: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_field {
    pub name: *mut ::std::os::raw::c_char,
    pub org_name: *mut ::std::os::raw::c_char,
    pub table: *mut ::std::os::raw::c_char,
    pub org_table: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub catalog: *mut ::std::os::raw::c_char,
    pub def: *mut ::std::os::raw::c_char,
    pub length: ::std::os::raw::c_ulong,
    pub max_length: ::std::os::raw::c_ulong,
    pub name_length: ::std::os::raw::c_uint,
    pub org_name_length: ::std::os::raw::c_uint,
    pub table_length: ::std::os::raw::c_uint,
    pub org_table_length: ::std::os::raw::c_uint,
    pub db_length: ::std::os::raw::c_uint,
    pub catalog_length: ::std::os::raw::c_uint,
    pub def_length: ::std::os::raw::c_uint,
    pub flags: ::std::os::raw::c_uint,
    pub decimals: ::std::os::raw::c_uint,
    pub charsetnr: ::std::os::raw::c_uint,
    pub type_: enum_field_types,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_field"][::std::mem::size_of::<st_mysql_field>() - 84usize];
    ["Alignment of st_mysql_field"][::std::mem::align_of::<st_mysql_field>() - 4usize];
    ["Offset of field: st_mysql_field::name"]
        [::std::mem::offset_of!(st_mysql_field, name) - 0usize];
    ["Offset of field: st_mysql_field::org_name"]
        [::std::mem::offset_of!(st_mysql_field, org_name) - 4usize];
    ["Offset of field: st_mysql_field::table"]
        [::std::mem::offset_of!(st_mysql_field, table) - 8usize];
    ["Offset of field: st_mysql_field::org_table"]
        [::std::mem::offset_of!(st_mysql_field, org_table) - 12usize];
    ["Offset of field: st_mysql_field::db"][::std::mem::offset_of!(st_mysql_field, db) - 16usize];
    ["Offset of field: st_mysql_field::catalog"]
        [::std::mem::offset_of!(st_mysql_field, catalog) - 20usize];
    ["Offset of field: st_mysql_field::def"][::std::mem::offset_of!(st_mysql_field, def) - 24usize];
    ["Offset of field: st_mysql_field::length"]
        [::std::mem::offset_of!(st_mysql_field, length) - 28usize];
    ["Offset of field: st_mysql_field::max_length"]
        [::std::mem::offset_of!(st_mysql_field, max_length) - 32usize];
    ["Offset of field: st_mysql_field::name_length"]
        [::std::mem::offset_of!(st_mysql_field, name_length) - 36usize];
    ["Offset of field: st_mysql_field::org_name_length"]
        [::std::mem::offset_of!(st_mysql_field, org_name_length) - 40usize];
    ["Offset of field: st_mysql_field::table_length"]
        [::std::mem::offset_of!(st_mysql_field, table_length) - 44usize];
    ["Offset of field: st_mysql_field::org_table_length"]
        [::std::mem::offset_of!(st_mysql_field, org_table_length) - 48usize];
    ["Offset of field: st_mysql_field::db_length"]
        [::std::mem::offset_of!(st_mysql_field, db_length) - 52usize];
    ["Offset of field: st_mysql_field::catalog_length"]
        [::std::mem::offset_of!(st_mysql_field, catalog_length) - 56usize];
    ["Offset of field: st_mysql_field::def_length"]
        [::std::mem::offset_of!(st_mysql_field, def_length) - 60usize];
    ["Offset of field: st_mysql_field::flags"]
        [::std::mem::offset_of!(st_mysql_field, flags) - 64usize];
    ["Offset of field: st_mysql_field::decimals"]
        [::std::mem::offset_of!(st_mysql_field, decimals) - 68usize];
    ["Offset of field: st_mysql_field::charsetnr"]
        [::std::mem::offset_of!(st_mysql_field, charsetnr) - 72usize];
    ["Offset of field: st_mysql_field::type_"]
        [::std::mem::offset_of!(st_mysql_field, type_) - 76usize];
    ["Offset of field: st_mysql_field::extension"]
        [::std::mem::offset_of!(st_mysql_field, extension) - 80usize];
};
pub type MYSQL_FIELD = st_mysql_field;
pub type MYSQL_ROW = *mut *mut ::std::os::raw::c_char;
pub type MYSQL_FIELD_OFFSET = ::std::os::raw::c_uint;
pub type my_ulonglong = ::std::os::raw::c_ulonglong;
#[doc = "Instrumented memory key.\nTo instrument memory, a memory key must be obtained using @c register_memory.\nUsing a zero key always disable the instrumentation."]
pub type PSI_memory_key = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_used_mem {
    pub next: *mut st_used_mem,
    pub left: ::std::os::raw::c_uint,
    pub size: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_used_mem"][::std::mem::size_of::<st_used_mem>() - 12usize];
    ["Alignment of st_used_mem"][::std::mem::align_of::<st_used_mem>() - 4usize];
    ["Offset of field: st_used_mem::next"][::std::mem::offset_of!(st_used_mem, next) - 0usize];
    ["Offset of field: st_used_mem::left"][::std::mem::offset_of!(st_used_mem, left) - 4usize];
    ["Offset of field: st_used_mem::size"][::std::mem::offset_of!(st_used_mem, size) - 8usize];
};
pub type USED_MEM = st_used_mem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mem_root {
    pub free: *mut USED_MEM,
    pub used: *mut USED_MEM,
    pub pre_alloc: *mut USED_MEM,
    pub min_malloc: usize,
    pub block_size: usize,
    pub block_num: ::std::os::raw::c_uint,
    pub first_block_usage: ::std::os::raw::c_uint,
    pub max_capacity: usize,
    pub allocated_size: usize,
    pub error_for_capacity_exceeded: my_bool,
    pub error_handler: ::std::option::Option<unsafe extern "C" fn()>,
    pub m_psi_key: PSI_memory_key,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mem_root"][::std::mem::size_of::<st_mem_root>() - 48usize];
    ["Alignment of st_mem_root"][::std::mem::align_of::<st_mem_root>() - 4usize];
    ["Offset of field: st_mem_root::free"][::std::mem::offset_of!(st_mem_root, free) - 0usize];
    ["Offset of field: st_mem_root::used"][::std::mem::offset_of!(st_mem_root, used) - 4usize];
    ["Offset of field: st_mem_root::pre_alloc"]
        [::std::mem::offset_of!(st_mem_root, pre_alloc) - 8usize];
    ["Offset of field: st_mem_root::min_malloc"]
        [::std::mem::offset_of!(st_mem_root, min_malloc) - 12usize];
    ["Offset of field: st_mem_root::block_size"]
        [::std::mem::offset_of!(st_mem_root, block_size) - 16usize];
    ["Offset of field: st_mem_root::block_num"]
        [::std::mem::offset_of!(st_mem_root, block_num) - 20usize];
    ["Offset of field: st_mem_root::first_block_usage"]
        [::std::mem::offset_of!(st_mem_root, first_block_usage) - 24usize];
    ["Offset of field: st_mem_root::max_capacity"]
        [::std::mem::offset_of!(st_mem_root, max_capacity) - 28usize];
    ["Offset of field: st_mem_root::allocated_size"]
        [::std::mem::offset_of!(st_mem_root, allocated_size) - 32usize];
    ["Offset of field: st_mem_root::error_for_capacity_exceeded"]
        [::std::mem::offset_of!(st_mem_root, error_for_capacity_exceeded) - 36usize];
    ["Offset of field: st_mem_root::error_handler"]
        [::std::mem::offset_of!(st_mem_root, error_handler) - 40usize];
    ["Offset of field: st_mem_root::m_psi_key"]
        [::std::mem::offset_of!(st_mem_root, m_psi_key) - 44usize];
};
pub type MEM_ROOT = st_mem_root;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_rows {
    pub next: *mut st_mysql_rows,
    pub data: MYSQL_ROW,
    pub length: ::std::os::raw::c_ulong,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_rows"][::std::mem::size_of::<st_mysql_rows>() - 12usize];
    ["Alignment of st_mysql_rows"][::std::mem::align_of::<st_mysql_rows>() - 4usize];
    ["Offset of field: st_mysql_rows::next"][::std::mem::offset_of!(st_mysql_rows, next) - 0usize];
    ["Offset of field: st_mysql_rows::data"][::std::mem::offset_of!(st_mysql_rows, data) - 4usize];
    ["Offset of field: st_mysql_rows::length"]
        [::std::mem::offset_of!(st_mysql_rows, length) - 8usize];
};
pub type MYSQL_ROWS = st_mysql_rows;
pub type MYSQL_ROW_OFFSET = *mut MYSQL_ROWS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct embedded_query_result {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_data {
    pub data: *mut MYSQL_ROWS,
    pub embedded_info: *mut embedded_query_result,
    pub alloc: MEM_ROOT,
    pub rows: my_ulonglong,
    pub fields: ::std::os::raw::c_uint,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_data"][::std::mem::size_of::<st_mysql_data>() - 72usize];
    ["Alignment of st_mysql_data"][::std::mem::align_of::<st_mysql_data>() - 4usize];
    ["Offset of field: st_mysql_data::data"][::std::mem::offset_of!(st_mysql_data, data) - 0usize];
    ["Offset of field: st_mysql_data::embedded_info"]
        [::std::mem::offset_of!(st_mysql_data, embedded_info) - 4usize];
    ["Offset of field: st_mysql_data::alloc"]
        [::std::mem::offset_of!(st_mysql_data, alloc) - 8usize];
    ["Offset of field: st_mysql_data::rows"][::std::mem::offset_of!(st_mysql_data, rows) - 56usize];
    ["Offset of field: st_mysql_data::fields"]
        [::std::mem::offset_of!(st_mysql_data, fields) - 64usize];
    ["Offset of field: st_mysql_data::extension"]
        [::std::mem::offset_of!(st_mysql_data, extension) - 68usize];
};
pub type MYSQL_DATA = st_mysql_data;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_option {
    MYSQL_OPT_CONNECT_TIMEOUT = 0,
    MYSQL_OPT_COMPRESS = 1,
    MYSQL_OPT_NAMED_PIPE = 2,
    MYSQL_INIT_COMMAND = 3,
    MYSQL_READ_DEFAULT_FILE = 4,
    MYSQL_READ_DEFAULT_GROUP = 5,
    MYSQL_SET_CHARSET_DIR = 6,
    MYSQL_SET_CHARSET_NAME = 7,
    MYSQL_OPT_LOCAL_INFILE = 8,
    MYSQL_OPT_PROTOCOL = 9,
    MYSQL_SHARED_MEMORY_BASE_NAME = 10,
    MYSQL_OPT_READ_TIMEOUT = 11,
    MYSQL_OPT_WRITE_TIMEOUT = 12,
    MYSQL_OPT_USE_RESULT = 13,
    MYSQL_OPT_USE_REMOTE_CONNECTION = 14,
    MYSQL_OPT_USE_EMBEDDED_CONNECTION = 15,
    MYSQL_OPT_GUESS_CONNECTION = 16,
    MYSQL_SET_CLIENT_IP = 17,
    MYSQL_SECURE_AUTH = 18,
    MYSQL_REPORT_DATA_TRUNCATION = 19,
    MYSQL_OPT_RECONNECT = 20,
    MYSQL_OPT_SSL_VERIFY_SERVER_CERT = 21,
    MYSQL_PLUGIN_DIR = 22,
    MYSQL_DEFAULT_AUTH = 23,
    MYSQL_OPT_BIND = 24,
    MYSQL_OPT_SSL_KEY = 25,
    MYSQL_OPT_SSL_CERT = 26,
    MYSQL_OPT_SSL_CA = 27,
    MYSQL_OPT_SSL_CAPATH = 28,
    MYSQL_OPT_SSL_CIPHER = 29,
    MYSQL_OPT_SSL_CRL = 30,
    MYSQL_OPT_SSL_CRLPATH = 31,
    MYSQL_OPT_CONNECT_ATTR_RESET = 32,
    MYSQL_OPT_CONNECT_ATTR_ADD = 33,
    MYSQL_OPT_CONNECT_ATTR_DELETE = 34,
    MYSQL_SERVER_PUBLIC_KEY = 35,
    MYSQL_ENABLE_CLEARTEXT_PLUGIN = 36,
    MYSQL_OPT_CAN_HANDLE_EXPIRED_PASSWORDS = 37,
    MYSQL_OPT_SSL_ENFORCE = 38,
    MYSQL_OPT_MAX_ALLOWED_PACKET = 39,
    MYSQL_OPT_NET_BUFFER_LENGTH = 40,
    MYSQL_OPT_TLS_VERSION = 41,
    MYSQL_OPT_SSL_MODE = 42,
    MYSQL_OPT_GET_SERVER_PUBLIC_KEY = 43,
}
#[doc = "@todo remove the \"extension\", move st_mysql_options completely\nout of mysql.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_options_extention {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct st_mysql_options {
    pub connect_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub port: ::std::os::raw::c_uint,
    pub protocol: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub password: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub init_commands: *mut st_dynamic_array,
    pub my_cnf_file: *mut ::std::os::raw::c_char,
    pub my_cnf_group: *mut ::std::os::raw::c_char,
    pub charset_dir: *mut ::std::os::raw::c_char,
    pub charset_name: *mut ::std::os::raw::c_char,
    pub ssl_key: *mut ::std::os::raw::c_char,
    pub ssl_cert: *mut ::std::os::raw::c_char,
    pub ssl_ca: *mut ::std::os::raw::c_char,
    pub ssl_capath: *mut ::std::os::raw::c_char,
    pub ssl_cipher: *mut ::std::os::raw::c_char,
    pub shared_memory_base_name: *mut ::std::os::raw::c_char,
    pub max_allowed_packet: ::std::os::raw::c_ulong,
    pub use_ssl: my_bool,
    pub compress: my_bool,
    pub named_pipe: my_bool,
    pub unused1: my_bool,
    pub unused2: my_bool,
    pub unused3: my_bool,
    pub unused4: my_bool,
    pub methods_to_use: mysql_option,
    pub ci: st_mysql_options__bindgen_ty_1,
    pub unused5: my_bool,
    pub report_data_truncation: my_bool,
    pub local_infile_init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_end:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub local_infile_error: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_userdata: *mut ::std::os::raw::c_void,
    pub extension: *mut st_mysql_options_extention,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union st_mysql_options__bindgen_ty_1 {
    pub client_ip: *mut ::std::os::raw::c_char,
    pub bind_address: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_options__bindgen_ty_1"]
        [::std::mem::size_of::<st_mysql_options__bindgen_ty_1>() - 4usize];
    ["Alignment of st_mysql_options__bindgen_ty_1"]
        [::std::mem::align_of::<st_mysql_options__bindgen_ty_1>() - 4usize];
    ["Offset of field: st_mysql_options__bindgen_ty_1::client_ip"]
        [::std::mem::offset_of!(st_mysql_options__bindgen_ty_1, client_ip) - 0usize];
    ["Offset of field: st_mysql_options__bindgen_ty_1::bind_address"]
        [::std::mem::offset_of!(st_mysql_options__bindgen_ty_1, bind_address) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_options"][::std::mem::size_of::<st_mysql_options>() - 136usize];
    ["Alignment of st_mysql_options"][::std::mem::align_of::<st_mysql_options>() - 4usize];
    ["Offset of field: st_mysql_options::connect_timeout"]
        [::std::mem::offset_of!(st_mysql_options, connect_timeout) - 0usize];
    ["Offset of field: st_mysql_options::read_timeout"]
        [::std::mem::offset_of!(st_mysql_options, read_timeout) - 4usize];
    ["Offset of field: st_mysql_options::write_timeout"]
        [::std::mem::offset_of!(st_mysql_options, write_timeout) - 8usize];
    ["Offset of field: st_mysql_options::port"]
        [::std::mem::offset_of!(st_mysql_options, port) - 12usize];
    ["Offset of field: st_mysql_options::protocol"]
        [::std::mem::offset_of!(st_mysql_options, protocol) - 16usize];
    ["Offset of field: st_mysql_options::client_flag"]
        [::std::mem::offset_of!(st_mysql_options, client_flag) - 20usize];
    ["Offset of field: st_mysql_options::host"]
        [::std::mem::offset_of!(st_mysql_options, host) - 24usize];
    ["Offset of field: st_mysql_options::user"]
        [::std::mem::offset_of!(st_mysql_options, user) - 28usize];
    ["Offset of field: st_mysql_options::password"]
        [::std::mem::offset_of!(st_mysql_options, password) - 32usize];
    ["Offset of field: st_mysql_options::unix_socket"]
        [::std::mem::offset_of!(st_mysql_options, unix_socket) - 36usize];
    ["Offset of field: st_mysql_options::db"]
        [::std::mem::offset_of!(st_mysql_options, db) - 40usize];
    ["Offset of field: st_mysql_options::init_commands"]
        [::std::mem::offset_of!(st_mysql_options, init_commands) - 44usize];
    ["Offset of field: st_mysql_options::my_cnf_file"]
        [::std::mem::offset_of!(st_mysql_options, my_cnf_file) - 48usize];
    ["Offset of field: st_mysql_options::my_cnf_group"]
        [::std::mem::offset_of!(st_mysql_options, my_cnf_group) - 52usize];
    ["Offset of field: st_mysql_options::charset_dir"]
        [::std::mem::offset_of!(st_mysql_options, charset_dir) - 56usize];
    ["Offset of field: st_mysql_options::charset_name"]
        [::std::mem::offset_of!(st_mysql_options, charset_name) - 60usize];
    ["Offset of field: st_mysql_options::ssl_key"]
        [::std::mem::offset_of!(st_mysql_options, ssl_key) - 64usize];
    ["Offset of field: st_mysql_options::ssl_cert"]
        [::std::mem::offset_of!(st_mysql_options, ssl_cert) - 68usize];
    ["Offset of field: st_mysql_options::ssl_ca"]
        [::std::mem::offset_of!(st_mysql_options, ssl_ca) - 72usize];
    ["Offset of field: st_mysql_options::ssl_capath"]
        [::std::mem::offset_of!(st_mysql_options, ssl_capath) - 76usize];
    ["Offset of field: st_mysql_options::ssl_cipher"]
        [::std::mem::offset_of!(st_mysql_options, ssl_cipher) - 80usize];
    ["Offset of field: st_mysql_options::shared_memory_base_name"]
        [::std::mem::offset_of!(st_mysql_options, shared_memory_base_name) - 84usize];
    ["Offset of field: st_mysql_options::max_allowed_packet"]
        [::std::mem::offset_of!(st_mysql_options, max_allowed_packet) - 88usize];
    ["Offset of field: st_mysql_options::use_ssl"]
        [::std::mem::offset_of!(st_mysql_options, use_ssl) - 92usize];
    ["Offset of field: st_mysql_options::compress"]
        [::std::mem::offset_of!(st_mysql_options, compress) - 93usize];
    ["Offset of field: st_mysql_options::named_pipe"]
        [::std::mem::offset_of!(st_mysql_options, named_pipe) - 94usize];
    ["Offset of field: st_mysql_options::unused1"]
        [::std::mem::offset_of!(st_mysql_options, unused1) - 95usize];
    ["Offset of field: st_mysql_options::unused2"]
        [::std::mem::offset_of!(st_mysql_options, unused2) - 96usize];
    ["Offset of field: st_mysql_options::unused3"]
        [::std::mem::offset_of!(st_mysql_options, unused3) - 97usize];
    ["Offset of field: st_mysql_options::unused4"]
        [::std::mem::offset_of!(st_mysql_options, unused4) - 98usize];
    ["Offset of field: st_mysql_options::methods_to_use"]
        [::std::mem::offset_of!(st_mysql_options, methods_to_use) - 100usize];
    ["Offset of field: st_mysql_options::ci"]
        [::std::mem::offset_of!(st_mysql_options, ci) - 104usize];
    ["Offset of field: st_mysql_options::unused5"]
        [::std::mem::offset_of!(st_mysql_options, unused5) - 108usize];
    ["Offset of field: st_mysql_options::report_data_truncation"]
        [::std::mem::offset_of!(st_mysql_options, report_data_truncation) - 109usize];
    ["Offset of field: st_mysql_options::local_infile_init"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_init) - 112usize];
    ["Offset of field: st_mysql_options::local_infile_read"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_read) - 116usize];
    ["Offset of field: st_mysql_options::local_infile_end"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_end) - 120usize];
    ["Offset of field: st_mysql_options::local_infile_error"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_error) - 124usize];
    ["Offset of field: st_mysql_options::local_infile_userdata"]
        [::std::mem::offset_of!(st_mysql_options, local_infile_userdata) - 128usize];
    ["Offset of field: st_mysql_options::extension"]
        [::std::mem::offset_of!(st_mysql_options, extension) - 132usize];
};
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_status {
    MYSQL_STATUS_READY = 0,
    MYSQL_STATUS_GET_RESULT = 1,
    MYSQL_STATUS_USE_RESULT = 2,
    MYSQL_STATUS_STATEMENT_GET_RESULT = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_protocol_type {
    MYSQL_PROTOCOL_DEFAULT = 0,
    MYSQL_PROTOCOL_TCP = 1,
    MYSQL_PROTOCOL_SOCKET = 2,
    MYSQL_PROTOCOL_PIPE = 3,
    MYSQL_PROTOCOL_MEMORY = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_ssl_mode {
    SSL_MODE_DISABLED = 1,
    SSL_MODE_PREFERRED = 2,
    SSL_MODE_REQUIRED = 3,
    SSL_MODE_VERIFY_CA = 4,
    SSL_MODE_VERIFY_IDENTITY = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct character_set {
    pub number: ::std::os::raw::c_uint,
    pub state: ::std::os::raw::c_uint,
    pub csname: *const ::std::os::raw::c_char,
    pub name: *const ::std::os::raw::c_char,
    pub comment: *const ::std::os::raw::c_char,
    pub dir: *const ::std::os::raw::c_char,
    pub mbminlen: ::std::os::raw::c_uint,
    pub mbmaxlen: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of character_set"][::std::mem::size_of::<character_set>() - 32usize];
    ["Alignment of character_set"][::std::mem::align_of::<character_set>() - 4usize];
    ["Offset of field: character_set::number"]
        [::std::mem::offset_of!(character_set, number) - 0usize];
    ["Offset of field: character_set::state"]
        [::std::mem::offset_of!(character_set, state) - 4usize];
    ["Offset of field: character_set::csname"]
        [::std::mem::offset_of!(character_set, csname) - 8usize];
    ["Offset of field: character_set::name"][::std::mem::offset_of!(character_set, name) - 12usize];
    ["Offset of field: character_set::comment"]
        [::std::mem::offset_of!(character_set, comment) - 16usize];
    ["Offset of field: character_set::dir"][::std::mem::offset_of!(character_set, dir) - 20usize];
    ["Offset of field: character_set::mbminlen"]
        [::std::mem::offset_of!(character_set, mbminlen) - 24usize];
    ["Offset of field: character_set::mbmaxlen"]
        [::std::mem::offset_of!(character_set, mbmaxlen) - 28usize];
};
pub type MY_CHARSET_INFO = character_set;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_methods {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct st_mysql {
    pub net: NET,
    pub connector_fd: *mut ::std::os::raw::c_uchar,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub passwd: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub server_version: *mut ::std::os::raw::c_char,
    pub host_info: *mut ::std::os::raw::c_char,
    pub info: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub charset: *mut charset_info_st,
    pub fields: *mut MYSQL_FIELD,
    pub field_alloc: MEM_ROOT,
    pub affected_rows: my_ulonglong,
    pub insert_id: my_ulonglong,
    pub extra_info: my_ulonglong,
    pub thread_id: ::std::os::raw::c_ulong,
    pub packet_length: ::std::os::raw::c_ulong,
    pub port: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub server_capabilities: ::std::os::raw::c_ulong,
    pub protocol_version: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub server_status: ::std::os::raw::c_uint,
    pub server_language: ::std::os::raw::c_uint,
    pub warning_count: ::std::os::raw::c_uint,
    pub options: st_mysql_options,
    pub status: mysql_status,
    pub free_me: my_bool,
    pub reconnect: my_bool,
    pub scramble: [::std::os::raw::c_char; 21usize],
    pub unused1: my_bool,
    pub unused2: *mut ::std::os::raw::c_void,
    pub unused3: *mut ::std::os::raw::c_void,
    pub unused4: *mut ::std::os::raw::c_void,
    pub unused5: *mut ::std::os::raw::c_void,
    pub stmts: *mut LIST,
    pub methods: *const st_mysql_methods,
    pub thd: *mut ::std::os::raw::c_void,
    pub unbuffered_fetch_owner: *mut my_bool,
    pub info_buffer: *mut ::std::os::raw::c_char,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql"][::std::mem::size_of::<st_mysql>() - 980usize];
    ["Alignment of st_mysql"][::std::mem::align_of::<st_mysql>() - 4usize];
    ["Offset of field: st_mysql::net"][::std::mem::offset_of!(st_mysql, net) - 0usize];
    ["Offset of field: st_mysql::connector_fd"]
        [::std::mem::offset_of!(st_mysql, connector_fd) - 620usize];
    ["Offset of field: st_mysql::host"][::std::mem::offset_of!(st_mysql, host) - 624usize];
    ["Offset of field: st_mysql::user"][::std::mem::offset_of!(st_mysql, user) - 628usize];
    ["Offset of field: st_mysql::passwd"][::std::mem::offset_of!(st_mysql, passwd) - 632usize];
    ["Offset of field: st_mysql::unix_socket"]
        [::std::mem::offset_of!(st_mysql, unix_socket) - 636usize];
    ["Offset of field: st_mysql::server_version"]
        [::std::mem::offset_of!(st_mysql, server_version) - 640usize];
    ["Offset of field: st_mysql::host_info"]
        [::std::mem::offset_of!(st_mysql, host_info) - 644usize];
    ["Offset of field: st_mysql::info"][::std::mem::offset_of!(st_mysql, info) - 648usize];
    ["Offset of field: st_mysql::db"][::std::mem::offset_of!(st_mysql, db) - 652usize];
    ["Offset of field: st_mysql::charset"][::std::mem::offset_of!(st_mysql, charset) - 656usize];
    ["Offset of field: st_mysql::fields"][::std::mem::offset_of!(st_mysql, fields) - 660usize];
    ["Offset of field: st_mysql::field_alloc"]
        [::std::mem::offset_of!(st_mysql, field_alloc) - 664usize];
    ["Offset of field: st_mysql::affected_rows"]
        [::std::mem::offset_of!(st_mysql, affected_rows) - 712usize];
    ["Offset of field: st_mysql::insert_id"]
        [::std::mem::offset_of!(st_mysql, insert_id) - 720usize];
    ["Offset of field: st_mysql::extra_info"]
        [::std::mem::offset_of!(st_mysql, extra_info) - 728usize];
    ["Offset of field: st_mysql::thread_id"]
        [::std::mem::offset_of!(st_mysql, thread_id) - 736usize];
    ["Offset of field: st_mysql::packet_length"]
        [::std::mem::offset_of!(st_mysql, packet_length) - 740usize];
    ["Offset of field: st_mysql::port"][::std::mem::offset_of!(st_mysql, port) - 744usize];
    ["Offset of field: st_mysql::client_flag"]
        [::std::mem::offset_of!(st_mysql, client_flag) - 748usize];
    ["Offset of field: st_mysql::server_capabilities"]
        [::std::mem::offset_of!(st_mysql, server_capabilities) - 752usize];
    ["Offset of field: st_mysql::protocol_version"]
        [::std::mem::offset_of!(st_mysql, protocol_version) - 756usize];
    ["Offset of field: st_mysql::field_count"]
        [::std::mem::offset_of!(st_mysql, field_count) - 760usize];
    ["Offset of field: st_mysql::server_status"]
        [::std::mem::offset_of!(st_mysql, server_status) - 764usize];
    ["Offset of field: st_mysql::server_language"]
        [::std::mem::offset_of!(st_mysql, server_language) - 768usize];
    ["Offset of field: st_mysql::warning_count"]
        [::std::mem::offset_of!(st_mysql, warning_count) - 772usize];
    ["Offset of field: st_mysql::options"][::std::mem::offset_of!(st_mysql, options) - 776usize];
    ["Offset of field: st_mysql::status"][::std::mem::offset_of!(st_mysql, status) - 912usize];
    ["Offset of field: st_mysql::free_me"][::std::mem::offset_of!(st_mysql, free_me) - 916usize];
    ["Offset of field: st_mysql::reconnect"]
        [::std::mem::offset_of!(st_mysql, reconnect) - 917usize];
    ["Offset of field: st_mysql::scramble"][::std::mem::offset_of!(st_mysql, scramble) - 918usize];
    ["Offset of field: st_mysql::unused1"][::std::mem::offset_of!(st_mysql, unused1) - 939usize];
    ["Offset of field: st_mysql::unused2"][::std::mem::offset_of!(st_mysql, unused2) - 940usize];
    ["Offset of field: st_mysql::unused3"][::std::mem::offset_of!(st_mysql, unused3) - 944usize];
    ["Offset of field: st_mysql::unused4"][::std::mem::offset_of!(st_mysql, unused4) - 948usize];
    ["Offset of field: st_mysql::unused5"][::std::mem::offset_of!(st_mysql, unused5) - 952usize];
    ["Offset of field: st_mysql::stmts"][::std::mem::offset_of!(st_mysql, stmts) - 956usize];
    ["Offset of field: st_mysql::methods"][::std::mem::offset_of!(st_mysql, methods) - 960usize];
    ["Offset of field: st_mysql::thd"][::std::mem::offset_of!(st_mysql, thd) - 964usize];
    ["Offset of field: st_mysql::unbuffered_fetch_owner"]
        [::std::mem::offset_of!(st_mysql, unbuffered_fetch_owner) - 968usize];
    ["Offset of field: st_mysql::info_buffer"]
        [::std::mem::offset_of!(st_mysql, info_buffer) - 972usize];
    ["Offset of field: st_mysql::extension"]
        [::std::mem::offset_of!(st_mysql, extension) - 976usize];
};
pub type MYSQL = st_mysql;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_res {
    pub row_count: my_ulonglong,
    pub fields: *mut MYSQL_FIELD,
    pub data: *mut MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub lengths: *mut ::std::os::raw::c_ulong,
    pub handle: *mut MYSQL,
    pub methods: *const st_mysql_methods,
    pub row: MYSQL_ROW,
    pub current_row: MYSQL_ROW,
    pub field_alloc: MEM_ROOT,
    pub field_count: ::std::os::raw::c_uint,
    pub current_field: ::std::os::raw::c_uint,
    pub eof: my_bool,
    pub unbuffered_fetch_cancelled: my_bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_res"][::std::mem::size_of::<st_mysql_res>() - 104usize];
    ["Alignment of st_mysql_res"][::std::mem::align_of::<st_mysql_res>() - 4usize];
    ["Offset of field: st_mysql_res::row_count"]
        [::std::mem::offset_of!(st_mysql_res, row_count) - 0usize];
    ["Offset of field: st_mysql_res::fields"]
        [::std::mem::offset_of!(st_mysql_res, fields) - 8usize];
    ["Offset of field: st_mysql_res::data"][::std::mem::offset_of!(st_mysql_res, data) - 12usize];
    ["Offset of field: st_mysql_res::data_cursor"]
        [::std::mem::offset_of!(st_mysql_res, data_cursor) - 16usize];
    ["Offset of field: st_mysql_res::lengths"]
        [::std::mem::offset_of!(st_mysql_res, lengths) - 20usize];
    ["Offset of field: st_mysql_res::handle"]
        [::std::mem::offset_of!(st_mysql_res, handle) - 24usize];
    ["Offset of field: st_mysql_res::methods"]
        [::std::mem::offset_of!(st_mysql_res, methods) - 28usize];
    ["Offset of field: st_mysql_res::row"][::std::mem::offset_of!(st_mysql_res, row) - 32usize];
    ["Offset of field: st_mysql_res::current_row"]
        [::std::mem::offset_of!(st_mysql_res, current_row) - 36usize];
    ["Offset of field: st_mysql_res::field_alloc"]
        [::std::mem::offset_of!(st_mysql_res, field_alloc) - 40usize];
    ["Offset of field: st_mysql_res::field_count"]
        [::std::mem::offset_of!(st_mysql_res, field_count) - 88usize];
    ["Offset of field: st_mysql_res::current_field"]
        [::std::mem::offset_of!(st_mysql_res, current_field) - 92usize];
    ["Offset of field: st_mysql_res::eof"][::std::mem::offset_of!(st_mysql_res, eof) - 96usize];
    ["Offset of field: st_mysql_res::unbuffered_fetch_cancelled"]
        [::std::mem::offset_of!(st_mysql_res, unbuffered_fetch_cancelled) - 97usize];
    ["Offset of field: st_mysql_res::extension"]
        [::std::mem::offset_of!(st_mysql_res, extension) - 100usize];
};
pub type MYSQL_RES = st_mysql_res;
unsafe extern "C" {
    pub fn mysql_server_init(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
        groups: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_server_end();
}
unsafe extern "C" {
    pub fn mysql_thread_init() -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_thread_end();
}
unsafe extern "C" {
    pub fn mysql_num_rows(res: *mut MYSQL_RES) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_num_fields(res: *mut MYSQL_RES) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_eof(res: *mut MYSQL_RES) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_fetch_field_direct(
        res: *mut MYSQL_RES,
        fieldnr: ::std::os::raw::c_uint,
    ) -> *mut MYSQL_FIELD;
}
unsafe extern "C" {
    pub fn mysql_fetch_fields(res: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
unsafe extern "C" {
    pub fn mysql_row_tell(res: *mut MYSQL_RES) -> MYSQL_ROW_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_field_tell(res: *mut MYSQL_RES) -> MYSQL_FIELD_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_field_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_affected_rows(mysql: *mut MYSQL) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_insert_id(mysql: *mut MYSQL) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_errno(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_error(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_sqlstate(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_warning_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_thread_id(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_character_set_name(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_set_character_set(
        mysql: *mut MYSQL,
        csname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_init(mysql: *mut MYSQL) -> *mut MYSQL;
}
unsafe extern "C" {
    pub fn mysql_ssl_set(
        mysql: *mut MYSQL,
        key: *const ::std::os::raw::c_char,
        cert: *const ::std::os::raw::c_char,
        ca: *const ::std::os::raw::c_char,
        capath: *const ::std::os::raw::c_char,
        cipher: *const ::std::os::raw::c_char,
    ) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_get_ssl_cipher(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_change_user(
        mysql: *mut MYSQL,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
    ) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_real_connect(
        mysql: *mut MYSQL,
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        port: ::std::os::raw::c_uint,
        unix_socket: *const ::std::os::raw::c_char,
        clientflag: ::std::os::raw::c_ulong,
    ) -> *mut MYSQL;
}
unsafe extern "C" {
    pub fn mysql_select_db(
        mysql: *mut MYSQL,
        db: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_send_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_real_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_store_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_use_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_get_character_set_info(mysql: *mut MYSQL, charset: *mut MY_CHARSET_INFO);
}
unsafe extern "C" {
    pub fn mysql_session_track_get_first(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_session_track_get_next(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_set_local_infile_handler(
        mysql: *mut MYSQL,
        local_infile_init: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_read: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_end: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
        local_infile_error: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        arg1: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn mysql_set_local_infile_default(mysql: *mut MYSQL);
}
unsafe extern "C" {
    pub fn mysql_shutdown(
        mysql: *mut MYSQL,
        shutdown_level: mysql_enum_shutdown_level,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_dump_debug_info(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_refresh(
        mysql: *mut MYSQL,
        refresh_options: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_kill(mysql: *mut MYSQL, pid: ::std::os::raw::c_ulong) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_set_server_option(
        mysql: *mut MYSQL,
        option: enum_mysql_set_option,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_ping(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stat(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_get_server_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_get_client_info() -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_get_client_version() -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_get_host_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_get_server_version(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_get_proto_info(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_list_dbs(mysql: *mut MYSQL, wild: *const ::std::os::raw::c_char)
        -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_list_tables(
        mysql: *mut MYSQL,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_list_processes(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_options(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_options4(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_get_option(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_free_result(result: *mut MYSQL_RES);
}
unsafe extern "C" {
    pub fn mysql_data_seek(result: *mut MYSQL_RES, offset: my_ulonglong);
}
unsafe extern "C" {
    pub fn mysql_row_seek(result: *mut MYSQL_RES, offset: MYSQL_ROW_OFFSET) -> MYSQL_ROW_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_field_seek(
        result: *mut MYSQL_RES,
        offset: MYSQL_FIELD_OFFSET,
    ) -> MYSQL_FIELD_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_fetch_row(result: *mut MYSQL_RES) -> MYSQL_ROW;
}
unsafe extern "C" {
    pub fn mysql_fetch_lengths(result: *mut MYSQL_RES) -> *mut ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_fetch_field(result: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
unsafe extern "C" {
    pub fn mysql_list_fields(
        mysql: *mut MYSQL,
        table: *const ::std::os::raw::c_char,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_escape_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_hex_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_real_escape_string(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_real_escape_string_quote(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
        quote: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_debug(debug: *const ::std::os::raw::c_char);
}
unsafe extern "C" {
    pub fn mysql_thread_safe() -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_embedded() -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_read_query_result(mysql: *mut MYSQL) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_reset_connection(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_stmt_state {
    MYSQL_STMT_INIT_DONE = 1,
    MYSQL_STMT_PREPARE_DONE = 2,
    MYSQL_STMT_EXECUTE_DONE = 3,
    MYSQL_STMT_FETCH_DONE = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_bind {
    pub length: *mut ::std::os::raw::c_ulong,
    pub is_null: *mut my_bool,
    pub buffer: *mut ::std::os::raw::c_void,
    pub error: *mut my_bool,
    pub row_ptr: *mut ::std::os::raw::c_uchar,
    pub store_param_func:
        ::std::option::Option<unsafe extern "C" fn(net: *mut NET, param: *mut st_mysql_bind)>,
    pub fetch_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut st_mysql_bind,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub skip_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut st_mysql_bind,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub buffer_length: ::std::os::raw::c_ulong,
    pub offset: ::std::os::raw::c_ulong,
    pub length_value: ::std::os::raw::c_ulong,
    pub param_number: ::std::os::raw::c_uint,
    pub pack_length: ::std::os::raw::c_uint,
    pub buffer_type: enum_field_types,
    pub error_value: my_bool,
    pub is_unsigned: my_bool,
    pub long_data_used: my_bool,
    pub is_null_value: my_bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_bind"][::std::mem::size_of::<st_mysql_bind>() - 64usize];
    ["Alignment of st_mysql_bind"][::std::mem::align_of::<st_mysql_bind>() - 4usize];
    ["Offset of field: st_mysql_bind::length"]
        [::std::mem::offset_of!(st_mysql_bind, length) - 0usize];
    ["Offset of field: st_mysql_bind::is_null"]
        [::std::mem::offset_of!(st_mysql_bind, is_null) - 4usize];
    ["Offset of field: st_mysql_bind::buffer"]
        [::std::mem::offset_of!(st_mysql_bind, buffer) - 8usize];
    ["Offset of field: st_mysql_bind::error"]
        [::std::mem::offset_of!(st_mysql_bind, error) - 12usize];
    ["Offset of field: st_mysql_bind::row_ptr"]
        [::std::mem::offset_of!(st_mysql_bind, row_ptr) - 16usize];
    ["Offset of field: st_mysql_bind::store_param_func"]
        [::std::mem::offset_of!(st_mysql_bind, store_param_func) - 20usize];
    ["Offset of field: st_mysql_bind::fetch_result"]
        [::std::mem::offset_of!(st_mysql_bind, fetch_result) - 24usize];
    ["Offset of field: st_mysql_bind::skip_result"]
        [::std::mem::offset_of!(st_mysql_bind, skip_result) - 28usize];
    ["Offset of field: st_mysql_bind::buffer_length"]
        [::std::mem::offset_of!(st_mysql_bind, buffer_length) - 32usize];
    ["Offset of field: st_mysql_bind::offset"]
        [::std::mem::offset_of!(st_mysql_bind, offset) - 36usize];
    ["Offset of field: st_mysql_bind::length_value"]
        [::std::mem::offset_of!(st_mysql_bind, length_value) - 40usize];
    ["Offset of field: st_mysql_bind::param_number"]
        [::std::mem::offset_of!(st_mysql_bind, param_number) - 44usize];
    ["Offset of field: st_mysql_bind::pack_length"]
        [::std::mem::offset_of!(st_mysql_bind, pack_length) - 48usize];
    ["Offset of field: st_mysql_bind::buffer_type"]
        [::std::mem::offset_of!(st_mysql_bind, buffer_type) - 52usize];
    ["Offset of field: st_mysql_bind::error_value"]
        [::std::mem::offset_of!(st_mysql_bind, error_value) - 56usize];
    ["Offset of field: st_mysql_bind::is_unsigned"]
        [::std::mem::offset_of!(st_mysql_bind, is_unsigned) - 57usize];
    ["Offset of field: st_mysql_bind::long_data_used"]
        [::std::mem::offset_of!(st_mysql_bind, long_data_used) - 58usize];
    ["Offset of field: st_mysql_bind::is_null_value"]
        [::std::mem::offset_of!(st_mysql_bind, is_null_value) - 59usize];
    ["Offset of field: st_mysql_bind::extension"]
        [::std::mem::offset_of!(st_mysql_bind, extension) - 60usize];
};
pub type MYSQL_BIND = st_mysql_bind;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_stmt_extension {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_stmt {
    pub mem_root: MEM_ROOT,
    pub list: LIST,
    pub mysql: *mut MYSQL,
    pub params: *mut MYSQL_BIND,
    pub bind: *mut MYSQL_BIND,
    pub fields: *mut MYSQL_FIELD,
    pub result: MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub read_row_func: ::std::option::Option<
        unsafe extern "C" fn(
            stmt: *mut st_mysql_stmt,
            row: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    pub affected_rows: my_ulonglong,
    pub insert_id: my_ulonglong,
    pub stmt_id: ::std::os::raw::c_ulong,
    pub flags: ::std::os::raw::c_ulong,
    pub prefetch_rows: ::std::os::raw::c_ulong,
    pub server_status: ::std::os::raw::c_uint,
    pub last_errno: ::std::os::raw::c_uint,
    pub param_count: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub state: enum_mysql_stmt_state,
    pub last_error: [::std::os::raw::c_char; 512usize],
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    pub send_types_to_server: my_bool,
    pub bind_param_done: my_bool,
    pub bind_result_done: ::std::os::raw::c_uchar,
    pub unbuffered_fetch_cancelled: my_bool,
    pub update_max_length: my_bool,
    pub extension: *mut st_mysql_stmt_extension,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of st_mysql_stmt"][::std::mem::size_of::<st_mysql_stmt>() - 732usize];
    ["Alignment of st_mysql_stmt"][::std::mem::align_of::<st_mysql_stmt>() - 4usize];
    ["Offset of field: st_mysql_stmt::mem_root"]
        [::std::mem::offset_of!(st_mysql_stmt, mem_root) - 0usize];
    ["Offset of field: st_mysql_stmt::list"][::std::mem::offset_of!(st_mysql_stmt, list) - 48usize];
    ["Offset of field: st_mysql_stmt::mysql"]
        [::std::mem::offset_of!(st_mysql_stmt, mysql) - 60usize];
    ["Offset of field: st_mysql_stmt::params"]
        [::std::mem::offset_of!(st_mysql_stmt, params) - 64usize];
    ["Offset of field: st_mysql_stmt::bind"][::std::mem::offset_of!(st_mysql_stmt, bind) - 68usize];
    ["Offset of field: st_mysql_stmt::fields"]
        [::std::mem::offset_of!(st_mysql_stmt, fields) - 72usize];
    ["Offset of field: st_mysql_stmt::result"]
        [::std::mem::offset_of!(st_mysql_stmt, result) - 76usize];
    ["Offset of field: st_mysql_stmt::data_cursor"]
        [::std::mem::offset_of!(st_mysql_stmt, data_cursor) - 148usize];
    ["Offset of field: st_mysql_stmt::read_row_func"]
        [::std::mem::offset_of!(st_mysql_stmt, read_row_func) - 152usize];
    ["Offset of field: st_mysql_stmt::affected_rows"]
        [::std::mem::offset_of!(st_mysql_stmt, affected_rows) - 156usize];
    ["Offset of field: st_mysql_stmt::insert_id"]
        [::std::mem::offset_of!(st_mysql_stmt, insert_id) - 164usize];
    ["Offset of field: st_mysql_stmt::stmt_id"]
        [::std::mem::offset_of!(st_mysql_stmt, stmt_id) - 172usize];
    ["Offset of field: st_mysql_stmt::flags"]
        [::std::mem::offset_of!(st_mysql_stmt, flags) - 176usize];
    ["Offset of field: st_mysql_stmt::prefetch_rows"]
        [::std::mem::offset_of!(st_mysql_stmt, prefetch_rows) - 180usize];
    ["Offset of field: st_mysql_stmt::server_status"]
        [::std::mem::offset_of!(st_mysql_stmt, server_status) - 184usize];
    ["Offset of field: st_mysql_stmt::last_errno"]
        [::std::mem::offset_of!(st_mysql_stmt, last_errno) - 188usize];
    ["Offset of field: st_mysql_stmt::param_count"]
        [::std::mem::offset_of!(st_mysql_stmt, param_count) - 192usize];
    ["Offset of field: st_mysql_stmt::field_count"]
        [::std::mem::offset_of!(st_mysql_stmt, field_count) - 196usize];
    ["Offset of field: st_mysql_stmt::state"]
        [::std::mem::offset_of!(st_mysql_stmt, state) - 200usize];
    ["Offset of field: st_mysql_stmt::last_error"]
        [::std::mem::offset_of!(st_mysql_stmt, last_error) - 204usize];
    ["Offset of field: st_mysql_stmt::sqlstate"]
        [::std::mem::offset_of!(st_mysql_stmt, sqlstate) - 716usize];
    ["Offset of field: st_mysql_stmt::send_types_to_server"]
        [::std::mem::offset_of!(st_mysql_stmt, send_types_to_server) - 722usize];
    ["Offset of field: st_mysql_stmt::bind_param_done"]
        [::std::mem::offset_of!(st_mysql_stmt, bind_param_done) - 723usize];
    ["Offset of field: st_mysql_stmt::bind_result_done"]
        [::std::mem::offset_of!(st_mysql_stmt, bind_result_done) - 724usize];
    ["Offset of field: st_mysql_stmt::unbuffered_fetch_cancelled"]
        [::std::mem::offset_of!(st_mysql_stmt, unbuffered_fetch_cancelled) - 725usize];
    ["Offset of field: st_mysql_stmt::update_max_length"]
        [::std::mem::offset_of!(st_mysql_stmt, update_max_length) - 726usize];
    ["Offset of field: st_mysql_stmt::extension"]
        [::std::mem::offset_of!(st_mysql_stmt, extension) - 728usize];
};
pub type MYSQL_STMT = st_mysql_stmt;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_stmt_attr_type {
    STMT_ATTR_UPDATE_MAX_LENGTH = 0,
    STMT_ATTR_CURSOR_TYPE = 1,
    STMT_ATTR_PREFETCH_ROWS = 2,
}
unsafe extern "C" {
    pub fn mysql_stmt_init(mysql: *mut MYSQL) -> *mut MYSQL_STMT;
}
unsafe extern "C" {
    pub fn mysql_stmt_prepare(
        stmt: *mut MYSQL_STMT,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_execute(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_fetch(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_fetch_column(
        stmt: *mut MYSQL_STMT,
        bind_arg: *mut MYSQL_BIND,
        column: ::std::os::raw::c_uint,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_store_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_param_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_ulong;
}
unsafe extern "C" {
    pub fn mysql_stmt_attr_set(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *const ::std::os::raw::c_void,
    ) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_attr_get(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *mut ::std::os::raw::c_void,
    ) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_bind_param(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_bind_result(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_close(stmt: *mut MYSQL_STMT) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_reset(stmt: *mut MYSQL_STMT) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_free_result(stmt: *mut MYSQL_STMT) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_send_long_data(
        stmt: *mut MYSQL_STMT,
        param_number: ::std::os::raw::c_uint,
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_stmt_result_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_stmt_param_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
unsafe extern "C" {
    pub fn mysql_stmt_errno(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_stmt_error(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_stmt_sqlstate(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn mysql_stmt_row_seek(stmt: *mut MYSQL_STMT, offset: MYSQL_ROW_OFFSET)
        -> MYSQL_ROW_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_stmt_row_tell(stmt: *mut MYSQL_STMT) -> MYSQL_ROW_OFFSET;
}
unsafe extern "C" {
    pub fn mysql_stmt_data_seek(stmt: *mut MYSQL_STMT, offset: my_ulonglong);
}
unsafe extern "C" {
    pub fn mysql_stmt_num_rows(stmt: *mut MYSQL_STMT) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_stmt_affected_rows(stmt: *mut MYSQL_STMT) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_stmt_insert_id(stmt: *mut MYSQL_STMT) -> my_ulonglong;
}
unsafe extern "C" {
    pub fn mysql_stmt_field_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn mysql_commit(mysql: *mut MYSQL) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_rollback(mysql: *mut MYSQL) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_autocommit(mysql: *mut MYSQL, auto_mode: my_bool) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_more_results(mysql: *mut MYSQL) -> my_bool;
}
unsafe extern "C" {
    pub fn mysql_next_result(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_stmt_next_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn mysql_close(sock: *mut MYSQL);
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_dynamic_array {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct charset_info_st {
    pub _address: u8,
}
