// Copyright (c) Meta Platforms, Inc. and affiliates.
//
// This source code is licensed under the MIT license found in the
// LICENSE file in the root directory of this source tree.
//
// Auto generated for hbt. Do not manually edit.
// @generated

#include <stdexcept>
#include "hbt/src/perf_event/json_events/generated/intel/JsonEvents.h"

namespace facebook::hbt::perf_event::generated {
namespace snowridgex_uncore_experimental {

void addEvents(PmuDeviceManager& pmu_manager) {
/*
  Events from snowridgex_uncore_experimental.json (2313 experimental events).

  Supported SKUs:
      - Arch: x86, Model: SNR id: 134
*/
#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x0F, .umaskExt = 0x20},
      R"(Lines Victimized : Local - All Lines)",
      R"(Lines Victimized : Local - All Lines : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_COUNTER0_OCCUPANCY",
      EventDef::Encoding{.code = 0x1F, .umask = 0x00, .umaskExt = 0x00},
      R"(Counter 0 Occupancy)",
      R"(Counter 0 Occupancy : Since occupancy counts can only be captured in the Cbo's 0 counter, this event allows a user to capture occupancy related information by filtering the Cb0 occupancy count captured in Counter 0.   The filtering available is found in the control register - threshold, invert and edge detect.   E.g. setting threshold to 1 can effectively monitor how many cycles the monitored queue has an entry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.RFO_HIT_S",
      EventDef::Encoding{.code = 0x39, .umask = 0x08, .umaskExt = 0x00},
      R"(Number of times that an RFO hit in S state.)",
      R"(Counts when a RFO (the Read for Ownership issued before a  write) request hit a cacheline in the S (Shared) state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_REQUESTS.INVITOE",
      EventDef::Encoding{.code = 0x50, .umask = 0x30, .umaskExt = 0x00},
      R"(Local INVITOE requests (exclusive ownership of a cache line without receiving data) that miss the SF/LLC and remote INVITOE requests sent to the CHA's home agent)",
      R"(Counts the total number of requests coming from a unit on this socket for exclusive ownership of a cache line without receiving data (INVITOE) to the CHA.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x19, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ALL",
      EventDef::Encoding{.code = 0x35, .umask = 0xff, .umaskExt = 0xC001FF},
      R"(TOR Inserts : All)",
      R"(TOR Inserts : All : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_CRD",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC80FFD},
      R"(TOR Occupancy : CRds issued by iA Cores that Hit the LLC)",
      R"(TOR Occupancy : CRds issued by iA Cores that Hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IA_HIT_RFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC807FD},
      R"(TOR Occupancy : RFOs issued by iA Cores that Hit the LLC)",
      R"(TOR Occupancy : RFOs issued by iA Cores that Hit the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IO_MISS_RFO",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0xc803fe},
      R"(TOR Inserts : RFOs issued by IO Devices that missed the LLC)",
      R"(TOR Inserts : RFOs issued by IO Devices that missed the LLC : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_MISS_RFO",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xc803fe},
      R"(TOR Occupancy : RFOs issued by IO Devices that missed the LLC)",
      R"(TOR Occupancy : RFOs issued by IO Devices that missed the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_MISS_ITOM",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xcc43fe},
      R"(TOR Occupancy : ItoMs issued by IO Devices that missed the LLC)",
      R"(TOR Occupancy : ItoMs issued by IO Devices that missed the LLC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_M",
      EventDef::Encoding{.code = 0x12, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoop Responses : Hit M)",
      R"(Snoop Responses : Hit M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.RFO",
      EventDef::Encoding{.code = 0x10, .umask = 0x08, .umaskExt = 0x00},
      R"(RFO request issued by the IRP unit to the mesh with the intention of writing a partial cacheline.)",
      R"(RFO request issued by the IRP unit to the mesh with the intention of writing a partial cacheline to coherent memory.  RFO is a Read For Ownership command that requests ownership of the cacheline and moves data from the mesh to IRP cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RDB_INSERTS",
      EventDef::Encoding{.code = 0x17, .umask = 0x00, .umaskExt = 0x00},
      R"(Read Data Buffer Inserts)",
      R"(Read Data Buffer Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_REG",
      EventDef::Encoding{.code = 0x04, .umask = 0x01, .umaskExt = 0x00},
      R"(All DRAM read CAS commands issued (does not include underfills))",
      R"(Counts the total number of DRAM Read CAS commands issued on this channel.  This includes both regular RD CAS commands as well as those with implicit Precharge.   We do not filter based on major mode, as RD_CAS is not issued during WMM (with the exception of underfills).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_UNDERFILL",
      EventDef::Encoding{.code = 0x04, .umask = 0x04, .umaskExt = 0x00},
      R"(DRAM underfill read CAS commands issued)",
      R"(Counts the total of DRAM Read CAS commands issued due to an underfill)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_EGRESS.NOT_TAKEN",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Not Taken)",
      R"(M2M to iMC Bypass : Not Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2CORE_NOT_TAKEN_DIRSTATE",
      EventDef::Encoding{.code = 0x24, .umask = 0x00, .umaskExt = 0x00},
      R"(Cycles when direct to core mode, which bypasses the CHA, was disabled)",
      R"(Cycles when direct to core mode, which bypasses the CHA, was disabled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECT2CORE_TXN_OVERRIDE",
      EventDef::Encoding{.code = 0x25, .umask = 0x00, .umaskExt = 0x00},
      R"(Number of reads in which direct to core transaction was overridden)",
      R"(Number of reads in which direct to core transaction was overridden)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x07},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - All Channels)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x07},
      R"(M2M Reads Issued to iMC : Normal Priority - All Channels)",
      R"(M2M Reads Issued to iMC : Normal Priority - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : All Writes - All Channels)",
      R"(M2M Writes Issued to iMC : All Writes - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - All Channels)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x1C},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - All Channels)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - All Channels)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_INSERTS",
      EventDef::Encoding{.code = 0x01, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Ingress (from CMS) Allocations)",
      R"(AD Ingress (from CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_OCCUPANCY",
      EventDef::Encoding{.code = 0x02, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Ingress (from CMS) Occupancy)",
      R"(AD Ingress (from CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_INSERTS",
      EventDef::Encoding{.code = 0x05, .umask = 0x00, .umaskExt = 0x00},
      R"(BL Ingress (from CMS) Allocations)",
      R"(BL Ingress (from CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_OCCUPANCY",
      EventDef::Encoding{.code = 0x06, .umask = 0x00, .umaskExt = 0x00},
      R"(BL Ingress (from CMS) Occupancy)",
      R"(BL Ingress (from CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_INSERTS",
      EventDef::Encoding{.code = 0x09, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Egress (to CMS) Allocations)",
      R"(AD Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_OCCUPANCY",
      EventDef::Encoding{.code = 0x0A, .umask = 0x00, .umaskExt = 0x00},
      R"(AD Egress (to CMS) Occupancy)",
      R"(AD Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.ALL",
      EventDef::Encoding{.code = 0x15, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : All)",
      R"(BL Egress (to CMS) Allocations : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Taken)",
      R"(CHA to iMC Bypass : Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that succeeded in taking the full bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.INTERMEDIATE",
      EventDef::Encoding{.code = 0x57, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Intermediate bypass Taken)",
      R"(CHA to iMC Bypass : Intermediate bypass Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that succeeded in taking the intermediate bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.NOT_TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA to iMC Bypass : Not Taken)",
      R"(CHA to iMC Bypass : Not Taken : Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not. : Filter for transactions that could not take the bypass, and issues a read to memory. Note that transactions that did not take the bypass but did not issue read to memory will not be counted.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x21, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single External Snoops)",
      R"(Core Cross Snoops Issued : Single External Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x41, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single Core Requests)",
      R"(Core Cross Snoops Issued : Single Core Requests : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x81, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Single Eviction)",
      R"(Core Cross Snoops Issued : Single Eviction : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xF1, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Any Single Snoop)",
      R"(Core Cross Snoops Issued : Any Single Snoop : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x22, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple External Snoops)",
      R"(Core Cross Snoops Issued : Multiple External Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x42, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple Core Requests)",
      R"(Core Cross Snoops Issued : Multiple Core Requests : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x82, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Multiple Eviction)",
      R"(Core Cross Snoops Issued : Multiple Eviction : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xF2, .umaskExt = 0x00},
      R"(Core Cross Snoops Issued : Any Cycle with Multiple Snoops)",
      R"(Core Cross Snoops Issued : Any Cycle with Multiple Snoops : Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_TOR_DEALLOC",
      EventDef::Encoding{.code = 0x6E, .umask = 0x01, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_SUPPRESS_NO_D2C",
      EventDef::Encoding{.code = 0x6E, .umask = 0x02, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO.HA_SUPPRESS_DRD",
      EventDef::Encoding{.code = 0x6E, .umask = 0x04, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.EXTCMP",
      EventDef::Encoding{.code = 0x6D, .umask = 0x01, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x02, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.GO",
      EventDef::Encoding{.code = 0x6D, .umask = 0x04, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.GO_PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x08, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.FAST_GO",
      EventDef::Encoding{.code = 0x6D, .umask = 0x10, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.FAST_GO_PULL",
      EventDef::Encoding{.code = 0x6D, .umask = 0x20, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.NOP",
      EventDef::Encoding{.code = 0x6D, .umask = 0x40, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DIRECT_GO_OPC.IDLE_DUE_SUPPRESS",
      EventDef::Encoding{.code = 0x6D, .umask = 0x80, .umaskExt = 0x00},
      R"(Direct GO)",
      R"(Direct GO)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_READS_COUNT.PRIORITY",
      EventDef::Encoding{.code = 0x59, .umask = 0x02, .umaskExt = 0x00},
      R"(HA to iMC Reads Issued : ISOCH)",
      R"(HA to iMC Reads Issued : ISOCH : Count of the number of reads issued to any of the memory controller channels.  This can be filtered by the priority of the reads.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL",
      EventDef::Encoding{.code = 0x5B, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : Partial Non-ISOCH)",
      R"(CHA to iMC Full Line Writes Issued : Partial Non-ISOCH : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.FULL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : ISOCH Full Line)",
      R"(CHA to iMC Full Line Writes Issued : ISOCH Full Line : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA to iMC Full Line Writes Issued : ISOCH Partial)",
      R"(CHA to iMC Full Line Writes Issued : ISOCH Partial : Counts the total number of full line writes issued from the HA into the memory controller.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.M_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in M state)",
      R"(Lines Victimized : Lines in M state : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.E_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in E state)",
      R"(Lines Victimized : Lines in E state : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.S_STATE",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x00},
      R"(Lines Victimized : Lines in S State)",
      R"(Lines Victimized : Lines in S State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_ONLY",
      EventDef::Encoding{.code = 0x37, .umask = 0x00, .umaskExt = 0x20},
      R"(Lines Victimized : Local Only)",
      R"(Lines Victimized : Local Only : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_M",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in M State)",
      R"(Lines Victimized : Local - Lines in M State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_E",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in E State)",
      R"(Lines Victimized : Local - Lines in E State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_S",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x20},
      R"(Lines Victimized : Local - Lines in S State)",
      R"(Lines Victimized : Local - Lines in S State : Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.RSPI_WAS_FSE",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .umaskExt = 0x00},
      R"(Cbo Misc : Silent Snoop Eviction)",
      R"(Cbo Misc : Silent Snoop Eviction : Miscellaneous events in the Cbo. : Counts the number of times when a Snoop hit in FSE states and triggered a silent eviction.  This is useful because this information is lost in the PRE encodings.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.WC_ALIASING",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .umaskExt = 0x00},
      R"(Cbo Misc : Write Combining Aliasing)",
      R"(Cbo Misc : Write Combining Aliasing : Miscellaneous events in the Cbo. : Counts the number of times that a USWC write (WCIL(F)) transaction hit in the LLC in M state, triggering a WBMtoI followed by the USWC write.  This occurs when there is WC aliasing.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_VIC",
      EventDef::Encoding{.code = 0x39, .umask = 0x10, .umaskExt = 0x00},
      R"(Cbo Misc : CV0 Prefetch Victim)",
      R"(Cbo Misc : CV0 Prefetch Victim : Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_MISS",
      EventDef::Encoding{.code = 0x39, .umask = 0x20, .umaskExt = 0x00},
      R"(Cbo Misc : CV0 Prefetch Miss)",
      R"(Cbo Misc : CV0 Prefetch Miss : Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.RMW_SETMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_PAMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_ALLOWSNP",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_WAYMATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x08, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.GOTRACK_ALLWAYRSV",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.PTL_INPIPE",
      EventDef::Encoding{.code = 0x42, .umask = 0x80, .umaskExt = 0x00},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IRQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x01},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.FSF_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x02},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ONE_FSF_VIC",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x04},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.TORID_MATCH_GO_P",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x10},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IPQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x20},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.WAY_MATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x40},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ONE_RSP_CON",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x80},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IDX_INPIPE",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x100},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.SETMATCHENTRYWSCT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x200},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ALLRSFWAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x800},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.RRQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x1000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ISMQ_SETMATCH_VICP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x2000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.SF_WAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x4000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.LLC_WAYS_RES",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x8000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.NOTALLOWSNOOP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x10000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.TOPA_MATCH",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x20000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.IVEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x40000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.BLEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x80000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.ADEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x100000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.AKEGRCREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x200000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.HACREDIT",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x400000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_AD_REQ",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x800000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_AD_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x1000000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_PIPE_REJECT.VN_BL_RSP",
      EventDef::Encoding{.code = 0x42, .umask = 0x00, .umaskExt = 0x2000000},
      R"(Pipe Rejects)",
      R"(Pipe Rejects : More Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC0",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC0)",
      R"(CHA iMC CHNx READ Credits Empty : MC0 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC1",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC1)",
      R"(CHA iMC CHNx READ Credits Empty : MC1 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC2",
      EventDef::Encoding{.code = 0x58, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC2)",
      R"(CHA iMC CHNx READ Credits Empty : MC2 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC3",
      EventDef::Encoding{.code = 0x58, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC3)",
      R"(CHA iMC CHNx READ Credits Empty : MC3 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC4",
      EventDef::Encoding{.code = 0x58, .umask = 0x10, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC4)",
      R"(CHA iMC CHNx READ Credits Empty : MC4 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC5",
      EventDef::Encoding{.code = 0x58, .umask = 0x20, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC5)",
      R"(CHA iMC CHNx READ Credits Empty : MC5 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC6",
      EventDef::Encoding{.code = 0x58, .umask = 0x40, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC6)",
      R"(CHA iMC CHNx READ Credits Empty : MC6 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 6 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC7",
      EventDef::Encoding{.code = 0x58, .umask = 0x80, .umaskExt = 0x00},
      R"(CHA iMC CHNx READ Credits Empty : MC7)",
      R"(CHA iMC CHNx READ Credits Empty : MC7 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 7 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC8",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x01},
      R"(CHA iMC CHNx READ Credits Empty : MC8)",
      R"(CHA iMC CHNx READ Credits Empty : MC8 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 8 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC9",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x02},
      R"(CHA iMC CHNx READ Credits Empty : MC9)",
      R"(CHA iMC CHNx READ Credits Empty : MC9 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 9 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC10",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x04},
      R"(CHA iMC CHNx READ Credits Empty : MC10)",
      R"(CHA iMC CHNx READ Credits Empty : MC10 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 10 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC11",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x08},
      R"(CHA iMC CHNx READ Credits Empty : MC11)",
      R"(CHA iMC CHNx READ Credits Empty : MC11 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 11 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC12",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x10},
      R"(CHA iMC CHNx READ Credits Empty : MC12)",
      R"(CHA iMC CHNx READ Credits Empty : MC12 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 12 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC13",
      EventDef::Encoding{.code = 0x58, .umask = 0x00, .umaskExt = 0x20},
      R"(CHA iMC CHNx READ Credits Empty : MC13)",
      R"(CHA iMC CHNx READ Credits Empty : MC13 : Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue. : Filter for memory controller 13 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : IRQ)",
      R"(Ingress (from CMS) Allocations : IRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : IRQ Rejected)",
      R"(Ingress (from CMS) Allocations : IRQ Rejected : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : PRQ)",
      R"(Ingress (from CMS) Allocations : PRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Allocations : PRQ)",
      R"(Ingress (from CMS) Allocations : PRQ : Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0 : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0 : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0 : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x08, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0 : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x10, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0 : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x20, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0 : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x40, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x80, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request)",
      R"(IRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : ANY0)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : ANY0 : Any condition listed in the IRQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : HA)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x04, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x08, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : SF Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : SF Victim : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC or SF Way)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : LLC or SF Way : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x19, .umask = 0x40, .umaskExt = 0x00},
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      R"(IRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : AD REQ on VN0)",
      R"(ISMQ Rejects - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : AD RSP on VN0)",
      R"(ISMQ Rejects - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x04, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL RSP on VN0)",
      R"(ISMQ Rejects - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x08, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL WB on VN0)",
      R"(ISMQ Rejects - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x10, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL NCB on VN0)",
      R"(ISMQ Rejects - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x20, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : BL NCS on VN0)",
      R"(ISMQ Rejects - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x40, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : Non UPI AK Request)",
      R"(ISMQ Rejects - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x80, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 0 : Non UPI IV Request)",
      R"(ISMQ Rejects - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : AD REQ on VN0)",
      R"(ISMQ Retries - Set 0 : AD REQ on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : AD RSP on VN0)",
      R"(ISMQ Retries - Set 0 : AD RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL RSP on VN0)",
      R"(ISMQ Retries - Set 0 : BL RSP on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL WB on VN0)",
      R"(ISMQ Retries - Set 0 : BL WB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x10, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL NCB on VN0)",
      R"(ISMQ Retries - Set 0 : BL NCB on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x20, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : BL NCS on VN0)",
      R"(ISMQ Retries - Set 0 : BL NCS on VN0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x40, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : Non UPI AK Request)",
      R"(ISMQ Retries - Set 0 : Non UPI AK Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x80, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 0 : Non UPI IV Request)",
      R"(ISMQ Retries - Set 0 : Non UPI IV Request : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x25, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 1 : ANY0)",
      R"(ISMQ Rejects - Set 1 : ANY0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Any condition listed in the ISMQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x25, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Rejects - Set 1 : HA)",
      R"(ISMQ Rejects - Set 1 : HA : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2D, .umask = 0x01, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 1 : ANY0)",
      R"(ISMQ Retries - Set 1 : ANY0 : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores. : Any condition listed in the ISMQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.HA",
      EventDef::Encoding{.code = 0x2D, .umask = 0x02, .umaskExt = 0x00},
      R"(ISMQ Retries - Set 1 : HA)",
      R"(ISMQ Retries - Set 1 : HA : Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.IRQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Occupancy : IRQ)",
      R"(Ingress (from CMS) Occupancy : IRQ : Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x01, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : AD REQ on VN0)",
      R"(Other Retries - Set 0 : AD REQ on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x02, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : AD RSP on VN0)",
      R"(Other Retries - Set 0 : AD RSP on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x04, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL RSP on VN0)",
      R"(Other Retries - Set 0 : BL RSP on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x08, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL WB on VN0)",
      R"(Other Retries - Set 0 : BL WB on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x10, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL NCB on VN0)",
      R"(Other Retries - Set 0 : BL NCB on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x20, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : BL NCS on VN0)",
      R"(Other Retries - Set 0 : BL NCS on VN0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x40, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : Non UPI AK Request)",
      R"(Other Retries - Set 0 : Non UPI AK Request : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x80, .umaskExt = 0x00},
      R"(Other Retries - Set 0 : Non UPI IV Request)",
      R"(Other Retries - Set 0 : Non UPI IV Request : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2F, .umask = 0x01, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : ANY0)",
      R"(Other Retries - Set 1 : ANY0 : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Any condition listed in the Other0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.HA",
      EventDef::Encoding{.code = 0x2F, .umask = 0x02, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : HA)",
      R"(Other Retries - Set 1 : HA : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x04, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : LLC Victim)",
      R"(Other Retries - Set 1 : LLC Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x08, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : SF Victim)",
      R"(Other Retries - Set 1 : SF Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x10, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : Victim)",
      R"(Other Retries - Set 1 : Victim : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2F, .umask = 0x20, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : LLC OR SF Way)",
      R"(Other Retries - Set 1 : LLC OR SF Way : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2F, .umask = 0x40, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : Allow Snoop)",
      R"(Other Retries - Set 1 : Allow Snoop : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2F, .umask = 0x80, .umaskExt = 0x00},
      R"(Other Retries - Set 1 : PhyAddr Match)",
      R"(Other Retries - Set 1 : PhyAddr Match : Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject) : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD REQ on VN0 : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : AD RSP on VN0 : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL RSP on VN0 : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x08, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL WB on VN0 : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x10, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCB on VN0 : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x20, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : BL NCS on VN0 : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x40, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI AK Request : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x80, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request)",
      R"(PRQ Requests (from CMS) Rejected - Set 0 : Non UPI IV Request : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : ANY0)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : ANY0 : Any condition listed in the PRQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : HA)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x04, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x08, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : SF Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : SF Victim : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x10, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x21, .umask = 0x20, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : LLC OR SF Way : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x21, .umask = 0x40, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x21, .umask = 0x80, .umaskExt = 0x00},
      R"(PRQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match)",
      R"(PRQ Requests (from CMS) Rejected - Set 1 : PhyAddr Match : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x01, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : AD REQ on VN0)",
      R"(Request Queue Retries - Set 0 : AD REQ on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No AD VN0 credit for generating a request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x02, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : AD RSP on VN0)",
      R"(Request Queue Retries - Set 0 : AD RSP on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No AD VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x04, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL RSP on VN0)",
      R"(Request Queue Retries - Set 0 : BL RSP on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for generating a response)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x08, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL WB on VN0)",
      R"(Request Queue Retries - Set 0 : BL WB on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for generating a writeback)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL NCB on VN0)",
      R"(Request Queue Retries - Set 0 : BL NCB on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : BL NCS on VN0)",
      R"(Request Queue Retries - Set 0 : BL NCS on VN0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : No BL VN0 credit for NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : Non UPI AK Request)",
      R"(Request Queue Retries - Set 0 : Non UPI AK Request : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Can't inject AK ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 0 : Non UPI IV Request)",
      R"(Request Queue Retries - Set 0 : Non UPI IV Request : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Can't inject IV ring message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2B, .umask = 0x01, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : ANY0)",
      R"(Request Queue Retries - Set 1 : ANY0 : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Any condition listed in the WBQ0 Reject counter was true)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.HA",
      EventDef::Encoding{.code = 0x2B, .umask = 0x02, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : HA)",
      R"(Request Queue Retries - Set 1 : HA : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x04, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : LLC Victim)",
      R"(Request Queue Retries - Set 1 : LLC Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x08, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : SF Victim)",
      R"(Request Queue Retries - Set 1 : SF Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Requests did not generate Snoop filter victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x10, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : Victim)",
      R"(Request Queue Retries - Set 1 : Victim : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2B, .umask = 0x20, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : LLC OR SF Way)",
      R"(Request Queue Retries - Set 1 : LLC OR SF Way : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Way conflict with another request that caused the reject)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2B, .umask = 0x40, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : Allow Snoop)",
      R"(Request Queue Retries - Set 1 : Allow Snoop : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2B, .umask = 0x80, .umaskExt = 0x00},
      R"(Request Queue Retries - Set 1 : PhyAddr Match)",
      R"(Request Queue Retries - Set 1 : PhyAddr Match : REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ) : Address match with an outstanding request that was rejected.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.ALL",
      EventDef::Encoding{.code = 0x51, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoops Sent : All)",
      R"(Snoops Sent : All : Counts the number of snoops issued by the HA.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoops Sent : Snoops sent for Local Requests)",
      R"(Snoops Sent : Snoops sent for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast or directed snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.BCST_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoops Sent : Broadcast snoops for Local Requests)",
      R"(Snoops Sent : Broadcast snoops for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of broadcast snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.DIRECT_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoops Sent : Directed snoops for Local Requests)",
      R"(Snoops Sent : Directed snoops for Local Requests : Counts the number of snoops issued by the HA. : Counts the number of directed snoops issued by the HA responding to local requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPI",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspI)",
      R"(Snoop Responses Received Local : RspI : Number of snoop responses received for a Local  request : Filters for snoops responses of RspI to local CA requests.  RspI is returned when the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO hits non-modified data).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPS",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspS)",
      R"(Snoop Responses Received Local : RspS : Number of snoop responses received for a Local  request : Filters for snoop responses of RspS to local CA requests.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPIFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspIFwd)",
      R"(Snoop Responses Received Local : RspIFwd : Number of snoop responses received for a Local  request : Filters for snoop responses of RspIFwd to local CA requests.  This is returned when a remote caching agent forwards data and the requesting agent is able to acquire the data in E or M states.  This is commonly returned with RFO transactions.  It can be either a HitM or a HitFE.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPSFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x08, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspSFwd)",
      R"(Snoop Responses Received Local : RspSFwd : Number of snoop responses received for a Local  request : Filters for a snoop response of RspSFwd to local CA requests.  This is returned when a remote caching agent forwards data but holds on to its currently copy.  This is common for data and code reads that hit in a remote socket in E or F state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPWB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : Rsp*WB)",
      R"(Snoop Responses Received Local : Rsp*WB : Number of snoop responses received for a Local  request : Filters for a snoop response of RspIWB or RspSWB to local CA requests.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPFWDWB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : Rsp*FWD*WB)",
      R"(Snoop Responses Received Local : Rsp*FWD*WB : Number of snoop responses received for a Local  request : Filters for a snoop response of Rsp*Fwd*WB to local CA requests.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPCNFLCT",
      EventDef::Encoding{.code = 0x5D, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspCnflct)",
      R"(Snoop Responses Received Local : RspCnflct : Number of snoop responses received for a Local  request : Filters for snoops responses of RspConflict to local CA requests.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x80, .umaskExt = 0x00},
      R"(Snoop Responses Received Local : RspFwd)",
      R"(Snoop Responses Received Local : RspFwd : Number of snoop responses received for a Local  request : Filters for a snoop response of RspFwd to local CA requests.  This snoop response is only possible for RdCur when a snoop HITM/E in a remote caching agent and it directly forwards data to a requestor without changing the requestor's cache line state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.MTOI_RSPIFWDM",
      EventDef::Encoding{.code = 0x6B, .umask = 0x01, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : MtoI RspIFwdM)",
      R"(Misc Snoop Responses Received : MtoI RspIFwdM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.MTOI_RSPDATAM",
      EventDef::Encoding{.code = 0x6B, .umask = 0x02, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : MtoI RspIDataM)",
      R"(Misc Snoop Responses Received : MtoI RspIDataM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.RSPIFWDMPTL_HITSF",
      EventDef::Encoding{.code = 0x6B, .umask = 0x04, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit SF)",
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit SF)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.RSPIFWDMPTL_HITLLC",
      EventDef::Encoding{.code = 0x6B, .umask = 0x08, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit LLC)",
      R"(Misc Snoop Responses Received : RspIFwdPtl Hit LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.PULLDATAPTL_HITSF",
      EventDef::Encoding{.code = 0x6B, .umask = 0x10, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit SF)",
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit SF)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RSP_MISC.PULLDATAPTL_HITLLC",
      EventDef::Encoding{.code = 0x6B, .umask = 0x20, .umaskExt = 0x00},
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit LLC)",
      R"(Misc Snoop Responses Received : Pull Data Partial - Hit LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.LLC",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .umaskExt = 0x00},
      R"(WbPushMtoI : Pushed to LLC)",
      R"(WbPushMtoI : Pushed to LLC : Counts the number of times when the CHA was received WbPushMtoI : Counts the number of times when the CHA was able to push WbPushMToI to LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.MEM",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .umaskExt = 0x00},
      R"(WbPushMtoI : Pushed to Memory)",
      R"(WbPushMtoI : Pushed to Memory : Counts the number of times when the CHA was received WbPushMtoI : Counts the number of times when the CHA was unable to push WbPushMToI to LLC (hence pushed it to MEM))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC0",
      EventDef::Encoding{.code = 0x5A, .umask = 0x01, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC0)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC0 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC1",
      EventDef::Encoding{.code = 0x5A, .umask = 0x02, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC1)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC1 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC2",
      EventDef::Encoding{.code = 0x5A, .umask = 0x04, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC2)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC2 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC3",
      EventDef::Encoding{.code = 0x5A, .umask = 0x08, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC3)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC3 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC4",
      EventDef::Encoding{.code = 0x5A, .umask = 0x10, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC4)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC4 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC5",
      EventDef::Encoding{.code = 0x5A, .umask = 0x20, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC5)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC5 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC6",
      EventDef::Encoding{.code = 0x5A, .umask = 0x40, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC6)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC6 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 6 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC7",
      EventDef::Encoding{.code = 0x5A, .umask = 0x80, .umaskExt = 0x00},
      R"(CHA iMC CHNx WRITE Credits Empty : MC7)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC7 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 7 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC8",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x01},
      R"(CHA iMC CHNx WRITE Credits Empty : MC8)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC8 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 8 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC9",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x02},
      R"(CHA iMC CHNx WRITE Credits Empty : MC9)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC9 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 9 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC10",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x04},
      R"(CHA iMC CHNx WRITE Credits Empty : MC10)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC10 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 10 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC11",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x08},
      R"(CHA iMC CHNx WRITE Credits Empty : MC11)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC11 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 11 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC12",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x10},
      R"(CHA iMC CHNx WRITE Credits Empty : MC12)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC12 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 12 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC13",
      EventDef::Encoding{.code = 0x5A, .umask = 0x00, .umaskExt = 0x20},
      R"(CHA iMC CHNx WRITE Credits Empty : MC13)",
      R"(CHA iMC CHNx WRITE Credits Empty : MC13 : Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue. : Filter for memory controller 13 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.SENT0",
      EventDef::Encoding{.code = 0x6f, .umask = 0x01, .umaskExt = 0x00},
      R"(XPT Prefetches : Sent (on 0?))",
      R"(XPT Prefetches : Sent (on 0?) : Number of XPT prefetches sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP0_NOCRD",
      EventDef::Encoding{.code = 0x6f, .umask = 0x04, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 0?) - No Credits)",
      R"(XPT Prefetches : Dropped (on 0?) - No Credits : Number of XPT prefetches dropped due to lack of XPT AD egress credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP0_CONFLICT",
      EventDef::Encoding{.code = 0x6f, .umask = 0x08, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 0?) - Conflict)",
      R"(XPT Prefetches : Dropped (on 0?) - Conflict : Number of XPT prefetches dropped due to AD CMS write port contention)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.SENT1",
      EventDef::Encoding{.code = 0x6f, .umask = 0x10, .umaskExt = 0x00},
      R"(XPT Prefetches : Sent (on 1?))",
      R"(XPT Prefetches : Sent (on 1?) : Number of XPT prefetches sent)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP1_NOCRD",
      EventDef::Encoding{.code = 0x6f, .umask = 0x40, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 1?) - No Credits)",
      R"(XPT Prefetches : Dropped (on 1?) - No Credits : Number of XPT prefetches dropped due to lack of XPT AD egress credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XPT_PREF.DROP1_CONFLICT",
      EventDef::Encoding{.code = 0x6f, .umask = 0x80, .umaskExt = 0x00},
      R"(XPT Prefetches : Dropped (on 1?) - Conflict)",
      R"(XPT Prefetches : Dropped (on 1?) - Conflict : Number of XPT prefetches dropped due to AD CMS write port contention)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART4",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART5",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART6",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART7",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART4",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART5",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART6",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART7",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.FIRST_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(: IOTLB lookups first)",
      R"(: IOTLB lookups first : Some transactions have to look up IOTLB multiple times.  Counts the first time a request looks up IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.ALL_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(: IOTLB lookups all)",
      R"(: IOTLB lookups all : Some transactions have to look up IOTLB multiple times.  Counts every time a request looks up IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.4K_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 4K Page)",
      R"(: IOTLB Hits to a 4K Page : Counts if a transaction to a 4K page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.2M_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x08, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 2M Page)",
      R"(: IOTLB Hits to a 2M Page : Counts if a transaction to a 2M page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.1G_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x10, .umaskExt = 0x00},
      R"(: IOTLB Hits to a 1G Page)",
      R"(: IOTLB Hits to a 1G Page : Counts if a transaction to a 1G page, on its first lookup, hits the IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.MISSES",
      EventDef::Encoding{.code = 0x40, .umask = 0x20, .umaskExt = 0x00},
      R"(: IOTLB Fills (same as IOTLB miss))",
      R"(: IOTLB Fills (same as IOTLB miss) : When a transaction misses IOTLB, it does a page walk to look up memory and bring in the relevant page translation. Counts when this page translation is written to IOTLB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.CTXT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x40, .umask = 0x40, .umaskExt = 0x00},
      R"(: Context cache lookups)",
      R"(: Context cache lookups : Counts each time a transaction looks up root context cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU0.CTXT_CACHE_HITS",
      EventDef::Encoding{.code = 0x40, .umask = 0x80, .umaskExt = 0x00},
      R"(: Context cache hits)",
      R"(: Context cache hits : Counts each time a first look up of the transaction hits the RCC.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.PWT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x41, .umask = 0x01, .umaskExt = 0x00},
      R"(: PageWalk cache lookup)",
      R"(: PageWalk cache lookup : Counts each time a transaction looks up second level page walk cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.NUM_MEM_ACCESSES",
      EventDef::Encoding{.code = 0x41, .umask = 0x40, .umaskExt = 0x00},
      R"(: IOMMU memory access)",
      R"(: IOMMU memory access : IOMMU sends out memory fetches when it misses the cache look up which is indicated by this signal.  M2IOSF only uses low priority channel)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU1.CYC_PWT_FULL",
      EventDef::Encoding{.code = 0x41, .umask = 0x80, .umaskExt = 0x00},
      R"(: Cycles PWT full)",
      R"(: Cycles PWT full : Counts cycles the IOMMU has reached its maximum limit for outstanding page walks.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU3.INT_CACHE_LOOKUPS",
      EventDef::Encoding{.code = 0x43, .umask = 0x40, .umaskExt = 0x00},
      R"(: Interrupt Entry cache lookup)",
      R"(: Interrupt Entry cache lookup : Counts the number of transaction looks up that interrupt remapping cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_IOMMU3.INT_CACHE_HITS",
      EventDef::Encoding{.code = 0x43, .umask = 0x80, .umaskExt = 0x00},
      R"(: Interrupt Entry cache hit)",
      R"(: Interrupt Entry cache hit : Counts each time a transaction's first look up hits the IEC.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0",
      EventDef::Encoding{.code = 0x02, .umask = 0x01, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus)",
      R"(AND Mask/match for debug bus : Non-PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x02, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : PCIE bus)",
      R"(AND Mask/match for debug bus : PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x04, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus and !(PCIE bus))",
      R"(AND Mask/match for debug bus : Non-PCIE bus and !(PCIE bus) : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x08, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : Non-PCIE bus and PCIE bus)",
      R"(AND Mask/match for debug bus : Non-PCIE bus and PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x10, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus)",
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x02, .umask = 0x20, .umaskExt = 0x00},
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus))",
      R"(AND Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus) : Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0",
      EventDef::Encoding{.code = 0x03, .umask = 0x01, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus)",
      R"(OR Mask/match for debug bus : Non-PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x02, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : PCIE bus)",
      R"(OR Mask/match for debug bus : PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x04, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus and !(PCIE bus))",
      R"(OR Mask/match for debug bus : Non-PCIE bus and !(PCIE bus) : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x08, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : Non-PCIE bus and PCIE bus)",
      R"(OR Mask/match for debug bus : Non-PCIE bus and PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x10, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus)",
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and PCIE bus : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x03, .umask = 0x20, .umaskExt = 0x00},
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus))",
      R"(OR Mask/match for debug bus : !(Non-PCIE bus) and !(PCIE bus) : Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_NUM_REQ_OF_CPU.ALL.DROP",
      EventDef::Encoding{.code = 0x85, .umask = 0x02, .umaskExt = 0x00},
      R"(Number requests PCIe makes of the main die : Drop request)",
      R"(Number requests PCIe makes of the main die : Drop request : Counts full PCIe requests before they're broken into a series of cache-line size requests as measured by DATA_REQ_OF_CPU and TXN_REQ_OF_CPU. : Packet error detected, must be dropped)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART4",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART5",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART6",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART7",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART0",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 0/1/2/3, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART1",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART2",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART3",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART4",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x16 card plugged in to Lane 4/5/6/7, Or x8 card plugged in to Lane 4/5, Or x4 card is plugged in to slot 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART5",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART6",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x8 card plugged in to Lane 6/7, Or x4 card is plugged in to slot 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.PART7",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : x4 card is plugged in to slot 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.ANY",
      EventDef::Encoding{.code = 0x0F, .umask = 0x01, .umaskExt = 0x00},
      R"(Total Write Cache Occupancy : Any Source)",
      R"(Total Write Cache Occupancy : Any Source : Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events. : Tracks all requests from any source port.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.IV_Q",
      EventDef::Encoding{.code = 0x0F, .umask = 0x02, .umaskExt = 0x00},
      R"(Total Write Cache Occupancy : Snoops)",
      R"(Total Write Cache Occupancy : Snoops : Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.CLFLUSH",
      EventDef::Encoding{.code = 0x10, .umask = 0x80, .umaskExt = 0x00},
      R"(Coherent Ops : CLFlush)",
      R"(Coherent Ops : CLFlush : Counts the number of coherency related operations serviced by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.OUTBOUND_INSERTS",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.EVICTS",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .umaskExt = 0x00},
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      R"(: All Inserts Outbound (BL, AK, Snoops))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REQ",
      EventDef::Encoding{.code = 0x1e, .umask = 0x01, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Requests)",
      R"(Counts Timeouts - Set 0 : Fastpath Requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REJ",
      EventDef::Encoding{.code = 0x1E, .umask = 0x02, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Rejects)",
      R"(Counts Timeouts - Set 0 : Fastpath Rejects)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_RD_INSERT",
      EventDef::Encoding{.code = 0x1e, .umask = 0x04, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Read Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Read Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_WR_INSERT",
      EventDef::Encoding{.code = 0x1e, .umask = 0x08, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Write Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Write Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_ATOMIC_INSERT",
      EventDef::Encoding{.code = 0x1E, .umask = 0x10, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Cache Inserts of Atomic Transactions as Secondary)",
      R"(Counts Timeouts - Set 0 : Cache Inserts of Atomic Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_XFER",
      EventDef::Encoding{.code = 0x1E, .umask = 0x20, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Fastpath Transfers From Primary to Secondary)",
      R"(Counts Timeouts - Set 0 : Fastpath Transfers From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.PF_ACK_HINT",
      EventDef::Encoding{.code = 0x1E, .umask = 0x40, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Prefetch Ack Hints From Primary to Secondary)",
      R"(Counts Timeouts - Set 0 : Prefetch Ack Hints From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.SLOWPATH_FWPF_NO_PRF",
      EventDef::Encoding{.code = 0x1E, .umask = 0x80, .umaskExt = 0x00},
      R"(Counts Timeouts - Set 0 : Slow path fwpf didn't find prefetch)",
      R"(Counts Timeouts - Set 0 : Slow path fwpf didn't find prefetch)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_I",
      EventDef::Encoding{.code = 0x1f, .umask = 0x01, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of I Line)",
      R"(Misc Events - Set 1 : Slow Transfer of I Line : Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_S",
      EventDef::Encoding{.code = 0x1f, .umask = 0x02, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of S Line)",
      R"(Misc Events - Set 1 : Slow Transfer of S Line : Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_E",
      EventDef::Encoding{.code = 0x1f, .umask = 0x04, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of E Line)",
      R"(Misc Events - Set 1 : Slow Transfer of E Line : Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_M",
      EventDef::Encoding{.code = 0x1f, .umask = 0x08, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Slow Transfer of M Line)",
      R"(Misc Events - Set 1 : Slow Transfer of M Line : Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_INVLD",
      EventDef::Encoding{.code = 0x1F, .umask = 0x20, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Received Invalid)",
      R"(Misc Events - Set 1 : Received Invalid : Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_VLD",
      EventDef::Encoding{.code = 0x1F, .umask = 0x40, .umaskExt = 0x00},
      R"(Misc Events - Set 1 : Received Valid)",
      R"(Misc Events - Set 1 : Received Valid : Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.RD",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(P2P Transactions : P2P reads)",
      R"(P2P Transactions : P2P reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.WR",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(P2P Transactions : P2P Writes)",
      R"(P2P Transactions : P2P Writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.MSG",
      EventDef::Encoding{.code = 0x13, .umask = 0x04, .umaskExt = 0x00},
      R"(P2P Transactions : P2P Message)",
      R"(P2P Transactions : P2P Message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.CMPL",
      EventDef::Encoding{.code = 0x13, .umask = 0x08, .umaskExt = 0x00},
      R"(P2P Transactions : P2P completions)",
      R"(P2P Transactions : P2P completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(P2P Transactions : Match if remote only)",
      R"(P2P Transactions : Match if remote only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(P2P Transactions : match if remote and target matches)",
      R"(P2P Transactions : match if remote and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC",
      EventDef::Encoding{.code = 0x13, .umask = 0x40, .umaskExt = 0x00},
      R"(P2P Transactions : match if local only)",
      R"(P2P Transactions : match if local only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x80, .umaskExt = 0x00},
      R"(P2P Transactions : match if local and target matches)",
      R"(P2P Transactions : match if local and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.MISS",
      EventDef::Encoding{.code = 0x12, .umask = 0x01, .umaskExt = 0x00},
      R"(Snoop Responses : Miss)",
      R"(Snoop Responses : Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_I",
      EventDef::Encoding{.code = 0x12, .umask = 0x02, .umaskExt = 0x00},
      R"(Snoop Responses : Hit I)",
      R"(Snoop Responses : Hit I)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_ES",
      EventDef::Encoding{.code = 0x12, .umask = 0x04, .umaskExt = 0x00},
      R"(Snoop Responses : Hit E or S)",
      R"(Snoop Responses : Hit E or S)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPCODE",
      EventDef::Encoding{.code = 0x12, .umask = 0x10, .umaskExt = 0x00},
      R"(Snoop Responses : SnpCode)",
      R"(Snoop Responses : SnpCode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPDATA",
      EventDef::Encoding{.code = 0x12, .umask = 0x20, .umaskExt = 0x00},
      R"(Snoop Responses : SnpData)",
      R"(Snoop Responses : SnpData)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPINV",
      EventDef::Encoding{.code = 0x12, .umask = 0x40, .umaskExt = 0x00},
      R"(Snoop Responses : SnpInv)",
      R"(Snoop Responses : SnpInv)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.WRITES",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Writes)",
      R"(Inbound Transaction Count : Writes : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks only write requests.  Each write request should have a prefetch, so there is no need to explicitly track these requests.  For writes that are tickled and have to retry, the counter will be incremented for each retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.ATOMIC",
      EventDef::Encoding{.code = 0x11, .umask = 0x10, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Atomic)",
      R"(Inbound Transaction Count : Atomic : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks the number of atomic transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.OTHER",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Other)",
      R"(Inbound Transaction Count : Other : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks the number of 'other' kinds of transactions.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.ORDERINGQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(Inbound Transaction Count : Select Source)",
      R"(Inbound Transaction Count : Select Source : Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID. : Tracks only those requests that come from the port specified in the IRP_PmonFilter.OrderingQ register.  This register allows one to select one specific queue.  It is not possible to monitor multiple queues at a time.  If this bit is not set, then requests from all sources will be counted.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_EGRESS.TAKEN",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Taken)",
      R"(M2M to iMC Bypass : Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_INGRESS.TAKEN",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Taken)",
      R"(M2M to iMC Bypass : Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_INGRESS.NOT_TAKEN",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC Bypass : Not Taken)",
      R"(M2M to iMC Bypass : Not Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : Normal Priority - Ch0)",
      R"(M2M Reads Issued to iMC : Normal Priority - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_ISOCH",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : Critical Priority - Ch0)",
      R"(M2M Reads Issued to iMC : Critical Priority - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch0)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH0_FROM_TGR",
      EventDef::Encoding{.code = 0x37, .umask = 0x40, .umaskExt = 0x01},
      R"(M2M Reads Issued to iMC : From TGR - Ch0)",
      R"(M2M Reads Issued to iMC : From TGR - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_NORMAL",
      EventDef::Encoding{.code = 0x37, .umask = 0x01, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : Normal Priority - Ch1)",
      R"(M2M Reads Issued to iMC : Normal Priority - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_ISOCH",
      EventDef::Encoding{.code = 0x37, .umask = 0x02, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : Critical Priority - Ch1)",
      R"(M2M Reads Issued to iMC : Critical Priority - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x04, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch1)",
      R"(M2M Reads Issued to iMC : All, regardless of priority. - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.CH1_FROM_TGR",
      EventDef::Encoding{.code = 0x37, .umask = 0x40, .umaskExt = 0x02},
      R"(M2M Reads Issued to iMC : From TGR - Ch1)",
      R"(M2M Reads Issued to iMC : From TGR - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch0)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch0)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FULL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x04, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch0)",
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_PARTIAL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x08, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch0)",
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x04},
      R"(M2M Writes Issued to iMC : All Writes - Ch0)",
      R"(M2M Writes Issued to iMC : All Writes - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_FROM_TGR",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x05},
      R"(M2M Writes Issued to iMC : From TGR - Ch0)",
      R"(M2M Writes Issued to iMC : From TGR - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch1)",
      R"(M2M Writes Issued to iMC : Full Line Non-ISOCH - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_PARTIAL",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch1)",
      R"(M2M Writes Issued to iMC : Partial Non-ISOCH - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FULL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x04, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch1)",
      R"(M2M Writes Issued to iMC : ISOCH Full Line - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_PARTIAL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x08, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch1)",
      R"(M2M Writes Issued to iMC : ISOCH Partial - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_ALL",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .umaskExt = 0x08},
      R"(M2M Writes Issued to iMC : All Writes - Ch1)",
      R"(M2M Writes Issued to iMC : All Writes - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_FROM_TGR",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x09},
      R"(M2M Writes Issued to iMC : From TGR - Ch1)",
      R"(M2M Writes Issued to iMC : From TGR - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MESH",
      EventDef::Encoding{.code = 0x4C, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Packet Header Matches : Mesh Match)",
      R"(Number Packet Header Matches : Mesh Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MC",
      EventDef::Encoding{.code = 0x4C, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Packet Header Matches : MC Match)",
      R"(Number Packet Header Matches : MC Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_REG_CRD.CH0",
      EventDef::Encoding{.code = 0x43, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 0)",
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_REG_CRD.CH1",
      EventDef::Encoding{.code = 0x43, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 1)",
      R"(M2M to iMC RPQ Cycles w/Credits - Regular : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_SPEC_CRD.CH0",
      EventDef::Encoding{.code = 0x44, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 0)",
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RPQ_NO_SPEC_CRD.CH1",
      EventDef::Encoding{.code = 0x44, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 1)",
      R"(M2M to iMC RPQ Cycles w/Credits - Special : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_FULL.CH0",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Cycles Full : Channel 0)",
      R"(Tracker Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_FULL.CH1",
      EventDef::Encoding{.code = 0x45, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Cycles Full : Channel 1)",
      R"(Tracker Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x49, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Inserts : Channel 0)",
      R"(Tracker Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x49, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Inserts : Channel 1)",
      R"(Tracker Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_NE.CH0",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Cycles Not Empty : Channel 0)",
      R"(Tracker Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_NE.CH1",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Cycles Not Empty : Channel 1)",
      R"(Tracker Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(Tracker Occupancy : Channel 0)",
      R"(Tracker Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(Tracker Occupancy : Channel 1)",
      R"(Tracker Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.NDR",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .umaskExt = 0x00},
      R"(Outbound Ring Transactions on AK : NDR Transactions)",
      R"(Outbound Ring Transactions on AK : NDR Transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.CRD_CBO",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .umaskExt = 0x00},
      R"(Outbound Ring Transactions on AK : CRD Transactions to Cbo)",
      R"(Outbound Ring Transactions on AK : CRD Transactions to Cbo)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x1D, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x1D, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.CMS0",
      EventDef::Encoding{.code = 0x14, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.CMS1",
      EventDef::Encoding{.code = 0x14, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.RDCRD0",
      EventDef::Encoding{.code = 0x14, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCRD0",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCMP0",
      EventDef::Encoding{.code = 0x14, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.RDCRD1",
      EventDef::Encoding{.code = 0x14, .umask = 0x88, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCRD1",
      EventDef::Encoding{.code = 0x14, .umask = 0x90, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.WRCMP1",
      EventDef::Encoding{.code = 0x14, .umask = 0xA0, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full)",
      R"(AK Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_FULL.ALL",
      EventDef::Encoding{.code = 0x14, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Full : All)",
      R"(AK Egress (to CMS) Full : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.CMS0",
      EventDef::Encoding{.code = 0x13, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.CMS1",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.RDCRD",
      EventDef::Encoding{.code = 0x13, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.WRCRD",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.WRCMP",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty)",
      R"(AK Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x13, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Not Empty : All)",
      R"(AK Egress (to CMS) Not Empty : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.CMS0",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.CMS1",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.RDCRD",
      EventDef::Encoding{.code = 0x11, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.WRCRD",
      EventDef::Encoding{.code = 0x11, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.WRCMP",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.PREF_RD_CAM_HIT",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations)",
      R"(AK Egress (to CMS) Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_INSERTS.ALL",
      EventDef::Encoding{.code = 0x11, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Allocations : All)",
      R"(AK Egress (to CMS) Allocations : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1F, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1F, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.CMS0",
      EventDef::Encoding{.code = 0x12, .umask = 0x01, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.CMS1",
      EventDef::Encoding{.code = 0x12, .umask = 0x02, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Occupancy : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.RDCRD",
      EventDef::Encoding{.code = 0x12, .umask = 0x08, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.WRCRD",
      EventDef::Encoding{.code = 0x12, .umask = 0x10, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.WRCMP",
      EventDef::Encoding{.code = 0x12, .umask = 0x20, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy)",
      R"(AK Egress (to CMS) Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_OCCUPANCY.ALL",
      EventDef::Encoding{.code = 0x12, .umask = 0x03, .umaskExt = 0x00},
      R"(AK Egress (to CMS) Occupancy : All)",
      R"(AK Egress (to CMS) Occupancy : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CACHE",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(Outbound DRS Ring Transactions to Cache : Data to Cache)",
      R"(Outbound DRS Ring Transactions to Cache : Data to Cache)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CORE",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(Outbound DRS Ring Transactions to Cache : Data to Core)",
      R"(Outbound DRS Ring Transactions to Cache : Data to Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Credit Acquired : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Full : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.ALL",
      EventDef::Encoding{.code = 0x18, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Full : All)",
      R"(BL Egress (to CMS) Full : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS0",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS1",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Not Empty : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x17, .umask = 0x03, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Not Empty : All)",
      R"(BL Egress (to CMS) Not Empty : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS0",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS1",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .umaskExt = 0x00},
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Allocations : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1B, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1B, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x1C, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x1C, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits : Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_FLUSH.CH0",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .umaskExt = 0x00},
      R"(WPQ Flush : Channel 0)",
      R"(WPQ Flush : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_FLUSH.CH1",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .umaskExt = 0x00},
      R"(WPQ Flush : Channel 1)",
      R"(WPQ Flush : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN0",
      EventDef::Encoding{.code = 0x4D, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 0)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN1",
      EventDef::Encoding{.code = 0x4D, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 1)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_REG_CRD.CHN2",
      EventDef::Encoding{.code = 0x4D, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 2)",
      R"(M2M->iMC WPQ Cycles w/Credits - Regular : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN0",
      EventDef::Encoding{.code = 0x4E, .umask = 0x01, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 0)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN1",
      EventDef::Encoding{.code = 0x4E, .umask = 0x02, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 1)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WPQ_NO_SPEC_CRD.CHN2",
      EventDef::Encoding{.code = 0x4E, .umask = 0x04, .umaskExt = 0x00},
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 2)",
      R"(M2M->iMC WPQ Cycles w/Credits - Special : Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.CH0",
      EventDef::Encoding{.code = 0x4A, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Channel 0)",
      R"(Write Tracker Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.CH1",
      EventDef::Encoding{.code = 0x4A, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Channel 1)",
      R"(Write Tracker Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_FULL.MIRR",
      EventDef::Encoding{.code = 0x4A, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Cycles Full : Mirror)",
      R"(Write Tracker Cycles Full : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Inserts : Channel 0)",
      R"(Write Tracker Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Inserts : Channel 1)",
      R"(Write Tracker Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.CH0",
      EventDef::Encoding{.code = 0x4B, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Channel 0)",
      R"(Write Tracker Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.CH1",
      EventDef::Encoding{.code = 0x4B, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Channel 1)",
      R"(Write Tracker Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty : Mirror)",
      R"(Write Tracker Cycles Not Empty : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS.CH0",
      EventDef::Encoding{.code = 0x63, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Inserts : Channel 0)",
      R"(Write Tracker Non-Posted Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_INSERTS.CH1",
      EventDef::Encoding{.code = 0x63, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Inserts : Channel 1)",
      R"(Write Tracker Non-Posted Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x62, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Occupancy : Channel 0)",
      R"(Write Tracker Non-Posted Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NONPOSTED_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x62, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Non-Posted Occupancy : Channel 1)",
      R"(Write Tracker Non-Posted Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x55, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Channel 0)",
      R"(Write Tracker Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x55, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Channel 1)",
      R"(Write Tracker Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR",
      EventDef::Encoding{.code = 0x55, .umask = 0x08, .umaskExt = 0x00},
      R"(Write Tracker Occupancy : Mirror)",
      R"(Write Tracker Occupancy : Mirror)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_INSERTS.CH0",
      EventDef::Encoding{.code = 0x5E, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Posted Inserts : Channel 0)",
      R"(Write Tracker Posted Inserts : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_INSERTS.CH1",
      EventDef::Encoding{.code = 0x5E, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Posted Inserts : Channel 1)",
      R"(Write Tracker Posted Inserts : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Tracker Posted Occupancy : Channel 0)",
      R"(Write Tracker Posted Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_POSTED_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Tracker Posted Occupancy : Channel 1)",
      R"(Write Tracker Posted Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.DRS_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x01, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : DRS)",
      R"(M2PCIe IIO Credit Acquired : DRS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.DRS_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x02, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : DRS)",
      R"(M2PCIe IIO Credit Acquired : DRS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCB_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x04, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCB)",
      R"(M2PCIe IIO Credit Acquired : NCB : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCB_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCB)",
      R"(M2PCIe IIO Credit Acquired : NCB : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCS_0",
      EventDef::Encoding{.code = 0x33, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCS)",
      R"(M2PCIe IIO Credit Acquired : NCS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_ACQUIRED.NCS_1",
      EventDef::Encoding{.code = 0x33, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Credit Acquired : NCS)",
      R"(M2PCIe IIO Credit Acquired : NCS : Counts the number of credits that are acquired in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credit for transfer through CMS Port 0s to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.DRS",
      EventDef::Encoding{.code = 0x34, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : DRS)",
      R"(M2PCIe IIO Failed to Acquire a Credit : DRS : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.NCB",
      EventDef::Encoding{.code = 0x34, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : NCB)",
      R"(M2PCIe IIO Failed to Acquire a Credit : NCB : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_REJECT.NCS",
      EventDef::Encoding{.code = 0x34, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Failed to Acquire a Credit : NCS)",
      R"(M2PCIe IIO Failed to Acquire a Credit : NCS : Counts the number of times that a request pending in the BL Ingress attempted to acquire either a NCB or NCS credit to transmit into the IIO, but was rejected because no credits were available.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.DRS_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x01, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.DRS_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x02, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : DRS to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the DRS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCB_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x04, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCB_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x08, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : NCB to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCB message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCS_0",
      EventDef::Encoding{.code = 0x32, .umask = 0x10, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 0)",
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 0 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credits for transfer through CMS Port 0 to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_IIO_CREDITS_USED.NCS_1",
      EventDef::Encoding{.code = 0x32, .umask = 0x20, .umaskExt = 0x00},
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 1)",
      R"(M2PCIe IIO Credits in Use : NCS to CMS Port 1 : Counts the number of cycles when one or more credits in the M2PCIe agent for sending transactions into the IIO on either NCB or NCS are in use.  Transactions from the BL ring going into the IIO Agent must first acquire a credit.  These credits are for either the NCB or NCS message classes.  NCB, or non-coherent bypass messages are used to transmit data without coherency (and are common).  NCS is used for reads to PCIe (and should be used sparingly). : Credit for transfer through CMS Port 0s to the IIO for the NCS message class.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.IIO_NCB",
      EventDef::Encoding{.code = 0x10, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.IIO_NCS",
      EventDef::Encoding{.code = 0x10, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x10, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.IIO_NCB",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.IIO_NCS",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.ALL",
      EventDef::Encoding{.code = 0x11, .umask = 0x80, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AD_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AK_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x02, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.BL_0",
      EventDef::Encoding{.code = 0x25, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AD_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.AK_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x20, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_FULL.BL_1",
      EventDef::Encoding{.code = 0x25, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Full)",
      R"(Egress (to CMS) Cycles Full : Counts the number of cycles when the M2PCIe Egress is full.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AD_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AK_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.BL_0",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AD_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.AK_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x20, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CYCLES_NE.BL_1",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Cycles Not Empty)",
      R"(Egress (to CMS) Cycles Not Empty : Counts the number of cycles when the M2PCIe Egress is not empty.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple egress buffers can be tracked at a given time using multiple counters.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AD_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.BL_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AK_CRD_0",
      EventDef::Encoding{.code = 0x24, .umask = 0x08, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AD_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x10, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.BL_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x40, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_INSERTS.AK_CRD_1",
      EventDef::Encoding{.code = 0x24, .umask = 0x80, .umaskExt = 0x00},
      R"(Egress (to CMS) Ingress)",
      R"(Egress (to CMS) Ingress : Counts the number of number of messages inserted into the  the M2PCIe Egress queue.  This tracks messages for one of the two CMS ports that are used by the M2PCIe agent.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.VLW_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x01, .umaskExt = 0x00},
      R"(Message Received : VLW)",
      R"(Message Received : VLW : Virtual Logical Wire (legacy) message were received from Uncore.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.MSI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x02, .umaskExt = 0x00},
      R"(Message Received : MSI)",
      R"(Message Received : MSI : Message Signaled Interrupts - interrupts sent by devices (including PCIe via IOxAPIC) (Socket Mode only))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.IPI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x04, .umaskExt = 0x00},
      R"(Message Received : IPI)",
      R"(Message Received : IPI : Inter Processor Interrupts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.DOORBELL_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x08, .umaskExt = 0x00},
      R"(Message Received : Doorbell)",
      R"(Message Received : Doorbell)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.INT_PRIO",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .umaskExt = 0x00},
      R"(Message Received : Interrupt)",
      R"(Message Received : Interrupt : Interrupts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_PHOLD_CYCLES.ASSERT_TO_ACK",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles PHOLD Assert to Ack : Assert to ACK)",
      R"(Cycles PHOLD Assert to Ack : Assert to ACK : PHOLD cycles.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDRAND",
      EventDef::Encoding{.code = 0x4C, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.RDRAND)",
      R"(UNC_U_RACU_DRNG.RDRAND)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDSEED",
      EventDef::Encoding{.code = 0x4C, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.RDSEED)",
      R"(UNC_U_RACU_DRNG.RDSEED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY",
      EventDef::Encoding{.code = 0x4C, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_ACT_COUNT.BYP",
      EventDef::Encoding{.code = 0x01, .umask = 0x08, .umaskExt = 0x00},
      R"(DRAM Activate Count : Activate due to Bypass)",
      R"(DRAM Activate Count : Activate due to Bypass : Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_PRE_REG",
      EventDef::Encoding{.code = 0x04, .umask = 0x02, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS commands w/auto-pre)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS commands w/auto-pre : DRAM RD_CAS and WR_CAS Commands : Counts the total number or DRAM Read CAS commands issued on this channel.  This includes both regular RD CAS commands as well as those with explicit Precharge.  AutoPre is only used in systems that are using closed page policy.  We do not filter based on major mode, as RD_CAS is not issued during WMM (with the exception of underfills).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_PRE_UNDERFILL",
      EventDef::Encoding{.code = 0x04, .umask = 0x08, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands.)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM RD_CAS and WR_CAS Commands)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.WR_PRE",
      EventDef::Encoding{.code = 0x04, .umask = 0x20, .umaskExt = 0x00},
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM WR_CAS commands w/ auto-pre)",
      R"(DRAM RD_CAS and WR_CAS Commands. : DRAM WR_CAS commands w/ auto-pre : DRAM RD_CAS and WR_CAS Commands)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_0",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_1",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_2",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.LOW_3",
      EventDef::Encoding{.code = 0x47, .umask = 0x08, .umaskExt = 0x00},
      R"(CKE_ON_CYCLES by Rank : DIMM ID)",
      R"(CKE_ON_CYCLES by Rank : DIMM ID : Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CRIT_THROTTLE_CYCLES.SLOT0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1. : Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CRIT_THROTTLE_CYCLES.SLOT1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.SLOT0",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1. : Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.SLOT1",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Throttle Cycles for Rank 0)",
      R"(Throttle Cycles for Rank 0 : Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_NE.PCH0",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(Read Pending Queue Not Empty)",
      R"(Read Pending Queue Not Empty : Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_NE.PCH1",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(Read Pending Queue Not Empty)",
      R"(Read Pending Queue Not Empty : Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_NE.PCH0",
      EventDef::Encoding{.code = 0x21, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue Not Empty)",
      R"(Write Pending Queue Not Empty : Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the CHA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have posted to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_NE.PCH1",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue Not Empty)",
      R"(Write Pending Queue Not Empty : Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the CHA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have posted to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_READ_HIT.PCH0",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_READ_HIT.PCH1",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_WRITE_HIT.PCH0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_WRITE_HIT.PCH1",
      EventDef::Encoding{.code = 0x24, .umask = 0x02, .umaskExt = 0x00},
      R"(Write Pending Queue CAM Match)",
      R"(Write Pending Queue CAM Match : Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.I",
      EventDef::Encoding{.code = 0x34, .umask = 0x01, .umaskExt = 0x00},
      R"(Cache Lookups : I State)",
      R"(Cache Lookups : I State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_S",
      EventDef::Encoding{.code = 0x34, .umask = 0x02, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - S State)",
      R"(Cache Lookups : SnoopFilter - S State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit Shared State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_E",
      EventDef::Encoding{.code = 0x34, .umask = 0x04, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - E State)",
      R"(Cache Lookups : SnoopFilter - E State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit Exclusive State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.SF_H",
      EventDef::Encoding{.code = 0x34, .umask = 0x08, .umaskExt = 0x00},
      R"(Cache Lookups : SnoopFilter - H State)",
      R"(Cache Lookups : SnoopFilter - H State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : SF Hit HitMe State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.S",
      EventDef::Encoding{.code = 0x34, .umask = 0x10, .umaskExt = 0x00},
      R"(Cache Lookups : S State)",
      R"(Cache Lookups : S State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Shared State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.E",
      EventDef::Encoding{.code = 0x34, .umask = 0x20, .umaskExt = 0x00},
      R"(Cache Lookups : E State)",
      R"(Cache Lookups : E State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Exclusive State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.M",
      EventDef::Encoding{.code = 0x34, .umask = 0x40, .umaskExt = 0x00},
      R"(Cache Lookups : M State)",
      R"(Cache Lookups : M State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Modified State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.F",
      EventDef::Encoding{.code = 0x34, .umask = 0x80, .umaskExt = 0x00},
      R"(Cache Lookups : F State)",
      R"(Cache Lookups : F State : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS select a state or states (in the umask field) to match.  Otherwise, the event will count nothing. : Hit Forward State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.RFO",
      EventDef::Encoding{.code = 0x34, .umask = 0xFF, .umaskExt = 0x1BC8},
      R"(Cache Lookups : RFO Requests)",
      R"(Cache Lookups : RFO Requests : Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing. : Local or remote RFO transactions to the LLC.  This includes RFO prefetch.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IRQ_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .umaskExt = 0x00},
      R"(TOR Inserts : IRQ - iA)",
      R"(TOR Inserts : IRQ - iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : From an iA Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.EVICT",
      EventDef::Encoding{.code = 0x35, .umask = 0x02, .umaskExt = 0x00},
      R"(TOR Inserts : SF/LLC Evictions)",
      R"(TOR Inserts : SF/LLC Evictions : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PRQ_IOSF",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0x00},
      R"(TOR Inserts : PRQ - IOSF)",
      R"(TOR Inserts : PRQ - IOSF : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : From a PCIe Device)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IRQ_NON_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x10, .umaskExt = 0x00},
      R"(TOR Inserts : IRQ - Non iA)",
      R"(TOR Inserts : IRQ - Non iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PRQ_NON_IOSF",
      EventDef::Encoding{.code = 0x35, .umask = 0x20, .umaskExt = 0x00},
      R"(TOR Inserts : PRQ - Non IOSF)",
      R"(TOR Inserts : PRQ - Non IOSF : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_IO",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local IO)",
      R"(TOR Inserts : All from Local IO : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local iA)",
      R"(TOR Inserts : All from Local iA : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally initiated requests from iA Cores)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOC_ALL",
      EventDef::Encoding{.code = 0x35, .umask = 0x05, .umaskExt = 0xC000FF},
      R"(TOR Inserts : All from Local iA and IO)",
      R"(TOR Inserts : All from Local iA and IO : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts. : All locally initiated requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.HIT",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x01},
      R"(TOR Inserts : Just Hits)",
      R"(TOR Inserts : Just Hits : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MISS",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x02},
      R"(TOR Inserts : Just Misses)",
      R"(TOR Inserts : Just Misses : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MMCFG",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x20},
      R"(TOR Inserts : MMCFG Access)",
      R"(TOR Inserts : MMCFG Access : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.LOCAL_TGT",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x80},
      R"(TOR Inserts : Just Local Targets)",
      R"(TOR Inserts : Just Local Targets : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MATCH_OPC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x200},
      R"(TOR Inserts : Match the Opcode in b[29:19] of the extended umask field)",
      R"(TOR Inserts : Match the Opcode in b[29:19] of the extended umask field : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PREMORPH_OPC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x400},
      R"(TOR Inserts : Match the PreMorphed Opcode in b[29:19] of the extended umask field)",
      R"(TOR Inserts : Match the PreMorphed Opcode in b[29:19] of the extended umask field : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NEARMEM",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x400000},
      R"(TOR Inserts : Just NearMem)",
      R"(TOR Inserts : Just NearMem : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NOT_NEARMEM",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x800000},
      R"(TOR Inserts : Just NotNearMem)",
      R"(TOR Inserts : Just NotNearMem : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.NONCOH",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x1000000},
      R"(TOR Inserts : Just NonCoherent)",
      R"(TOR Inserts : Just NonCoherent : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ISOC",
      EventDef::Encoding{.code = 0x35, .umask = 0x00, .umaskExt = 0x2000000},
      R"(TOR Inserts : Just ISOC)",
      R"(TOR Inserts : Just ISOC : Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.   Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IRQ_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0x00},
      R"(TOR Occupancy : IRQ - iA)",
      R"(TOR Occupancy : IRQ - iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : From an iA Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.EVICT",
      EventDef::Encoding{.code = 0x36, .umask = 0x02, .umaskExt = 0x00},
      R"(TOR Occupancy : SF/LLC Evictions)",
      R"(TOR Occupancy : SF/LLC Evictions : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PRQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0x00},
      R"(TOR Occupancy : PRQ - IOSF)",
      R"(TOR Occupancy : PRQ - IOSF : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : From a PCIe Device)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IRQ_NON_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x10, .umaskExt = 0x00},
      R"(TOR Occupancy : IRQ - Non iA)",
      R"(TOR Occupancy : IRQ - Non iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PRQ_NON_IOSF",
      EventDef::Encoding{.code = 0x36, .umask = 0x20, .umaskExt = 0x00},
      R"(TOR Occupancy : PRQ - Non IOSF)",
      R"(TOR Occupancy : PRQ - Non IOSF : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_IO",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local IO)",
      R"(TOR Occupancy : All from Local IO : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_IA",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local iA)",
      R"(TOR Occupancy : All from Local iA : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally initiated requests from iA Cores)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOC_ALL",
      EventDef::Encoding{.code = 0x36, .umask = 0x05, .umaskExt = 0xC000FF},
      R"(TOR Occupancy : All from Local iA and IO)",
      R"(TOR Occupancy : All from Local iA and IO : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts. : All locally initiated requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.HIT",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x01},
      R"(TOR Occupancy : Just Hits)",
      R"(TOR Occupancy : Just Hits : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MISS",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x02},
      R"(TOR Occupancy : Just Misses)",
      R"(TOR Occupancy : Just Misses : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MMCFG",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x20},
      R"(TOR Occupancy : MMCFG Access)",
      R"(TOR Occupancy : MMCFG Access : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.LOCAL_TGT",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x80},
      R"(TOR Occupancy : Just Local Targets)",
      R"(TOR Occupancy : Just Local Targets : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MATCH_OPC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x200},
      R"(TOR Occupancy : Match the Opcode in b[29:19] of the extended umask field)",
      R"(TOR Occupancy : Match the Opcode in b[29:19] of the extended umask field : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PREMORPH_OPC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x400},
      R"(TOR Occupancy : Match the PreMorphed Opcode in b[29:19] of the extended umask field)",
      R"(TOR Occupancy : Match the PreMorphed Opcode in b[29:19] of the extended umask field : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NEARMEM",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x400000},
      R"(TOR Occupancy : Just NearMem)",
      R"(TOR Occupancy : Just NearMem : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NOT_NEARMEM",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x800000},
      R"(TOR Occupancy : Just NotNearMem)",
      R"(TOR Occupancy : Just NotNearMem : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.NONCOH",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x1000000},
      R"(TOR Occupancy : Just NonCoherent)",
      R"(TOR Occupancy : Just NonCoherent : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.ISOC",
      EventDef::Encoding{.code = 0x36, .umask = 0x00, .umaskExt = 0x2000000},
      R"(TOR Occupancy : Just ISOC)",
      R"(TOR Occupancy : Just ISOC : For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.     Does not include addressless requests such as locks and interrupts.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's MMIO space)",
      R"(Data requested by the CPU : Core writing to Card's MMIO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's MMIO space)",
      R"(Data requested by the CPU : Core writing to Card's MMIO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) writing to this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM)",
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM)",
      R"(Data requested by the CPU : Core reporting completion of Card read from Core DRAM : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Data requested by the CPU : Another card (different IIO stack) reading from this card. : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Data requested by the CPU : Core writing to Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core writing to Card's IO space)",
      R"(Data requested by the CPU : Core writing to Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Data requested by the CPU : Core reading from Card's PCICFG space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested by the CPU : Core reading from Card's IO space)",
      R"(Data requested by the CPU : Core reading from Card's IO space : Number of DWs (4 bytes) requested by the main die.  Includes all requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card writing to DRAM)",
      R"(Data requested of the CPU : Card writing to DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card writing to DRAM)",
      R"(Data requested of the CPU : Card writing to DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Data requested of the CPU : Card writing to another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card reading from DRAM)",
      R"(Data requested of the CPU : Card reading from DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(Four byte data request of the CPU : Card reading from DRAM)",
      R"(Data requested of the CPU : Card reading from DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .umaskExt = 0x00},
      R"(Data requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Data requested of the CPU : Card reading from another Card (same or different stack) : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .umaskExt = 0x00},
      R"(Data requested of the CPU : Atomic requests targeting DRAM)",
      R"(Data requested of the CPU : Atomic requests targeting DRAM : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .umaskExt = 0x00},
      R"(Data requested of the CPU : Messages)",
      R"(Data requested of the CPU : Messages : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.CMPD.IOMMU0",
      EventDef::Encoding{.code = 0x83, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.CMPD.IOMMU1",
      EventDef::Encoding{.code = 0x83, .umask = 0x80, .umaskExt = 0x00},
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Data requested of the CPU : CmpD - device sending completion to CPU request : Number of DWs (4 bytes) the card requests of the main die.    Includes all requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) writing to this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's MMIO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card.)",
      R"(Number Transactions requested by the CPU : Another card (different IIO stack) reading from this card. : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space)",
      R"(Number Transactions requested by the CPU : Core writing to Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's PCICFG space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.IOMMU0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.IOMMU1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space)",
      R"(Number Transactions requested by the CPU : Core reading from Card's IO space : Also known as Outbound.  Number of requests initiated by the main die, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to DRAM)",
      R"(Number Transactions requested of the CPU : Card writing to DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to DRAM)",
      R"(Number Transactions requested of the CPU : Card writing to DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_WRITE.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card writing to another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_READ.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from DRAM)",
      R"(Number Transactions requested of the CPU : Card reading from DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MEM_READ.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from DRAM)",
      R"(Number Transactions requested of the CPU : Card reading from DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.PEER_READ.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack))",
      R"(Number Transactions requested of the CPU : Card reading from another Card (same or different stack) : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.ATOMIC.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM)",
      R"(Number Transactions requested of the CPU : Atomic requests targeting DRAM : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.MSG.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : Messages)",
      R"(Number Transactions requested of the CPU : Messages : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.CMPD.IOMMU0",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_OF_CPU.CMPD.IOMMU1",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request)",
      R"(Number Transactions requested of the CPU : CmpD - device sending completion to CPU request : Also known as Inbound.  Number of 64B cache line requests initiated by the Card, including reads and writes. : IOMMU - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH0_NI_MISS",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x20},
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch0)",
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.CH1_NI_MISS",
      EventDef::Encoding{.code = 0x38, .umask = 0x00, .umaskExt = 0x0C},
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch1)",
      R"(M2M Writes Issued to iMC : Non-Inclusive Miss - Ch1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL.CH0",
      EventDef::Encoding{.code = 0x6B, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Full : Channel 0)",
      R"(Prefetch CAM Cycles Full : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL.CH1",
      EventDef::Encoding{.code = 0x6B, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Full : Channel 1)",
      R"(Prefetch CAM Cycles Full : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE.CH0",
      EventDef::Encoding{.code = 0x6C, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Not Empty : Channel 0)",
      R"(Prefetch CAM Cycles Not Empty : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE.CH1",
      EventDef::Encoding{.code = 0x6C, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Cycles Not Empty : Channel 1)",
      R"(Prefetch CAM Cycles Not Empty : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_HITA0_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_HITA1_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_MISS_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH0_RSP_PDRESET",
      EventDef::Encoding{.code = 0x6E, .umask = 0x08, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_HITA0_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x10, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_HITA1_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x20, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_MISS_INVAL",
      EventDef::Encoding{.code = 0x6E, .umask = 0x40, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEALLOCS.CH1_RSP_PDRESET",
      EventDef::Encoding{.code = 0x6E, .umask = 0x80, .umaskExt = 0x00},
      R"(Prefetch CAM Deallocs)",
      R"(Prefetch CAM Deallocs)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH0_XPT",
      EventDef::Encoding{.code = 0x6F, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : XPT - Ch 0)",
      R"(Data Prefetches Dropped : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_DROPS.CH1_XPT",
      EventDef::Encoding{.code = 0x6F, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped : XPT - Ch 1)",
      R"(Data Prefetches Dropped : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_MERGE.CH0_XPT",
      EventDef::Encoding{.code = 0x74, .umask = 0x01, .umaskExt = 0x00},
      R"(Demands Merged with CAMed Prefetches : XPT - Ch 0)",
      R"(Demands Merged with CAMed Prefetches : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_MERGE.CH1_XPT",
      EventDef::Encoding{.code = 0x74, .umask = 0x04, .umaskExt = 0x00},
      R"(Demands Merged with CAMed Prefetches : XPT - Ch 1)",
      R"(Demands Merged with CAMed Prefetches : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_NO_MERGE.CH0_XPT",
      EventDef::Encoding{.code = 0x75, .umask = 0x01, .umaskExt = 0x00},
      R"(Demands Not Merged with CAMed Prefetches : XPT - Ch 0)",
      R"(Demands Not Merged with CAMed Prefetches : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DEMAND_NO_MERGE.CH1_XPT",
      EventDef::Encoding{.code = 0x75, .umask = 0x04, .umaskExt = 0x00},
      R"(Demands Not Merged with CAMed Prefetches : XPT - Ch 1)",
      R"(Demands Not Merged with CAMed Prefetches : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_SECURE_DROP",
      EventDef::Encoding{.code = 0x70, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.NOT_PF_SAD_REGION",
      EventDef::Encoding{.code = 0x70, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_CAM_HIT",
      EventDef::Encoding{.code = 0x70, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.STOP_B2B",
      EventDef::Encoding{.code = 0x70, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.ERRORBLK_RxC",
      EventDef::Encoding{.code = 0x70, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_AD_CRD",
      EventDef::Encoding{.code = 0x70, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.PF_CAM_FULL",
      EventDef::Encoding{.code = 0x70, .umask = 0x40, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.WPQ_PROXY",
      EventDef::Encoding{.code = 0x70, .umask = 0x80, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.RPQ_PROXY",
      EventDef::Encoding{.code = 0x70, .umask = 0x00, .umaskExt = 0x01},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH0.XPT_THRESH",
      EventDef::Encoding{.code = 0x70, .umask = 0x00, .umaskExt = 0x02},
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      R"(Data Prefetches Dropped Ch0 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_SECURE_DROP",
      EventDef::Encoding{.code = 0x71, .umask = 0x01, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.NOT_PF_SAD_REGION",
      EventDef::Encoding{.code = 0x71, .umask = 0x02, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_CAM_HIT",
      EventDef::Encoding{.code = 0x71, .umask = 0x04, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.STOP_B2B",
      EventDef::Encoding{.code = 0x71, .umask = 0x08, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.ERRORBLK_RxC",
      EventDef::Encoding{.code = 0x71, .umask = 0x10, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_AD_CRD",
      EventDef::Encoding{.code = 0x71, .umask = 0x20, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.PF_CAM_FULL",
      EventDef::Encoding{.code = 0x71, .umask = 0x40, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.WPQ_PROXY",
      EventDef::Encoding{.code = 0x71, .umask = 0x80, .umaskExt = 0x00},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.RPQ_PROXY",
      EventDef::Encoding{.code = 0x71, .umask = 0x00, .umaskExt = 0x01},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_DROP_REASONS_CH1.XPT_THRESH",
      EventDef::Encoding{.code = 0x71, .umask = 0x00, .umaskExt = 0x02},
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      R"(Data Prefetches Dropped Ch1 - Reasons)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH0_XPT",
      EventDef::Encoding{.code = 0x6D, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : XPT - Ch 0)",
      R"(Prefetch CAM Inserts : XPT - Ch 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_INSERTS.CH1_XPT",
      EventDef::Encoding{.code = 0x6D, .umask = 0x04, .umaskExt = 0x00},
      R"(Prefetch CAM Inserts : XPT - Ch 1)",
      R"(Prefetch CAM Inserts : XPT - Ch 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x6A, .umask = 0x01, .umaskExt = 0x00},
      R"(Prefetch CAM Occupancy : Channel 0)",
      R"(Prefetch CAM Occupancy : Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x6A, .umask = 0x02, .umaskExt = 0x00},
      R"(Prefetch CAM Occupancy : Channel 1)",
      R"(Prefetch CAM Occupancy : Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RESP_MISS.CH0",
      EventDef::Encoding{.code = 0x76, .umask = 0x01, .umaskExt = 0x00},
      R"(: Channel 0)",
      R"(: Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RESP_MISS.CH1",
      EventDef::Encoding{.code = 0x76, .umask = 0x02, .umaskExt = 0x00},
      R"(: Channel 1)",
      R"(: Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED",
      EventDef::Encoding{.code = 0x7A, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.SQUASHED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED",
      EventDef::Encoding{.code = 0x7A, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.1LM_POSTED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS",
      EventDef::Encoding{.code = 0x7A, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS)",
      R"(UNC_M2M_PREFCAM_RxC_DEALLOCS.CIS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR_NONTGR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x10, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty)",
      R"(Write Tracker Cycles Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_NE.MIRR_PWR",
      EventDef::Encoding{.code = 0x4B, .umask = 0x20, .umaskExt = 0x00},
      R"(Write Tracker Cycles Not Empty)",
      R"(Write Tracker Cycles Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR_NONTGR",
      EventDef::Encoding{.code = 0x55, .umask = 0x10, .umaskExt = 0x00},
      R"(Write Tracker Occupancy)",
      R"(Write Tracker Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WR_TRACKER_OCCUPANCY.MIRR_PWR",
      EventDef::Encoding{.code = 0x55, .umask = 0x20, .umaskExt = 0x00},
      R"(Write Tracker Occupancy)",
      R"(Write Tracker Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x46, .umask = 0x40, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x46, .umask = 0x80, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x47, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x47, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x47, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x47, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      R"(Local Dedicated P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF0_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF0_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF1_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF1_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x08, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF2_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF2_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF3_NCB",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_0.MS2IOSF3_NCS",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF4_NCB",
      EventDef::Encoding{.code = 0x1a, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF4_NCS",
      EventDef::Encoding{.code = 0x1a, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF5_NCB",
      EventDef::Encoding{.code = 0x1a, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCB)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_DED_RETURNED_1.MS2IOSF5_NCS",
      EventDef::Encoding{.code = 0x1a, .umask = 0x08, .umaskExt = 0x00},
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCS)",
      R"(Local P2P Dedicated Credits Returned - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent0)",
      R"(Local P2P Shared Credits Returned : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent1)",
      R"(Local P2P Shared Credits Returned : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_P2P_SHAR_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x17, .umask = 0x04, .umaskExt = 0x00},
      R"(Local P2P Shared Credits Returned : Agent2)",
      R"(Local P2P Shared Credits Returned : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x44, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent0)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x44, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent1)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x44, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent2)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_3",
      EventDef::Encoding{.code = 0x44, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent3)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_4",
      EventDef::Encoding{.code = 0x44, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent4)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED.AGENT_5",
      EventDef::Encoding{.code = 0x44, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Returned to credit ring : Agent5)",
      R"(Local Shared P2P Credit Returned to credit ring : Agent5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x10, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x20, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x40, .umask = 0x40, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x40, .umask = 0x80, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      R"(Local Shared P2P Credit Taken - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x41, .umask = 0x01, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x41, .umask = 0x02, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x41, .umask = 0x04, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x41, .umask = 0x08, .umaskExt = 0x00},
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      R"(Local Shared P2P Credit Taken - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF0_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x01, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF0_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x02, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF0 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF1_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x04, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF1_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x08, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF1 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF2_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x10, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF2_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x20, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF2 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF3_NCB",
      EventDef::Encoding{.code = 0x4a, .umask = 0x40, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0.M2IOSF3_NCS",
      EventDef::Encoding{.code = 0x4a, .umask = 0x80, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 0 : M2IOSF3 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF4_NCB",
      EventDef::Encoding{.code = 0x4b, .umask = 0x01, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF4_NCS",
      EventDef::Encoding{.code = 0x4b, .umask = 0x02, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF4 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF5_NCB",
      EventDef::Encoding{.code = 0x4b, .umask = 0x04, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCB)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1.M2IOSF5_NCS",
      EventDef::Encoding{.code = 0x4b, .umask = 0x08, .umaskExt = 0x00},
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCS)",
      R"(Waiting on Local Shared P2P Credit - 1 : M2IOSF5 - NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.LOCAL_NCB",
      EventDef::Encoding{.code = 0x14, .umask = 0x01, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Local NCB)",
      R"(P2P Credit Occupancy : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.LOCAL_NCS",
      EventDef::Encoding{.code = 0x14, .umask = 0x02, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Local NCS)",
      R"(P2P Credit Occupancy : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.REMOTE_NCB",
      EventDef::Encoding{.code = 0x14, .umask = 0x04, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Remote NCB)",
      R"(P2P Credit Occupancy : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.REMOTE_NCS",
      EventDef::Encoding{.code = 0x14, .umask = 0x08, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : Remote NCS)",
      R"(P2P Credit Occupancy : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_CRD_OCCUPANCY.ALL",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .umaskExt = 0x00},
      R"(P2P Credit Occupancy : All)",
      R"(P2P Credit Occupancy : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.LOCAL_NCB",
      EventDef::Encoding{.code = 0x16, .umask = 0x01, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Local NCB)",
      R"(Dedicated Credits Received : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.LOCAL_NCS",
      EventDef::Encoding{.code = 0x16, .umask = 0x02, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Local NCS)",
      R"(Dedicated Credits Received : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.REMOTE_NCB",
      EventDef::Encoding{.code = 0x16, .umask = 0x04, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Remote NCB)",
      R"(Dedicated Credits Received : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.REMOTE_NCS",
      EventDef::Encoding{.code = 0x16, .umask = 0x08, .umaskExt = 0x00},
      R"(Dedicated Credits Received : Remote NCS)",
      R"(Dedicated Credits Received : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_DED_RECEIVED.ALL",
      EventDef::Encoding{.code = 0x16, .umask = 0x10, .umaskExt = 0x00},
      R"(Dedicated Credits Received : All)",
      R"(Dedicated Credits Received : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.LOCAL_NCB",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .umaskExt = 0x00},
      R"(Shared Credits  Received : Local NCB)",
      R"(Shared Credits  Received : Local NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.LOCAL_NCS",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .umaskExt = 0x00},
      R"(Shared Credits  Received : Local NCS)",
      R"(Shared Credits  Received : Local NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.REMOTE_NCB",
      EventDef::Encoding{.code = 0x15, .umask = 0x04, .umaskExt = 0x00},
      R"(Shared Credits  Received : Remote NCB)",
      R"(Shared Credits  Received : Remote NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.REMOTE_NCS",
      EventDef::Encoding{.code = 0x15, .umask = 0x08, .umaskExt = 0x00},
      R"(Shared Credits  Received : Remote NCS)",
      R"(Shared Credits  Received : Remote NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_P2P_SHAR_RECEIVED.ALL",
      EventDef::Encoding{.code = 0x15, .umask = 0x10, .umaskExt = 0x00},
      R"(Shared Credits  Received : All)",
      R"(Shared Credits  Received : All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent0)",
      R"(Remote P2P Shared Credits Returned : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent1)",
      R"(Remote P2P Shared Credits Returned : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_P2P_SHAR_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote P2P Shared Credits Returned : Agent2)",
      R"(Remote P2P Shared Credits Returned : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_0",
      EventDef::Encoding{.code = 0x45, .umask = 0x01, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent0)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_1",
      EventDef::Encoding{.code = 0x45, .umask = 0x02, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent1)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED.AGENT_2",
      EventDef::Encoding{.code = 0x45, .umask = 0x04, .umaskExt = 0x00},
      R"(Remote Shared P2P Credit Returned to credit ring : Agent2)",
      R"(Remote Shared P2P Credit Returned to credit ring : Agent2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.CHA_IDI",
      EventDef::Encoding{.code = 0x10, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.CHA_NCB",
      EventDef::Encoding{.code = 0x10, .umask = 0x02, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_CYCLES_NE.CHA_NCS",
      EventDef::Encoding{.code = 0x10, .umask = 0x04, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Cycles Not Empty)",
      R"(Ingress (from CMS) Queue Cycles Not Empty : Counts the number of cycles when the M2PCIe Ingress is not empty.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.CHA_IDI",
      EventDef::Encoding{.code = 0x11, .umask = 0x01, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.CHA_NCB",
      EventDef::Encoding{.code = 0x11, .umask = 0x02, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_RxC_INSERTS.CHA_NCS",
      EventDef::Encoding{.code = 0x11, .umask = 0x04, .umaskExt = 0x00},
      R"(Ingress (from CMS) Queue Inserts)",
      R"(Ingress (from CMS) Queue Inserts : Counts the number of entries inserted into the M2PCIe Ingress Queue.  This can be used in conjunction with the M2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2pcie,
      "UNC_M2P_TxC_CREDITS.PRQ",
      EventDef::Encoding{.code = 0x2d, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M2P_TxC_CREDITS.PRQ)",
      R"(UNC_M2P_TxC_CREDITS.PRQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCB",
      EventDef::Encoding{.code = 0x4D, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCB)",
      R"(UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCS",
      EventDef::Encoding{.code = 0x4D, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCS)",
      R"(UNC_U_M2U_MISC1.RxC_CYCLES_NE_CBO_NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCB",
      EventDef::Encoding{.code = 0x4D, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCB)",
      R"(UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCS",
      EventDef::Encoding{.code = 0x4D, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCS)",
      R"(UNC_U_M2U_MISC1.TxC_CYCLES_CRD_OVF_CBO_NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.RxC_CYCLES_FULL_BL",
      EventDef::Encoding{.code = 0x4E, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.RxC_CYCLES_FULL_BL)",
      R"(UNC_U_M2U_MISC2.RxC_CYCLES_FULL_BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.RxC_CYCLES_EMPTY_BL",
      EventDef::Encoding{.code = 0x4E, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.RxC_CYCLES_EMPTY_BL)",
      R"(UNC_U_M2U_MISC2.RxC_CYCLES_EMPTY_BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCB",
      EventDef::Encoding{.code = 0x4E, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCB)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCB)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCS",
      EventDef::Encoding{.code = 0x4E, .umask = 0x08, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCS)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_CRD_OVF_VN0_NCS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_BL",
      EventDef::Encoding{.code = 0x4E, .umask = 0x10, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_BL)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AK",
      EventDef::Encoding{.code = 0x4E, .umask = 0x20, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AK)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AKC",
      EventDef::Encoding{.code = 0x4E, .umask = 0x40, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AKC)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_EMPTY_AKC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC2.TxC_CYCLES_FULL_BL",
      EventDef::Encoding{.code = 0x4E, .umask = 0x80, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_FULL_BL)",
      R"(UNC_U_M2U_MISC2.TxC_CYCLES_FULL_BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AK",
      EventDef::Encoding{.code = 0x4F, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AK)",
      R"(UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AKC",
      EventDef::Encoding{.code = 0x4F, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AKC)",
      R"(UNC_U_M2U_MISC3.TxC_CYCLES_FULL_AKC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PCLS.RD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x01, .umaskExt = 0x00},
      R"(UNC_M_PCLS.RD)",
      R"(UNC_M_PCLS.RD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PCLS.WR",
      EventDef::Encoding{.code = 0xA0, .umask = 0x02, .umaskExt = 0x00},
      R"(UNC_M_PCLS.WR)",
      R"(UNC_M_PCLS.WR)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PCLS.TOTAL",
      EventDef::Encoding{.code = 0xA0, .umask = 0x04, .umaskExt = 0x00},
      R"(UNC_M_PCLS.TOTAL)",
      R"(UNC_M_PCLS.TOTAL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x80, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 0)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 0 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x80, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 1)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 1 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x80, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 2)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 2 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x80, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 3)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 3 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x80, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 4)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 4 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x80, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 5)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 5 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x80, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 6)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 6 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x80, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 7)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 7 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x81, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 8)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 8 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x81, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 9)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 9 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x81, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 10)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 10 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x82, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 0)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 0 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x82, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 1)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 1 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x82, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 2)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 2 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x82, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 3)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 3 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x82, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 4)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 4 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x82, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 5)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 5 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x82, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 6)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 6 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x82, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 7)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 7 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 8)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 8 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 9)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 9 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 10)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 10 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x88, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 0)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 0 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x88, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 1)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 1 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x88, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 2)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 2 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x88, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 3)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 3 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x88, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x88, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x88, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 6)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 6 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x88, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 7)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 7 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x89, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 8)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 8 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x89, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 9)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 9 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x89, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 10)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 10 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x8A, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 0)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 0 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x8A, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 1)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 1 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x8A, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 2)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 2 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x8A, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 3)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 3 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x8A, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 4)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 4 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x8A, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 5)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 5 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x8A, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 6)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 6 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x8A, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 7)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 7 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x8B, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 8)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 8 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x8B, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 9)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 9 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x8B, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 10)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 10 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 0)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 0 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 1)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 1 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 2)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 2 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 3)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 3 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 4 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x84, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 5 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 6)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 6 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 7)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 7 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x85, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 8)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 8 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x85, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 9)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 9 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x85, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 10)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 10 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 0)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 0 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 1)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 1 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x86, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 2)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 2 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x86, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 3)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 3 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x86, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 4)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 4 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x86, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 5)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 5 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x86, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 6)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 6 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x86, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 7)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 7 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x87, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 8)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 8 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x87, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 9)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 9 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x87, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 10)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 10 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x8C, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 0)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 0 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x8C, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 1)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 1 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x8C, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 2)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 2 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x8C, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 3)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 3 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x8C, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x8C, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x8C, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x8C, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x8D, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 8)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 8 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x8D, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 9)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 9 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x8D, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 10)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 10 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x8E, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 0)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 0 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x8E, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 1)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 1 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x8E, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 2)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 2 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x8E, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 3)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 3 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x8E, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 4)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 4 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x8E, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 5)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 5 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x8E, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 6)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 6 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x8E, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 7)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 7 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x8F, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 8)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 8 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x8F, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 9)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 9 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x8F, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 10)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 10 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.VERT",
      EventDef::Encoding{.code = 0xAF, .umask = 0x01, .umaskExt = 0x00},
      R"(Distress signal asserted : Vertical)",
      R"(Distress signal asserted : Vertical : Counts the number of cycles either the local or incoming distress signals are asserted. : If IRQ egress is full, then agents will throttle outgoing AD IDI transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.HORZ",
      EventDef::Encoding{.code = 0xAF, .umask = 0x02, .umaskExt = 0x00},
      R"(Distress signal asserted : Horizontal)",
      R"(Distress signal asserted : Horizontal : Counts the number of cycles either the local or incoming distress signals are asserted. : If TGR egress is full, then agents will throttle outgoing AD IDI transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.DPT_LOCAL",
      EventDef::Encoding{.code = 0xAF, .umask = 0x04, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Local)",
      R"(Distress signal asserted : DPT Local : Counts the number of cycles either the local or incoming distress signals are asserted. : Dynamic Prefetch Throttle triggered by this tile)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.DPT_NONLOCAL",
      EventDef::Encoding{.code = 0xAF, .umask = 0x08, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Remote)",
      R"(Distress signal asserted : DPT Remote : Counts the number of cycles either the local or incoming distress signals are asserted. : Dynamic Prefetch Throttle received by this tile)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.DPT_STALL_IV",
      EventDef::Encoding{.code = 0xAF, .umask = 0x40, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Stalled - IV)",
      R"(Distress signal asserted : DPT Stalled - IV : Counts the number of cycles either the local or incoming distress signals are asserted. : DPT occurred while regular IVs were received, causing DPT to be stalled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_DISTRESS_ASSERTED.DPT_STALL_NOCRD",
      EventDef::Encoding{.code = 0xAF, .umask = 0x80, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Stalled -  No Credit)",
      R"(Distress signal asserted : DPT Stalled -  No Credit : Counts the number of cycles either the local or incoming distress signals are asserted. : DPT occurred while credit not available causing DPT to be stalled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_EGRESS_ORDERING.IV_SNOOPGO_UP",
      EventDef::Encoding{.code = 0xBA, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress Blocking due to Ordering requirements : Up)",
      R"(Egress Blocking due to Ordering requirements : Up : Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_EGRESS_ORDERING.IV_SNOOPGO_DN",
      EventDef::Encoding{.code = 0xBA, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress Blocking due to Ordering requirements : Down)",
      R"(Egress Blocking due to Ordering requirements : Down : Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB6, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Left and Even)",
      R"(Horizontal AD Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB6, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Left and Odd)",
      R"(Horizontal AD Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB6, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Right and Even)",
      R"(Horizontal AD Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB6, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Right and Odd)",
      R"(Horizontal AD Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AKC_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xBB, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Even)",
      R"(Horizontal AK Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AKC_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xBB, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Odd)",
      R"(Horizontal AK Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AKC_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xBB, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Even)",
      R"(Horizontal AK Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AKC_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xBB, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Odd)",
      R"(Horizontal AK Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB7, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Even)",
      R"(Horizontal AK Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB7, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Odd)",
      R"(Horizontal AK Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB7, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Even)",
      R"(Horizontal AK Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB7, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Odd)",
      R"(Horizontal AK Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB8, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Left and Even)",
      R"(Horizontal BL Ring in Use : Left and Even : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB8, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Left and Odd)",
      R"(Horizontal BL Ring in Use : Left and Odd : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB8, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Right and Even)",
      R"(Horizontal BL Ring in Use : Right and Even : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB8, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Right and Odd)",
      R"(Horizontal BL Ring in Use : Right and Odd : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_IV_IN_USE.LEFT",
      EventDef::Encoding{.code = 0xB9, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal IV Ring in Use : Left)",
      R"(Horizontal IV Ring in Use : Left : Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_IV_IN_USE.RIGHT",
      EventDef::Encoding{.code = 0xB9, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal IV Ring in Use : Right)",
      R"(Horizontal IV Ring in Use : Right : Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC_EXTERNAL.MBE_INST0",
      EventDef::Encoding{.code = 0xE6, .umask = 0x01, .umaskExt = 0x00},
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI0)",
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC_EXTERNAL.MBE_INST1",
      EventDef::Encoding{.code = 0xE6, .umask = 0x02, .umaskExt = 0x00},
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI1)",
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.AD",
      EventDef::Encoding{.code = 0xAC, .umask = 0x01, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : AD)",
      R"(Messages that bounced on the Horizontal Ring. : AD : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.AK",
      EventDef::Encoding{.code = 0xAC, .umask = 0x02, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : AK)",
      R"(Messages that bounced on the Horizontal Ring. : AK : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.BL",
      EventDef::Encoding{.code = 0xAC, .umask = 0x04, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : BL)",
      R"(Messages that bounced on the Horizontal Ring. : BL : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.IV",
      EventDef::Encoding{.code = 0xAC, .umask = 0x08, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : IV)",
      R"(Messages that bounced on the Horizontal Ring. : IV : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.AD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x01, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : AD)",
      R"(Messages that bounced on the Vertical Ring. : AD : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.AK",
      EventDef::Encoding{.code = 0xAA, .umask = 0x02, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Acknowledgements to core)",
      R"(Messages that bounced on the Vertical Ring. : Acknowledgements to core : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.BL",
      EventDef::Encoding{.code = 0xAA, .umask = 0x04, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Data Responses to core)",
      R"(Messages that bounced on the Vertical Ring. : Data Responses to core : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.IV",
      EventDef::Encoding{.code = 0xAA, .umask = 0x08, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Snoops of processor's cache.)",
      R"(Messages that bounced on the Vertical Ring. : Snoops of processor's cache. : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.AKC",
      EventDef::Encoding{.code = 0xAA, .umask = 0x10, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring.)",
      R"(Messages that bounced on the Vertical Ring. : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AD",
      EventDef::Encoding{.code = 0xAD, .umask = 0x01, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : AD)",
      R"(Sink Starvation on Horizontal Ring : AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AK",
      EventDef::Encoding{.code = 0xAD, .umask = 0x02, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : AK)",
      R"(Sink Starvation on Horizontal Ring : AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.BL",
      EventDef::Encoding{.code = 0xAD, .umask = 0x04, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : BL)",
      R"(Sink Starvation on Horizontal Ring : BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.IV",
      EventDef::Encoding{.code = 0xAD, .umask = 0x08, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : IV)",
      R"(Sink Starvation on Horizontal Ring : IV)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AK_AG1",
      EventDef::Encoding{.code = 0xAD, .umask = 0x20, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : Acknowledgements to Agent 1)",
      R"(Sink Starvation on Horizontal Ring : Acknowledgements to Agent 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.AD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x01, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : AD)",
      R"(Sink Starvation on Vertical Ring : AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.AK",
      EventDef::Encoding{.code = 0xAB, .umask = 0x02, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Acknowledgements to core)",
      R"(Sink Starvation on Vertical Ring : Acknowledgements to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.BL",
      EventDef::Encoding{.code = 0xAB, .umask = 0x04, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Data Responses to core)",
      R"(Sink Starvation on Vertical Ring : Data Responses to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.IV",
      EventDef::Encoding{.code = 0xAB, .umask = 0x08, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Snoops of processor's cache.)",
      R"(Sink Starvation on Vertical Ring : Snoops of processor's cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.AKC",
      EventDef::Encoding{.code = 0xAB, .umask = 0x10, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring)",
      R"(Sink Starvation on Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.AD_UNCRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Uncredited)",
      R"(Transgress Injection Starvation : AD - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.BL_UNCRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Uncredited)",
      R"(Transgress Injection Starvation : BL - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Credited)",
      R"(Transgress Injection Starvation : AD - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Credited)",
      R"(Transgress Injection Starvation : BL - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.AD_ALL",
      EventDef::Encoding{.code = 0xE5, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - All)",
      R"(Transgress Injection Starvation : AD - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.BL_ALL",
      EventDef::Encoding{.code = 0xE5, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - All)",
      R"(Transgress Injection Starvation : BL - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AD_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - Uncredited)",
      R"(Transgress Ingress Bypass : AD - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AK",
      EventDef::Encoding{.code = 0xE2, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AK)",
      R"(Transgress Ingress Bypass : AK : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.BL_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - Uncredited)",
      R"(Transgress Ingress Bypass : BL - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.IV",
      EventDef::Encoding{.code = 0xE2, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : IV)",
      R"(Transgress Ingress Bypass : IV : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - Credited)",
      R"(Transgress Ingress Bypass : AD - Credited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - Credited)",
      R"(Transgress Ingress Bypass : BL - Credited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AKC - Uncredited)",
      R"(Transgress Ingress Bypass : AKC - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AD_ALL",
      EventDef::Encoding{.code = 0xE2, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - All)",
      R"(Transgress Ingress Bypass : AD - All : Number of packets bypassing the CMS Ingress : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.BL_ALL",
      EventDef::Encoding{.code = 0xE2, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - All)",
      R"(Transgress Ingress Bypass : BL - All : Number of packets bypassing the CMS Ingress : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AD_UNCRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Uncredited)",
      R"(Transgress Injection Starvation : AD - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AK",
      EventDef::Encoding{.code = 0xE3, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AK)",
      R"(Transgress Injection Starvation : AK : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.BL_UNCRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Uncredited)",
      R"(Transgress Injection Starvation : BL - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.IV",
      EventDef::Encoding{.code = 0xE3, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : IV)",
      R"(Transgress Injection Starvation : IV : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Credited)",
      R"(Transgress Injection Starvation : AD - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Credited)",
      R"(Transgress Injection Starvation : BL - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.IFV",
      EventDef::Encoding{.code = 0xE3, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : IFV - Credited)",
      R"(Transgress Injection Starvation : IFV - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AD_ALL",
      EventDef::Encoding{.code = 0xE3, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - All)",
      R"(Transgress Injection Starvation : AD - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.BL_ALL",
      EventDef::Encoding{.code = 0xE3, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - All)",
      R"(Transgress Injection Starvation : BL - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AD_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - Uncredited)",
      R"(Transgress Ingress Allocations : AD - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AK",
      EventDef::Encoding{.code = 0xE1, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AK)",
      R"(Transgress Ingress Allocations : AK : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.BL_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - Uncredited)",
      R"(Transgress Ingress Allocations : BL - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.IV",
      EventDef::Encoding{.code = 0xE1, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : IV)",
      R"(Transgress Ingress Allocations : IV : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - Credited)",
      R"(Transgress Ingress Allocations : AD - Credited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - Credited)",
      R"(Transgress Ingress Allocations : BL - Credited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AKC - Uncredited)",
      R"(Transgress Ingress Allocations : AKC - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AD_ALL",
      EventDef::Encoding{.code = 0xE1, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - All)",
      R"(Transgress Ingress Allocations : AD - All : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.BL_ALL",
      EventDef::Encoding{.code = 0xE1, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - All)",
      R"(Transgress Ingress Allocations : BL - All : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AD_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - Uncredited)",
      R"(Transgress Ingress Occupancy : AD - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AK",
      EventDef::Encoding{.code = 0xE0, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AK)",
      R"(Transgress Ingress Occupancy : AK : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.BL_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - Uncredited)",
      R"(Transgress Ingress Occupancy : BL - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.IV",
      EventDef::Encoding{.code = 0xE0, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : IV)",
      R"(Transgress Ingress Occupancy : IV : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - Credited)",
      R"(Transgress Ingress Occupancy : AD - Credited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x20, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - Credited)",
      R"(Transgress Ingress Occupancy : BL - Credited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AKC - Uncredited)",
      R"(Transgress Ingress Occupancy : AKC - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AD_ALL",
      EventDef::Encoding{.code = 0xE0, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - All)",
      R"(Transgress Ingress Occupancy : AD - All : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.BL_ALL",
      EventDef::Encoding{.code = 0xE0, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - All)",
      R"(Transgress Ingress Occupancy : BL - All : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR0",
      EventDef::Encoding{.code = 0xD0, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 0)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 0 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR1",
      EventDef::Encoding{.code = 0xD0, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 1)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 1 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR2",
      EventDef::Encoding{.code = 0xD0, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 2)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 2 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR3",
      EventDef::Encoding{.code = 0xD0, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 3)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 3 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR4",
      EventDef::Encoding{.code = 0xD0, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 4)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 4 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR5",
      EventDef::Encoding{.code = 0xD0, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 5)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 5 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR6",
      EventDef::Encoding{.code = 0xD0, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 6)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 6 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR7",
      EventDef::Encoding{.code = 0xD0, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 7)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 7 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR0",
      EventDef::Encoding{.code = 0xD2, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 0)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 0 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR1",
      EventDef::Encoding{.code = 0xD2, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 1)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 1 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR2",
      EventDef::Encoding{.code = 0xD2, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 2)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 2 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR3",
      EventDef::Encoding{.code = 0xD2, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 3)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 3 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR4",
      EventDef::Encoding{.code = 0xD2, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 4)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 4 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR5",
      EventDef::Encoding{.code = 0xD2, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 5)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 5 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR6",
      EventDef::Encoding{.code = 0xD2, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 6)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 6 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR7",
      EventDef::Encoding{.code = 0xD2, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 7)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 7 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR0",
      EventDef::Encoding{.code = 0xD4, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 0)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 0 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR1",
      EventDef::Encoding{.code = 0xD4, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 1)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 1 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR2",
      EventDef::Encoding{.code = 0xD4, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 2)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 2 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR3",
      EventDef::Encoding{.code = 0xD4, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 3)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 3 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR4",
      EventDef::Encoding{.code = 0xD4, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 4)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 4 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR5",
      EventDef::Encoding{.code = 0xD4, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 5)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 5 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR6",
      EventDef::Encoding{.code = 0xD4, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 6)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 6 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR7",
      EventDef::Encoding{.code = 0xD4, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 7)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 7 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR0",
      EventDef::Encoding{.code = 0xD6, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 0)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 0 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR1",
      EventDef::Encoding{.code = 0xD6, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 1)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 1 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR2",
      EventDef::Encoding{.code = 0xD6, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 2)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 2 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR3",
      EventDef::Encoding{.code = 0xD6, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 3)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 3 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR4",
      EventDef::Encoding{.code = 0xD6, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 4)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 4 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR5",
      EventDef::Encoding{.code = 0xD6, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 5)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 5 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR6",
      EventDef::Encoding{.code = 0xD6, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 6)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 6 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR7",
      EventDef::Encoding{.code = 0xD6, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 7)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 7 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR8",
      EventDef::Encoding{.code = 0xD1, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 8)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 8 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR9",
      EventDef::Encoding{.code = 0xD1, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 9)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 9 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR10",
      EventDef::Encoding{.code = 0xD1, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 10)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 10 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR8",
      EventDef::Encoding{.code = 0xD3, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 8)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 8 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR9",
      EventDef::Encoding{.code = 0xD3, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 9)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 9 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR10",
      EventDef::Encoding{.code = 0xD3, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 10)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 10 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR8",
      EventDef::Encoding{.code = 0xD5, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 8)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 8 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR9",
      EventDef::Encoding{.code = 0xD5, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 9)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 9 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR10",
      EventDef::Encoding{.code = 0xD5, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 10)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 10 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR8",
      EventDef::Encoding{.code = 0xD7, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 8)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 8 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR9",
      EventDef::Encoding{.code = 0xD7, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 9)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 9 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR10",
      EventDef::Encoding{.code = 0xD7, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 10)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 10 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AD_UNCRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - Uncredited)",
      R"(CMS Horizontal ADS Used : AD - Uncredited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.BL_UNCRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - Uncredited)",
      R"(CMS Horizontal ADS Used : BL - Uncredited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AD_CRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - Credited)",
      R"(CMS Horizontal ADS Used : AD - Credited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.BL_CRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - Credited)",
      R"(CMS Horizontal ADS Used : BL - Credited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AD_ALL",
      EventDef::Encoding{.code = 0xA6, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - All)",
      R"(CMS Horizontal ADS Used : AD - All : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.BL_ALL",
      EventDef::Encoding{.code = 0xA6, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - All)",
      R"(CMS Horizontal ADS Used : BL - All : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AD_UNCRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AD - Uncredited)",
      R"(CMS Horizontal Bypass Used : AD - Uncredited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AK",
      EventDef::Encoding{.code = 0xA7, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AK)",
      R"(CMS Horizontal Bypass Used : AK : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.BL_UNCRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : BL - Uncredited)",
      R"(CMS Horizontal Bypass Used : BL - Uncredited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.IV",
      EventDef::Encoding{.code = 0xA7, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : IV)",
      R"(CMS Horizontal Bypass Used : IV : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AD - Credited)",
      R"(CMS Horizontal Bypass Used : AD - Credited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : BL - Credited)",
      R"(CMS Horizontal Bypass Used : BL - Credited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AKC - Uncredited)",
      R"(CMS Horizontal Bypass Used : AKC - Uncredited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AD_ALL",
      EventDef::Encoding{.code = 0xA7, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AD - All)",
      R"(CMS Horizontal Bypass Used : AD - All : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.BL_ALL",
      EventDef::Encoding{.code = 0xA7, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : BL - All)",
      R"(CMS Horizontal Bypass Used : BL - All : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AD_UNCRD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AK",
      EventDef::Encoding{.code = 0xA2, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : AK)",
      R"(Cycles CMS Horizontal Egress Queue is Full : AK : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.BL_UNCRD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x04, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.IV",
      EventDef::Encoding{.code = 0xA2, .umask = 0x08, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : IV)",
      R"(Cycles CMS Horizontal Egress Queue is Full : IV : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AD_CRD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x10, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - Credited)",
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - Credited : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.BL_CRD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x40, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - Credited)",
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - Credited : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x80, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : AKC - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Full : AKC - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AD_ALL",
      EventDef::Encoding{.code = 0xA2, .umask = 0x11, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - All)",
      R"(Cycles CMS Horizontal Egress Queue is Full : AD - All : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.BL_ALL",
      EventDef::Encoding{.code = 0xA2, .umask = 0x44, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - All)",
      R"(Cycles CMS Horizontal Egress Queue is Full : BL - All : Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AD_UNCRD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AK",
      EventDef::Encoding{.code = 0xA3, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AK)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AK : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.BL_UNCRD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x04, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.IV",
      EventDef::Encoding{.code = 0xA3, .umask = 0x08, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : IV)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : IV : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AD_CRD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x10, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - Credited)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - Credited : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.BL_CRD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x40, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - Credited)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - Credited : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x80, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AKC - Uncredited)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AKC - Uncredited : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AD_ALL",
      EventDef::Encoding{.code = 0xA3, .umask = 0x11, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - All)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : AD - All : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.BL_ALL",
      EventDef::Encoding{.code = 0xA3, .umask = 0x44, .umaskExt = 0x00},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - All)",
      R"(Cycles CMS Horizontal Egress Queue is Not Empty : BL - All : Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AD_UNCRD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : AD - Uncredited)",
      R"(CMS Horizontal Egress Inserts : AD - Uncredited : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AK",
      EventDef::Encoding{.code = 0xA1, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : AK)",
      R"(CMS Horizontal Egress Inserts : AK : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.BL_UNCRD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : BL - Uncredited)",
      R"(CMS Horizontal Egress Inserts : BL - Uncredited : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.IV",
      EventDef::Encoding{.code = 0xA1, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : IV)",
      R"(CMS Horizontal Egress Inserts : IV : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : AD - Credited)",
      R"(CMS Horizontal Egress Inserts : AD - Credited : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : BL - Credited)",
      R"(CMS Horizontal Egress Inserts : BL - Credited : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : AKC - Uncredited)",
      R"(CMS Horizontal Egress Inserts : AKC - Uncredited : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AD_ALL",
      EventDef::Encoding{.code = 0xA1, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : AD - All)",
      R"(CMS Horizontal Egress Inserts : AD - All : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.BL_ALL",
      EventDef::Encoding{.code = 0xA1, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Inserts : BL - All)",
      R"(CMS Horizontal Egress Inserts : BL - All : Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AD_UNCRD",
      EventDef::Encoding{.code = 0xA4, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : AD - Uncredited)",
      R"(CMS Horizontal Egress NACKs : AD - Uncredited : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AK",
      EventDef::Encoding{.code = 0xA4, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : AK)",
      R"(CMS Horizontal Egress NACKs : AK : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.BL_UNCRD",
      EventDef::Encoding{.code = 0xA4, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : BL - Uncredited)",
      R"(CMS Horizontal Egress NACKs : BL - Uncredited : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.IV",
      EventDef::Encoding{.code = 0xA4, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : IV)",
      R"(CMS Horizontal Egress NACKs : IV : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AD_CRD",
      EventDef::Encoding{.code = 0xA4, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : AD - Credited)",
      R"(CMS Horizontal Egress NACKs : AD - Credited : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.BL_CRD",
      EventDef::Encoding{.code = 0xA4, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : BL - Credited)",
      R"(CMS Horizontal Egress NACKs : BL - Credited : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA4, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : AKC - Uncredited)",
      R"(CMS Horizontal Egress NACKs : AKC - Uncredited : Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AD_ALL",
      EventDef::Encoding{.code = 0xA4, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : AD - All)",
      R"(CMS Horizontal Egress NACKs : AD - All : Counts number of Egress packets NACK'ed on to the Horizontal Ring : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.BL_ALL",
      EventDef::Encoding{.code = 0xA4, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal Egress NACKs : BL - All)",
      R"(CMS Horizontal Egress NACKs : BL - All : Counts number of Egress packets NACK'ed on to the Horizontal Ring : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AD_UNCRD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : AD - Uncredited)",
      R"(CMS Horizontal Egress Occupancy : AD - Uncredited : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AK",
      EventDef::Encoding{.code = 0xA0, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : AK)",
      R"(CMS Horizontal Egress Occupancy : AK : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.BL_UNCRD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : BL - Uncredited)",
      R"(CMS Horizontal Egress Occupancy : BL - Uncredited : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.IV",
      EventDef::Encoding{.code = 0xA0, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : IV)",
      R"(CMS Horizontal Egress Occupancy : IV : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : AD - Credited)",
      R"(CMS Horizontal Egress Occupancy : AD - Credited : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : BL - Credited)",
      R"(CMS Horizontal Egress Occupancy : BL - Credited : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : AKC - Uncredited)",
      R"(CMS Horizontal Egress Occupancy : AKC - Uncredited : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AD_ALL",
      EventDef::Encoding{.code = 0xA0, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : AD - All)",
      R"(CMS Horizontal Egress Occupancy : AD - All : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.BL_ALL",
      EventDef::Encoding{.code = 0xA0, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Occupancy : BL - All)",
      R"(CMS Horizontal Egress Occupancy : BL - All : Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AD_UNCRD",
      EventDef::Encoding{.code = 0xA5, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : AD - Uncredited)",
      R"(CMS Horizontal Egress Injection Starvation : AD - Uncredited : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AK",
      EventDef::Encoding{.code = 0xA5, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : AK)",
      R"(CMS Horizontal Egress Injection Starvation : AK : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.BL_UNCRD",
      EventDef::Encoding{.code = 0xA5, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : BL - Uncredited)",
      R"(CMS Horizontal Egress Injection Starvation : BL - Uncredited : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.IV",
      EventDef::Encoding{.code = 0xA5, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : IV)",
      R"(CMS Horizontal Egress Injection Starvation : IV : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AKC_UNCRD",
      EventDef::Encoding{.code = 0xA5, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : AKC - Uncredited)",
      R"(CMS Horizontal Egress Injection Starvation : AKC - Uncredited : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AD_ALL",
      EventDef::Encoding{.code = 0xA5, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : AD - All)",
      R"(CMS Horizontal Egress Injection Starvation : AD - All : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.BL_ALL",
      EventDef::Encoding{.code = 0xA5, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Egress Injection Starvation : BL - All)",
      R"(CMS Horizontal Egress Injection Starvation : BL - All : Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AD_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AD - Agent 0)",
      R"(CMS Vertical ADS Used : AD - Agent 0 : Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.BL_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : BL - Agent 0)",
      R"(CMS Vertical ADS Used : BL - Agent 0 : Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AD_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AD - Agent 1)",
      R"(CMS Vertical ADS Used : AD - Agent 1 : Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.BL_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : BL - Agent 1)",
      R"(CMS Vertical ADS Used : BL - Agent 1 : Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AD_AG0",
      EventDef::Encoding{.code = 0x9D, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AD - Agent 0)",
      R"(CMS Vertical ADS Used : AD - Agent 0 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AK_AG0",
      EventDef::Encoding{.code = 0x9D, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AK - Agent 0)",
      R"(CMS Vertical ADS Used : AK - Agent 0 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.BL_AG0",
      EventDef::Encoding{.code = 0x9D, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : BL - Agent 0)",
      R"(CMS Vertical ADS Used : BL - Agent 0 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.IV_AG1",
      EventDef::Encoding{.code = 0x9D, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : IV - Agent 1)",
      R"(CMS Vertical ADS Used : IV - Agent 1 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AD_AG1",
      EventDef::Encoding{.code = 0x9D, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AD - Agent 1)",
      R"(CMS Vertical ADS Used : AD - Agent 1 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AK_AG1",
      EventDef::Encoding{.code = 0x9D, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AK - Agent 1)",
      R"(CMS Vertical ADS Used : AK - Agent 1 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.BL_AG1",
      EventDef::Encoding{.code = 0x9D, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : BL - Agent 1)",
      R"(CMS Vertical ADS Used : BL - Agent 1 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS_1.AKC_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AKC - Agent 0)",
      R"(CMS Vertical ADS Used : AKC - Agent 0 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS_1.AKC_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical ADS Used : AKC - Agent 1)",
      R"(CMS Vertical ADS Used : AKC - Agent 1 : Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.AD_AG0",
      EventDef::Encoding{.code = 0x94, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AD - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AD - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.AK_AG0",
      EventDef::Encoding{.code = 0x94, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AK - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AK - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.BL_AG0",
      EventDef::Encoding{.code = 0x94, .umask = 0x04, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : BL - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Full : BL - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.IV_AG0",
      EventDef::Encoding{.code = 0x94, .umask = 0x08, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : IV - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Full : IV - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.AD_AG1",
      EventDef::Encoding{.code = 0x94, .umask = 0x10, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AD - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AD - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.AK_AG1",
      EventDef::Encoding{.code = 0x94, .umask = 0x20, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AK - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AK - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL0.BL_AG1",
      EventDef::Encoding{.code = 0x94, .umask = 0x40, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : BL - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Full : BL - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL1.AKC_AG0",
      EventDef::Encoding{.code = 0x95, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AKC - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AKC - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL1.AKC_AG1",
      EventDef::Encoding{.code = 0x95, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Full : AKC - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Full : AKC - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.AD_AG0",
      EventDef::Encoding{.code = 0x96, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AD - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AD - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.AK_AG0",
      EventDef::Encoding{.code = 0x96, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AK - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AK - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.BL_AG0",
      EventDef::Encoding{.code = 0x96, .umask = 0x04, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : BL - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : BL - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.IV_AG0",
      EventDef::Encoding{.code = 0x96, .umask = 0x08, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : IV - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : IV - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.AD_AG1",
      EventDef::Encoding{.code = 0x96, .umask = 0x10, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AD - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AD - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.AK_AG1",
      EventDef::Encoding{.code = 0x96, .umask = 0x20, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AK - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AK - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE0.BL_AG1",
      EventDef::Encoding{.code = 0x96, .umask = 0x40, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : BL - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : BL - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE1.AKC_AG0",
      EventDef::Encoding{.code = 0x97, .umask = 0x01, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AKC - Agent 0)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AKC - Agent 0 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE1.AKC_AG1",
      EventDef::Encoding{.code = 0x97, .umask = 0x02, .umaskExt = 0x00},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AKC - Agent 1)",
      R"(Cycles CMS Vertical Egress Queue Is Not Empty : AKC - Agent 1 : Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.AD_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AD - Agent 0)",
      R"(CMS Vert Egress Allocations : AD - Agent 0 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.AK_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AK - Agent 0)",
      R"(CMS Vert Egress Allocations : AK - Agent 0 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.BL_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : BL - Agent 0)",
      R"(CMS Vert Egress Allocations : BL - Agent 0 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.IV_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : IV - Agent 0)",
      R"(CMS Vert Egress Allocations : IV - Agent 0 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.AD_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AD - Agent 1)",
      R"(CMS Vert Egress Allocations : AD - Agent 1 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.AK_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AK - Agent 1)",
      R"(CMS Vert Egress Allocations : AK - Agent 1 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS0.BL_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : BL - Agent 1)",
      R"(CMS Vert Egress Allocations : BL - Agent 1 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS1.AKC_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AKC - Agent 0)",
      R"(CMS Vert Egress Allocations : AKC - Agent 0 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS1.AKC_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vert Egress Allocations : AKC - Agent 1)",
      R"(CMS Vert Egress Allocations : AKC - Agent 1 : Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.AD_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AD - Agent 0)",
      R"(CMS Vertical Egress NACKs : AD - Agent 0 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.AK_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AK - Agent 0)",
      R"(CMS Vertical Egress NACKs : AK - Agent 0 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.BL_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : BL - Agent 0)",
      R"(CMS Vertical Egress NACKs : BL - Agent 0 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.IV_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : IV)",
      R"(CMS Vertical Egress NACKs : IV : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.AD_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AD - Agent 1)",
      R"(CMS Vertical Egress NACKs : AD - Agent 1 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.AK_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AK - Agent 1)",
      R"(CMS Vertical Egress NACKs : AK - Agent 1 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK0.BL_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : BL - Agent 1)",
      R"(CMS Vertical Egress NACKs : BL - Agent 1 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK1.AKC_AG0",
      EventDef::Encoding{.code = 0x99, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AKC - Agent 0)",
      R"(CMS Vertical Egress NACKs : AKC - Agent 0 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK1.AKC_AG1",
      EventDef::Encoding{.code = 0x99, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical Egress NACKs : AKC - Agent 1)",
      R"(CMS Vertical Egress NACKs : AKC - Agent 1 : Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.AD_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AD - Agent 0)",
      R"(CMS Vert Egress Occupancy : AD - Agent 0 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.AK_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AK - Agent 0)",
      R"(CMS Vert Egress Occupancy : AK - Agent 0 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.BL_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : BL - Agent 0)",
      R"(CMS Vert Egress Occupancy : BL - Agent 0 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.IV_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : IV - Agent 0)",
      R"(CMS Vert Egress Occupancy : IV - Agent 0 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.AD_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AD - Agent 1)",
      R"(CMS Vert Egress Occupancy : AD - Agent 1 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.AK_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AK - Agent 1)",
      R"(CMS Vert Egress Occupancy : AK - Agent 1 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY0.BL_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : BL - Agent 1)",
      R"(CMS Vert Egress Occupancy : BL - Agent 1 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY1.AKC_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AKC - Agent 0)",
      R"(CMS Vert Egress Occupancy : AKC - Agent 0 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY1.AKC_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vert Egress Occupancy : AKC - Agent 1)",
      R"(CMS Vert Egress Occupancy : AKC - Agent 1 : Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh. : Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.AD_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AD - Agent 0)",
      R"(CMS Vertical Egress Injection Starvation : AD - Agent 0 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.AK_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AK - Agent 0)",
      R"(CMS Vertical Egress Injection Starvation : AK - Agent 0 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.BL_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : BL - Agent 0)",
      R"(CMS Vertical Egress Injection Starvation : BL - Agent 0 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.IV_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : IV)",
      R"(CMS Vertical Egress Injection Starvation : IV : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.AD_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AD - Agent 1)",
      R"(CMS Vertical Egress Injection Starvation : AD - Agent 1 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.AK_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AK - Agent 1)",
      R"(CMS Vertical Egress Injection Starvation : AK - Agent 1 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED0.BL_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : BL - Agent 1)",
      R"(CMS Vertical Egress Injection Starvation : BL - Agent 1 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED1.AKC_AG0",
      EventDef::Encoding{.code = 0x9B, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 0)",
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 0 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED1.AKC_AG1",
      EventDef::Encoding{.code = 0x9B, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 1)",
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 1 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED1.TGC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 0)",
      R"(CMS Vertical Egress Injection Starvation : AKC - Agent 0 : Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xB0, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical AD Ring In Use : Up and Even)",
      R"(Vertical AD Ring In Use : Up and Even : Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x02, .umaskExt = 0x00},
      R"(Vertical AD Ring In Use : Up and Odd)",
      R"(Vertical AD Ring In Use : Up and Odd : Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xB0, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical AD Ring In Use : Down and Even)",
      R"(Vertical AD Ring In Use : Down and Even : Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x08, .umaskExt = 0x00},
      R"(Vertical AD Ring In Use : Down and Odd)",
      R"(Vertical AD Ring In Use : Down and Odd : Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AKC_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xB4, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical AKC Ring In Use : Up and Even)",
      R"(Vertical AKC Ring In Use : Up and Even : Counts the number of cycles that the Vertical AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AKC_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x02, .umaskExt = 0x00},
      R"(Vertical AKC Ring In Use : Up and Odd)",
      R"(Vertical AKC Ring In Use : Up and Odd : Counts the number of cycles that the Vertical AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AKC_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xB4, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical AKC Ring In Use : Down and Even)",
      R"(Vertical AKC Ring In Use : Down and Even : Counts the number of cycles that the Vertical AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AKC_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x08, .umaskExt = 0x00},
      R"(Vertical AKC Ring In Use : Down and Odd)",
      R"(Vertical AKC Ring In Use : Down and Odd : Counts the number of cycles that the Vertical AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xB1, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical AK Ring In Use : Up and Even)",
      R"(Vertical AK Ring In Use : Up and Even : Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x02, .umaskExt = 0x00},
      R"(Vertical AK Ring In Use : Up and Odd)",
      R"(Vertical AK Ring In Use : Up and Odd : Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xB1, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical AK Ring In Use : Down and Even)",
      R"(Vertical AK Ring In Use : Down and Even : Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x08, .umaskExt = 0x00},
      R"(Vertical AK Ring In Use : Down and Odd)",
      R"(Vertical AK Ring In Use : Down and Odd : Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xB2, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical BL Ring in Use : Up and Even)",
      R"(Vertical BL Ring in Use : Up and Even : Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x02, .umaskExt = 0x00},
      R"(Vertical BL Ring in Use : Up and Odd)",
      R"(Vertical BL Ring in Use : Up and Odd : Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xB2, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical BL Ring in Use : Down and Even)",
      R"(Vertical BL Ring in Use : Down and Even : Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x08, .umaskExt = 0x00},
      R"(Vertical BL Ring in Use : Down and Odd)",
      R"(Vertical BL Ring in Use : Down and Odd : Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_IV_IN_USE.UP",
      EventDef::Encoding{.code = 0xB3, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical IV Ring in Use : Up)",
      R"(Vertical IV Ring in Use : Up : Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_IV_IN_USE.DN",
      EventDef::Encoding{.code = 0xB3, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical IV Ring in Use : Down)",
      R"(Vertical IV Ring in Use : Down : Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_TGC_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xB5, .umask = 0x01, .umaskExt = 0x00},
      R"(Vertical TGC Ring In Use : Up and Even)",
      R"(Vertical TGC Ring In Use : Up and Even : Counts the number of cycles that the Vertical TGC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_TGC_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xB5, .umask = 0x02, .umaskExt = 0x00},
      R"(Vertical TGC Ring In Use : Up and Odd)",
      R"(Vertical TGC Ring In Use : Up and Odd : Counts the number of cycles that the Vertical TGC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_TGC_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xB5, .umask = 0x04, .umaskExt = 0x00},
      R"(Vertical TGC Ring In Use : Down and Even)",
      R"(Vertical TGC Ring In Use : Down and Even : Counts the number of cycles that the Vertical TGC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_TGC_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xB5, .umask = 0x08, .umaskExt = 0x00},
      R"(Vertical TGC Ring In Use : Down and Odd)",
      R"(Vertical TGC Ring In Use : Down and Odd : Counts the number of cycles that the Vertical TGC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x80, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 0)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 0 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x80, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 1)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 1 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x80, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 2)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 2 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x80, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 3)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 3 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x80, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 4)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 4 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x80, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 5)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 5 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x80, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 6)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 6 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x80, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 7)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 7 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x81, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 8)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 8 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x81, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 9)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 9 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x81, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Acquired : For Transgress 10)",
      R"(CMS Agent0 AD Credits Acquired : For Transgress 10 : Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x82, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 0)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 0 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x82, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 1)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 1 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x82, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 2)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 2 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x82, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 3)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 3 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x82, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 4)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 4 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x82, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 5)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 5 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x82, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 6)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 6 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x82, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 7)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 7 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 8)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 8 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 9)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 9 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 10)",
      R"(CMS Agent0 AD Credits Occupancy : For Transgress 10 : Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x88, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 0)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 0 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x88, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 1)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 1 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x88, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 2)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 2 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x88, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 3)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 3 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x88, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x88, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x88, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 6)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 6 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x88, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 7)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 7 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x89, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 8)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 8 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x89, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 9)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 9 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x89, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Acquired : For Transgress 10)",
      R"(CMS Agent0 BL Credits Acquired : For Transgress 10 : Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x8A, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 0)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 0 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x8A, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 1)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 1 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x8A, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 2)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 2 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x8A, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 3)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 3 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x8A, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 4)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 4 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x8A, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 5)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 5 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x8A, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 6)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 6 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x8A, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 7)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 7 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x8B, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 8)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 8 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x8B, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 9)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 9 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x8B, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 10)",
      R"(CMS Agent0 BL Credits Occupancy : For Transgress 10 : Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 0)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 0 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 1)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 1 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 2)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 2 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 3)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 3 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 4 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x84, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 5 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x84, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 6)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 6 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x84, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 7)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 7 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x85, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 8)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 8 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x85, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 9)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 9 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x85, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Acquired : For Transgress 10)",
      R"(CMS Agent1 AD Credits Acquired : For Transgress 10 : Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 0)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 0 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 1)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 1 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x86, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 2)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 2 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x86, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 3)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 3 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x86, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 4)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 4 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x86, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 5)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 5 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x86, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 6)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 6 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x86, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 7)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 7 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x87, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 8)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 8 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x87, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 9)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 9 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x87, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 10)",
      R"(CMS Agent1 AD Credits Occupancy : For Transgress 10 : Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR0",
      EventDef::Encoding{.code = 0x8C, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 0)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 0 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR1",
      EventDef::Encoding{.code = 0x8C, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 1)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 1 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR2",
      EventDef::Encoding{.code = 0x8C, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 2)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 2 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR3",
      EventDef::Encoding{.code = 0x8C, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 3)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 3 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR4",
      EventDef::Encoding{.code = 0x8C, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR5",
      EventDef::Encoding{.code = 0x8C, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR6",
      EventDef::Encoding{.code = 0x8C, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 4 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED0.TGR7",
      EventDef::Encoding{.code = 0x8C, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 5 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED1.TGR8",
      EventDef::Encoding{.code = 0x8D, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 8)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 8 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED1.TGR9",
      EventDef::Encoding{.code = 0x8D, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 9)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 9 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_ACQUIRED1.TGR10",
      EventDef::Encoding{.code = 0x8D, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Acquired : For Transgress 10)",
      R"(CMS Agent1 BL Credits Acquired : For Transgress 10 : Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR0",
      EventDef::Encoding{.code = 0x8E, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 0)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 0 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR1",
      EventDef::Encoding{.code = 0x8E, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 1)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 1 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR2",
      EventDef::Encoding{.code = 0x8E, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 2)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 2 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR3",
      EventDef::Encoding{.code = 0x8E, .umask = 0x08, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 3)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 3 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR4",
      EventDef::Encoding{.code = 0x8E, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 4)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 4 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR5",
      EventDef::Encoding{.code = 0x8E, .umask = 0x20, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 5)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 5 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR6",
      EventDef::Encoding{.code = 0x8E, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 6)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 6 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY0.TGR7",
      EventDef::Encoding{.code = 0x8E, .umask = 0x80, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 7)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 7 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY1.TGR8",
      EventDef::Encoding{.code = 0x8F, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 8)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 8 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY1.TGR9",
      EventDef::Encoding{.code = 0x8F, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 9)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 9 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY1.TGR10",
      EventDef::Encoding{.code = 0x8F, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 10)",
      R"(CMS Agent1 BL Credits Occupancy : For Transgress 10 : Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.VERT",
      EventDef::Encoding{.code = 0xAF, .umask = 0x01, .umaskExt = 0x00},
      R"(Distress signal asserted : Vertical)",
      R"(Distress signal asserted : Vertical : Counts the number of cycles either the local or incoming distress signals are asserted. : If IRQ egress is full, then agents will throttle outgoing AD IDI transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.HORZ",
      EventDef::Encoding{.code = 0xAF, .umask = 0x02, .umaskExt = 0x00},
      R"(Distress signal asserted : Horizontal)",
      R"(Distress signal asserted : Horizontal : Counts the number of cycles either the local or incoming distress signals are asserted. : If TGR egress is full, then agents will throttle outgoing AD IDI transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.DPT_LOCAL",
      EventDef::Encoding{.code = 0xAF, .umask = 0x04, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Local)",
      R"(Distress signal asserted : DPT Local : Counts the number of cycles either the local or incoming distress signals are asserted. : Dynamic Prefetch Throttle triggered by this tile)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.DPT_NONLOCAL",
      EventDef::Encoding{.code = 0xAF, .umask = 0x08, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Remote)",
      R"(Distress signal asserted : DPT Remote : Counts the number of cycles either the local or incoming distress signals are asserted. : Dynamic Prefetch Throttle received by this tile)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.DPT_STALL_IV",
      EventDef::Encoding{.code = 0xAF, .umask = 0x40, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Stalled - IV)",
      R"(Distress signal asserted : DPT Stalled - IV : Counts the number of cycles either the local or incoming distress signals are asserted. : DPT occurred while regular IVs were received, causing DPT to be stalled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DISTRESS_ASSERTED.DPT_STALL_NOCRD",
      EventDef::Encoding{.code = 0xAF, .umask = 0x80, .umaskExt = 0x00},
      R"(Distress signal asserted : DPT Stalled -  No Credit)",
      R"(Distress signal asserted : DPT Stalled -  No Credit : Counts the number of cycles either the local or incoming distress signals are asserted. : DPT occurred while credit not available causing DPT to be stalled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_EGRESS_ORDERING.IV_SNOOPGO_UP",
      EventDef::Encoding{.code = 0xBA, .umask = 0x01, .umaskExt = 0x00},
      R"(Egress Blocking due to Ordering requirements : Up)",
      R"(Egress Blocking due to Ordering requirements : Up : Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_EGRESS_ORDERING.IV_SNOOPGO_DN",
      EventDef::Encoding{.code = 0xBA, .umask = 0x04, .umaskExt = 0x00},
      R"(Egress Blocking due to Ordering requirements : Down)",
      R"(Egress Blocking due to Ordering requirements : Down : Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB6, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Left and Even)",
      R"(Horizontal AD Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB6, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Left and Odd)",
      R"(Horizontal AD Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB6, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Right and Even)",
      R"(Horizontal AD Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB6, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AD Ring In Use : Right and Odd)",
      R"(Horizontal AD Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AKC_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xBB, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Even)",
      R"(Horizontal AK Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AKC_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xBB, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Odd)",
      R"(Horizontal AK Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AKC_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xBB, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Even)",
      R"(Horizontal AK Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AKC_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xBB, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Odd)",
      R"(Horizontal AK Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AKC ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in JKT -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB7, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Even)",
      R"(Horizontal AK Ring In Use : Left and Even : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB7, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Left and Odd)",
      R"(Horizontal AK Ring In Use : Left and Odd : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB7, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Even)",
      R"(Horizontal AK Ring In Use : Right and Even : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB7, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal AK Ring In Use : Right and Odd)",
      R"(Horizontal AK Ring In Use : Right and Odd : Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xB8, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Left and Even)",
      R"(Horizontal BL Ring in Use : Left and Even : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xB8, .umask = 0x02, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Left and Odd)",
      R"(Horizontal BL Ring in Use : Left and Odd : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xB8, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Right and Even)",
      R"(Horizontal BL Ring in Use : Right and Even : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xB8, .umask = 0x08, .umaskExt = 0x00},
      R"(Horizontal BL Ring in Use : Right and Odd)",
      R"(Horizontal BL Ring in Use : Right and Odd : Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_IV_IN_USE.LEFT",
      EventDef::Encoding{.code = 0xB9, .umask = 0x01, .umaskExt = 0x00},
      R"(Horizontal IV Ring in Use : Left)",
      R"(Horizontal IV Ring in Use : Left : Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_IV_IN_USE.RIGHT",
      EventDef::Encoding{.code = 0xB9, .umask = 0x04, .umaskExt = 0x00},
      R"(Horizontal IV Ring in Use : Right)",
      R"(Horizontal IV Ring in Use : Right : Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_MISC_EXTERNAL.MBE_INST0",
      EventDef::Encoding{.code = 0xE6, .umask = 0x01, .umaskExt = 0x00},
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI0)",
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_MISC_EXTERNAL.MBE_INST1",
      EventDef::Encoding{.code = 0xE6, .umask = 0x02, .umaskExt = 0x00},
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI1)",
      R"(Miscellaneous Events (mostly from MS2IDI) : Number of cycles MBE is high for MS2IDI1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.AD",
      EventDef::Encoding{.code = 0xAC, .umask = 0x01, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : AD)",
      R"(Messages that bounced on the Horizontal Ring. : AD : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.AK",
      EventDef::Encoding{.code = 0xAC, .umask = 0x02, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : AK)",
      R"(Messages that bounced on the Horizontal Ring. : AK : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.BL",
      EventDef::Encoding{.code = 0xAC, .umask = 0x04, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : BL)",
      R"(Messages that bounced on the Horizontal Ring. : BL : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.IV",
      EventDef::Encoding{.code = 0xAC, .umask = 0x08, .umaskExt = 0x00},
      R"(Messages that bounced on the Horizontal Ring. : IV)",
      R"(Messages that bounced on the Horizontal Ring. : IV : Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.AD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x01, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : AD)",
      R"(Messages that bounced on the Vertical Ring. : AD : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.AK",
      EventDef::Encoding{.code = 0xAA, .umask = 0x02, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Acknowledgements to core)",
      R"(Messages that bounced on the Vertical Ring. : Acknowledgements to core : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.BL",
      EventDef::Encoding{.code = 0xAA, .umask = 0x04, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Data Responses to core)",
      R"(Messages that bounced on the Vertical Ring. : Data Responses to core : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.IV",
      EventDef::Encoding{.code = 0xAA, .umask = 0x08, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring. : Snoops of processor's cache.)",
      R"(Messages that bounced on the Vertical Ring. : Snoops of processor's cache. : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.AKC",
      EventDef::Encoding{.code = 0xAA, .umask = 0x10, .umaskExt = 0x00},
      R"(Messages that bounced on the Vertical Ring.)",
      R"(Messages that bounced on the Vertical Ring. : Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AD",
      EventDef::Encoding{.code = 0xAD, .umask = 0x01, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : AD)",
      R"(Sink Starvation on Horizontal Ring : AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AK",
      EventDef::Encoding{.code = 0xAD, .umask = 0x02, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : AK)",
      R"(Sink Starvation on Horizontal Ring : AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.BL",
      EventDef::Encoding{.code = 0xAD, .umask = 0x04, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : BL)",
      R"(Sink Starvation on Horizontal Ring : BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.IV",
      EventDef::Encoding{.code = 0xAD, .umask = 0x08, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : IV)",
      R"(Sink Starvation on Horizontal Ring : IV)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AK_AG1",
      EventDef::Encoding{.code = 0xAD, .umask = 0x20, .umaskExt = 0x00},
      R"(Sink Starvation on Horizontal Ring : Acknowledgements to Agent 1)",
      R"(Sink Starvation on Horizontal Ring : Acknowledgements to Agent 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.AD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x01, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : AD)",
      R"(Sink Starvation on Vertical Ring : AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.AK",
      EventDef::Encoding{.code = 0xAB, .umask = 0x02, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Acknowledgements to core)",
      R"(Sink Starvation on Vertical Ring : Acknowledgements to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.BL",
      EventDef::Encoding{.code = 0xAB, .umask = 0x04, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Data Responses to core)",
      R"(Sink Starvation on Vertical Ring : Data Responses to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.IV",
      EventDef::Encoding{.code = 0xAB, .umask = 0x08, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring : Snoops of processor's cache.)",
      R"(Sink Starvation on Vertical Ring : Snoops of processor's cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.AKC",
      EventDef::Encoding{.code = 0xAB, .umask = 0x10, .umaskExt = 0x00},
      R"(Sink Starvation on Vertical Ring)",
      R"(Sink Starvation on Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.AD_UNCRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Uncredited)",
      R"(Transgress Injection Starvation : AD - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.BL_UNCRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Uncredited)",
      R"(Transgress Injection Starvation : BL - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Credited)",
      R"(Transgress Injection Starvation : AD - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xE5, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Credited)",
      R"(Transgress Injection Starvation : BL - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.AD_ALL",
      EventDef::Encoding{.code = 0xE5, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - All)",
      R"(Transgress Injection Starvation : AD - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.BL_ALL",
      EventDef::Encoding{.code = 0xE5, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - All)",
      R"(Transgress Injection Starvation : BL - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AD_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - Uncredited)",
      R"(Transgress Ingress Bypass : AD - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AK",
      EventDef::Encoding{.code = 0xE2, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AK)",
      R"(Transgress Ingress Bypass : AK : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.BL_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - Uncredited)",
      R"(Transgress Ingress Bypass : BL - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.IV",
      EventDef::Encoding{.code = 0xE2, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : IV)",
      R"(Transgress Ingress Bypass : IV : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - Credited)",
      R"(Transgress Ingress Bypass : AD - Credited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - Credited)",
      R"(Transgress Ingress Bypass : BL - Credited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE2, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AKC - Uncredited)",
      R"(Transgress Ingress Bypass : AKC - Uncredited : Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AD_ALL",
      EventDef::Encoding{.code = 0xE2, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : AD - All)",
      R"(Transgress Ingress Bypass : AD - All : Number of packets bypassing the CMS Ingress : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.BL_ALL",
      EventDef::Encoding{.code = 0xE2, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Bypass : BL - All)",
      R"(Transgress Ingress Bypass : BL - All : Number of packets bypassing the CMS Ingress : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AD_UNCRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Uncredited)",
      R"(Transgress Injection Starvation : AD - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AK",
      EventDef::Encoding{.code = 0xE3, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AK)",
      R"(Transgress Injection Starvation : AK : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.BL_UNCRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Uncredited)",
      R"(Transgress Injection Starvation : BL - Uncredited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.IV",
      EventDef::Encoding{.code = 0xE3, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : IV)",
      R"(Transgress Injection Starvation : IV : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - Credited)",
      R"(Transgress Injection Starvation : AD - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xE3, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - Credited)",
      R"(Transgress Injection Starvation : BL - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.IFV",
      EventDef::Encoding{.code = 0xE3, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : IFV - Credited)",
      R"(Transgress Injection Starvation : IFV - Credited : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AD_ALL",
      EventDef::Encoding{.code = 0xE3, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : AD - All)",
      R"(Transgress Injection Starvation : AD - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.BL_ALL",
      EventDef::Encoding{.code = 0xE3, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Injection Starvation : BL - All)",
      R"(Transgress Injection Starvation : BL - All : Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AD_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - Uncredited)",
      R"(Transgress Ingress Allocations : AD - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AK",
      EventDef::Encoding{.code = 0xE1, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AK)",
      R"(Transgress Ingress Allocations : AK : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.BL_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - Uncredited)",
      R"(Transgress Ingress Allocations : BL - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.IV",
      EventDef::Encoding{.code = 0xE1, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : IV)",
      R"(Transgress Ingress Allocations : IV : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - Credited)",
      R"(Transgress Ingress Allocations : AD - Credited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x40, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - Credited)",
      R"(Transgress Ingress Allocations : BL - Credited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE1, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AKC - Uncredited)",
      R"(Transgress Ingress Allocations : AKC - Uncredited : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AD_ALL",
      EventDef::Encoding{.code = 0xE1, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : AD - All)",
      R"(Transgress Ingress Allocations : AD - All : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.BL_ALL",
      EventDef::Encoding{.code = 0xE1, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Allocations : BL - All)",
      R"(Transgress Ingress Allocations : BL - All : Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AD_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x01, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - Uncredited)",
      R"(Transgress Ingress Occupancy : AD - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AK",
      EventDef::Encoding{.code = 0xE0, .umask = 0x02, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AK)",
      R"(Transgress Ingress Occupancy : AK : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.BL_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x04, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - Uncredited)",
      R"(Transgress Ingress Occupancy : BL - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.IV",
      EventDef::Encoding{.code = 0xE0, .umask = 0x08, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : IV)",
      R"(Transgress Ingress Occupancy : IV : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x10, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - Credited)",
      R"(Transgress Ingress Occupancy : AD - Credited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x20, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - Credited)",
      R"(Transgress Ingress Occupancy : BL - Credited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AKC_UNCRD",
      EventDef::Encoding{.code = 0xE0, .umask = 0x80, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AKC - Uncredited)",
      R"(Transgress Ingress Occupancy : AKC - Uncredited : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AD_ALL",
      EventDef::Encoding{.code = 0xE0, .umask = 0x11, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : AD - All)",
      R"(Transgress Ingress Occupancy : AD - All : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.BL_ALL",
      EventDef::Encoding{.code = 0xE0, .umask = 0x44, .umaskExt = 0x00},
      R"(Transgress Ingress Occupancy : BL - All)",
      R"(Transgress Ingress Occupancy : BL - All : Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR0",
      EventDef::Encoding{.code = 0xD0, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 0)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 0 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR1",
      EventDef::Encoding{.code = 0xD0, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 1)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 1 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR2",
      EventDef::Encoding{.code = 0xD0, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 2)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 2 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR3",
      EventDef::Encoding{.code = 0xD0, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 3)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 3 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR4",
      EventDef::Encoding{.code = 0xD0, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 4)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 4 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR5",
      EventDef::Encoding{.code = 0xD0, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 5)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 5 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR6",
      EventDef::Encoding{.code = 0xD0, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 6)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 6 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG0.TGR7",
      EventDef::Encoding{.code = 0xD0, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 7)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 7 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR0",
      EventDef::Encoding{.code = 0xD2, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 0)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 0 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR1",
      EventDef::Encoding{.code = 0xD2, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 1)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 1 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR2",
      EventDef::Encoding{.code = 0xD2, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 2)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 2 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR3",
      EventDef::Encoding{.code = 0xD2, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 3)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 3 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR4",
      EventDef::Encoding{.code = 0xD2, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 4)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 4 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR5",
      EventDef::Encoding{.code = 0xD2, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 5)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 5 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR6",
      EventDef::Encoding{.code = 0xD2, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 6)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 6 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_AD_AG1.TGR7",
      EventDef::Encoding{.code = 0xD2, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 7)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 7 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR0",
      EventDef::Encoding{.code = 0xD4, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 0)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 0 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR1",
      EventDef::Encoding{.code = 0xD4, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 1)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 1 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR2",
      EventDef::Encoding{.code = 0xD4, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 2)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 2 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR3",
      EventDef::Encoding{.code = 0xD4, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 3)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 3 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR4",
      EventDef::Encoding{.code = 0xD4, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 4)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 4 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR5",
      EventDef::Encoding{.code = 0xD4, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 5)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 5 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR6",
      EventDef::Encoding{.code = 0xD4, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 6)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 6 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG0.TGR7",
      EventDef::Encoding{.code = 0xD4, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 7)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 7 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR0",
      EventDef::Encoding{.code = 0xD6, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 0)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 0 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR1",
      EventDef::Encoding{.code = 0xD6, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 1)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 1 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR2",
      EventDef::Encoding{.code = 0xD6, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 2)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 2 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR3",
      EventDef::Encoding{.code = 0xD6, .umask = 0x08, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 3)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 3 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR4",
      EventDef::Encoding{.code = 0xD6, .umask = 0x10, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 4)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 4 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR5",
      EventDef::Encoding{.code = 0xD6, .umask = 0x20, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 5)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 5 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR6",
      EventDef::Encoding{.code = 0xD6, .umask = 0x40, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 6)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 6 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL0_NO_TxR_HORZ_CRD_BL_AG1.TGR7",
      EventDef::Encoding{.code = 0xD6, .umask = 0x80, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 7)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 7 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR8",
      EventDef::Encoding{.code = 0xD1, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 8)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 8 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR9",
      EventDef::Encoding{.code = 0xD1, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 9)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 9 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG0.TGR10",
      EventDef::Encoding{.code = 0xD1, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 10)",
      R"(Stall on No AD Agent0 Transgress Credits : For Transgress 10 : Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR8",
      EventDef::Encoding{.code = 0xD3, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 8)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 8 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR9",
      EventDef::Encoding{.code = 0xD3, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 9)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 9 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1.TGR10",
      EventDef::Encoding{.code = 0xD3, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 10)",
      R"(Stall on No AD Agent1 Transgress Credits : For Transgress 10 : Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR8",
      EventDef::Encoding{.code = 0xD5, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 8)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 8 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR9",
      EventDef::Encoding{.code = 0xD5, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 9)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 9 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1.TGR10",
      EventDef::Encoding{.code = 0xD5, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 10)",
      R"(Stall on No BL Agent0 Transgress Credits : For Transgress 10 : Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR8",
      EventDef::Encoding{.code = 0xD7, .umask = 0x01, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 8)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 8 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR9",
      EventDef::Encoding{.code = 0xD7, .umask = 0x02, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 9)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 9 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1.TGR10",
      EventDef::Encoding{.code = 0xD7, .umask = 0x04, .umaskExt = 0x00},
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 10)",
      R"(Stall on No BL Agent1 Transgress Credits : For Transgress 10 : Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AD_UNCRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - Uncredited)",
      R"(CMS Horizontal ADS Used : AD - Uncredited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.BL_UNCRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - Uncredited)",
      R"(CMS Horizontal ADS Used : BL - Uncredited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AD_CRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x10, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - Credited)",
      R"(CMS Horizontal ADS Used : AD - Credited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.BL_CRD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x40, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - Credited)",
      R"(CMS Horizontal ADS Used : BL - Credited : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AD_ALL",
      EventDef::Encoding{.code = 0xA6, .umask = 0x11, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : AD - All)",
      R"(CMS Horizontal ADS Used : AD - All : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.BL_ALL",
      EventDef::Encoding{.code = 0xA6, .umask = 0x44, .umaskExt = 0x00},
      R"(CMS Horizontal ADS Used : BL - All)",
      R"(CMS Horizontal ADS Used : BL - All : Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent. : All == Credited + Uncredited)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.AD_UNCRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x01, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AD - Uncredited)",
      R"(CMS Horizontal Bypass Used : AD - Uncredited : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.AK",
      EventDef::Encoding{.code = 0xA7, .umask = 0x02, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : AK)",
      R"(CMS Horizontal Bypass Used : AK : Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.BL_UNCRD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x04, .umaskExt = 0x00},
      R"(CMS Horizontal Bypass Used : BL - Uncredited)",
      R"(CMS Horizontal Bypass Used : BL - Uncredited : Number of packets bypassing the Horizontal Eg