/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.RepositoryKind;

public class MavenRepositoryInfo
implements Serializable {
    private final String myId;
    private final String myName;
    private final String myUrl;
    private final RepositoryKind myKind;

    public MavenRepositoryInfo(String id, String name, String url, RepositoryKind kind) {
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myKind = kind;
    }

    public MavenRepositoryInfo(String id, String url, RepositoryKind kind) {
        this(id, id, url, kind);
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public RepositoryKind getKind() {
        return this.myKind;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        MavenId.append((StringBuilder)builder, (String)this.myId);
        MavenId.append((StringBuilder)builder, (String)this.myName);
        MavenId.append((StringBuilder)builder, (String)this.myUrl);
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRepositoryInfo info = (MavenRepositoryInfo)o;
        return Objects.equals(this.myId, info.myId) && Objects.equals(this.myName, info.myName) && Objects.equals(this.myUrl, info.myUrl) && this.myKind == info.myKind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myId, this.myName, this.myUrl, this.myKind});
    }
}

