/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkGlobalDeclaration", "checkLocalDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSealedSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,88:1\n67#2:89\n48#2:90\n40#2:91\n*S KotlinDebug\n*F\n+ 1 FirSealedSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSealedSupertypeChecker\n*L\n49#1:89\n58#1:90\n75#1:91\n*E\n"})
public final class FirSealedSupertypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSealedSupertypeChecker INSTANCE = new FirSealedSupertypeChecker();

    private FirSealedSupertypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (FirDeclarationUtilKt.getClassId(declaration).isLocal()) {
            this.checkLocalDeclaration(context, reporter, declaration);
        } else {
            this.checkGlobalDeclaration(context, reporter, declaration);
        }
    }

    private final void checkGlobalDeclaration(CheckerContext context, DiagnosticReporter reporter, FirClass declaration) {
        FqName subclassPackage = FirDeclarationUtilKt.getClassId(declaration).getPackageFqName();
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            FirRegularClassSymbol superClass;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId superClassId;
            if (FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(superTypeRef), context.getSession()) == null || superClassId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId(superClassId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClass = superClass;
            FirClassLikeSymbol $this$isSealed$iv = superClass;
            boolean $i$f$isSealed = false;
            if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) continue;
            if (superClass.getOrigin() instanceof FirDeclarationOrigin.Java) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)superTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getCLASS_INHERITS_JAVA_SEALED_CLASS(), null, (int)8, null);
                continue;
            }
            FqName superClassPackage = superClass.getClassId().getPackageFqName();
            if (!Intrinsics.areEqual((Object)superClassPackage, (Object)subclassPackage)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)superTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_PACKAGE(), null, (int)8, null);
            }
            if (Intrinsics.areEqual((Object)superClass.getModuleData(), (Object)declaration.getModuleData())) continue;
            FirClassLikeSymbol $this$isExpect$iv = superClass;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getRawStatus().isExpect()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)superTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_MODULE(), null, (int)8, null);
        }
    }

    private final void checkLocalDeclaration(CheckerContext context, DiagnosticReporter reporter, FirClass declaration) {
        for (FirTypeRef it : declaration.getSuperTypeRefs()) {
            FirRegularClassSymbol superClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            ClassId classId;
            if (FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it), context.getSession()) == null || classId.isLocal() || ((firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId(classId)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null) == null) continue;
            superClassSymbol = superClassSymbol;
            FirClassLikeSymbol $this$modality$iv = superClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.SEALED) continue;
            String declarationType = declaration instanceof FirAnonymousObject ? "Anonymous object" : "Local class";
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it.getSource()), FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), (Object)declarationType, (Object)superClassSymbol.getClassKind(), null, (int)32, null);
            return;
        }
    }
}

