/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBoxLayout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010$\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxSpec;", "", "title", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "reverse", "", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;Z)V", "contentBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getContentBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "contentOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getContentOrigin", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "contentSize", "getContentSize", "fullContentExtend", "innerBounds", "getInnerBounds", "innerContentExtend", "innerOrigin", "layout", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxLayout;", "getLayout", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBoxLayout;", "getReverse", "()Z", "size", "getSize", "getTheme", "()Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "getTitle", "()Ljava/lang/String;", "hasTitle", "plot-builder"})
public abstract class LegendBoxSpec {
    @NotNull
    private final String title;
    @NotNull
    private final LegendTheme theme;
    private final boolean reverse;
    @NotNull
    private final DoubleVector contentOrigin;
    @NotNull
    private final DoubleVector fullContentExtend;
    @NotNull
    private final DoubleVector innerOrigin;
    @NotNull
    private final DoubleVector innerContentExtend;

    public LegendBoxSpec(@NotNull String title, @NotNull LegendTheme theme, boolean reverse) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.title = title;
        this.theme = theme;
        this.reverse = reverse;
        DoubleVector contentExpand = new DoubleVector(this.theme.backgroundStrokeWidth(), this.theme.backgroundStrokeWidth());
        this.contentOrigin = this.theme.margins().getLeftTop().add(contentExpand);
        this.fullContentExtend = this.theme.margins().getSize().add(contentExpand.mul(2.0));
        this.innerOrigin = contentExpand.mul(0.5);
        this.innerContentExtend = this.theme.margins().getSize().add(contentExpand);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final LegendTheme getTheme() {
        return this.theme;
    }

    public final boolean getReverse() {
        return this.reverse;
    }

    @NotNull
    public abstract LegendBoxLayout getLayout();

    @NotNull
    public final DoubleVector getContentOrigin() {
        return this.contentOrigin;
    }

    private final DoubleVector getContentSize() {
        return this.getLayout().getSize();
    }

    @NotNull
    public final DoubleVector getSize() {
        return this.getContentSize().add(this.fullContentExtend);
    }

    @NotNull
    public final DoubleRectangle getInnerBounds() {
        return new DoubleRectangle(this.innerOrigin, this.getContentSize().add(this.innerContentExtend));
    }

    @NotNull
    public final DoubleRectangle getContentBounds() {
        return new DoubleRectangle(this.contentOrigin, this.getContentSize());
    }

    public final boolean hasTitle() {
        return !StringsKt.isBlank((CharSequence)this.title) && this.theme.showTitle();
    }
}

