/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public final class WriteOnceFile
implements Closeable {
    private static final Logger LOG = Logger.getInstance(WriteOnceFile.class);
    private final FileChannel myStream;
    private final ByteBuffer myBuffer;

    public WriteOnceFile(Path path) throws IOException {
        this(path, 0x100000);
    }

    public WriteOnceFile(Path path, int bufferSize) throws IOException {
        if (Files.deleteIfExists(path)) {
            LOG.info("Deleted old file '" + String.valueOf(path.toAbsolutePath()) + "' to be able to write a new one");
        }
        this.myStream = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        this.myBuffer = ByteBuffer.allocate(bufferSize);
    }

    public void putLong(long value) throws IOException {
        if (!this.myBuffer.hasRemaining()) {
            this.flush();
        }
        this.myBuffer.putLong(value);
    }

    public void putInt(int value) throws IOException {
        if (!this.myBuffer.hasRemaining()) {
            this.flush();
        }
        this.myBuffer.putInt(value);
    }

    public void flush() throws IOException {
        this.myBuffer.flip();
        this.myStream.write(this.myBuffer);
        this.myBuffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.myStream.close();
        ByteBufferUtil.cleanBuffer((ByteBuffer)this.myBuffer);
    }
}

