/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceMapDataImpl;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceMappingList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001d\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J1\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/debugger/sourcemap/SourceMapDataCache;", "", "<init>", "()V", "cache", "", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataImpl;", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "getOrCreate", "sourceMapData", "", "mapDebugName", "", "calculateReverseMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "data", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "(Lorg/jetbrains/debugger/sourcemap/SourceMapData;)[Lorg/jetbrains/debugger/sourcemap/MappingList;", "getOrCreateMapping", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "reverseMappingsBySourceUrl", "sourceIndex", "", "([Ljava/util/List;I)Ljava/util/List;", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public final class SourceMapDataCache {
    @NotNull
    public static final SourceMapDataCache INSTANCE = new SourceMapDataCache();
    @NotNull
    private static final Map<SourceMapDataImpl, SourceMapDataEx> cache;

    private SourceMapDataCache() {
    }

    @Nullable
    public final SourceMapDataEx getOrCreate(@NotNull CharSequence sourceMapData, @Nullable String mapDebugName) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        SourceMapDataImpl sourceMapDataImpl = SourceMapDecoderKt.parseMapSafely(sourceMapData, mapDebugName);
        if (sourceMapDataImpl == null) {
            return null;
        }
        SourceMapDataImpl data = sourceMapDataImpl;
        SourceMapDataEx value = cache.get(data);
        if (value != null) {
            return value;
        }
        MappingList[] sourceIndexToMappings = this.calculateReverseMappings(data);
        GeneratedMappingList generatedMappings = new GeneratedMappingList(data.getMappings());
        SourceMapDataEx result = new SourceMapDataEx(data, sourceIndexToMappings, generatedMappings);
        cache.put(data, result);
        return result;
    }

    public static /* synthetic */ SourceMapDataEx getOrCreate$default(SourceMapDataCache sourceMapDataCache, CharSequence charSequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return sourceMapDataCache.getOrCreate(charSequence, string);
    }

    private final MappingList[] calculateReverseMappings(SourceMapData data) {
        List[] reverseMappingsBySourceUrl = new List[data.getSources().size()];
        for (MappingEntry entry : data.getMappings()) {
            int sourceIndex = entry.getSource();
            if (sourceIndex < 0) continue;
            List<MappingEntry> reverseMappings = this.getOrCreateMapping(reverseMappingsBySourceUrl, sourceIndex);
            reverseMappings.add(entry);
        }
        int n = reverseMappingsBySourceUrl.length;
        MappingList[] mappingListArray = new MappingList[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            List entries = reverseMappingsBySourceUrl[n2];
            mappingListArray[n2] = entries == null ? null : new SourceMappingList(entries);
        }
        return mappingListArray;
    }

    private final List<MappingEntry> getOrCreateMapping(List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        List reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = (List)new ArrayList();
        }
        return reverseMappings;
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        cache = concurrentMap;
    }
}

