
# htdocs/info.txt.rb: export file info as list.
#   pack:  "/info.txt.rb?pack=21"
#   range: "/info.txt.rb?pack=21;last=29"
#   group: "/info.txt.rb?group=ZZZ"

# Author::    Dirk Meyer
# Copyright:: Copyright (c) 2008-2021 Dirk Meyer
# License::   Distributes under the same terms as Ruby
# SPDX-FileCopyrightText: 2008-2021 Dirk Meyer
# SPDX-License-Identifier: Ruby

now = Time.now.to_s

bot = IrofferEvent.new
version = bot.irconfig( "version" )

puts "# Generated by #{version} on #{now}\r"

require "cgi"

cgi = CGI.new('html4Tr')  # New CGI object

def get_post( cgi, name, fallback = '' )
  val = cgi.params[ name ][0]
  if val.nil?
    return fallback
  end
  return val
end

def print_head( bot, pack, group = nil )
  bytes = bot.info_pack(pack, "bytes" )
  if bytes.nil?
    return nil
  end
  if not group.nil?
    if bot.info_pack(pack, "group" ) != group
      return pack + 1
    end
  end
  md5 = bot.info_pack(pack, "md5sum" )
  crc = bot.info_pack(pack, "crc32" )
  file = bot.info_pack(pack, "file" )
  bytes = bot.info_pack(pack, "bytes" )
  mtime = bot.info_pack(pack, "mtime" )
  file.sub!( /^.*\//, '' )
  printf( "%s;%s;%s;%s;%s\r\n", file, crc, md5, bytes, mtime.to_i )
  return pack + 1
end

first = get_post( cgi, 'pack', 1 ).to_i
last = get_post( cgi, 'last', first.to_s ).to_i
group = get_post( cgi, 'group', nil )

if not group.nil?
  pack = 1
  while true do
    pack = print_head( bot, pack, group )
    if pack.nil?
      break
    end
  end
else
  pack = first
  while pack <= last do
    pack = print_head( bot, pack )
    if pack.nil?
      break
    end
  end
end

# eof
