import type { StrictCSSProperties, CSSPseudoClasses, CSSPseudoElements, CSSPseudos } from '../types';
/**
 * This is the shape of the generic object that `createStrictAPI()` takes.
 * It's deliberately a subset of `AllowedStyles` and does not take at rules
 * and pseudo elements.
 */
export type CompiledSchemaShape = StrictCSSProperties & {
    [Q in CSSPseudoClasses]?: StrictCSSProperties;
};
export type PseudosDeclarations = {
    [Q in CSSPseudos]?: StrictCSSProperties;
};
export type MediaQueries<TMediaQuery extends string> = {
    [Q in `@media ${TMediaQuery}`]?: StrictCSSProperties & PseudosDeclarations;
};
export type AllowedStyles<TMediaQuery extends string> = StrictCSSProperties & PseudosDeclarations & MediaQueries<TMediaQuery>;
export type ApplySchemaValue<TSchema, TKey extends keyof StrictCSSProperties, TPseudoKey extends CSSPseudoClasses | ''> = TKey extends keyof TSchema ? TPseudoKey extends keyof TSchema ? TKey extends keyof TSchema[TPseudoKey] ? TSchema[TPseudoKey][TKey] : TSchema[TKey] : TSchema[TKey] : StrictCSSProperties[TKey];
/**
 * Recursively maps over object properties to resolve them to either a {@link TSchema}
 * value if present, else fallback to its value from {@link StrictCSSProperties}. If
 * the property isn't a known property its value will be resolved to `never`.
 */
export type ApplySchema<TObject, TSchema, TPseudoKey extends CSSPseudoClasses | '' = ''> = {
    [TKey in keyof TObject]?: TKey extends keyof StrictCSSProperties ? ApplySchemaValue<TSchema, TKey, TPseudoKey> : TKey extends CSSPseudoClasses ? ApplySchema<TObject[TKey], TSchema, TKey> : TKey extends `@${string}` | CSSPseudoElements ? ApplySchema<TObject[TKey], TSchema> : never;
};
export type ApplySchemaMap<TStylesMap, TSchema> = {
    [P in keyof TStylesMap]: ApplySchema<TStylesMap[P], TSchema>;
};
