package grype

import (
	"path/filepath"
	"testing"

	"github.com/anchore/grype/grype/db/legacy/distribution"
	"github.com/anchore/grype/internal"
)

// this benchmark was added to measure the performance
// of LoadVulnerabilityDB, specifically in regards to hash validation.
// https://github.com/anchore/grype/issues/1502
func BenchmarkLoadVulnerabilityDB(b *testing.B) {
	cfg := distribution.Config{
		DBRootDir:           filepath.Join(".tmp", "grype-db"),
		ListingURL:          internal.DBUpdateURL,
		ValidateByHashOnGet: true,
	}
	for range b.N {
		_, _, err := LoadVulnerabilityDB(cfg, true)
		if err != nil {
			b.Fatal(err)
		}
	}
}
