/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.ItemCommandEvent;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.items.events.ItemStateEvent;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.Type;
import org.openhab.core.types.TypeParser;
import org.openhab.core.types.UnDefType;
import org.openhab.core.util.DurationUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ExpireManager.class, EventSubscriber.class}, configurationPid={"org.openhab.expire"}, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class ExpireManager
implements EventSubscriber,
RegistryChangeListener<Item> {
    protected static final String EVENT_SOURCE = "org.openhab.core.expire";
    protected static final String METADATA_NAMESPACE = "expire";
    protected static final String PROPERTY_ENABLED = "enabled";
    private static final Set<String> SUBSCRIBED_EVENT_TYPES = Set.of(ItemStateEvent.TYPE, ItemStateChangedEvent.TYPE, ItemCommandEvent.TYPE, GroupItemStateChangedEvent.TYPE);
    private final Logger logger = LoggerFactory.getLogger(ExpireManager.class);
    private final Map<String, Optional<ExpireConfig>> itemExpireConfig = new ConcurrentHashMap<String, Optional<ExpireConfig>>();
    private final Map<String, Instant> itemExpireMap = new ConcurrentHashMap<String, Instant>();
    private final ScheduledExecutorService threadPool = ThreadPoolManager.getScheduledPool("common");
    private final EventPublisher eventPublisher;
    private final MetadataRegistry metadataRegistry;
    private final ItemRegistry itemRegistry;
    final MetadataChangeListener metadataChangeListener = new MetadataChangeListener();
    private boolean enabled = true;
    private @Nullable ScheduledFuture<?> expireJob;

    @Activate
    public ExpireManager(Map<String, @Nullable Object> configuration, @Reference EventPublisher eventPublisher, @Reference MetadataRegistry metadataRegistry, @Reference ItemRegistry itemRegistry) {
        this.eventPublisher = eventPublisher;
        this.metadataRegistry = metadataRegistry;
        this.itemRegistry = itemRegistry;
        this.modified(configuration);
    }

    @Modified
    protected void modified(Map<String, @Nullable Object> configuration) {
        Object valueEnabled = configuration.get(PROPERTY_ENABLED);
        if (valueEnabled != null) {
            this.enabled = Boolean.parseBoolean(valueEnabled.toString());
        }
        if (this.enabled) {
            ScheduledFuture<?> localExpireJob = this.expireJob;
            if (localExpireJob == null) {
                this.expireJob = this.threadPool.scheduleWithFixedDelay(() -> {
                    if (!this.itemExpireMap.isEmpty()) {
                        for (String itemName : this.itemExpireConfig.keySet()) {
                            if (!this.isReadyToExpire(itemName)) continue;
                            this.expire(itemName);
                        }
                    }
                }, 1L, 1L, TimeUnit.SECONDS);
            }
            this.itemRegistry.addRegistryChangeListener(this);
            this.metadataRegistry.addRegistryChangeListener(this.metadataChangeListener);
        } else {
            this.deactivate();
        }
    }

    @Deactivate
    protected void deactivate() {
        ScheduledFuture<?> localExpireJob = this.expireJob;
        if (localExpireJob != null) {
            localExpireJob.cancel(true);
            this.expireJob = null;
        }
        this.itemRegistry.removeRegistryChangeListener(this);
        this.metadataRegistry.removeRegistryChangeListener(this.metadataChangeListener);
        this.itemExpireMap.clear();
    }

    private void processEvent(String itemName, Type stateOrCommand, ExpireConfig expireConfig, Class<?> eventClz) {
        this.logger.trace("Received '{}' for item {}, event type= {}", new Object[]{stateOrCommand, itemName, eventClz.getSimpleName()});
        Command expireCommand = expireConfig.expireCommand;
        State expireState = expireConfig.expireState;
        if (expireCommand != null && expireCommand.equals(stateOrCommand) || expireState != null && expireState.equals(stateOrCommand)) {
            this.itemExpireMap.remove(itemName);
            this.logger.debug("Item {} received '{}'; stopping any future expiration.", (Object)itemName, (Object)stateOrCommand);
        } else {
            Duration duration = expireConfig.duration;
            this.itemExpireMap.put(itemName, Instant.now().plus(duration));
            this.logger.debug("Item {} will expire (with '{}' {}) in {} ms", new Object[]{itemName, expireCommand == null ? expireState : expireCommand, expireCommand == null ? "state" : "command", duration});
        }
    }

    private @Nullable ExpireConfig getExpireConfig(String itemName) {
        Optional<ExpireConfig> itemConfig = this.itemExpireConfig.get(itemName);
        if (itemConfig != null) {
            return itemConfig.orElse(null);
        }
        Metadata metadata = (Metadata)this.metadataRegistry.get(new MetadataKey(METADATA_NAMESPACE, itemName));
        if (metadata != null) {
            try {
                Item item = this.itemRegistry.getItem(itemName);
                try {
                    ExpireConfig cfg = new ExpireConfig(item, metadata.getValue(), metadata.getConfiguration());
                    this.itemExpireConfig.put(itemName, Optional.of(cfg));
                    return cfg;
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Expire config '{}' of item '{}' is invalid: {}", new Object[]{metadata.getValue(), itemName, e.getMessage()});
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("Item '{}' does not exist.", (Object)itemName);
            }
        }
        this.itemExpireConfig.put(itemName, Optional.empty());
        return null;
    }

    private void postCommand(String itemName, Command command) {
        this.eventPublisher.post(ItemEventFactory.createCommandEvent(itemName, command, EVENT_SOURCE));
    }

    private void postUpdate(String itemName, State state) {
        this.eventPublisher.post(ItemEventFactory.createStateEvent(itemName, state, EVENT_SOURCE));
    }

    private boolean isReadyToExpire(String itemName) {
        Instant nextExpiry = this.itemExpireMap.get(itemName);
        return nextExpiry != null && Instant.now().isAfter(nextExpiry);
    }

    private void expire(String itemName) {
        this.itemExpireMap.remove(itemName);
        Optional<ExpireConfig> expireConfig = this.itemExpireConfig.get(itemName);
        if (expireConfig != null && expireConfig.isPresent()) {
            Command expireCommand = expireConfig.get().expireCommand;
            State expireState = expireConfig.get().expireState;
            if (expireCommand != null) {
                this.logger.debug("Item {} received no command or update for {} - posting command '{}'", new Object[]{itemName, expireConfig.get().duration, expireCommand});
                this.postCommand(itemName, expireCommand);
            } else if (expireState != null) {
                this.logger.debug("Item {} received no command or update for {} - posting state '{}'", new Object[]{itemName, expireConfig.get().duration, expireState});
                this.postUpdate(itemName, expireState);
            }
        }
    }

    @Override
    public Set<String> getSubscribedEventTypes() {
        return SUBSCRIBED_EVENT_TYPES;
    }

    @Override
    public void receive(Event event) {
        if (!this.enabled) {
            return;
        }
        if (!(event instanceof ItemEvent)) {
            return;
        }
        ItemEvent itemEvent = (ItemEvent)event;
        String itemName = itemEvent.getItemName();
        ExpireConfig expireConfig = this.getExpireConfig(itemName);
        if (expireConfig == null) {
            return;
        }
        if (event instanceof ItemStateEvent) {
            ItemStateEvent isEvent = (ItemStateEvent)event;
            if (!expireConfig.ignoreStateUpdates) {
                this.processEvent(itemName, isEvent.getItemState(), expireConfig, event.getClass());
            }
        } else if (event instanceof ItemCommandEvent) {
            ItemCommandEvent icEvent = (ItemCommandEvent)event;
            if (!expireConfig.ignoreCommands) {
                this.processEvent(itemName, icEvent.getItemCommand(), expireConfig, event.getClass());
            }
        } else if (event instanceof ItemStateChangedEvent) {
            ItemStateChangedEvent icEvent = (ItemStateChangedEvent)event;
            this.processEvent(itemName, icEvent.getItemState(), expireConfig, event.getClass());
        }
    }

    @Override
    public void added(Item item) {
        this.itemExpireConfig.remove(item.getName());
    }

    @Override
    public void removed(Item item) {
        this.itemExpireConfig.remove(item.getName());
    }

    @Override
    public void updated(Item oldItem, Item item) {
        this.itemExpireConfig.remove(item.getName());
    }

    static class ExpireConfig {
        static final String CONFIG_DURATION = "duration";
        static final String CONFIG_COMMAND = "command";
        static final String CONFIG_STATE = "state";
        static final String CONFIG_IGNORE_STATE_UPDATES = "ignoreStateUpdates";
        static final String CONFIG_IGNORE_COMMANDS = "ignoreCommands";
        static final Set<String> CONFIG_KEYS = Set.of("duration", "command", "state", "ignoreStateUpdates", "ignoreCommands");
        private static final StringType STRING_TYPE_NULL_HYPHEN = new StringType("'NULL'");
        private static final StringType STRING_TYPE_NULL = new StringType("NULL");
        private static final StringType STRING_TYPE_UNDEF_HYPHEN = new StringType("'UNDEF'");
        private static final StringType STRING_TYPE_UNDEF = new StringType("UNDEF");
        protected static final String COMMAND_PREFIX = "command=";
        protected static final String STATE_PREFIX = "state=";
        final @Nullable Command expireCommand;
        final @Nullable State expireState;
        final String durationString;
        final Duration duration;
        final boolean ignoreStateUpdates;
        final boolean ignoreCommands;

        public ExpireConfig(Item item, String configString, Map<String, Object> configuration) throws IllegalArgumentException {
            String durationStr;
            int commaPos = configString.indexOf(44);
            String commandString = null;
            String stateString = null;
            String string = durationStr = commaPos >= 0 ? configString.substring(0, commaPos).trim() : configString.trim();
            if (configuration.containsKey(CONFIG_DURATION)) {
                if (!durationStr.isEmpty()) {
                    throw new IllegalArgumentException("Expire duration for item " + item.getName() + " is specified in both the value string and the configuration");
                }
                durationStr = configuration.get(CONFIG_DURATION).toString();
            }
            this.durationString = durationStr;
            this.duration = DurationUtils.parse(this.durationString);
            if (this.duration.isNegative()) {
                throw new IllegalArgumentException("Expire duration for item " + item.getName() + " must be a positive value");
            }
            String stateOrCommand = commaPos >= 0 && configString.length() - 1 > commaPos ? configString.substring(commaPos + 1).trim() : null;
            this.ignoreStateUpdates = this.getBooleanConfigValue(configuration, CONFIG_IGNORE_STATE_UPDATES);
            this.ignoreCommands = this.getBooleanConfigValue(configuration, CONFIG_IGNORE_COMMANDS);
            if (configuration.containsKey(CONFIG_COMMAND)) {
                commandString = configuration.get(CONFIG_COMMAND).toString();
            }
            if (configuration.containsKey(CONFIG_STATE)) {
                if (commandString != null) {
                    throw new IllegalArgumentException("Expire configuration for item " + item.getName() + " contains both command and state");
                }
                stateString = configuration.get(CONFIG_STATE).toString();
            }
            if (stateOrCommand != null && !stateOrCommand.isEmpty()) {
                if (commandString != null || stateString != null) {
                    throw new IllegalArgumentException("Expire state/command for item " + item.getName() + " is specified in both the value string and the configuration");
                }
                if (stateOrCommand.startsWith(COMMAND_PREFIX)) {
                    commandString = stateOrCommand.substring(COMMAND_PREFIX.length());
                } else {
                    if (stateOrCommand.startsWith(STATE_PREFIX)) {
                        stateOrCommand = stateOrCommand.substring(STATE_PREFIX.length());
                    }
                    stateString = stateOrCommand;
                }
            }
            if (commandString != null) {
                this.expireCommand = TypeParser.parseCommand(item.getAcceptedCommandTypes(), commandString);
                this.expireState = null;
                if (this.expireCommand == null) {
                    throw new IllegalArgumentException("The string '" + commandString + "' does not represent a valid command for item " + item.getName());
                }
            } else if (stateString != null) {
                this.expireCommand = null;
                State state = TypeParser.parseState(item.getAcceptedDataTypes(), stateString);
                this.expireState = STRING_TYPE_NULL_HYPHEN.equals(state) ? STRING_TYPE_NULL : (STRING_TYPE_UNDEF_HYPHEN.equals(state) ? STRING_TYPE_UNDEF : state);
                if (this.expireState == null) {
                    throw new IllegalArgumentException("The string '" + stateString + "' does not represent a valid state for item " + item.getName());
                }
            } else {
                this.expireCommand = null;
                this.expireState = UnDefType.UNDEF;
            }
            if (!CONFIG_KEYS.containsAll(configuration.keySet())) {
                HashSet<String> unknownKeys = new HashSet<String>(configuration.keySet());
                unknownKeys.removeAll(CONFIG_KEYS);
                throw new IllegalArgumentException("Expire configuration for item " + item.getName() + " contains unknown keys: " + String.valueOf(unknownKeys));
            }
        }

        private boolean getBooleanConfigValue(Map<String, Object> configuration, String configKey) {
            boolean configValue;
            Object configValueObject = configuration.get(configKey);
            if (configValueObject instanceof String) {
                String string = (String)configValueObject;
                configValue = Boolean.parseBoolean(string);
            } else if (configValueObject instanceof Boolean) {
                Boolean boolean1 = (Boolean)configValueObject;
                configValue = boolean1;
            } else {
                configValue = false;
            }
            return configValue;
        }

        public String toString() {
            return "duration='" + this.durationString + "', s=" + this.duration.toSeconds() + ", state='" + String.valueOf(this.expireState) + "', command='" + String.valueOf(this.expireCommand) + "', ignoreStateUpdates=" + this.ignoreStateUpdates + ", ignoreCommands=" + this.ignoreCommands;
        }
    }

    class MetadataChangeListener
    implements RegistryChangeListener<Metadata> {
        MetadataChangeListener() {
        }

        @Override
        public void added(Metadata element) {
            ExpireManager.this.itemExpireConfig.remove(element.getUID().getItemName());
        }

        @Override
        public void removed(Metadata element) {
            ExpireManager.this.itemExpireConfig.remove(element.getUID().getItemName());
        }

        @Override
        public void updated(Metadata oldElement, Metadata element) {
            ExpireManager.this.itemExpireConfig.remove(element.getUID().getItemName());
        }
    }
}

