/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.addons;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonEvent;
import org.openhab.core.addon.AddonEventFactory;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonInfoRegistry;
import org.openhab.core.addon.AddonService;
import org.openhab.core.addon.AddonType;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.discovery.addon.AddonSuggestionService;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.config.ConfigurationService;
import org.openhab.core.io.rest.core.internal.addons.AddonServiceDTO;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="addons")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="addons")
@Component
@JaxrsResource
@JaxrsName(value="addons")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class AddonResource
implements RESTResource,
EventSubscriber {
    private static final String THREAD_POOL_NAME = "addonService";
    public static final String PATH_ADDONS = "addons";
    public static final String DEFAULT_ADDON_SERVICE = "karaf";
    private static final Set<String> SUBSCRIBED_EVENT_TYPES = Set.of(AddonEvent.TYPE);
    private final Logger logger = LoggerFactory.getLogger(AddonResource.class);
    private final Set<AddonService> addonServices = new CopyOnWriteArraySet<AddonService>();
    private final EventPublisher eventPublisher;
    private final LocaleService localeService;
    private final ConfigurationService configurationService;
    private final AddonInfoRegistry addonInfoRegistry;
    private final ConfigDescriptionRegistry configDescriptionRegistry;
    private final AddonSuggestionService addonSuggestionService;
    private @Nullable Date lastModified = null;
    @Context
    @NonNullByDefault(value={})
    private UriInfo uriInfo;

    @Activate
    public AddonResource(@Reference EventPublisher eventPublisher, @Reference LocaleService localeService, @Reference ConfigurationService configurationService, @Reference AddonInfoRegistry addonInfoRegistry, @Reference ConfigDescriptionRegistry configDescriptionRegistry, @Reference AddonSuggestionService addonSuggestionService) {
        this.eventPublisher = eventPublisher;
        this.localeService = localeService;
        this.configurationService = configurationService;
        this.addonInfoRegistry = addonInfoRegistry;
        this.configDescriptionRegistry = configDescriptionRegistry;
        this.addonSuggestionService = addonSuggestionService;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addAddonService(AddonService featureService) {
        this.addonServices.add(featureService);
        this.lastModified = null;
    }

    protected void removeAddonService(AddonService featureService) {
        this.addonServices.remove(featureService);
    }

    public Set<String> getSubscribedEventTypes() {
        return SUBSCRIBED_EVENT_TYPES;
    }

    public void receive(Event event) {
        this.lastModified = null;
    }

    private boolean lastModifiedIsValid() {
        return this.lastModified != null && new Date().getTime() - this.lastModified.getTime() <= 450000L;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getAddons", summary="Get all add-ons.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Addon.class)))}), @ApiResponse(responseCode="404", description="Service not found")})
    public Response getAddon(@Context Request request, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        AddonService addonService;
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        if (this.lastModifiedIsValid()) {
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
        }
        Locale locale = this.localeService.getLocale(language);
        if ("all".equals(serviceId)) {
            return Response.ok((Object)new Stream2JSONInputStream(this.getAllAddons(locale))).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
        }
        AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
        if (addonService == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)new Stream2JSONInputStream(addonService.getAddons(locale).stream())).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
    }

    @GET
    @Path(value="/services")
    @Produces(value={"application/json"})
    @Operation(operationId="getAddonTypes", summary="Get all add-on types.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AddonType.class)))})})
    public Response getServices(@Context Request request, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        if (this.lastModifiedIsValid()) {
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
        }
        Locale locale = this.localeService.getLocale(language);
        Stream<AddonServiceDTO> addonTypeStream = this.addonServices.stream().map(s -> this.convertToAddonServiceDTO((AddonService)s, locale));
        return Response.ok((Object)new Stream2JSONInputStream(addonTypeStream)).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
    }

    @GET
    @Path(value="/suggestions")
    @Produces(value={"application/json"})
    @Operation(operationId="getSuggestedAddons", summary="Get suggested add-ons to be installed.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Addon.class)))})})
    public Response getSuggestions(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        return Response.ok((Object)new Stream2JSONInputStream(this.addonSuggestionService.getSuggestedAddons(locale).stream())).build();
    }

    @GET
    @Path(value="/types")
    @Produces(value={"application/json"})
    @Operation(operationId="getAddonServices", summary="Get add-on services.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AddonType.class)))}), @ApiResponse(responseCode="404", description="Service not found")})
    public Response getTypes(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        this.logger.debug("Received HTTP GET request at '{}'", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        if (serviceId != null) {
            @Nullable AddonService service = this.getServiceById(serviceId);
            if (service != null) {
                Stream addonTypeStream = this.getAddonTypesForService(service, locale).stream().distinct();
                return Response.ok((Object)new Stream2JSONInputStream(addonTypeStream)).build();
            }
            return Response.status((int)404).build();
        }
        Stream addonTypeStream = this.getAllAddonTypes(locale).stream().distinct();
        return Response.ok((Object)new Stream2JSONInputStream(addonTypeStream)).build();
    }

    @GET
    @Path(value="/{addonId: [a-zA-Z_0-9-:]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getAddonById", summary="Get add-on with given ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=Addon.class))}), @ApiResponse(responseCode="404", description="Not found")})
    public Response getById(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="addonId") @Parameter(description="addon ID") String addonId, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        AddonService addonService;
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)this.uriInfo.getPath());
        Locale locale = this.localeService.getLocale(language);
        AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
        if (addonService == null) {
            return Response.status((int)404).build();
        }
        Addon responseObject = addonService.getAddon(addonId, locale);
        if (responseObject != null) {
            return Response.ok((Object)responseObject).build();
        }
        return Response.status((int)404).build();
    }

    @POST
    @Path(value="/{addonId: [a-zA-Z_0-9-:]+}/install")
    @Operation(operationId="installAddonById", summary="Installs the add-on with the given ID.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not found")})
    public Response installAddon(@PathParam(value="addonId") @Parameter(description="addon ID") String addonId, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        AddonService addonService;
        AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
        if (addonService == null || addonService.getAddon(addonId, null) == null) {
            return Response.status((int)404).build();
        }
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(() -> {
            try {
                addonService.install(addonId);
            }
            catch (Exception e) {
                this.logger.error("Exception while installing add-on: {}", (Object)e.getMessage());
                this.postFailureEvent(addonId, e.getMessage());
            }
        });
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/url/{url}/install")
    @Operation(operationId="installAddonFromURL", summary="Installs the add-on from the given URL.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="The given URL is malformed or not valid.")})
    public Response installAddonByURL(@PathParam(value="url") @Parameter(description="addon install URL") String url) {
        try {
            URI addonURI = new URI(url);
            String addonId = this.getAddonId(addonURI);
            this.installAddon(addonId, this.getAddonServiceForAddonId(addonURI));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            this.logger.error("Exception while parsing the addon URL '{}': {}", (Object)url, (Object)e.getMessage());
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"The given URL is malformed or not valid.");
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{addonId: [a-zA-Z_0-9-:]+}/uninstall")
    @Operation(operationId="uninstallAddon", summary="Uninstalls the add-on with the given ID.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not found")})
    public Response uninstallAddon(@PathParam(value="addonId") @Parameter(description="addon ID") String addonId, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        AddonService addonService;
        AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
        if (addonService == null || addonService.getAddon(addonId, null) == null) {
            return Response.status((int)404).build();
        }
        ThreadPoolManager.getPool((String)THREAD_POOL_NAME).submit(() -> {
            try {
                addonService.uninstall(addonId);
            }
            catch (Exception e) {
                this.logger.error("Exception while uninstalling add-on: {}", (Object)e.getMessage());
                this.postFailureEvent(addonId, e.getMessage());
            }
        });
        return Response.ok(null, (String)"text/plain").build();
    }

    @GET
    @Path(value="/{addonId: [a-zA-Z_0-9-:]+}/config")
    @Produces(value={"application/json"})
    @Operation(operationId="getAddonConfiguration", summary="Get add-on configuration for given add-on ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Add-on does not exist"), @ApiResponse(responseCode="500", description="Configuration can not be read due to internal error")})
    public Response getConfiguration(@PathParam(value="addonId") @Parameter(description="addon ID") String addonId, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId) {
        try {
            AddonService addonService;
            AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
            if (addonService == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Addon addon = addonService.getAddon(addonId, null);
            if (addon == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String infoUid = addon.getType() + "-" + addon.getId();
            AddonInfo addonInfo = this.addonInfoRegistry.getAddonInfo(infoUid);
            if (addonInfo == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Configuration configuration = this.configurationService.get(addonInfo.getServiceId());
            return configuration != null ? Response.ok((Object)configuration.getProperties()).build() : Response.ok(Map.of()).build();
        }
        catch (IOException e) {
            this.logger.error("Cannot get configuration for service {}: {}", new Object[]{addonId, e.getMessage(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{addonId: [a-zA-Z_0-9-:]+}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="updateAddonConfiguration", summary="Updates an add-on configuration for given ID and returns the old configuration.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="204", description="No old configuration"), @ApiResponse(responseCode="404", description="Add-on does not exist"), @ApiResponse(responseCode="500", description="Configuration can not be updated due to internal error")})
    public Response updateConfiguration(@PathParam(value="addonId") @Parameter(description="Add-on id") String addonId, @QueryParam(value="serviceId") @Parameter(description="service ID") @Nullable String serviceId, @Nullable Map<String, @Nullable Object> configuration) {
        try {
            AddonService addonService;
            AddonService addonService2 = addonService = serviceId != null ? this.getServiceById(serviceId) : this.getDefaultService();
            if (addonService == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Addon addon = addonService.getAddon(addonId, null);
            if (addon == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String infoUid = addon.getType() + "-" + addon.getId();
            AddonInfo addonInfo = this.addonInfoRegistry.getAddonInfo(infoUid);
            if (addonInfo == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Configuration oldConfiguration = this.configurationService.get(addonInfo.getServiceId());
            this.configurationService.update(addonInfo.getServiceId(), new Configuration(this.normalizeConfiguration(configuration, infoUid)));
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration.getProperties()).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot update configuration for service {}: {}", new Object[]{addonId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private @Nullable Map<String, @Nullable Object> normalizeConfiguration(@Nullable Map<String, @Nullable Object> properties, String addonId) {
        ConfigDescription configDesc;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        AddonInfo addonInfo = this.addonInfoRegistry.getAddonInfo(addonId);
        if (addonInfo == null || addonInfo.getConfigDescriptionURI() == null) {
            return properties;
        }
        String configDescriptionURI = addonInfo.getConfigDescriptionURI();
        if (configDescriptionURI != null && (configDesc = this.configDescriptionRegistry.getConfigDescription(URI.create(configDescriptionURI))) != null) {
            return ConfigUtil.normalizeTypes(properties, List.of(configDesc));
        }
        return properties;
    }

    private void postFailureEvent(String addonId, @Nullable String msg) {
        AddonEvent event = AddonEventFactory.createAddonFailureEvent((String)addonId, (String)msg);
        this.eventPublisher.post((Event)event);
    }

    private @Nullable AddonService getDefaultService() {
        return this.addonServices.stream().filter(addonService -> DEFAULT_ADDON_SERVICE.equals(addonService.getId())).findFirst().orElse(this.addonServices.stream().findFirst().orElse(null));
    }

    private Stream<Addon> getAllAddons(Locale locale) {
        return this.addonServices.stream().map(s -> s.getAddons(locale)).flatMap(Collection::stream);
    }

    private Set<AddonType> getAllAddonTypes(Locale locale) {
        Collator coll = Collator.getInstance(locale);
        coll.setStrength(0);
        TreeSet<AddonType> ret = new TreeSet<AddonType>((o1, o2) -> coll.compare(o1.getLabel(), o2.getLabel()));
        for (AddonService addonService : this.addonServices) {
            ret.addAll(addonService.getTypes(locale));
        }
        return ret;
    }

    private Set<AddonType> getAddonTypesForService(AddonService addonService, Locale locale) {
        Collator coll = Collator.getInstance(locale);
        coll.setStrength(0);
        TreeSet<AddonType> ret = new TreeSet<AddonType>((o1, o2) -> coll.compare(o1.getLabel(), o2.getLabel()));
        ret.addAll(addonService.getTypes(locale));
        return ret;
    }

    private @Nullable AddonService getServiceById(String serviceId) {
        for (AddonService addonService : this.addonServices) {
            if (!addonService.getId().equals(serviceId)) continue;
            return addonService;
        }
        return null;
    }

    private String getAddonId(URI addonURI) {
        for (AddonService addonService : this.addonServices) {
            String addonId = addonService.getAddonId(addonURI);
            if (addonId == null || addonId.isBlank()) continue;
            return addonId;
        }
        throw new IllegalArgumentException("No add-on service registered for URI " + String.valueOf(addonURI));
    }

    private String getAddonServiceForAddonId(URI addonURI) {
        for (AddonService addonService : this.addonServices) {
            String addonId = addonService.getAddonId(addonURI);
            if (addonId == null || addonId.isBlank()) continue;
            return addonService.getId();
        }
        throw new IllegalArgumentException("No add-on service registered for URI " + String.valueOf(addonURI));
    }

    private AddonServiceDTO convertToAddonServiceDTO(AddonService addonService, Locale locale) {
        return new AddonServiceDTO(addonService.getId(), addonService.getName(), this.getAddonTypesForService(addonService, locale));
    }
}

