/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.witness;

import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmHeapLocation
extends JvmMemoryLocation {
    public final SetAbstractState<Reference> reference;
    public final String field;

    public JvmHeapLocation(SetAbstractState<Reference> reference, String field) {
        this(null, reference, field);
    }

    public JvmHeapLocation(ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> argNode, SetAbstractState<Reference> reference, String field) {
        this.argNode = argNode;
        this.reference = reference;
        this.field = field;
    }

    @Override
    public JvmHeapLocation copy() {
        return new JvmHeapLocation(this.argNode, this.reference, this.field);
    }

    @Override
    public <T extends LatticeAbstractState> T extractValueOrDefault(JvmAbstractState abstractState, T defaultValue) {
        return (T)abstractState.getHeap().getField(this.reference, this.field, (SetAbstractState<Reference>)defaultValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmHeapLocation)) {
            return false;
        }
        JvmHeapLocation other = (JvmHeapLocation)obj;
        return super.equals(other) && this.reference.equals(other.reference);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argNode, this.reference.hashCode());
    }

    public String toString() {
        return "JvmHeapLocation(" + this.reference.stream().sorted(Comparator.comparingInt(Reference::hashCode)).collect(Collectors.toList()) + ", " + this.field + ")" + (this.argNode == null ? "" : "@" + ((JvmCfaNode)this.argNode.getProgramLocation()).getSignature().getFqn() + ":" + ((JvmCfaNode)this.argNode.getProgramLocation()).getOffset());
    }
}

