/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassPrinter;
import proguard.resources.file.ResourceFile;

public class CompactCodeAttributeComposer
implements AttributeVisitor {
    private final ConstantPoolEditor constantPoolEditor;
    private final CodeAttributeComposer codeAttributeComposer;
    private int labelCount = 0;

    public CompactCodeAttributeComposer(ProgramClass targetClass) {
        this(targetClass, null, null);
    }

    public CompactCodeAttributeComposer(ProgramClass targetClass, ClassPool programClassPool, ClassPool libraryClassPool) {
        this(targetClass, false, true, true, programClassPool, libraryClassPool);
    }

    public CompactCodeAttributeComposer(ProgramClass targetClass, boolean allowExternalBranchTargets, boolean allowExternalExceptionOffsets, boolean shrinkInstructions) {
        this(targetClass, allowExternalBranchTargets, allowExternalExceptionOffsets, shrinkInstructions, null, null);
    }

    public CompactCodeAttributeComposer(ProgramClass targetClass, boolean allowExternalBranchTargets, boolean allowExternalExceptionOffsets, boolean shrinkInstructions, ClassPool programClassPool, ClassPool libraryClassPool) {
        this(new ConstantPoolEditor(targetClass, programClassPool, libraryClassPool), allowExternalBranchTargets, allowExternalExceptionOffsets, shrinkInstructions);
    }

    public CompactCodeAttributeComposer(ConstantPoolEditor constantPoolEditor, boolean allowExternalBranchTargets, boolean allowExternalExceptionOffsets, boolean shrinkInstructions) {
        this(constantPoolEditor, new CodeAttributeComposer(allowExternalBranchTargets, allowExternalExceptionOffsets, shrinkInstructions, true));
    }

    public CompactCodeAttributeComposer(ConstantPoolEditor constantPoolEditor, CodeAttributeComposer codeAttributeComposer) {
        this.constantPoolEditor = constantPoolEditor;
        this.codeAttributeComposer = codeAttributeComposer;
    }

    public ProgramClass getTargetClass() {
        return this.constantPoolEditor.getTargetClass();
    }

    public ConstantPoolEditor getConstantPoolEditor() {
        return this.constantPoolEditor;
    }

    public int getCodeLength() {
        return this.codeAttributeComposer.getCodeLength();
    }

    public void convertToTargetType(String sourceType, String targetType) {
        if (ClassUtil.isInternalPrimitiveType(sourceType) && !ClassUtil.isInternalPrimitiveType(targetType)) {
            this.boxPrimitiveType(sourceType.charAt(0));
        } else if (!ClassUtil.isInternalPrimitiveType(sourceType) && ClassUtil.isInternalPrimitiveType(targetType)) {
            this.unboxPrimitiveType(sourceType, targetType);
        } else if (ClassUtil.isInternalClassType(sourceType) && (ClassUtil.isInternalClassType(targetType) || ClassUtil.isInternalArrayType(targetType)) && !sourceType.equals(targetType) && !"Ljava/lang/Object;".equals(targetType)) {
            this.checkcast(ClassUtil.internalClassTypeFromType(targetType));
        } else if (ClassUtil.isInternalPrimitiveType(sourceType) && ClassUtil.isInternalPrimitiveType(targetType) && !sourceType.equals(targetType)) {
            char source = sourceType.charAt(0);
            char target = targetType.charAt(0);
            this.convertPrimitiveType(source, target);
        }
    }

    public void boxPrimitiveType(char sourceType) {
        switch (sourceType) {
            case 'I': {
                this.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 'B': {
                this.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 'C': {
                this.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 'S': {
                this.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 'Z': {
                this.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 'J': {
                this.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 'F': {
                this.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 'D': {
                this.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }
    }

    public void convertPrimitiveType(char source, char target) {
        if (source == 'S' || source == 'B' || source == 'C') {
            source = (char)73;
        }
        block0 : switch (source) {
            case 'I': {
                switch (target) {
                    case 'D': {
                        this.i2d();
                        break;
                    }
                    case 'B': {
                        this.i2b();
                        break;
                    }
                    case 'C': {
                        this.i2c();
                        break;
                    }
                    case 'F': {
                        this.i2f();
                        break;
                    }
                    case 'J': {
                        this.i2l();
                        break;
                    }
                    case 'S': {
                        this.i2s();
                    }
                }
                break;
            }
            case 'F': {
                switch (target) {
                    case 'D': {
                        this.f2d();
                        break;
                    }
                    case 'B': {
                        this.f2i();
                        this.i2b();
                        break;
                    }
                    case 'C': {
                        this.f2i();
                        this.i2c();
                        break;
                    }
                    case 'I': {
                        this.f2i();
                        break;
                    }
                    case 'J': {
                        this.f2l();
                        break;
                    }
                    case 'S': {
                        this.f2i();
                        this.i2s();
                    }
                }
                break;
            }
            case 'D': {
                switch (target) {
                    case 'I': {
                        this.d2i();
                        break;
                    }
                    case 'B': {
                        this.d2i();
                        this.i2b();
                        break;
                    }
                    case 'C': {
                        this.d2i();
                        this.i2c();
                        break;
                    }
                    case 'F': {
                        this.d2f();
                        break;
                    }
                    case 'J': {
                        this.d2l();
                        break;
                    }
                    case 'S': {
                        this.d2i();
                        this.i2s();
                    }
                }
                break;
            }
            case 'J': {
                switch (target) {
                    case 'D': {
                        this.l2d();
                        break block0;
                    }
                    case 'B': {
                        this.l2i();
                        this.i2b();
                        break block0;
                    }
                    case 'C': {
                        this.l2i();
                        this.i2c();
                        break block0;
                    }
                    case 'F': {
                        this.l2f();
                        break block0;
                    }
                    case 'I': {
                        this.l2i();
                        break block0;
                    }
                    case 'S': {
                        this.l2i();
                        this.i2s();
                    }
                }
            }
        }
    }

    public void unboxPrimitiveType(String sourceType, String targetType) {
        boolean castRequired = sourceType.equals("Ljava/lang/Object;");
        switch (targetType.charAt(0)) {
            case 'I': {
                if (castRequired) {
                    this.checkcast("java/lang/Number");
                }
                this.invokevirtual("java/lang/Number", "intValue", "()I");
                break;
            }
            case 'B': {
                if (castRequired) {
                    this.checkcast("java/lang/Byte");
                }
                this.invokevirtual("java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 'C': {
                if (castRequired) {
                    this.checkcast("java/lang/Character");
                }
                this.invokevirtual("java/lang/Character", "charValue", "()C");
                break;
            }
            case 'S': {
                if (castRequired) {
                    this.checkcast("java/lang/Short");
                }
                this.invokevirtual("java/lang/Short", "shortValue", "()S");
                break;
            }
            case 'Z': {
                if (castRequired) {
                    this.checkcast("java/lang/Boolean");
                }
                this.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 'J': {
                if (castRequired) {
                    this.checkcast("java/lang/Number");
                }
                this.invokevirtual("java/lang/Number", "longValue", "()J");
                break;
            }
            case 'F': {
                if (castRequired) {
                    this.checkcast("java/lang/Number");
                }
                this.invokevirtual("java/lang/Number", "floatValue", "()F");
                break;
            }
            case 'D': {
                if (castRequired) {
                    this.checkcast("java/lang/Number");
                }
                this.invokevirtual("java/lang/Number", "doubleValue", "()D");
            }
        }
    }

    public CompactCodeAttributeComposer reset() {
        this.codeAttributeComposer.reset();
        this.labelCount = 0;
        return this;
    }

    public CompactCodeAttributeComposer beginCodeFragment(int maximumCodeFragmentLength) {
        this.codeAttributeComposer.beginCodeFragment(maximumCodeFragmentLength);
        return this;
    }

    public Label createLabel() {
        return new Label(this.labelCount++);
    }

    public CompactCodeAttributeComposer label(Label label) {
        this.codeAttributeComposer.appendLabel(label.offset);
        return this;
    }

    public CompactCodeAttributeComposer appendInstructions(Instruction[] instructions) {
        this.codeAttributeComposer.appendInstructions(instructions);
        return this;
    }

    public CompactCodeAttributeComposer appendInstruction(Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(instruction);
        return this;
    }

    public CompactCodeAttributeComposer catchAll(Label startLabel, Label endLabel) {
        return this.catch_(startLabel, endLabel, null, null);
    }

    public CompactCodeAttributeComposer catchAll(Label startLabel, Label endLabel, Label handlerLabel) {
        return this.catch_(startLabel, endLabel, handlerLabel, null, null);
    }

    public CompactCodeAttributeComposer catch_(Label startLabel, Label endLabel, String catchType, Clazz referencedClass) {
        Label handlerLabel = this.createLabel();
        this.codeAttributeComposer.appendLabel(handlerLabel.offset);
        return this.catch_(startLabel, endLabel, handlerLabel, catchType, referencedClass);
    }

    public CompactCodeAttributeComposer catch_(Label startLabel, Label endLabel, Label handlerLabel, String catchType, Clazz referencedClass) {
        int u2catchType = catchType == null ? 0 : this.constantPoolEditor.addClassConstant(catchType, referencedClass);
        this.codeAttributeComposer.appendException(new ExceptionInfo(startLabel.offset, endLabel.offset, handlerLabel.offset, u2catchType));
        return this;
    }

    public CompactCodeAttributeComposer line(int lineNumber) {
        Label currentLabel = this.createLabel();
        this.codeAttributeComposer.appendLabel(currentLabel.offset);
        this.codeAttributeComposer.appendLineNumber(new LineNumberInfo(currentLabel.offset, lineNumber));
        return this;
    }

    public CompactCodeAttributeComposer endCodeFragment() {
        this.codeAttributeComposer.endCodeFragment();
        return this;
    }

    public CompactCodeAttributeComposer nop() {
        return this.appendInstruction(new SimpleInstruction(0));
    }

    public CompactCodeAttributeComposer aconst_null() {
        return this.appendInstruction(new SimpleInstruction(1));
    }

    public CompactCodeAttributeComposer iconst(int constant) {
        return this.appendInstruction(new SimpleInstruction(3, constant));
    }

    public CompactCodeAttributeComposer iconst_m1() {
        return this.appendInstruction(new SimpleInstruction(2));
    }

    public CompactCodeAttributeComposer iconst_0() {
        return this.appendInstruction(new SimpleInstruction(3));
    }

    public CompactCodeAttributeComposer iconst_1() {
        return this.appendInstruction(new SimpleInstruction(4));
    }

    public CompactCodeAttributeComposer iconst_2() {
        return this.appendInstruction(new SimpleInstruction(5));
    }

    public CompactCodeAttributeComposer iconst_3() {
        return this.appendInstruction(new SimpleInstruction(6));
    }

    public CompactCodeAttributeComposer iconst_4() {
        return this.appendInstruction(new SimpleInstruction(7));
    }

    public CompactCodeAttributeComposer iconst_5() {
        return this.appendInstruction(new SimpleInstruction(8));
    }

    public CompactCodeAttributeComposer lconst(int constant) {
        return this.appendInstruction(new SimpleInstruction(9, constant));
    }

    public CompactCodeAttributeComposer lconst_0() {
        return this.appendInstruction(new SimpleInstruction(9));
    }

    public CompactCodeAttributeComposer lconst_1() {
        return this.appendInstruction(new SimpleInstruction(10));
    }

    public CompactCodeAttributeComposer fconst(int constant) {
        return this.appendInstruction(new SimpleInstruction(11, constant));
    }

    public CompactCodeAttributeComposer fconst_0() {
        return this.appendInstruction(new SimpleInstruction(11));
    }

    public CompactCodeAttributeComposer fconst_1() {
        return this.appendInstruction(new SimpleInstruction(12));
    }

    public CompactCodeAttributeComposer fconst_2() {
        return this.appendInstruction(new SimpleInstruction(13));
    }

    public CompactCodeAttributeComposer dconst(int constant) {
        return this.appendInstruction(new SimpleInstruction(14, constant));
    }

    public CompactCodeAttributeComposer dconst_0() {
        return this.appendInstruction(new SimpleInstruction(14));
    }

    public CompactCodeAttributeComposer dconst_1() {
        return this.appendInstruction(new SimpleInstruction(15));
    }

    public CompactCodeAttributeComposer bipush(int constant) {
        return this.appendInstruction(new SimpleInstruction(16, constant));
    }

    public CompactCodeAttributeComposer sipush(int constant) {
        return this.appendInstruction(new SimpleInstruction(17, constant));
    }

    public CompactCodeAttributeComposer ldc(int value) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public CompactCodeAttributeComposer ldc(float value) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(value));
    }

    public CompactCodeAttributeComposer ldc(String string) {
        return this.ldc(string, null, null);
    }

    public CompactCodeAttributeComposer ldc(Object primitiveArray) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArray));
    }

    public CompactCodeAttributeComposer ldc(Clazz clazz, Member member) {
        return this.ldc(member.getName(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer ldc(String string, Clazz referencedClass, Member referencedMember) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer ldc(ResourceFile resourceFile) {
        return this.ldc(resourceFile.getFileName(), resourceFile);
    }

    public CompactCodeAttributeComposer ldc(String string, ResourceFile referencedResourceFile) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedResourceFile));
    }

    public CompactCodeAttributeComposer ldc(Clazz clazz) {
        return this.ldc(clazz.getName(), clazz);
    }

    public CompactCodeAttributeComposer ldc(String typeName, Clazz referencedClass) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public CompactCodeAttributeComposer ldc_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(18, constantIndex));
    }

    public CompactCodeAttributeComposer ldc_w(int value) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public CompactCodeAttributeComposer ldc_w(float value) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(value));
    }

    public CompactCodeAttributeComposer ldc_w(String string) {
        return this.ldc_w(string, null, null);
    }

    public CompactCodeAttributeComposer ldc_w(Object primitiveArray) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArray));
    }

    public CompactCodeAttributeComposer ldc_w(Clazz clazz, Member member) {
        return this.ldc_w(member.getName(clazz), clazz, member);
    }

    public CompactCodeAttributeComposer ldc_w(String string, Clazz referencedClass, Member referencedMember) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer ldc_w(ResourceFile resourceFile) {
        return this.ldc_w(resourceFile.getFileName(), resourceFile);
    }

    public CompactCodeAttributeComposer ldc_w(String string, ResourceFile referencedResourceFile) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedResourceFile));
    }

    public CompactCodeAttributeComposer ldc_w(Clazz clazz) {
        return this.ldc_w(clazz.getName(), clazz);
    }

    public CompactCodeAttributeComposer ldc_w(String typeName, Clazz referencedClass) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(typeName, referencedClass));
    }

    public CompactCodeAttributeComposer ldc_w_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(19, constantIndex));
    }

    public CompactCodeAttributeComposer ldc2_w(long value) {
        return this.ldc2_w(this.constantPoolEditor.addLongConstant(value));
    }

    public CompactCodeAttributeComposer ldc2_w(double value) {
        return this.ldc2_w(this.constantPoolEditor.addDoubleConstant(value));
    }

    public CompactCodeAttributeComposer ldc2_w(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(20, constantIndex));
    }

    public CompactCodeAttributeComposer iload(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(21, variableIndex));
    }

    public CompactCodeAttributeComposer lload(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(22, variableIndex));
    }

    public CompactCodeAttributeComposer fload(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(23, variableIndex));
    }

    public CompactCodeAttributeComposer dload(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(24, variableIndex));
    }

    public CompactCodeAttributeComposer aload(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(25, variableIndex));
    }

    public CompactCodeAttributeComposer iload_0() {
        return this.appendInstruction(new VariableInstruction(26));
    }

    public CompactCodeAttributeComposer iload_1() {
        return this.appendInstruction(new VariableInstruction(27));
    }

    public CompactCodeAttributeComposer iload_2() {
        return this.appendInstruction(new VariableInstruction(28));
    }

    public CompactCodeAttributeComposer iload_3() {
        return this.appendInstruction(new VariableInstruction(29));
    }

    public CompactCodeAttributeComposer lload_0() {
        return this.appendInstruction(new VariableInstruction(30));
    }

    public CompactCodeAttributeComposer lload_1() {
        return this.appendInstruction(new VariableInstruction(31));
    }

    public CompactCodeAttributeComposer lload_2() {
        return this.appendInstruction(new VariableInstruction(32));
    }

    public CompactCodeAttributeComposer lload_3() {
        return this.appendInstruction(new VariableInstruction(33));
    }

    public CompactCodeAttributeComposer fload_0() {
        return this.appendInstruction(new VariableInstruction(34));
    }

    public CompactCodeAttributeComposer fload_1() {
        return this.appendInstruction(new VariableInstruction(35));
    }

    public CompactCodeAttributeComposer fload_2() {
        return this.appendInstruction(new VariableInstruction(36));
    }

    public CompactCodeAttributeComposer fload_3() {
        return this.appendInstruction(new VariableInstruction(37));
    }

    public CompactCodeAttributeComposer dload_0() {
        return this.appendInstruction(new VariableInstruction(38));
    }

    public CompactCodeAttributeComposer dload_1() {
        return this.appendInstruction(new VariableInstruction(39));
    }

    public CompactCodeAttributeComposer dload_2() {
        return this.appendInstruction(new VariableInstruction(40));
    }

    public CompactCodeAttributeComposer dload_3() {
        return this.appendInstruction(new VariableInstruction(41));
    }

    public CompactCodeAttributeComposer aload_0() {
        return this.appendInstruction(new VariableInstruction(42));
    }

    public CompactCodeAttributeComposer aload_1() {
        return this.appendInstruction(new VariableInstruction(43));
    }

    public CompactCodeAttributeComposer aload_2() {
        return this.appendInstruction(new VariableInstruction(44));
    }

    public CompactCodeAttributeComposer aload_3() {
        return this.appendInstruction(new VariableInstruction(45));
    }

    public CompactCodeAttributeComposer iaload() {
        return this.appendInstruction(new SimpleInstruction(46));
    }

    public CompactCodeAttributeComposer laload() {
        return this.appendInstruction(new SimpleInstruction(47));
    }

    public CompactCodeAttributeComposer faload() {
        return this.appendInstruction(new SimpleInstruction(48));
    }

    public CompactCodeAttributeComposer daload() {
        return this.appendInstruction(new SimpleInstruction(49));
    }

    public CompactCodeAttributeComposer aaload() {
        return this.appendInstruction(new SimpleInstruction(50));
    }

    public CompactCodeAttributeComposer baload() {
        return this.appendInstruction(new SimpleInstruction(51));
    }

    public CompactCodeAttributeComposer caload() {
        return this.appendInstruction(new SimpleInstruction(52));
    }

    public CompactCodeAttributeComposer saload() {
        return this.appendInstruction(new SimpleInstruction(53));
    }

    public CompactCodeAttributeComposer istore(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(54, variableIndex));
    }

    public CompactCodeAttributeComposer lstore(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(55, variableIndex));
    }

    public CompactCodeAttributeComposer fstore(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(56, variableIndex));
    }

    public CompactCodeAttributeComposer dstore(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(57, variableIndex));
    }

    public CompactCodeAttributeComposer astore(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(58, variableIndex));
    }

    public CompactCodeAttributeComposer istore_0() {
        return this.appendInstruction(new VariableInstruction(59));
    }

    public CompactCodeAttributeComposer istore_1() {
        return this.appendInstruction(new VariableInstruction(60));
    }

    public CompactCodeAttributeComposer istore_2() {
        return this.appendInstruction(new VariableInstruction(61));
    }

    public CompactCodeAttributeComposer istore_3() {
        return this.appendInstruction(new VariableInstruction(62));
    }

    public CompactCodeAttributeComposer lstore_0() {
        return this.appendInstruction(new VariableInstruction(63));
    }

    public CompactCodeAttributeComposer lstore_1() {
        return this.appendInstruction(new VariableInstruction(64));
    }

    public CompactCodeAttributeComposer lstore_2() {
        return this.appendInstruction(new VariableInstruction(65));
    }

    public CompactCodeAttributeComposer lstore_3() {
        return this.appendInstruction(new VariableInstruction(66));
    }

    public CompactCodeAttributeComposer fstore_0() {
        return this.appendInstruction(new VariableInstruction(67));
    }

    public CompactCodeAttributeComposer fstore_1() {
        return this.appendInstruction(new VariableInstruction(68));
    }

    public CompactCodeAttributeComposer fstore_2() {
        return this.appendInstruction(new VariableInstruction(69));
    }

    public CompactCodeAttributeComposer fstore_3() {
        return this.appendInstruction(new VariableInstruction(70));
    }

    public CompactCodeAttributeComposer dstore_0() {
        return this.appendInstruction(new VariableInstruction(71));
    }

    public CompactCodeAttributeComposer dstore_1() {
        return this.appendInstruction(new VariableInstruction(72));
    }

    public CompactCodeAttributeComposer dstore_2() {
        return this.appendInstruction(new VariableInstruction(73));
    }

    public CompactCodeAttributeComposer dstore_3() {
        return this.appendInstruction(new VariableInstruction(74));
    }

    public CompactCodeAttributeComposer astore_0() {
        return this.appendInstruction(new VariableInstruction(75));
    }

    public CompactCodeAttributeComposer astore_1() {
        return this.appendInstruction(new VariableInstruction(76));
    }

    public CompactCodeAttributeComposer astore_2() {
        return this.appendInstruction(new VariableInstruction(77));
    }

    public CompactCodeAttributeComposer astore_3() {
        return this.appendInstruction(new VariableInstruction(78));
    }

    public CompactCodeAttributeComposer iastore() {
        return this.appendInstruction(new SimpleInstruction(79));
    }

    public CompactCodeAttributeComposer lastore() {
        return this.appendInstruction(new SimpleInstruction(80));
    }

    public CompactCodeAttributeComposer fastore() {
        return this.appendInstruction(new SimpleInstruction(81));
    }

    public CompactCodeAttributeComposer dastore() {
        return this.appendInstruction(new SimpleInstruction(82));
    }

    public CompactCodeAttributeComposer aastore() {
        return this.appendInstruction(new SimpleInstruction(83));
    }

    public CompactCodeAttributeComposer bastore() {
        return this.appendInstruction(new SimpleInstruction(84));
    }

    public CompactCodeAttributeComposer castore() {
        return this.appendInstruction(new SimpleInstruction(85));
    }

    public CompactCodeAttributeComposer sastore() {
        return this.appendInstruction(new SimpleInstruction(86));
    }

    public CompactCodeAttributeComposer pop() {
        return this.appendInstruction(new SimpleInstruction(87));
    }

    public CompactCodeAttributeComposer pop2() {
        return this.appendInstruction(new SimpleInstruction(88));
    }

    public CompactCodeAttributeComposer dup() {
        return this.appendInstruction(new SimpleInstruction(89));
    }

    public CompactCodeAttributeComposer dup_x1() {
        return this.appendInstruction(new SimpleInstruction(90));
    }

    public CompactCodeAttributeComposer dup_x2() {
        return this.appendInstruction(new SimpleInstruction(91));
    }

    public CompactCodeAttributeComposer dup2() {
        return this.appendInstruction(new SimpleInstruction(92));
    }

    public CompactCodeAttributeComposer dup2_x1() {
        return this.appendInstruction(new SimpleInstruction(93));
    }

    public CompactCodeAttributeComposer dup2_x2() {
        return this.appendInstruction(new SimpleInstruction(94));
    }

    public CompactCodeAttributeComposer swap() {
        return this.appendInstruction(new SimpleInstruction(95));
    }

    public CompactCodeAttributeComposer iadd() {
        return this.appendInstruction(new SimpleInstruction(96));
    }

    public CompactCodeAttributeComposer ladd() {
        return this.appendInstruction(new SimpleInstruction(97));
    }

    public CompactCodeAttributeComposer fadd() {
        return this.appendInstruction(new SimpleInstruction(98));
    }

    public CompactCodeAttributeComposer dadd() {
        return this.appendInstruction(new SimpleInstruction(99));
    }

    public CompactCodeAttributeComposer isub() {
        return this.appendInstruction(new SimpleInstruction(100));
    }

    public CompactCodeAttributeComposer lsub() {
        return this.appendInstruction(new SimpleInstruction(101));
    }

    public CompactCodeAttributeComposer fsub() {
        return this.appendInstruction(new SimpleInstruction(102));
    }

    public CompactCodeAttributeComposer dsub() {
        return this.appendInstruction(new SimpleInstruction(103));
    }

    public CompactCodeAttributeComposer imul() {
        return this.appendInstruction(new SimpleInstruction(104));
    }

    public CompactCodeAttributeComposer lmul() {
        return this.appendInstruction(new SimpleInstruction(105));
    }

    public CompactCodeAttributeComposer fmul() {
        return this.appendInstruction(new SimpleInstruction(106));
    }

    public CompactCodeAttributeComposer dmul() {
        return this.appendInstruction(new SimpleInstruction(107));
    }

    public CompactCodeAttributeComposer idiv() {
        return this.appendInstruction(new SimpleInstruction(108));
    }

    public CompactCodeAttributeComposer ldiv() {
        return this.appendInstruction(new SimpleInstruction(109));
    }

    public CompactCodeAttributeComposer fdiv() {
        return this.appendInstruction(new SimpleInstruction(110));
    }

    public CompactCodeAttributeComposer ddiv() {
        return this.appendInstruction(new SimpleInstruction(111));
    }

    public CompactCodeAttributeComposer irem() {
        return this.appendInstruction(new SimpleInstruction(112));
    }

    public CompactCodeAttributeComposer lrem() {
        return this.appendInstruction(new SimpleInstruction(113));
    }

    public CompactCodeAttributeComposer frem() {
        return this.appendInstruction(new SimpleInstruction(114));
    }

    public CompactCodeAttributeComposer drem() {
        return this.appendInstruction(new SimpleInstruction(115));
    }

    public CompactCodeAttributeComposer ineg() {
        return this.appendInstruction(new SimpleInstruction(116));
    }

    public CompactCodeAttributeComposer lneg() {
        return this.appendInstruction(new SimpleInstruction(117));
    }

    public CompactCodeAttributeComposer fneg() {
        return this.appendInstruction(new SimpleInstruction(118));
    }

    public CompactCodeAttributeComposer dneg() {
        return this.appendInstruction(new SimpleInstruction(119));
    }

    public CompactCodeAttributeComposer ishl() {
        return this.appendInstruction(new SimpleInstruction(120));
    }

    public CompactCodeAttributeComposer lshl() {
        return this.appendInstruction(new SimpleInstruction(121));
    }

    public CompactCodeAttributeComposer ishr() {
        return this.appendInstruction(new SimpleInstruction(122));
    }

    public CompactCodeAttributeComposer lshr() {
        return this.appendInstruction(new SimpleInstruction(123));
    }

    public CompactCodeAttributeComposer iushr() {
        return this.appendInstruction(new SimpleInstruction(124));
    }

    public CompactCodeAttributeComposer lushr() {
        return this.appendInstruction(new SimpleInstruction(125));
    }

    public CompactCodeAttributeComposer iand() {
        return this.appendInstruction(new SimpleInstruction(126));
    }

    public CompactCodeAttributeComposer land() {
        return this.appendInstruction(new SimpleInstruction(127));
    }

    public CompactCodeAttributeComposer ior() {
        return this.appendInstruction(new SimpleInstruction(-128));
    }

    public CompactCodeAttributeComposer lor() {
        return this.appendInstruction(new SimpleInstruction(-127));
    }

    public CompactCodeAttributeComposer ixor() {
        return this.appendInstruction(new SimpleInstruction(-126));
    }

    public CompactCodeAttributeComposer lxor() {
        return this.appendInstruction(new SimpleInstruction(-125));
    }

    public CompactCodeAttributeComposer iinc(int variableIndex, int constant) {
        return this.appendInstruction(new VariableInstruction(-124, variableIndex, constant));
    }

    public CompactCodeAttributeComposer i2l() {
        return this.appendInstruction(new SimpleInstruction(-123));
    }

    public CompactCodeAttributeComposer i2f() {
        return this.appendInstruction(new SimpleInstruction(-122));
    }

    public CompactCodeAttributeComposer i2d() {
        return this.appendInstruction(new SimpleInstruction(-121));
    }

    public CompactCodeAttributeComposer l2i() {
        return this.appendInstruction(new SimpleInstruction(-120));
    }

    public CompactCodeAttributeComposer l2f() {
        return this.appendInstruction(new SimpleInstruction(-119));
    }

    public CompactCodeAttributeComposer l2d() {
        return this.appendInstruction(new SimpleInstruction(-118));
    }

    public CompactCodeAttributeComposer f2i() {
        return this.appendInstruction(new SimpleInstruction(-117));
    }

    public CompactCodeAttributeComposer f2l() {
        return this.appendInstruction(new SimpleInstruction(-116));
    }

    public CompactCodeAttributeComposer f2d() {
        return this.appendInstruction(new SimpleInstruction(-115));
    }

    public CompactCodeAttributeComposer d2i() {
        return this.appendInstruction(new SimpleInstruction(-114));
    }

    public CompactCodeAttributeComposer d2l() {
        return this.appendInstruction(new SimpleInstruction(-113));
    }

    public CompactCodeAttributeComposer d2f() {
        return this.appendInstruction(new SimpleInstruction(-112));
    }

    public CompactCodeAttributeComposer i2b() {
        return this.appendInstruction(new SimpleInstruction(-111));
    }

    public CompactCodeAttributeComposer i2c() {
        return this.appendInstruction(new SimpleInstruction(-110));
    }

    public CompactCodeAttributeComposer i2s() {
        return this.appendInstruction(new SimpleInstruction(-109));
    }

    public CompactCodeAttributeComposer lcmp() {
        return this.appendInstruction(new SimpleInstruction(-108));
    }

    public CompactCodeAttributeComposer fcmpl() {
        return this.appendInstruction(new SimpleInstruction(-107));
    }

    public CompactCodeAttributeComposer fcmpg() {
        return this.appendInstruction(new SimpleInstruction(-106));
    }

    public CompactCodeAttributeComposer dcmpl() {
        return this.appendInstruction(new SimpleInstruction(-105));
    }

    public CompactCodeAttributeComposer dcmpg() {
        return this.appendInstruction(new SimpleInstruction(-104));
    }

    public CompactCodeAttributeComposer ifeq(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-103, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifne(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-102, branchLabel.offset));
    }

    public CompactCodeAttributeComposer iflt(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-101, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifge(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-100, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifgt(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-99, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifle(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-98, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmpeq(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-97, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmpne(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-96, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmplt(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-95, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmpge(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-94, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmpgt(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-93, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ificmple(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-92, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifacmpeq(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-91, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifacmpne(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-90, branchLabel.offset));
    }

    public CompactCodeAttributeComposer goto_(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-89, branchLabel.offset));
    }

    public CompactCodeAttributeComposer jsr(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-88, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ret(int variableIndex) {
        return this.appendInstruction(new VariableInstruction(-87, variableIndex));
    }

    public CompactCodeAttributeComposer tableswitch(Label defaultLabel, int lowCase, int highCase, Label[] jumpLabels) {
        return this.appendInstruction(new TableSwitchInstruction(-86, defaultLabel.offset, lowCase, highCase, this.offsets(jumpLabels)));
    }

    public CompactCodeAttributeComposer lookupswitch(Label defaultLabel, int[] cases, Label[] jumpLabels) {
        return this.appendInstruction(new LookUpSwitchInstruction(-85, defaultLabel.offset, cases, this.offsets(jumpLabels)));
    }

    public CompactCodeAttributeComposer ireturn() {
        return this.appendInstruction(new SimpleInstruction(-84));
    }

    public CompactCodeAttributeComposer lreturn() {
        return this.appendInstruction(new SimpleInstruction(-83));
    }

    public CompactCodeAttributeComposer freturn() {
        return this.appendInstruction(new SimpleInstruction(-82));
    }

    public CompactCodeAttributeComposer dreturn() {
        return this.appendInstruction(new SimpleInstruction(-81));
    }

    public CompactCodeAttributeComposer areturn() {
        return this.appendInstruction(new SimpleInstruction(-80));
    }

    public CompactCodeAttributeComposer return_() {
        return this.appendInstruction(new SimpleInstruction(-79));
    }

    public CompactCodeAttributeComposer getstatic(Clazz clazz, Field field) {
        return this.getstatic(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public CompactCodeAttributeComposer getstatic(String className, String name, String descriptor) {
        return this.getstatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer getstatic(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.getstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public CompactCodeAttributeComposer getstatic(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-78, constantIndex));
    }

    public CompactCodeAttributeComposer putstatic(Clazz referencedClass, Field referencedField) {
        return this.putstatic(referencedClass.getName(), referencedField.getName(referencedClass), referencedField.getDescriptor(referencedClass), referencedClass, referencedField);
    }

    public CompactCodeAttributeComposer putstatic(String className, String name, String descriptor) {
        return this.putstatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer putstatic(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.putstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public CompactCodeAttributeComposer putstatic(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-77, constantIndex));
    }

    public CompactCodeAttributeComposer getfield(Clazz clazz, Field field) {
        return this.getfield(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public CompactCodeAttributeComposer getfield(String className, String name, String descriptor) {
        return this.getfield(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer getfield(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.getfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public CompactCodeAttributeComposer getfield(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-76, constantIndex));
    }

    public CompactCodeAttributeComposer putfield(Clazz clazz, Field field) {
        return this.putfield(clazz.getName(), field.getName(clazz), field.getDescriptor(clazz), clazz, field);
    }

    public CompactCodeAttributeComposer putfield(String className, String name, String descriptor) {
        return this.putfield(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer putfield(String className, String name, String descriptor, Clazz referencedClass, Field referencedField) {
        return this.putfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedField));
    }

    public CompactCodeAttributeComposer putfield(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-75, constantIndex));
    }

    public CompactCodeAttributeComposer invokevirtual(Clazz clazz, Method method) {
        return this.invokevirtual(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public CompactCodeAttributeComposer invokevirtual(String className, String name, String descriptor) {
        return this.invokevirtual(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokevirtual(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public CompactCodeAttributeComposer invokevirtual(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-74, constantIndex));
    }

    public CompactCodeAttributeComposer invokespecial(Clazz clazz, Method method) {
        return this.invokespecial(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public CompactCodeAttributeComposer invokespecial(String className, String name, String descriptor) {
        return this.invokespecial(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokespecial(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokespecial(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public CompactCodeAttributeComposer invokespecial(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-73, constantIndex));
    }

    public CompactCodeAttributeComposer invokestatic(Clazz clazz, Method method) {
        return this.invokestatic(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public CompactCodeAttributeComposer invokestatic(String className, String name, String descriptor) {
        return this.invokestatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokestatic(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokestatic(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public CompactCodeAttributeComposer invokestatic_interface(Clazz clazz, Method method) {
        return this.invokestatic_interface(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public CompactCodeAttributeComposer invokestatic_interface(String className, String name, String descriptor) {
        return this.invokestatic_interface(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokestatic_interface(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        return this.invokestatic(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod));
    }

    public CompactCodeAttributeComposer invokestatic(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-72, constantIndex));
    }

    public CompactCodeAttributeComposer invokeinterface(Clazz clazz, Method method) {
        return this.invokeinterface(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz), clazz, method);
    }

    public CompactCodeAttributeComposer invokeinterface(String className, String name, String descriptor) {
        return this.invokeinterface(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokeinterface(String className, String name, String descriptor, Clazz referencedClass, Method referencedMethod) {
        int invokeinterfaceConstant = ClassUtil.internalMethodParameterSize(descriptor, false) << 8;
        return this.invokeinterface(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMethod), invokeinterfaceConstant);
    }

    public CompactCodeAttributeComposer invokeinterface(int constantIndex, int constant) {
        return this.appendInstruction(new ConstantInstruction(-71, constantIndex, constant));
    }

    public CompactCodeAttributeComposer invokedynamic(int bootStrapMethodIndex, String name, String descriptor, Clazz[] referencedClasses) {
        return this.invokedynamic(this.constantPoolEditor.addInvokeDynamicConstant(bootStrapMethodIndex, name, descriptor, referencedClasses));
    }

    public CompactCodeAttributeComposer invokedynamic(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-70, constantIndex));
    }

    public CompactCodeAttributeComposer new_(Clazz clazz) {
        return this.new_(clazz.getName(), clazz);
    }

    public CompactCodeAttributeComposer new_(String className) {
        return this.new_(className, null);
    }

    public CompactCodeAttributeComposer new_(String className, Clazz referencedClass) {
        return this.new_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer new_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-69, constantIndex));
    }

    public CompactCodeAttributeComposer newarray(int constant) {
        return this.appendInstruction(new SimpleInstruction(-68, constant));
    }

    public CompactCodeAttributeComposer anewarray(String className, Clazz referencedClass) {
        return this.anewarray(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer anewarray(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-67, constantIndex));
    }

    public CompactCodeAttributeComposer arraylength() {
        return this.appendInstruction(new SimpleInstruction(-66));
    }

    public CompactCodeAttributeComposer athrow() {
        return this.appendInstruction(new SimpleInstruction(-65));
    }

    public CompactCodeAttributeComposer checkcast(String className) {
        return this.checkcast(className, null);
    }

    public CompactCodeAttributeComposer checkcast(String className, Clazz referencedClass) {
        return this.checkcast(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer checkcast(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-64, constantIndex));
    }

    public CompactCodeAttributeComposer instanceof_(String className, Clazz referencedClass) {
        return this.instanceof_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer instanceof_(int constantIndex) {
        return this.appendInstruction(new ConstantInstruction(-63, constantIndex));
    }

    public CompactCodeAttributeComposer monitorenter() {
        return this.appendInstruction(new SimpleInstruction(-62));
    }

    public CompactCodeAttributeComposer monitorexit() {
        return this.appendInstruction(new SimpleInstruction(-61));
    }

    public CompactCodeAttributeComposer wide() {
        return this.appendInstruction(new SimpleInstruction(-60));
    }

    public CompactCodeAttributeComposer multianewarray(String className, Clazz referencedClass, int dimensions) {
        return this.multianewarray(this.constantPoolEditor.addClassConstant(className, referencedClass), dimensions);
    }

    public CompactCodeAttributeComposer multianewarray(int constantIndex, int dimensions) {
        return this.appendInstruction(new ConstantInstruction(-59, constantIndex, dimensions));
    }

    public CompactCodeAttributeComposer ifnull(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-58, branchLabel.offset));
    }

    public CompactCodeAttributeComposer ifnonnull(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-57, branchLabel.offset));
    }

    public CompactCodeAttributeComposer goto_w(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-56, branchLabel.offset));
    }

    public CompactCodeAttributeComposer jsr_w(Label branchLabel) {
        return this.appendInstruction(new BranchInstruction(-55, branchLabel.offset));
    }

    public CompactCodeAttributeComposer pushPrimitive(Object primitive, char internalType) {
        switch (internalType) {
            case 'Z': {
                return (Boolean)primitive != false ? this.iconst_1() : this.iconst_0();
            }
            case 'B': {
                return this.bipush(((Byte)primitive).byteValue());
            }
            case 'C': {
                return this.ldc(((Character)primitive).charValue());
            }
            case 'S': {
                return this.sipush(((Short)primitive).shortValue());
            }
            case 'I': {
                return this.ldc((Integer)primitive);
            }
            case 'J': {
                return this.ldc2_w((Long)primitive);
            }
            case 'F': {
                return this.ldc(((Float)primitive).floatValue());
            }
            case 'D': {
                return this.ldc2_w((Double)primitive);
            }
        }
        throw new IllegalArgumentException(primitive.toString());
    }

    public CompactCodeAttributeComposer pushInt(int value) {
        switch (value) {
            case -1: {
                return this.iconst_m1();
            }
            case 0: {
                return this.iconst_0();
            }
            case 1: {
                return this.iconst_1();
            }
            case 2: {
                return this.iconst_2();
            }
            case 3: {
                return this.iconst_3();
            }
            case 4: {
                return this.iconst_4();
            }
            case 5: {
                return this.iconst_5();
            }
        }
        return value == (byte)value ? this.bipush(value) : (value == (short)value ? this.sipush(value) : this.ldc(value));
    }

    public CompactCodeAttributeComposer pushFloat(float value) {
        return value == 0.0f ? this.fconst_0() : (value == 1.0f ? this.fconst_1() : (value == 2.0f ? this.fconst_2() : this.ldc(value)));
    }

    public CompactCodeAttributeComposer pushLong(long value) {
        return value == 0L ? this.lconst_0() : (value == 1L ? this.lconst_1() : this.ldc2_w(value));
    }

    public CompactCodeAttributeComposer pushDouble(double value) {
        return value == 0.0 ? this.dconst_0() : (value == 1.0 ? this.dconst_1() : this.ldc2_w(value));
    }

    public CompactCodeAttributeComposer pushNewArray(String elementTypeOrClassName, int size) {
        this.pushInt(size);
        return ClassUtil.isInternalPrimitiveType(elementTypeOrClassName) ? this.newarray(InstructionUtil.arrayTypeFromInternalType(elementTypeOrClassName.charAt(0))) : this.anewarray(elementTypeOrClassName, null);
    }

    public CompactCodeAttributeComposer load(int variableIndex, String internalType) {
        return this.load(variableIndex, internalType.charAt(0));
    }

    public CompactCodeAttributeComposer load(int variableIndex, char internalType) {
        switch (internalType) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iload(variableIndex);
            }
            case 'J': {
                return this.lload(variableIndex);
            }
            case 'F': {
                return this.fload(variableIndex);
            }
            case 'D': {
                return this.dload(variableIndex);
            }
        }
        return this.aload(variableIndex);
    }

    public CompactCodeAttributeComposer store(int variableIndex, String internalType) {
        return this.store(variableIndex, internalType.charAt(0));
    }

    public CompactCodeAttributeComposer store(int variableIndex, char internalType) {
        switch (internalType) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.istore(variableIndex);
            }
            case 'J': {
                return this.lstore(variableIndex);
            }
            case 'F': {
                return this.fstore(variableIndex);
            }
            case 'D': {
                return this.dstore(variableIndex);
            }
        }
        return this.astore(variableIndex);
    }

    public CompactCodeAttributeComposer storeToArray(String elementType) {
        switch (elementType.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.bastore();
            }
            case 'C': {
                return this.castore();
            }
            case 'S': {
                return this.sastore();
            }
            case 'I': {
                return this.iastore();
            }
            case 'J': {
                return this.lastore();
            }
            case 'F': {
                return this.fastore();
            }
            case 'D': {
                return this.dastore();
            }
        }
        return this.aastore();
    }

    public CompactCodeAttributeComposer return_(String internalType) {
        switch (internalType.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.ireturn();
            }
            case 'J': {
                return this.lreturn();
            }
            case 'F': {
                return this.freturn();
            }
            case 'D': {
                return this.dreturn();
            }
            case 'V': {
                return this.return_();
            }
        }
        return this.areturn();
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintIntegerInstructions();
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintIntegerHexInstructions();
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintLongInstructions();
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintStringInstructions();
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintObjectInstructions();
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions(String message) {
        return this.appendPrintInstructions(message).appendPrintStackTraceInstructions();
    }

    public CompactCodeAttributeComposer appendPrintInstructions(String message) {
        return this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").ldc(message).invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions() {
        return this.dup().getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").swap().invokevirtual("java/io/PrintStream", "println", "(I)V");
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions() {
        return this.dup().getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").swap().invokestatic("java/lang/Integer", "toHexString", "(I)Ljava/lang/String;").invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions() {
        return this.dup2().getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").dup_x2().pop().invokevirtual("java/io/PrintStream", "println", "(J)V");
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions() {
        return this.dup().getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").swap().invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions() {
        return this.dup().getstatic("java/lang/System", "err", "Ljava/io/PrintStream;").swap().invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/Object;)V");
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions() {
        return this.dup().invokevirtual("java/lang/Throwable", "printStackTrace", "()V");
    }

    public void addCodeAttribute(ProgramClass programClass, ProgramMethod programMethod) {
        this.codeAttributeComposer.addCodeAttribute(programClass, programMethod, this.constantPoolEditor);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private int[] offsets(Label[] labels) {
        int[] offsets = new int[labels.length];
        for (int index = 0; index < offsets.length; ++index) {
            offsets[index] = labels[index].offset;
        }
        return offsets;
    }

    public static void main(String[] args2) {
        ProgramClass programClass = new ProgramClass(0x340000, 1, new Constant[10], 1, 0, 0);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        programClass.u2thisClass = constantPoolEditor.addClassConstant("com/example/Test", (Clazz)programClass);
        programClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        ProgramMethod programMethod = new ProgramMethod(1, constantPoolEditor.addUtf8Constant("test"), constantPoolEditor.addUtf8Constant("()I"), null);
        ClassEditor classEditor = new ClassEditor(programClass);
        classEditor.addMethod(programMethod);
        CompactCodeAttributeComposer composer = new CompactCodeAttributeComposer(programClass);
        Label TRY_START = composer.createLabel();
        Label TRY_END = composer.createLabel();
        Label ELSE = composer.createLabel();
        composer.beginCodeFragment(50).label(TRY_START).iconst_1().iconst_2().ificmplt(ELSE).iconst_1().ireturn().label(ELSE).iconst_2().ireturn().label(TRY_END).catch_(TRY_START, TRY_END, "java/lang/Exception", null).iconst_m1().ireturn().endCodeFragment();
        composer.addCodeAttribute(programClass, programMethod);
        programClass.accept(new ClassPrinter());
    }

    public class Label {
        private final int offset;

        private Label(int offset) {
            this.offset = offset;
        }
    }
}

