/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllLineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberRangeFinder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.pass.Pass;

public class LineNumberLinearizer
implements Pass,
ClassVisitor,
MemberVisitor,
AttributeVisitor,
LineNumberInfoVisitor {
    private static final Logger logger = LogManager.getLogger(LineNumberLinearizer.class);
    public static final int SHIFT_ROUNDING = 1000;
    private static final int SHIFT_ROUNDING_LIMIT = 50000;
    private Stack enclosingLineNumbers = new Stack();
    private LineNumberInfo previousLineNumberInfo;
    private int highestUsedLineNumber;
    private int currentLineNumberShift;

    @Override
    public void execute(AppView appView) {
        appView.programClassPool.classesAccept(this);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        LineNumberRangeFinder lineNumberRangeFinder = new LineNumberRangeFinder();
        programClass.methodsAccept(new AllAttributeVisitor(true, new AllLineNumberInfoVisitor(lineNumberRangeFinder)));
        if (lineNumberRangeFinder.hasSource()) {
            this.highestUsedLineNumber = lineNumberRangeFinder.getHighestLineNumber();
            programClass.methodsAccept(this);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        logger.debug("LineNumberLinearizer [{}.{}{}]:", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        this.enclosingLineNumbers.clear();
        this.previousLineNumberInfo = null;
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        String source = lineNumberInfo.getSource();
        String debugMessage = String.format("    [%s] line %s%s", lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber, source == null ? "" : " [" + source + "]");
        if (source != null) {
            ExtendedLineNumberInfo extendedLineNumberInfo = (ExtendedLineNumberInfo)lineNumberInfo;
            int lineNumber = extendedLineNumberInfo.u2lineNumber;
            if (this.previousLineNumberInfo == null || this.previousLineNumberInfo.getSource() != source) {
                if (lineNumber != -1) {
                    this.enclosingLineNumbers.push(this.previousLineNumberInfo != null ? new MyLineNumberBlock(this.currentLineNumberShift, this.previousLineNumberInfo.u2lineNumber, this.previousLineNumberInfo.getSource()) : new MyLineNumberBlock(0, 0, null));
                    int separatorIndex1 = source.indexOf(58);
                    int separatorIndex2 = source.indexOf(58, separatorIndex1 + 1);
                    int startLineNumber = Integer.parseInt(source.substring(separatorIndex1 + 1, separatorIndex2));
                    int endLineNumber = Integer.parseInt(source.substring(separatorIndex2 + 1));
                    this.currentLineNumberShift = this.highestUsedLineNumber > 50000 ? this.highestUsedLineNumber - startLineNumber + 1 : (startLineNumber > this.highestUsedLineNumber ? 0 : (this.highestUsedLineNumber - startLineNumber + 1000) / 1000 * 1000);
                    this.highestUsedLineNumber = endLineNumber + this.currentLineNumberShift;
                    debugMessage = debugMessage + String.format(" (enter with shift %s)", this.currentLineNumberShift);
                    lineNumberInfo.u2lineNumber += this.currentLineNumberShift;
                } else if (this.enclosingLineNumbers.isEmpty()) {
                    debugMessage = debugMessage + String.format("Problem linearizing line numbers for optimized code %s.%s)", clazz.getName(), method.getName(clazz));
                    logger.debug(debugMessage);
                    debugMessage = "";
                } else {
                    MyLineNumberBlock lineNumberBlock = (MyLineNumberBlock)this.enclosingLineNumbers.pop();
                    extendedLineNumberInfo.u2lineNumber = lineNumberBlock.enclosingLineNumber;
                    extendedLineNumberInfo.source = lineNumberBlock.enclosingSource;
                    this.currentLineNumberShift = lineNumberBlock.lineNumberShift;
                    debugMessage = debugMessage + String.format(" (exit to shift %s)", this.currentLineNumberShift);
                }
            } else {
                debugMessage = debugMessage + String.format(" (apply shift %s)", this.currentLineNumberShift);
                lineNumberInfo.u2lineNumber += this.currentLineNumberShift;
            }
        }
        this.previousLineNumberInfo = lineNumberInfo;
        debugMessage = debugMessage + String.format(" -> line %s", lineNumberInfo.u2lineNumber);
        logger.debug(debugMessage);
    }

    private static class MyLineNumberBlock {
        public final int lineNumberShift;
        public final int enclosingLineNumber;
        public final String enclosingSource;

        public MyLineNumberBlock(int lineNumberShift, int enclosingLineNumber, String enclosingSource) {
            this.lineNumberShift = lineNumberShift;
            this.enclosingLineNumber = enclosingLineNumber;
            this.enclosingSource = enclosingSource;
        }
    }
}

