/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.util;

import com.eed3si9n.jarjar.util.ClassPathEntry;
import com.eed3si9n.jarjar.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathIterator
implements Iterator<ClassPathEntry> {
    private static final FileFilter CLASS_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || ClassPathIterator.isClass(file.getName());
        }
    };
    private static final FileFilter JAR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return ClassPathIterator.hasExtension(file.getName(), ".jar");
        }
    };
    private final Iterator<File> files;
    private Iterator<ClassPathEntry> entries = Collections.emptyList().iterator();
    private ClassPathEntry next;
    private List<ZipFile> zips = new ArrayList<ZipFile>();

    public ClassPathIterator(String string) throws IOException {
        this(new File(System.getProperty("user.dir")), string, null);
    }

    public ClassPathIterator(File file, String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = System.getProperty("path.separator");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            boolean bl = false;
            if (string3.endsWith("/*")) {
                if ((string3 = string3.substring(0, string3.length() - 1)).indexOf(42) >= 0) {
                    throw new IllegalArgumentException("Multiple wildcards are not allowed: " + string3);
                }
                bl = true;
            } else if (string3.indexOf(42) >= 0) {
                throw new IllegalArgumentException("Incorrect wildcard usage: " + string3);
            }
            File file2 = new File(string3);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string3);
            }
            if (!file2.exists()) {
                throw new IllegalArgumentException("File " + file2 + " does not exist");
            }
            if (bl) {
                if (!file2.isDirectory()) {
                    throw new IllegalArgumentException("File " + file2 + " + is not a directory");
                }
                arrayList.addAll(ClassPathIterator.findFiles(file2, JAR_FILTER, false, new ArrayList<File>()));
                continue;
            }
            arrayList.add(file2);
        }
        this.files = arrayList.iterator();
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public void close() throws IOException {
        this.next = null;
        for (ZipFile zipFile : this.zips) {
            zipFile.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassPathEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClassPathEntry classPathEntry = this.next;
        try {
            this.advance();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        return classPathEntry;
    }

    private void advance() throws IOException {
        if (!this.entries.hasNext()) {
            ZipFile zipFile;
            if (!this.files.hasNext()) {
                this.next = null;
                return;
            }
            File file = this.files.next();
            if (ClassPathIterator.hasExtension(file.getName(), ".jar")) {
                zipFile = new JarFile(file);
                this.zips.add(zipFile);
                this.entries = new ZipIterator(zipFile);
            } else if (ClassPathIterator.hasExtension(file.getName(), ".zip")) {
                zipFile = new ZipFile(file);
                this.zips.add(zipFile);
                this.entries = new ZipIterator(zipFile);
            } else if (file.isDirectory()) {
                this.entries = new FileIterator(file);
            } else {
                throw new IllegalArgumentException("Do not know how to handle " + file);
            }
        }
        boolean bl = false;
        while (!bl && this.entries.hasNext()) {
            this.next = this.entries.next();
            bl = ClassPathIterator.isClass(this.next.getName());
        }
        if (!bl) {
            this.advance();
        }
    }

    private static List<File> findFiles(File file, FileFilter fileFilter, boolean bl, List<File> list2) {
        for (File file2 : file.listFiles(fileFilter)) {
            if (bl && file2.isDirectory()) {
                ClassPathIterator.findFiles(file2, fileFilter, bl, list2);
                continue;
            }
            list2.add(file2);
        }
        return list2;
    }

    private static boolean isClass(String string) {
        return ClassPathIterator.hasExtension(string, ".class");
    }

    private static boolean hasExtension(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        String string3 = string.substring(string.length() - string2.length());
        return string3.equals(string2) || string3.equals(string2.toUpperCase());
    }

    private static class FileIterator
    implements Iterator<ClassPathEntry> {
        private final File dir;
        private final Iterator<File> entries;

        FileIterator(File file) {
            this.dir = file;
            this.entries = ClassPathIterator.findFiles(file, CLASS_FILTER, true, new ArrayList()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPathEntry next() {
            final File file = this.entries.next();
            return new ClassPathEntry(){

                @Override
                public String getSource() throws IOException {
                    return dir.getCanonicalPath();
                }

                @Override
                public String getName() {
                    return file.getName();
                }

                @Override
                public InputStream openStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(file));
                }
            };
        }
    }

    private static class ZipIterator
    implements Iterator<ClassPathEntry> {
        private final ZipFile zip;
        private final Enumeration<? extends ZipEntry> entries;

        ZipIterator(ZipFile zipFile) {
            this.zip = zipFile;
            this.entries = zipFile.entries();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClassPathEntry next() {
            final ZipEntry zipEntry = this.entries.nextElement();
            return new ClassPathEntry(){

                @Override
                public String getSource() {
                    return zip.getName();
                }

                @Override
                public String getName() {
                    return zipEntry.getName();
                }

                @Override
                public InputStream openStream() throws IOException {
                    return zip.getInputStream(zipEntry);
                }
            };
        }
    }
}

