/*
 * Decompiled with CFR 0.152.
 */
package mill.main.client.lock;

import java.util.concurrent.locks.ReentrantLock;
import mill.main.client.lock.Lock;
import mill.main.client.lock.Locked;
import mill.main.client.lock.MemoryLocked;
import mill.main.client.lock.MemoryTryLocked;

class MemoryLock
extends Lock {
    private final ReentrantLock innerLock = new ReentrantLock();

    MemoryLock() {
    }

    @Override
    public boolean probe() {
        return !this.innerLock.isLocked();
    }

    @Override
    public Locked lock() {
        this.innerLock.lock();
        return new MemoryLocked(this.innerLock);
    }

    @Override
    public MemoryTryLocked tryLock() {
        if (this.innerLock.tryLock()) {
            return new MemoryTryLocked(this.innerLock);
        }
        return new MemoryTryLocked(null);
    }

    @Override
    public void close() throws Exception {
        this.innerLock.unlock();
    }
}

