/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Aexion's Quadray Sets from FractalForums
 * @reference http://www.fractalforums.com/the-3d-mandelbulb/quadray-sets/msg31458/#msg31458

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_aexion.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 AexionIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 temp = z;
	REAL t;
	if (aux->i == 0)
	{
		t = fractal->aexion.cadd;
		REAL4 cadd = (REAL4){t, t, t, t};
		temp.x = z.x + z.y + z.z;
		temp.y = -z.x - z.y + z.z;
		temp.z = -z.x + z.y - z.z;
		temp.w = z.x - z.y - z.z;
		z = fabs(temp) + cadd;
		aux->const_c = z;
	}
	t = 2.0f * z.w * z.z;
	temp.x = z.x * z.x - z.y * z.y;
	temp.y = t - temp.x;
	temp.x += t;
	t = 2.0f * z.x * z.y;
	temp.z = z.z * z.z - z.w * z.w;
	temp.w = t - temp.z;
	temp.z += t;
	z = temp + aux->const_c;

	if (fractal->analyticDE.enabled)
	{
		REAL de1 = 1.1f * aux->r;
		de1 = de1 + (length(z) / aux->r - de1) * fractal->analyticDE.scale1;
		aux->DE = de1 * 2.0f * aux->DE + fractal->analyticDE.offset1;
	}
	return z;
}