/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * MsltoeToroidalV2
 * @reference http://www.fractalforums.com/theory/toroidal-coordinates/msg9428/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_msltoe_toroidal_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MsltoeToroidalV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1) // pre-scale
	{
		z *= fractal->transformCommon.scale3D111;
		aux->DE *= length(z) / aux->r;
	}

	// Toroidal bulb
	REAL r1 = fractal->transformCommon.minR05; // default 0.5f
	REAL theta = atan2(z.y, z.x);
	REAL x1 = r1 * native_cos(theta);
	REAL y1 = r1 * native_sin(theta);
	REAL rr = (z.x - x1) * (z.x - x1) + (z.y - y1) * (z.y - y1);
	REAL r = native_sqrt(rr + z.z * z.z);
	REAL temp = r;

	REAL phi = 0.0f;
	if (!fractal->transformCommon.functionEnabledYFalse)
	{
		phi = asin(z.z / temp);
	}
	else
	{
		if (fractal->transformCommon.functionEnabledXFalse
				&& aux->i >= fractal->transformCommon.startIterationsB
				&& aux->i < fractal->transformCommon.stopIterationsB)
		{
			if (!fractal->transformCommon.functionEnabledBFalse)
				temp = rr;
			else
				temp = native_sqrt(rr);
		}
		phi = atan2(z.z, temp);
	}

	r = r + (aux->r - r) * fractal->transformCommon.offsetR0;

	REAL rp = pow(r, fractal->bulb.power - 1.0f) / fractal->transformCommon.scaleB1;
	aux->DE = rp * aux->DE * (fractal->bulb.power + fractal->analyticDE.offset0) + 1.0f;
	rp *= r;

	phi *= fractal->transformCommon.pwr8;
	theta *= fractal->bulb.power;

	// convert back to cartesian coordinates
	if (!fractal->transformCommon.functionEnabledSwFalse)
	{
		temp = r1 + rp * native_cos(phi);
		z.x = temp * native_cos(theta);
		z.y = temp * native_sin(theta);
	}
	else
	{
		temp = rp * native_cos(phi);
		z.x = (sign(z.x) * x1 + temp) * native_cos(theta);
		z.y = (sign(z.y) * y1 + temp) * native_sin(theta);
	}
	z.z = rp * native_sin(phi);
	z.z *= fractal->transformCommon.scaleNeg1;

	aux->DE *= fractal->analyticDE.scale1;

	if (fractal->transformCommon.functionEnabledAxFalse) // spherical offset
	{
		// REAL lengthTempZ = -length(z);
		//  if (lengthTempZ > -1e-21f) lengthTempZ = -1e-21f;   //  z is neg.)
		z *= 1.0f - fractal->transformCommon.offset / length(z);
		// aux->DE = aux->DE * fabs(1.0f + fractal->transformCommon.offset / -length(z));
		z *= fractal->transformCommon.scale;
		aux->DE = aux->DE * fabs(fractal->transformCommon.scale);
	}
	// then add Cpixel constant vector

	if (fractal->transformCommon.functionEnabledOFalse)
	{
		aux->DE0 = length(z);
		if (aux->DE0 > 1.0f)
			aux->DE0 = 0.5f * log(aux->DE0) * aux->DE0 / aux->DE;
		else
			aux->DE0 = 0.0f;
		if (!fractal->transformCommon.functionEnabledCFalse)
			aux->dist = aux->DE0;
		else
			aux->dist = min(aux->dist, aux->DE0);
	}
	return z;
}