/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.functions;

import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;

public final class Functions {
    private static final IntFunction incOneIntFunction = new IncIntFunction(1);
    private static final LongFunction incOneLongFunction = new IncLongFunction(1L);
    private static final IntFunction decOneIntFunction = new IncIntFunction(-1);
    private static final LongFunction decOneLongFunction = new IncLongFunction(-1L);
    private static final DoubleFunction incOneDoubleFunction = new IncDoubleFunction();
    private static final DoubleFunction identityDoubleFunction = new IdentityDoubleFunction();
    private static final BooleanFunction inverseBooleanFunction = new BooleanFunction(){

        @Override
        public boolean call(boolean current) {
            return !current;
        }
    };
    private static final BooleanFunction identityBooleanFunction = new BooleanFunction(){

        @Override
        public boolean call(boolean current) {
            return current;
        }

        public String toString() {
            return "IdentityBooleanFunction";
        }
    };
    private static final IntFunction identityIntFunction = new IntFunction(){

        @Override
        public int call(int current) {
            return current;
        }

        public String toString() {
            return "IdentityIntFunction";
        }
    };
    private static final LongFunction identityLongFunction = new LongFunction(){

        @Override
        public long call(long current) {
            return current;
        }

        public String toString() {
            return "IdentityLongFunction";
        }
    };
    private static final Function identityFunction = new Function(){

        public Object call(Object value) {
            return value;
        }

        public String toString() {
            return "IdentityFunction";
        }
    };

    public static Function identityFunction() {
        return identityFunction;
    }

    public static DoubleFunction identityDoubleFunction() {
        return identityDoubleFunction;
    }

    public static DoubleFunction incDoubleFunction() {
        return incOneDoubleFunction;
    }

    public static IntFunction identityIntFunction() {
        return identityIntFunction;
    }

    public static LongFunction identityLongFunction() {
        return identityLongFunction;
    }

    public static IntFunction incIntFunction() {
        return incOneIntFunction;
    }

    public static IntFunction decIntFunction() {
        return decOneIntFunction;
    }

    public static LongFunction incLongFunction() {
        return incOneLongFunction;
    }

    public static LongFunction decLongFunction() {
        return decOneLongFunction;
    }

    public static IntFunction incIntFunction(int amount) {
        switch (amount) {
            case 0: {
                return identityIntFunction;
            }
            case 1: {
                return incOneIntFunction;
            }
            case -1: {
                return decOneIntFunction;
            }
        }
        return new IncIntFunction(amount);
    }

    public static BooleanFunction inverseBooleanFunction() {
        return inverseBooleanFunction;
    }

    public static BooleanFunction identityBooleanFunction() {
        return identityBooleanFunction;
    }

    public static LongFunction incLongFunction(long amount) {
        if (amount == 0L) {
            return identityLongFunction;
        }
        if (amount == 1L) {
            return incOneLongFunction;
        }
        if (amount == -1L) {
            return decOneLongFunction;
        }
        return new IncLongFunction(amount);
    }

    private Functions() {
    }

    private static class IdentityDoubleFunction
    extends DoubleFunction {
        private IdentityDoubleFunction() {
        }

        @Override
        public double call(double current) {
            return current;
        }

        public String toString() {
            return "IdentityDoubleFunction{}";
        }
    }

    private static class IncDoubleFunction
    extends DoubleFunction {
        private IncDoubleFunction() {
        }

        @Override
        public double call(double current) {
            return current + 1.0;
        }

        public String toString() {
            return "IncDoubleFunction{value=1}";
        }
    }

    private static class IncLongFunction
    extends LongFunction {
        private final long value;

        public IncLongFunction(long value) {
            this.value = value;
        }

        @Override
        public long call(long current) {
            return current + this.value;
        }

        public String toString() {
            return "IncLongFunction{value=" + this.value + '}';
        }
    }

    private static class IncIntFunction
    extends IntFunction {
        private final int value;

        public IncIntFunction(int value) {
            this.value = value;
        }

        @Override
        public int call(int current) {
            return current + this.value;
        }

        public String toString() {
            return "IncIntFunction{value=" + this.value + '}';
        }
    }
}

