// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/rpc/context/attribute_context.proto

package attribute_context

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This message defines the standard attribute vocabulary for Google APIs.
//
// An attribute is a piece of metadata that describes an activity on a network
// service. For example, the size of an HTTP request, or the status code of
// an HTTP response.
//
// Each attribute has a type and a name, which is logically defined as
// a proto message field in `AttributeContext`. The field type becomes the
// attribute type, and the field path becomes the attribute name. For example,
// the attribute `source.ip` maps to field `AttributeContext.source.ip`.
//
// This message definition is guaranteed not to have any wire breaking change.
// So you can use it directly for passing attributes across different systems.
//
// NOTE: Different system may generate different subset of attributes. Please
// verify the system specification before relying on an attribute generated
// a system.
type AttributeContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The origin of a network activity. In a multi hop network activity,
	// the origin represents the sender of the first hop. For the first hop,
	// the `source` and the `origin` must have the same content.
	Origin *AttributeContext_Peer `protobuf:"bytes,7,opt,name=origin,proto3" json:"origin,omitempty"`
	// The source of a network activity, such as starting a TCP connection.
	// In a multi hop network activity, the source represents the sender of the
	// last hop.
	Source *AttributeContext_Peer `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop.
	Destination *AttributeContext_Peer `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Represents a network request, such as an HTTP request.
	Request *AttributeContext_Request `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Represents a network response, such as an HTTP response.
	Response *AttributeContext_Response `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
	// Represents a target resource that is involved with a network activity.
	// If multiple resources are involved with an activity, this must be the
	// primary one.
	Resource *AttributeContext_Resource `protobuf:"bytes,5,opt,name=resource,proto3" json:"resource,omitempty"`
	// Represents an API operation that is involved to a network activity.
	Api *AttributeContext_Api `protobuf:"bytes,6,opt,name=api,proto3" json:"api,omitempty"`
	// Supports extensions for advanced use cases, such as logs and metrics.
	Extensions []*anypb.Any `protobuf:"bytes,8,rep,name=extensions,proto3" json:"extensions,omitempty"`
}

func (x *AttributeContext) Reset() {
	*x = AttributeContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext) ProtoMessage() {}

func (x *AttributeContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext.ProtoReflect.Descriptor instead.
func (*AttributeContext) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0}
}

func (x *AttributeContext) GetOrigin() *AttributeContext_Peer {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *AttributeContext) GetSource() *AttributeContext_Peer {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *AttributeContext) GetDestination() *AttributeContext_Peer {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *AttributeContext) GetRequest() *AttributeContext_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *AttributeContext) GetResponse() *AttributeContext_Response {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *AttributeContext) GetResource() *AttributeContext_Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *AttributeContext) GetApi() *AttributeContext_Api {
	if x != nil {
		return x.Api
	}
	return nil
}

func (x *AttributeContext) GetExtensions() []*anypb.Any {
	if x != nil {
		return x.Extensions
	}
	return nil
}

// This message defines attributes for a node that handles a network request.
// The node can be either a service or an application that sends, forwards,
// or receives the request. Service peers should fill in
// `principal` and `labels` as appropriate.
type AttributeContext_Peer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP address of the peer.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// The network port of the peer.
	Port int64 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The labels associated with the peer.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The identity of this peer. Similar to `Request.auth.principal`, but
	// relative to the peer instead of the request. For example, the
	// identity associated with a load balancer that forwarded the request.
	Principal string `protobuf:"bytes,7,opt,name=principal,proto3" json:"principal,omitempty"`
	// The CLDR country/region code associated with the above IP address.
	// If the IP address is private, the `region_code` should reflect the
	// physical location where this peer is running.
	RegionCode string `protobuf:"bytes,8,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
}

func (x *AttributeContext_Peer) Reset() {
	*x = AttributeContext_Peer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Peer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Peer) ProtoMessage() {}

func (x *AttributeContext_Peer) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Peer.ProtoReflect.Descriptor instead.
func (*AttributeContext_Peer) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AttributeContext_Peer) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *AttributeContext_Peer) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *AttributeContext_Peer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AttributeContext_Peer) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *AttributeContext_Peer) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

// This message defines attributes associated with API operations, such as
// a network API request. The terminology is based on the conventions used
// by Google APIs, Istio, and OpenAPI.
type AttributeContext_Api struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API service name. It is a logical identifier for a networked API,
	// such as "pubsub.googleapis.com". The naming syntax depends on the
	// API management system being used for handling the request.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The API operation name. For gRPC requests, it is the fully qualified API
	// method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
	// requests, it is the `operationId`, such as "getPet".
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The API protocol used for sending the request, such as "http", "https",
	// "grpc", or "internal".
	Protocol string `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// The API version associated with the API operation above, such as "v1" or
	// "v1alpha1".
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *AttributeContext_Api) Reset() {
	*x = AttributeContext_Api{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Api) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Api) ProtoMessage() {}

func (x *AttributeContext_Api) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Api.ProtoReflect.Descriptor instead.
func (*AttributeContext_Api) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AttributeContext_Api) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *AttributeContext_Api) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *AttributeContext_Api) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *AttributeContext_Api) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// This message defines request authentication attributes. Terminology is
// based on the JSON Web Token (JWT) standard, but the terms also
// correlate to concepts in other standards.
type AttributeContext_Auth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The authenticated principal. Reflects the issuer (`iss`) and subject
	// (`sub`) claims within a JWT. The issuer and subject should be `/`
	// delimited, with `/` percent-encoded within the subject fragment. For
	// Google accounts, the principal format is:
	// "https://accounts.google.com/{id}"
	Principal string `protobuf:"bytes,1,opt,name=principal,proto3" json:"principal,omitempty"`
	// The intended audience(s) for this authentication information. Reflects
	// the audience (`aud`) claim within a JWT. The audience
	// value(s) depends on the `issuer`, but typically include one or more of
	// the following pieces of information:
	//
	//   - The services intended to receive the credential. For example,
	//     ["https://pubsub.googleapis.com/", "https://storage.googleapis.com/"].
	//   - A set of service-based scopes. For example,
	//     ["https://www.googleapis.com/auth/cloud-platform"].
	//   - The client id of an app, such as the Firebase project id for JWTs
	//     from Firebase Auth.
	//
	// Consult the documentation for the credential issuer to determine the
	// information provided.
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// The authorized presenter of the credential. Reflects the optional
	// Authorized Presenter (`azp`) claim within a JWT or the
	// OAuth client id. For example, a Google Cloud Platform client id looks
	// as follows: "123456789012.apps.googleusercontent.com".
	Presenter string `protobuf:"bytes,3,opt,name=presenter,proto3" json:"presenter,omitempty"`
	// Structured claims presented with the credential. JWTs include
	// `{key: value}` pairs for standard and private claims. The following
	// is a subset of the standard required and optional claims that would
	// typically be presented for a Google-based JWT:
	//
	//	{'iss': 'accounts.google.com',
	//	 'sub': '113289723416554971153',
	//	 'aud': ['123456789012', 'pubsub.googleapis.com'],
	//	 'azp': '123456789012.apps.googleusercontent.com',
	//	 'email': 'jsmith@example.com',
	//	 'iat': 1353601026,
	//	 'exp': 1353604926}
	//
	// SAML assertions are similarly specified, but with an identity provider
	// dependent structure.
	Claims *structpb.Struct `protobuf:"bytes,4,opt,name=claims,proto3" json:"claims,omitempty"`
	// A list of access level resource names that allow resources to be
	// accessed by authenticated requester. It is part of Secure GCP processing
	// for the incoming request. An access level string has the format:
	// "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
	//
	// Example:
	// "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
	AccessLevels []string `protobuf:"bytes,5,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
}

func (x *AttributeContext_Auth) Reset() {
	*x = AttributeContext_Auth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Auth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Auth) ProtoMessage() {}

func (x *AttributeContext_Auth) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Auth.ProtoReflect.Descriptor instead.
func (*AttributeContext_Auth) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 2}
}

func (x *AttributeContext_Auth) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *AttributeContext_Auth) GetAudiences() []string {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *AttributeContext_Auth) GetPresenter() string {
	if x != nil {
		return x.Presenter
	}
	return ""
}

func (x *AttributeContext_Auth) GetClaims() *structpb.Struct {
	if x != nil {
		return x.Claims
	}
	return nil
}

func (x *AttributeContext_Auth) GetAccessLevels() []string {
	if x != nil {
		return x.AccessLevels
	}
	return nil
}

// This message defines attributes for an HTTP request. If the actual
// request is not an HTTP request, the runtime system should try to map
// the actual request to an equivalent HTTP request.
type AttributeContext_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID for a request, which can be propagated to downstream
	// systems. The ID should have low probability of collision
	// within a single day for a specific service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The HTTP request method, such as `GET`, `POST`.
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	// The HTTP request headers. If multiple headers share the same key, they
	// must be merged according to the HTTP spec. All header keys must be
	// lowercased, because HTTP header keys are case-insensitive.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The HTTP URL path, excluding the query parameters.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// The HTTP request `Host` header value.
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The HTTP URL scheme, such as `http` and `https`.
	Scheme string `protobuf:"bytes,6,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// The HTTP URL query in the format of `name1=value1&name2=value2`, as it
	// appears in the first line of the HTTP request. No decoding is performed.
	Query string `protobuf:"bytes,7,opt,name=query,proto3" json:"query,omitempty"`
	// The timestamp when the `destination` service receives the last byte of
	// the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=time,proto3" json:"time,omitempty"`
	// The HTTP request size in bytes. If unknown, it must be -1.
	Size int64 `protobuf:"varint,10,opt,name=size,proto3" json:"size,omitempty"`
	// The network protocol used with the request, such as "http/1.1",
	// "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
	// https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
	// for details.
	Protocol string `protobuf:"bytes,11,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// A special parameter for request reason. It is used by security systems
	// to associate auditing information with a request.
	Reason string `protobuf:"bytes,12,opt,name=reason,proto3" json:"reason,omitempty"`
	// The request authentication. May be absent for unauthenticated requests.
	// Derived from the HTTP request `Authorization` header or equivalent.
	Auth *AttributeContext_Auth `protobuf:"bytes,13,opt,name=auth,proto3" json:"auth,omitempty"`
}

func (x *AttributeContext_Request) Reset() {
	*x = AttributeContext_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Request) ProtoMessage() {}

func (x *AttributeContext_Request) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Request.ProtoReflect.Descriptor instead.
func (*AttributeContext_Request) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 3}
}

func (x *AttributeContext_Request) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AttributeContext_Request) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *AttributeContext_Request) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *AttributeContext_Request) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AttributeContext_Request) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *AttributeContext_Request) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *AttributeContext_Request) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *AttributeContext_Request) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *AttributeContext_Request) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *AttributeContext_Request) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *AttributeContext_Request) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *AttributeContext_Request) GetAuth() *AttributeContext_Auth {
	if x != nil {
		return x.Auth
	}
	return nil
}

// This message defines attributes for a typical network response. It
// generally models semantics of an HTTP response.
type AttributeContext_Response struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP response status code, such as `200` and `404`.
	Code int64 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The HTTP response size in bytes. If unknown, it must be -1.
	Size int64 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	// The HTTP response headers. If multiple headers share the same key, they
	// must be merged according to HTTP spec. All header keys must be
	// lowercased, because HTTP header keys are case-insensitive.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The timestamp when the `destination` service sends the last byte of
	// the response.
	Time *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
	// The amount of time it takes the backend service to fully respond to a
	// request. Measured from when the destination service starts to send the
	// request to the backend until when the destination service receives the
	// complete response from the backend.
	BackendLatency *durationpb.Duration `protobuf:"bytes,5,opt,name=backend_latency,json=backendLatency,proto3" json:"backend_latency,omitempty"`
}

func (x *AttributeContext_Response) Reset() {
	*x = AttributeContext_Response{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Response) ProtoMessage() {}

func (x *AttributeContext_Response) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Response.ProtoReflect.Descriptor instead.
func (*AttributeContext_Response) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 4}
}

func (x *AttributeContext_Response) GetCode() int64 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *AttributeContext_Response) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *AttributeContext_Response) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *AttributeContext_Response) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *AttributeContext_Response) GetBackendLatency() *durationpb.Duration {
	if x != nil {
		return x.BackendLatency
	}
	return nil
}

// This message defines core attributes for a resource. A resource is an
// addressable (named) entity provided by the destination service. For
// example, a file stored on a network storage service.
type AttributeContext_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the service that this resource belongs to, such as
	// `pubsub.googleapis.com`. The service may be different from the DNS
	// hostname that actually serves the request.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The stable identifier (name) of a resource on the `service`. A resource
	// can be logically identified as "//{resource.service}/{resource.name}".
	// The differences between a resource name and a URI are:
	//
	//   - Resource name is a logical identifier, independent of network
	//     protocol and API version. For example,
	//     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
	//   - URI often includes protocol and version information, so it can
	//     be used directly by applications. For example,
	//     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
	//
	// See https://cloud.google.com/apis/design/resource_names for details.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the resource. The syntax is platform-specific because
	// different platforms define their resources differently.
	//
	// For Google APIs, the type format must be "{service}/{kind}", such as
	// "pubsub.googleapis.com/Topic".
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// The labels or tags on the resource, such as AWS resource tags and
	// Kubernetes resource labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The unique identifier of the resource. UID is unique in the time
	// and space for this resource within the scope of the service. It is
	// typically generated by the server on successful creation of a resource
	// and must not be changed. UID is used to uniquely identify resources
	// with resource name reuses. This should be a UUID4.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Annotations is an unstructured key-value map stored with a resource that
	// may be set by external tools to store and retrieve arbitrary metadata.
	// They are not queryable and should be preserved when modifying objects.
	//
	// More info:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mutable. The display name set by clients. Must be <= 63 characters.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The timestamp when the resource was created. This may
	// be either the time creation was initiated or when it was completed.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was last updated. Any
	// change to the resource made by users must refresh this value.
	// Changes to a resource made by the service should refresh this value.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The timestamp when the resource was deleted.
	// If the resource is not deleted, this must be empty.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. An opaque value that uniquely identifies a version or
	// generation of a resource. It can be used to confirm that the client
	// and server agree on the ordering of a resource being written.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Immutable. The location of the resource. The location encoding is
	// specific to the service provider, and new encoding may be introduced
	// as the service evolves.
	//
	// For Google Cloud products, the encoding is what is used by Google Cloud
	// APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
	// semantics of `location` is identical to the
	// `cloud.googleapis.com/location` label used by some Google Cloud APIs.
	Location string `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *AttributeContext_Resource) Reset() {
	*x = AttributeContext_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_rpc_context_attribute_context_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeContext_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Resource) ProtoMessage() {}

func (x *AttributeContext_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_rpc_context_attribute_context_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Resource.ProtoReflect.Descriptor instead.
func (*AttributeContext_Resource) Descriptor() ([]byte, []int) {
	return file_google_rpc_context_attribute_context_proto_rawDescGZIP(), []int{0, 5}
}

func (x *AttributeContext_Resource) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *AttributeContext_Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AttributeContext_Resource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AttributeContext_Resource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AttributeContext_Resource) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AttributeContext_Resource) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AttributeContext_Resource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AttributeContext_Resource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AttributeContext_Resource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AttributeContext_Resource) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *AttributeContext_Resource) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AttributeContext_Resource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

var File_google_rpc_context_attribute_context_proto protoreflect.FileDescriptor

var file_google_rpc_context_attribute_context_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x14, 0x0a, 0x10, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x52, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x3a, 0x0a, 0x03, 0x61, 0x70, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x2e, 0x41, 0x70, 0x69, 0x52, 0x03, 0x61, 0x70, 0x69, 0x12, 0x34, 0x0a, 0x0a,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xf3, 0x01, 0x0a, 0x04, 0x50, 0x65, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1c,
	0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x0b,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x73, 0x0a, 0x03, 0x41, 0x70, 0x69, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xb6, 0x01,
	0x0a, 0x04, 0x41, 0x75, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x1a, 0xcf, 0x03, 0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x53, 0x0a, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x3d, 0x0a,
	0x04, 0x61, 0x75, 0x74, 0x68, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x1a, 0x3a, 0x0a, 0x0c,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0xb8, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x54, 0x0a,
	0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x6c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x1a, 0x3a, 0x0a, 0x0c, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x98, 0x05, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x60, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x8b,
	0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x15, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x55, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x3b, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_rpc_context_attribute_context_proto_rawDescOnce sync.Once
	file_google_rpc_context_attribute_context_proto_rawDescData = file_google_rpc_context_attribute_context_proto_rawDesc
)

func file_google_rpc_context_attribute_context_proto_rawDescGZIP() []byte {
	file_google_rpc_context_attribute_context_proto_rawDescOnce.Do(func() {
		file_google_rpc_context_attribute_context_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_rpc_context_attribute_context_proto_rawDescData)
	})
	return file_google_rpc_context_attribute_context_proto_rawDescData
}

var file_google_rpc_context_attribute_context_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_rpc_context_attribute_context_proto_goTypes = []interface{}{
	(*AttributeContext)(nil),          // 0: google.rpc.context.AttributeContext
	(*AttributeContext_Peer)(nil),     // 1: google.rpc.context.AttributeContext.Peer
	(*AttributeContext_Api)(nil),      // 2: google.rpc.context.AttributeContext.Api
	(*AttributeContext_Auth)(nil),     // 3: google.rpc.context.AttributeContext.Auth
	(*AttributeContext_Request)(nil),  // 4: google.rpc.context.AttributeContext.Request
	(*AttributeContext_Response)(nil), // 5: google.rpc.context.AttributeContext.Response
	(*AttributeContext_Resource)(nil), // 6: google.rpc.context.AttributeContext.Resource
	nil,                               // 7: google.rpc.context.AttributeContext.Peer.LabelsEntry
	nil,                               // 8: google.rpc.context.AttributeContext.Request.HeadersEntry
	nil,                               // 9: google.rpc.context.AttributeContext.Response.HeadersEntry
	nil,                               // 10: google.rpc.context.AttributeContext.Resource.LabelsEntry
	nil,                               // 11: google.rpc.context.AttributeContext.Resource.AnnotationsEntry
	(*anypb.Any)(nil),                 // 12: google.protobuf.Any
	(*structpb.Struct)(nil),           // 13: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),     // 14: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),       // 15: google.protobuf.Duration
}
var file_google_rpc_context_attribute_context_proto_depIdxs = []int32{
	1,  // 0: google.rpc.context.AttributeContext.origin:type_name -> google.rpc.context.AttributeContext.Peer
	1,  // 1: google.rpc.context.AttributeContext.source:type_name -> google.rpc.context.AttributeContext.Peer
	1,  // 2: google.rpc.context.AttributeContext.destination:type_name -> google.rpc.context.AttributeContext.Peer
	4,  // 3: google.rpc.context.AttributeContext.request:type_name -> google.rpc.context.AttributeContext.Request
	5,  // 4: google.rpc.context.AttributeContext.response:type_name -> google.rpc.context.AttributeContext.Response
	6,  // 5: google.rpc.context.AttributeContext.resource:type_name -> google.rpc.context.AttributeContext.Resource
	2,  // 6: google.rpc.context.AttributeContext.api:type_name -> google.rpc.context.AttributeContext.Api
	12, // 7: google.rpc.context.AttributeContext.extensions:type_name -> google.protobuf.Any
	7,  // 8: google.rpc.context.AttributeContext.Peer.labels:type_name -> google.rpc.context.AttributeContext.Peer.LabelsEntry
	13, // 9: google.rpc.context.AttributeContext.Auth.claims:type_name -> google.protobuf.Struct
	8,  // 10: google.rpc.context.AttributeContext.Request.headers:type_name -> google.rpc.context.AttributeContext.Request.HeadersEntry
	14, // 11: google.rpc.context.AttributeContext.Request.time:type_name -> google.protobuf.Timestamp
	3,  // 12: google.rpc.context.AttributeContext.Request.auth:type_name -> google.rpc.context.AttributeContext.Auth
	9,  // 13: google.rpc.context.AttributeContext.Response.headers:type_name -> google.rpc.context.AttributeContext.Response.HeadersEntry
	14, // 14: google.rpc.context.AttributeContext.Response.time:type_name -> google.protobuf.Timestamp
	15, // 15: google.rpc.context.AttributeContext.Response.backend_latency:type_name -> google.protobuf.Duration
	10, // 16: google.rpc.context.AttributeContext.Resource.labels:type_name -> google.rpc.context.AttributeContext.Resource.LabelsEntry
	11, // 17: google.rpc.context.AttributeContext.Resource.annotations:type_name -> google.rpc.context.AttributeContext.Resource.AnnotationsEntry
	14, // 18: google.rpc.context.AttributeContext.Resource.create_time:type_name -> google.protobuf.Timestamp
	14, // 19: google.rpc.context.AttributeContext.Resource.update_time:type_name -> google.protobuf.Timestamp
	14, // 20: google.rpc.context.AttributeContext.Resource.delete_time:type_name -> google.protobuf.Timestamp
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_rpc_context_attribute_context_proto_init() }
func file_google_rpc_context_attribute_context_proto_init() {
	if File_google_rpc_context_attribute_context_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_rpc_context_attribute_context_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Peer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Api); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Auth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Response); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_rpc_context_attribute_context_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeContext_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_rpc_context_attribute_context_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_rpc_context_attribute_context_proto_goTypes,
		DependencyIndexes: file_google_rpc_context_attribute_context_proto_depIdxs,
		MessageInfos:      file_google_rpc_context_attribute_context_proto_msgTypes,
	}.Build()
	File_google_rpc_context_attribute_context_proto = out.File
	file_google_rpc_context_attribute_context_proto_rawDesc = nil
	file_google_rpc_context_attribute_context_proto_goTypes = nil
	file_google_rpc_context_attribute_context_proto_depIdxs = nil
}
