# -*- coding: utf-8 -*-
#
# Picard, the next-generation MusicBrainz tagger
#
# Copyright (C) 2007 Lukáš Lalinský
# Copyright (C) 2014, 2020, 2024 Laurent Monin
# Copyright (C) 2017 Sambhav Kothari
# Copyright (C) 2019, 2023 Philipp Wolfer
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.


from picard.i18n import N_


# List of alias locales
ALIAS_LOCALES = {
    'aa': N_('Afar'),
    'aa_DJ': N_('Afar (Djibouti)'),
    'aa_ER': N_('Afar (Eritrea)'),
    'aa_ER_SAAHO': N_('Afar (Eritrea) (Saho)'),
    'aa_ET': N_('Afar (Ethiopia)'),
    'ab': N_('Abkhazian'),
    'ab_GE': N_('Abkhazian (Georgia)'),
    'af': N_('Afrikaans'),
    'af_NA': N_('Afrikaans (Namibia)'),
    'af_ZA': N_('Afrikaans (South Africa)'),
    'agq': N_('Aghem'),
    'agq_CM': N_('Aghem (Cameroon)'),
    'ak': N_('Akan'),
    'ak_GH': N_('Akan (Ghana)'),
    'am': N_('Amharic'),
    'am_ET': N_('Amharic (Ethiopia)'),
    'an': N_('Aragonese'),
    'an_ES': N_('Aragonese (Spain)'),
    'ann': N_('Obolo'),
    'ann_NG': N_('Obolo (Nigeria)'),
    'apc_SY': N_('Syria'),
    'ar': N_('Arabic'),
    'ar_001': N_('Arabic (world)'),
    'ar_AE': N_('Arabic (United Arab Emirates)'),
    'ar_BH': N_('Arabic (Bahrain)'),
    'ar_DJ': N_('Arabic (Djibouti)'),
    'ar_DZ': N_('Arabic (Algeria)'),
    'ar_EG': N_('Arabic (Egypt)'),
    'ar_EH': N_('Arabic (Western Sahara)'),
    'ar_ER': N_('Arabic (Eritrea)'),
    'ar_IL': N_('Arabic (Israel)'),
    'ar_IQ': N_('Arabic (Iraq)'),
    'ar_JO': N_('Arabic (Jordan)'),
    'ar_KM': N_('Arabic (Comoros)'),
    'ar_KW': N_('Arabic (Kuwait)'),
    'ar_LB': N_('Arabic (Lebanon)'),
    'ar_LY': N_('Arabic (Libya)'),
    'ar_MA': N_('Arabic (Morocco)'),
    'ar_MR': N_('Arabic (Mauritania)'),
    'ar_OM': N_('Arabic (Oman)'),
    'ar_PS': N_('Arabic (Palestinian Territories)'),
    'ar_QA': N_('Arabic (Qatar)'),
    'ar_SA': N_('Arabic (Saudi Arabia)'),
    'ar_SD': N_('Arabic (Sudan)'),
    'ar_SO': N_('Arabic (Somalia)'),
    'ar_SS': N_('Arabic (South Sudan)'),
    'ar_SY': N_('Arabic (Syria)'),
    'ar_TD': N_('Arabic (Chad)'),
    'ar_TN': N_('Arabic (Tunisia)'),
    'ar_YE': N_('Arabic (Yemen)'),
    'arn': N_('Mapuche'),
    'arn_CL': N_('Mapuche (Chile)'),
    'as': N_('Assamese'),
    'as_IN': N_('Assamese (India)'),
    'asa': N_('Asu'),
    'asa_TZ': N_('Asu (Tanzania)'),
    'ast': N_('Asturian'),
    'ast_ES': N_('Asturian (Spain)'),
    'az': N_('Azerbaijani'),
    'az_Arab': N_('Azerbaijani (Arabic)'),
    'az_Arab_IQ': N_('Azerbaijani (Arabic) (Iraq)'),
    'az_Arab_IR': N_('Azerbaijani (Arabic) (Iran)'),
    'az_Arab_TR': N_('Azerbaijani (Arabic) (Türkiye)'),
    'az_Cyrl': N_('Azerbaijani (Cyrillic)'),
    'az_Cyrl_AZ': N_('Azerbaijani (Cyrillic) (Azerbaijan)'),
    'az_Latn': N_('Azerbaijani (Latin)'),
    'az_Latn_AZ': N_('Azerbaijani (Latin) (Azerbaijan)'),
    'ba': N_('Bashkir'),
    'ba_RU': N_('Bashkir (Russia)'),
    'bal': N_('Baluchi'),
    'bal_Arab': N_('Baluchi (Arabic)'),
    'bal_Arab_PK': N_('Baluchi (Arabic) (Pakistan)'),
    'bal_Latn': N_('Baluchi (Latin)'),
    'bal_Latn_PK': N_('Baluchi (Latin) (Pakistan)'),
    'bas': N_('Basaa'),
    'bas_CM': N_('Basaa (Cameroon)'),
    'be': N_('Belarusian'),
    'be_BY': N_('Belarusian (Belarus)'),
    'be_tarask': N_('Belarusian (Taraskievica orthography)'),
    'bem': N_('Bemba'),
    'bem_ZM': N_('Bemba (Zambia)'),
    'bez': N_('Bena'),
    'bez_TZ': N_('Bena (Tanzania)'),
    'bg': N_('Bulgarian'),
    'bg_BG': N_('Bulgarian (Bulgaria)'),
    'bgc': N_('Haryanvi'),
    'bgc_IN': N_('Haryanvi (India)'),
    'bgn': N_('Western Balochi'),
    'bgn_AE': N_('Western Balochi (United Arab Emirates)'),
    'bgn_AF': N_('Western Balochi (Afghanistan)'),
    'bgn_IR': N_('Western Balochi (Iran)'),
    'bgn_OM': N_('Western Balochi (Oman)'),
    'bgn_PK': N_('Western Balochi (Pakistan)'),
    'bho': N_('Bhojpuri'),
    'bho_IN': N_('Bhojpuri (India)'),
    'blt': N_('Tai Dam'),
    'blt_VN': N_('Tai Dam (Vietnam)'),
    'bm': N_('Bambara'),
    'bm_ML': N_('Bambara (Mali)'),
    'bm_Nkoo': N_('Bambara (N’Ko)'),
    'bm_Nkoo_ML': N_('Bambara (N’Ko) (Mali)'),
    'bn': N_('Bangla'),
    'bn_BD': N_('Bangla (Bangladesh)'),
    'bn_IN': N_('Bangla (India)'),
    'bo': N_('Tibetan'),
    'bo_CN': N_('Tibetan (China)'),
    'bo_IN': N_('Tibetan (India)'),
    'br': N_('Breton'),
    'br_FR': N_('Breton (France)'),
    'brx': N_('Bodo'),
    'brx_IN': N_('Bodo (India)'),
    'bs': N_('Bosnian'),
    'bs_Cyrl': N_('Bosnian (Cyrillic)'),
    'bs_Cyrl_BA': N_('Bosnian (Cyrillic) (Bosnia & Herzegovina)'),
    'bs_Latn': N_('Bosnian (Latin)'),
    'bs_Latn_BA': N_('Bosnian (Latin) (Bosnia & Herzegovina)'),
    'bss': N_('Akoose'),
    'bss_CM': N_('Akoose (Cameroon)'),
    'byn': N_('Blin'),
    'byn_ER': N_('Blin (Eritrea)'),
    'ca': N_('Catalan'),
    'ca_AD': N_('Catalan (Andorra)'),
    'ca_ES': N_('Catalan (Spain)'),
    'ca_ES_valencia': N_('Catalan (Spain Valencian)'),
    'ca_FR': N_('Catalan (France)'),
    'ca_IT': N_('Catalan (Italy)'),
    'cad': N_('Caddo'),
    'cad_US': N_('Caddo (United States)'),
    'cch': N_('Atsam'),
    'cch_NG': N_('Atsam (Nigeria)'),
    'ccp': N_('Chakma'),
    'ccp_BD': N_('Chakma (Bangladesh)'),
    'ccp_IN': N_('Chakma (India)'),
    'ce': N_('Chechen'),
    'ce_RU': N_('Chechen (Russia)'),
    'ceb': N_('Cebuano'),
    'ceb_PH': N_('Cebuano (Philippines)'),
    'cgg': N_('Chiga'),
    'cgg_UG': N_('Chiga (Uganda)'),
    'cho': N_('Choctaw'),
    'cho_US': N_('Choctaw (United States)'),
    'chr': N_('Cherokee'),
    'chr_US': N_('Cherokee (United States)'),
    'cic': N_('Chickasaw'),
    'cic_US': N_('Chickasaw (United States)'),
    'ckb': N_('Central Kurdish'),
    'ckb_IQ': N_('Central Kurdish (Iraq)'),
    'ckb_IR': N_('Central Kurdish (Iran)'),
    'co': N_('Corsican'),
    'co_FR': N_('Corsican (France)'),
    'cs': N_('Czech'),
    'cs_CZ': N_('Czech (Czechia)'),
    'cu': N_('Church Slavic'),
    'cu_RU': N_('Church Slavic (Russia)'),
    'cv': N_('Chuvash'),
    'cv_RU': N_('Chuvash (Russia)'),
    'cy': N_('Welsh'),
    'cy_GB': N_('Welsh (United Kingdom)'),
    'da': N_('Danish'),
    'da_DK': N_('Danish (Denmark)'),
    'da_GL': N_('Danish (Greenland)'),
    'dav': N_('Taita'),
    'dav_KE': N_('Taita (Kenya)'),
    'de': N_('German'),
    'de_AT': N_('German (Austria)'),
    'de_BE': N_('German (Belgium)'),
    'de_CH': N_('German (Switzerland)'),
    'de_DE': N_('German (Germany)'),
    'de_IT': N_('German (Italy)'),
    'de_LI': N_('German (Liechtenstein)'),
    'de_LU': N_('German (Luxembourg)'),
    'dje': N_('Zarma'),
    'dje_NE': N_('Zarma (Niger)'),
    'doi': N_('Dogri'),
    'doi_IN': N_('Dogri (India)'),
    'dsb': N_('Lower Sorbian'),
    'dsb_DE': N_('Lower Sorbian (Germany)'),
    'dua': N_('Duala'),
    'dua_CM': N_('Duala (Cameroon)'),
    'dv': N_('Divehi'),
    'dv_MV': N_('Divehi (Maldives)'),
    'dyo': N_('Jola-Fonyi'),
    'dyo_SN': N_('Jola-Fonyi (Senegal)'),
    'dz': N_('Dzongkha'),
    'dz_BT': N_('Dzongkha (Bhutan)'),
    'ebu': N_('Embu'),
    'ebu_KE': N_('Embu (Kenya)'),
    'ee': N_('Ewe'),
    'ee_GH': N_('Ewe (Ghana)'),
    'ee_TG': N_('Ewe (Togo)'),
    'el': N_('Greek'),
    'el_CY': N_('Greek (Cyprus)'),
    'el_GR': N_('Greek (Greece)'),
    'el_polyton': N_('Greek (Polytonic)'),
    'en': N_('English'),
    'en_001': N_('English (world)'),
    'en_150': N_('English (Europe)'),
    'en_AE': N_('English (United Arab Emirates)'),
    'en_AG': N_('English (Antigua & Barbuda)'),
    'en_AI': N_('English (Anguilla)'),
    'en_AS': N_('English (American Samoa)'),
    'en_AT': N_('English (Austria)'),
    'en_AU': N_('English (Australia)'),
    'en_BB': N_('English (Barbados)'),
    'en_BE': N_('English (Belgium)'),
    'en_BI': N_('English (Burundi)'),
    'en_BM': N_('English (Bermuda)'),
    'en_BS': N_('English (Bahamas)'),
    'en_BW': N_('English (Botswana)'),
    'en_BZ': N_('English (Belize)'),
    'en_CA': N_('English (Canada)'),
    'en_CC': N_('English (Cocos (Keeling) Islands)'),
    'en_CH': N_('English (Switzerland)'),
    'en_CK': N_('English (Cook Islands)'),
    'en_CM': N_('English (Cameroon)'),
    'en_CX': N_('English (Christmas Island)'),
    'en_CY': N_('English (Cyprus)'),
    'en_DE': N_('English (Germany)'),
    'en_DG': N_('English (Diego Garcia)'),
    'en_DK': N_('English (Denmark)'),
    'en_DM': N_('English (Dominica)'),
    'en_Dsrt': N_('English (Deseret)'),
    'en_Dsrt_US': N_('English (Deseret) (United States)'),
    'en_ER': N_('English (Eritrea)'),
    'en_FI': N_('English (Finland)'),
    'en_FJ': N_('English (Fiji)'),
    'en_FK': N_('English (Falkland Islands)'),
    'en_FM': N_('English (Micronesia)'),
    'en_GB': N_('English (United Kingdom)'),
    'en_GD': N_('English (Grenada)'),
    'en_GG': N_('English (Guernsey)'),
    'en_GH': N_('English (Ghana)'),
    'en_GI': N_('English (Gibraltar)'),
    'en_GM': N_('English (Gambia)'),
    'en_GU': N_('English (Guam)'),
    'en_GY': N_('English (Guyana)'),
    'en_HK': N_('English (Hong Kong)'),
    'en_IE': N_('English (Ireland)'),
    'en_IL': N_('English (Israel)'),
    'en_IM': N_('English (Isle of Man)'),
    'en_IN': N_('English (India)'),
    'en_IO': N_('English (British Indian Ocean Territory)'),
    'en_JE': N_('English (Jersey)'),
    'en_JM': N_('English (Jamaica)'),
    'en_KE': N_('English (Kenya)'),
    'en_KI': N_('English (Kiribati)'),
    'en_KN': N_('English (St. Kitts & Nevis)'),
    'en_KY': N_('English (Cayman Islands)'),
    'en_LC': N_('English (St. Lucia)'),
    'en_LR': N_('English (Liberia)'),
    'en_LS': N_('English (Lesotho)'),
    'en_MG': N_('English (Madagascar)'),
    'en_MH': N_('English (Marshall Islands)'),
    'en_MO': N_('English (Macao)'),
    'en_MP': N_('English (Northern Mariana Islands)'),
    'en_MS': N_('English (Montserrat)'),
    'en_MT': N_('English (Malta)'),
    'en_MU': N_('English (Mauritius)'),
    'en_MV': N_('English (Maldives)'),
    'en_MW': N_('English (Malawi)'),
    'en_MY': N_('English (Malaysia)'),
    'en_NA': N_('English (Namibia)'),
    'en_NF': N_('English (Norfolk Island)'),
    'en_NG': N_('English (Nigeria)'),
    'en_NL': N_('English (Netherlands)'),
    'en_NR': N_('English (Nauru)'),
    'en_NU': N_('English (Niue)'),
    'en_NZ': N_('English (New Zealand)'),
    'en_PG': N_('English (Papua New Guinea)'),
    'en_PH': N_('English (Philippines)'),
    'en_PK': N_('English (Pakistan)'),
    'en_PN': N_('English (Pitcairn Islands)'),
    'en_PR': N_('English (Puerto Rico)'),
    'en_PW': N_('English (Palau)'),
    'en_RW': N_('English (Rwanda)'),
    'en_SB': N_('English (Solomon Islands)'),
    'en_SC': N_('English (Seychelles)'),
    'en_SD': N_('English (Sudan)'),
    'en_SE': N_('English (Sweden)'),
    'en_SG': N_('English (Singapore)'),
    'en_SH': N_('English (St. Helena)'),
    'en_SI': N_('English (Slovenia)'),
    'en_SL': N_('English (Sierra Leone)'),
    'en_SS': N_('English (South Sudan)'),
    'en_SX': N_('English (Sint Maarten)'),
    'en_SZ': N_('English (Eswatini)'),
    'en_Shaw': N_('English (Shavian)'),
    'en_Shaw_GB': N_('English (Shavian) (United Kingdom)'),
    'en_TC': N_('English (Turks & Caicos Islands)'),
    'en_TK': N_('English (Tokelau)'),
    'en_TO': N_('English (Tonga)'),
    'en_TT': N_('English (Trinidad & Tobago)'),
    'en_TV': N_('English (Tuvalu)'),
    'en_TZ': N_('English (Tanzania)'),
    'en_UG': N_('English (Uganda)'),
    'en_UM': N_('English (U.S. Outlying Islands)'),
    'en_US': N_('English (United States)'),
    'en_VC': N_('English (St. Vincent & Grenadines)'),
    'en_VG': N_('English (British Virgin Islands)'),
    'en_VI': N_('English (U.S. Virgin Islands)'),
    'en_VU': N_('English (Vanuatu)'),
    'en_WS': N_('English (Samoa)'),
    'en_ZA': N_('English (South Africa)'),
    'en_ZM': N_('English (Zambia)'),
    'en_ZW': N_('English (Zimbabwe)'),
    'eo': N_('Esperanto'),
    'eo_001': N_('Esperanto (world)'),
    'es': N_('Spanish'),
    'es_419': N_('Spanish (Latin America)'),
    'es_AR': N_('Spanish (Argentina)'),
    'es_BO': N_('Spanish (Bolivia)'),
    'es_BR': N_('Spanish (Brazil)'),
    'es_BZ': N_('Spanish (Belize)'),
    'es_CL': N_('Spanish (Chile)'),
    'es_CO': N_('Spanish (Colombia)'),
    'es_CR': N_('Spanish (Costa Rica)'),
    'es_CU': N_('Spanish (Cuba)'),
    'es_DO': N_('Spanish (Dominican Republic)'),
    'es_EA': N_('Spanish (Ceuta & Melilla)'),
    'es_EC': N_('Spanish (Ecuador)'),
    'es_ES': N_('Spanish (Spain)'),
    'es_GQ': N_('Spanish (Equatorial Guinea)'),
    'es_GT': N_('Spanish (Guatemala)'),
    'es_HN': N_('Spanish (Honduras)'),
    'es_IC': N_('Spanish (Canary Islands)'),
    'es_MX': N_('Spanish (Mexico)'),
    'es_NI': N_('Spanish (Nicaragua)'),
    'es_PA': N_('Spanish (Panama)'),
    'es_PE': N_('Spanish (Peru)'),
    'es_PH': N_('Spanish (Philippines)'),
    'es_PR': N_('Spanish (Puerto Rico)'),
    'es_PY': N_('Spanish (Paraguay)'),
    'es_SV': N_('Spanish (El Salvador)'),
    'es_US': N_('Spanish (United States)'),
    'es_UY': N_('Spanish (Uruguay)'),
    'es_VE': N_('Spanish (Venezuela)'),
    'et': N_('Estonian'),
    'et_EE': N_('Estonian (Estonia)'),
    'eu': N_('Basque'),
    'eu_ES': N_('Basque (Spain)'),
    'ewo': N_('Ewondo'),
    'ewo_CM': N_('Ewondo (Cameroon)'),
    'fa': N_('Persian'),
    'fa_AF': N_('Persian (Afghanistan)'),
    'fa_IR': N_('Persian (Iran)'),
    'ff': N_('Fula'),
    'ff_Adlm': N_('Fula (Adlam)'),
    'ff_Adlm_BF': N_('Fula (Adlam) (Burkina Faso)'),
    'ff_Adlm_CM': N_('Fula (Adlam) (Cameroon)'),
    'ff_Adlm_GH': N_('Fula (Adlam) (Ghana)'),
    'ff_Adlm_GM': N_('Fula (Adlam) (Gambia)'),
    'ff_Adlm_GN': N_('Fula (Adlam) (Guinea)'),
    'ff_Adlm_GW': N_('Fula (Adlam) (Guinea-Bissau)'),
    'ff_Adlm_LR': N_('Fula (Adlam) (Liberia)'),
    'ff_Adlm_MR': N_('Fula (Adlam) (Mauritania)'),
    'ff_Adlm_NE': N_('Fula (Adlam) (Niger)'),
    'ff_Adlm_NG': N_('Fula (Adlam) (Nigeria)'),
    'ff_Adlm_SL': N_('Fula (Adlam) (Sierra Leone)'),
    'ff_Adlm_SN': N_('Fula (Adlam) (Senegal)'),
    'ff_Latn': N_('Fula (Latin)'),
    'ff_Latn_BF': N_('Fula (Latin) (Burkina Faso)'),
    'ff_Latn_CM': N_('Fula (Latin) (Cameroon)'),
    'ff_Latn_GH': N_('Fula (Latin) (Ghana)'),
    'ff_Latn_GM': N_('Fula (Latin) (Gambia)'),
    'ff_Latn_GN': N_('Fula (Latin) (Guinea)'),
    'ff_Latn_GW': N_('Fula (Latin) (Guinea-Bissau)'),
    'ff_Latn_LR': N_('Fula (Latin) (Liberia)'),
    'ff_Latn_MR': N_('Fula (Latin) (Mauritania)'),
    'ff_Latn_NE': N_('Fula (Latin) (Niger)'),
    'ff_Latn_NG': N_('Fula (Latin) (Nigeria)'),
    'ff_Latn_SL': N_('Fula (Latin) (Sierra Leone)'),
    'ff_Latn_SN': N_('Fula (Latin) (Senegal)'),
    'fi': N_('Finnish'),
    'fi_FI': N_('Finnish (Finland)'),
    'fil': N_('Filipino'),
    'fil_PH': N_('Filipino (Philippines)'),
    'fo': N_('Faroese'),
    'fo_DK': N_('Faroese (Denmark)'),
    'fo_FO': N_('Faroese (Faroe Islands)'),
    'fr': N_('French'),
    'fr_BE': N_('French (Belgium)'),
    'fr_BF': N_('French (Burkina Faso)'),
    'fr_BI': N_('French (Burundi)'),
    'fr_BJ': N_('French (Benin)'),
    'fr_BL': N_('French (St. Barthélemy)'),
    'fr_CA': N_('French (Canada)'),
    'fr_CD': N_('French (Congo - Kinshasa)'),
    'fr_CF': N_('French (Central African Republic)'),
    'fr_CG': N_('French (Congo - Brazzaville)'),
    'fr_CH': N_('French (Switzerland)'),
    'fr_CI': N_('French (Côte d’Ivoire)'),
    'fr_CM': N_('French (Cameroon)'),
    'fr_DJ': N_('French (Djibouti)'),
    'fr_DZ': N_('French (Algeria)'),
    'fr_FR': N_('French (France)'),
    'fr_GA': N_('French (Gabon)'),
    'fr_GF': N_('French (French Guiana)'),
    'fr_GN': N_('French (Guinea)'),
    'fr_GP': N_('French (Guadeloupe)'),
    'fr_GQ': N_('French (Equatorial Guinea)'),
    'fr_HT': N_('French (Haiti)'),
    'fr_KM': N_('French (Comoros)'),
    'fr_LU': N_('French (Luxembourg)'),
    'fr_MA': N_('French (Morocco)'),
    'fr_MC': N_('French (Monaco)'),
    'fr_MF': N_('French (St. Martin)'),
    'fr_MG': N_('French (Madagascar)'),
    'fr_ML': N_('French (Mali)'),
    'fr_MQ': N_('French (Martinique)'),
    'fr_MR': N_('French (Mauritania)'),
    'fr_MU': N_('French (Mauritius)'),
    'fr_NC': N_('French (New Caledonia)'),
    'fr_NE': N_('French (Niger)'),
    'fr_PF': N_('French (French Polynesia)'),
    'fr_PM': N_('French (St. Pierre & Miquelon)'),
    'fr_RE': N_('French (Réunion)'),
    'fr_RW': N_('French (Rwanda)'),
    'fr_SC': N_('French (Seychelles)'),
    'fr_SN': N_('French (Senegal)'),
    'fr_SY': N_('French (Syria)'),
    'fr_TD': N_('French (Chad)'),
    'fr_TG': N_('French (Togo)'),
    'fr_TN': N_('French (Tunisia)'),
    'fr_VU': N_('French (Vanuatu)'),
    'fr_WF': N_('French (Wallis & Futuna)'),
    'fr_YT': N_('French (Mayotte)'),
    'frr': N_('Northern Frisian'),
    'frr_DE': N_('Northern Frisian (Germany)'),
    'fur': N_('Friulian'),
    'fur_IT': N_('Friulian (Italy)'),
    'fy': N_('Western Frisian'),
    'fy_NL': N_('Western Frisian (Netherlands)'),
    'ga': N_('Irish'),
    'ga_GB': N_('Irish (United Kingdom)'),
    'ga_IE': N_('Irish (Ireland)'),
    'gaa': N_('Ga'),
    'gaa_GH': N_('Ga (Ghana)'),
    'gd': N_('Scottish Gaelic'),
    'gd_GB': N_('Scottish Gaelic (United Kingdom)'),
    'gez': N_('Geez'),
    'gez_ER': N_('Geez (Eritrea)'),
    'gez_ET': N_('Geez (Ethiopia)'),
    'gl': N_('Galician'),
    'gl_ES': N_('Galician (Spain)'),
    'gn': N_('Guarani'),
    'gn_PY': N_('Guarani (Paraguay)'),
    'gsw': N_('Swiss German'),
    'gsw_CH': N_('Swiss German (Switzerland)'),
    'gsw_FR': N_('Swiss German (France)'),
    'gsw_LI': N_('Swiss German (Liechtenstein)'),
    'gu': N_('Gujarati'),
    'gu_IN': N_('Gujarati (India)'),
    'guz': N_('Gusii'),
    'guz_KE': N_('Gusii (Kenya)'),
    'gv': N_('Manx'),
    'gv_IM': N_('Manx (Isle of Man)'),
    'ha': N_('Hausa'),
    'ha_Arab': N_('Hausa (Arabic)'),
    'ha_Arab_NG': N_('Hausa (Arabic) (Nigeria)'),
    'ha_Arab_SD': N_('Hausa (Arabic) (Sudan)'),
    'ha_GH': N_('Hausa (Ghana)'),
    'ha_Latn': N_('Hausa (Latin)'),
    'ha_Latn_GH': N_('Hausa (Latin) (Ghana)'),
    'ha_Latn_NE': N_('Hausa (Latin) (Niger)'),
    'ha_Latn_NG': N_('Hausa (Latin) (Nigeria)'),
    'ha_NE': N_('Hausa (Niger)'),
    'ha_NG': N_('Hausa (Nigeria)'),
    'ha_SD': N_('Hausa (Sudan)'),
    'haw': N_('Hawaiian'),
    'haw_US': N_('Hawaiian (United States)'),
    'he': N_('Hebrew'),
    'he_IL': N_('Hebrew (Israel)'),
    'hi': N_('Hindi'),
    'hi_IN': N_('Hindi (India)'),
    'hi_Latn': N_('Hindi (Latin)'),
    'hi_Latn_IN': N_('Hindi (Latin) (India)'),
    'hnj': N_('Hmong Njua'),
    'hnj_Hmnp': N_('Hmong Njua (Nyiakeng Puachue Hmong)'),
    'hnj_Hmnp_US': N_('Hmong Njua (Nyiakeng Puachue Hmong) (United States)'),
    'hr': N_('Croatian'),
    'hr_BA': N_('Croatian (Bosnia & Herzegovina)'),
    'hr_HR': N_('Croatian (Croatia)'),
    'hsb': N_('Upper Sorbian'),
    'hsb_DE': N_('Upper Sorbian (Germany)'),
    'hu': N_('Hungarian'),
    'hu_HU': N_('Hungarian (Hungary)'),
    'hy': N_('Armenian'),
    'hy_AM': N_('Armenian (Armenia)'),
    'hy_AM_REVISED': N_('Armenian (Armenia) (Revised Orthography)'),
    'ia': N_('Interlingua'),
    'ia_001': N_('Interlingua (world)'),
    'id': N_('Indonesian'),
    'id_ID': N_('Indonesian (Indonesia)'),
    'ig': N_('Igbo'),
    'ig_NG': N_('Igbo (Nigeria)'),
    'ii': N_('Sichuan Yi'),
    'ii_CN': N_('Sichuan Yi (China)'),
    'io': N_('Ido'),
    'io_001': N_('Ido (world)'),
    'is': N_('Icelandic'),
    'is_IS': N_('Icelandic (Iceland)'),
    'it': N_('Italian'),
    'it_CH': N_('Italian (Switzerland)'),
    'it_IT': N_('Italian (Italy)'),
    'it_SM': N_('Italian (San Marino)'),
    'it_VA': N_('Italian (Vatican City)'),
    'iu': N_('Inuktitut'),
    'iu_CA': N_('Inuktitut (Canada)'),
    'iu_Latn': N_('Inuktitut (Latin)'),
    'iu_Latn_CA': N_('Inuktitut (Latin) (Canada)'),
    'ja': N_('Japanese'),
    'ja_JP': N_('Japanese (Japan)'),
    'jbo': N_('Lojban'),
    'jbo_001': N_('Lojban (world)'),
    'jgo': N_('Ngomba'),
    'jgo_CM': N_('Ngomba (Cameroon)'),
    'jmc': N_('Machame'),
    'jmc_TZ': N_('Machame (Tanzania)'),
    'jv': N_('Javanese'),
    'jv_ID': N_('Javanese (Indonesia)'),
    'ka': N_('Georgian'),
    'ka_GE': N_('Georgian (Georgia)'),
    'kab': N_('Kabyle'),
    'kab_DZ': N_('Kabyle (Algeria)'),
    'kaj': N_('Jju'),
    'kaj_NG': N_('Jju (Nigeria)'),
    'kam': N_('Kamba'),
    'kam_KE': N_('Kamba (Kenya)'),
    'kcg': N_('Tyap'),
    'kcg_NG': N_('Tyap (Nigeria)'),
    'kde': N_('Makonde'),
    'kde_TZ': N_('Makonde (Tanzania)'),
    'kea': N_('Kabuverdianu'),
    'kea_CV': N_('Kabuverdianu (Cape Verde)'),
    'ken': N_('Kenyang'),
    'ken_CM': N_('Kenyang (Cameroon)'),
    'kfo': N_('Koro'),
    'kfo_CI': N_('Koro (Côte d’Ivoire)'),
    'kgp': N_('Kaingang'),
    'kgp_BR': N_('Kaingang (Brazil)'),
    'khq': N_('Koyra Chiini'),
    'khq_ML': N_('Koyra Chiini (Mali)'),
    'ki': N_('Kikuyu'),
    'ki_KE': N_('Kikuyu (Kenya)'),
    'kk': N_('Kazakh'),
    'kk_Cyrl': N_('Kazakh (Cyrillic)'),
    'kk_Cyrl_KZ': N_('Kazakh (Cyrillic) (Kazakhstan)'),
    'kk_KZ': N_('Kazakh (Kazakhstan)'),
    'kkj': N_('Kako'),
    'kkj_CM': N_('Kako (Cameroon)'),
    'kl': N_('Kalaallisut'),
    'kl_GL': N_('Kalaallisut (Greenland)'),
    'kln': N_('Kalenjin'),
    'kln_KE': N_('Kalenjin (Kenya)'),
    'km': N_('Khmer'),
    'km_KH': N_('Khmer (Cambodia)'),
    'kn': N_('Kannada'),
    'kn_IN': N_('Kannada (India)'),
    'ko': N_('Korean'),
    'ko_KP': N_('Korean (North Korea)'),
    'ko_KR': N_('Korean (South Korea)'),
    'kok': N_('Konkani'),
    'kok_IN': N_('Konkani (India)'),
    'kpe': N_('Kpelle'),
    'kpe_GN': N_('Kpelle (Guinea)'),
    'kpe_LR': N_('Kpelle (Liberia)'),
    'ks': N_('Kashmiri'),
    'ks_Arab': N_('Kashmiri (Arabic)'),
    'ks_Arab_IN': N_('Kashmiri (Arabic) (India)'),
    'ks_Deva': N_('Kashmiri (Devanagari)'),
    'ks_Deva_IN': N_('Kashmiri (Devanagari) (India)'),
    'ksb': N_('Shambala'),
    'ksb_TZ': N_('Shambala (Tanzania)'),
    'ksf': N_('Bafia'),
    'ksf_CM': N_('Bafia (Cameroon)'),
    'ksh': N_('Colognian'),
    'ksh_DE': N_('Colognian (Germany)'),
    'ku': N_('Kurdish'),
    'ku_TR': N_('Kurdish (Türkiye)'),
    'kw': N_('Cornish'),
    'kw_GB': N_('Cornish (United Kingdom)'),
    'ky': N_('Kyrgyz'),
    'ky_KG': N_('Kyrgyz (Kyrgyzstan)'),
    'la': N_('Latin'),
    'la_VA': N_('Latin (Vatican City)'),
    'lag': N_('Langi'),
    'lag_TZ': N_('Langi (Tanzania)'),
    'lb': N_('Luxembourgish'),
    'lb_LU': N_('Luxembourgish (Luxembourg)'),
    'lg': N_('Ganda'),
    'lg_UG': N_('Ganda (Uganda)'),
    'lij': N_('Ligurian'),
    'lij_IT': N_('Ligurian (Italy)'),
    'lkt': N_('Lakota'),
    'lkt_US': N_('Lakota (United States)'),
    'lmo': N_('Lombard'),
    'lmo_IT': N_('Lombard (Italy)'),
    'ln': N_('Lingala'),
    'ln_AO': N_('Lingala (Angola)'),
    'ln_CD': N_('Lingala (Congo - Kinshasa)'),
    'ln_CF': N_('Lingala (Central African Republic)'),
    'ln_CG': N_('Lingala (Congo - Brazzaville)'),
    'lo': N_('Lao'),
    'lo_LA': N_('Lao (Laos)'),
    'lrc': N_('Northern Luri'),
    'lrc_IQ': N_('Northern Luri (Iraq)'),
    'lrc_IR': N_('Northern Luri (Iran)'),
    'lt': N_('Lithuanian'),
    'lt_LT': N_('Lithuanian (Lithuania)'),
    'lu': N_('Luba-Katanga'),
    'lu_CD': N_('Luba-Katanga (Congo - Kinshasa)'),
    'luo': N_('Luo'),
    'luo_KE': N_('Luo (Kenya)'),
    'luy': N_('Luyia'),
    'luy_KE': N_('Luyia (Kenya)'),
    'lv': N_('Latvian'),
    'lv_LV': N_('Latvian (Latvia)'),
    'mai': N_('Maithili'),
    'mai_IN': N_('Maithili (India)'),
    'mas': N_('Masai'),
    'mas_KE': N_('Masai (Kenya)'),
    'mas_TZ': N_('Masai (Tanzania)'),
    'mdf': N_('Moksha'),
    'mdf_RU': N_('Moksha (Russia)'),
    'mer': N_('Meru'),
    'mer_KE': N_('Meru (Kenya)'),
    'mfe': N_('Morisyen'),
    'mfe_MU': N_('Morisyen (Mauritius)'),
    'mg': N_('Malagasy'),
    'mg_MG': N_('Malagasy (Madagascar)'),
    'mgh': N_('Makhuwa-Meetto'),
    'mgh_MZ': N_('Makhuwa-Meetto (Mozambique)'),
    'mgo': N_('Metaʼ'),
    'mgo_CM': N_('Metaʼ (Cameroon)'),
    'mi': N_('Māori'),
    'mi_NZ': N_('Māori (New Zealand)'),
    'mk': N_('Macedonian'),
    'mk_MK': N_('Macedonian (North Macedonia)'),
    'ml': N_('Malayalam'),
    'ml_IN': N_('Malayalam (India)'),
    'mn': N_('Mongolian'),
    'mn_Cyrl': N_('Mongolian (Cyrillic)'),
    'mn_Cyrl_MN': N_('Mongolian (Cyrillic) (Mongolia)'),
    'mn_MN': N_('Mongolian (Mongolia)'),
    'mn_Mong': N_('Mongolian (Mongolian)'),
    'mn_Mong_CN': N_('Mongolian (Mongolian) (China)'),
    'mn_Mong_MN': N_('Mongolian (Mongolian) (Mongolia)'),
    'mni': N_('Manipuri'),
    'mni_Beng': N_('Manipuri (Bangla)'),
    'mni_Beng_IN': N_('Manipuri (Bangla) (India)'),
    'mni_Mtei': N_('Manipuri (Meitei Mayek)'),
    'mni_Mtei_IN': N_('Manipuri (Meitei Mayek) (India)'),
    'moh': N_('Mohawk'),
    'moh_CA': N_('Mohawk (Canada)'),
    'mr': N_('Marathi'),
    'mr_IN': N_('Marathi (India)'),
    'ms': N_('Malay'),
    'ms_Arab': N_('Malay (Arabic)'),
    'ms_Arab_BN': N_('Malay (Arabic) (Brunei)'),
    'ms_Arab_MY': N_('Malay (Arabic) (Malaysia)'),
    'ms_BN': N_('Malay (Brunei)'),
    'ms_ID': N_('Malay (Indonesia)'),
    'ms_MY': N_('Malay (Malaysia)'),
    'ms_SG': N_('Malay (Singapore)'),
    'mt': N_('Maltese'),
    'mt_MT': N_('Maltese (Malta)'),
    'mua': N_('Mundang'),
    'mua_CM': N_('Mundang (Cameroon)'),
    'mus': N_('Muscogee'),
    'mus_US': N_('Muscogee (United States)'),
    'my': N_('Burmese'),
    'my_MM': N_('Burmese (Myanmar (Burma))'),
    'myv': N_('Erzya'),
    'myv_RU': N_('Erzya (Russia)'),
    'mzn': N_('Mazanderani'),
    'mzn_IR': N_('Mazanderani (Iran)'),
    'naq': N_('Nama'),
    'naq_NA': N_('Nama (Namibia)'),
    'nb': N_('Norwegian Bokmål'),
    'nb_NO': N_('Norwegian Bokmål (Norway)'),
    'nb_SJ': N_('Norwegian Bokmål (Svalbard & Jan Mayen)'),
    'nd': N_('North Ndebele'),
    'nd_ZW': N_('North Ndebele (Zimbabwe)'),
    'nds': N_('Low German'),
    'nds_DE': N_('Low German (Germany)'),
    'nds_NL': N_('Low German (Netherlands)'),
    'ne': N_('Nepali'),
    'ne_IN': N_('Nepali (India)'),
    'ne_NP': N_('Nepali (Nepal)'),
    'nl': N_('Dutch'),
    'nl_AW': N_('Dutch (Aruba)'),
    'nl_BE': N_('Dutch (Belgium)'),
    'nl_BQ': N_('Dutch (Caribbean Netherlands)'),
    'nl_CW': N_('Dutch (Curaçao)'),
    'nl_NL': N_('Dutch (Netherlands)'),
    'nl_SR': N_('Dutch (Suriname)'),
    'nl_SX': N_('Dutch (Sint Maarten)'),
    'nmg': N_('Kwasio'),
    'nmg_CM': N_('Kwasio (Cameroon)'),
    'nn': N_('Norwegian Nynorsk'),
    'nn_NO': N_('Norwegian Nynorsk (Norway)'),
    'nnh': N_('Ngiemboon'),
    'nnh_CM': N_('Ngiemboon (Cameroon)'),
    'no': N_('Norwegian'),
    'nqo': N_('N’Ko'),
    'nqo_GN': N_('N’Ko (Guinea)'),
    'nr': N_('South Ndebele'),
    'nr_ZA': N_('South Ndebele (South Africa)'),
    'nso': N_('Northern Sotho'),
    'nso_ZA': N_('Northern Sotho (South Africa)'),
    'nus': N_('Nuer'),
    'nus_SS': N_('Nuer (South Sudan)'),
    'nv': N_('Navajo'),
    'nv_US': N_('Navajo (United States)'),
    'ny': N_('Nyanja'),
    'ny_MW': N_('Nyanja (Malawi)'),
    'nyn': N_('Nyankole'),
    'nyn_UG': N_('Nyankole (Uganda)'),
    'oc': N_('Occitan'),
    'oc_ES': N_('Occitan (Spain)'),
    'oc_FR': N_('Occitan (France)'),
    'om': N_('Oromo'),
    'om_ET': N_('Oromo (Ethiopia)'),
    'om_KE': N_('Oromo (Kenya)'),
    'or': N_('Odia'),
    'or_IN': N_('Odia (India)'),
    'os': N_('Ossetic'),
    'os_GE': N_('Ossetic (Georgia)'),
    'os_RU': N_('Ossetic (Russia)'),
    'osa': N_('Osage'),
    'osa_US': N_('Osage (United States)'),
    'pa': N_('Punjabi'),
    'pa_Arab': N_('Punjabi (Arabic)'),
    'pa_Arab_PK': N_('Punjabi (Arabic) (Pakistan)'),
    'pa_Guru': N_('Punjabi (Gurmukhi)'),
    'pa_Guru_IN': N_('Punjabi (Gurmukhi) (India)'),
    'pa_IN': N_('Punjabi (India)'),
    'pa_PK': N_('Punjabi (Pakistan)'),
    'pap': N_('Papiamento'),
    'pap_AW': N_('Papiamento (Aruba)'),
    'pap_CW': N_('Papiamento (Curaçao)'),
    'pcm': N_('Nigerian Pidgin'),
    'pcm_NG': N_('Nigerian Pidgin (Nigeria)'),
    'pis': N_('Pijin'),
    'pis_SB': N_('Pijin (Solomon Islands)'),
    'pl': N_('Polish'),
    'pl_PL': N_('Polish (Poland)'),
    'prg': N_('Prussian'),
    'prg_001': N_('Prussian (world)'),
    'ps': N_('Pashto'),
    'ps_AF': N_('Pashto (Afghanistan)'),
    'ps_PK': N_('Pashto (Pakistan)'),
    'pt': N_('Portuguese'),
    'pt_AO': N_('Portuguese (Angola)'),
    'pt_BR': N_('Portuguese (Brazil)'),
    'pt_CH': N_('Portuguese (Switzerland)'),
    'pt_CV': N_('Portuguese (Cape Verde)'),
    'pt_GQ': N_('Portuguese (Equatorial Guinea)'),
    'pt_GW': N_('Portuguese (Guinea-Bissau)'),
    'pt_LU': N_('Portuguese (Luxembourg)'),
    'pt_MO': N_('Portuguese (Macao)'),
    'pt_MZ': N_('Portuguese (Mozambique)'),
    'pt_PT': N_('Portuguese (Portugal)'),
    'pt_ST': N_('Portuguese (São Tomé & Príncipe)'),
    'pt_TL': N_('Portuguese (Timor-Leste)'),
    'qu': N_('Quechua'),
    'qu_BO': N_('Quechua (Bolivia)'),
    'qu_EC': N_('Quechua (Ecuador)'),
    'qu_PE': N_('Quechua (Peru)'),
    'quc': N_('Kʼicheʼ'),
    'quc_GT': N_('Kʼicheʼ (Guatemala)'),
    'raj': N_('Rajasthani'),
    'raj_IN': N_('Rajasthani (India)'),
    'rhg': N_('Rohingya'),
    'rhg_Rohg': N_('Rohingya (Hanifi)'),
    'rhg_Rohg_BD': N_('Rohingya (Hanifi) (Bangladesh)'),
    'rhg_Rohg_MM': N_('Rohingya (Hanifi) (Myanmar (Burma))'),
    'rif': N_('Riffian'),
    'rif_MA': N_('Riffian (Morocco)'),
    'rm': N_('Romansh'),
    'rm_CH': N_('Romansh (Switzerland)'),
    'rn': N_('Rundi'),
    'rn_BI': N_('Rundi (Burundi)'),
    'ro': N_('Romanian'),
    'ro_MD': N_('Romanian (Moldova)'),
    'ro_RO': N_('Romanian (Romania)'),
    'rof': N_('Rombo'),
    'rof_TZ': N_('Rombo (Tanzania)'),
    'ru': N_('Russian'),
    'ru_BY': N_('Russian (Belarus)'),
    'ru_KG': N_('Russian (Kyrgyzstan)'),
    'ru_KZ': N_('Russian (Kazakhstan)'),
    'ru_MD': N_('Russian (Moldova)'),
    'ru_RU': N_('Russian (Russia)'),
    'ru_UA': N_('Russian (Ukraine)'),
    'rw': N_('Kinyarwanda'),
    'rw_RW': N_('Kinyarwanda (Rwanda)'),
    'rwk': N_('Rwa'),
    'rwk_TZ': N_('Rwa (Tanzania)'),
    'sa': N_('Sanskrit'),
    'sa_IN': N_('Sanskrit (India)'),
    'sah': N_('Yakut'),
    'sah_RU': N_('Yakut (Russia)'),
    'saq': N_('Samburu'),
    'saq_KE': N_('Samburu (Kenya)'),
    'sat': N_('Santali'),
    'sat_Deva': N_('Santali (Devanagari)'),
    'sat_Deva_IN': N_('Santali (Devanagari) (India)'),
    'sat_Olck': N_('Santali (Ol Chiki)'),
    'sat_Olck_IN': N_('Santali (Ol Chiki) (India)'),
    'sbp': N_('Sangu'),
    'sbp_TZ': N_('Sangu (Tanzania)'),
    'sc': N_('Sardinian'),
    'sc_IT': N_('Sardinian (Italy)'),
    'scn': N_('Sicilian'),
    'scn_IT': N_('Sicilian (Italy)'),
    'sd': N_('Sindhi'),
    'sd_Arab': N_('Sindhi (Arabic)'),
    'sd_Arab_PK': N_('Sindhi (Arabic) (Pakistan)'),
    'sd_Deva': N_('Sindhi (Devanagari)'),
    'sd_Deva_IN': N_('Sindhi (Devanagari) (India)'),
    'sdh': N_('Southern Kurdish'),
    'sdh_IQ': N_('Southern Kurdish (Iraq)'),
    'sdh_IR': N_('Southern Kurdish (Iran)'),
    'se': N_('Northern Sami'),
    'se_FI': N_('Northern Sami (Finland)'),
    'se_NO': N_('Northern Sami (Norway)'),
    'se_SE': N_('Northern Sami (Sweden)'),
    'seh': N_('Sena'),
    'seh_MZ': N_('Sena (Mozambique)'),
    'ses': N_('Koyraboro Senni'),
    'ses_ML': N_('Koyraboro Senni (Mali)'),
    'sg': N_('Sango'),
    'sg_CF': N_('Sango (Central African Republic)'),
    'shi': N_('Tachelhit'),
    'shi_Latn': N_('Tachelhit (Latin)'),
    'shi_Latn_MA': N_('Tachelhit (Latin) (Morocco)'),
    'shi_Tfng': N_('Tachelhit (Tifinagh)'),
    'shi_Tfng_MA': N_('Tachelhit (Tifinagh) (Morocco)'),
    'shn': N_('Shan'),
    'shn_MM': N_('Shan (Myanmar (Burma))'),
    'shn_TH': N_('Shan (Thailand)'),
    'si': N_('Sinhala'),
    'si_LK': N_('Sinhala (Sri Lanka)'),
    'sid': N_('Sidamo'),
    'sid_ET': N_('Sidamo (Ethiopia)'),
    'sk': N_('Slovak'),
    'sk_SK': N_('Slovak (Slovakia)'),
    'sl': N_('Slovenian'),
    'sl_SI': N_('Slovenian (Slovenia)'),
    'sma': N_('Southern Sami'),
    'sma_NO': N_('Southern Sami (Norway)'),
    'sma_SE': N_('Southern Sami (Sweden)'),
    'smj': N_('Lule Sami'),
    'smj_NO': N_('Lule Sami (Norway)'),
    'smj_SE': N_('Lule Sami (Sweden)'),
    'smn': N_('Inari Sami'),
    'smn_FI': N_('Inari Sami (Finland)'),
    'sms': N_('Skolt Sami'),
    'sms_FI': N_('Skolt Sami (Finland)'),
    'sn': N_('Shona'),
    'sn_ZW': N_('Shona (Zimbabwe)'),
    'so': N_('Somali'),
    'so_DJ': N_('Somali (Djibouti)'),
    'so_ET': N_('Somali (Ethiopia)'),
    'so_KE': N_('Somali (Kenya)'),
    'so_SO': N_('Somali (Somalia)'),
    'sq': N_('Albanian'),
    'sq_AL': N_('Albanian (Albania)'),
    'sq_MK': N_('Albanian (North Macedonia)'),
    'sq_XK': N_('Albanian (Kosovo)'),
    'sr': N_('Serbian'),
    'sr_Cyrl': N_('Serbian (Cyrillic)'),
    'sr_Cyrl_BA': N_('Serbian (Cyrillic) (Bosnia & Herzegovina)'),
    'sr_Cyrl_ME': N_('Serbian (Cyrillic) (Montenegro)'),
    'sr_Cyrl_RS': N_('Serbian (Cyrillic) (Serbia)'),
    'sr_Cyrl_XK': N_('Serbian (Cyrillic) (Kosovo)'),
    'sr_Latn': N_('Serbian (Latin)'),
    'sr_Latn_BA': N_('Serbian (Latin) (Bosnia & Herzegovina)'),
    'sr_Latn_ME': N_('Serbian (Latin) (Montenegro)'),
    'sr_Latn_RS': N_('Serbian (Latin) (Serbia)'),
    'sr_Latn_XK': N_('Serbian (Latin) (Kosovo)'),
    'ss': N_('Swati'),
    'ss_SZ': N_('Swati (Eswatini)'),
    'ss_ZA': N_('Swati (South Africa)'),
    'ssy': N_('Saho'),
    'ssy_ER': N_('Saho (Eritrea)'),
    'st': N_('Southern Sotho'),
    'st_LS': N_('Southern Sotho (Lesotho)'),
    'st_ZA': N_('Southern Sotho (South Africa)'),
    'su': N_('Sundanese'),
    'su_Latn': N_('Sundanese (Latin)'),
    'su_Latn_ID': N_('Sundanese (Latin) (Indonesia)'),
    'sv': N_('Swedish'),
    'sv_AX': N_('Swedish (Åland Islands)'),
    'sv_FI': N_('Swedish (Finland)'),
    'sv_SE': N_('Swedish (Sweden)'),
    'sw': N_('Swahili'),
    'sw_CD': N_('Swahili (Congo - Kinshasa)'),
    'sw_KE': N_('Swahili (Kenya)'),
    'sw_TZ': N_('Swahili (Tanzania)'),
    'sw_UG': N_('Swahili (Uganda)'),
    'syr': N_('Syriac'),
    'syr_IQ': N_('Syriac (Iraq)'),
    'syr_SY': N_('Syriac (Syria)'),
    'szl': N_('Silesian'),
    'szl_PL': N_('Silesian (Poland)'),
    'ta': N_('Tamil'),
    'ta_IN': N_('Tamil (India)'),
    'ta_LK': N_('Tamil (Sri Lanka)'),
    'ta_MY': N_('Tamil (Malaysia)'),
    'ta_SG': N_('Tamil (Singapore)'),
    'te': N_('Telugu'),
    'te_IN': N_('Telugu (India)'),
    'teo': N_('Teso'),
    'teo_KE': N_('Teso (Kenya)'),
    'teo_UG': N_('Teso (Uganda)'),
    'tg': N_('Tajik'),
    'tg_Cyrl': N_('Tajik (Cyrillic)'),
    'tg_Cyrl_TJ': N_('Tajik (Cyrillic) (Tajikistan)'),
    'tg_TJ': N_('Tajik (Tajikistan)'),
    'th': N_('Thai'),
    'th_TH': N_('Thai (Thailand)'),
    'ti': N_('Tigrinya'),
    'ti_ER': N_('Tigrinya (Eritrea)'),
    'ti_ET': N_('Tigrinya (Ethiopia)'),
    'tig': N_('Tigre'),
    'tig_ER': N_('Tigre (Eritrea)'),
    'tk': N_('Turkmen'),
    'tk_TM': N_('Turkmen (Turkmenistan)'),
    'tn': N_('Tswana'),
    'tn_BW': N_('Tswana (Botswana)'),
    'tn_ZA': N_('Tswana (South Africa)'),
    'to': N_('Tongan'),
    'to_TO': N_('Tongan (Tonga)'),
    'tok': N_('Toki Pona'),
    'tok_001': N_('Toki Pona (world)'),
    'tpi': N_('Tok Pisin'),
    'tpi_PG': N_('Tok Pisin (Papua New Guinea)'),
    'tr': N_('Turkish'),
    'tr_CY': N_('Turkish (Cyprus)'),
    'tr_TR': N_('Turkish (Türkiye)'),
    'trv': N_('Taroko'),
    'trv_TW': N_('Taroko (Taiwan)'),
    'trw': N_('Torwali'),
    'trw_PK': N_('Torwali (Pakistan)'),
    'ts': N_('Tsonga'),
    'ts_ZA': N_('Tsonga (South Africa)'),
    'tt': N_('Tatar'),
    'tt_RU': N_('Tatar (Russia)'),
    'twq': N_('Tasawaq'),
    'twq_NE': N_('Tasawaq (Niger)'),
    'tzm': N_('Central Atlas Tamazight'),
    'tzm_MA': N_('Central Atlas Tamazight (Morocco)'),
    'ug': N_('Uyghur'),
    'ug_CN': N_('Uyghur (China)'),
    'uk': N_('Ukrainian'),
    'uk_UA': N_('Ukrainian (Ukraine)'),
    'und': N_('Unknown language'),
    'ur': N_('Urdu'),
    'ur_IN': N_('Urdu (India)'),
    'ur_PK': N_('Urdu (Pakistan)'),
    'uz': N_('Uzbek'),
    'uz_Arab': N_('Uzbek (Arabic)'),
    'uz_Arab_AF': N_('Uzbek (Arabic) (Afghanistan)'),
    'uz_Cyrl': N_('Uzbek (Cyrillic)'),
    'uz_Cyrl_UZ': N_('Uzbek (Cyrillic) (Uzbekistan)'),
    'uz_Latn': N_('Uzbek (Latin)'),
    'uz_Latn_UZ': N_('Uzbek (Latin) (Uzbekistan)'),
    'vai': N_('Vai'),
    'vai_Latn': N_('Vai (Latin)'),
    'vai_Latn_LR': N_('Vai (Latin) (Liberia)'),
    'vai_Vaii': N_('Vai (Vai)'),
    'vai_Vaii_LR': N_('Vai (Vai) (Liberia)'),
    've': N_('Venda'),
    've_ZA': N_('Venda (South Africa)'),
    'vec': N_('Venetian'),
    'vec_IT': N_('Venetian (Italy)'),
    'vi': N_('Vietnamese'),
    'vi_VN': N_('Vietnamese (Vietnam)'),
    'vo': N_('Volapük'),
    'vo_001': N_('Volapük (world)'),
    'vun': N_('Vunjo'),
    'vun_TZ': N_('Vunjo (Tanzania)'),
    'wa': N_('Walloon'),
    'wa_BE': N_('Walloon (Belgium)'),
    'wae': N_('Walser'),
    'wae_CH': N_('Walser (Switzerland)'),
    'wal': N_('Wolaytta'),
    'wal_ET': N_('Wolaytta (Ethiopia)'),
    'wbp': N_('Warlpiri'),
    'wbp_AU': N_('Warlpiri (Australia)'),
    'wo': N_('Wolof'),
    'wo_SN': N_('Wolof (Senegal)'),
    'xh': N_('Xhosa'),
    'xh_ZA': N_('Xhosa (South Africa)'),
    'xog': N_('Soga'),
    'xog_UG': N_('Soga (Uganda)'),
    'yav': N_('Yangben'),
    'yav_CM': N_('Yangben (Cameroon)'),
    'yi': N_('Yiddish'),
    'yi_001': N_('Yiddish (world)'),
    'yo': N_('Yoruba'),
    'yo_BJ': N_('Yoruba (Benin)'),
    'yo_NG': N_('Yoruba (Nigeria)'),
    'yrl': N_('Nheengatu'),
    'yrl_BR': N_('Nheengatu (Brazil)'),
    'yrl_CO': N_('Nheengatu (Colombia)'),
    'yrl_VE': N_('Nheengatu (Venezuela)'),
    'yue': N_('Cantonese'),
    'yue_Hans': N_('Cantonese (Simplified)'),
    'yue_Hans_CN': N_('Cantonese (Simplified) (China)'),
    'yue_Hant': N_('Cantonese (Traditional)'),
    'yue_Hant_HK': N_('Cantonese (Traditional) (Hong Kong)'),
    'zgh': N_('Standard Moroccan Tamazight'),
    'zgh_MA': N_('Standard Moroccan Tamazight (Morocco)'),
    'zh': N_('Chinese'),
    'zh_Hans': N_('Chinese (Simplified)'),
    'zh_Hans_CN': N_('Chinese (Simplified) (China)'),
    'zh_Hans_HK': N_('Chinese (Simplified) (Hong Kong)'),
    'zh_Hans_MO': N_('Chinese (Simplified) (Macao)'),
    'zh_Hans_SG': N_('Chinese (Simplified) (Singapore)'),
    'zh_Hant': N_('Chinese (Traditional)'),
    'zh_Hant_HK': N_('Chinese (Traditional) (Hong Kong)'),
    'zh_Hant_MO': N_('Chinese (Traditional) (Macao)'),
    'zh_Hant_TW': N_('Chinese (Traditional) (Taiwan)'),
    'zu': N_('Zulu'),
    'zu_ZA': N_('Zulu (South Africa)'),
}
