// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/loads"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/runtime/security"
	"github.com/go-openapi/spec"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/haproxytech/dataplaneapi/operations/acl"
	"github.com/haproxytech/dataplaneapi/operations/acl_runtime"
	"github.com/haproxytech/dataplaneapi/operations/backend"
	"github.com/haproxytech/dataplaneapi/operations/backend_switching_rule"
	"github.com/haproxytech/dataplaneapi/operations/bind"
	"github.com/haproxytech/dataplaneapi/operations/cache"
	"github.com/haproxytech/dataplaneapi/operations/cluster"
	"github.com/haproxytech/dataplaneapi/operations/configuration"
	"github.com/haproxytech/dataplaneapi/operations/crt_load"
	"github.com/haproxytech/dataplaneapi/operations/crt_store"
	"github.com/haproxytech/dataplaneapi/operations/declare_capture"
	"github.com/haproxytech/dataplaneapi/operations/defaults"
	"github.com/haproxytech/dataplaneapi/operations/dgram_bind"
	"github.com/haproxytech/dataplaneapi/operations/discovery"
	"github.com/haproxytech/dataplaneapi/operations/fcgi_app"
	"github.com/haproxytech/dataplaneapi/operations/filter"
	"github.com/haproxytech/dataplaneapi/operations/frontend"
	"github.com/haproxytech/dataplaneapi/operations/global"
	"github.com/haproxytech/dataplaneapi/operations/group"
	"github.com/haproxytech/dataplaneapi/operations/health"
	"github.com/haproxytech/dataplaneapi/operations/http_after_response_rule"
	"github.com/haproxytech/dataplaneapi/operations/http_check"
	"github.com/haproxytech/dataplaneapi/operations/http_error_rule"
	"github.com/haproxytech/dataplaneapi/operations/http_errors"
	"github.com/haproxytech/dataplaneapi/operations/http_request_rule"
	"github.com/haproxytech/dataplaneapi/operations/http_response_rule"
	"github.com/haproxytech/dataplaneapi/operations/information"
	"github.com/haproxytech/dataplaneapi/operations/log_forward"
	"github.com/haproxytech/dataplaneapi/operations/log_profile"
	"github.com/haproxytech/dataplaneapi/operations/log_target"
	"github.com/haproxytech/dataplaneapi/operations/mailer_entry"
	"github.com/haproxytech/dataplaneapi/operations/mailers"
	"github.com/haproxytech/dataplaneapi/operations/maps"
	"github.com/haproxytech/dataplaneapi/operations/nameserver"
	"github.com/haproxytech/dataplaneapi/operations/peer"
	"github.com/haproxytech/dataplaneapi/operations/peer_entry"
	"github.com/haproxytech/dataplaneapi/operations/process_manager"
	"github.com/haproxytech/dataplaneapi/operations/quic_initial_rule"
	"github.com/haproxytech/dataplaneapi/operations/reloads"
	"github.com/haproxytech/dataplaneapi/operations/resolver"
	"github.com/haproxytech/dataplaneapi/operations/ring"
	serverops "github.com/haproxytech/dataplaneapi/operations/server"
	"github.com/haproxytech/dataplaneapi/operations/server_switching_rule"
	"github.com/haproxytech/dataplaneapi/operations/server_template"
	"github.com/haproxytech/dataplaneapi/operations/service_discovery"
	"github.com/haproxytech/dataplaneapi/operations/sites"
	"github.com/haproxytech/dataplaneapi/operations/specification"
	"github.com/haproxytech/dataplaneapi/operations/spoe"
	"github.com/haproxytech/dataplaneapi/operations/spoe_transactions"
	"github.com/haproxytech/dataplaneapi/operations/stats"
	"github.com/haproxytech/dataplaneapi/operations/stick_rule"
	"github.com/haproxytech/dataplaneapi/operations/stick_table"
	"github.com/haproxytech/dataplaneapi/operations/storage"
	"github.com/haproxytech/dataplaneapi/operations/table"
	"github.com/haproxytech/dataplaneapi/operations/tcp_check"
	"github.com/haproxytech/dataplaneapi/operations/tcp_request_rule"
	"github.com/haproxytech/dataplaneapi/operations/tcp_response_rule"
	"github.com/haproxytech/dataplaneapi/operations/traces"
	"github.com/haproxytech/dataplaneapi/operations/transactions"
	"github.com/haproxytech/dataplaneapi/operations/user"
	"github.com/haproxytech/dataplaneapi/operations/userlist"
	"github.com/haproxytech/dataplaneapi/operations/version3"
)

// NewDataPlaneAPI creates a new DataPlane instance
func NewDataPlaneAPI(spec *loads.Document) *DataPlaneAPI {
	return &DataPlaneAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		customConsumers:     make(map[string]runtime.Consumer),
		customProducers:     make(map[string]runtime.Producer),
		PreServerShutdown:   func() {},
		ServerShutdown:      func() {},
		spec:                spec,
		useSwaggerUI:        false,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,

		JSONConsumer:          runtime.JSONConsumer(),
		MultipartformConsumer: runtime.DiscardConsumer,
		TxtConsumer:           runtime.TextConsumer(),

		BinProducer:  runtime.ByteStreamProducer(),
		JSONProducer: runtime.JSONProducer(),
		TxtProducer:  runtime.TextProducer(),

		ACLRuntimeDeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler: acl_runtime.DeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandlerFunc(func(params acl_runtime.DeleteServicesHaproxyRuntimeAclsParentNameEntriesIDParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.DeleteServicesHaproxyRuntimeAclsParentNameEntriesID has not yet been implemented")
		}),
		ACLRuntimeGetServicesHaproxyRuntimeAclsHandler: acl_runtime.GetServicesHaproxyRuntimeAclsHandlerFunc(func(params acl_runtime.GetServicesHaproxyRuntimeAclsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.GetServicesHaproxyRuntimeAcls has not yet been implemented")
		}),
		ACLRuntimeGetServicesHaproxyRuntimeAclsIDHandler: acl_runtime.GetServicesHaproxyRuntimeAclsIDHandlerFunc(func(params acl_runtime.GetServicesHaproxyRuntimeAclsIDParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.GetServicesHaproxyRuntimeAclsID has not yet been implemented")
		}),
		ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesHandler: acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesHandlerFunc(func(params acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntries has not yet been implemented")
		}),
		ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler: acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesIDHandlerFunc(func(params acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesIDParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesID has not yet been implemented")
		}),
		ACLRuntimePostServicesHaproxyRuntimeAclsParentNameEntriesHandler: acl_runtime.PostServicesHaproxyRuntimeAclsParentNameEntriesHandlerFunc(func(params acl_runtime.PostServicesHaproxyRuntimeAclsParentNameEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.PostServicesHaproxyRuntimeAclsParentNameEntries has not yet been implemented")
		}),
		DefaultsAddDefaultsSectionHandler: defaults.AddDefaultsSectionHandlerFunc(func(params defaults.AddDefaultsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.AddDefaultsSection has not yet been implemented")
		}),
		MapsAddMapEntryHandler: maps.AddMapEntryHandlerFunc(func(params maps.AddMapEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.AddMapEntry has not yet been implemented")
		}),
		ACLRuntimeAddPayloadRuntimeACLHandler: acl_runtime.AddPayloadRuntimeACLHandlerFunc(func(params acl_runtime.AddPayloadRuntimeACLParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl_runtime.AddPayloadRuntimeACL has not yet been implemented")
		}),
		MapsAddPayloadRuntimeMapHandler: maps.AddPayloadRuntimeMapHandlerFunc(func(params maps.AddPayloadRuntimeMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.AddPayloadRuntimeMap has not yet been implemented")
		}),
		ServerAddRuntimeServerHandler: serverops.AddRuntimeServerHandlerFunc(func(params serverops.AddRuntimeServerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.AddRuntimeServer has not yet been implemented")
		}),
		MapsClearRuntimeMapHandler: maps.ClearRuntimeMapHandlerFunc(func(params maps.ClearRuntimeMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.ClearRuntimeMap has not yet been implemented")
		}),
		SpoeTransactionsCommitSpoeTransactionHandler: spoe_transactions.CommitSpoeTransactionHandlerFunc(func(params spoe_transactions.CommitSpoeTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe_transactions.CommitSpoeTransaction has not yet been implemented")
		}),
		TransactionsCommitTransactionHandler: transactions.CommitTransactionHandlerFunc(func(params transactions.CommitTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation transactions.CommitTransaction has not yet been implemented")
		}),
		ServiceDiscoveryCreateAWSRegionHandler: service_discovery.CreateAWSRegionHandlerFunc(func(params service_discovery.CreateAWSRegionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.CreateAWSRegion has not yet been implemented")
		}),
		ACLCreateACLBackendHandler: acl.CreateACLBackendHandlerFunc(func(params acl.CreateACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.CreateACLBackend has not yet been implemented")
		}),
		ACLCreateACLFCGIAppHandler: acl.CreateACLFCGIAppHandlerFunc(func(params acl.CreateACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.CreateACLFCGIApp has not yet been implemented")
		}),
		ACLCreateACLFrontendHandler: acl.CreateACLFrontendHandlerFunc(func(params acl.CreateACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.CreateACLFrontend has not yet been implemented")
		}),
		BackendCreateBackendHandler: backend.CreateBackendHandlerFunc(func(params backend.CreateBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend.CreateBackend has not yet been implemented")
		}),
		BackendSwitchingRuleCreateBackendSwitchingRuleHandler: backend_switching_rule.CreateBackendSwitchingRuleHandlerFunc(func(params backend_switching_rule.CreateBackendSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.CreateBackendSwitchingRule has not yet been implemented")
		}),
		BindCreateBindFrontendHandler: bind.CreateBindFrontendHandlerFunc(func(params bind.CreateBindFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.CreateBindFrontend has not yet been implemented")
		}),
		BindCreateBindLogForwardHandler: bind.CreateBindLogForwardHandlerFunc(func(params bind.CreateBindLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.CreateBindLogForward has not yet been implemented")
		}),
		BindCreateBindPeerHandler: bind.CreateBindPeerHandlerFunc(func(params bind.CreateBindPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.CreateBindPeer has not yet been implemented")
		}),
		CacheCreateCacheHandler: cache.CreateCacheHandlerFunc(func(params cache.CreateCacheParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cache.CreateCache has not yet been implemented")
		}),
		ServiceDiscoveryCreateConsulHandler: service_discovery.CreateConsulHandlerFunc(func(params service_discovery.CreateConsulParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.CreateConsul has not yet been implemented")
		}),
		CrtLoadCreateCrtLoadHandler: crt_load.CreateCrtLoadHandlerFunc(func(params crt_load.CreateCrtLoadParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_load.CreateCrtLoad has not yet been implemented")
		}),
		CrtStoreCreateCrtStoreHandler: crt_store.CreateCrtStoreHandlerFunc(func(params crt_store.CreateCrtStoreParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_store.CreateCrtStore has not yet been implemented")
		}),
		DeclareCaptureCreateDeclareCaptureHandler: declare_capture.CreateDeclareCaptureHandlerFunc(func(params declare_capture.CreateDeclareCaptureParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.CreateDeclareCapture has not yet been implemented")
		}),
		DefaultsCreateDefaultsSectionHandler: defaults.CreateDefaultsSectionHandlerFunc(func(params defaults.CreateDefaultsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.CreateDefaultsSection has not yet been implemented")
		}),
		DgramBindCreateDgramBindHandler: dgram_bind.CreateDgramBindHandlerFunc(func(params dgram_bind.CreateDgramBindParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation dgram_bind.CreateDgramBind has not yet been implemented")
		}),
		FCGIAppCreateFCGIAppHandler: fcgi_app.CreateFCGIAppHandlerFunc(func(params fcgi_app.CreateFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation fcgi_app.CreateFCGIApp has not yet been implemented")
		}),
		FilterCreateFilterBackendHandler: filter.CreateFilterBackendHandlerFunc(func(params filter.CreateFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.CreateFilterBackend has not yet been implemented")
		}),
		FilterCreateFilterFrontendHandler: filter.CreateFilterFrontendHandlerFunc(func(params filter.CreateFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.CreateFilterFrontend has not yet been implemented")
		}),
		FrontendCreateFrontendHandler: frontend.CreateFrontendHandlerFunc(func(params frontend.CreateFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation frontend.CreateFrontend has not yet been implemented")
		}),
		GroupCreateGroupHandler: group.CreateGroupHandlerFunc(func(params group.CreateGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation group.CreateGroup has not yet been implemented")
		}),
		HTTPAfterResponseRuleCreateHTTPAfterResponseRuleBackendHandler: http_after_response_rule.CreateHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.CreateHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.CreateHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleCreateHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.CreateHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.CreateHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.CreateHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckCreateHTTPCheckBackendHandler: http_check.CreateHTTPCheckBackendHandlerFunc(func(params http_check.CreateHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.CreateHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckCreateHTTPCheckDefaultsHandler: http_check.CreateHTTPCheckDefaultsHandlerFunc(func(params http_check.CreateHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.CreateHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleCreateHTTPErrorRuleBackendHandler: http_error_rule.CreateHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.CreateHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.CreateHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleCreateHTTPErrorRuleDefaultsHandler: http_error_rule.CreateHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.CreateHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.CreateHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleCreateHTTPErrorRuleFrontendHandler: http_error_rule.CreateHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.CreateHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.CreateHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPErrorsCreateHTTPErrorsSectionHandler: http_errors.CreateHTTPErrorsSectionHandlerFunc(func(params http_errors.CreateHTTPErrorsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_errors.CreateHTTPErrorsSection has not yet been implemented")
		}),
		HTTPRequestRuleCreateHTTPRequestRuleBackendHandler: http_request_rule.CreateHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.CreateHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.CreateHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleCreateHTTPRequestRuleFrontendHandler: http_request_rule.CreateHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.CreateHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.CreateHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleCreateHTTPResponseRuleBackendHandler: http_response_rule.CreateHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.CreateHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.CreateHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleCreateHTTPResponseRuleFrontendHandler: http_response_rule.CreateHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.CreateHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.CreateHTTPResponseRuleFrontend has not yet been implemented")
		}),
		LogForwardCreateLogForwardHandler: log_forward.CreateLogForwardHandlerFunc(func(params log_forward.CreateLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_forward.CreateLogForward has not yet been implemented")
		}),
		LogProfileCreateLogProfileHandler: log_profile.CreateLogProfileHandlerFunc(func(params log_profile.CreateLogProfileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_profile.CreateLogProfile has not yet been implemented")
		}),
		LogTargetCreateLogTargetBackendHandler: log_target.CreateLogTargetBackendHandlerFunc(func(params log_target.CreateLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetBackend has not yet been implemented")
		}),
		LogTargetCreateLogTargetDefaultsHandler: log_target.CreateLogTargetDefaultsHandlerFunc(func(params log_target.CreateLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetDefaults has not yet been implemented")
		}),
		LogTargetCreateLogTargetFrontendHandler: log_target.CreateLogTargetFrontendHandlerFunc(func(params log_target.CreateLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetFrontend has not yet been implemented")
		}),
		LogTargetCreateLogTargetGlobalHandler: log_target.CreateLogTargetGlobalHandlerFunc(func(params log_target.CreateLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetGlobal has not yet been implemented")
		}),
		LogTargetCreateLogTargetLogForwardHandler: log_target.CreateLogTargetLogForwardHandlerFunc(func(params log_target.CreateLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetLogForward has not yet been implemented")
		}),
		LogTargetCreateLogTargetPeerHandler: log_target.CreateLogTargetPeerHandlerFunc(func(params log_target.CreateLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.CreateLogTargetPeer has not yet been implemented")
		}),
		MailerEntryCreateMailerEntryHandler: mailer_entry.CreateMailerEntryHandlerFunc(func(params mailer_entry.CreateMailerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailer_entry.CreateMailerEntry has not yet been implemented")
		}),
		MailersCreateMailersSectionHandler: mailers.CreateMailersSectionHandlerFunc(func(params mailers.CreateMailersSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailers.CreateMailersSection has not yet been implemented")
		}),
		NameserverCreateNameserverHandler: nameserver.CreateNameserverHandlerFunc(func(params nameserver.CreateNameserverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation nameserver.CreateNameserver has not yet been implemented")
		}),
		PeerCreatePeerHandler: peer.CreatePeerHandlerFunc(func(params peer.CreatePeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer.CreatePeer has not yet been implemented")
		}),
		PeerEntryCreatePeerEntryHandler: peer_entry.CreatePeerEntryHandlerFunc(func(params peer_entry.CreatePeerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer_entry.CreatePeerEntry has not yet been implemented")
		}),
		ProcessManagerCreateProgramHandler: process_manager.CreateProgramHandlerFunc(func(params process_manager.CreateProgramParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation process_manager.CreateProgram has not yet been implemented")
		}),
		QUICInitialRuleCreateQUICInitialRuleDefaultsHandler: quic_initial_rule.CreateQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.CreateQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.CreateQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleCreateQUICInitialRuleFrontendHandler: quic_initial_rule.CreateQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.CreateQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.CreateQUICInitialRuleFrontend has not yet been implemented")
		}),
		ResolverCreateResolverHandler: resolver.CreateResolverHandlerFunc(func(params resolver.CreateResolverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation resolver.CreateResolver has not yet been implemented")
		}),
		RingCreateRingHandler: ring.CreateRingHandlerFunc(func(params ring.CreateRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ring.CreateRing has not yet been implemented")
		}),
		ServerCreateServerBackendHandler: serverops.CreateServerBackendHandlerFunc(func(params serverops.CreateServerBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.CreateServerBackend has not yet been implemented")
		}),
		ServerCreateServerPeerHandler: serverops.CreateServerPeerHandlerFunc(func(params serverops.CreateServerPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.CreateServerPeer has not yet been implemented")
		}),
		ServerCreateServerRingHandler: serverops.CreateServerRingHandlerFunc(func(params serverops.CreateServerRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.CreateServerRing has not yet been implemented")
		}),
		ServerSwitchingRuleCreateServerSwitchingRuleHandler: server_switching_rule.CreateServerSwitchingRuleHandlerFunc(func(params server_switching_rule.CreateServerSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.CreateServerSwitchingRule has not yet been implemented")
		}),
		ServerTemplateCreateServerTemplateHandler: server_template.CreateServerTemplateHandlerFunc(func(params server_template.CreateServerTemplateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_template.CreateServerTemplate has not yet been implemented")
		}),
		SitesCreateSiteHandler: sites.CreateSiteHandlerFunc(func(params sites.CreateSiteParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation sites.CreateSite has not yet been implemented")
		}),
		SpoeCreateSpoeHandler: spoe.CreateSpoeHandlerFunc(func(params spoe.CreateSpoeParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.CreateSpoe has not yet been implemented")
		}),
		SpoeCreateSpoeAgentHandler: spoe.CreateSpoeAgentHandlerFunc(func(params spoe.CreateSpoeAgentParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.CreateSpoeAgent has not yet been implemented")
		}),
		SpoeCreateSpoeGroupHandler: spoe.CreateSpoeGroupHandlerFunc(func(params spoe.CreateSpoeGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.CreateSpoeGroup has not yet been implemented")
		}),
		SpoeCreateSpoeMessageHandler: spoe.CreateSpoeMessageHandlerFunc(func(params spoe.CreateSpoeMessageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.CreateSpoeMessage has not yet been implemented")
		}),
		SpoeCreateSpoeScopeHandler: spoe.CreateSpoeScopeHandlerFunc(func(params spoe.CreateSpoeScopeParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.CreateSpoeScope has not yet been implemented")
		}),
		StickRuleCreateStickRuleHandler: stick_rule.CreateStickRuleHandlerFunc(func(params stick_rule.CreateStickRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.CreateStickRule has not yet been implemented")
		}),
		StorageCreateStorageGeneralFileHandler: storage.CreateStorageGeneralFileHandlerFunc(func(params storage.CreateStorageGeneralFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.CreateStorageGeneralFile has not yet been implemented")
		}),
		StorageCreateStorageMapFileHandler: storage.CreateStorageMapFileHandlerFunc(func(params storage.CreateStorageMapFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.CreateStorageMapFile has not yet been implemented")
		}),
		StorageCreateStorageSSLCertificateHandler: storage.CreateStorageSSLCertificateHandlerFunc(func(params storage.CreateStorageSSLCertificateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.CreateStorageSSLCertificate has not yet been implemented")
		}),
		TCPCheckCreateTCPCheckBackendHandler: tcp_check.CreateTCPCheckBackendHandlerFunc(func(params tcp_check.CreateTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.CreateTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckCreateTCPCheckDefaultsHandler: tcp_check.CreateTCPCheckDefaultsHandlerFunc(func(params tcp_check.CreateTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.CreateTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleCreateTCPRequestRuleBackendHandler: tcp_request_rule.CreateTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.CreateTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.CreateTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleCreateTCPRequestRuleFrontendHandler: tcp_request_rule.CreateTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.CreateTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.CreateTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleCreateTCPResponseRuleBackendHandler: tcp_response_rule.CreateTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.CreateTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.CreateTCPResponseRuleBackend has not yet been implemented")
		}),
		TableCreateTableHandler: table.CreateTableHandlerFunc(func(params table.CreateTableParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation table.CreateTable has not yet been implemented")
		}),
		TracesCreateTraceEntryHandler: traces.CreateTraceEntryHandlerFunc(func(params traces.CreateTraceEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.CreateTraceEntry has not yet been implemented")
		}),
		TracesCreateTracesHandler: traces.CreateTracesHandlerFunc(func(params traces.CreateTracesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.CreateTraces has not yet been implemented")
		}),
		UserCreateUserHandler: user.CreateUserHandlerFunc(func(params user.CreateUserParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation user.CreateUser has not yet been implemented")
		}),
		UserlistCreateUserlistHandler: userlist.CreateUserlistHandlerFunc(func(params userlist.CreateUserlistParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation userlist.CreateUserlist has not yet been implemented")
		}),
		ServiceDiscoveryDeleteAWSRegionHandler: service_discovery.DeleteAWSRegionHandlerFunc(func(params service_discovery.DeleteAWSRegionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.DeleteAWSRegion has not yet been implemented")
		}),
		ACLDeleteACLBackendHandler: acl.DeleteACLBackendHandlerFunc(func(params acl.DeleteACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.DeleteACLBackend has not yet been implemented")
		}),
		ACLDeleteACLFCGIAppHandler: acl.DeleteACLFCGIAppHandlerFunc(func(params acl.DeleteACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.DeleteACLFCGIApp has not yet been implemented")
		}),
		ACLDeleteACLFrontendHandler: acl.DeleteACLFrontendHandlerFunc(func(params acl.DeleteACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.DeleteACLFrontend has not yet been implemented")
		}),
		BackendDeleteBackendHandler: backend.DeleteBackendHandlerFunc(func(params backend.DeleteBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend.DeleteBackend has not yet been implemented")
		}),
		BackendSwitchingRuleDeleteBackendSwitchingRuleHandler: backend_switching_rule.DeleteBackendSwitchingRuleHandlerFunc(func(params backend_switching_rule.DeleteBackendSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.DeleteBackendSwitchingRule has not yet been implemented")
		}),
		BindDeleteBindFrontendHandler: bind.DeleteBindFrontendHandlerFunc(func(params bind.DeleteBindFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.DeleteBindFrontend has not yet been implemented")
		}),
		BindDeleteBindLogForwardHandler: bind.DeleteBindLogForwardHandlerFunc(func(params bind.DeleteBindLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.DeleteBindLogForward has not yet been implemented")
		}),
		BindDeleteBindPeerHandler: bind.DeleteBindPeerHandlerFunc(func(params bind.DeleteBindPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.DeleteBindPeer has not yet been implemented")
		}),
		CacheDeleteCacheHandler: cache.DeleteCacheHandlerFunc(func(params cache.DeleteCacheParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cache.DeleteCache has not yet been implemented")
		}),
		ClusterDeleteClusterHandler: cluster.DeleteClusterHandlerFunc(func(params cluster.DeleteClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cluster.DeleteCluster has not yet been implemented")
		}),
		ServiceDiscoveryDeleteConsulHandler: service_discovery.DeleteConsulHandlerFunc(func(params service_discovery.DeleteConsulParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.DeleteConsul has not yet been implemented")
		}),
		CrtLoadDeleteCrtLoadHandler: crt_load.DeleteCrtLoadHandlerFunc(func(params crt_load.DeleteCrtLoadParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_load.DeleteCrtLoad has not yet been implemented")
		}),
		CrtStoreDeleteCrtStoreHandler: crt_store.DeleteCrtStoreHandlerFunc(func(params crt_store.DeleteCrtStoreParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_store.DeleteCrtStore has not yet been implemented")
		}),
		DeclareCaptureDeleteDeclareCaptureHandler: declare_capture.DeleteDeclareCaptureHandlerFunc(func(params declare_capture.DeleteDeclareCaptureParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.DeleteDeclareCapture has not yet been implemented")
		}),
		DefaultsDeleteDefaultsSectionHandler: defaults.DeleteDefaultsSectionHandlerFunc(func(params defaults.DeleteDefaultsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.DeleteDefaultsSection has not yet been implemented")
		}),
		DgramBindDeleteDgramBindHandler: dgram_bind.DeleteDgramBindHandlerFunc(func(params dgram_bind.DeleteDgramBindParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation dgram_bind.DeleteDgramBind has not yet been implemented")
		}),
		FCGIAppDeleteFCGIAppHandler: fcgi_app.DeleteFCGIAppHandlerFunc(func(params fcgi_app.DeleteFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation fcgi_app.DeleteFCGIApp has not yet been implemented")
		}),
		FilterDeleteFilterBackendHandler: filter.DeleteFilterBackendHandlerFunc(func(params filter.DeleteFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.DeleteFilterBackend has not yet been implemented")
		}),
		FilterDeleteFilterFrontendHandler: filter.DeleteFilterFrontendHandlerFunc(func(params filter.DeleteFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.DeleteFilterFrontend has not yet been implemented")
		}),
		FrontendDeleteFrontendHandler: frontend.DeleteFrontendHandlerFunc(func(params frontend.DeleteFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation frontend.DeleteFrontend has not yet been implemented")
		}),
		GroupDeleteGroupHandler: group.DeleteGroupHandlerFunc(func(params group.DeleteGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation group.DeleteGroup has not yet been implemented")
		}),
		HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleBackendHandler: http_after_response_rule.DeleteHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.DeleteHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.DeleteHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.DeleteHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.DeleteHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.DeleteHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckDeleteHTTPCheckBackendHandler: http_check.DeleteHTTPCheckBackendHandlerFunc(func(params http_check.DeleteHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.DeleteHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckDeleteHTTPCheckDefaultsHandler: http_check.DeleteHTTPCheckDefaultsHandlerFunc(func(params http_check.DeleteHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.DeleteHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleDeleteHTTPErrorRuleBackendHandler: http_error_rule.DeleteHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.DeleteHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.DeleteHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleDeleteHTTPErrorRuleDefaultsHandler: http_error_rule.DeleteHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.DeleteHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.DeleteHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleDeleteHTTPErrorRuleFrontendHandler: http_error_rule.DeleteHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.DeleteHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.DeleteHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPErrorsDeleteHTTPErrorsSectionHandler: http_errors.DeleteHTTPErrorsSectionHandlerFunc(func(params http_errors.DeleteHTTPErrorsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_errors.DeleteHTTPErrorsSection has not yet been implemented")
		}),
		HTTPRequestRuleDeleteHTTPRequestRuleBackendHandler: http_request_rule.DeleteHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.DeleteHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.DeleteHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleDeleteHTTPRequestRuleFrontendHandler: http_request_rule.DeleteHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.DeleteHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.DeleteHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleDeleteHTTPResponseRuleBackendHandler: http_response_rule.DeleteHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.DeleteHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.DeleteHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleDeleteHTTPResponseRuleFrontendHandler: http_response_rule.DeleteHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.DeleteHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.DeleteHTTPResponseRuleFrontend has not yet been implemented")
		}),
		LogForwardDeleteLogForwardHandler: log_forward.DeleteLogForwardHandlerFunc(func(params log_forward.DeleteLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_forward.DeleteLogForward has not yet been implemented")
		}),
		LogProfileDeleteLogProfileHandler: log_profile.DeleteLogProfileHandlerFunc(func(params log_profile.DeleteLogProfileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_profile.DeleteLogProfile has not yet been implemented")
		}),
		LogTargetDeleteLogTargetBackendHandler: log_target.DeleteLogTargetBackendHandlerFunc(func(params log_target.DeleteLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetBackend has not yet been implemented")
		}),
		LogTargetDeleteLogTargetDefaultsHandler: log_target.DeleteLogTargetDefaultsHandlerFunc(func(params log_target.DeleteLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetDefaults has not yet been implemented")
		}),
		LogTargetDeleteLogTargetFrontendHandler: log_target.DeleteLogTargetFrontendHandlerFunc(func(params log_target.DeleteLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetFrontend has not yet been implemented")
		}),
		LogTargetDeleteLogTargetGlobalHandler: log_target.DeleteLogTargetGlobalHandlerFunc(func(params log_target.DeleteLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetGlobal has not yet been implemented")
		}),
		LogTargetDeleteLogTargetLogForwardHandler: log_target.DeleteLogTargetLogForwardHandlerFunc(func(params log_target.DeleteLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetLogForward has not yet been implemented")
		}),
		LogTargetDeleteLogTargetPeerHandler: log_target.DeleteLogTargetPeerHandlerFunc(func(params log_target.DeleteLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.DeleteLogTargetPeer has not yet been implemented")
		}),
		MailerEntryDeleteMailerEntryHandler: mailer_entry.DeleteMailerEntryHandlerFunc(func(params mailer_entry.DeleteMailerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailer_entry.DeleteMailerEntry has not yet been implemented")
		}),
		MailersDeleteMailersSectionHandler: mailers.DeleteMailersSectionHandlerFunc(func(params mailers.DeleteMailersSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailers.DeleteMailersSection has not yet been implemented")
		}),
		NameserverDeleteNameserverHandler: nameserver.DeleteNameserverHandlerFunc(func(params nameserver.DeleteNameserverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation nameserver.DeleteNameserver has not yet been implemented")
		}),
		PeerDeletePeerHandler: peer.DeletePeerHandlerFunc(func(params peer.DeletePeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer.DeletePeer has not yet been implemented")
		}),
		PeerEntryDeletePeerEntryHandler: peer_entry.DeletePeerEntryHandlerFunc(func(params peer_entry.DeletePeerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer_entry.DeletePeerEntry has not yet been implemented")
		}),
		ProcessManagerDeleteProgramHandler: process_manager.DeleteProgramHandlerFunc(func(params process_manager.DeleteProgramParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation process_manager.DeleteProgram has not yet been implemented")
		}),
		QUICInitialRuleDeleteQUICInitialRuleDefaultsHandler: quic_initial_rule.DeleteQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.DeleteQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.DeleteQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleDeleteQUICInitialRuleFrontendHandler: quic_initial_rule.DeleteQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.DeleteQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.DeleteQUICInitialRuleFrontend has not yet been implemented")
		}),
		ResolverDeleteResolverHandler: resolver.DeleteResolverHandlerFunc(func(params resolver.DeleteResolverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation resolver.DeleteResolver has not yet been implemented")
		}),
		RingDeleteRingHandler: ring.DeleteRingHandlerFunc(func(params ring.DeleteRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ring.DeleteRing has not yet been implemented")
		}),
		MapsDeleteRuntimeMapEntryHandler: maps.DeleteRuntimeMapEntryHandlerFunc(func(params maps.DeleteRuntimeMapEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.DeleteRuntimeMapEntry has not yet been implemented")
		}),
		ServerDeleteRuntimeServerHandler: serverops.DeleteRuntimeServerHandlerFunc(func(params serverops.DeleteRuntimeServerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.DeleteRuntimeServer has not yet been implemented")
		}),
		ServerDeleteServerBackendHandler: serverops.DeleteServerBackendHandlerFunc(func(params serverops.DeleteServerBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.DeleteServerBackend has not yet been implemented")
		}),
		ServerDeleteServerPeerHandler: serverops.DeleteServerPeerHandlerFunc(func(params serverops.DeleteServerPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.DeleteServerPeer has not yet been implemented")
		}),
		ServerDeleteServerRingHandler: serverops.DeleteServerRingHandlerFunc(func(params serverops.DeleteServerRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.DeleteServerRing has not yet been implemented")
		}),
		ServerSwitchingRuleDeleteServerSwitchingRuleHandler: server_switching_rule.DeleteServerSwitchingRuleHandlerFunc(func(params server_switching_rule.DeleteServerSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.DeleteServerSwitchingRule has not yet been implemented")
		}),
		ServerTemplateDeleteServerTemplateHandler: server_template.DeleteServerTemplateHandlerFunc(func(params server_template.DeleteServerTemplateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_template.DeleteServerTemplate has not yet been implemented")
		}),
		SitesDeleteSiteHandler: sites.DeleteSiteHandlerFunc(func(params sites.DeleteSiteParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation sites.DeleteSite has not yet been implemented")
		}),
		SpoeDeleteSpoeAgentHandler: spoe.DeleteSpoeAgentHandlerFunc(func(params spoe.DeleteSpoeAgentParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.DeleteSpoeAgent has not yet been implemented")
		}),
		SpoeDeleteSpoeFileHandler: spoe.DeleteSpoeFileHandlerFunc(func(params spoe.DeleteSpoeFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.DeleteSpoeFile has not yet been implemented")
		}),
		SpoeDeleteSpoeGroupHandler: spoe.DeleteSpoeGroupHandlerFunc(func(params spoe.DeleteSpoeGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.DeleteSpoeGroup has not yet been implemented")
		}),
		SpoeDeleteSpoeMessageHandler: spoe.DeleteSpoeMessageHandlerFunc(func(params spoe.DeleteSpoeMessageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.DeleteSpoeMessage has not yet been implemented")
		}),
		SpoeDeleteSpoeScopeHandler: spoe.DeleteSpoeScopeHandlerFunc(func(params spoe.DeleteSpoeScopeParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.DeleteSpoeScope has not yet been implemented")
		}),
		SpoeTransactionsDeleteSpoeTransactionHandler: spoe_transactions.DeleteSpoeTransactionHandlerFunc(func(params spoe_transactions.DeleteSpoeTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe_transactions.DeleteSpoeTransaction has not yet been implemented")
		}),
		StickRuleDeleteStickRuleHandler: stick_rule.DeleteStickRuleHandlerFunc(func(params stick_rule.DeleteStickRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.DeleteStickRule has not yet been implemented")
		}),
		StorageDeleteStorageGeneralFileHandler: storage.DeleteStorageGeneralFileHandlerFunc(func(params storage.DeleteStorageGeneralFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.DeleteStorageGeneralFile has not yet been implemented")
		}),
		StorageDeleteStorageMapHandler: storage.DeleteStorageMapHandlerFunc(func(params storage.DeleteStorageMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.DeleteStorageMap has not yet been implemented")
		}),
		StorageDeleteStorageSSLCertificateHandler: storage.DeleteStorageSSLCertificateHandlerFunc(func(params storage.DeleteStorageSSLCertificateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.DeleteStorageSSLCertificate has not yet been implemented")
		}),
		TCPCheckDeleteTCPCheckBackendHandler: tcp_check.DeleteTCPCheckBackendHandlerFunc(func(params tcp_check.DeleteTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.DeleteTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckDeleteTCPCheckDefaultsHandler: tcp_check.DeleteTCPCheckDefaultsHandlerFunc(func(params tcp_check.DeleteTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.DeleteTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleDeleteTCPRequestRuleBackendHandler: tcp_request_rule.DeleteTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.DeleteTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.DeleteTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleDeleteTCPRequestRuleFrontendHandler: tcp_request_rule.DeleteTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.DeleteTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.DeleteTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleDeleteTCPResponseRuleBackendHandler: tcp_response_rule.DeleteTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.DeleteTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.DeleteTCPResponseRuleBackend has not yet been implemented")
		}),
		TableDeleteTableHandler: table.DeleteTableHandlerFunc(func(params table.DeleteTableParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation table.DeleteTable has not yet been implemented")
		}),
		TracesDeleteTraceEntryHandler: traces.DeleteTraceEntryHandlerFunc(func(params traces.DeleteTraceEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.DeleteTraceEntry has not yet been implemented")
		}),
		TracesDeleteTracesHandler: traces.DeleteTracesHandlerFunc(func(params traces.DeleteTracesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.DeleteTraces has not yet been implemented")
		}),
		TransactionsDeleteTransactionHandler: transactions.DeleteTransactionHandlerFunc(func(params transactions.DeleteTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation transactions.DeleteTransaction has not yet been implemented")
		}),
		UserDeleteUserHandler: user.DeleteUserHandlerFunc(func(params user.DeleteUserParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation user.DeleteUser has not yet been implemented")
		}),
		UserlistDeleteUserlistHandler: userlist.DeleteUserlistHandlerFunc(func(params userlist.DeleteUserlistParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation userlist.DeleteUserlist has not yet been implemented")
		}),
		ClusterEditClusterHandler: cluster.EditClusterHandlerFunc(func(params cluster.EditClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cluster.EditCluster has not yet been implemented")
		}),
		CrtStoreEditCrtStoreHandler: crt_store.EditCrtStoreHandlerFunc(func(params crt_store.EditCrtStoreParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_store.EditCrtStore has not yet been implemented")
		}),
		LogProfileEditLogProfileHandler: log_profile.EditLogProfileHandlerFunc(func(params log_profile.EditLogProfileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_profile.EditLogProfile has not yet been implemented")
		}),
		MailersEditMailersSectionHandler: mailers.EditMailersSectionHandlerFunc(func(params mailers.EditMailersSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailers.EditMailersSection has not yet been implemented")
		}),
		DiscoveryGetAPIEndpointsHandler: discovery.GetAPIEndpointsHandlerFunc(func(params discovery.GetAPIEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetAPIEndpoints has not yet been implemented")
		}),
		ServiceDiscoveryGetAWSRegionHandler: service_discovery.GetAWSRegionHandlerFunc(func(params service_discovery.GetAWSRegionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.GetAWSRegion has not yet been implemented")
		}),
		ServiceDiscoveryGetAWSRegionsHandler: service_discovery.GetAWSRegionsHandlerFunc(func(params service_discovery.GetAWSRegionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.GetAWSRegions has not yet been implemented")
		}),
		ACLGetACLBackendHandler: acl.GetACLBackendHandlerFunc(func(params acl.GetACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetACLBackend has not yet been implemented")
		}),
		ACLGetACLFCGIAppHandler: acl.GetACLFCGIAppHandlerFunc(func(params acl.GetACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetACLFCGIApp has not yet been implemented")
		}),
		ACLGetACLFrontendHandler: acl.GetACLFrontendHandlerFunc(func(params acl.GetACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetACLFrontend has not yet been implemented")
		}),
		ACLGetAllACLBackendHandler: acl.GetAllACLBackendHandlerFunc(func(params acl.GetAllACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetAllACLBackend has not yet been implemented")
		}),
		ACLGetAllACLFCGIAppHandler: acl.GetAllACLFCGIAppHandlerFunc(func(params acl.GetAllACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetAllACLFCGIApp has not yet been implemented")
		}),
		ACLGetAllACLFrontendHandler: acl.GetAllACLFrontendHandlerFunc(func(params acl.GetAllACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.GetAllACLFrontend has not yet been implemented")
		}),
		BindGetAllBindFrontendHandler: bind.GetAllBindFrontendHandlerFunc(func(params bind.GetAllBindFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetAllBindFrontend has not yet been implemented")
		}),
		BindGetAllBindLogForwardHandler: bind.GetAllBindLogForwardHandlerFunc(func(params bind.GetAllBindLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetAllBindLogForward has not yet been implemented")
		}),
		BindGetAllBindPeerHandler: bind.GetAllBindPeerHandlerFunc(func(params bind.GetAllBindPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetAllBindPeer has not yet been implemented")
		}),
		FilterGetAllFilterBackendHandler: filter.GetAllFilterBackendHandlerFunc(func(params filter.GetAllFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.GetAllFilterBackend has not yet been implemented")
		}),
		FilterGetAllFilterFrontendHandler: filter.GetAllFilterFrontendHandlerFunc(func(params filter.GetAllFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.GetAllFilterFrontend has not yet been implemented")
		}),
		HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleBackendHandler: http_after_response_rule.GetAllHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.GetAllHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.GetAllHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.GetAllHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.GetAllHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.GetAllHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckGetAllHTTPCheckBackendHandler: http_check.GetAllHTTPCheckBackendHandlerFunc(func(params http_check.GetAllHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.GetAllHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckGetAllHTTPCheckDefaultsHandler: http_check.GetAllHTTPCheckDefaultsHandlerFunc(func(params http_check.GetAllHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.GetAllHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleGetAllHTTPErrorRuleBackendHandler: http_error_rule.GetAllHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.GetAllHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetAllHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleGetAllHTTPErrorRuleDefaultsHandler: http_error_rule.GetAllHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.GetAllHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetAllHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleGetAllHTTPErrorRuleFrontendHandler: http_error_rule.GetAllHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.GetAllHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetAllHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPRequestRuleGetAllHTTPRequestRuleBackendHandler: http_request_rule.GetAllHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.GetAllHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.GetAllHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleGetAllHTTPRequestRuleFrontendHandler: http_request_rule.GetAllHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.GetAllHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.GetAllHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleGetAllHTTPResponseRuleBackendHandler: http_response_rule.GetAllHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.GetAllHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.GetAllHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleGetAllHTTPResponseRuleFrontendHandler: http_response_rule.GetAllHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.GetAllHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.GetAllHTTPResponseRuleFrontend has not yet been implemented")
		}),
		LogTargetGetAllLogTargetBackendHandler: log_target.GetAllLogTargetBackendHandlerFunc(func(params log_target.GetAllLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetBackend has not yet been implemented")
		}),
		LogTargetGetAllLogTargetDefaultsHandler: log_target.GetAllLogTargetDefaultsHandlerFunc(func(params log_target.GetAllLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetDefaults has not yet been implemented")
		}),
		LogTargetGetAllLogTargetFrontendHandler: log_target.GetAllLogTargetFrontendHandlerFunc(func(params log_target.GetAllLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetFrontend has not yet been implemented")
		}),
		LogTargetGetAllLogTargetGlobalHandler: log_target.GetAllLogTargetGlobalHandlerFunc(func(params log_target.GetAllLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetGlobal has not yet been implemented")
		}),
		LogTargetGetAllLogTargetLogForwardHandler: log_target.GetAllLogTargetLogForwardHandlerFunc(func(params log_target.GetAllLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetLogForward has not yet been implemented")
		}),
		LogTargetGetAllLogTargetPeerHandler: log_target.GetAllLogTargetPeerHandlerFunc(func(params log_target.GetAllLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetAllLogTargetPeer has not yet been implemented")
		}),
		QUICInitialRuleGetAllQUICInitialRuleDefaultsHandler: quic_initial_rule.GetAllQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.GetAllQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.GetAllQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleGetAllQUICInitialRuleFrontendHandler: quic_initial_rule.GetAllQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.GetAllQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.GetAllQUICInitialRuleFrontend has not yet been implemented")
		}),
		MapsGetAllRuntimeMapFilesHandler: maps.GetAllRuntimeMapFilesHandlerFunc(func(params maps.GetAllRuntimeMapFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.GetAllRuntimeMapFiles has not yet been implemented")
		}),
		ServerGetAllRuntimeServerHandler: serverops.GetAllRuntimeServerHandlerFunc(func(params serverops.GetAllRuntimeServerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetAllRuntimeServer has not yet been implemented")
		}),
		ServerGetAllServerBackendHandler: serverops.GetAllServerBackendHandlerFunc(func(params serverops.GetAllServerBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetAllServerBackend has not yet been implemented")
		}),
		ServerGetAllServerPeerHandler: serverops.GetAllServerPeerHandlerFunc(func(params serverops.GetAllServerPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetAllServerPeer has not yet been implemented")
		}),
		ServerGetAllServerRingHandler: serverops.GetAllServerRingHandlerFunc(func(params serverops.GetAllServerRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetAllServerRing has not yet been implemented")
		}),
		SpoeGetAllSpoeAgentHandler: spoe.GetAllSpoeAgentHandlerFunc(func(params spoe.GetAllSpoeAgentParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetAllSpoeAgent has not yet been implemented")
		}),
		SpoeGetAllSpoeFilesHandler: spoe.GetAllSpoeFilesHandlerFunc(func(params spoe.GetAllSpoeFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetAllSpoeFiles has not yet been implemented")
		}),
		SpoeGetAllSpoeGroupHandler: spoe.GetAllSpoeGroupHandlerFunc(func(params spoe.GetAllSpoeGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetAllSpoeGroup has not yet been implemented")
		}),
		SpoeGetAllSpoeMessageHandler: spoe.GetAllSpoeMessageHandlerFunc(func(params spoe.GetAllSpoeMessageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetAllSpoeMessage has not yet been implemented")
		}),
		SpoeGetAllSpoeScopeHandler: spoe.GetAllSpoeScopeHandlerFunc(func(params spoe.GetAllSpoeScopeParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetAllSpoeScope has not yet been implemented")
		}),
		SpoeTransactionsGetAllSpoeTransactionHandler: spoe_transactions.GetAllSpoeTransactionHandlerFunc(func(params spoe_transactions.GetAllSpoeTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe_transactions.GetAllSpoeTransaction has not yet been implemented")
		}),
		StorageGetAllStorageGeneralFilesHandler: storage.GetAllStorageGeneralFilesHandlerFunc(func(params storage.GetAllStorageGeneralFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetAllStorageGeneralFiles has not yet been implemented")
		}),
		StorageGetAllStorageMapFilesHandler: storage.GetAllStorageMapFilesHandlerFunc(func(params storage.GetAllStorageMapFilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetAllStorageMapFiles has not yet been implemented")
		}),
		StorageGetAllStorageSSLCertificatesHandler: storage.GetAllStorageSSLCertificatesHandlerFunc(func(params storage.GetAllStorageSSLCertificatesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetAllStorageSSLCertificates has not yet been implemented")
		}),
		TCPCheckGetAllTCPCheckBackendHandler: tcp_check.GetAllTCPCheckBackendHandlerFunc(func(params tcp_check.GetAllTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.GetAllTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckGetAllTCPCheckDefaultsHandler: tcp_check.GetAllTCPCheckDefaultsHandlerFunc(func(params tcp_check.GetAllTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.GetAllTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleGetAllTCPRequestRuleBackendHandler: tcp_request_rule.GetAllTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.GetAllTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.GetAllTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleGetAllTCPRequestRuleFrontendHandler: tcp_request_rule.GetAllTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.GetAllTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.GetAllTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleGetAllTCPResponseRuleBackendHandler: tcp_response_rule.GetAllTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.GetAllTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.GetAllTCPResponseRuleBackend has not yet been implemented")
		}),
		BackendGetBackendHandler: backend.GetBackendHandlerFunc(func(params backend.GetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend.GetBackend has not yet been implemented")
		}),
		BackendSwitchingRuleGetBackendSwitchingRuleHandler: backend_switching_rule.GetBackendSwitchingRuleHandlerFunc(func(params backend_switching_rule.GetBackendSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.GetBackendSwitchingRule has not yet been implemented")
		}),
		BackendSwitchingRuleGetBackendSwitchingRulesHandler: backend_switching_rule.GetBackendSwitchingRulesHandlerFunc(func(params backend_switching_rule.GetBackendSwitchingRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.GetBackendSwitchingRules has not yet been implemented")
		}),
		BackendGetBackendsHandler: backend.GetBackendsHandlerFunc(func(params backend.GetBackendsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend.GetBackends has not yet been implemented")
		}),
		BindGetBindFrontendHandler: bind.GetBindFrontendHandlerFunc(func(params bind.GetBindFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetBindFrontend has not yet been implemented")
		}),
		BindGetBindLogForwardHandler: bind.GetBindLogForwardHandlerFunc(func(params bind.GetBindLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetBindLogForward has not yet been implemented")
		}),
		BindGetBindPeerHandler: bind.GetBindPeerHandlerFunc(func(params bind.GetBindPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.GetBindPeer has not yet been implemented")
		}),
		CacheGetCacheHandler: cache.GetCacheHandlerFunc(func(params cache.GetCacheParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cache.GetCache has not yet been implemented")
		}),
		CacheGetCachesHandler: cache.GetCachesHandlerFunc(func(params cache.GetCachesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cache.GetCaches has not yet been implemented")
		}),
		ClusterGetClusterHandler: cluster.GetClusterHandlerFunc(func(params cluster.GetClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cluster.GetCluster has not yet been implemented")
		}),
		DiscoveryGetConfigurationEndpointsHandler: discovery.GetConfigurationEndpointsHandlerFunc(func(params discovery.GetConfigurationEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetConfigurationEndpoints has not yet been implemented")
		}),
		ConfigurationGetConfigurationVersionHandler: configuration.GetConfigurationVersionHandlerFunc(func(params configuration.GetConfigurationVersionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation configuration.GetConfigurationVersion has not yet been implemented")
		}),
		ServiceDiscoveryGetConsulHandler: service_discovery.GetConsulHandlerFunc(func(params service_discovery.GetConsulParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.GetConsul has not yet been implemented")
		}),
		ServiceDiscoveryGetConsulsHandler: service_discovery.GetConsulsHandlerFunc(func(params service_discovery.GetConsulsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.GetConsuls has not yet been implemented")
		}),
		CrtLoadGetCrtLoadHandler: crt_load.GetCrtLoadHandlerFunc(func(params crt_load.GetCrtLoadParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_load.GetCrtLoad has not yet been implemented")
		}),
		CrtLoadGetCrtLoadsHandler: crt_load.GetCrtLoadsHandlerFunc(func(params crt_load.GetCrtLoadsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_load.GetCrtLoads has not yet been implemented")
		}),
		CrtStoreGetCrtStoreHandler: crt_store.GetCrtStoreHandlerFunc(func(params crt_store.GetCrtStoreParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_store.GetCrtStore has not yet been implemented")
		}),
		CrtStoreGetCrtStoresHandler: crt_store.GetCrtStoresHandlerFunc(func(params crt_store.GetCrtStoresParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_store.GetCrtStores has not yet been implemented")
		}),
		DeclareCaptureGetDeclareCaptureHandler: declare_capture.GetDeclareCaptureHandlerFunc(func(params declare_capture.GetDeclareCaptureParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.GetDeclareCapture has not yet been implemented")
		}),
		DeclareCaptureGetDeclareCapturesHandler: declare_capture.GetDeclareCapturesHandlerFunc(func(params declare_capture.GetDeclareCapturesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.GetDeclareCaptures has not yet been implemented")
		}),
		DefaultsGetDefaultsSectionHandler: defaults.GetDefaultsSectionHandlerFunc(func(params defaults.GetDefaultsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.GetDefaultsSection has not yet been implemented")
		}),
		DefaultsGetDefaultsSectionsHandler: defaults.GetDefaultsSectionsHandlerFunc(func(params defaults.GetDefaultsSectionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.GetDefaultsSections has not yet been implemented")
		}),
		DgramBindGetDgramBindHandler: dgram_bind.GetDgramBindHandlerFunc(func(params dgram_bind.GetDgramBindParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation dgram_bind.GetDgramBind has not yet been implemented")
		}),
		DgramBindGetDgramBindsHandler: dgram_bind.GetDgramBindsHandlerFunc(func(params dgram_bind.GetDgramBindsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation dgram_bind.GetDgramBinds has not yet been implemented")
		}),
		FCGIAppGetFCGIAppHandler: fcgi_app.GetFCGIAppHandlerFunc(func(params fcgi_app.GetFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation fcgi_app.GetFCGIApp has not yet been implemented")
		}),
		FCGIAppGetFCGIAppsHandler: fcgi_app.GetFCGIAppsHandlerFunc(func(params fcgi_app.GetFCGIAppsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation fcgi_app.GetFCGIApps has not yet been implemented")
		}),
		FilterGetFilterBackendHandler: filter.GetFilterBackendHandlerFunc(func(params filter.GetFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.GetFilterBackend has not yet been implemented")
		}),
		FilterGetFilterFrontendHandler: filter.GetFilterFrontendHandlerFunc(func(params filter.GetFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.GetFilterFrontend has not yet been implemented")
		}),
		FrontendGetFrontendHandler: frontend.GetFrontendHandlerFunc(func(params frontend.GetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation frontend.GetFrontend has not yet been implemented")
		}),
		FrontendGetFrontendsHandler: frontend.GetFrontendsHandlerFunc(func(params frontend.GetFrontendsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation frontend.GetFrontends has not yet been implemented")
		}),
		GlobalGetGlobalHandler: global.GetGlobalHandlerFunc(func(params global.GetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation global.GetGlobal has not yet been implemented")
		}),
		GroupGetGroupHandler: group.GetGroupHandlerFunc(func(params group.GetGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation group.GetGroup has not yet been implemented")
		}),
		GroupGetGroupsHandler: group.GetGroupsHandlerFunc(func(params group.GetGroupsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation group.GetGroups has not yet been implemented")
		}),
		ConfigurationGetHAProxyConfigurationHandler: configuration.GetHAProxyConfigurationHandlerFunc(func(params configuration.GetHAProxyConfigurationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation configuration.GetHAProxyConfiguration has not yet been implemented")
		}),
		HTTPAfterResponseRuleGetHTTPAfterResponseRuleBackendHandler: http_after_response_rule.GetHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.GetHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.GetHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleGetHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.GetHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.GetHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.GetHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckGetHTTPCheckBackendHandler: http_check.GetHTTPCheckBackendHandlerFunc(func(params http_check.GetHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.GetHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckGetHTTPCheckDefaultsHandler: http_check.GetHTTPCheckDefaultsHandlerFunc(func(params http_check.GetHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.GetHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleGetHTTPErrorRuleBackendHandler: http_error_rule.GetHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.GetHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleGetHTTPErrorRuleDefaultsHandler: http_error_rule.GetHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.GetHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleGetHTTPErrorRuleFrontendHandler: http_error_rule.GetHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.GetHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.GetHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPErrorsGetHTTPErrorsSectionHandler: http_errors.GetHTTPErrorsSectionHandlerFunc(func(params http_errors.GetHTTPErrorsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_errors.GetHTTPErrorsSection has not yet been implemented")
		}),
		HTTPErrorsGetHTTPErrorsSectionsHandler: http_errors.GetHTTPErrorsSectionsHandlerFunc(func(params http_errors.GetHTTPErrorsSectionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_errors.GetHTTPErrorsSections has not yet been implemented")
		}),
		HTTPRequestRuleGetHTTPRequestRuleBackendHandler: http_request_rule.GetHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.GetHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.GetHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleGetHTTPRequestRuleFrontendHandler: http_request_rule.GetHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.GetHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.GetHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleGetHTTPResponseRuleBackendHandler: http_response_rule.GetHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.GetHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.GetHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleGetHTTPResponseRuleFrontendHandler: http_response_rule.GetHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.GetHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.GetHTTPResponseRuleFrontend has not yet been implemented")
		}),
		DiscoveryGetHaproxyEndpointsHandler: discovery.GetHaproxyEndpointsHandlerFunc(func(params discovery.GetHaproxyEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetHaproxyEndpoints has not yet been implemented")
		}),
		InformationGetHaproxyProcessInfoHandler: information.GetHaproxyProcessInfoHandlerFunc(func(params information.GetHaproxyProcessInfoParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation information.GetHaproxyProcessInfo has not yet been implemented")
		}),
		HealthGetHealthHandler: health.GetHealthHandlerFunc(func(params health.GetHealthParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation health.GetHealth has not yet been implemented")
		}),
		InformationGetInfoHandler: information.GetInfoHandlerFunc(func(params information.GetInfoParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation information.GetInfo has not yet been implemented")
		}),
		LogForwardGetLogForwardHandler: log_forward.GetLogForwardHandlerFunc(func(params log_forward.GetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_forward.GetLogForward has not yet been implemented")
		}),
		LogForwardGetLogForwardsHandler: log_forward.GetLogForwardsHandlerFunc(func(params log_forward.GetLogForwardsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_forward.GetLogForwards has not yet been implemented")
		}),
		LogProfileGetLogProfileHandler: log_profile.GetLogProfileHandlerFunc(func(params log_profile.GetLogProfileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_profile.GetLogProfile has not yet been implemented")
		}),
		LogProfileGetLogProfilesHandler: log_profile.GetLogProfilesHandlerFunc(func(params log_profile.GetLogProfilesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_profile.GetLogProfiles has not yet been implemented")
		}),
		LogTargetGetLogTargetBackendHandler: log_target.GetLogTargetBackendHandlerFunc(func(params log_target.GetLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetBackend has not yet been implemented")
		}),
		LogTargetGetLogTargetDefaultsHandler: log_target.GetLogTargetDefaultsHandlerFunc(func(params log_target.GetLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetDefaults has not yet been implemented")
		}),
		LogTargetGetLogTargetFrontendHandler: log_target.GetLogTargetFrontendHandlerFunc(func(params log_target.GetLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetFrontend has not yet been implemented")
		}),
		LogTargetGetLogTargetGlobalHandler: log_target.GetLogTargetGlobalHandlerFunc(func(params log_target.GetLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetGlobal has not yet been implemented")
		}),
		LogTargetGetLogTargetLogForwardHandler: log_target.GetLogTargetLogForwardHandlerFunc(func(params log_target.GetLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetLogForward has not yet been implemented")
		}),
		LogTargetGetLogTargetPeerHandler: log_target.GetLogTargetPeerHandlerFunc(func(params log_target.GetLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.GetLogTargetPeer has not yet been implemented")
		}),
		MailerEntryGetMailerEntriesHandler: mailer_entry.GetMailerEntriesHandlerFunc(func(params mailer_entry.GetMailerEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailer_entry.GetMailerEntries has not yet been implemented")
		}),
		MailerEntryGetMailerEntryHandler: mailer_entry.GetMailerEntryHandlerFunc(func(params mailer_entry.GetMailerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailer_entry.GetMailerEntry has not yet been implemented")
		}),
		MailersGetMailersSectionHandler: mailers.GetMailersSectionHandlerFunc(func(params mailers.GetMailersSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailers.GetMailersSection has not yet been implemented")
		}),
		MailersGetMailersSectionsHandler: mailers.GetMailersSectionsHandlerFunc(func(params mailers.GetMailersSectionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailers.GetMailersSections has not yet been implemented")
		}),
		NameserverGetNameserverHandler: nameserver.GetNameserverHandlerFunc(func(params nameserver.GetNameserverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation nameserver.GetNameserver has not yet been implemented")
		}),
		NameserverGetNameserversHandler: nameserver.GetNameserversHandlerFunc(func(params nameserver.GetNameserversParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation nameserver.GetNameservers has not yet been implemented")
		}),
		MapsGetOneRuntimeMapHandler: maps.GetOneRuntimeMapHandlerFunc(func(params maps.GetOneRuntimeMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.GetOneRuntimeMap has not yet been implemented")
		}),
		SpoeGetOneSpoeFileHandler: spoe.GetOneSpoeFileHandlerFunc(func(params spoe.GetOneSpoeFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetOneSpoeFile has not yet been implemented")
		}),
		StorageGetOneStorageGeneralFileHandler: storage.GetOneStorageGeneralFileHandlerFunc(func(params storage.GetOneStorageGeneralFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetOneStorageGeneralFile has not yet been implemented")
		}),
		StorageGetOneStorageMapHandler: storage.GetOneStorageMapHandlerFunc(func(params storage.GetOneStorageMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetOneStorageMap has not yet been implemented")
		}),
		StorageGetOneStorageSSLCertificateHandler: storage.GetOneStorageSSLCertificateHandlerFunc(func(params storage.GetOneStorageSSLCertificateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.GetOneStorageSSLCertificate has not yet been implemented")
		}),
		Version3GetOpenapiv3SpecificationHandler: version3.GetOpenapiv3SpecificationHandlerFunc(func(params version3.GetOpenapiv3SpecificationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation version3.GetOpenapiv3Specification has not yet been implemented")
		}),
		PeerEntryGetPeerEntriesHandler: peer_entry.GetPeerEntriesHandlerFunc(func(params peer_entry.GetPeerEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer_entry.GetPeerEntries has not yet been implemented")
		}),
		PeerEntryGetPeerEntryHandler: peer_entry.GetPeerEntryHandlerFunc(func(params peer_entry.GetPeerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer_entry.GetPeerEntry has not yet been implemented")
		}),
		PeerGetPeerSectionHandler: peer.GetPeerSectionHandlerFunc(func(params peer.GetPeerSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer.GetPeerSection has not yet been implemented")
		}),
		PeerGetPeerSectionsHandler: peer.GetPeerSectionsHandlerFunc(func(params peer.GetPeerSectionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer.GetPeerSections has not yet been implemented")
		}),
		ProcessManagerGetProgramHandler: process_manager.GetProgramHandlerFunc(func(params process_manager.GetProgramParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation process_manager.GetProgram has not yet been implemented")
		}),
		ProcessManagerGetProgramsHandler: process_manager.GetProgramsHandlerFunc(func(params process_manager.GetProgramsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation process_manager.GetPrograms has not yet been implemented")
		}),
		QUICInitialRuleGetQUICInitialRuleDefaultsHandler: quic_initial_rule.GetQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.GetQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.GetQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleGetQUICInitialRuleFrontendHandler: quic_initial_rule.GetQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.GetQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.GetQUICInitialRuleFrontend has not yet been implemented")
		}),
		ReloadsGetReloadHandler: reloads.GetReloadHandlerFunc(func(params reloads.GetReloadParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation reloads.GetReload has not yet been implemented")
		}),
		ReloadsGetReloadsHandler: reloads.GetReloadsHandlerFunc(func(params reloads.GetReloadsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation reloads.GetReloads has not yet been implemented")
		}),
		ResolverGetResolverHandler: resolver.GetResolverHandlerFunc(func(params resolver.GetResolverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation resolver.GetResolver has not yet been implemented")
		}),
		ResolverGetResolversHandler: resolver.GetResolversHandlerFunc(func(params resolver.GetResolversParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation resolver.GetResolvers has not yet been implemented")
		}),
		RingGetRingHandler: ring.GetRingHandlerFunc(func(params ring.GetRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ring.GetRing has not yet been implemented")
		}),
		RingGetRingsHandler: ring.GetRingsHandlerFunc(func(params ring.GetRingsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ring.GetRings has not yet been implemented")
		}),
		DiscoveryGetRuntimeEndpointsHandler: discovery.GetRuntimeEndpointsHandlerFunc(func(params discovery.GetRuntimeEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetRuntimeEndpoints has not yet been implemented")
		}),
		MapsGetRuntimeMapEntryHandler: maps.GetRuntimeMapEntryHandlerFunc(func(params maps.GetRuntimeMapEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.GetRuntimeMapEntry has not yet been implemented")
		}),
		ServerGetRuntimeServerHandler: serverops.GetRuntimeServerHandlerFunc(func(params serverops.GetRuntimeServerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetRuntimeServer has not yet been implemented")
		}),
		ServerGetServerBackendHandler: serverops.GetServerBackendHandlerFunc(func(params serverops.GetServerBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetServerBackend has not yet been implemented")
		}),
		ServerGetServerPeerHandler: serverops.GetServerPeerHandlerFunc(func(params serverops.GetServerPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetServerPeer has not yet been implemented")
		}),
		ServerGetServerRingHandler: serverops.GetServerRingHandlerFunc(func(params serverops.GetServerRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.GetServerRing has not yet been implemented")
		}),
		ServerSwitchingRuleGetServerSwitchingRuleHandler: server_switching_rule.GetServerSwitchingRuleHandlerFunc(func(params server_switching_rule.GetServerSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.GetServerSwitchingRule has not yet been implemented")
		}),
		ServerSwitchingRuleGetServerSwitchingRulesHandler: server_switching_rule.GetServerSwitchingRulesHandlerFunc(func(params server_switching_rule.GetServerSwitchingRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.GetServerSwitchingRules has not yet been implemented")
		}),
		ServerTemplateGetServerTemplateHandler: server_template.GetServerTemplateHandlerFunc(func(params server_template.GetServerTemplateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_template.GetServerTemplate has not yet been implemented")
		}),
		ServerTemplateGetServerTemplatesHandler: server_template.GetServerTemplatesHandlerFunc(func(params server_template.GetServerTemplatesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_template.GetServerTemplates has not yet been implemented")
		}),
		DiscoveryGetServicesEndpointsHandler: discovery.GetServicesEndpointsHandlerFunc(func(params discovery.GetServicesEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetServicesEndpoints has not yet been implemented")
		}),
		SitesGetSiteHandler: sites.GetSiteHandlerFunc(func(params sites.GetSiteParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation sites.GetSite has not yet been implemented")
		}),
		SitesGetSitesHandler: sites.GetSitesHandlerFunc(func(params sites.GetSitesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation sites.GetSites has not yet been implemented")
		}),
		SpecificationGetSpecificationHandler: specification.GetSpecificationHandlerFunc(func(params specification.GetSpecificationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation specification.GetSpecification has not yet been implemented")
		}),
		SpoeGetSpoeAgentHandler: spoe.GetSpoeAgentHandlerFunc(func(params spoe.GetSpoeAgentParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetSpoeAgent has not yet been implemented")
		}),
		SpoeGetSpoeConfigurationVersionHandler: spoe.GetSpoeConfigurationVersionHandlerFunc(func(params spoe.GetSpoeConfigurationVersionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetSpoeConfigurationVersion has not yet been implemented")
		}),
		DiscoveryGetSpoeEndpointsHandler: discovery.GetSpoeEndpointsHandlerFunc(func(params discovery.GetSpoeEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetSpoeEndpoints has not yet been implemented")
		}),
		SpoeGetSpoeGroupHandler: spoe.GetSpoeGroupHandlerFunc(func(params spoe.GetSpoeGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetSpoeGroup has not yet been implemented")
		}),
		SpoeGetSpoeMessageHandler: spoe.GetSpoeMessageHandlerFunc(func(params spoe.GetSpoeMessageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetSpoeMessage has not yet been implemented")
		}),
		SpoeGetSpoeScopeHandler: spoe.GetSpoeScopeHandlerFunc(func(params spoe.GetSpoeScopeParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.GetSpoeScope has not yet been implemented")
		}),
		SpoeTransactionsGetSpoeTransactionHandler: spoe_transactions.GetSpoeTransactionHandlerFunc(func(params spoe_transactions.GetSpoeTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe_transactions.GetSpoeTransaction has not yet been implemented")
		}),
		StatsGetStatsHandler: stats.GetStatsHandlerFunc(func(params stats.GetStatsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stats.GetStats has not yet been implemented")
		}),
		DiscoveryGetStatsEndpointsHandler: discovery.GetStatsEndpointsHandlerFunc(func(params discovery.GetStatsEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetStatsEndpoints has not yet been implemented")
		}),
		StickRuleGetStickRuleHandler: stick_rule.GetStickRuleHandlerFunc(func(params stick_rule.GetStickRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.GetStickRule has not yet been implemented")
		}),
		StickRuleGetStickRulesHandler: stick_rule.GetStickRulesHandlerFunc(func(params stick_rule.GetStickRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.GetStickRules has not yet been implemented")
		}),
		StickTableGetStickTableHandler: stick_table.GetStickTableHandlerFunc(func(params stick_table.GetStickTableParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_table.GetStickTable has not yet been implemented")
		}),
		StickTableGetStickTableEntriesHandler: stick_table.GetStickTableEntriesHandlerFunc(func(params stick_table.GetStickTableEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_table.GetStickTableEntries has not yet been implemented")
		}),
		StickTableGetStickTablesHandler: stick_table.GetStickTablesHandlerFunc(func(params stick_table.GetStickTablesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_table.GetStickTables has not yet been implemented")
		}),
		DiscoveryGetStorageEndpointsHandler: discovery.GetStorageEndpointsHandlerFunc(func(params discovery.GetStorageEndpointsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation discovery.GetStorageEndpoints has not yet been implemented")
		}),
		TCPCheckGetTCPCheckBackendHandler: tcp_check.GetTCPCheckBackendHandlerFunc(func(params tcp_check.GetTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.GetTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckGetTCPCheckDefaultsHandler: tcp_check.GetTCPCheckDefaultsHandlerFunc(func(params tcp_check.GetTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.GetTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleGetTCPRequestRuleBackendHandler: tcp_request_rule.GetTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.GetTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.GetTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleGetTCPRequestRuleFrontendHandler: tcp_request_rule.GetTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.GetTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.GetTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleGetTCPResponseRuleBackendHandler: tcp_response_rule.GetTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.GetTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.GetTCPResponseRuleBackend has not yet been implemented")
		}),
		TableGetTableHandler: table.GetTableHandlerFunc(func(params table.GetTableParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation table.GetTable has not yet been implemented")
		}),
		TableGetTablesHandler: table.GetTablesHandlerFunc(func(params table.GetTablesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation table.GetTables has not yet been implemented")
		}),
		TracesGetTracesHandler: traces.GetTracesHandlerFunc(func(params traces.GetTracesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.GetTraces has not yet been implemented")
		}),
		TransactionsGetTransactionHandler: transactions.GetTransactionHandlerFunc(func(params transactions.GetTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation transactions.GetTransaction has not yet been implemented")
		}),
		TransactionsGetTransactionsHandler: transactions.GetTransactionsHandlerFunc(func(params transactions.GetTransactionsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation transactions.GetTransactions has not yet been implemented")
		}),
		UserGetUserHandler: user.GetUserHandlerFunc(func(params user.GetUserParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation user.GetUser has not yet been implemented")
		}),
		UserlistGetUserlistHandler: userlist.GetUserlistHandlerFunc(func(params userlist.GetUserlistParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation userlist.GetUserlist has not yet been implemented")
		}),
		UserlistGetUserlistsHandler: userlist.GetUserlistsHandlerFunc(func(params userlist.GetUserlistsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation userlist.GetUserlists has not yet been implemented")
		}),
		UserGetUsersHandler: user.GetUsersHandlerFunc(func(params user.GetUsersParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation user.GetUsers has not yet been implemented")
		}),
		ClusterInitiateCertificateRefreshHandler: cluster.InitiateCertificateRefreshHandlerFunc(func(params cluster.InitiateCertificateRefreshParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cluster.InitiateCertificateRefresh has not yet been implemented")
		}),
		ClusterPostClusterHandler: cluster.PostClusterHandlerFunc(func(params cluster.PostClusterParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cluster.PostCluster has not yet been implemented")
		}),
		ConfigurationPostHAProxyConfigurationHandler: configuration.PostHAProxyConfigurationHandlerFunc(func(params configuration.PostHAProxyConfigurationParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation configuration.PostHAProxyConfiguration has not yet been implemented")
		}),
		ServiceDiscoveryReplaceAWSRegionHandler: service_discovery.ReplaceAWSRegionHandlerFunc(func(params service_discovery.ReplaceAWSRegionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.ReplaceAWSRegion has not yet been implemented")
		}),
		ACLReplaceACLBackendHandler: acl.ReplaceACLBackendHandlerFunc(func(params acl.ReplaceACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceACLBackend has not yet been implemented")
		}),
		ACLReplaceACLFCGIAppHandler: acl.ReplaceACLFCGIAppHandlerFunc(func(params acl.ReplaceACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceACLFCGIApp has not yet been implemented")
		}),
		ACLReplaceACLFrontendHandler: acl.ReplaceACLFrontendHandlerFunc(func(params acl.ReplaceACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceACLFrontend has not yet been implemented")
		}),
		ACLReplaceAllACLBackendHandler: acl.ReplaceAllACLBackendHandlerFunc(func(params acl.ReplaceAllACLBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceAllACLBackend has not yet been implemented")
		}),
		ACLReplaceAllACLFCGIAppHandler: acl.ReplaceAllACLFCGIAppHandlerFunc(func(params acl.ReplaceAllACLFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceAllACLFCGIApp has not yet been implemented")
		}),
		ACLReplaceAllACLFrontendHandler: acl.ReplaceAllACLFrontendHandlerFunc(func(params acl.ReplaceAllACLFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation acl.ReplaceAllACLFrontend has not yet been implemented")
		}),
		FilterReplaceAllFilterBackendHandler: filter.ReplaceAllFilterBackendHandlerFunc(func(params filter.ReplaceAllFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.ReplaceAllFilterBackend has not yet been implemented")
		}),
		FilterReplaceAllFilterFrontendHandler: filter.ReplaceAllFilterFrontendHandlerFunc(func(params filter.ReplaceAllFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.ReplaceAllFilterFrontend has not yet been implemented")
		}),
		HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleBackendHandler: http_after_response_rule.ReplaceAllHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.ReplaceAllHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.ReplaceAllHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.ReplaceAllHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.ReplaceAllHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.ReplaceAllHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckReplaceAllHTTPCheckBackendHandler: http_check.ReplaceAllHTTPCheckBackendHandlerFunc(func(params http_check.ReplaceAllHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.ReplaceAllHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckReplaceAllHTTPCheckDefaultsHandler: http_check.ReplaceAllHTTPCheckDefaultsHandlerFunc(func(params http_check.ReplaceAllHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.ReplaceAllHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleReplaceAllHTTPErrorRuleBackendHandler: http_error_rule.ReplaceAllHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.ReplaceAllHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceAllHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleReplaceAllHTTPErrorRuleDefaultsHandler: http_error_rule.ReplaceAllHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.ReplaceAllHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceAllHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleReplaceAllHTTPErrorRuleFrontendHandler: http_error_rule.ReplaceAllHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.ReplaceAllHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceAllHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPRequestRuleReplaceAllHTTPRequestRuleBackendHandler: http_request_rule.ReplaceAllHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.ReplaceAllHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.ReplaceAllHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleReplaceAllHTTPRequestRuleFrontendHandler: http_request_rule.ReplaceAllHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.ReplaceAllHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.ReplaceAllHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleReplaceAllHTTPResponseRuleBackendHandler: http_response_rule.ReplaceAllHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.ReplaceAllHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.ReplaceAllHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleReplaceAllHTTPResponseRuleFrontendHandler: http_response_rule.ReplaceAllHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.ReplaceAllHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.ReplaceAllHTTPResponseRuleFrontend has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetBackendHandler: log_target.ReplaceAllLogTargetBackendHandlerFunc(func(params log_target.ReplaceAllLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetBackend has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetDefaultsHandler: log_target.ReplaceAllLogTargetDefaultsHandlerFunc(func(params log_target.ReplaceAllLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetDefaults has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetFrontendHandler: log_target.ReplaceAllLogTargetFrontendHandlerFunc(func(params log_target.ReplaceAllLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetFrontend has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetGlobalHandler: log_target.ReplaceAllLogTargetGlobalHandlerFunc(func(params log_target.ReplaceAllLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetGlobal has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetLogForwardHandler: log_target.ReplaceAllLogTargetLogForwardHandlerFunc(func(params log_target.ReplaceAllLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetLogForward has not yet been implemented")
		}),
		LogTargetReplaceAllLogTargetPeerHandler: log_target.ReplaceAllLogTargetPeerHandlerFunc(func(params log_target.ReplaceAllLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceAllLogTargetPeer has not yet been implemented")
		}),
		QUICInitialRuleReplaceAllQUICInitialRuleDefaultsHandler: quic_initial_rule.ReplaceAllQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.ReplaceAllQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.ReplaceAllQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleReplaceAllQUICInitialRuleFrontendHandler: quic_initial_rule.ReplaceAllQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.ReplaceAllQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.ReplaceAllQUICInitialRuleFrontend has not yet been implemented")
		}),
		TCPCheckReplaceAllTCPCheckBackendHandler: tcp_check.ReplaceAllTCPCheckBackendHandlerFunc(func(params tcp_check.ReplaceAllTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.ReplaceAllTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckReplaceAllTCPCheckDefaultsHandler: tcp_check.ReplaceAllTCPCheckDefaultsHandlerFunc(func(params tcp_check.ReplaceAllTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.ReplaceAllTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleReplaceAllTCPRequestRuleBackendHandler: tcp_request_rule.ReplaceAllTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.ReplaceAllTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.ReplaceAllTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleReplaceAllTCPRequestRuleFrontendHandler: tcp_request_rule.ReplaceAllTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.ReplaceAllTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.ReplaceAllTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleReplaceAllTCPResponseRuleBackendHandler: tcp_response_rule.ReplaceAllTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.ReplaceAllTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.ReplaceAllTCPResponseRuleBackend has not yet been implemented")
		}),
		BackendReplaceBackendHandler: backend.ReplaceBackendHandlerFunc(func(params backend.ReplaceBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend.ReplaceBackend has not yet been implemented")
		}),
		BackendSwitchingRuleReplaceBackendSwitchingRuleHandler: backend_switching_rule.ReplaceBackendSwitchingRuleHandlerFunc(func(params backend_switching_rule.ReplaceBackendSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.ReplaceBackendSwitchingRule has not yet been implemented")
		}),
		BackendSwitchingRuleReplaceBackendSwitchingRulesHandler: backend_switching_rule.ReplaceBackendSwitchingRulesHandlerFunc(func(params backend_switching_rule.ReplaceBackendSwitchingRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation backend_switching_rule.ReplaceBackendSwitchingRules has not yet been implemented")
		}),
		BindReplaceBindFrontendHandler: bind.ReplaceBindFrontendHandlerFunc(func(params bind.ReplaceBindFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.ReplaceBindFrontend has not yet been implemented")
		}),
		BindReplaceBindLogForwardHandler: bind.ReplaceBindLogForwardHandlerFunc(func(params bind.ReplaceBindLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.ReplaceBindLogForward has not yet been implemented")
		}),
		BindReplaceBindPeerHandler: bind.ReplaceBindPeerHandlerFunc(func(params bind.ReplaceBindPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation bind.ReplaceBindPeer has not yet been implemented")
		}),
		CacheReplaceCacheHandler: cache.ReplaceCacheHandlerFunc(func(params cache.ReplaceCacheParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation cache.ReplaceCache has not yet been implemented")
		}),
		ServiceDiscoveryReplaceConsulHandler: service_discovery.ReplaceConsulHandlerFunc(func(params service_discovery.ReplaceConsulParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation service_discovery.ReplaceConsul has not yet been implemented")
		}),
		CrtLoadReplaceCrtLoadHandler: crt_load.ReplaceCrtLoadHandlerFunc(func(params crt_load.ReplaceCrtLoadParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation crt_load.ReplaceCrtLoad has not yet been implemented")
		}),
		DeclareCaptureReplaceDeclareCaptureHandler: declare_capture.ReplaceDeclareCaptureHandlerFunc(func(params declare_capture.ReplaceDeclareCaptureParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.ReplaceDeclareCapture has not yet been implemented")
		}),
		DeclareCaptureReplaceDeclareCapturesHandler: declare_capture.ReplaceDeclareCapturesHandlerFunc(func(params declare_capture.ReplaceDeclareCapturesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation declare_capture.ReplaceDeclareCaptures has not yet been implemented")
		}),
		DefaultsReplaceDefaultsSectionHandler: defaults.ReplaceDefaultsSectionHandlerFunc(func(params defaults.ReplaceDefaultsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation defaults.ReplaceDefaultsSection has not yet been implemented")
		}),
		DgramBindReplaceDgramBindHandler: dgram_bind.ReplaceDgramBindHandlerFunc(func(params dgram_bind.ReplaceDgramBindParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation dgram_bind.ReplaceDgramBind has not yet been implemented")
		}),
		FCGIAppReplaceFCGIAppHandler: fcgi_app.ReplaceFCGIAppHandlerFunc(func(params fcgi_app.ReplaceFCGIAppParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation fcgi_app.ReplaceFCGIApp has not yet been implemented")
		}),
		FilterReplaceFilterBackendHandler: filter.ReplaceFilterBackendHandlerFunc(func(params filter.ReplaceFilterBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.ReplaceFilterBackend has not yet been implemented")
		}),
		FilterReplaceFilterFrontendHandler: filter.ReplaceFilterFrontendHandlerFunc(func(params filter.ReplaceFilterFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation filter.ReplaceFilterFrontend has not yet been implemented")
		}),
		FrontendReplaceFrontendHandler: frontend.ReplaceFrontendHandlerFunc(func(params frontend.ReplaceFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation frontend.ReplaceFrontend has not yet been implemented")
		}),
		GlobalReplaceGlobalHandler: global.ReplaceGlobalHandlerFunc(func(params global.ReplaceGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation global.ReplaceGlobal has not yet been implemented")
		}),
		GroupReplaceGroupHandler: group.ReplaceGroupHandlerFunc(func(params group.ReplaceGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation group.ReplaceGroup has not yet been implemented")
		}),
		HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleBackendHandler: http_after_response_rule.ReplaceHTTPAfterResponseRuleBackendHandlerFunc(func(params http_after_response_rule.ReplaceHTTPAfterResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.ReplaceHTTPAfterResponseRuleBackend has not yet been implemented")
		}),
		HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleFrontendHandler: http_after_response_rule.ReplaceHTTPAfterResponseRuleFrontendHandlerFunc(func(params http_after_response_rule.ReplaceHTTPAfterResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_after_response_rule.ReplaceHTTPAfterResponseRuleFrontend has not yet been implemented")
		}),
		HTTPCheckReplaceHTTPCheckBackendHandler: http_check.ReplaceHTTPCheckBackendHandlerFunc(func(params http_check.ReplaceHTTPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.ReplaceHTTPCheckBackend has not yet been implemented")
		}),
		HTTPCheckReplaceHTTPCheckDefaultsHandler: http_check.ReplaceHTTPCheckDefaultsHandlerFunc(func(params http_check.ReplaceHTTPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_check.ReplaceHTTPCheckDefaults has not yet been implemented")
		}),
		HTTPErrorRuleReplaceHTTPErrorRuleBackendHandler: http_error_rule.ReplaceHTTPErrorRuleBackendHandlerFunc(func(params http_error_rule.ReplaceHTTPErrorRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceHTTPErrorRuleBackend has not yet been implemented")
		}),
		HTTPErrorRuleReplaceHTTPErrorRuleDefaultsHandler: http_error_rule.ReplaceHTTPErrorRuleDefaultsHandlerFunc(func(params http_error_rule.ReplaceHTTPErrorRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceHTTPErrorRuleDefaults has not yet been implemented")
		}),
		HTTPErrorRuleReplaceHTTPErrorRuleFrontendHandler: http_error_rule.ReplaceHTTPErrorRuleFrontendHandlerFunc(func(params http_error_rule.ReplaceHTTPErrorRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_error_rule.ReplaceHTTPErrorRuleFrontend has not yet been implemented")
		}),
		HTTPErrorsReplaceHTTPErrorsSectionHandler: http_errors.ReplaceHTTPErrorsSectionHandlerFunc(func(params http_errors.ReplaceHTTPErrorsSectionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_errors.ReplaceHTTPErrorsSection has not yet been implemented")
		}),
		HTTPRequestRuleReplaceHTTPRequestRuleBackendHandler: http_request_rule.ReplaceHTTPRequestRuleBackendHandlerFunc(func(params http_request_rule.ReplaceHTTPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.ReplaceHTTPRequestRuleBackend has not yet been implemented")
		}),
		HTTPRequestRuleReplaceHTTPRequestRuleFrontendHandler: http_request_rule.ReplaceHTTPRequestRuleFrontendHandlerFunc(func(params http_request_rule.ReplaceHTTPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_request_rule.ReplaceHTTPRequestRuleFrontend has not yet been implemented")
		}),
		HTTPResponseRuleReplaceHTTPResponseRuleBackendHandler: http_response_rule.ReplaceHTTPResponseRuleBackendHandlerFunc(func(params http_response_rule.ReplaceHTTPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.ReplaceHTTPResponseRuleBackend has not yet been implemented")
		}),
		HTTPResponseRuleReplaceHTTPResponseRuleFrontendHandler: http_response_rule.ReplaceHTTPResponseRuleFrontendHandlerFunc(func(params http_response_rule.ReplaceHTTPResponseRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation http_response_rule.ReplaceHTTPResponseRuleFrontend has not yet been implemented")
		}),
		LogForwardReplaceLogForwardHandler: log_forward.ReplaceLogForwardHandlerFunc(func(params log_forward.ReplaceLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_forward.ReplaceLogForward has not yet been implemented")
		}),
		LogTargetReplaceLogTargetBackendHandler: log_target.ReplaceLogTargetBackendHandlerFunc(func(params log_target.ReplaceLogTargetBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetBackend has not yet been implemented")
		}),
		LogTargetReplaceLogTargetDefaultsHandler: log_target.ReplaceLogTargetDefaultsHandlerFunc(func(params log_target.ReplaceLogTargetDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetDefaults has not yet been implemented")
		}),
		LogTargetReplaceLogTargetFrontendHandler: log_target.ReplaceLogTargetFrontendHandlerFunc(func(params log_target.ReplaceLogTargetFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetFrontend has not yet been implemented")
		}),
		LogTargetReplaceLogTargetGlobalHandler: log_target.ReplaceLogTargetGlobalHandlerFunc(func(params log_target.ReplaceLogTargetGlobalParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetGlobal has not yet been implemented")
		}),
		LogTargetReplaceLogTargetLogForwardHandler: log_target.ReplaceLogTargetLogForwardHandlerFunc(func(params log_target.ReplaceLogTargetLogForwardParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetLogForward has not yet been implemented")
		}),
		LogTargetReplaceLogTargetPeerHandler: log_target.ReplaceLogTargetPeerHandlerFunc(func(params log_target.ReplaceLogTargetPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation log_target.ReplaceLogTargetPeer has not yet been implemented")
		}),
		MailerEntryReplaceMailerEntryHandler: mailer_entry.ReplaceMailerEntryHandlerFunc(func(params mailer_entry.ReplaceMailerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation mailer_entry.ReplaceMailerEntry has not yet been implemented")
		}),
		NameserverReplaceNameserverHandler: nameserver.ReplaceNameserverHandlerFunc(func(params nameserver.ReplaceNameserverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation nameserver.ReplaceNameserver has not yet been implemented")
		}),
		PeerEntryReplacePeerEntryHandler: peer_entry.ReplacePeerEntryHandlerFunc(func(params peer_entry.ReplacePeerEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation peer_entry.ReplacePeerEntry has not yet been implemented")
		}),
		ProcessManagerReplaceProgramHandler: process_manager.ReplaceProgramHandlerFunc(func(params process_manager.ReplaceProgramParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation process_manager.ReplaceProgram has not yet been implemented")
		}),
		QUICInitialRuleReplaceQUICInitialRuleDefaultsHandler: quic_initial_rule.ReplaceQUICInitialRuleDefaultsHandlerFunc(func(params quic_initial_rule.ReplaceQUICInitialRuleDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.ReplaceQUICInitialRuleDefaults has not yet been implemented")
		}),
		QUICInitialRuleReplaceQUICInitialRuleFrontendHandler: quic_initial_rule.ReplaceQUICInitialRuleFrontendHandlerFunc(func(params quic_initial_rule.ReplaceQUICInitialRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation quic_initial_rule.ReplaceQUICInitialRuleFrontend has not yet been implemented")
		}),
		ResolverReplaceResolverHandler: resolver.ReplaceResolverHandlerFunc(func(params resolver.ReplaceResolverParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation resolver.ReplaceResolver has not yet been implemented")
		}),
		RingReplaceRingHandler: ring.ReplaceRingHandlerFunc(func(params ring.ReplaceRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation ring.ReplaceRing has not yet been implemented")
		}),
		MapsReplaceRuntimeMapEntryHandler: maps.ReplaceRuntimeMapEntryHandlerFunc(func(params maps.ReplaceRuntimeMapEntryParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.ReplaceRuntimeMapEntry has not yet been implemented")
		}),
		ServerReplaceRuntimeServerHandler: serverops.ReplaceRuntimeServerHandlerFunc(func(params serverops.ReplaceRuntimeServerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.ReplaceRuntimeServer has not yet been implemented")
		}),
		ServerReplaceServerBackendHandler: serverops.ReplaceServerBackendHandlerFunc(func(params serverops.ReplaceServerBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.ReplaceServerBackend has not yet been implemented")
		}),
		ServerReplaceServerPeerHandler: serverops.ReplaceServerPeerHandlerFunc(func(params serverops.ReplaceServerPeerParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.ReplaceServerPeer has not yet been implemented")
		}),
		ServerReplaceServerRingHandler: serverops.ReplaceServerRingHandlerFunc(func(params serverops.ReplaceServerRingParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server.ReplaceServerRing has not yet been implemented")
		}),
		ServerSwitchingRuleReplaceServerSwitchingRuleHandler: server_switching_rule.ReplaceServerSwitchingRuleHandlerFunc(func(params server_switching_rule.ReplaceServerSwitchingRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.ReplaceServerSwitchingRule has not yet been implemented")
		}),
		ServerSwitchingRuleReplaceServerSwitchingRulesHandler: server_switching_rule.ReplaceServerSwitchingRulesHandlerFunc(func(params server_switching_rule.ReplaceServerSwitchingRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_switching_rule.ReplaceServerSwitchingRules has not yet been implemented")
		}),
		ServerTemplateReplaceServerTemplateHandler: server_template.ReplaceServerTemplateHandlerFunc(func(params server_template.ReplaceServerTemplateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation server_template.ReplaceServerTemplate has not yet been implemented")
		}),
		SitesReplaceSiteHandler: sites.ReplaceSiteHandlerFunc(func(params sites.ReplaceSiteParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation sites.ReplaceSite has not yet been implemented")
		}),
		SpoeReplaceSpoeAgentHandler: spoe.ReplaceSpoeAgentHandlerFunc(func(params spoe.ReplaceSpoeAgentParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.ReplaceSpoeAgent has not yet been implemented")
		}),
		SpoeReplaceSpoeGroupHandler: spoe.ReplaceSpoeGroupHandlerFunc(func(params spoe.ReplaceSpoeGroupParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.ReplaceSpoeGroup has not yet been implemented")
		}),
		SpoeReplaceSpoeMessageHandler: spoe.ReplaceSpoeMessageHandlerFunc(func(params spoe.ReplaceSpoeMessageParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe.ReplaceSpoeMessage has not yet been implemented")
		}),
		StickRuleReplaceStickRuleHandler: stick_rule.ReplaceStickRuleHandlerFunc(func(params stick_rule.ReplaceStickRuleParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.ReplaceStickRule has not yet been implemented")
		}),
		StickRuleReplaceStickRulesHandler: stick_rule.ReplaceStickRulesHandlerFunc(func(params stick_rule.ReplaceStickRulesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_rule.ReplaceStickRules has not yet been implemented")
		}),
		StorageReplaceStorageGeneralFileHandler: storage.ReplaceStorageGeneralFileHandlerFunc(func(params storage.ReplaceStorageGeneralFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.ReplaceStorageGeneralFile has not yet been implemented")
		}),
		StorageReplaceStorageMapFileHandler: storage.ReplaceStorageMapFileHandlerFunc(func(params storage.ReplaceStorageMapFileParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.ReplaceStorageMapFile has not yet been implemented")
		}),
		StorageReplaceStorageSSLCertificateHandler: storage.ReplaceStorageSSLCertificateHandlerFunc(func(params storage.ReplaceStorageSSLCertificateParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation storage.ReplaceStorageSSLCertificate has not yet been implemented")
		}),
		TCPCheckReplaceTCPCheckBackendHandler: tcp_check.ReplaceTCPCheckBackendHandlerFunc(func(params tcp_check.ReplaceTCPCheckBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.ReplaceTCPCheckBackend has not yet been implemented")
		}),
		TCPCheckReplaceTCPCheckDefaultsHandler: tcp_check.ReplaceTCPCheckDefaultsHandlerFunc(func(params tcp_check.ReplaceTCPCheckDefaultsParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_check.ReplaceTCPCheckDefaults has not yet been implemented")
		}),
		TCPRequestRuleReplaceTCPRequestRuleBackendHandler: tcp_request_rule.ReplaceTCPRequestRuleBackendHandlerFunc(func(params tcp_request_rule.ReplaceTCPRequestRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.ReplaceTCPRequestRuleBackend has not yet been implemented")
		}),
		TCPRequestRuleReplaceTCPRequestRuleFrontendHandler: tcp_request_rule.ReplaceTCPRequestRuleFrontendHandlerFunc(func(params tcp_request_rule.ReplaceTCPRequestRuleFrontendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_request_rule.ReplaceTCPRequestRuleFrontend has not yet been implemented")
		}),
		TCPResponseRuleReplaceTCPResponseRuleBackendHandler: tcp_response_rule.ReplaceTCPResponseRuleBackendHandlerFunc(func(params tcp_response_rule.ReplaceTCPResponseRuleBackendParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation tcp_response_rule.ReplaceTCPResponseRuleBackend has not yet been implemented")
		}),
		TableReplaceTableHandler: table.ReplaceTableHandlerFunc(func(params table.ReplaceTableParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation table.ReplaceTable has not yet been implemented")
		}),
		TracesReplaceTracesHandler: traces.ReplaceTracesHandlerFunc(func(params traces.ReplaceTracesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation traces.ReplaceTraces has not yet been implemented")
		}),
		UserReplaceUserHandler: user.ReplaceUserHandlerFunc(func(params user.ReplaceUserParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation user.ReplaceUser has not yet been implemented")
		}),
		StickTableSetStickTableEntriesHandler: stick_table.SetStickTableEntriesHandlerFunc(func(params stick_table.SetStickTableEntriesParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation stick_table.SetStickTableEntries has not yet been implemented")
		}),
		MapsShowRuntimeMapHandler: maps.ShowRuntimeMapHandlerFunc(func(params maps.ShowRuntimeMapParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation maps.ShowRuntimeMap has not yet been implemented")
		}),
		SpoeTransactionsStartSpoeTransactionHandler: spoe_transactions.StartSpoeTransactionHandlerFunc(func(params spoe_transactions.StartSpoeTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation spoe_transactions.StartSpoeTransaction has not yet been implemented")
		}),
		TransactionsStartTransactionHandler: transactions.StartTransactionHandlerFunc(func(params transactions.StartTransactionParams, principal interface{}) middleware.Responder {
			return middleware.NotImplemented("operation transactions.StartTransaction has not yet been implemented")
		}),

		// Applies when the Authorization header is set with the Basic scheme
		BasicAuthAuth: func(user string, pass string) (interface{}, error) {
			return nil, errors.NotImplemented("basic auth  (basic_auth) has not yet been implemented")
		},
		// default authorizer is authorized meaning no requests are blocked
		APIAuthorizer: security.Authorized(),
	}
}

/*
DataPlaneAPI API for editing and managing haproxy instances. Provides process information, configuration management,
haproxy stats and logs.
*/
type DataPlaneAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	customConsumers map[string]runtime.Consumer
	customProducers map[string]runtime.Producer
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler
	useSwaggerUI    bool

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator

	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator

	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for the following mime types:
	//   - application/json
	JSONConsumer runtime.Consumer
	// MultipartformConsumer registers a consumer for the following mime types:
	//   - multipart/form-data
	MultipartformConsumer runtime.Consumer
	// TxtConsumer registers a consumer for the following mime types:
	//   - text/plain
	TxtConsumer runtime.Consumer

	// BinProducer registers a producer for the following mime types:
	//   - application/octet-stream
	BinProducer runtime.Producer
	// JSONProducer registers a producer for the following mime types:
	//   - application/json
	JSONProducer runtime.Producer
	// TxtProducer registers a producer for the following mime types:
	//   - text/plain
	TxtProducer runtime.Producer

	// BasicAuthAuth registers a function that takes username and password and returns a principal
	// it performs authentication with basic auth
	BasicAuthAuth func(string, string) (interface{}, error)

	// APIAuthorizer provides access control (ACL/RBAC/ABAC) by providing access to the request and authenticated principal
	APIAuthorizer runtime.Authorizer

	// ACLRuntimeDeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler sets the operation handler for the delete services haproxy runtime acls parent name entries ID operation
	ACLRuntimeDeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler acl_runtime.DeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler
	// ACLRuntimeGetServicesHaproxyRuntimeAclsHandler sets the operation handler for the get services haproxy runtime acls operation
	ACLRuntimeGetServicesHaproxyRuntimeAclsHandler acl_runtime.GetServicesHaproxyRuntimeAclsHandler
	// ACLRuntimeGetServicesHaproxyRuntimeAclsIDHandler sets the operation handler for the get services haproxy runtime acls ID operation
	ACLRuntimeGetServicesHaproxyRuntimeAclsIDHandler acl_runtime.GetServicesHaproxyRuntimeAclsIDHandler
	// ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesHandler sets the operation handler for the get services haproxy runtime acls parent name entries operation
	ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesHandler acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesHandler
	// ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler sets the operation handler for the get services haproxy runtime acls parent name entries ID operation
	ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler
	// ACLRuntimePostServicesHaproxyRuntimeAclsParentNameEntriesHandler sets the operation handler for the post services haproxy runtime acls parent name entries operation
	ACLRuntimePostServicesHaproxyRuntimeAclsParentNameEntriesHandler acl_runtime.PostServicesHaproxyRuntimeAclsParentNameEntriesHandler
	// DefaultsAddDefaultsSectionHandler sets the operation handler for the add defaults section operation
	DefaultsAddDefaultsSectionHandler defaults.AddDefaultsSectionHandler
	// MapsAddMapEntryHandler sets the operation handler for the add map entry operation
	MapsAddMapEntryHandler maps.AddMapEntryHandler
	// ACLRuntimeAddPayloadRuntimeACLHandler sets the operation handler for the add payload runtime ACL operation
	ACLRuntimeAddPayloadRuntimeACLHandler acl_runtime.AddPayloadRuntimeACLHandler
	// MapsAddPayloadRuntimeMapHandler sets the operation handler for the add payload runtime map operation
	MapsAddPayloadRuntimeMapHandler maps.AddPayloadRuntimeMapHandler
	// ServerAddRuntimeServerHandler sets the operation handler for the add runtime server operation
	ServerAddRuntimeServerHandler serverops.AddRuntimeServerHandler
	// MapsClearRuntimeMapHandler sets the operation handler for the clear runtime map operation
	MapsClearRuntimeMapHandler maps.ClearRuntimeMapHandler
	// SpoeTransactionsCommitSpoeTransactionHandler sets the operation handler for the commit spoe transaction operation
	SpoeTransactionsCommitSpoeTransactionHandler spoe_transactions.CommitSpoeTransactionHandler
	// TransactionsCommitTransactionHandler sets the operation handler for the commit transaction operation
	TransactionsCommitTransactionHandler transactions.CommitTransactionHandler
	// ServiceDiscoveryCreateAWSRegionHandler sets the operation handler for the create a w s region operation
	ServiceDiscoveryCreateAWSRegionHandler service_discovery.CreateAWSRegionHandler
	// ACLCreateACLBackendHandler sets the operation handler for the create Acl backend operation
	ACLCreateACLBackendHandler acl.CreateACLBackendHandler
	// ACLCreateACLFCGIAppHandler sets the operation handler for the create Acl FCGI app operation
	ACLCreateACLFCGIAppHandler acl.CreateACLFCGIAppHandler
	// ACLCreateACLFrontendHandler sets the operation handler for the create Acl frontend operation
	ACLCreateACLFrontendHandler acl.CreateACLFrontendHandler
	// BackendCreateBackendHandler sets the operation handler for the create backend operation
	BackendCreateBackendHandler backend.CreateBackendHandler
	// BackendSwitchingRuleCreateBackendSwitchingRuleHandler sets the operation handler for the create backend switching rule operation
	BackendSwitchingRuleCreateBackendSwitchingRuleHandler backend_switching_rule.CreateBackendSwitchingRuleHandler
	// BindCreateBindFrontendHandler sets the operation handler for the create bind frontend operation
	BindCreateBindFrontendHandler bind.CreateBindFrontendHandler
	// BindCreateBindLogForwardHandler sets the operation handler for the create bind log forward operation
	BindCreateBindLogForwardHandler bind.CreateBindLogForwardHandler
	// BindCreateBindPeerHandler sets the operation handler for the create bind peer operation
	BindCreateBindPeerHandler bind.CreateBindPeerHandler
	// CacheCreateCacheHandler sets the operation handler for the create cache operation
	CacheCreateCacheHandler cache.CreateCacheHandler
	// ServiceDiscoveryCreateConsulHandler sets the operation handler for the create consul operation
	ServiceDiscoveryCreateConsulHandler service_discovery.CreateConsulHandler
	// CrtLoadCreateCrtLoadHandler sets the operation handler for the create crt load operation
	CrtLoadCreateCrtLoadHandler crt_load.CreateCrtLoadHandler
	// CrtStoreCreateCrtStoreHandler sets the operation handler for the create crt store operation
	CrtStoreCreateCrtStoreHandler crt_store.CreateCrtStoreHandler
	// DeclareCaptureCreateDeclareCaptureHandler sets the operation handler for the create declare capture operation
	DeclareCaptureCreateDeclareCaptureHandler declare_capture.CreateDeclareCaptureHandler
	// DefaultsCreateDefaultsSectionHandler sets the operation handler for the create defaults section operation
	DefaultsCreateDefaultsSectionHandler defaults.CreateDefaultsSectionHandler
	// DgramBindCreateDgramBindHandler sets the operation handler for the create dgram bind operation
	DgramBindCreateDgramBindHandler dgram_bind.CreateDgramBindHandler
	// FCGIAppCreateFCGIAppHandler sets the operation handler for the create FCGI app operation
	FCGIAppCreateFCGIAppHandler fcgi_app.CreateFCGIAppHandler
	// FilterCreateFilterBackendHandler sets the operation handler for the create filter backend operation
	FilterCreateFilterBackendHandler filter.CreateFilterBackendHandler
	// FilterCreateFilterFrontendHandler sets the operation handler for the create filter frontend operation
	FilterCreateFilterFrontendHandler filter.CreateFilterFrontendHandler
	// FrontendCreateFrontendHandler sets the operation handler for the create frontend operation
	FrontendCreateFrontendHandler frontend.CreateFrontendHandler
	// GroupCreateGroupHandler sets the operation handler for the create group operation
	GroupCreateGroupHandler group.CreateGroupHandler
	// HTTPAfterResponseRuleCreateHTTPAfterResponseRuleBackendHandler sets the operation handler for the create HTTP after response rule backend operation
	HTTPAfterResponseRuleCreateHTTPAfterResponseRuleBackendHandler http_after_response_rule.CreateHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleCreateHTTPAfterResponseRuleFrontendHandler sets the operation handler for the create HTTP after response rule frontend operation
	HTTPAfterResponseRuleCreateHTTPAfterResponseRuleFrontendHandler http_after_response_rule.CreateHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckCreateHTTPCheckBackendHandler sets the operation handler for the create HTTP check backend operation
	HTTPCheckCreateHTTPCheckBackendHandler http_check.CreateHTTPCheckBackendHandler
	// HTTPCheckCreateHTTPCheckDefaultsHandler sets the operation handler for the create HTTP check defaults operation
	HTTPCheckCreateHTTPCheckDefaultsHandler http_check.CreateHTTPCheckDefaultsHandler
	// HTTPErrorRuleCreateHTTPErrorRuleBackendHandler sets the operation handler for the create HTTP error rule backend operation
	HTTPErrorRuleCreateHTTPErrorRuleBackendHandler http_error_rule.CreateHTTPErrorRuleBackendHandler
	// HTTPErrorRuleCreateHTTPErrorRuleDefaultsHandler sets the operation handler for the create HTTP error rule defaults operation
	HTTPErrorRuleCreateHTTPErrorRuleDefaultsHandler http_error_rule.CreateHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleCreateHTTPErrorRuleFrontendHandler sets the operation handler for the create HTTP error rule frontend operation
	HTTPErrorRuleCreateHTTPErrorRuleFrontendHandler http_error_rule.CreateHTTPErrorRuleFrontendHandler
	// HTTPErrorsCreateHTTPErrorsSectionHandler sets the operation handler for the create HTTP errors section operation
	HTTPErrorsCreateHTTPErrorsSectionHandler http_errors.CreateHTTPErrorsSectionHandler
	// HTTPRequestRuleCreateHTTPRequestRuleBackendHandler sets the operation handler for the create HTTP request rule backend operation
	HTTPRequestRuleCreateHTTPRequestRuleBackendHandler http_request_rule.CreateHTTPRequestRuleBackendHandler
	// HTTPRequestRuleCreateHTTPRequestRuleFrontendHandler sets the operation handler for the create HTTP request rule frontend operation
	HTTPRequestRuleCreateHTTPRequestRuleFrontendHandler http_request_rule.CreateHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleCreateHTTPResponseRuleBackendHandler sets the operation handler for the create HTTP response rule backend operation
	HTTPResponseRuleCreateHTTPResponseRuleBackendHandler http_response_rule.CreateHTTPResponseRuleBackendHandler
	// HTTPResponseRuleCreateHTTPResponseRuleFrontendHandler sets the operation handler for the create HTTP response rule frontend operation
	HTTPResponseRuleCreateHTTPResponseRuleFrontendHandler http_response_rule.CreateHTTPResponseRuleFrontendHandler
	// LogForwardCreateLogForwardHandler sets the operation handler for the create log forward operation
	LogForwardCreateLogForwardHandler log_forward.CreateLogForwardHandler
	// LogProfileCreateLogProfileHandler sets the operation handler for the create log profile operation
	LogProfileCreateLogProfileHandler log_profile.CreateLogProfileHandler
	// LogTargetCreateLogTargetBackendHandler sets the operation handler for the create log target backend operation
	LogTargetCreateLogTargetBackendHandler log_target.CreateLogTargetBackendHandler
	// LogTargetCreateLogTargetDefaultsHandler sets the operation handler for the create log target defaults operation
	LogTargetCreateLogTargetDefaultsHandler log_target.CreateLogTargetDefaultsHandler
	// LogTargetCreateLogTargetFrontendHandler sets the operation handler for the create log target frontend operation
	LogTargetCreateLogTargetFrontendHandler log_target.CreateLogTargetFrontendHandler
	// LogTargetCreateLogTargetGlobalHandler sets the operation handler for the create log target global operation
	LogTargetCreateLogTargetGlobalHandler log_target.CreateLogTargetGlobalHandler
	// LogTargetCreateLogTargetLogForwardHandler sets the operation handler for the create log target log forward operation
	LogTargetCreateLogTargetLogForwardHandler log_target.CreateLogTargetLogForwardHandler
	// LogTargetCreateLogTargetPeerHandler sets the operation handler for the create log target peer operation
	LogTargetCreateLogTargetPeerHandler log_target.CreateLogTargetPeerHandler
	// MailerEntryCreateMailerEntryHandler sets the operation handler for the create mailer entry operation
	MailerEntryCreateMailerEntryHandler mailer_entry.CreateMailerEntryHandler
	// MailersCreateMailersSectionHandler sets the operation handler for the create mailers section operation
	MailersCreateMailersSectionHandler mailers.CreateMailersSectionHandler
	// NameserverCreateNameserverHandler sets the operation handler for the create nameserver operation
	NameserverCreateNameserverHandler nameserver.CreateNameserverHandler
	// PeerCreatePeerHandler sets the operation handler for the create peer operation
	PeerCreatePeerHandler peer.CreatePeerHandler
	// PeerEntryCreatePeerEntryHandler sets the operation handler for the create peer entry operation
	PeerEntryCreatePeerEntryHandler peer_entry.CreatePeerEntryHandler
	// ProcessManagerCreateProgramHandler sets the operation handler for the create program operation
	ProcessManagerCreateProgramHandler process_manager.CreateProgramHandler
	// QUICInitialRuleCreateQUICInitialRuleDefaultsHandler sets the operation handler for the create QUIC initial rule defaults operation
	QUICInitialRuleCreateQUICInitialRuleDefaultsHandler quic_initial_rule.CreateQUICInitialRuleDefaultsHandler
	// QUICInitialRuleCreateQUICInitialRuleFrontendHandler sets the operation handler for the create QUIC initial rule frontend operation
	QUICInitialRuleCreateQUICInitialRuleFrontendHandler quic_initial_rule.CreateQUICInitialRuleFrontendHandler
	// ResolverCreateResolverHandler sets the operation handler for the create resolver operation
	ResolverCreateResolverHandler resolver.CreateResolverHandler
	// RingCreateRingHandler sets the operation handler for the create ring operation
	RingCreateRingHandler ring.CreateRingHandler
	// ServerCreateServerBackendHandler sets the operation handler for the create server backend operation
	ServerCreateServerBackendHandler serverops.CreateServerBackendHandler
	// ServerCreateServerPeerHandler sets the operation handler for the create server peer operation
	ServerCreateServerPeerHandler serverops.CreateServerPeerHandler
	// ServerCreateServerRingHandler sets the operation handler for the create server ring operation
	ServerCreateServerRingHandler serverops.CreateServerRingHandler
	// ServerSwitchingRuleCreateServerSwitchingRuleHandler sets the operation handler for the create server switching rule operation
	ServerSwitchingRuleCreateServerSwitchingRuleHandler server_switching_rule.CreateServerSwitchingRuleHandler
	// ServerTemplateCreateServerTemplateHandler sets the operation handler for the create server template operation
	ServerTemplateCreateServerTemplateHandler server_template.CreateServerTemplateHandler
	// SitesCreateSiteHandler sets the operation handler for the create site operation
	SitesCreateSiteHandler sites.CreateSiteHandler
	// SpoeCreateSpoeHandler sets the operation handler for the create spoe operation
	SpoeCreateSpoeHandler spoe.CreateSpoeHandler
	// SpoeCreateSpoeAgentHandler sets the operation handler for the create spoe agent operation
	SpoeCreateSpoeAgentHandler spoe.CreateSpoeAgentHandler
	// SpoeCreateSpoeGroupHandler sets the operation handler for the create spoe group operation
	SpoeCreateSpoeGroupHandler spoe.CreateSpoeGroupHandler
	// SpoeCreateSpoeMessageHandler sets the operation handler for the create spoe message operation
	SpoeCreateSpoeMessageHandler spoe.CreateSpoeMessageHandler
	// SpoeCreateSpoeScopeHandler sets the operation handler for the create spoe scope operation
	SpoeCreateSpoeScopeHandler spoe.CreateSpoeScopeHandler
	// StickRuleCreateStickRuleHandler sets the operation handler for the create stick rule operation
	StickRuleCreateStickRuleHandler stick_rule.CreateStickRuleHandler
	// StorageCreateStorageGeneralFileHandler sets the operation handler for the create storage general file operation
	StorageCreateStorageGeneralFileHandler storage.CreateStorageGeneralFileHandler
	// StorageCreateStorageMapFileHandler sets the operation handler for the create storage map file operation
	StorageCreateStorageMapFileHandler storage.CreateStorageMapFileHandler
	// StorageCreateStorageSSLCertificateHandler sets the operation handler for the create storage s s l certificate operation
	StorageCreateStorageSSLCertificateHandler storage.CreateStorageSSLCertificateHandler
	// TCPCheckCreateTCPCheckBackendHandler sets the operation handler for the create TCP check backend operation
	TCPCheckCreateTCPCheckBackendHandler tcp_check.CreateTCPCheckBackendHandler
	// TCPCheckCreateTCPCheckDefaultsHandler sets the operation handler for the create TCP check defaults operation
	TCPCheckCreateTCPCheckDefaultsHandler tcp_check.CreateTCPCheckDefaultsHandler
	// TCPRequestRuleCreateTCPRequestRuleBackendHandler sets the operation handler for the create TCP request rule backend operation
	TCPRequestRuleCreateTCPRequestRuleBackendHandler tcp_request_rule.CreateTCPRequestRuleBackendHandler
	// TCPRequestRuleCreateTCPRequestRuleFrontendHandler sets the operation handler for the create TCP request rule frontend operation
	TCPRequestRuleCreateTCPRequestRuleFrontendHandler tcp_request_rule.CreateTCPRequestRuleFrontendHandler
	// TCPResponseRuleCreateTCPResponseRuleBackendHandler sets the operation handler for the create TCP response rule backend operation
	TCPResponseRuleCreateTCPResponseRuleBackendHandler tcp_response_rule.CreateTCPResponseRuleBackendHandler
	// TableCreateTableHandler sets the operation handler for the create table operation
	TableCreateTableHandler table.CreateTableHandler
	// TracesCreateTraceEntryHandler sets the operation handler for the create trace entry operation
	TracesCreateTraceEntryHandler traces.CreateTraceEntryHandler
	// TracesCreateTracesHandler sets the operation handler for the create traces operation
	TracesCreateTracesHandler traces.CreateTracesHandler
	// UserCreateUserHandler sets the operation handler for the create user operation
	UserCreateUserHandler user.CreateUserHandler
	// UserlistCreateUserlistHandler sets the operation handler for the create userlist operation
	UserlistCreateUserlistHandler userlist.CreateUserlistHandler
	// ServiceDiscoveryDeleteAWSRegionHandler sets the operation handler for the delete a w s region operation
	ServiceDiscoveryDeleteAWSRegionHandler service_discovery.DeleteAWSRegionHandler
	// ACLDeleteACLBackendHandler sets the operation handler for the delete Acl backend operation
	ACLDeleteACLBackendHandler acl.DeleteACLBackendHandler
	// ACLDeleteACLFCGIAppHandler sets the operation handler for the delete Acl FCGI app operation
	ACLDeleteACLFCGIAppHandler acl.DeleteACLFCGIAppHandler
	// ACLDeleteACLFrontendHandler sets the operation handler for the delete Acl frontend operation
	ACLDeleteACLFrontendHandler acl.DeleteACLFrontendHandler
	// BackendDeleteBackendHandler sets the operation handler for the delete backend operation
	BackendDeleteBackendHandler backend.DeleteBackendHandler
	// BackendSwitchingRuleDeleteBackendSwitchingRuleHandler sets the operation handler for the delete backend switching rule operation
	BackendSwitchingRuleDeleteBackendSwitchingRuleHandler backend_switching_rule.DeleteBackendSwitchingRuleHandler
	// BindDeleteBindFrontendHandler sets the operation handler for the delete bind frontend operation
	BindDeleteBindFrontendHandler bind.DeleteBindFrontendHandler
	// BindDeleteBindLogForwardHandler sets the operation handler for the delete bind log forward operation
	BindDeleteBindLogForwardHandler bind.DeleteBindLogForwardHandler
	// BindDeleteBindPeerHandler sets the operation handler for the delete bind peer operation
	BindDeleteBindPeerHandler bind.DeleteBindPeerHandler
	// CacheDeleteCacheHandler sets the operation handler for the delete cache operation
	CacheDeleteCacheHandler cache.DeleteCacheHandler
	// ClusterDeleteClusterHandler sets the operation handler for the delete cluster operation
	ClusterDeleteClusterHandler cluster.DeleteClusterHandler
	// ServiceDiscoveryDeleteConsulHandler sets the operation handler for the delete consul operation
	ServiceDiscoveryDeleteConsulHandler service_discovery.DeleteConsulHandler
	// CrtLoadDeleteCrtLoadHandler sets the operation handler for the delete crt load operation
	CrtLoadDeleteCrtLoadHandler crt_load.DeleteCrtLoadHandler
	// CrtStoreDeleteCrtStoreHandler sets the operation handler for the delete crt store operation
	CrtStoreDeleteCrtStoreHandler crt_store.DeleteCrtStoreHandler
	// DeclareCaptureDeleteDeclareCaptureHandler sets the operation handler for the delete declare capture operation
	DeclareCaptureDeleteDeclareCaptureHandler declare_capture.DeleteDeclareCaptureHandler
	// DefaultsDeleteDefaultsSectionHandler sets the operation handler for the delete defaults section operation
	DefaultsDeleteDefaultsSectionHandler defaults.DeleteDefaultsSectionHandler
	// DgramBindDeleteDgramBindHandler sets the operation handler for the delete dgram bind operation
	DgramBindDeleteDgramBindHandler dgram_bind.DeleteDgramBindHandler
	// FCGIAppDeleteFCGIAppHandler sets the operation handler for the delete FCGI app operation
	FCGIAppDeleteFCGIAppHandler fcgi_app.DeleteFCGIAppHandler
	// FilterDeleteFilterBackendHandler sets the operation handler for the delete filter backend operation
	FilterDeleteFilterBackendHandler filter.DeleteFilterBackendHandler
	// FilterDeleteFilterFrontendHandler sets the operation handler for the delete filter frontend operation
	FilterDeleteFilterFrontendHandler filter.DeleteFilterFrontendHandler
	// FrontendDeleteFrontendHandler sets the operation handler for the delete frontend operation
	FrontendDeleteFrontendHandler frontend.DeleteFrontendHandler
	// GroupDeleteGroupHandler sets the operation handler for the delete group operation
	GroupDeleteGroupHandler group.DeleteGroupHandler
	// HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleBackendHandler sets the operation handler for the delete HTTP after response rule backend operation
	HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleBackendHandler http_after_response_rule.DeleteHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleFrontendHandler sets the operation handler for the delete HTTP after response rule frontend operation
	HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleFrontendHandler http_after_response_rule.DeleteHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckDeleteHTTPCheckBackendHandler sets the operation handler for the delete HTTP check backend operation
	HTTPCheckDeleteHTTPCheckBackendHandler http_check.DeleteHTTPCheckBackendHandler
	// HTTPCheckDeleteHTTPCheckDefaultsHandler sets the operation handler for the delete HTTP check defaults operation
	HTTPCheckDeleteHTTPCheckDefaultsHandler http_check.DeleteHTTPCheckDefaultsHandler
	// HTTPErrorRuleDeleteHTTPErrorRuleBackendHandler sets the operation handler for the delete HTTP error rule backend operation
	HTTPErrorRuleDeleteHTTPErrorRuleBackendHandler http_error_rule.DeleteHTTPErrorRuleBackendHandler
	// HTTPErrorRuleDeleteHTTPErrorRuleDefaultsHandler sets the operation handler for the delete HTTP error rule defaults operation
	HTTPErrorRuleDeleteHTTPErrorRuleDefaultsHandler http_error_rule.DeleteHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleDeleteHTTPErrorRuleFrontendHandler sets the operation handler for the delete HTTP error rule frontend operation
	HTTPErrorRuleDeleteHTTPErrorRuleFrontendHandler http_error_rule.DeleteHTTPErrorRuleFrontendHandler
	// HTTPErrorsDeleteHTTPErrorsSectionHandler sets the operation handler for the delete HTTP errors section operation
	HTTPErrorsDeleteHTTPErrorsSectionHandler http_errors.DeleteHTTPErrorsSectionHandler
	// HTTPRequestRuleDeleteHTTPRequestRuleBackendHandler sets the operation handler for the delete HTTP request rule backend operation
	HTTPRequestRuleDeleteHTTPRequestRuleBackendHandler http_request_rule.DeleteHTTPRequestRuleBackendHandler
	// HTTPRequestRuleDeleteHTTPRequestRuleFrontendHandler sets the operation handler for the delete HTTP request rule frontend operation
	HTTPRequestRuleDeleteHTTPRequestRuleFrontendHandler http_request_rule.DeleteHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleDeleteHTTPResponseRuleBackendHandler sets the operation handler for the delete HTTP response rule backend operation
	HTTPResponseRuleDeleteHTTPResponseRuleBackendHandler http_response_rule.DeleteHTTPResponseRuleBackendHandler
	// HTTPResponseRuleDeleteHTTPResponseRuleFrontendHandler sets the operation handler for the delete HTTP response rule frontend operation
	HTTPResponseRuleDeleteHTTPResponseRuleFrontendHandler http_response_rule.DeleteHTTPResponseRuleFrontendHandler
	// LogForwardDeleteLogForwardHandler sets the operation handler for the delete log forward operation
	LogForwardDeleteLogForwardHandler log_forward.DeleteLogForwardHandler
	// LogProfileDeleteLogProfileHandler sets the operation handler for the delete log profile operation
	LogProfileDeleteLogProfileHandler log_profile.DeleteLogProfileHandler
	// LogTargetDeleteLogTargetBackendHandler sets the operation handler for the delete log target backend operation
	LogTargetDeleteLogTargetBackendHandler log_target.DeleteLogTargetBackendHandler
	// LogTargetDeleteLogTargetDefaultsHandler sets the operation handler for the delete log target defaults operation
	LogTargetDeleteLogTargetDefaultsHandler log_target.DeleteLogTargetDefaultsHandler
	// LogTargetDeleteLogTargetFrontendHandler sets the operation handler for the delete log target frontend operation
	LogTargetDeleteLogTargetFrontendHandler log_target.DeleteLogTargetFrontendHandler
	// LogTargetDeleteLogTargetGlobalHandler sets the operation handler for the delete log target global operation
	LogTargetDeleteLogTargetGlobalHandler log_target.DeleteLogTargetGlobalHandler
	// LogTargetDeleteLogTargetLogForwardHandler sets the operation handler for the delete log target log forward operation
	LogTargetDeleteLogTargetLogForwardHandler log_target.DeleteLogTargetLogForwardHandler
	// LogTargetDeleteLogTargetPeerHandler sets the operation handler for the delete log target peer operation
	LogTargetDeleteLogTargetPeerHandler log_target.DeleteLogTargetPeerHandler
	// MailerEntryDeleteMailerEntryHandler sets the operation handler for the delete mailer entry operation
	MailerEntryDeleteMailerEntryHandler mailer_entry.DeleteMailerEntryHandler
	// MailersDeleteMailersSectionHandler sets the operation handler for the delete mailers section operation
	MailersDeleteMailersSectionHandler mailers.DeleteMailersSectionHandler
	// NameserverDeleteNameserverHandler sets the operation handler for the delete nameserver operation
	NameserverDeleteNameserverHandler nameserver.DeleteNameserverHandler
	// PeerDeletePeerHandler sets the operation handler for the delete peer operation
	PeerDeletePeerHandler peer.DeletePeerHandler
	// PeerEntryDeletePeerEntryHandler sets the operation handler for the delete peer entry operation
	PeerEntryDeletePeerEntryHandler peer_entry.DeletePeerEntryHandler
	// ProcessManagerDeleteProgramHandler sets the operation handler for the delete program operation
	ProcessManagerDeleteProgramHandler process_manager.DeleteProgramHandler
	// QUICInitialRuleDeleteQUICInitialRuleDefaultsHandler sets the operation handler for the delete QUIC initial rule defaults operation
	QUICInitialRuleDeleteQUICInitialRuleDefaultsHandler quic_initial_rule.DeleteQUICInitialRuleDefaultsHandler
	// QUICInitialRuleDeleteQUICInitialRuleFrontendHandler sets the operation handler for the delete QUIC initial rule frontend operation
	QUICInitialRuleDeleteQUICInitialRuleFrontendHandler quic_initial_rule.DeleteQUICInitialRuleFrontendHandler
	// ResolverDeleteResolverHandler sets the operation handler for the delete resolver operation
	ResolverDeleteResolverHandler resolver.DeleteResolverHandler
	// RingDeleteRingHandler sets the operation handler for the delete ring operation
	RingDeleteRingHandler ring.DeleteRingHandler
	// MapsDeleteRuntimeMapEntryHandler sets the operation handler for the delete runtime map entry operation
	MapsDeleteRuntimeMapEntryHandler maps.DeleteRuntimeMapEntryHandler
	// ServerDeleteRuntimeServerHandler sets the operation handler for the delete runtime server operation
	ServerDeleteRuntimeServerHandler serverops.DeleteRuntimeServerHandler
	// ServerDeleteServerBackendHandler sets the operation handler for the delete server backend operation
	ServerDeleteServerBackendHandler serverops.DeleteServerBackendHandler
	// ServerDeleteServerPeerHandler sets the operation handler for the delete server peer operation
	ServerDeleteServerPeerHandler serverops.DeleteServerPeerHandler
	// ServerDeleteServerRingHandler sets the operation handler for the delete server ring operation
	ServerDeleteServerRingHandler serverops.DeleteServerRingHandler
	// ServerSwitchingRuleDeleteServerSwitchingRuleHandler sets the operation handler for the delete server switching rule operation
	ServerSwitchingRuleDeleteServerSwitchingRuleHandler server_switching_rule.DeleteServerSwitchingRuleHandler
	// ServerTemplateDeleteServerTemplateHandler sets the operation handler for the delete server template operation
	ServerTemplateDeleteServerTemplateHandler server_template.DeleteServerTemplateHandler
	// SitesDeleteSiteHandler sets the operation handler for the delete site operation
	SitesDeleteSiteHandler sites.DeleteSiteHandler
	// SpoeDeleteSpoeAgentHandler sets the operation handler for the delete spoe agent operation
	SpoeDeleteSpoeAgentHandler spoe.DeleteSpoeAgentHandler
	// SpoeDeleteSpoeFileHandler sets the operation handler for the delete spoe file operation
	SpoeDeleteSpoeFileHandler spoe.DeleteSpoeFileHandler
	// SpoeDeleteSpoeGroupHandler sets the operation handler for the delete spoe group operation
	SpoeDeleteSpoeGroupHandler spoe.DeleteSpoeGroupHandler
	// SpoeDeleteSpoeMessageHandler sets the operation handler for the delete spoe message operation
	SpoeDeleteSpoeMessageHandler spoe.DeleteSpoeMessageHandler
	// SpoeDeleteSpoeScopeHandler sets the operation handler for the delete spoe scope operation
	SpoeDeleteSpoeScopeHandler spoe.DeleteSpoeScopeHandler
	// SpoeTransactionsDeleteSpoeTransactionHandler sets the operation handler for the delete spoe transaction operation
	SpoeTransactionsDeleteSpoeTransactionHandler spoe_transactions.DeleteSpoeTransactionHandler
	// StickRuleDeleteStickRuleHandler sets the operation handler for the delete stick rule operation
	StickRuleDeleteStickRuleHandler stick_rule.DeleteStickRuleHandler
	// StorageDeleteStorageGeneralFileHandler sets the operation handler for the delete storage general file operation
	StorageDeleteStorageGeneralFileHandler storage.DeleteStorageGeneralFileHandler
	// StorageDeleteStorageMapHandler sets the operation handler for the delete storage map operation
	StorageDeleteStorageMapHandler storage.DeleteStorageMapHandler
	// StorageDeleteStorageSSLCertificateHandler sets the operation handler for the delete storage s s l certificate operation
	StorageDeleteStorageSSLCertificateHandler storage.DeleteStorageSSLCertificateHandler
	// TCPCheckDeleteTCPCheckBackendHandler sets the operation handler for the delete TCP check backend operation
	TCPCheckDeleteTCPCheckBackendHandler tcp_check.DeleteTCPCheckBackendHandler
	// TCPCheckDeleteTCPCheckDefaultsHandler sets the operation handler for the delete TCP check defaults operation
	TCPCheckDeleteTCPCheckDefaultsHandler tcp_check.DeleteTCPCheckDefaultsHandler
	// TCPRequestRuleDeleteTCPRequestRuleBackendHandler sets the operation handler for the delete TCP request rule backend operation
	TCPRequestRuleDeleteTCPRequestRuleBackendHandler tcp_request_rule.DeleteTCPRequestRuleBackendHandler
	// TCPRequestRuleDeleteTCPRequestRuleFrontendHandler sets the operation handler for the delete TCP request rule frontend operation
	TCPRequestRuleDeleteTCPRequestRuleFrontendHandler tcp_request_rule.DeleteTCPRequestRuleFrontendHandler
	// TCPResponseRuleDeleteTCPResponseRuleBackendHandler sets the operation handler for the delete TCP response rule backend operation
	TCPResponseRuleDeleteTCPResponseRuleBackendHandler tcp_response_rule.DeleteTCPResponseRuleBackendHandler
	// TableDeleteTableHandler sets the operation handler for the delete table operation
	TableDeleteTableHandler table.DeleteTableHandler
	// TracesDeleteTraceEntryHandler sets the operation handler for the delete trace entry operation
	TracesDeleteTraceEntryHandler traces.DeleteTraceEntryHandler
	// TracesDeleteTracesHandler sets the operation handler for the delete traces operation
	TracesDeleteTracesHandler traces.DeleteTracesHandler
	// TransactionsDeleteTransactionHandler sets the operation handler for the delete transaction operation
	TransactionsDeleteTransactionHandler transactions.DeleteTransactionHandler
	// UserDeleteUserHandler sets the operation handler for the delete user operation
	UserDeleteUserHandler user.DeleteUserHandler
	// UserlistDeleteUserlistHandler sets the operation handler for the delete userlist operation
	UserlistDeleteUserlistHandler userlist.DeleteUserlistHandler
	// ClusterEditClusterHandler sets the operation handler for the edit cluster operation
	ClusterEditClusterHandler cluster.EditClusterHandler
	// CrtStoreEditCrtStoreHandler sets the operation handler for the edit crt store operation
	CrtStoreEditCrtStoreHandler crt_store.EditCrtStoreHandler
	// LogProfileEditLogProfileHandler sets the operation handler for the edit log profile operation
	LogProfileEditLogProfileHandler log_profile.EditLogProfileHandler
	// MailersEditMailersSectionHandler sets the operation handler for the edit mailers section operation
	MailersEditMailersSectionHandler mailers.EditMailersSectionHandler
	// DiscoveryGetAPIEndpointsHandler sets the operation handler for the get API endpoints operation
	DiscoveryGetAPIEndpointsHandler discovery.GetAPIEndpointsHandler
	// ServiceDiscoveryGetAWSRegionHandler sets the operation handler for the get a w s region operation
	ServiceDiscoveryGetAWSRegionHandler service_discovery.GetAWSRegionHandler
	// ServiceDiscoveryGetAWSRegionsHandler sets the operation handler for the get a w s regions operation
	ServiceDiscoveryGetAWSRegionsHandler service_discovery.GetAWSRegionsHandler
	// ACLGetACLBackendHandler sets the operation handler for the get Acl backend operation
	ACLGetACLBackendHandler acl.GetACLBackendHandler
	// ACLGetACLFCGIAppHandler sets the operation handler for the get Acl FCGI app operation
	ACLGetACLFCGIAppHandler acl.GetACLFCGIAppHandler
	// ACLGetACLFrontendHandler sets the operation handler for the get Acl frontend operation
	ACLGetACLFrontendHandler acl.GetACLFrontendHandler
	// ACLGetAllACLBackendHandler sets the operation handler for the get all Acl backend operation
	ACLGetAllACLBackendHandler acl.GetAllACLBackendHandler
	// ACLGetAllACLFCGIAppHandler sets the operation handler for the get all Acl FCGI app operation
	ACLGetAllACLFCGIAppHandler acl.GetAllACLFCGIAppHandler
	// ACLGetAllACLFrontendHandler sets the operation handler for the get all Acl frontend operation
	ACLGetAllACLFrontendHandler acl.GetAllACLFrontendHandler
	// BindGetAllBindFrontendHandler sets the operation handler for the get all bind frontend operation
	BindGetAllBindFrontendHandler bind.GetAllBindFrontendHandler
	// BindGetAllBindLogForwardHandler sets the operation handler for the get all bind log forward operation
	BindGetAllBindLogForwardHandler bind.GetAllBindLogForwardHandler
	// BindGetAllBindPeerHandler sets the operation handler for the get all bind peer operation
	BindGetAllBindPeerHandler bind.GetAllBindPeerHandler
	// FilterGetAllFilterBackendHandler sets the operation handler for the get all filter backend operation
	FilterGetAllFilterBackendHandler filter.GetAllFilterBackendHandler
	// FilterGetAllFilterFrontendHandler sets the operation handler for the get all filter frontend operation
	FilterGetAllFilterFrontendHandler filter.GetAllFilterFrontendHandler
	// HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleBackendHandler sets the operation handler for the get all HTTP after response rule backend operation
	HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleBackendHandler http_after_response_rule.GetAllHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleFrontendHandler sets the operation handler for the get all HTTP after response rule frontend operation
	HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleFrontendHandler http_after_response_rule.GetAllHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckGetAllHTTPCheckBackendHandler sets the operation handler for the get all HTTP check backend operation
	HTTPCheckGetAllHTTPCheckBackendHandler http_check.GetAllHTTPCheckBackendHandler
	// HTTPCheckGetAllHTTPCheckDefaultsHandler sets the operation handler for the get all HTTP check defaults operation
	HTTPCheckGetAllHTTPCheckDefaultsHandler http_check.GetAllHTTPCheckDefaultsHandler
	// HTTPErrorRuleGetAllHTTPErrorRuleBackendHandler sets the operation handler for the get all HTTP error rule backend operation
	HTTPErrorRuleGetAllHTTPErrorRuleBackendHandler http_error_rule.GetAllHTTPErrorRuleBackendHandler
	// HTTPErrorRuleGetAllHTTPErrorRuleDefaultsHandler sets the operation handler for the get all HTTP error rule defaults operation
	HTTPErrorRuleGetAllHTTPErrorRuleDefaultsHandler http_error_rule.GetAllHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleGetAllHTTPErrorRuleFrontendHandler sets the operation handler for the get all HTTP error rule frontend operation
	HTTPErrorRuleGetAllHTTPErrorRuleFrontendHandler http_error_rule.GetAllHTTPErrorRuleFrontendHandler
	// HTTPRequestRuleGetAllHTTPRequestRuleBackendHandler sets the operation handler for the get all HTTP request rule backend operation
	HTTPRequestRuleGetAllHTTPRequestRuleBackendHandler http_request_rule.GetAllHTTPRequestRuleBackendHandler
	// HTTPRequestRuleGetAllHTTPRequestRuleFrontendHandler sets the operation handler for the get all HTTP request rule frontend operation
	HTTPRequestRuleGetAllHTTPRequestRuleFrontendHandler http_request_rule.GetAllHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleGetAllHTTPResponseRuleBackendHandler sets the operation handler for the get all HTTP response rule backend operation
	HTTPResponseRuleGetAllHTTPResponseRuleBackendHandler http_response_rule.GetAllHTTPResponseRuleBackendHandler
	// HTTPResponseRuleGetAllHTTPResponseRuleFrontendHandler sets the operation handler for the get all HTTP response rule frontend operation
	HTTPResponseRuleGetAllHTTPResponseRuleFrontendHandler http_response_rule.GetAllHTTPResponseRuleFrontendHandler
	// LogTargetGetAllLogTargetBackendHandler sets the operation handler for the get all log target backend operation
	LogTargetGetAllLogTargetBackendHandler log_target.GetAllLogTargetBackendHandler
	// LogTargetGetAllLogTargetDefaultsHandler sets the operation handler for the get all log target defaults operation
	LogTargetGetAllLogTargetDefaultsHandler log_target.GetAllLogTargetDefaultsHandler
	// LogTargetGetAllLogTargetFrontendHandler sets the operation handler for the get all log target frontend operation
	LogTargetGetAllLogTargetFrontendHandler log_target.GetAllLogTargetFrontendHandler
	// LogTargetGetAllLogTargetGlobalHandler sets the operation handler for the get all log target global operation
	LogTargetGetAllLogTargetGlobalHandler log_target.GetAllLogTargetGlobalHandler
	// LogTargetGetAllLogTargetLogForwardHandler sets the operation handler for the get all log target log forward operation
	LogTargetGetAllLogTargetLogForwardHandler log_target.GetAllLogTargetLogForwardHandler
	// LogTargetGetAllLogTargetPeerHandler sets the operation handler for the get all log target peer operation
	LogTargetGetAllLogTargetPeerHandler log_target.GetAllLogTargetPeerHandler
	// QUICInitialRuleGetAllQUICInitialRuleDefaultsHandler sets the operation handler for the get all QUIC initial rule defaults operation
	QUICInitialRuleGetAllQUICInitialRuleDefaultsHandler quic_initial_rule.GetAllQUICInitialRuleDefaultsHandler
	// QUICInitialRuleGetAllQUICInitialRuleFrontendHandler sets the operation handler for the get all QUIC initial rule frontend operation
	QUICInitialRuleGetAllQUICInitialRuleFrontendHandler quic_initial_rule.GetAllQUICInitialRuleFrontendHandler
	// MapsGetAllRuntimeMapFilesHandler sets the operation handler for the get all runtime map files operation
	MapsGetAllRuntimeMapFilesHandler maps.GetAllRuntimeMapFilesHandler
	// ServerGetAllRuntimeServerHandler sets the operation handler for the get all runtime server operation
	ServerGetAllRuntimeServerHandler serverops.GetAllRuntimeServerHandler
	// ServerGetAllServerBackendHandler sets the operation handler for the get all server backend operation
	ServerGetAllServerBackendHandler serverops.GetAllServerBackendHandler
	// ServerGetAllServerPeerHandler sets the operation handler for the get all server peer operation
	ServerGetAllServerPeerHandler serverops.GetAllServerPeerHandler
	// ServerGetAllServerRingHandler sets the operation handler for the get all server ring operation
	ServerGetAllServerRingHandler serverops.GetAllServerRingHandler
	// SpoeGetAllSpoeAgentHandler sets the operation handler for the get all spoe agent operation
	SpoeGetAllSpoeAgentHandler spoe.GetAllSpoeAgentHandler
	// SpoeGetAllSpoeFilesHandler sets the operation handler for the get all spoe files operation
	SpoeGetAllSpoeFilesHandler spoe.GetAllSpoeFilesHandler
	// SpoeGetAllSpoeGroupHandler sets the operation handler for the get all spoe group operation
	SpoeGetAllSpoeGroupHandler spoe.GetAllSpoeGroupHandler
	// SpoeGetAllSpoeMessageHandler sets the operation handler for the get all spoe message operation
	SpoeGetAllSpoeMessageHandler spoe.GetAllSpoeMessageHandler
	// SpoeGetAllSpoeScopeHandler sets the operation handler for the get all spoe scope operation
	SpoeGetAllSpoeScopeHandler spoe.GetAllSpoeScopeHandler
	// SpoeTransactionsGetAllSpoeTransactionHandler sets the operation handler for the get all spoe transaction operation
	SpoeTransactionsGetAllSpoeTransactionHandler spoe_transactions.GetAllSpoeTransactionHandler
	// StorageGetAllStorageGeneralFilesHandler sets the operation handler for the get all storage general files operation
	StorageGetAllStorageGeneralFilesHandler storage.GetAllStorageGeneralFilesHandler
	// StorageGetAllStorageMapFilesHandler sets the operation handler for the get all storage map files operation
	StorageGetAllStorageMapFilesHandler storage.GetAllStorageMapFilesHandler
	// StorageGetAllStorageSSLCertificatesHandler sets the operation handler for the get all storage s s l certificates operation
	StorageGetAllStorageSSLCertificatesHandler storage.GetAllStorageSSLCertificatesHandler
	// TCPCheckGetAllTCPCheckBackendHandler sets the operation handler for the get all TCP check backend operation
	TCPCheckGetAllTCPCheckBackendHandler tcp_check.GetAllTCPCheckBackendHandler
	// TCPCheckGetAllTCPCheckDefaultsHandler sets the operation handler for the get all TCP check defaults operation
	TCPCheckGetAllTCPCheckDefaultsHandler tcp_check.GetAllTCPCheckDefaultsHandler
	// TCPRequestRuleGetAllTCPRequestRuleBackendHandler sets the operation handler for the get all TCP request rule backend operation
	TCPRequestRuleGetAllTCPRequestRuleBackendHandler tcp_request_rule.GetAllTCPRequestRuleBackendHandler
	// TCPRequestRuleGetAllTCPRequestRuleFrontendHandler sets the operation handler for the get all TCP request rule frontend operation
	TCPRequestRuleGetAllTCPRequestRuleFrontendHandler tcp_request_rule.GetAllTCPRequestRuleFrontendHandler
	// TCPResponseRuleGetAllTCPResponseRuleBackendHandler sets the operation handler for the get all TCP response rule backend operation
	TCPResponseRuleGetAllTCPResponseRuleBackendHandler tcp_response_rule.GetAllTCPResponseRuleBackendHandler
	// BackendGetBackendHandler sets the operation handler for the get backend operation
	BackendGetBackendHandler backend.GetBackendHandler
	// BackendSwitchingRuleGetBackendSwitchingRuleHandler sets the operation handler for the get backend switching rule operation
	BackendSwitchingRuleGetBackendSwitchingRuleHandler backend_switching_rule.GetBackendSwitchingRuleHandler
	// BackendSwitchingRuleGetBackendSwitchingRulesHandler sets the operation handler for the get backend switching rules operation
	BackendSwitchingRuleGetBackendSwitchingRulesHandler backend_switching_rule.GetBackendSwitchingRulesHandler
	// BackendGetBackendsHandler sets the operation handler for the get backends operation
	BackendGetBackendsHandler backend.GetBackendsHandler
	// BindGetBindFrontendHandler sets the operation handler for the get bind frontend operation
	BindGetBindFrontendHandler bind.GetBindFrontendHandler
	// BindGetBindLogForwardHandler sets the operation handler for the get bind log forward operation
	BindGetBindLogForwardHandler bind.GetBindLogForwardHandler
	// BindGetBindPeerHandler sets the operation handler for the get bind peer operation
	BindGetBindPeerHandler bind.GetBindPeerHandler
	// CacheGetCacheHandler sets the operation handler for the get cache operation
	CacheGetCacheHandler cache.GetCacheHandler
	// CacheGetCachesHandler sets the operation handler for the get caches operation
	CacheGetCachesHandler cache.GetCachesHandler
	// ClusterGetClusterHandler sets the operation handler for the get cluster operation
	ClusterGetClusterHandler cluster.GetClusterHandler
	// DiscoveryGetConfigurationEndpointsHandler sets the operation handler for the get configuration endpoints operation
	DiscoveryGetConfigurationEndpointsHandler discovery.GetConfigurationEndpointsHandler
	// ConfigurationGetConfigurationVersionHandler sets the operation handler for the get configuration version operation
	ConfigurationGetConfigurationVersionHandler configuration.GetConfigurationVersionHandler
	// ServiceDiscoveryGetConsulHandler sets the operation handler for the get consul operation
	ServiceDiscoveryGetConsulHandler service_discovery.GetConsulHandler
	// ServiceDiscoveryGetConsulsHandler sets the operation handler for the get consuls operation
	ServiceDiscoveryGetConsulsHandler service_discovery.GetConsulsHandler
	// CrtLoadGetCrtLoadHandler sets the operation handler for the get crt load operation
	CrtLoadGetCrtLoadHandler crt_load.GetCrtLoadHandler
	// CrtLoadGetCrtLoadsHandler sets the operation handler for the get crt loads operation
	CrtLoadGetCrtLoadsHandler crt_load.GetCrtLoadsHandler
	// CrtStoreGetCrtStoreHandler sets the operation handler for the get crt store operation
	CrtStoreGetCrtStoreHandler crt_store.GetCrtStoreHandler
	// CrtStoreGetCrtStoresHandler sets the operation handler for the get crt stores operation
	CrtStoreGetCrtStoresHandler crt_store.GetCrtStoresHandler
	// DeclareCaptureGetDeclareCaptureHandler sets the operation handler for the get declare capture operation
	DeclareCaptureGetDeclareCaptureHandler declare_capture.GetDeclareCaptureHandler
	// DeclareCaptureGetDeclareCapturesHandler sets the operation handler for the get declare captures operation
	DeclareCaptureGetDeclareCapturesHandler declare_capture.GetDeclareCapturesHandler
	// DefaultsGetDefaultsSectionHandler sets the operation handler for the get defaults section operation
	DefaultsGetDefaultsSectionHandler defaults.GetDefaultsSectionHandler
	// DefaultsGetDefaultsSectionsHandler sets the operation handler for the get defaults sections operation
	DefaultsGetDefaultsSectionsHandler defaults.GetDefaultsSectionsHandler
	// DgramBindGetDgramBindHandler sets the operation handler for the get dgram bind operation
	DgramBindGetDgramBindHandler dgram_bind.GetDgramBindHandler
	// DgramBindGetDgramBindsHandler sets the operation handler for the get dgram binds operation
	DgramBindGetDgramBindsHandler dgram_bind.GetDgramBindsHandler
	// FCGIAppGetFCGIAppHandler sets the operation handler for the get FCGI app operation
	FCGIAppGetFCGIAppHandler fcgi_app.GetFCGIAppHandler
	// FCGIAppGetFCGIAppsHandler sets the operation handler for the get FCGI apps operation
	FCGIAppGetFCGIAppsHandler fcgi_app.GetFCGIAppsHandler
	// FilterGetFilterBackendHandler sets the operation handler for the get filter backend operation
	FilterGetFilterBackendHandler filter.GetFilterBackendHandler
	// FilterGetFilterFrontendHandler sets the operation handler for the get filter frontend operation
	FilterGetFilterFrontendHandler filter.GetFilterFrontendHandler
	// FrontendGetFrontendHandler sets the operation handler for the get frontend operation
	FrontendGetFrontendHandler frontend.GetFrontendHandler
	// FrontendGetFrontendsHandler sets the operation handler for the get frontends operation
	FrontendGetFrontendsHandler frontend.GetFrontendsHandler
	// GlobalGetGlobalHandler sets the operation handler for the get global operation
	GlobalGetGlobalHandler global.GetGlobalHandler
	// GroupGetGroupHandler sets the operation handler for the get group operation
	GroupGetGroupHandler group.GetGroupHandler
	// GroupGetGroupsHandler sets the operation handler for the get groups operation
	GroupGetGroupsHandler group.GetGroupsHandler
	// ConfigurationGetHAProxyConfigurationHandler sets the operation handler for the get h a proxy configuration operation
	ConfigurationGetHAProxyConfigurationHandler configuration.GetHAProxyConfigurationHandler
	// HTTPAfterResponseRuleGetHTTPAfterResponseRuleBackendHandler sets the operation handler for the get HTTP after response rule backend operation
	HTTPAfterResponseRuleGetHTTPAfterResponseRuleBackendHandler http_after_response_rule.GetHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleGetHTTPAfterResponseRuleFrontendHandler sets the operation handler for the get HTTP after response rule frontend operation
	HTTPAfterResponseRuleGetHTTPAfterResponseRuleFrontendHandler http_after_response_rule.GetHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckGetHTTPCheckBackendHandler sets the operation handler for the get HTTP check backend operation
	HTTPCheckGetHTTPCheckBackendHandler http_check.GetHTTPCheckBackendHandler
	// HTTPCheckGetHTTPCheckDefaultsHandler sets the operation handler for the get HTTP check defaults operation
	HTTPCheckGetHTTPCheckDefaultsHandler http_check.GetHTTPCheckDefaultsHandler
	// HTTPErrorRuleGetHTTPErrorRuleBackendHandler sets the operation handler for the get HTTP error rule backend operation
	HTTPErrorRuleGetHTTPErrorRuleBackendHandler http_error_rule.GetHTTPErrorRuleBackendHandler
	// HTTPErrorRuleGetHTTPErrorRuleDefaultsHandler sets the operation handler for the get HTTP error rule defaults operation
	HTTPErrorRuleGetHTTPErrorRuleDefaultsHandler http_error_rule.GetHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleGetHTTPErrorRuleFrontendHandler sets the operation handler for the get HTTP error rule frontend operation
	HTTPErrorRuleGetHTTPErrorRuleFrontendHandler http_error_rule.GetHTTPErrorRuleFrontendHandler
	// HTTPErrorsGetHTTPErrorsSectionHandler sets the operation handler for the get HTTP errors section operation
	HTTPErrorsGetHTTPErrorsSectionHandler http_errors.GetHTTPErrorsSectionHandler
	// HTTPErrorsGetHTTPErrorsSectionsHandler sets the operation handler for the get HTTP errors sections operation
	HTTPErrorsGetHTTPErrorsSectionsHandler http_errors.GetHTTPErrorsSectionsHandler
	// HTTPRequestRuleGetHTTPRequestRuleBackendHandler sets the operation handler for the get HTTP request rule backend operation
	HTTPRequestRuleGetHTTPRequestRuleBackendHandler http_request_rule.GetHTTPRequestRuleBackendHandler
	// HTTPRequestRuleGetHTTPRequestRuleFrontendHandler sets the operation handler for the get HTTP request rule frontend operation
	HTTPRequestRuleGetHTTPRequestRuleFrontendHandler http_request_rule.GetHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleGetHTTPResponseRuleBackendHandler sets the operation handler for the get HTTP response rule backend operation
	HTTPResponseRuleGetHTTPResponseRuleBackendHandler http_response_rule.GetHTTPResponseRuleBackendHandler
	// HTTPResponseRuleGetHTTPResponseRuleFrontendHandler sets the operation handler for the get HTTP response rule frontend operation
	HTTPResponseRuleGetHTTPResponseRuleFrontendHandler http_response_rule.GetHTTPResponseRuleFrontendHandler
	// DiscoveryGetHaproxyEndpointsHandler sets the operation handler for the get haproxy endpoints operation
	DiscoveryGetHaproxyEndpointsHandler discovery.GetHaproxyEndpointsHandler
	// InformationGetHaproxyProcessInfoHandler sets the operation handler for the get haproxy process info operation
	InformationGetHaproxyProcessInfoHandler information.GetHaproxyProcessInfoHandler
	// HealthGetHealthHandler sets the operation handler for the get health operation
	HealthGetHealthHandler health.GetHealthHandler
	// InformationGetInfoHandler sets the operation handler for the get info operation
	InformationGetInfoHandler information.GetInfoHandler
	// LogForwardGetLogForwardHandler sets the operation handler for the get log forward operation
	LogForwardGetLogForwardHandler log_forward.GetLogForwardHandler
	// LogForwardGetLogForwardsHandler sets the operation handler for the get log forwards operation
	LogForwardGetLogForwardsHandler log_forward.GetLogForwardsHandler
	// LogProfileGetLogProfileHandler sets the operation handler for the get log profile operation
	LogProfileGetLogProfileHandler log_profile.GetLogProfileHandler
	// LogProfileGetLogProfilesHandler sets the operation handler for the get log profiles operation
	LogProfileGetLogProfilesHandler log_profile.GetLogProfilesHandler
	// LogTargetGetLogTargetBackendHandler sets the operation handler for the get log target backend operation
	LogTargetGetLogTargetBackendHandler log_target.GetLogTargetBackendHandler
	// LogTargetGetLogTargetDefaultsHandler sets the operation handler for the get log target defaults operation
	LogTargetGetLogTargetDefaultsHandler log_target.GetLogTargetDefaultsHandler
	// LogTargetGetLogTargetFrontendHandler sets the operation handler for the get log target frontend operation
	LogTargetGetLogTargetFrontendHandler log_target.GetLogTargetFrontendHandler
	// LogTargetGetLogTargetGlobalHandler sets the operation handler for the get log target global operation
	LogTargetGetLogTargetGlobalHandler log_target.GetLogTargetGlobalHandler
	// LogTargetGetLogTargetLogForwardHandler sets the operation handler for the get log target log forward operation
	LogTargetGetLogTargetLogForwardHandler log_target.GetLogTargetLogForwardHandler
	// LogTargetGetLogTargetPeerHandler sets the operation handler for the get log target peer operation
	LogTargetGetLogTargetPeerHandler log_target.GetLogTargetPeerHandler
	// MailerEntryGetMailerEntriesHandler sets the operation handler for the get mailer entries operation
	MailerEntryGetMailerEntriesHandler mailer_entry.GetMailerEntriesHandler
	// MailerEntryGetMailerEntryHandler sets the operation handler for the get mailer entry operation
	MailerEntryGetMailerEntryHandler mailer_entry.GetMailerEntryHandler
	// MailersGetMailersSectionHandler sets the operation handler for the get mailers section operation
	MailersGetMailersSectionHandler mailers.GetMailersSectionHandler
	// MailersGetMailersSectionsHandler sets the operation handler for the get mailers sections operation
	MailersGetMailersSectionsHandler mailers.GetMailersSectionsHandler
	// NameserverGetNameserverHandler sets the operation handler for the get nameserver operation
	NameserverGetNameserverHandler nameserver.GetNameserverHandler
	// NameserverGetNameserversHandler sets the operation handler for the get nameservers operation
	NameserverGetNameserversHandler nameserver.GetNameserversHandler
	// MapsGetOneRuntimeMapHandler sets the operation handler for the get one runtime map operation
	MapsGetOneRuntimeMapHandler maps.GetOneRuntimeMapHandler
	// SpoeGetOneSpoeFileHandler sets the operation handler for the get one spoe file operation
	SpoeGetOneSpoeFileHandler spoe.GetOneSpoeFileHandler
	// StorageGetOneStorageGeneralFileHandler sets the operation handler for the get one storage general file operation
	StorageGetOneStorageGeneralFileHandler storage.GetOneStorageGeneralFileHandler
	// StorageGetOneStorageMapHandler sets the operation handler for the get one storage map operation
	StorageGetOneStorageMapHandler storage.GetOneStorageMapHandler
	// StorageGetOneStorageSSLCertificateHandler sets the operation handler for the get one storage s s l certificate operation
	StorageGetOneStorageSSLCertificateHandler storage.GetOneStorageSSLCertificateHandler
	// Version3GetOpenapiv3SpecificationHandler sets the operation handler for the get openapiv3 specification operation
	Version3GetOpenapiv3SpecificationHandler version3.GetOpenapiv3SpecificationHandler
	// PeerEntryGetPeerEntriesHandler sets the operation handler for the get peer entries operation
	PeerEntryGetPeerEntriesHandler peer_entry.GetPeerEntriesHandler
	// PeerEntryGetPeerEntryHandler sets the operation handler for the get peer entry operation
	PeerEntryGetPeerEntryHandler peer_entry.GetPeerEntryHandler
	// PeerGetPeerSectionHandler sets the operation handler for the get peer section operation
	PeerGetPeerSectionHandler peer.GetPeerSectionHandler
	// PeerGetPeerSectionsHandler sets the operation handler for the get peer sections operation
	PeerGetPeerSectionsHandler peer.GetPeerSectionsHandler
	// ProcessManagerGetProgramHandler sets the operation handler for the get program operation
	ProcessManagerGetProgramHandler process_manager.GetProgramHandler
	// ProcessManagerGetProgramsHandler sets the operation handler for the get programs operation
	ProcessManagerGetProgramsHandler process_manager.GetProgramsHandler
	// QUICInitialRuleGetQUICInitialRuleDefaultsHandler sets the operation handler for the get QUIC initial rule defaults operation
	QUICInitialRuleGetQUICInitialRuleDefaultsHandler quic_initial_rule.GetQUICInitialRuleDefaultsHandler
	// QUICInitialRuleGetQUICInitialRuleFrontendHandler sets the operation handler for the get QUIC initial rule frontend operation
	QUICInitialRuleGetQUICInitialRuleFrontendHandler quic_initial_rule.GetQUICInitialRuleFrontendHandler
	// ReloadsGetReloadHandler sets the operation handler for the get reload operation
	ReloadsGetReloadHandler reloads.GetReloadHandler
	// ReloadsGetReloadsHandler sets the operation handler for the get reloads operation
	ReloadsGetReloadsHandler reloads.GetReloadsHandler
	// ResolverGetResolverHandler sets the operation handler for the get resolver operation
	ResolverGetResolverHandler resolver.GetResolverHandler
	// ResolverGetResolversHandler sets the operation handler for the get resolvers operation
	ResolverGetResolversHandler resolver.GetResolversHandler
	// RingGetRingHandler sets the operation handler for the get ring operation
	RingGetRingHandler ring.GetRingHandler
	// RingGetRingsHandler sets the operation handler for the get rings operation
	RingGetRingsHandler ring.GetRingsHandler
	// DiscoveryGetRuntimeEndpointsHandler sets the operation handler for the get runtime endpoints operation
	DiscoveryGetRuntimeEndpointsHandler discovery.GetRuntimeEndpointsHandler
	// MapsGetRuntimeMapEntryHandler sets the operation handler for the get runtime map entry operation
	MapsGetRuntimeMapEntryHandler maps.GetRuntimeMapEntryHandler
	// ServerGetRuntimeServerHandler sets the operation handler for the get runtime server operation
	ServerGetRuntimeServerHandler serverops.GetRuntimeServerHandler
	// ServerGetServerBackendHandler sets the operation handler for the get server backend operation
	ServerGetServerBackendHandler serverops.GetServerBackendHandler
	// ServerGetServerPeerHandler sets the operation handler for the get server peer operation
	ServerGetServerPeerHandler serverops.GetServerPeerHandler
	// ServerGetServerRingHandler sets the operation handler for the get server ring operation
	ServerGetServerRingHandler serverops.GetServerRingHandler
	// ServerSwitchingRuleGetServerSwitchingRuleHandler sets the operation handler for the get server switching rule operation
	ServerSwitchingRuleGetServerSwitchingRuleHandler server_switching_rule.GetServerSwitchingRuleHandler
	// ServerSwitchingRuleGetServerSwitchingRulesHandler sets the operation handler for the get server switching rules operation
	ServerSwitchingRuleGetServerSwitchingRulesHandler server_switching_rule.GetServerSwitchingRulesHandler
	// ServerTemplateGetServerTemplateHandler sets the operation handler for the get server template operation
	ServerTemplateGetServerTemplateHandler server_template.GetServerTemplateHandler
	// ServerTemplateGetServerTemplatesHandler sets the operation handler for the get server templates operation
	ServerTemplateGetServerTemplatesHandler server_template.GetServerTemplatesHandler
	// DiscoveryGetServicesEndpointsHandler sets the operation handler for the get services endpoints operation
	DiscoveryGetServicesEndpointsHandler discovery.GetServicesEndpointsHandler
	// SitesGetSiteHandler sets the operation handler for the get site operation
	SitesGetSiteHandler sites.GetSiteHandler
	// SitesGetSitesHandler sets the operation handler for the get sites operation
	SitesGetSitesHandler sites.GetSitesHandler
	// SpecificationGetSpecificationHandler sets the operation handler for the get specification operation
	SpecificationGetSpecificationHandler specification.GetSpecificationHandler
	// SpoeGetSpoeAgentHandler sets the operation handler for the get spoe agent operation
	SpoeGetSpoeAgentHandler spoe.GetSpoeAgentHandler
	// SpoeGetSpoeConfigurationVersionHandler sets the operation handler for the get spoe configuration version operation
	SpoeGetSpoeConfigurationVersionHandler spoe.GetSpoeConfigurationVersionHandler
	// DiscoveryGetSpoeEndpointsHandler sets the operation handler for the get spoe endpoints operation
	DiscoveryGetSpoeEndpointsHandler discovery.GetSpoeEndpointsHandler
	// SpoeGetSpoeGroupHandler sets the operation handler for the get spoe group operation
	SpoeGetSpoeGroupHandler spoe.GetSpoeGroupHandler
	// SpoeGetSpoeMessageHandler sets the operation handler for the get spoe message operation
	SpoeGetSpoeMessageHandler spoe.GetSpoeMessageHandler
	// SpoeGetSpoeScopeHandler sets the operation handler for the get spoe scope operation
	SpoeGetSpoeScopeHandler spoe.GetSpoeScopeHandler
	// SpoeTransactionsGetSpoeTransactionHandler sets the operation handler for the get spoe transaction operation
	SpoeTransactionsGetSpoeTransactionHandler spoe_transactions.GetSpoeTransactionHandler
	// StatsGetStatsHandler sets the operation handler for the get stats operation
	StatsGetStatsHandler stats.GetStatsHandler
	// DiscoveryGetStatsEndpointsHandler sets the operation handler for the get stats endpoints operation
	DiscoveryGetStatsEndpointsHandler discovery.GetStatsEndpointsHandler
	// StickRuleGetStickRuleHandler sets the operation handler for the get stick rule operation
	StickRuleGetStickRuleHandler stick_rule.GetStickRuleHandler
	// StickRuleGetStickRulesHandler sets the operation handler for the get stick rules operation
	StickRuleGetStickRulesHandler stick_rule.GetStickRulesHandler
	// StickTableGetStickTableHandler sets the operation handler for the get stick table operation
	StickTableGetStickTableHandler stick_table.GetStickTableHandler
	// StickTableGetStickTableEntriesHandler sets the operation handler for the get stick table entries operation
	StickTableGetStickTableEntriesHandler stick_table.GetStickTableEntriesHandler
	// StickTableGetStickTablesHandler sets the operation handler for the get stick tables operation
	StickTableGetStickTablesHandler stick_table.GetStickTablesHandler
	// DiscoveryGetStorageEndpointsHandler sets the operation handler for the get storage endpoints operation
	DiscoveryGetStorageEndpointsHandler discovery.GetStorageEndpointsHandler
	// TCPCheckGetTCPCheckBackendHandler sets the operation handler for the get TCP check backend operation
	TCPCheckGetTCPCheckBackendHandler tcp_check.GetTCPCheckBackendHandler
	// TCPCheckGetTCPCheckDefaultsHandler sets the operation handler for the get TCP check defaults operation
	TCPCheckGetTCPCheckDefaultsHandler tcp_check.GetTCPCheckDefaultsHandler
	// TCPRequestRuleGetTCPRequestRuleBackendHandler sets the operation handler for the get TCP request rule backend operation
	TCPRequestRuleGetTCPRequestRuleBackendHandler tcp_request_rule.GetTCPRequestRuleBackendHandler
	// TCPRequestRuleGetTCPRequestRuleFrontendHandler sets the operation handler for the get TCP request rule frontend operation
	TCPRequestRuleGetTCPRequestRuleFrontendHandler tcp_request_rule.GetTCPRequestRuleFrontendHandler
	// TCPResponseRuleGetTCPResponseRuleBackendHandler sets the operation handler for the get TCP response rule backend operation
	TCPResponseRuleGetTCPResponseRuleBackendHandler tcp_response_rule.GetTCPResponseRuleBackendHandler
	// TableGetTableHandler sets the operation handler for the get table operation
	TableGetTableHandler table.GetTableHandler
	// TableGetTablesHandler sets the operation handler for the get tables operation
	TableGetTablesHandler table.GetTablesHandler
	// TracesGetTracesHandler sets the operation handler for the get traces operation
	TracesGetTracesHandler traces.GetTracesHandler
	// TransactionsGetTransactionHandler sets the operation handler for the get transaction operation
	TransactionsGetTransactionHandler transactions.GetTransactionHandler
	// TransactionsGetTransactionsHandler sets the operation handler for the get transactions operation
	TransactionsGetTransactionsHandler transactions.GetTransactionsHandler
	// UserGetUserHandler sets the operation handler for the get user operation
	UserGetUserHandler user.GetUserHandler
	// UserlistGetUserlistHandler sets the operation handler for the get userlist operation
	UserlistGetUserlistHandler userlist.GetUserlistHandler
	// UserlistGetUserlistsHandler sets the operation handler for the get userlists operation
	UserlistGetUserlistsHandler userlist.GetUserlistsHandler
	// UserGetUsersHandler sets the operation handler for the get users operation
	UserGetUsersHandler user.GetUsersHandler
	// ClusterInitiateCertificateRefreshHandler sets the operation handler for the initiate certificate refresh operation
	ClusterInitiateCertificateRefreshHandler cluster.InitiateCertificateRefreshHandler
	// ClusterPostClusterHandler sets the operation handler for the post cluster operation
	ClusterPostClusterHandler cluster.PostClusterHandler
	// ConfigurationPostHAProxyConfigurationHandler sets the operation handler for the post h a proxy configuration operation
	ConfigurationPostHAProxyConfigurationHandler configuration.PostHAProxyConfigurationHandler
	// ServiceDiscoveryReplaceAWSRegionHandler sets the operation handler for the replace a w s region operation
	ServiceDiscoveryReplaceAWSRegionHandler service_discovery.ReplaceAWSRegionHandler
	// ACLReplaceACLBackendHandler sets the operation handler for the replace Acl backend operation
	ACLReplaceACLBackendHandler acl.ReplaceACLBackendHandler
	// ACLReplaceACLFCGIAppHandler sets the operation handler for the replace Acl FCGI app operation
	ACLReplaceACLFCGIAppHandler acl.ReplaceACLFCGIAppHandler
	// ACLReplaceACLFrontendHandler sets the operation handler for the replace Acl frontend operation
	ACLReplaceACLFrontendHandler acl.ReplaceACLFrontendHandler
	// ACLReplaceAllACLBackendHandler sets the operation handler for the replace all Acl backend operation
	ACLReplaceAllACLBackendHandler acl.ReplaceAllACLBackendHandler
	// ACLReplaceAllACLFCGIAppHandler sets the operation handler for the replace all Acl FCGI app operation
	ACLReplaceAllACLFCGIAppHandler acl.ReplaceAllACLFCGIAppHandler
	// ACLReplaceAllACLFrontendHandler sets the operation handler for the replace all Acl frontend operation
	ACLReplaceAllACLFrontendHandler acl.ReplaceAllACLFrontendHandler
	// FilterReplaceAllFilterBackendHandler sets the operation handler for the replace all filter backend operation
	FilterReplaceAllFilterBackendHandler filter.ReplaceAllFilterBackendHandler
	// FilterReplaceAllFilterFrontendHandler sets the operation handler for the replace all filter frontend operation
	FilterReplaceAllFilterFrontendHandler filter.ReplaceAllFilterFrontendHandler
	// HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleBackendHandler sets the operation handler for the replace all HTTP after response rule backend operation
	HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleBackendHandler http_after_response_rule.ReplaceAllHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleFrontendHandler sets the operation handler for the replace all HTTP after response rule frontend operation
	HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleFrontendHandler http_after_response_rule.ReplaceAllHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckReplaceAllHTTPCheckBackendHandler sets the operation handler for the replace all HTTP check backend operation
	HTTPCheckReplaceAllHTTPCheckBackendHandler http_check.ReplaceAllHTTPCheckBackendHandler
	// HTTPCheckReplaceAllHTTPCheckDefaultsHandler sets the operation handler for the replace all HTTP check defaults operation
	HTTPCheckReplaceAllHTTPCheckDefaultsHandler http_check.ReplaceAllHTTPCheckDefaultsHandler
	// HTTPErrorRuleReplaceAllHTTPErrorRuleBackendHandler sets the operation handler for the replace all HTTP error rule backend operation
	HTTPErrorRuleReplaceAllHTTPErrorRuleBackendHandler http_error_rule.ReplaceAllHTTPErrorRuleBackendHandler
	// HTTPErrorRuleReplaceAllHTTPErrorRuleDefaultsHandler sets the operation handler for the replace all HTTP error rule defaults operation
	HTTPErrorRuleReplaceAllHTTPErrorRuleDefaultsHandler http_error_rule.ReplaceAllHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleReplaceAllHTTPErrorRuleFrontendHandler sets the operation handler for the replace all HTTP error rule frontend operation
	HTTPErrorRuleReplaceAllHTTPErrorRuleFrontendHandler http_error_rule.ReplaceAllHTTPErrorRuleFrontendHandler
	// HTTPRequestRuleReplaceAllHTTPRequestRuleBackendHandler sets the operation handler for the replace all HTTP request rule backend operation
	HTTPRequestRuleReplaceAllHTTPRequestRuleBackendHandler http_request_rule.ReplaceAllHTTPRequestRuleBackendHandler
	// HTTPRequestRuleReplaceAllHTTPRequestRuleFrontendHandler sets the operation handler for the replace all HTTP request rule frontend operation
	HTTPRequestRuleReplaceAllHTTPRequestRuleFrontendHandler http_request_rule.ReplaceAllHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleReplaceAllHTTPResponseRuleBackendHandler sets the operation handler for the replace all HTTP response rule backend operation
	HTTPResponseRuleReplaceAllHTTPResponseRuleBackendHandler http_response_rule.ReplaceAllHTTPResponseRuleBackendHandler
	// HTTPResponseRuleReplaceAllHTTPResponseRuleFrontendHandler sets the operation handler for the replace all HTTP response rule frontend operation
	HTTPResponseRuleReplaceAllHTTPResponseRuleFrontendHandler http_response_rule.ReplaceAllHTTPResponseRuleFrontendHandler
	// LogTargetReplaceAllLogTargetBackendHandler sets the operation handler for the replace all log target backend operation
	LogTargetReplaceAllLogTargetBackendHandler log_target.ReplaceAllLogTargetBackendHandler
	// LogTargetReplaceAllLogTargetDefaultsHandler sets the operation handler for the replace all log target defaults operation
	LogTargetReplaceAllLogTargetDefaultsHandler log_target.ReplaceAllLogTargetDefaultsHandler
	// LogTargetReplaceAllLogTargetFrontendHandler sets the operation handler for the replace all log target frontend operation
	LogTargetReplaceAllLogTargetFrontendHandler log_target.ReplaceAllLogTargetFrontendHandler
	// LogTargetReplaceAllLogTargetGlobalHandler sets the operation handler for the replace all log target global operation
	LogTargetReplaceAllLogTargetGlobalHandler log_target.ReplaceAllLogTargetGlobalHandler
	// LogTargetReplaceAllLogTargetLogForwardHandler sets the operation handler for the replace all log target log forward operation
	LogTargetReplaceAllLogTargetLogForwardHandler log_target.ReplaceAllLogTargetLogForwardHandler
	// LogTargetReplaceAllLogTargetPeerHandler sets the operation handler for the replace all log target peer operation
	LogTargetReplaceAllLogTargetPeerHandler log_target.ReplaceAllLogTargetPeerHandler
	// QUICInitialRuleReplaceAllQUICInitialRuleDefaultsHandler sets the operation handler for the replace all QUIC initial rule defaults operation
	QUICInitialRuleReplaceAllQUICInitialRuleDefaultsHandler quic_initial_rule.ReplaceAllQUICInitialRuleDefaultsHandler
	// QUICInitialRuleReplaceAllQUICInitialRuleFrontendHandler sets the operation handler for the replace all QUIC initial rule frontend operation
	QUICInitialRuleReplaceAllQUICInitialRuleFrontendHandler quic_initial_rule.ReplaceAllQUICInitialRuleFrontendHandler
	// TCPCheckReplaceAllTCPCheckBackendHandler sets the operation handler for the replace all TCP check backend operation
	TCPCheckReplaceAllTCPCheckBackendHandler tcp_check.ReplaceAllTCPCheckBackendHandler
	// TCPCheckReplaceAllTCPCheckDefaultsHandler sets the operation handler for the replace all TCP check defaults operation
	TCPCheckReplaceAllTCPCheckDefaultsHandler tcp_check.ReplaceAllTCPCheckDefaultsHandler
	// TCPRequestRuleReplaceAllTCPRequestRuleBackendHandler sets the operation handler for the replace all TCP request rule backend operation
	TCPRequestRuleReplaceAllTCPRequestRuleBackendHandler tcp_request_rule.ReplaceAllTCPRequestRuleBackendHandler
	// TCPRequestRuleReplaceAllTCPRequestRuleFrontendHandler sets the operation handler for the replace all TCP request rule frontend operation
	TCPRequestRuleReplaceAllTCPRequestRuleFrontendHandler tcp_request_rule.ReplaceAllTCPRequestRuleFrontendHandler
	// TCPResponseRuleReplaceAllTCPResponseRuleBackendHandler sets the operation handler for the replace all TCP response rule backend operation
	TCPResponseRuleReplaceAllTCPResponseRuleBackendHandler tcp_response_rule.ReplaceAllTCPResponseRuleBackendHandler
	// BackendReplaceBackendHandler sets the operation handler for the replace backend operation
	BackendReplaceBackendHandler backend.ReplaceBackendHandler
	// BackendSwitchingRuleReplaceBackendSwitchingRuleHandler sets the operation handler for the replace backend switching rule operation
	BackendSwitchingRuleReplaceBackendSwitchingRuleHandler backend_switching_rule.ReplaceBackendSwitchingRuleHandler
	// BackendSwitchingRuleReplaceBackendSwitchingRulesHandler sets the operation handler for the replace backend switching rules operation
	BackendSwitchingRuleReplaceBackendSwitchingRulesHandler backend_switching_rule.ReplaceBackendSwitchingRulesHandler
	// BindReplaceBindFrontendHandler sets the operation handler for the replace bind frontend operation
	BindReplaceBindFrontendHandler bind.ReplaceBindFrontendHandler
	// BindReplaceBindLogForwardHandler sets the operation handler for the replace bind log forward operation
	BindReplaceBindLogForwardHandler bind.ReplaceBindLogForwardHandler
	// BindReplaceBindPeerHandler sets the operation handler for the replace bind peer operation
	BindReplaceBindPeerHandler bind.ReplaceBindPeerHandler
	// CacheReplaceCacheHandler sets the operation handler for the replace cache operation
	CacheReplaceCacheHandler cache.ReplaceCacheHandler
	// ServiceDiscoveryReplaceConsulHandler sets the operation handler for the replace consul operation
	ServiceDiscoveryReplaceConsulHandler service_discovery.ReplaceConsulHandler
	// CrtLoadReplaceCrtLoadHandler sets the operation handler for the replace crt load operation
	CrtLoadReplaceCrtLoadHandler crt_load.ReplaceCrtLoadHandler
	// DeclareCaptureReplaceDeclareCaptureHandler sets the operation handler for the replace declare capture operation
	DeclareCaptureReplaceDeclareCaptureHandler declare_capture.ReplaceDeclareCaptureHandler
	// DeclareCaptureReplaceDeclareCapturesHandler sets the operation handler for the replace declare captures operation
	DeclareCaptureReplaceDeclareCapturesHandler declare_capture.ReplaceDeclareCapturesHandler
	// DefaultsReplaceDefaultsSectionHandler sets the operation handler for the replace defaults section operation
	DefaultsReplaceDefaultsSectionHandler defaults.ReplaceDefaultsSectionHandler
	// DgramBindReplaceDgramBindHandler sets the operation handler for the replace dgram bind operation
	DgramBindReplaceDgramBindHandler dgram_bind.ReplaceDgramBindHandler
	// FCGIAppReplaceFCGIAppHandler sets the operation handler for the replace FCGI app operation
	FCGIAppReplaceFCGIAppHandler fcgi_app.ReplaceFCGIAppHandler
	// FilterReplaceFilterBackendHandler sets the operation handler for the replace filter backend operation
	FilterReplaceFilterBackendHandler filter.ReplaceFilterBackendHandler
	// FilterReplaceFilterFrontendHandler sets the operation handler for the replace filter frontend operation
	FilterReplaceFilterFrontendHandler filter.ReplaceFilterFrontendHandler
	// FrontendReplaceFrontendHandler sets the operation handler for the replace frontend operation
	FrontendReplaceFrontendHandler frontend.ReplaceFrontendHandler
	// GlobalReplaceGlobalHandler sets the operation handler for the replace global operation
	GlobalReplaceGlobalHandler global.ReplaceGlobalHandler
	// GroupReplaceGroupHandler sets the operation handler for the replace group operation
	GroupReplaceGroupHandler group.ReplaceGroupHandler
	// HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleBackendHandler sets the operation handler for the replace HTTP after response rule backend operation
	HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleBackendHandler http_after_response_rule.ReplaceHTTPAfterResponseRuleBackendHandler
	// HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleFrontendHandler sets the operation handler for the replace HTTP after response rule frontend operation
	HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleFrontendHandler http_after_response_rule.ReplaceHTTPAfterResponseRuleFrontendHandler
	// HTTPCheckReplaceHTTPCheckBackendHandler sets the operation handler for the replace HTTP check backend operation
	HTTPCheckReplaceHTTPCheckBackendHandler http_check.ReplaceHTTPCheckBackendHandler
	// HTTPCheckReplaceHTTPCheckDefaultsHandler sets the operation handler for the replace HTTP check defaults operation
	HTTPCheckReplaceHTTPCheckDefaultsHandler http_check.ReplaceHTTPCheckDefaultsHandler
	// HTTPErrorRuleReplaceHTTPErrorRuleBackendHandler sets the operation handler for the replace HTTP error rule backend operation
	HTTPErrorRuleReplaceHTTPErrorRuleBackendHandler http_error_rule.ReplaceHTTPErrorRuleBackendHandler
	// HTTPErrorRuleReplaceHTTPErrorRuleDefaultsHandler sets the operation handler for the replace HTTP error rule defaults operation
	HTTPErrorRuleReplaceHTTPErrorRuleDefaultsHandler http_error_rule.ReplaceHTTPErrorRuleDefaultsHandler
	// HTTPErrorRuleReplaceHTTPErrorRuleFrontendHandler sets the operation handler for the replace HTTP error rule frontend operation
	HTTPErrorRuleReplaceHTTPErrorRuleFrontendHandler http_error_rule.ReplaceHTTPErrorRuleFrontendHandler
	// HTTPErrorsReplaceHTTPErrorsSectionHandler sets the operation handler for the replace HTTP errors section operation
	HTTPErrorsReplaceHTTPErrorsSectionHandler http_errors.ReplaceHTTPErrorsSectionHandler
	// HTTPRequestRuleReplaceHTTPRequestRuleBackendHandler sets the operation handler for the replace HTTP request rule backend operation
	HTTPRequestRuleReplaceHTTPRequestRuleBackendHandler http_request_rule.ReplaceHTTPRequestRuleBackendHandler
	// HTTPRequestRuleReplaceHTTPRequestRuleFrontendHandler sets the operation handler for the replace HTTP request rule frontend operation
	HTTPRequestRuleReplaceHTTPRequestRuleFrontendHandler http_request_rule.ReplaceHTTPRequestRuleFrontendHandler
	// HTTPResponseRuleReplaceHTTPResponseRuleBackendHandler sets the operation handler for the replace HTTP response rule backend operation
	HTTPResponseRuleReplaceHTTPResponseRuleBackendHandler http_response_rule.ReplaceHTTPResponseRuleBackendHandler
	// HTTPResponseRuleReplaceHTTPResponseRuleFrontendHandler sets the operation handler for the replace HTTP response rule frontend operation
	HTTPResponseRuleReplaceHTTPResponseRuleFrontendHandler http_response_rule.ReplaceHTTPResponseRuleFrontendHandler
	// LogForwardReplaceLogForwardHandler sets the operation handler for the replace log forward operation
	LogForwardReplaceLogForwardHandler log_forward.ReplaceLogForwardHandler
	// LogTargetReplaceLogTargetBackendHandler sets the operation handler for the replace log target backend operation
	LogTargetReplaceLogTargetBackendHandler log_target.ReplaceLogTargetBackendHandler
	// LogTargetReplaceLogTargetDefaultsHandler sets the operation handler for the replace log target defaults operation
	LogTargetReplaceLogTargetDefaultsHandler log_target.ReplaceLogTargetDefaultsHandler
	// LogTargetReplaceLogTargetFrontendHandler sets the operation handler for the replace log target frontend operation
	LogTargetReplaceLogTargetFrontendHandler log_target.ReplaceLogTargetFrontendHandler
	// LogTargetReplaceLogTargetGlobalHandler sets the operation handler for the replace log target global operation
	LogTargetReplaceLogTargetGlobalHandler log_target.ReplaceLogTargetGlobalHandler
	// LogTargetReplaceLogTargetLogForwardHandler sets the operation handler for the replace log target log forward operation
	LogTargetReplaceLogTargetLogForwardHandler log_target.ReplaceLogTargetLogForwardHandler
	// LogTargetReplaceLogTargetPeerHandler sets the operation handler for the replace log target peer operation
	LogTargetReplaceLogTargetPeerHandler log_target.ReplaceLogTargetPeerHandler
	// MailerEntryReplaceMailerEntryHandler sets the operation handler for the replace mailer entry operation
	MailerEntryReplaceMailerEntryHandler mailer_entry.ReplaceMailerEntryHandler
	// NameserverReplaceNameserverHandler sets the operation handler for the replace nameserver operation
	NameserverReplaceNameserverHandler nameserver.ReplaceNameserverHandler
	// PeerEntryReplacePeerEntryHandler sets the operation handler for the replace peer entry operation
	PeerEntryReplacePeerEntryHandler peer_entry.ReplacePeerEntryHandler
	// ProcessManagerReplaceProgramHandler sets the operation handler for the replace program operation
	ProcessManagerReplaceProgramHandler process_manager.ReplaceProgramHandler
	// QUICInitialRuleReplaceQUICInitialRuleDefaultsHandler sets the operation handler for the replace QUIC initial rule defaults operation
	QUICInitialRuleReplaceQUICInitialRuleDefaultsHandler quic_initial_rule.ReplaceQUICInitialRuleDefaultsHandler
	// QUICInitialRuleReplaceQUICInitialRuleFrontendHandler sets the operation handler for the replace QUIC initial rule frontend operation
	QUICInitialRuleReplaceQUICInitialRuleFrontendHandler quic_initial_rule.ReplaceQUICInitialRuleFrontendHandler
	// ResolverReplaceResolverHandler sets the operation handler for the replace resolver operation
	ResolverReplaceResolverHandler resolver.ReplaceResolverHandler
	// RingReplaceRingHandler sets the operation handler for the replace ring operation
	RingReplaceRingHandler ring.ReplaceRingHandler
	// MapsReplaceRuntimeMapEntryHandler sets the operation handler for the replace runtime map entry operation
	MapsReplaceRuntimeMapEntryHandler maps.ReplaceRuntimeMapEntryHandler
	// ServerReplaceRuntimeServerHandler sets the operation handler for the replace runtime server operation
	ServerReplaceRuntimeServerHandler serverops.ReplaceRuntimeServerHandler
	// ServerReplaceServerBackendHandler sets the operation handler for the replace server backend operation
	ServerReplaceServerBackendHandler serverops.ReplaceServerBackendHandler
	// ServerReplaceServerPeerHandler sets the operation handler for the replace server peer operation
	ServerReplaceServerPeerHandler serverops.ReplaceServerPeerHandler
	// ServerReplaceServerRingHandler sets the operation handler for the replace server ring operation
	ServerReplaceServerRingHandler serverops.ReplaceServerRingHandler
	// ServerSwitchingRuleReplaceServerSwitchingRuleHandler sets the operation handler for the replace server switching rule operation
	ServerSwitchingRuleReplaceServerSwitchingRuleHandler server_switching_rule.ReplaceServerSwitchingRuleHandler
	// ServerSwitchingRuleReplaceServerSwitchingRulesHandler sets the operation handler for the replace server switching rules operation
	ServerSwitchingRuleReplaceServerSwitchingRulesHandler server_switching_rule.ReplaceServerSwitchingRulesHandler
	// ServerTemplateReplaceServerTemplateHandler sets the operation handler for the replace server template operation
	ServerTemplateReplaceServerTemplateHandler server_template.ReplaceServerTemplateHandler
	// SitesReplaceSiteHandler sets the operation handler for the replace site operation
	SitesReplaceSiteHandler sites.ReplaceSiteHandler
	// SpoeReplaceSpoeAgentHandler sets the operation handler for the replace spoe agent operation
	SpoeReplaceSpoeAgentHandler spoe.ReplaceSpoeAgentHandler
	// SpoeReplaceSpoeGroupHandler sets the operation handler for the replace spoe group operation
	SpoeReplaceSpoeGroupHandler spoe.ReplaceSpoeGroupHandler
	// SpoeReplaceSpoeMessageHandler sets the operation handler for the replace spoe message operation
	SpoeReplaceSpoeMessageHandler spoe.ReplaceSpoeMessageHandler
	// StickRuleReplaceStickRuleHandler sets the operation handler for the replace stick rule operation
	StickRuleReplaceStickRuleHandler stick_rule.ReplaceStickRuleHandler
	// StickRuleReplaceStickRulesHandler sets the operation handler for the replace stick rules operation
	StickRuleReplaceStickRulesHandler stick_rule.ReplaceStickRulesHandler
	// StorageReplaceStorageGeneralFileHandler sets the operation handler for the replace storage general file operation
	StorageReplaceStorageGeneralFileHandler storage.ReplaceStorageGeneralFileHandler
	// StorageReplaceStorageMapFileHandler sets the operation handler for the replace storage map file operation
	StorageReplaceStorageMapFileHandler storage.ReplaceStorageMapFileHandler
	// StorageReplaceStorageSSLCertificateHandler sets the operation handler for the replace storage s s l certificate operation
	StorageReplaceStorageSSLCertificateHandler storage.ReplaceStorageSSLCertificateHandler
	// TCPCheckReplaceTCPCheckBackendHandler sets the operation handler for the replace TCP check backend operation
	TCPCheckReplaceTCPCheckBackendHandler tcp_check.ReplaceTCPCheckBackendHandler
	// TCPCheckReplaceTCPCheckDefaultsHandler sets the operation handler for the replace TCP check defaults operation
	TCPCheckReplaceTCPCheckDefaultsHandler tcp_check.ReplaceTCPCheckDefaultsHandler
	// TCPRequestRuleReplaceTCPRequestRuleBackendHandler sets the operation handler for the replace TCP request rule backend operation
	TCPRequestRuleReplaceTCPRequestRuleBackendHandler tcp_request_rule.ReplaceTCPRequestRuleBackendHandler
	// TCPRequestRuleReplaceTCPRequestRuleFrontendHandler sets the operation handler for the replace TCP request rule frontend operation
	TCPRequestRuleReplaceTCPRequestRuleFrontendHandler tcp_request_rule.ReplaceTCPRequestRuleFrontendHandler
	// TCPResponseRuleReplaceTCPResponseRuleBackendHandler sets the operation handler for the replace TCP response rule backend operation
	TCPResponseRuleReplaceTCPResponseRuleBackendHandler tcp_response_rule.ReplaceTCPResponseRuleBackendHandler
	// TableReplaceTableHandler sets the operation handler for the replace table operation
	TableReplaceTableHandler table.ReplaceTableHandler
	// TracesReplaceTracesHandler sets the operation handler for the replace traces operation
	TracesReplaceTracesHandler traces.ReplaceTracesHandler
	// UserReplaceUserHandler sets the operation handler for the replace user operation
	UserReplaceUserHandler user.ReplaceUserHandler
	// StickTableSetStickTableEntriesHandler sets the operation handler for the set stick table entries operation
	StickTableSetStickTableEntriesHandler stick_table.SetStickTableEntriesHandler
	// MapsShowRuntimeMapHandler sets the operation handler for the show runtime map operation
	MapsShowRuntimeMapHandler maps.ShowRuntimeMapHandler
	// SpoeTransactionsStartSpoeTransactionHandler sets the operation handler for the start spoe transaction operation
	SpoeTransactionsStartSpoeTransactionHandler spoe_transactions.StartSpoeTransactionHandler
	// TransactionsStartTransactionHandler sets the operation handler for the start transaction operation
	TransactionsStartTransactionHandler transactions.StartTransactionHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// PreServerShutdown is called before the HTTP(S) server is shutdown
	// This allows for custom functions to get executed before the HTTP(S) server stops accepting traffic
	PreServerShutdown func()

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// UseRedoc for documentation at /docs
func (o *DataPlaneAPI) UseRedoc() {
	o.useSwaggerUI = false
}

// UseSwaggerUI for documentation at /docs
func (o *DataPlaneAPI) UseSwaggerUI() {
	o.useSwaggerUI = true
}

// SetDefaultProduces sets the default produces media type
func (o *DataPlaneAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *DataPlaneAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *DataPlaneAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *DataPlaneAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *DataPlaneAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *DataPlaneAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *DataPlaneAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the DataPlaneAPI
func (o *DataPlaneAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}
	if o.MultipartformConsumer == nil {
		unregistered = append(unregistered, "MultipartformConsumer")
	}
	if o.TxtConsumer == nil {
		unregistered = append(unregistered, "TxtConsumer")
	}

	if o.BinProducer == nil {
		unregistered = append(unregistered, "BinProducer")
	}
	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}
	if o.TxtProducer == nil {
		unregistered = append(unregistered, "TxtProducer")
	}

	if o.BasicAuthAuth == nil {
		unregistered = append(unregistered, "BasicAuthAuth")
	}

	if o.ACLRuntimeDeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler == nil {
		unregistered = append(unregistered, "acl_runtime.DeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler")
	}
	if o.ACLRuntimeGetServicesHaproxyRuntimeAclsHandler == nil {
		unregistered = append(unregistered, "acl_runtime.GetServicesHaproxyRuntimeAclsHandler")
	}
	if o.ACLRuntimeGetServicesHaproxyRuntimeAclsIDHandler == nil {
		unregistered = append(unregistered, "acl_runtime.GetServicesHaproxyRuntimeAclsIDHandler")
	}
	if o.ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesHandler == nil {
		unregistered = append(unregistered, "acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesHandler")
	}
	if o.ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler == nil {
		unregistered = append(unregistered, "acl_runtime.GetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler")
	}
	if o.ACLRuntimePostServicesHaproxyRuntimeAclsParentNameEntriesHandler == nil {
		unregistered = append(unregistered, "acl_runtime.PostServicesHaproxyRuntimeAclsParentNameEntriesHandler")
	}
	if o.DefaultsAddDefaultsSectionHandler == nil {
		unregistered = append(unregistered, "defaults.AddDefaultsSectionHandler")
	}
	if o.MapsAddMapEntryHandler == nil {
		unregistered = append(unregistered, "maps.AddMapEntryHandler")
	}
	if o.ACLRuntimeAddPayloadRuntimeACLHandler == nil {
		unregistered = append(unregistered, "acl_runtime.AddPayloadRuntimeACLHandler")
	}
	if o.MapsAddPayloadRuntimeMapHandler == nil {
		unregistered = append(unregistered, "maps.AddPayloadRuntimeMapHandler")
	}
	if o.ServerAddRuntimeServerHandler == nil {
		unregistered = append(unregistered, "server.AddRuntimeServerHandler")
	}
	if o.MapsClearRuntimeMapHandler == nil {
		unregistered = append(unregistered, "maps.ClearRuntimeMapHandler")
	}
	if o.SpoeTransactionsCommitSpoeTransactionHandler == nil {
		unregistered = append(unregistered, "spoe_transactions.CommitSpoeTransactionHandler")
	}
	if o.TransactionsCommitTransactionHandler == nil {
		unregistered = append(unregistered, "transactions.CommitTransactionHandler")
	}
	if o.ServiceDiscoveryCreateAWSRegionHandler == nil {
		unregistered = append(unregistered, "service_discovery.CreateAWSRegionHandler")
	}
	if o.ACLCreateACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.CreateACLBackendHandler")
	}
	if o.ACLCreateACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.CreateACLFCGIAppHandler")
	}
	if o.ACLCreateACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.CreateACLFrontendHandler")
	}
	if o.BackendCreateBackendHandler == nil {
		unregistered = append(unregistered, "backend.CreateBackendHandler")
	}
	if o.BackendSwitchingRuleCreateBackendSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.CreateBackendSwitchingRuleHandler")
	}
	if o.BindCreateBindFrontendHandler == nil {
		unregistered = append(unregistered, "bind.CreateBindFrontendHandler")
	}
	if o.BindCreateBindLogForwardHandler == nil {
		unregistered = append(unregistered, "bind.CreateBindLogForwardHandler")
	}
	if o.BindCreateBindPeerHandler == nil {
		unregistered = append(unregistered, "bind.CreateBindPeerHandler")
	}
	if o.CacheCreateCacheHandler == nil {
		unregistered = append(unregistered, "cache.CreateCacheHandler")
	}
	if o.ServiceDiscoveryCreateConsulHandler == nil {
		unregistered = append(unregistered, "service_discovery.CreateConsulHandler")
	}
	if o.CrtLoadCreateCrtLoadHandler == nil {
		unregistered = append(unregistered, "crt_load.CreateCrtLoadHandler")
	}
	if o.CrtStoreCreateCrtStoreHandler == nil {
		unregistered = append(unregistered, "crt_store.CreateCrtStoreHandler")
	}
	if o.DeclareCaptureCreateDeclareCaptureHandler == nil {
		unregistered = append(unregistered, "declare_capture.CreateDeclareCaptureHandler")
	}
	if o.DefaultsCreateDefaultsSectionHandler == nil {
		unregistered = append(unregistered, "defaults.CreateDefaultsSectionHandler")
	}
	if o.DgramBindCreateDgramBindHandler == nil {
		unregistered = append(unregistered, "dgram_bind.CreateDgramBindHandler")
	}
	if o.FCGIAppCreateFCGIAppHandler == nil {
		unregistered = append(unregistered, "fcgi_app.CreateFCGIAppHandler")
	}
	if o.FilterCreateFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.CreateFilterBackendHandler")
	}
	if o.FilterCreateFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.CreateFilterFrontendHandler")
	}
	if o.FrontendCreateFrontendHandler == nil {
		unregistered = append(unregistered, "frontend.CreateFrontendHandler")
	}
	if o.GroupCreateGroupHandler == nil {
		unregistered = append(unregistered, "group.CreateGroupHandler")
	}
	if o.HTTPAfterResponseRuleCreateHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.CreateHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleCreateHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.CreateHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckCreateHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.CreateHTTPCheckBackendHandler")
	}
	if o.HTTPCheckCreateHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.CreateHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleCreateHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.CreateHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleCreateHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.CreateHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleCreateHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.CreateHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPErrorsCreateHTTPErrorsSectionHandler == nil {
		unregistered = append(unregistered, "http_errors.CreateHTTPErrorsSectionHandler")
	}
	if o.HTTPRequestRuleCreateHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.CreateHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleCreateHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.CreateHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleCreateHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.CreateHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleCreateHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.CreateHTTPResponseRuleFrontendHandler")
	}
	if o.LogForwardCreateLogForwardHandler == nil {
		unregistered = append(unregistered, "log_forward.CreateLogForwardHandler")
	}
	if o.LogProfileCreateLogProfileHandler == nil {
		unregistered = append(unregistered, "log_profile.CreateLogProfileHandler")
	}
	if o.LogTargetCreateLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetBackendHandler")
	}
	if o.LogTargetCreateLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetDefaultsHandler")
	}
	if o.LogTargetCreateLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetFrontendHandler")
	}
	if o.LogTargetCreateLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetGlobalHandler")
	}
	if o.LogTargetCreateLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetLogForwardHandler")
	}
	if o.LogTargetCreateLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.CreateLogTargetPeerHandler")
	}
	if o.MailerEntryCreateMailerEntryHandler == nil {
		unregistered = append(unregistered, "mailer_entry.CreateMailerEntryHandler")
	}
	if o.MailersCreateMailersSectionHandler == nil {
		unregistered = append(unregistered, "mailers.CreateMailersSectionHandler")
	}
	if o.NameserverCreateNameserverHandler == nil {
		unregistered = append(unregistered, "nameserver.CreateNameserverHandler")
	}
	if o.PeerCreatePeerHandler == nil {
		unregistered = append(unregistered, "peer.CreatePeerHandler")
	}
	if o.PeerEntryCreatePeerEntryHandler == nil {
		unregistered = append(unregistered, "peer_entry.CreatePeerEntryHandler")
	}
	if o.ProcessManagerCreateProgramHandler == nil {
		unregistered = append(unregistered, "process_manager.CreateProgramHandler")
	}
	if o.QUICInitialRuleCreateQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.CreateQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleCreateQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.CreateQUICInitialRuleFrontendHandler")
	}
	if o.ResolverCreateResolverHandler == nil {
		unregistered = append(unregistered, "resolver.CreateResolverHandler")
	}
	if o.RingCreateRingHandler == nil {
		unregistered = append(unregistered, "ring.CreateRingHandler")
	}
	if o.ServerCreateServerBackendHandler == nil {
		unregistered = append(unregistered, "server.CreateServerBackendHandler")
	}
	if o.ServerCreateServerPeerHandler == nil {
		unregistered = append(unregistered, "server.CreateServerPeerHandler")
	}
	if o.ServerCreateServerRingHandler == nil {
		unregistered = append(unregistered, "server.CreateServerRingHandler")
	}
	if o.ServerSwitchingRuleCreateServerSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.CreateServerSwitchingRuleHandler")
	}
	if o.ServerTemplateCreateServerTemplateHandler == nil {
		unregistered = append(unregistered, "server_template.CreateServerTemplateHandler")
	}
	if o.SitesCreateSiteHandler == nil {
		unregistered = append(unregistered, "sites.CreateSiteHandler")
	}
	if o.SpoeCreateSpoeHandler == nil {
		unregistered = append(unregistered, "spoe.CreateSpoeHandler")
	}
	if o.SpoeCreateSpoeAgentHandler == nil {
		unregistered = append(unregistered, "spoe.CreateSpoeAgentHandler")
	}
	if o.SpoeCreateSpoeGroupHandler == nil {
		unregistered = append(unregistered, "spoe.CreateSpoeGroupHandler")
	}
	if o.SpoeCreateSpoeMessageHandler == nil {
		unregistered = append(unregistered, "spoe.CreateSpoeMessageHandler")
	}
	if o.SpoeCreateSpoeScopeHandler == nil {
		unregistered = append(unregistered, "spoe.CreateSpoeScopeHandler")
	}
	if o.StickRuleCreateStickRuleHandler == nil {
		unregistered = append(unregistered, "stick_rule.CreateStickRuleHandler")
	}
	if o.StorageCreateStorageGeneralFileHandler == nil {
		unregistered = append(unregistered, "storage.CreateStorageGeneralFileHandler")
	}
	if o.StorageCreateStorageMapFileHandler == nil {
		unregistered = append(unregistered, "storage.CreateStorageMapFileHandler")
	}
	if o.StorageCreateStorageSSLCertificateHandler == nil {
		unregistered = append(unregistered, "storage.CreateStorageSSLCertificateHandler")
	}
	if o.TCPCheckCreateTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.CreateTCPCheckBackendHandler")
	}
	if o.TCPCheckCreateTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.CreateTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleCreateTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.CreateTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleCreateTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.CreateTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleCreateTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.CreateTCPResponseRuleBackendHandler")
	}
	if o.TableCreateTableHandler == nil {
		unregistered = append(unregistered, "table.CreateTableHandler")
	}
	if o.TracesCreateTraceEntryHandler == nil {
		unregistered = append(unregistered, "traces.CreateTraceEntryHandler")
	}
	if o.TracesCreateTracesHandler == nil {
		unregistered = append(unregistered, "traces.CreateTracesHandler")
	}
	if o.UserCreateUserHandler == nil {
		unregistered = append(unregistered, "user.CreateUserHandler")
	}
	if o.UserlistCreateUserlistHandler == nil {
		unregistered = append(unregistered, "userlist.CreateUserlistHandler")
	}
	if o.ServiceDiscoveryDeleteAWSRegionHandler == nil {
		unregistered = append(unregistered, "service_discovery.DeleteAWSRegionHandler")
	}
	if o.ACLDeleteACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.DeleteACLBackendHandler")
	}
	if o.ACLDeleteACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.DeleteACLFCGIAppHandler")
	}
	if o.ACLDeleteACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.DeleteACLFrontendHandler")
	}
	if o.BackendDeleteBackendHandler == nil {
		unregistered = append(unregistered, "backend.DeleteBackendHandler")
	}
	if o.BackendSwitchingRuleDeleteBackendSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.DeleteBackendSwitchingRuleHandler")
	}
	if o.BindDeleteBindFrontendHandler == nil {
		unregistered = append(unregistered, "bind.DeleteBindFrontendHandler")
	}
	if o.BindDeleteBindLogForwardHandler == nil {
		unregistered = append(unregistered, "bind.DeleteBindLogForwardHandler")
	}
	if o.BindDeleteBindPeerHandler == nil {
		unregistered = append(unregistered, "bind.DeleteBindPeerHandler")
	}
	if o.CacheDeleteCacheHandler == nil {
		unregistered = append(unregistered, "cache.DeleteCacheHandler")
	}
	if o.ClusterDeleteClusterHandler == nil {
		unregistered = append(unregistered, "cluster.DeleteClusterHandler")
	}
	if o.ServiceDiscoveryDeleteConsulHandler == nil {
		unregistered = append(unregistered, "service_discovery.DeleteConsulHandler")
	}
	if o.CrtLoadDeleteCrtLoadHandler == nil {
		unregistered = append(unregistered, "crt_load.DeleteCrtLoadHandler")
	}
	if o.CrtStoreDeleteCrtStoreHandler == nil {
		unregistered = append(unregistered, "crt_store.DeleteCrtStoreHandler")
	}
	if o.DeclareCaptureDeleteDeclareCaptureHandler == nil {
		unregistered = append(unregistered, "declare_capture.DeleteDeclareCaptureHandler")
	}
	if o.DefaultsDeleteDefaultsSectionHandler == nil {
		unregistered = append(unregistered, "defaults.DeleteDefaultsSectionHandler")
	}
	if o.DgramBindDeleteDgramBindHandler == nil {
		unregistered = append(unregistered, "dgram_bind.DeleteDgramBindHandler")
	}
	if o.FCGIAppDeleteFCGIAppHandler == nil {
		unregistered = append(unregistered, "fcgi_app.DeleteFCGIAppHandler")
	}
	if o.FilterDeleteFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.DeleteFilterBackendHandler")
	}
	if o.FilterDeleteFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.DeleteFilterFrontendHandler")
	}
	if o.FrontendDeleteFrontendHandler == nil {
		unregistered = append(unregistered, "frontend.DeleteFrontendHandler")
	}
	if o.GroupDeleteGroupHandler == nil {
		unregistered = append(unregistered, "group.DeleteGroupHandler")
	}
	if o.HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.DeleteHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.DeleteHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckDeleteHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.DeleteHTTPCheckBackendHandler")
	}
	if o.HTTPCheckDeleteHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.DeleteHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleDeleteHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.DeleteHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleDeleteHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.DeleteHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleDeleteHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.DeleteHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPErrorsDeleteHTTPErrorsSectionHandler == nil {
		unregistered = append(unregistered, "http_errors.DeleteHTTPErrorsSectionHandler")
	}
	if o.HTTPRequestRuleDeleteHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.DeleteHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleDeleteHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.DeleteHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleDeleteHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.DeleteHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleDeleteHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.DeleteHTTPResponseRuleFrontendHandler")
	}
	if o.LogForwardDeleteLogForwardHandler == nil {
		unregistered = append(unregistered, "log_forward.DeleteLogForwardHandler")
	}
	if o.LogProfileDeleteLogProfileHandler == nil {
		unregistered = append(unregistered, "log_profile.DeleteLogProfileHandler")
	}
	if o.LogTargetDeleteLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetBackendHandler")
	}
	if o.LogTargetDeleteLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetDefaultsHandler")
	}
	if o.LogTargetDeleteLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetFrontendHandler")
	}
	if o.LogTargetDeleteLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetGlobalHandler")
	}
	if o.LogTargetDeleteLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetLogForwardHandler")
	}
	if o.LogTargetDeleteLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.DeleteLogTargetPeerHandler")
	}
	if o.MailerEntryDeleteMailerEntryHandler == nil {
		unregistered = append(unregistered, "mailer_entry.DeleteMailerEntryHandler")
	}
	if o.MailersDeleteMailersSectionHandler == nil {
		unregistered = append(unregistered, "mailers.DeleteMailersSectionHandler")
	}
	if o.NameserverDeleteNameserverHandler == nil {
		unregistered = append(unregistered, "nameserver.DeleteNameserverHandler")
	}
	if o.PeerDeletePeerHandler == nil {
		unregistered = append(unregistered, "peer.DeletePeerHandler")
	}
	if o.PeerEntryDeletePeerEntryHandler == nil {
		unregistered = append(unregistered, "peer_entry.DeletePeerEntryHandler")
	}
	if o.ProcessManagerDeleteProgramHandler == nil {
		unregistered = append(unregistered, "process_manager.DeleteProgramHandler")
	}
	if o.QUICInitialRuleDeleteQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.DeleteQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleDeleteQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.DeleteQUICInitialRuleFrontendHandler")
	}
	if o.ResolverDeleteResolverHandler == nil {
		unregistered = append(unregistered, "resolver.DeleteResolverHandler")
	}
	if o.RingDeleteRingHandler == nil {
		unregistered = append(unregistered, "ring.DeleteRingHandler")
	}
	if o.MapsDeleteRuntimeMapEntryHandler == nil {
		unregistered = append(unregistered, "maps.DeleteRuntimeMapEntryHandler")
	}
	if o.ServerDeleteRuntimeServerHandler == nil {
		unregistered = append(unregistered, "server.DeleteRuntimeServerHandler")
	}
	if o.ServerDeleteServerBackendHandler == nil {
		unregistered = append(unregistered, "server.DeleteServerBackendHandler")
	}
	if o.ServerDeleteServerPeerHandler == nil {
		unregistered = append(unregistered, "server.DeleteServerPeerHandler")
	}
	if o.ServerDeleteServerRingHandler == nil {
		unregistered = append(unregistered, "server.DeleteServerRingHandler")
	}
	if o.ServerSwitchingRuleDeleteServerSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.DeleteServerSwitchingRuleHandler")
	}
	if o.ServerTemplateDeleteServerTemplateHandler == nil {
		unregistered = append(unregistered, "server_template.DeleteServerTemplateHandler")
	}
	if o.SitesDeleteSiteHandler == nil {
		unregistered = append(unregistered, "sites.DeleteSiteHandler")
	}
	if o.SpoeDeleteSpoeAgentHandler == nil {
		unregistered = append(unregistered, "spoe.DeleteSpoeAgentHandler")
	}
	if o.SpoeDeleteSpoeFileHandler == nil {
		unregistered = append(unregistered, "spoe.DeleteSpoeFileHandler")
	}
	if o.SpoeDeleteSpoeGroupHandler == nil {
		unregistered = append(unregistered, "spoe.DeleteSpoeGroupHandler")
	}
	if o.SpoeDeleteSpoeMessageHandler == nil {
		unregistered = append(unregistered, "spoe.DeleteSpoeMessageHandler")
	}
	if o.SpoeDeleteSpoeScopeHandler == nil {
		unregistered = append(unregistered, "spoe.DeleteSpoeScopeHandler")
	}
	if o.SpoeTransactionsDeleteSpoeTransactionHandler == nil {
		unregistered = append(unregistered, "spoe_transactions.DeleteSpoeTransactionHandler")
	}
	if o.StickRuleDeleteStickRuleHandler == nil {
		unregistered = append(unregistered, "stick_rule.DeleteStickRuleHandler")
	}
	if o.StorageDeleteStorageGeneralFileHandler == nil {
		unregistered = append(unregistered, "storage.DeleteStorageGeneralFileHandler")
	}
	if o.StorageDeleteStorageMapHandler == nil {
		unregistered = append(unregistered, "storage.DeleteStorageMapHandler")
	}
	if o.StorageDeleteStorageSSLCertificateHandler == nil {
		unregistered = append(unregistered, "storage.DeleteStorageSSLCertificateHandler")
	}
	if o.TCPCheckDeleteTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.DeleteTCPCheckBackendHandler")
	}
	if o.TCPCheckDeleteTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.DeleteTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleDeleteTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.DeleteTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleDeleteTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.DeleteTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleDeleteTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.DeleteTCPResponseRuleBackendHandler")
	}
	if o.TableDeleteTableHandler == nil {
		unregistered = append(unregistered, "table.DeleteTableHandler")
	}
	if o.TracesDeleteTraceEntryHandler == nil {
		unregistered = append(unregistered, "traces.DeleteTraceEntryHandler")
	}
	if o.TracesDeleteTracesHandler == nil {
		unregistered = append(unregistered, "traces.DeleteTracesHandler")
	}
	if o.TransactionsDeleteTransactionHandler == nil {
		unregistered = append(unregistered, "transactions.DeleteTransactionHandler")
	}
	if o.UserDeleteUserHandler == nil {
		unregistered = append(unregistered, "user.DeleteUserHandler")
	}
	if o.UserlistDeleteUserlistHandler == nil {
		unregistered = append(unregistered, "userlist.DeleteUserlistHandler")
	}
	if o.ClusterEditClusterHandler == nil {
		unregistered = append(unregistered, "cluster.EditClusterHandler")
	}
	if o.CrtStoreEditCrtStoreHandler == nil {
		unregistered = append(unregistered, "crt_store.EditCrtStoreHandler")
	}
	if o.LogProfileEditLogProfileHandler == nil {
		unregistered = append(unregistered, "log_profile.EditLogProfileHandler")
	}
	if o.MailersEditMailersSectionHandler == nil {
		unregistered = append(unregistered, "mailers.EditMailersSectionHandler")
	}
	if o.DiscoveryGetAPIEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetAPIEndpointsHandler")
	}
	if o.ServiceDiscoveryGetAWSRegionHandler == nil {
		unregistered = append(unregistered, "service_discovery.GetAWSRegionHandler")
	}
	if o.ServiceDiscoveryGetAWSRegionsHandler == nil {
		unregistered = append(unregistered, "service_discovery.GetAWSRegionsHandler")
	}
	if o.ACLGetACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.GetACLBackendHandler")
	}
	if o.ACLGetACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.GetACLFCGIAppHandler")
	}
	if o.ACLGetACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.GetACLFrontendHandler")
	}
	if o.ACLGetAllACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.GetAllACLBackendHandler")
	}
	if o.ACLGetAllACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.GetAllACLFCGIAppHandler")
	}
	if o.ACLGetAllACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.GetAllACLFrontendHandler")
	}
	if o.BindGetAllBindFrontendHandler == nil {
		unregistered = append(unregistered, "bind.GetAllBindFrontendHandler")
	}
	if o.BindGetAllBindLogForwardHandler == nil {
		unregistered = append(unregistered, "bind.GetAllBindLogForwardHandler")
	}
	if o.BindGetAllBindPeerHandler == nil {
		unregistered = append(unregistered, "bind.GetAllBindPeerHandler")
	}
	if o.FilterGetAllFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.GetAllFilterBackendHandler")
	}
	if o.FilterGetAllFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.GetAllFilterFrontendHandler")
	}
	if o.HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.GetAllHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.GetAllHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckGetAllHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.GetAllHTTPCheckBackendHandler")
	}
	if o.HTTPCheckGetAllHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.GetAllHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleGetAllHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetAllHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleGetAllHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetAllHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleGetAllHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetAllHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPRequestRuleGetAllHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.GetAllHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleGetAllHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.GetAllHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleGetAllHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.GetAllHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleGetAllHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.GetAllHTTPResponseRuleFrontendHandler")
	}
	if o.LogTargetGetAllLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetBackendHandler")
	}
	if o.LogTargetGetAllLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetDefaultsHandler")
	}
	if o.LogTargetGetAllLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetFrontendHandler")
	}
	if o.LogTargetGetAllLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetGlobalHandler")
	}
	if o.LogTargetGetAllLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetLogForwardHandler")
	}
	if o.LogTargetGetAllLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.GetAllLogTargetPeerHandler")
	}
	if o.QUICInitialRuleGetAllQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.GetAllQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleGetAllQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.GetAllQUICInitialRuleFrontendHandler")
	}
	if o.MapsGetAllRuntimeMapFilesHandler == nil {
		unregistered = append(unregistered, "maps.GetAllRuntimeMapFilesHandler")
	}
	if o.ServerGetAllRuntimeServerHandler == nil {
		unregistered = append(unregistered, "server.GetAllRuntimeServerHandler")
	}
	if o.ServerGetAllServerBackendHandler == nil {
		unregistered = append(unregistered, "server.GetAllServerBackendHandler")
	}
	if o.ServerGetAllServerPeerHandler == nil {
		unregistered = append(unregistered, "server.GetAllServerPeerHandler")
	}
	if o.ServerGetAllServerRingHandler == nil {
		unregistered = append(unregistered, "server.GetAllServerRingHandler")
	}
	if o.SpoeGetAllSpoeAgentHandler == nil {
		unregistered = append(unregistered, "spoe.GetAllSpoeAgentHandler")
	}
	if o.SpoeGetAllSpoeFilesHandler == nil {
		unregistered = append(unregistered, "spoe.GetAllSpoeFilesHandler")
	}
	if o.SpoeGetAllSpoeGroupHandler == nil {
		unregistered = append(unregistered, "spoe.GetAllSpoeGroupHandler")
	}
	if o.SpoeGetAllSpoeMessageHandler == nil {
		unregistered = append(unregistered, "spoe.GetAllSpoeMessageHandler")
	}
	if o.SpoeGetAllSpoeScopeHandler == nil {
		unregistered = append(unregistered, "spoe.GetAllSpoeScopeHandler")
	}
	if o.SpoeTransactionsGetAllSpoeTransactionHandler == nil {
		unregistered = append(unregistered, "spoe_transactions.GetAllSpoeTransactionHandler")
	}
	if o.StorageGetAllStorageGeneralFilesHandler == nil {
		unregistered = append(unregistered, "storage.GetAllStorageGeneralFilesHandler")
	}
	if o.StorageGetAllStorageMapFilesHandler == nil {
		unregistered = append(unregistered, "storage.GetAllStorageMapFilesHandler")
	}
	if o.StorageGetAllStorageSSLCertificatesHandler == nil {
		unregistered = append(unregistered, "storage.GetAllStorageSSLCertificatesHandler")
	}
	if o.TCPCheckGetAllTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.GetAllTCPCheckBackendHandler")
	}
	if o.TCPCheckGetAllTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.GetAllTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleGetAllTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.GetAllTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleGetAllTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.GetAllTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleGetAllTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.GetAllTCPResponseRuleBackendHandler")
	}
	if o.BackendGetBackendHandler == nil {
		unregistered = append(unregistered, "backend.GetBackendHandler")
	}
	if o.BackendSwitchingRuleGetBackendSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.GetBackendSwitchingRuleHandler")
	}
	if o.BackendSwitchingRuleGetBackendSwitchingRulesHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.GetBackendSwitchingRulesHandler")
	}
	if o.BackendGetBackendsHandler == nil {
		unregistered = append(unregistered, "backend.GetBackendsHandler")
	}
	if o.BindGetBindFrontendHandler == nil {
		unregistered = append(unregistered, "bind.GetBindFrontendHandler")
	}
	if o.BindGetBindLogForwardHandler == nil {
		unregistered = append(unregistered, "bind.GetBindLogForwardHandler")
	}
	if o.BindGetBindPeerHandler == nil {
		unregistered = append(unregistered, "bind.GetBindPeerHandler")
	}
	if o.CacheGetCacheHandler == nil {
		unregistered = append(unregistered, "cache.GetCacheHandler")
	}
	if o.CacheGetCachesHandler == nil {
		unregistered = append(unregistered, "cache.GetCachesHandler")
	}
	if o.ClusterGetClusterHandler == nil {
		unregistered = append(unregistered, "cluster.GetClusterHandler")
	}
	if o.DiscoveryGetConfigurationEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetConfigurationEndpointsHandler")
	}
	if o.ConfigurationGetConfigurationVersionHandler == nil {
		unregistered = append(unregistered, "configuration.GetConfigurationVersionHandler")
	}
	if o.ServiceDiscoveryGetConsulHandler == nil {
		unregistered = append(unregistered, "service_discovery.GetConsulHandler")
	}
	if o.ServiceDiscoveryGetConsulsHandler == nil {
		unregistered = append(unregistered, "service_discovery.GetConsulsHandler")
	}
	if o.CrtLoadGetCrtLoadHandler == nil {
		unregistered = append(unregistered, "crt_load.GetCrtLoadHandler")
	}
	if o.CrtLoadGetCrtLoadsHandler == nil {
		unregistered = append(unregistered, "crt_load.GetCrtLoadsHandler")
	}
	if o.CrtStoreGetCrtStoreHandler == nil {
		unregistered = append(unregistered, "crt_store.GetCrtStoreHandler")
	}
	if o.CrtStoreGetCrtStoresHandler == nil {
		unregistered = append(unregistered, "crt_store.GetCrtStoresHandler")
	}
	if o.DeclareCaptureGetDeclareCaptureHandler == nil {
		unregistered = append(unregistered, "declare_capture.GetDeclareCaptureHandler")
	}
	if o.DeclareCaptureGetDeclareCapturesHandler == nil {
		unregistered = append(unregistered, "declare_capture.GetDeclareCapturesHandler")
	}
	if o.DefaultsGetDefaultsSectionHandler == nil {
		unregistered = append(unregistered, "defaults.GetDefaultsSectionHandler")
	}
	if o.DefaultsGetDefaultsSectionsHandler == nil {
		unregistered = append(unregistered, "defaults.GetDefaultsSectionsHandler")
	}
	if o.DgramBindGetDgramBindHandler == nil {
		unregistered = append(unregistered, "dgram_bind.GetDgramBindHandler")
	}
	if o.DgramBindGetDgramBindsHandler == nil {
		unregistered = append(unregistered, "dgram_bind.GetDgramBindsHandler")
	}
	if o.FCGIAppGetFCGIAppHandler == nil {
		unregistered = append(unregistered, "fcgi_app.GetFCGIAppHandler")
	}
	if o.FCGIAppGetFCGIAppsHandler == nil {
		unregistered = append(unregistered, "fcgi_app.GetFCGIAppsHandler")
	}
	if o.FilterGetFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.GetFilterBackendHandler")
	}
	if o.FilterGetFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.GetFilterFrontendHandler")
	}
	if o.FrontendGetFrontendHandler == nil {
		unregistered = append(unregistered, "frontend.GetFrontendHandler")
	}
	if o.FrontendGetFrontendsHandler == nil {
		unregistered = append(unregistered, "frontend.GetFrontendsHandler")
	}
	if o.GlobalGetGlobalHandler == nil {
		unregistered = append(unregistered, "global.GetGlobalHandler")
	}
	if o.GroupGetGroupHandler == nil {
		unregistered = append(unregistered, "group.GetGroupHandler")
	}
	if o.GroupGetGroupsHandler == nil {
		unregistered = append(unregistered, "group.GetGroupsHandler")
	}
	if o.ConfigurationGetHAProxyConfigurationHandler == nil {
		unregistered = append(unregistered, "configuration.GetHAProxyConfigurationHandler")
	}
	if o.HTTPAfterResponseRuleGetHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.GetHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleGetHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.GetHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckGetHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.GetHTTPCheckBackendHandler")
	}
	if o.HTTPCheckGetHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.GetHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleGetHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleGetHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleGetHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.GetHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPErrorsGetHTTPErrorsSectionHandler == nil {
		unregistered = append(unregistered, "http_errors.GetHTTPErrorsSectionHandler")
	}
	if o.HTTPErrorsGetHTTPErrorsSectionsHandler == nil {
		unregistered = append(unregistered, "http_errors.GetHTTPErrorsSectionsHandler")
	}
	if o.HTTPRequestRuleGetHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.GetHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleGetHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.GetHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleGetHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.GetHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleGetHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.GetHTTPResponseRuleFrontendHandler")
	}
	if o.DiscoveryGetHaproxyEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetHaproxyEndpointsHandler")
	}
	if o.InformationGetHaproxyProcessInfoHandler == nil {
		unregistered = append(unregistered, "information.GetHaproxyProcessInfoHandler")
	}
	if o.HealthGetHealthHandler == nil {
		unregistered = append(unregistered, "health.GetHealthHandler")
	}
	if o.InformationGetInfoHandler == nil {
		unregistered = append(unregistered, "information.GetInfoHandler")
	}
	if o.LogForwardGetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_forward.GetLogForwardHandler")
	}
	if o.LogForwardGetLogForwardsHandler == nil {
		unregistered = append(unregistered, "log_forward.GetLogForwardsHandler")
	}
	if o.LogProfileGetLogProfileHandler == nil {
		unregistered = append(unregistered, "log_profile.GetLogProfileHandler")
	}
	if o.LogProfileGetLogProfilesHandler == nil {
		unregistered = append(unregistered, "log_profile.GetLogProfilesHandler")
	}
	if o.LogTargetGetLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetBackendHandler")
	}
	if o.LogTargetGetLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetDefaultsHandler")
	}
	if o.LogTargetGetLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetFrontendHandler")
	}
	if o.LogTargetGetLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetGlobalHandler")
	}
	if o.LogTargetGetLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetLogForwardHandler")
	}
	if o.LogTargetGetLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.GetLogTargetPeerHandler")
	}
	if o.MailerEntryGetMailerEntriesHandler == nil {
		unregistered = append(unregistered, "mailer_entry.GetMailerEntriesHandler")
	}
	if o.MailerEntryGetMailerEntryHandler == nil {
		unregistered = append(unregistered, "mailer_entry.GetMailerEntryHandler")
	}
	if o.MailersGetMailersSectionHandler == nil {
		unregistered = append(unregistered, "mailers.GetMailersSectionHandler")
	}
	if o.MailersGetMailersSectionsHandler == nil {
		unregistered = append(unregistered, "mailers.GetMailersSectionsHandler")
	}
	if o.NameserverGetNameserverHandler == nil {
		unregistered = append(unregistered, "nameserver.GetNameserverHandler")
	}
	if o.NameserverGetNameserversHandler == nil {
		unregistered = append(unregistered, "nameserver.GetNameserversHandler")
	}
	if o.MapsGetOneRuntimeMapHandler == nil {
		unregistered = append(unregistered, "maps.GetOneRuntimeMapHandler")
	}
	if o.SpoeGetOneSpoeFileHandler == nil {
		unregistered = append(unregistered, "spoe.GetOneSpoeFileHandler")
	}
	if o.StorageGetOneStorageGeneralFileHandler == nil {
		unregistered = append(unregistered, "storage.GetOneStorageGeneralFileHandler")
	}
	if o.StorageGetOneStorageMapHandler == nil {
		unregistered = append(unregistered, "storage.GetOneStorageMapHandler")
	}
	if o.StorageGetOneStorageSSLCertificateHandler == nil {
		unregistered = append(unregistered, "storage.GetOneStorageSSLCertificateHandler")
	}
	if o.Version3GetOpenapiv3SpecificationHandler == nil {
		unregistered = append(unregistered, "version3.GetOpenapiv3SpecificationHandler")
	}
	if o.PeerEntryGetPeerEntriesHandler == nil {
		unregistered = append(unregistered, "peer_entry.GetPeerEntriesHandler")
	}
	if o.PeerEntryGetPeerEntryHandler == nil {
		unregistered = append(unregistered, "peer_entry.GetPeerEntryHandler")
	}
	if o.PeerGetPeerSectionHandler == nil {
		unregistered = append(unregistered, "peer.GetPeerSectionHandler")
	}
	if o.PeerGetPeerSectionsHandler == nil {
		unregistered = append(unregistered, "peer.GetPeerSectionsHandler")
	}
	if o.ProcessManagerGetProgramHandler == nil {
		unregistered = append(unregistered, "process_manager.GetProgramHandler")
	}
	if o.ProcessManagerGetProgramsHandler == nil {
		unregistered = append(unregistered, "process_manager.GetProgramsHandler")
	}
	if o.QUICInitialRuleGetQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.GetQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleGetQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.GetQUICInitialRuleFrontendHandler")
	}
	if o.ReloadsGetReloadHandler == nil {
		unregistered = append(unregistered, "reloads.GetReloadHandler")
	}
	if o.ReloadsGetReloadsHandler == nil {
		unregistered = append(unregistered, "reloads.GetReloadsHandler")
	}
	if o.ResolverGetResolverHandler == nil {
		unregistered = append(unregistered, "resolver.GetResolverHandler")
	}
	if o.ResolverGetResolversHandler == nil {
		unregistered = append(unregistered, "resolver.GetResolversHandler")
	}
	if o.RingGetRingHandler == nil {
		unregistered = append(unregistered, "ring.GetRingHandler")
	}
	if o.RingGetRingsHandler == nil {
		unregistered = append(unregistered, "ring.GetRingsHandler")
	}
	if o.DiscoveryGetRuntimeEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetRuntimeEndpointsHandler")
	}
	if o.MapsGetRuntimeMapEntryHandler == nil {
		unregistered = append(unregistered, "maps.GetRuntimeMapEntryHandler")
	}
	if o.ServerGetRuntimeServerHandler == nil {
		unregistered = append(unregistered, "server.GetRuntimeServerHandler")
	}
	if o.ServerGetServerBackendHandler == nil {
		unregistered = append(unregistered, "server.GetServerBackendHandler")
	}
	if o.ServerGetServerPeerHandler == nil {
		unregistered = append(unregistered, "server.GetServerPeerHandler")
	}
	if o.ServerGetServerRingHandler == nil {
		unregistered = append(unregistered, "server.GetServerRingHandler")
	}
	if o.ServerSwitchingRuleGetServerSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.GetServerSwitchingRuleHandler")
	}
	if o.ServerSwitchingRuleGetServerSwitchingRulesHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.GetServerSwitchingRulesHandler")
	}
	if o.ServerTemplateGetServerTemplateHandler == nil {
		unregistered = append(unregistered, "server_template.GetServerTemplateHandler")
	}
	if o.ServerTemplateGetServerTemplatesHandler == nil {
		unregistered = append(unregistered, "server_template.GetServerTemplatesHandler")
	}
	if o.DiscoveryGetServicesEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetServicesEndpointsHandler")
	}
	if o.SitesGetSiteHandler == nil {
		unregistered = append(unregistered, "sites.GetSiteHandler")
	}
	if o.SitesGetSitesHandler == nil {
		unregistered = append(unregistered, "sites.GetSitesHandler")
	}
	if o.SpecificationGetSpecificationHandler == nil {
		unregistered = append(unregistered, "specification.GetSpecificationHandler")
	}
	if o.SpoeGetSpoeAgentHandler == nil {
		unregistered = append(unregistered, "spoe.GetSpoeAgentHandler")
	}
	if o.SpoeGetSpoeConfigurationVersionHandler == nil {
		unregistered = append(unregistered, "spoe.GetSpoeConfigurationVersionHandler")
	}
	if o.DiscoveryGetSpoeEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetSpoeEndpointsHandler")
	}
	if o.SpoeGetSpoeGroupHandler == nil {
		unregistered = append(unregistered, "spoe.GetSpoeGroupHandler")
	}
	if o.SpoeGetSpoeMessageHandler == nil {
		unregistered = append(unregistered, "spoe.GetSpoeMessageHandler")
	}
	if o.SpoeGetSpoeScopeHandler == nil {
		unregistered = append(unregistered, "spoe.GetSpoeScopeHandler")
	}
	if o.SpoeTransactionsGetSpoeTransactionHandler == nil {
		unregistered = append(unregistered, "spoe_transactions.GetSpoeTransactionHandler")
	}
	if o.StatsGetStatsHandler == nil {
		unregistered = append(unregistered, "stats.GetStatsHandler")
	}
	if o.DiscoveryGetStatsEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetStatsEndpointsHandler")
	}
	if o.StickRuleGetStickRuleHandler == nil {
		unregistered = append(unregistered, "stick_rule.GetStickRuleHandler")
	}
	if o.StickRuleGetStickRulesHandler == nil {
		unregistered = append(unregistered, "stick_rule.GetStickRulesHandler")
	}
	if o.StickTableGetStickTableHandler == nil {
		unregistered = append(unregistered, "stick_table.GetStickTableHandler")
	}
	if o.StickTableGetStickTableEntriesHandler == nil {
		unregistered = append(unregistered, "stick_table.GetStickTableEntriesHandler")
	}
	if o.StickTableGetStickTablesHandler == nil {
		unregistered = append(unregistered, "stick_table.GetStickTablesHandler")
	}
	if o.DiscoveryGetStorageEndpointsHandler == nil {
		unregistered = append(unregistered, "discovery.GetStorageEndpointsHandler")
	}
	if o.TCPCheckGetTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.GetTCPCheckBackendHandler")
	}
	if o.TCPCheckGetTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.GetTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleGetTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.GetTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleGetTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.GetTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleGetTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.GetTCPResponseRuleBackendHandler")
	}
	if o.TableGetTableHandler == nil {
		unregistered = append(unregistered, "table.GetTableHandler")
	}
	if o.TableGetTablesHandler == nil {
		unregistered = append(unregistered, "table.GetTablesHandler")
	}
	if o.TracesGetTracesHandler == nil {
		unregistered = append(unregistered, "traces.GetTracesHandler")
	}
	if o.TransactionsGetTransactionHandler == nil {
		unregistered = append(unregistered, "transactions.GetTransactionHandler")
	}
	if o.TransactionsGetTransactionsHandler == nil {
		unregistered = append(unregistered, "transactions.GetTransactionsHandler")
	}
	if o.UserGetUserHandler == nil {
		unregistered = append(unregistered, "user.GetUserHandler")
	}
	if o.UserlistGetUserlistHandler == nil {
		unregistered = append(unregistered, "userlist.GetUserlistHandler")
	}
	if o.UserlistGetUserlistsHandler == nil {
		unregistered = append(unregistered, "userlist.GetUserlistsHandler")
	}
	if o.UserGetUsersHandler == nil {
		unregistered = append(unregistered, "user.GetUsersHandler")
	}
	if o.ClusterInitiateCertificateRefreshHandler == nil {
		unregistered = append(unregistered, "cluster.InitiateCertificateRefreshHandler")
	}
	if o.ClusterPostClusterHandler == nil {
		unregistered = append(unregistered, "cluster.PostClusterHandler")
	}
	if o.ConfigurationPostHAProxyConfigurationHandler == nil {
		unregistered = append(unregistered, "configuration.PostHAProxyConfigurationHandler")
	}
	if o.ServiceDiscoveryReplaceAWSRegionHandler == nil {
		unregistered = append(unregistered, "service_discovery.ReplaceAWSRegionHandler")
	}
	if o.ACLReplaceACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceACLBackendHandler")
	}
	if o.ACLReplaceACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceACLFCGIAppHandler")
	}
	if o.ACLReplaceACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceACLFrontendHandler")
	}
	if o.ACLReplaceAllACLBackendHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceAllACLBackendHandler")
	}
	if o.ACLReplaceAllACLFCGIAppHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceAllACLFCGIAppHandler")
	}
	if o.ACLReplaceAllACLFrontendHandler == nil {
		unregistered = append(unregistered, "acl.ReplaceAllACLFrontendHandler")
	}
	if o.FilterReplaceAllFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.ReplaceAllFilterBackendHandler")
	}
	if o.FilterReplaceAllFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.ReplaceAllFilterFrontendHandler")
	}
	if o.HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.ReplaceAllHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.ReplaceAllHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckReplaceAllHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.ReplaceAllHTTPCheckBackendHandler")
	}
	if o.HTTPCheckReplaceAllHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.ReplaceAllHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleReplaceAllHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceAllHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleReplaceAllHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceAllHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleReplaceAllHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceAllHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPRequestRuleReplaceAllHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.ReplaceAllHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleReplaceAllHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.ReplaceAllHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleReplaceAllHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.ReplaceAllHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleReplaceAllHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.ReplaceAllHTTPResponseRuleFrontendHandler")
	}
	if o.LogTargetReplaceAllLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetBackendHandler")
	}
	if o.LogTargetReplaceAllLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetDefaultsHandler")
	}
	if o.LogTargetReplaceAllLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetFrontendHandler")
	}
	if o.LogTargetReplaceAllLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetGlobalHandler")
	}
	if o.LogTargetReplaceAllLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetLogForwardHandler")
	}
	if o.LogTargetReplaceAllLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceAllLogTargetPeerHandler")
	}
	if o.QUICInitialRuleReplaceAllQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.ReplaceAllQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleReplaceAllQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.ReplaceAllQUICInitialRuleFrontendHandler")
	}
	if o.TCPCheckReplaceAllTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.ReplaceAllTCPCheckBackendHandler")
	}
	if o.TCPCheckReplaceAllTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.ReplaceAllTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleReplaceAllTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.ReplaceAllTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleReplaceAllTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.ReplaceAllTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleReplaceAllTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.ReplaceAllTCPResponseRuleBackendHandler")
	}
	if o.BackendReplaceBackendHandler == nil {
		unregistered = append(unregistered, "backend.ReplaceBackendHandler")
	}
	if o.BackendSwitchingRuleReplaceBackendSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.ReplaceBackendSwitchingRuleHandler")
	}
	if o.BackendSwitchingRuleReplaceBackendSwitchingRulesHandler == nil {
		unregistered = append(unregistered, "backend_switching_rule.ReplaceBackendSwitchingRulesHandler")
	}
	if o.BindReplaceBindFrontendHandler == nil {
		unregistered = append(unregistered, "bind.ReplaceBindFrontendHandler")
	}
	if o.BindReplaceBindLogForwardHandler == nil {
		unregistered = append(unregistered, "bind.ReplaceBindLogForwardHandler")
	}
	if o.BindReplaceBindPeerHandler == nil {
		unregistered = append(unregistered, "bind.ReplaceBindPeerHandler")
	}
	if o.CacheReplaceCacheHandler == nil {
		unregistered = append(unregistered, "cache.ReplaceCacheHandler")
	}
	if o.ServiceDiscoveryReplaceConsulHandler == nil {
		unregistered = append(unregistered, "service_discovery.ReplaceConsulHandler")
	}
	if o.CrtLoadReplaceCrtLoadHandler == nil {
		unregistered = append(unregistered, "crt_load.ReplaceCrtLoadHandler")
	}
	if o.DeclareCaptureReplaceDeclareCaptureHandler == nil {
		unregistered = append(unregistered, "declare_capture.ReplaceDeclareCaptureHandler")
	}
	if o.DeclareCaptureReplaceDeclareCapturesHandler == nil {
		unregistered = append(unregistered, "declare_capture.ReplaceDeclareCapturesHandler")
	}
	if o.DefaultsReplaceDefaultsSectionHandler == nil {
		unregistered = append(unregistered, "defaults.ReplaceDefaultsSectionHandler")
	}
	if o.DgramBindReplaceDgramBindHandler == nil {
		unregistered = append(unregistered, "dgram_bind.ReplaceDgramBindHandler")
	}
	if o.FCGIAppReplaceFCGIAppHandler == nil {
		unregistered = append(unregistered, "fcgi_app.ReplaceFCGIAppHandler")
	}
	if o.FilterReplaceFilterBackendHandler == nil {
		unregistered = append(unregistered, "filter.ReplaceFilterBackendHandler")
	}
	if o.FilterReplaceFilterFrontendHandler == nil {
		unregistered = append(unregistered, "filter.ReplaceFilterFrontendHandler")
	}
	if o.FrontendReplaceFrontendHandler == nil {
		unregistered = append(unregistered, "frontend.ReplaceFrontendHandler")
	}
	if o.GlobalReplaceGlobalHandler == nil {
		unregistered = append(unregistered, "global.ReplaceGlobalHandler")
	}
	if o.GroupReplaceGroupHandler == nil {
		unregistered = append(unregistered, "group.ReplaceGroupHandler")
	}
	if o.HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.ReplaceHTTPAfterResponseRuleBackendHandler")
	}
	if o.HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_after_response_rule.ReplaceHTTPAfterResponseRuleFrontendHandler")
	}
	if o.HTTPCheckReplaceHTTPCheckBackendHandler == nil {
		unregistered = append(unregistered, "http_check.ReplaceHTTPCheckBackendHandler")
	}
	if o.HTTPCheckReplaceHTTPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "http_check.ReplaceHTTPCheckDefaultsHandler")
	}
	if o.HTTPErrorRuleReplaceHTTPErrorRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceHTTPErrorRuleBackendHandler")
	}
	if o.HTTPErrorRuleReplaceHTTPErrorRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceHTTPErrorRuleDefaultsHandler")
	}
	if o.HTTPErrorRuleReplaceHTTPErrorRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_error_rule.ReplaceHTTPErrorRuleFrontendHandler")
	}
	if o.HTTPErrorsReplaceHTTPErrorsSectionHandler == nil {
		unregistered = append(unregistered, "http_errors.ReplaceHTTPErrorsSectionHandler")
	}
	if o.HTTPRequestRuleReplaceHTTPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.ReplaceHTTPRequestRuleBackendHandler")
	}
	if o.HTTPRequestRuleReplaceHTTPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_request_rule.ReplaceHTTPRequestRuleFrontendHandler")
	}
	if o.HTTPResponseRuleReplaceHTTPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.ReplaceHTTPResponseRuleBackendHandler")
	}
	if o.HTTPResponseRuleReplaceHTTPResponseRuleFrontendHandler == nil {
		unregistered = append(unregistered, "http_response_rule.ReplaceHTTPResponseRuleFrontendHandler")
	}
	if o.LogForwardReplaceLogForwardHandler == nil {
		unregistered = append(unregistered, "log_forward.ReplaceLogForwardHandler")
	}
	if o.LogTargetReplaceLogTargetBackendHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetBackendHandler")
	}
	if o.LogTargetReplaceLogTargetDefaultsHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetDefaultsHandler")
	}
	if o.LogTargetReplaceLogTargetFrontendHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetFrontendHandler")
	}
	if o.LogTargetReplaceLogTargetGlobalHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetGlobalHandler")
	}
	if o.LogTargetReplaceLogTargetLogForwardHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetLogForwardHandler")
	}
	if o.LogTargetReplaceLogTargetPeerHandler == nil {
		unregistered = append(unregistered, "log_target.ReplaceLogTargetPeerHandler")
	}
	if o.MailerEntryReplaceMailerEntryHandler == nil {
		unregistered = append(unregistered, "mailer_entry.ReplaceMailerEntryHandler")
	}
	if o.NameserverReplaceNameserverHandler == nil {
		unregistered = append(unregistered, "nameserver.ReplaceNameserverHandler")
	}
	if o.PeerEntryReplacePeerEntryHandler == nil {
		unregistered = append(unregistered, "peer_entry.ReplacePeerEntryHandler")
	}
	if o.ProcessManagerReplaceProgramHandler == nil {
		unregistered = append(unregistered, "process_manager.ReplaceProgramHandler")
	}
	if o.QUICInitialRuleReplaceQUICInitialRuleDefaultsHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.ReplaceQUICInitialRuleDefaultsHandler")
	}
	if o.QUICInitialRuleReplaceQUICInitialRuleFrontendHandler == nil {
		unregistered = append(unregistered, "quic_initial_rule.ReplaceQUICInitialRuleFrontendHandler")
	}
	if o.ResolverReplaceResolverHandler == nil {
		unregistered = append(unregistered, "resolver.ReplaceResolverHandler")
	}
	if o.RingReplaceRingHandler == nil {
		unregistered = append(unregistered, "ring.ReplaceRingHandler")
	}
	if o.MapsReplaceRuntimeMapEntryHandler == nil {
		unregistered = append(unregistered, "maps.ReplaceRuntimeMapEntryHandler")
	}
	if o.ServerReplaceRuntimeServerHandler == nil {
		unregistered = append(unregistered, "server.ReplaceRuntimeServerHandler")
	}
	if o.ServerReplaceServerBackendHandler == nil {
		unregistered = append(unregistered, "server.ReplaceServerBackendHandler")
	}
	if o.ServerReplaceServerPeerHandler == nil {
		unregistered = append(unregistered, "server.ReplaceServerPeerHandler")
	}
	if o.ServerReplaceServerRingHandler == nil {
		unregistered = append(unregistered, "server.ReplaceServerRingHandler")
	}
	if o.ServerSwitchingRuleReplaceServerSwitchingRuleHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.ReplaceServerSwitchingRuleHandler")
	}
	if o.ServerSwitchingRuleReplaceServerSwitchingRulesHandler == nil {
		unregistered = append(unregistered, "server_switching_rule.ReplaceServerSwitchingRulesHandler")
	}
	if o.ServerTemplateReplaceServerTemplateHandler == nil {
		unregistered = append(unregistered, "server_template.ReplaceServerTemplateHandler")
	}
	if o.SitesReplaceSiteHandler == nil {
		unregistered = append(unregistered, "sites.ReplaceSiteHandler")
	}
	if o.SpoeReplaceSpoeAgentHandler == nil {
		unregistered = append(unregistered, "spoe.ReplaceSpoeAgentHandler")
	}
	if o.SpoeReplaceSpoeGroupHandler == nil {
		unregistered = append(unregistered, "spoe.ReplaceSpoeGroupHandler")
	}
	if o.SpoeReplaceSpoeMessageHandler == nil {
		unregistered = append(unregistered, "spoe.ReplaceSpoeMessageHandler")
	}
	if o.StickRuleReplaceStickRuleHandler == nil {
		unregistered = append(unregistered, "stick_rule.ReplaceStickRuleHandler")
	}
	if o.StickRuleReplaceStickRulesHandler == nil {
		unregistered = append(unregistered, "stick_rule.ReplaceStickRulesHandler")
	}
	if o.StorageReplaceStorageGeneralFileHandler == nil {
		unregistered = append(unregistered, "storage.ReplaceStorageGeneralFileHandler")
	}
	if o.StorageReplaceStorageMapFileHandler == nil {
		unregistered = append(unregistered, "storage.ReplaceStorageMapFileHandler")
	}
	if o.StorageReplaceStorageSSLCertificateHandler == nil {
		unregistered = append(unregistered, "storage.ReplaceStorageSSLCertificateHandler")
	}
	if o.TCPCheckReplaceTCPCheckBackendHandler == nil {
		unregistered = append(unregistered, "tcp_check.ReplaceTCPCheckBackendHandler")
	}
	if o.TCPCheckReplaceTCPCheckDefaultsHandler == nil {
		unregistered = append(unregistered, "tcp_check.ReplaceTCPCheckDefaultsHandler")
	}
	if o.TCPRequestRuleReplaceTCPRequestRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.ReplaceTCPRequestRuleBackendHandler")
	}
	if o.TCPRequestRuleReplaceTCPRequestRuleFrontendHandler == nil {
		unregistered = append(unregistered, "tcp_request_rule.ReplaceTCPRequestRuleFrontendHandler")
	}
	if o.TCPResponseRuleReplaceTCPResponseRuleBackendHandler == nil {
		unregistered = append(unregistered, "tcp_response_rule.ReplaceTCPResponseRuleBackendHandler")
	}
	if o.TableReplaceTableHandler == nil {
		unregistered = append(unregistered, "table.ReplaceTableHandler")
	}
	if o.TracesReplaceTracesHandler == nil {
		unregistered = append(unregistered, "traces.ReplaceTracesHandler")
	}
	if o.UserReplaceUserHandler == nil {
		unregistered = append(unregistered, "user.ReplaceUserHandler")
	}
	if o.StickTableSetStickTableEntriesHandler == nil {
		unregistered = append(unregistered, "stick_table.SetStickTableEntriesHandler")
	}
	if o.MapsShowRuntimeMapHandler == nil {
		unregistered = append(unregistered, "maps.ShowRuntimeMapHandler")
	}
	if o.SpoeTransactionsStartSpoeTransactionHandler == nil {
		unregistered = append(unregistered, "spoe_transactions.StartSpoeTransactionHandler")
	}
	if o.TransactionsStartTransactionHandler == nil {
		unregistered = append(unregistered, "transactions.StartTransactionHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *DataPlaneAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *DataPlaneAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {
	result := make(map[string]runtime.Authenticator)
	for name := range schemes {
		switch name {
		case "basic_auth":
			result[name] = o.BasicAuthenticator(o.BasicAuthAuth)

		}
	}
	return result
}

// Authorizer returns the registered authorizer
func (o *DataPlaneAPI) Authorizer() runtime.Authorizer {
	return o.APIAuthorizer
}

// ConsumersFor gets the consumers for the specified media types.
// MIME type parameters are ignored here.
func (o *DataPlaneAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {
	result := make(map[string]runtime.Consumer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONConsumer
		case "multipart/form-data":
			result["multipart/form-data"] = o.MultipartformConsumer
		case "text/plain":
			result["text/plain"] = o.TxtConsumer
		}

		if c, ok := o.customConsumers[mt]; ok {
			result[mt] = c
		}
	}
	return result
}

// ProducersFor gets the producers for the specified media types.
// MIME type parameters are ignored here.
func (o *DataPlaneAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {
	result := make(map[string]runtime.Producer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/octet-stream":
			result["application/octet-stream"] = o.BinProducer
		case "application/json":
			result["application/json"] = o.JSONProducer
		case "text/plain":
			result["text/plain"] = o.TxtProducer
		}

		if p, ok := o.customProducers[mt]; ok {
			result[mt] = p
		}
	}
	return result
}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *DataPlaneAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the data plane API
func (o *DataPlaneAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *DataPlaneAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened
	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/runtime/acls/{parent_name}/entries/{id}"] = acl_runtime.NewDeleteServicesHaproxyRuntimeAclsParentNameEntriesID(o.context, o.ACLRuntimeDeleteServicesHaproxyRuntimeAclsParentNameEntriesIDHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/acls"] = acl_runtime.NewGetServicesHaproxyRuntimeAcls(o.context, o.ACLRuntimeGetServicesHaproxyRuntimeAclsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/acls/{id}"] = acl_runtime.NewGetServicesHaproxyRuntimeAclsID(o.context, o.ACLRuntimeGetServicesHaproxyRuntimeAclsIDHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/acls/{parent_name}/entries"] = acl_runtime.NewGetServicesHaproxyRuntimeAclsParentNameEntries(o.context, o.ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/acls/{parent_name}/entries/{id}"] = acl_runtime.NewGetServicesHaproxyRuntimeAclsParentNameEntriesID(o.context, o.ACLRuntimeGetServicesHaproxyRuntimeAclsParentNameEntriesIDHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/runtime/acls/{parent_name}/entries"] = acl_runtime.NewPostServicesHaproxyRuntimeAclsParentNameEntries(o.context, o.ACLRuntimePostServicesHaproxyRuntimeAclsParentNameEntriesHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults"] = defaults.NewAddDefaultsSection(o.context, o.DefaultsAddDefaultsSectionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/runtime/maps/{parent_name}/entries"] = maps.NewAddMapEntry(o.context, o.MapsAddMapEntryHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/runtime/acls/{parent_name}/entries"] = acl_runtime.NewAddPayloadRuntimeACL(o.context, o.ACLRuntimeAddPayloadRuntimeACLHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/runtime/maps/{name}"] = maps.NewAddPayloadRuntimeMap(o.context, o.MapsAddPayloadRuntimeMapHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/runtime/backends/{parent_name}/servers"] = serverops.NewAddRuntimeServer(o.context, o.ServerAddRuntimeServerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/runtime/maps/{name}"] = maps.NewClearRuntimeMap(o.context, o.MapsClearRuntimeMapHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/spoe/spoe_files/{parent_name}/transactions/{id}"] = spoe_transactions.NewCommitSpoeTransaction(o.context, o.SpoeTransactionsCommitSpoeTransactionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/transactions/{id}"] = transactions.NewCommitTransaction(o.context, o.TransactionsCommitTransactionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/service_discovery/aws"] = service_discovery.NewCreateAWSRegion(o.context, o.ServiceDiscoveryCreateAWSRegionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/acls/{index}"] = acl.NewCreateACLBackend(o.context, o.ACLCreateACLBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls/{index}"] = acl.NewCreateACLFCGIApp(o.context, o.ACLCreateACLFCGIAppHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/acls/{index}"] = acl.NewCreateACLFrontend(o.context, o.ACLCreateACLFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends"] = backend.NewCreateBackend(o.context, o.BackendCreateBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules/{index}"] = backend_switching_rule.NewCreateBackendSwitchingRule(o.context, o.BackendSwitchingRuleCreateBackendSwitchingRuleHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/binds"] = bind.NewCreateBindFrontend(o.context, o.BindCreateBindFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/log_forwards/{parent_name}/binds"] = bind.NewCreateBindLogForward(o.context, o.BindCreateBindLogForwardHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peers/{parent_name}/binds"] = bind.NewCreateBindPeer(o.context, o.BindCreateBindPeerHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/caches"] = cache.NewCreateCache(o.context, o.CacheCreateCacheHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/service_discovery/consul"] = service_discovery.NewCreateConsul(o.context, o.ServiceDiscoveryCreateConsulHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/crt_loads"] = crt_load.NewCreateCrtLoad(o.context, o.CrtLoadCreateCrtLoadHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/crt_stores"] = crt_store.NewCreateCrtStore(o.context, o.CrtStoreCreateCrtStoreHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/captures/{index}"] = declare_capture.NewCreateDeclareCapture(o.context, o.DeclareCaptureCreateDeclareCaptureHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults"] = defaults.NewCreateDefaultsSection(o.context, o.DefaultsCreateDefaultsSectionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds"] = dgram_bind.NewCreateDgramBind(o.context, o.DgramBindCreateDgramBindHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/fcgi_apps"] = fcgi_app.NewCreateFCGIApp(o.context, o.FCGIAppCreateFCGIAppHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/filters/{index}"] = filter.NewCreateFilterBackend(o.context, o.FilterCreateFilterBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/filters/{index}"] = filter.NewCreateFilterFrontend(o.context, o.FilterCreateFilterFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends"] = frontend.NewCreateFrontend(o.context, o.FrontendCreateFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/groups"] = group.NewCreateGroup(o.context, o.GroupCreateGroupHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewCreateHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleCreateHTTPAfterResponseRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewCreateHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleCreateHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/http_checks/{index}"] = http_check.NewCreateHTTPCheckBackend(o.context, o.HTTPCheckCreateHTTPCheckBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks/{index}"] = http_check.NewCreateHTTPCheckDefaults(o.context, o.HTTPCheckCreateHTTPCheckDefaultsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewCreateHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleCreateHTTPErrorRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewCreateHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleCreateHTTPErrorRuleDefaultsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewCreateHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleCreateHTTPErrorRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/http_errors_sections"] = http_errors.NewCreateHTTPErrorsSection(o.context, o.HTTPErrorsCreateHTTPErrorsSectionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewCreateHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleCreateHTTPRequestRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewCreateHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleCreateHTTPRequestRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewCreateHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleCreateHTTPResponseRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewCreateHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleCreateHTTPResponseRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/log_forwards"] = log_forward.NewCreateLogForward(o.context, o.LogForwardCreateLogForwardHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/log_profiles"] = log_profile.NewCreateLogProfile(o.context, o.LogProfileCreateLogProfileHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/log_targets/{index}"] = log_target.NewCreateLogTargetBackend(o.context, o.LogTargetCreateLogTargetBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets/{index}"] = log_target.NewCreateLogTargetDefaults(o.context, o.LogTargetCreateLogTargetDefaultsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets/{index}"] = log_target.NewCreateLogTargetFrontend(o.context, o.LogTargetCreateLogTargetFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/global/log_targets/{index}"] = log_target.NewCreateLogTargetGlobal(o.context, o.LogTargetCreateLogTargetGlobalHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets/{index}"] = log_target.NewCreateLogTargetLogForward(o.context, o.LogTargetCreateLogTargetLogForwardHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peers/{parent_name}/log_targets/{index}"] = log_target.NewCreateLogTargetPeer(o.context, o.LogTargetCreateLogTargetPeerHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/mailer_entries"] = mailer_entry.NewCreateMailerEntry(o.context, o.MailerEntryCreateMailerEntryHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/mailers_section"] = mailers.NewCreateMailersSection(o.context, o.MailersCreateMailersSectionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/nameservers"] = nameserver.NewCreateNameserver(o.context, o.NameserverCreateNameserverHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peer_section"] = peer.NewCreatePeer(o.context, o.PeerCreatePeerHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peer_entries"] = peer_entry.NewCreatePeerEntry(o.context, o.PeerEntryCreatePeerEntryHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/programs"] = process_manager.NewCreateProgram(o.context, o.ProcessManagerCreateProgramHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewCreateQUICInitialRuleDefaults(o.context, o.QUICInitialRuleCreateQUICInitialRuleDefaultsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewCreateQUICInitialRuleFrontend(o.context, o.QUICInitialRuleCreateQUICInitialRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/resolvers"] = resolver.NewCreateResolver(o.context, o.ResolverCreateResolverHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/rings"] = ring.NewCreateRing(o.context, o.RingCreateRingHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/servers"] = serverops.NewCreateServerBackend(o.context, o.ServerCreateServerBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peers/{parent_name}/servers"] = serverops.NewCreateServerPeer(o.context, o.ServerCreateServerPeerHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/rings/{parent_name}/servers"] = serverops.NewCreateServerRing(o.context, o.ServerCreateServerRingHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules/{index}"] = server_switching_rule.NewCreateServerSwitchingRule(o.context, o.ServerSwitchingRuleCreateServerSwitchingRuleHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/server_templates"] = server_template.NewCreateServerTemplate(o.context, o.ServerTemplateCreateServerTemplateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/sites"] = sites.NewCreateSite(o.context, o.SitesCreateSiteHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files"] = spoe.NewCreateSpoe(o.context, o.SpoeCreateSpoeHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents"] = spoe.NewCreateSpoeAgent(o.context, o.SpoeCreateSpoeAgentHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups"] = spoe.NewCreateSpoeGroup(o.context, o.SpoeCreateSpoeGroupHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages"] = spoe.NewCreateSpoeMessage(o.context, o.SpoeCreateSpoeMessageHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes"] = spoe.NewCreateSpoeScope(o.context, o.SpoeCreateSpoeScopeHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules/{index}"] = stick_rule.NewCreateStickRule(o.context, o.StickRuleCreateStickRuleHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/storage/general"] = storage.NewCreateStorageGeneralFile(o.context, o.StorageCreateStorageGeneralFileHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/storage/maps"] = storage.NewCreateStorageMapFile(o.context, o.StorageCreateStorageMapFileHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/storage/ssl_certificates"] = storage.NewCreateStorageSSLCertificate(o.context, o.StorageCreateStorageSSLCertificateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index}"] = tcp_check.NewCreateTCPCheckBackend(o.context, o.TCPCheckCreateTCPCheckBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks/{index}"] = tcp_check.NewCreateTCPCheckDefaults(o.context, o.TCPCheckCreateTCPCheckDefaultsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewCreateTCPRequestRuleBackend(o.context, o.TCPRequestRuleCreateTCPRequestRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewCreateTCPRequestRuleFrontend(o.context, o.TCPRequestRuleCreateTCPRequestRuleFrontendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules/{index}"] = tcp_response_rule.NewCreateTCPResponseRuleBackend(o.context, o.TCPResponseRuleCreateTCPResponseRuleBackendHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/peers/{parent_name}/tables"] = table.NewCreateTable(o.context, o.TableCreateTableHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/traces/entries"] = traces.NewCreateTraceEntry(o.context, o.TracesCreateTraceEntryHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/traces"] = traces.NewCreateTraces(o.context, o.TracesCreateTracesHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/users"] = user.NewCreateUser(o.context, o.UserCreateUserHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/userlists"] = userlist.NewCreateUserlist(o.context, o.UserlistCreateUserlistHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/service_discovery/aws/{id}"] = service_discovery.NewDeleteAWSRegion(o.context, o.ServiceDiscoveryDeleteAWSRegionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/acls/{index}"] = acl.NewDeleteACLBackend(o.context, o.ACLDeleteACLBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls/{index}"] = acl.NewDeleteACLFCGIApp(o.context, o.ACLDeleteACLFCGIAppHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/acls/{index}"] = acl.NewDeleteACLFrontend(o.context, o.ACLDeleteACLFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{name}"] = backend.NewDeleteBackend(o.context, o.BackendDeleteBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules/{index}"] = backend_switching_rule.NewDeleteBackendSwitchingRule(o.context, o.BackendSwitchingRuleDeleteBackendSwitchingRuleHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/binds/{name}"] = bind.NewDeleteBindFrontend(o.context, o.BindDeleteBindFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/log_forwards/{parent_name}/binds/{name}"] = bind.NewDeleteBindLogForward(o.context, o.BindDeleteBindLogForwardHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peers/{parent_name}/binds/{name}"] = bind.NewDeleteBindPeer(o.context, o.BindDeleteBindPeerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/caches/{name}"] = cache.NewDeleteCache(o.context, o.CacheDeleteCacheHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/cluster"] = cluster.NewDeleteCluster(o.context, o.ClusterDeleteClusterHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/service_discovery/consul/{id}"] = service_discovery.NewDeleteConsul(o.context, o.ServiceDiscoveryDeleteConsulHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/crt_loads/{certificate}"] = crt_load.NewDeleteCrtLoad(o.context, o.CrtLoadDeleteCrtLoadHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/crt_stores/{name}"] = crt_store.NewDeleteCrtStore(o.context, o.CrtStoreDeleteCrtStoreHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/captures/{index}"] = declare_capture.NewDeleteDeclareCapture(o.context, o.DeclareCaptureDeleteDeclareCaptureHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{name}"] = defaults.NewDeleteDefaultsSection(o.context, o.DefaultsDeleteDefaultsSectionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds/{name}"] = dgram_bind.NewDeleteDgramBind(o.context, o.DgramBindDeleteDgramBindHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/fcgi_apps/{name}"] = fcgi_app.NewDeleteFCGIApp(o.context, o.FCGIAppDeleteFCGIAppHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/filters/{index}"] = filter.NewDeleteFilterBackend(o.context, o.FilterDeleteFilterBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/filters/{index}"] = filter.NewDeleteFilterFrontend(o.context, o.FilterDeleteFilterFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{name}"] = frontend.NewDeleteFrontend(o.context, o.FrontendDeleteFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/groups/{name}"] = group.NewDeleteGroup(o.context, o.GroupDeleteGroupHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewDeleteHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewDeleteHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleDeleteHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/http_checks/{index}"] = http_check.NewDeleteHTTPCheckBackend(o.context, o.HTTPCheckDeleteHTTPCheckBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks/{index}"] = http_check.NewDeleteHTTPCheckDefaults(o.context, o.HTTPCheckDeleteHTTPCheckDefaultsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewDeleteHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleDeleteHTTPErrorRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewDeleteHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleDeleteHTTPErrorRuleDefaultsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewDeleteHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleDeleteHTTPErrorRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/http_errors_sections/{name}"] = http_errors.NewDeleteHTTPErrorsSection(o.context, o.HTTPErrorsDeleteHTTPErrorsSectionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewDeleteHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleDeleteHTTPRequestRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewDeleteHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleDeleteHTTPRequestRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewDeleteHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleDeleteHTTPResponseRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewDeleteHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleDeleteHTTPResponseRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/log_forwards/{name}"] = log_forward.NewDeleteLogForward(o.context, o.LogForwardDeleteLogForwardHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/log_profiles/{name}"] = log_profile.NewDeleteLogProfile(o.context, o.LogProfileDeleteLogProfileHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/log_targets/{index}"] = log_target.NewDeleteLogTargetBackend(o.context, o.LogTargetDeleteLogTargetBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets/{index}"] = log_target.NewDeleteLogTargetDefaults(o.context, o.LogTargetDeleteLogTargetDefaultsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets/{index}"] = log_target.NewDeleteLogTargetFrontend(o.context, o.LogTargetDeleteLogTargetFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/global/log_targets/{index}"] = log_target.NewDeleteLogTargetGlobal(o.context, o.LogTargetDeleteLogTargetGlobalHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets/{index}"] = log_target.NewDeleteLogTargetLogForward(o.context, o.LogTargetDeleteLogTargetLogForwardHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peers/{parent_name}/log_targets/{index}"] = log_target.NewDeleteLogTargetPeer(o.context, o.LogTargetDeleteLogTargetPeerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/mailer_entries/{name}"] = mailer_entry.NewDeleteMailerEntry(o.context, o.MailerEntryDeleteMailerEntryHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/mailers_section/{name}"] = mailers.NewDeleteMailersSection(o.context, o.MailersDeleteMailersSectionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/nameservers/{name}"] = nameserver.NewDeleteNameserver(o.context, o.NameserverDeleteNameserverHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peer_section/{name}"] = peer.NewDeletePeer(o.context, o.PeerDeletePeerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peer_entries/{name}"] = peer_entry.NewDeletePeerEntry(o.context, o.PeerEntryDeletePeerEntryHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/programs/{name}"] = process_manager.NewDeleteProgram(o.context, o.ProcessManagerDeleteProgramHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewDeleteQUICInitialRuleDefaults(o.context, o.QUICInitialRuleDeleteQUICInitialRuleDefaultsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewDeleteQUICInitialRuleFrontend(o.context, o.QUICInitialRuleDeleteQUICInitialRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/resolvers/{name}"] = resolver.NewDeleteResolver(o.context, o.ResolverDeleteResolverHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/rings/{name}"] = ring.NewDeleteRing(o.context, o.RingDeleteRingHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/runtime/maps/{parent_name}/entries/{id}"] = maps.NewDeleteRuntimeMapEntry(o.context, o.MapsDeleteRuntimeMapEntryHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/runtime/backends/{parent_name}/servers/{name}"] = serverops.NewDeleteRuntimeServer(o.context, o.ServerDeleteRuntimeServerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/servers/{name}"] = serverops.NewDeleteServerBackend(o.context, o.ServerDeleteServerBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peers/{parent_name}/servers/{name}"] = serverops.NewDeleteServerPeer(o.context, o.ServerDeleteServerPeerHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/rings/{parent_name}/servers/{name}"] = serverops.NewDeleteServerRing(o.context, o.ServerDeleteServerRingHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules/{index}"] = server_switching_rule.NewDeleteServerSwitchingRule(o.context, o.ServerSwitchingRuleDeleteServerSwitchingRuleHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/server_templates/{prefix}"] = server_template.NewDeleteServerTemplate(o.context, o.ServerTemplateDeleteServerTemplateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/sites/{name}"] = sites.NewDeleteSite(o.context, o.SitesDeleteSiteHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents/{name}"] = spoe.NewDeleteSpoeAgent(o.context, o.SpoeDeleteSpoeAgentHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{name}"] = spoe.NewDeleteSpoeFile(o.context, o.SpoeDeleteSpoeFileHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups/{name}"] = spoe.NewDeleteSpoeGroup(o.context, o.SpoeDeleteSpoeGroupHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages/{name}"] = spoe.NewDeleteSpoeMessage(o.context, o.SpoeDeleteSpoeMessageHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{name}"] = spoe.NewDeleteSpoeScope(o.context, o.SpoeDeleteSpoeScopeHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/spoe/spoe_files/{parent_name}/transactions/{id}"] = spoe_transactions.NewDeleteSpoeTransaction(o.context, o.SpoeTransactionsDeleteSpoeTransactionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules/{index}"] = stick_rule.NewDeleteStickRule(o.context, o.StickRuleDeleteStickRuleHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/storage/general/{name}"] = storage.NewDeleteStorageGeneralFile(o.context, o.StorageDeleteStorageGeneralFileHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/storage/maps/{name}"] = storage.NewDeleteStorageMap(o.context, o.StorageDeleteStorageMapHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/storage/ssl_certificates/{name}"] = storage.NewDeleteStorageSSLCertificate(o.context, o.StorageDeleteStorageSSLCertificateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index}"] = tcp_check.NewDeleteTCPCheckBackend(o.context, o.TCPCheckDeleteTCPCheckBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks/{index}"] = tcp_check.NewDeleteTCPCheckDefaults(o.context, o.TCPCheckDeleteTCPCheckDefaultsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewDeleteTCPRequestRuleBackend(o.context, o.TCPRequestRuleDeleteTCPRequestRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewDeleteTCPRequestRuleFrontend(o.context, o.TCPRequestRuleDeleteTCPRequestRuleFrontendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules/{index}"] = tcp_response_rule.NewDeleteTCPResponseRuleBackend(o.context, o.TCPResponseRuleDeleteTCPResponseRuleBackendHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/peers/{parent_name}/tables/{name}"] = table.NewDeleteTable(o.context, o.TableDeleteTableHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/traces/entries"] = traces.NewDeleteTraceEntry(o.context, o.TracesDeleteTraceEntryHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/traces"] = traces.NewDeleteTraces(o.context, o.TracesDeleteTracesHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/transactions/{id}"] = transactions.NewDeleteTransaction(o.context, o.TransactionsDeleteTransactionHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/users/{username}"] = user.NewDeleteUser(o.context, o.UserDeleteUserHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/services/haproxy/configuration/userlists/{name}"] = userlist.NewDeleteUserlist(o.context, o.UserlistDeleteUserlistHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/cluster"] = cluster.NewEditCluster(o.context, o.ClusterEditClusterHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/crt_stores/{name}"] = crt_store.NewEditCrtStore(o.context, o.CrtStoreEditCrtStoreHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_profiles/{name}"] = log_profile.NewEditLogProfile(o.context, o.LogProfileEditLogProfileHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/mailers_section/{name}"] = mailers.NewEditMailersSection(o.context, o.MailersEditMailersSectionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"][""] = discovery.NewGetAPIEndpoints(o.context, o.DiscoveryGetAPIEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/service_discovery/aws/{id}"] = service_discovery.NewGetAWSRegion(o.context, o.ServiceDiscoveryGetAWSRegionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/service_discovery/aws"] = service_discovery.NewGetAWSRegions(o.context, o.ServiceDiscoveryGetAWSRegionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/acls/{index}"] = acl.NewGetACLBackend(o.context, o.ACLGetACLBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls/{index}"] = acl.NewGetACLFCGIApp(o.context, o.ACLGetACLFCGIAppHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/acls/{index}"] = acl.NewGetACLFrontend(o.context, o.ACLGetACLFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/acls"] = acl.NewGetAllACLBackend(o.context, o.ACLGetAllACLBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls"] = acl.NewGetAllACLFCGIApp(o.context, o.ACLGetAllACLFCGIAppHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/acls"] = acl.NewGetAllACLFrontend(o.context, o.ACLGetAllACLFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/binds"] = bind.NewGetAllBindFrontend(o.context, o.BindGetAllBindFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/binds"] = bind.NewGetAllBindLogForward(o.context, o.BindGetAllBindLogForwardHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/binds"] = bind.NewGetAllBindPeer(o.context, o.BindGetAllBindPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/filters"] = filter.NewGetAllFilterBackend(o.context, o.FilterGetAllFilterBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/filters"] = filter.NewGetAllFilterFrontend(o.context, o.FilterGetAllFilterFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules"] = http_after_response_rule.NewGetAllHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules"] = http_after_response_rule.NewGetAllHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleGetAllHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_checks"] = http_check.NewGetAllHTTPCheckBackend(o.context, o.HTTPCheckGetAllHTTPCheckBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks"] = http_check.NewGetAllHTTPCheckDefaults(o.context, o.HTTPCheckGetAllHTTPCheckDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules"] = http_error_rule.NewGetAllHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleGetAllHTTPErrorRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules"] = http_error_rule.NewGetAllHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleGetAllHTTPErrorRuleDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules"] = http_error_rule.NewGetAllHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleGetAllHTTPErrorRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules"] = http_request_rule.NewGetAllHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleGetAllHTTPRequestRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules"] = http_request_rule.NewGetAllHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleGetAllHTTPRequestRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules"] = http_response_rule.NewGetAllHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleGetAllHTTPResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules"] = http_response_rule.NewGetAllHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleGetAllHTTPResponseRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/log_targets"] = log_target.NewGetAllLogTargetBackend(o.context, o.LogTargetGetAllLogTargetBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets"] = log_target.NewGetAllLogTargetDefaults(o.context, o.LogTargetGetAllLogTargetDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets"] = log_target.NewGetAllLogTargetFrontend(o.context, o.LogTargetGetAllLogTargetFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/global/log_targets"] = log_target.NewGetAllLogTargetGlobal(o.context, o.LogTargetGetAllLogTargetGlobalHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets"] = log_target.NewGetAllLogTargetLogForward(o.context, o.LogTargetGetAllLogTargetLogForwardHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/log_targets"] = log_target.NewGetAllLogTargetPeer(o.context, o.LogTargetGetAllLogTargetPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules"] = quic_initial_rule.NewGetAllQUICInitialRuleDefaults(o.context, o.QUICInitialRuleGetAllQUICInitialRuleDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules"] = quic_initial_rule.NewGetAllQUICInitialRuleFrontend(o.context, o.QUICInitialRuleGetAllQUICInitialRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/maps"] = maps.NewGetAllRuntimeMapFiles(o.context, o.MapsGetAllRuntimeMapFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/backends/{parent_name}/servers"] = serverops.NewGetAllRuntimeServer(o.context, o.ServerGetAllRuntimeServerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/servers"] = serverops.NewGetAllServerBackend(o.context, o.ServerGetAllServerBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/servers"] = serverops.NewGetAllServerPeer(o.context, o.ServerGetAllServerPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/rings/{parent_name}/servers"] = serverops.NewGetAllServerRing(o.context, o.ServerGetAllServerRingHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents"] = spoe.NewGetAllSpoeAgent(o.context, o.SpoeGetAllSpoeAgentHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files"] = spoe.NewGetAllSpoeFiles(o.context, o.SpoeGetAllSpoeFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups"] = spoe.NewGetAllSpoeGroup(o.context, o.SpoeGetAllSpoeGroupHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages"] = spoe.NewGetAllSpoeMessage(o.context, o.SpoeGetAllSpoeMessageHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes"] = spoe.NewGetAllSpoeScope(o.context, o.SpoeGetAllSpoeScopeHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/transactions"] = spoe_transactions.NewGetAllSpoeTransaction(o.context, o.SpoeTransactionsGetAllSpoeTransactionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/general"] = storage.NewGetAllStorageGeneralFiles(o.context, o.StorageGetAllStorageGeneralFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/maps"] = storage.NewGetAllStorageMapFiles(o.context, o.StorageGetAllStorageMapFilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/ssl_certificates"] = storage.NewGetAllStorageSSLCertificates(o.context, o.StorageGetAllStorageSSLCertificatesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks"] = tcp_check.NewGetAllTCPCheckBackend(o.context, o.TCPCheckGetAllTCPCheckBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks"] = tcp_check.NewGetAllTCPCheckDefaults(o.context, o.TCPCheckGetAllTCPCheckDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules"] = tcp_request_rule.NewGetAllTCPRequestRuleBackend(o.context, o.TCPRequestRuleGetAllTCPRequestRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules"] = tcp_request_rule.NewGetAllTCPRequestRuleFrontend(o.context, o.TCPRequestRuleGetAllTCPRequestRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules"] = tcp_response_rule.NewGetAllTCPResponseRuleBackend(o.context, o.TCPResponseRuleGetAllTCPResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{name}"] = backend.NewGetBackend(o.context, o.BackendGetBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules/{index}"] = backend_switching_rule.NewGetBackendSwitchingRule(o.context, o.BackendSwitchingRuleGetBackendSwitchingRuleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules"] = backend_switching_rule.NewGetBackendSwitchingRules(o.context, o.BackendSwitchingRuleGetBackendSwitchingRulesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends"] = backend.NewGetBackends(o.context, o.BackendGetBackendsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/binds/{name}"] = bind.NewGetBindFrontend(o.context, o.BindGetBindFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/binds/{name}"] = bind.NewGetBindLogForward(o.context, o.BindGetBindLogForwardHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/binds/{name}"] = bind.NewGetBindPeer(o.context, o.BindGetBindPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/caches/{name}"] = cache.NewGetCache(o.context, o.CacheGetCacheHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/caches"] = cache.NewGetCaches(o.context, o.CacheGetCachesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/cluster"] = cluster.NewGetCluster(o.context, o.ClusterGetClusterHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration"] = discovery.NewGetConfigurationEndpoints(o.context, o.DiscoveryGetConfigurationEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/version"] = configuration.NewGetConfigurationVersion(o.context, o.ConfigurationGetConfigurationVersionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/service_discovery/consul/{id}"] = service_discovery.NewGetConsul(o.context, o.ServiceDiscoveryGetConsulHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/service_discovery/consul"] = service_discovery.NewGetConsuls(o.context, o.ServiceDiscoveryGetConsulsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/crt_loads/{certificate}"] = crt_load.NewGetCrtLoad(o.context, o.CrtLoadGetCrtLoadHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/crt_loads"] = crt_load.NewGetCrtLoads(o.context, o.CrtLoadGetCrtLoadsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/crt_stores/{name}"] = crt_store.NewGetCrtStore(o.context, o.CrtStoreGetCrtStoreHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/crt_stores"] = crt_store.NewGetCrtStores(o.context, o.CrtStoreGetCrtStoresHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/captures/{index}"] = declare_capture.NewGetDeclareCapture(o.context, o.DeclareCaptureGetDeclareCaptureHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/captures"] = declare_capture.NewGetDeclareCaptures(o.context, o.DeclareCaptureGetDeclareCapturesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{name}"] = defaults.NewGetDefaultsSection(o.context, o.DefaultsGetDefaultsSectionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults"] = defaults.NewGetDefaultsSections(o.context, o.DefaultsGetDefaultsSectionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds/{name}"] = dgram_bind.NewGetDgramBind(o.context, o.DgramBindGetDgramBindHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds"] = dgram_bind.NewGetDgramBinds(o.context, o.DgramBindGetDgramBindsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/fcgi_apps/{name}"] = fcgi_app.NewGetFCGIApp(o.context, o.FCGIAppGetFCGIAppHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/fcgi_apps"] = fcgi_app.NewGetFCGIApps(o.context, o.FCGIAppGetFCGIAppsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/filters/{index}"] = filter.NewGetFilterBackend(o.context, o.FilterGetFilterBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/filters/{index}"] = filter.NewGetFilterFrontend(o.context, o.FilterGetFilterFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{name}"] = frontend.NewGetFrontend(o.context, o.FrontendGetFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends"] = frontend.NewGetFrontends(o.context, o.FrontendGetFrontendsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/global"] = global.NewGetGlobal(o.context, o.GlobalGetGlobalHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/groups/{name}"] = group.NewGetGroup(o.context, o.GroupGetGroupHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/groups"] = group.NewGetGroups(o.context, o.GroupGetGroupsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/raw"] = configuration.NewGetHAProxyConfiguration(o.context, o.ConfigurationGetHAProxyConfigurationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewGetHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleGetHTTPAfterResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewGetHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleGetHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_checks/{index}"] = http_check.NewGetHTTPCheckBackend(o.context, o.HTTPCheckGetHTTPCheckBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks/{index}"] = http_check.NewGetHTTPCheckDefaults(o.context, o.HTTPCheckGetHTTPCheckDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewGetHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleGetHTTPErrorRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewGetHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleGetHTTPErrorRuleDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewGetHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleGetHTTPErrorRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/http_errors_sections/{name}"] = http_errors.NewGetHTTPErrorsSection(o.context, o.HTTPErrorsGetHTTPErrorsSectionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/http_errors_sections"] = http_errors.NewGetHTTPErrorsSections(o.context, o.HTTPErrorsGetHTTPErrorsSectionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewGetHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleGetHTTPRequestRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewGetHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleGetHTTPRequestRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewGetHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleGetHTTPResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewGetHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleGetHTTPResponseRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy"] = discovery.NewGetHaproxyEndpoints(o.context, o.DiscoveryGetHaproxyEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/info"] = information.NewGetHaproxyProcessInfo(o.context, o.InformationGetHaproxyProcessInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/health"] = health.NewGetHealth(o.context, o.HealthGetHealthHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/info"] = information.NewGetInfo(o.context, o.InformationGetInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{name}"] = log_forward.NewGetLogForward(o.context, o.LogForwardGetLogForwardHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards"] = log_forward.NewGetLogForwards(o.context, o.LogForwardGetLogForwardsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_profiles/{name}"] = log_profile.NewGetLogProfile(o.context, o.LogProfileGetLogProfileHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_profiles"] = log_profile.NewGetLogProfiles(o.context, o.LogProfileGetLogProfilesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/log_targets/{index}"] = log_target.NewGetLogTargetBackend(o.context, o.LogTargetGetLogTargetBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets/{index}"] = log_target.NewGetLogTargetDefaults(o.context, o.LogTargetGetLogTargetDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets/{index}"] = log_target.NewGetLogTargetFrontend(o.context, o.LogTargetGetLogTargetFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/global/log_targets/{index}"] = log_target.NewGetLogTargetGlobal(o.context, o.LogTargetGetLogTargetGlobalHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets/{index}"] = log_target.NewGetLogTargetLogForward(o.context, o.LogTargetGetLogTargetLogForwardHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/log_targets/{index}"] = log_target.NewGetLogTargetPeer(o.context, o.LogTargetGetLogTargetPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/mailer_entries"] = mailer_entry.NewGetMailerEntries(o.context, o.MailerEntryGetMailerEntriesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/mailer_entries/{name}"] = mailer_entry.NewGetMailerEntry(o.context, o.MailerEntryGetMailerEntryHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/mailers_section/{name}"] = mailers.NewGetMailersSection(o.context, o.MailersGetMailersSectionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/mailers_section"] = mailers.NewGetMailersSections(o.context, o.MailersGetMailersSectionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/nameservers/{name}"] = nameserver.NewGetNameserver(o.context, o.NameserverGetNameserverHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/nameservers"] = nameserver.NewGetNameservers(o.context, o.NameserverGetNameserversHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/maps/{name}"] = maps.NewGetOneRuntimeMap(o.context, o.MapsGetOneRuntimeMapHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{name}"] = spoe.NewGetOneSpoeFile(o.context, o.SpoeGetOneSpoeFileHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/general/{name}"] = storage.NewGetOneStorageGeneralFile(o.context, o.StorageGetOneStorageGeneralFileHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/maps/{name}"] = storage.NewGetOneStorageMap(o.context, o.StorageGetOneStorageMapHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage/ssl_certificates/{name}"] = storage.NewGetOneStorageSSLCertificate(o.context, o.StorageGetOneStorageSSLCertificateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/specification_openapiv3"] = version3.NewGetOpenapiv3Specification(o.context, o.Version3GetOpenapiv3SpecificationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peer_entries"] = peer_entry.NewGetPeerEntries(o.context, o.PeerEntryGetPeerEntriesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peer_entries/{name}"] = peer_entry.NewGetPeerEntry(o.context, o.PeerEntryGetPeerEntryHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peer_section/{name}"] = peer.NewGetPeerSection(o.context, o.PeerGetPeerSectionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peer_section"] = peer.NewGetPeerSections(o.context, o.PeerGetPeerSectionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/programs/{name}"] = process_manager.NewGetProgram(o.context, o.ProcessManagerGetProgramHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/programs"] = process_manager.NewGetPrograms(o.context, o.ProcessManagerGetProgramsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewGetQUICInitialRuleDefaults(o.context, o.QUICInitialRuleGetQUICInitialRuleDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewGetQUICInitialRuleFrontend(o.context, o.QUICInitialRuleGetQUICInitialRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/reloads/{id}"] = reloads.NewGetReload(o.context, o.ReloadsGetReloadHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/reloads"] = reloads.NewGetReloads(o.context, o.ReloadsGetReloadsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/resolvers/{name}"] = resolver.NewGetResolver(o.context, o.ResolverGetResolverHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/resolvers"] = resolver.NewGetResolvers(o.context, o.ResolverGetResolversHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/rings/{name}"] = ring.NewGetRing(o.context, o.RingGetRingHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/rings"] = ring.NewGetRings(o.context, o.RingGetRingsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime"] = discovery.NewGetRuntimeEndpoints(o.context, o.DiscoveryGetRuntimeEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/maps/{parent_name}/entries/{id}"] = maps.NewGetRuntimeMapEntry(o.context, o.MapsGetRuntimeMapEntryHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/backends/{parent_name}/servers/{name}"] = serverops.NewGetRuntimeServer(o.context, o.ServerGetRuntimeServerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/servers/{name}"] = serverops.NewGetServerBackend(o.context, o.ServerGetServerBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/servers/{name}"] = serverops.NewGetServerPeer(o.context, o.ServerGetServerPeerHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/rings/{parent_name}/servers/{name}"] = serverops.NewGetServerRing(o.context, o.ServerGetServerRingHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules/{index}"] = server_switching_rule.NewGetServerSwitchingRule(o.context, o.ServerSwitchingRuleGetServerSwitchingRuleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules"] = server_switching_rule.NewGetServerSwitchingRules(o.context, o.ServerSwitchingRuleGetServerSwitchingRulesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/server_templates/{prefix}"] = server_template.NewGetServerTemplate(o.context, o.ServerTemplateGetServerTemplateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/server_templates"] = server_template.NewGetServerTemplates(o.context, o.ServerTemplateGetServerTemplatesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services"] = discovery.NewGetServicesEndpoints(o.context, o.DiscoveryGetServicesEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/sites/{name}"] = sites.NewGetSite(o.context, o.SitesGetSiteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/sites"] = sites.NewGetSites(o.context, o.SitesGetSitesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/specification"] = specification.NewGetSpecification(o.context, o.SpecificationGetSpecificationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents/{name}"] = spoe.NewGetSpoeAgent(o.context, o.SpoeGetSpoeAgentHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/{parent_name}/version"] = spoe.NewGetSpoeConfigurationVersion(o.context, o.SpoeGetSpoeConfigurationVersionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe"] = discovery.NewGetSpoeEndpoints(o.context, o.DiscoveryGetSpoeEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups/{name}"] = spoe.NewGetSpoeGroup(o.context, o.SpoeGetSpoeGroupHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages/{name}"] = spoe.NewGetSpoeMessage(o.context, o.SpoeGetSpoeMessageHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{name}"] = spoe.NewGetSpoeScope(o.context, o.SpoeGetSpoeScopeHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/spoe/spoe_files/{parent_name}/transactions/{id}"] = spoe_transactions.NewGetSpoeTransaction(o.context, o.SpoeTransactionsGetSpoeTransactionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/stats/native"] = stats.NewGetStats(o.context, o.StatsGetStatsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/stats"] = discovery.NewGetStatsEndpoints(o.context, o.DiscoveryGetStatsEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules/{index}"] = stick_rule.NewGetStickRule(o.context, o.StickRuleGetStickRuleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules"] = stick_rule.NewGetStickRules(o.context, o.StickRuleGetStickRulesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/stick_tables/{name}"] = stick_table.NewGetStickTable(o.context, o.StickTableGetStickTableHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/stick_tables/{parent_name}/entries"] = stick_table.NewGetStickTableEntries(o.context, o.StickTableGetStickTableEntriesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/stick_tables"] = stick_table.NewGetStickTables(o.context, o.StickTableGetStickTablesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/storage"] = discovery.NewGetStorageEndpoints(o.context, o.DiscoveryGetStorageEndpointsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index}"] = tcp_check.NewGetTCPCheckBackend(o.context, o.TCPCheckGetTCPCheckBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks/{index}"] = tcp_check.NewGetTCPCheckDefaults(o.context, o.TCPCheckGetTCPCheckDefaultsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewGetTCPRequestRuleBackend(o.context, o.TCPRequestRuleGetTCPRequestRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewGetTCPRequestRuleFrontend(o.context, o.TCPRequestRuleGetTCPRequestRuleFrontendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules/{index}"] = tcp_response_rule.NewGetTCPResponseRuleBackend(o.context, o.TCPResponseRuleGetTCPResponseRuleBackendHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/tables/{name}"] = table.NewGetTable(o.context, o.TableGetTableHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/peers/{parent_name}/tables"] = table.NewGetTables(o.context, o.TableGetTablesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/traces"] = traces.NewGetTraces(o.context, o.TracesGetTracesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/transactions/{id}"] = transactions.NewGetTransaction(o.context, o.TransactionsGetTransactionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/transactions"] = transactions.NewGetTransactions(o.context, o.TransactionsGetTransactionsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/users/{username}"] = user.NewGetUser(o.context, o.UserGetUserHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/userlists/{name}"] = userlist.NewGetUserlist(o.context, o.UserlistGetUserlistHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/userlists"] = userlist.NewGetUserlists(o.context, o.UserlistGetUserlistsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/configuration/users"] = user.NewGetUsers(o.context, o.UserGetUsersHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/cluster/certificate"] = cluster.NewInitiateCertificateRefresh(o.context, o.ClusterInitiateCertificateRefreshHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/cluster"] = cluster.NewPostCluster(o.context, o.ClusterPostClusterHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/configuration/raw"] = configuration.NewPostHAProxyConfiguration(o.context, o.ConfigurationPostHAProxyConfigurationHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/service_discovery/aws/{id}"] = service_discovery.NewReplaceAWSRegion(o.context, o.ServiceDiscoveryReplaceAWSRegionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/acls/{index}"] = acl.NewReplaceACLBackend(o.context, o.ACLReplaceACLBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls/{index}"] = acl.NewReplaceACLFCGIApp(o.context, o.ACLReplaceACLFCGIAppHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/acls/{index}"] = acl.NewReplaceACLFrontend(o.context, o.ACLReplaceACLFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/acls"] = acl.NewReplaceAllACLBackend(o.context, o.ACLReplaceAllACLBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/fcgi_apps/{parent_name}/acls"] = acl.NewReplaceAllACLFCGIApp(o.context, o.ACLReplaceAllACLFCGIAppHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/acls"] = acl.NewReplaceAllACLFrontend(o.context, o.ACLReplaceAllACLFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/filters"] = filter.NewReplaceAllFilterBackend(o.context, o.FilterReplaceAllFilterBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/filters"] = filter.NewReplaceAllFilterFrontend(o.context, o.FilterReplaceAllFilterFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules"] = http_after_response_rule.NewReplaceAllHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules"] = http_after_response_rule.NewReplaceAllHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleReplaceAllHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_checks"] = http_check.NewReplaceAllHTTPCheckBackend(o.context, o.HTTPCheckReplaceAllHTTPCheckBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks"] = http_check.NewReplaceAllHTTPCheckDefaults(o.context, o.HTTPCheckReplaceAllHTTPCheckDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules"] = http_error_rule.NewReplaceAllHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleReplaceAllHTTPErrorRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules"] = http_error_rule.NewReplaceAllHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleReplaceAllHTTPErrorRuleDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules"] = http_error_rule.NewReplaceAllHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleReplaceAllHTTPErrorRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules"] = http_request_rule.NewReplaceAllHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleReplaceAllHTTPRequestRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules"] = http_request_rule.NewReplaceAllHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleReplaceAllHTTPRequestRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules"] = http_response_rule.NewReplaceAllHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleReplaceAllHTTPResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules"] = http_response_rule.NewReplaceAllHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleReplaceAllHTTPResponseRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/log_targets"] = log_target.NewReplaceAllLogTargetBackend(o.context, o.LogTargetReplaceAllLogTargetBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets"] = log_target.NewReplaceAllLogTargetDefaults(o.context, o.LogTargetReplaceAllLogTargetDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets"] = log_target.NewReplaceAllLogTargetFrontend(o.context, o.LogTargetReplaceAllLogTargetFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/global/log_targets"] = log_target.NewReplaceAllLogTargetGlobal(o.context, o.LogTargetReplaceAllLogTargetGlobalHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets"] = log_target.NewReplaceAllLogTargetLogForward(o.context, o.LogTargetReplaceAllLogTargetLogForwardHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peers/{parent_name}/log_targets"] = log_target.NewReplaceAllLogTargetPeer(o.context, o.LogTargetReplaceAllLogTargetPeerHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules"] = quic_initial_rule.NewReplaceAllQUICInitialRuleDefaults(o.context, o.QUICInitialRuleReplaceAllQUICInitialRuleDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules"] = quic_initial_rule.NewReplaceAllQUICInitialRuleFrontend(o.context, o.QUICInitialRuleReplaceAllQUICInitialRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks"] = tcp_check.NewReplaceAllTCPCheckBackend(o.context, o.TCPCheckReplaceAllTCPCheckBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks"] = tcp_check.NewReplaceAllTCPCheckDefaults(o.context, o.TCPCheckReplaceAllTCPCheckDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules"] = tcp_request_rule.NewReplaceAllTCPRequestRuleBackend(o.context, o.TCPRequestRuleReplaceAllTCPRequestRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules"] = tcp_request_rule.NewReplaceAllTCPRequestRuleFrontend(o.context, o.TCPRequestRuleReplaceAllTCPRequestRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules"] = tcp_response_rule.NewReplaceAllTCPResponseRuleBackend(o.context, o.TCPResponseRuleReplaceAllTCPResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{name}"] = backend.NewReplaceBackend(o.context, o.BackendReplaceBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules/{index}"] = backend_switching_rule.NewReplaceBackendSwitchingRule(o.context, o.BackendSwitchingRuleReplaceBackendSwitchingRuleHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/backend_switching_rules"] = backend_switching_rule.NewReplaceBackendSwitchingRules(o.context, o.BackendSwitchingRuleReplaceBackendSwitchingRulesHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/binds/{name}"] = bind.NewReplaceBindFrontend(o.context, o.BindReplaceBindFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_forwards/{parent_name}/binds/{name}"] = bind.NewReplaceBindLogForward(o.context, o.BindReplaceBindLogForwardHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peers/{parent_name}/binds/{name}"] = bind.NewReplaceBindPeer(o.context, o.BindReplaceBindPeerHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/caches/{name}"] = cache.NewReplaceCache(o.context, o.CacheReplaceCacheHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/service_discovery/consul/{id}"] = service_discovery.NewReplaceConsul(o.context, o.ServiceDiscoveryReplaceConsulHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/crt_loads/{certificate}"] = crt_load.NewReplaceCrtLoad(o.context, o.CrtLoadReplaceCrtLoadHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/captures/{index}"] = declare_capture.NewReplaceDeclareCapture(o.context, o.DeclareCaptureReplaceDeclareCaptureHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/captures"] = declare_capture.NewReplaceDeclareCaptures(o.context, o.DeclareCaptureReplaceDeclareCapturesHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{name}"] = defaults.NewReplaceDefaultsSection(o.context, o.DefaultsReplaceDefaultsSectionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_forwards/{parent_name}/dgram_binds/{name}"] = dgram_bind.NewReplaceDgramBind(o.context, o.DgramBindReplaceDgramBindHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/fcgi_apps/{name}"] = fcgi_app.NewReplaceFCGIApp(o.context, o.FCGIAppReplaceFCGIAppHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/filters/{index}"] = filter.NewReplaceFilterBackend(o.context, o.FilterReplaceFilterBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/filters/{index}"] = filter.NewReplaceFilterFrontend(o.context, o.FilterReplaceFilterFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{name}"] = frontend.NewReplaceFrontend(o.context, o.FrontendReplaceFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/global"] = global.NewReplaceGlobal(o.context, o.GlobalReplaceGlobalHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/groups/{name}"] = group.NewReplaceGroup(o.context, o.GroupReplaceGroupHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewReplaceHTTPAfterResponseRuleBackend(o.context, o.HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_after_response_rules/{index}"] = http_after_response_rule.NewReplaceHTTPAfterResponseRuleFrontend(o.context, o.HTTPAfterResponseRuleReplaceHTTPAfterResponseRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_checks/{index}"] = http_check.NewReplaceHTTPCheckBackend(o.context, o.HTTPCheckReplaceHTTPCheckBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/http_checks/{index}"] = http_check.NewReplaceHTTPCheckDefaults(o.context, o.HTTPCheckReplaceHTTPCheckDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewReplaceHTTPErrorRuleBackend(o.context, o.HTTPErrorRuleReplaceHTTPErrorRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewReplaceHTTPErrorRuleDefaults(o.context, o.HTTPErrorRuleReplaceHTTPErrorRuleDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_error_rules/{index}"] = http_error_rule.NewReplaceHTTPErrorRuleFrontend(o.context, o.HTTPErrorRuleReplaceHTTPErrorRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/http_errors_sections/{name}"] = http_errors.NewReplaceHTTPErrorsSection(o.context, o.HTTPErrorsReplaceHTTPErrorsSectionHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewReplaceHTTPRequestRuleBackend(o.context, o.HTTPRequestRuleReplaceHTTPRequestRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_request_rules/{index}"] = http_request_rule.NewReplaceHTTPRequestRuleFrontend(o.context, o.HTTPRequestRuleReplaceHTTPRequestRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewReplaceHTTPResponseRuleBackend(o.context, o.HTTPResponseRuleReplaceHTTPResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/http_response_rules/{index}"] = http_response_rule.NewReplaceHTTPResponseRuleFrontend(o.context, o.HTTPResponseRuleReplaceHTTPResponseRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_forwards/{name}"] = log_forward.NewReplaceLogForward(o.context, o.LogForwardReplaceLogForwardHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/log_targets/{index}"] = log_target.NewReplaceLogTargetBackend(o.context, o.LogTargetReplaceLogTargetBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/log_targets/{index}"] = log_target.NewReplaceLogTargetDefaults(o.context, o.LogTargetReplaceLogTargetDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/log_targets/{index}"] = log_target.NewReplaceLogTargetFrontend(o.context, o.LogTargetReplaceLogTargetFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/global/log_targets/{index}"] = log_target.NewReplaceLogTargetGlobal(o.context, o.LogTargetReplaceLogTargetGlobalHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/log_forwards/{parent_name}/log_targets/{index}"] = log_target.NewReplaceLogTargetLogForward(o.context, o.LogTargetReplaceLogTargetLogForwardHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peers/{parent_name}/log_targets/{index}"] = log_target.NewReplaceLogTargetPeer(o.context, o.LogTargetReplaceLogTargetPeerHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/mailer_entries/{name}"] = mailer_entry.NewReplaceMailerEntry(o.context, o.MailerEntryReplaceMailerEntryHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/nameservers/{name}"] = nameserver.NewReplaceNameserver(o.context, o.NameserverReplaceNameserverHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peer_entries/{name}"] = peer_entry.NewReplacePeerEntry(o.context, o.PeerEntryReplacePeerEntryHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/programs/{name}"] = process_manager.NewReplaceProgram(o.context, o.ProcessManagerReplaceProgramHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewReplaceQUICInitialRuleDefaults(o.context, o.QUICInitialRuleReplaceQUICInitialRuleDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/quic_initial_rules/{index}"] = quic_initial_rule.NewReplaceQUICInitialRuleFrontend(o.context, o.QUICInitialRuleReplaceQUICInitialRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/resolvers/{name}"] = resolver.NewReplaceResolver(o.context, o.ResolverReplaceResolverHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/rings/{name}"] = ring.NewReplaceRing(o.context, o.RingReplaceRingHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/runtime/maps/{parent_name}/entries/{id}"] = maps.NewReplaceRuntimeMapEntry(o.context, o.MapsReplaceRuntimeMapEntryHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/runtime/backends/{parent_name}/servers/{name}"] = serverops.NewReplaceRuntimeServer(o.context, o.ServerReplaceRuntimeServerHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/servers/{name}"] = serverops.NewReplaceServerBackend(o.context, o.ServerReplaceServerBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peers/{parent_name}/servers/{name}"] = serverops.NewReplaceServerPeer(o.context, o.ServerReplaceServerPeerHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/rings/{parent_name}/servers/{name}"] = serverops.NewReplaceServerRing(o.context, o.ServerReplaceServerRingHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules/{index}"] = server_switching_rule.NewReplaceServerSwitchingRule(o.context, o.ServerSwitchingRuleReplaceServerSwitchingRuleHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/server_switching_rules"] = server_switching_rule.NewReplaceServerSwitchingRules(o.context, o.ServerSwitchingRuleReplaceServerSwitchingRulesHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/server_templates/{prefix}"] = server_template.NewReplaceServerTemplate(o.context, o.ServerTemplateReplaceServerTemplateHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/sites/{name}"] = sites.NewReplaceSite(o.context, o.SitesReplaceSiteHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/agents/{name}"] = spoe.NewReplaceSpoeAgent(o.context, o.SpoeReplaceSpoeAgentHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/groups/{name}"] = spoe.NewReplaceSpoeGroup(o.context, o.SpoeReplaceSpoeGroupHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/spoe/spoe_files/{parent_name}/scopes/{scope_name}/messages/{name}"] = spoe.NewReplaceSpoeMessage(o.context, o.SpoeReplaceSpoeMessageHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules/{index}"] = stick_rule.NewReplaceStickRule(o.context, o.StickRuleReplaceStickRuleHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/stick_rules"] = stick_rule.NewReplaceStickRules(o.context, o.StickRuleReplaceStickRulesHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/storage/general/{name}"] = storage.NewReplaceStorageGeneralFile(o.context, o.StorageReplaceStorageGeneralFileHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/storage/maps/{name}"] = storage.NewReplaceStorageMapFile(o.context, o.StorageReplaceStorageMapFileHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/storage/ssl_certificates/{name}"] = storage.NewReplaceStorageSSLCertificate(o.context, o.StorageReplaceStorageSSLCertificateHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index}"] = tcp_check.NewReplaceTCPCheckBackend(o.context, o.TCPCheckReplaceTCPCheckBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/defaults/{parent_name}/tcp_checks/{index}"] = tcp_check.NewReplaceTCPCheckDefaults(o.context, o.TCPCheckReplaceTCPCheckDefaultsHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewReplaceTCPRequestRuleBackend(o.context, o.TCPRequestRuleReplaceTCPRequestRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/frontends/{parent_name}/tcp_request_rules/{index}"] = tcp_request_rule.NewReplaceTCPRequestRuleFrontend(o.context, o.TCPRequestRuleReplaceTCPRequestRuleFrontendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/backends/{parent_name}/tcp_response_rules/{index}"] = tcp_response_rule.NewReplaceTCPResponseRuleBackend(o.context, o.TCPResponseRuleReplaceTCPResponseRuleBackendHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/peers/{parent_name}/tables/{name}"] = table.NewReplaceTable(o.context, o.TableReplaceTableHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/traces"] = traces.NewReplaceTraces(o.context, o.TracesReplaceTracesHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/services/haproxy/configuration/users/{username}"] = user.NewReplaceUser(o.context, o.UserReplaceUserHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/runtime/stick_tables/{parent_name}/entries"] = stick_table.NewSetStickTableEntries(o.context, o.StickTableSetStickTableEntriesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/services/haproxy/runtime/maps/{parent_name}/entries"] = maps.NewShowRuntimeMap(o.context, o.MapsShowRuntimeMapHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/spoe/spoe_files/{parent_name}/transactions"] = spoe_transactions.NewStartSpoeTransaction(o.context, o.SpoeTransactionsStartSpoeTransactionHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/services/haproxy/transactions"] = transactions.NewStartTransaction(o.context, o.TransactionsStartTransactionHandler)
}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *DataPlaneAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	if o.useSwaggerUI {
		return o.context.APIHandlerSwaggerUI(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middleware as you see fit
func (o *DataPlaneAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}

// RegisterConsumer allows you to add (or override) a consumer for a media type.
func (o *DataPlaneAPI) RegisterConsumer(mediaType string, consumer runtime.Consumer) {
	o.customConsumers[mediaType] = consumer
}

// RegisterProducer allows you to add (or override) a producer for a media type.
func (o *DataPlaneAPI) RegisterProducer(mediaType string, producer runtime.Producer) {
	o.customProducers[mediaType] = producer
}

// AddMiddlewareFor adds a http middleware to existing handler
func (o *DataPlaneAPI) AddMiddlewareFor(method, path string, builder middleware.Builder) {
	um := strings.ToUpper(method)
	if path == "/" {
		path = ""
	}
	o.Init()
	if h, ok := o.handlers[um][path]; ok {
		o.handlers[um][path] = builder(h)
	}
}
