// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateStorageGeneralFileCreatedCode is the HTTP code returned for type CreateStorageGeneralFileCreated
const CreateStorageGeneralFileCreatedCode int = 201

/*
CreateStorageGeneralFileCreated General use file created with its contents

swagger:response createStorageGeneralFileCreated
*/
type CreateStorageGeneralFileCreated struct {

	/*
	  In: Body
	*/
	Payload *models.GeneralFile `json:"body,omitempty"`
}

// NewCreateStorageGeneralFileCreated creates CreateStorageGeneralFileCreated with default headers values
func NewCreateStorageGeneralFileCreated() *CreateStorageGeneralFileCreated {

	return &CreateStorageGeneralFileCreated{}
}

// WithPayload adds the payload to the create storage general file created response
func (o *CreateStorageGeneralFileCreated) WithPayload(payload *models.GeneralFile) *CreateStorageGeneralFileCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create storage general file created response
func (o *CreateStorageGeneralFileCreated) SetPayload(payload *models.GeneralFile) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateStorageGeneralFileCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateStorageGeneralFileBadRequestCode is the HTTP code returned for type CreateStorageGeneralFileBadRequest
const CreateStorageGeneralFileBadRequestCode int = 400

/*
CreateStorageGeneralFileBadRequest Bad request

swagger:response createStorageGeneralFileBadRequest
*/
type CreateStorageGeneralFileBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateStorageGeneralFileBadRequest creates CreateStorageGeneralFileBadRequest with default headers values
func NewCreateStorageGeneralFileBadRequest() *CreateStorageGeneralFileBadRequest {

	return &CreateStorageGeneralFileBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create storage general file bad request response
func (o *CreateStorageGeneralFileBadRequest) WithConfigurationVersion(configurationVersion string) *CreateStorageGeneralFileBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create storage general file bad request response
func (o *CreateStorageGeneralFileBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create storage general file bad request response
func (o *CreateStorageGeneralFileBadRequest) WithPayload(payload *models.Error) *CreateStorageGeneralFileBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create storage general file bad request response
func (o *CreateStorageGeneralFileBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateStorageGeneralFileBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateStorageGeneralFileConflictCode is the HTTP code returned for type CreateStorageGeneralFileConflict
const CreateStorageGeneralFileConflictCode int = 409

/*
CreateStorageGeneralFileConflict The specified resource already exists

swagger:response createStorageGeneralFileConflict
*/
type CreateStorageGeneralFileConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateStorageGeneralFileConflict creates CreateStorageGeneralFileConflict with default headers values
func NewCreateStorageGeneralFileConflict() *CreateStorageGeneralFileConflict {

	return &CreateStorageGeneralFileConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create storage general file conflict response
func (o *CreateStorageGeneralFileConflict) WithConfigurationVersion(configurationVersion string) *CreateStorageGeneralFileConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create storage general file conflict response
func (o *CreateStorageGeneralFileConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create storage general file conflict response
func (o *CreateStorageGeneralFileConflict) WithPayload(payload *models.Error) *CreateStorageGeneralFileConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create storage general file conflict response
func (o *CreateStorageGeneralFileConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateStorageGeneralFileConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateStorageGeneralFileDefault General Error

swagger:response createStorageGeneralFileDefault
*/
type CreateStorageGeneralFileDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateStorageGeneralFileDefault creates CreateStorageGeneralFileDefault with default headers values
func NewCreateStorageGeneralFileDefault(code int) *CreateStorageGeneralFileDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateStorageGeneralFileDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) WithStatusCode(code int) *CreateStorageGeneralFileDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) WithConfigurationVersion(configurationVersion string) *CreateStorageGeneralFileDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) WithPayload(payload *models.Error) *CreateStorageGeneralFileDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create storage general file default response
func (o *CreateStorageGeneralFileDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateStorageGeneralFileDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
