/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00052\u00020\u00012\u00020\u0002:\u0001\u0005B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/documentation/docstrings/DocStringTagCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "Companion", "intellij.python.psi.impl"})
public final class DocStringTagCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final PsiElementPattern.Capture<PyStringLiteralExpression> DOCSTRING_PATTERN;

    public DocStringTagCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)DOCSTRING_PATTERN), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result2) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                PsiFile psiFile = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
                PsiFile file = psiFile;
                if (DocStringParser.getConfiguredDocStringFormat((PsiElement)((PsiElement)file)) == DocStringFormat.REST) {
                    int offset = parameters.getOffset();
                    String text = file.getText();
                    char prefix = ':';
                    if (offset > 0) {
                        --offset;
                    }
                    StringBuilder prefixBuilder = new StringBuilder();
                    while (offset > 0 && (Character.isLetterOrDigit(text.charAt(offset)) || text.charAt(offset) == prefix)) {
                        prefixBuilder.insert(0, text.charAt(offset));
                        if (text.charAt(offset) == prefix) {
                            --offset;
                            break;
                        }
                        --offset;
                    }
                    while (offset > 0 && text.charAt(--offset) != '\n' && text.charAt(offset) != '\"' && text.charAt(offset) != '\'') {
                        if (Character.isWhitespace(text.charAt(offset))) continue;
                        return;
                    }
                    CompletionResultSet resultSet = result2;
                    if (!(((CharSequence)prefixBuilder).length() == 0)) {
                        resultSet = resultSet.withPrefixMatcher(prefixBuilder.toString());
                    }
                    for (String tag : SphinxDocString.ALL_TAGS) {
                        resultSet.addElement((LookupElement)LookupElementBuilder.create((String)tag));
                    }
                }
            }
        });
    }

    static {
        TreeElementPattern treeElementPattern = PlatformPatterns.psiElement(PyStringLiteralExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PyExpressionStatement.class).inside(PyDocStringOwner.class));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        DOCSTRING_PATTERN = (PsiElementPattern.Capture)treeElementPattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/documentation/docstrings/DocStringTagCompletionContributor$Companion;", "", "<init>", "()V", "DOCSTRING_PATTERN", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

