/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbEmbeddedObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbEmbeddedObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.ui.DbCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.openapi.util.Condition;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbEmbeddedObjectEditor<S extends BasicElement, T extends BasicElement>
extends DbVisualEditorBase<S, DbEmbeddedObjectModelState<T>> {
    private DbCompoundEditor<?, DbObjectModelState<T>> mySubEditor;
    private final JComponent myComponent;
    private final ThreeStateCheckBox myActivated;

    public DbEmbeddedObjectEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<S, DbEmbeddedObjectModelState<T>> model) {
        if (controller == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myComponent = new JPanel((LayoutManager)new GridLayoutManager(2, 6));
        this.myActivated = new ThreeStateCheckBox(this.getModelTitle());
        this.myActivated.setThirdStateEnabled(false);
        this.myActivated.addPropertyChangeListener("ThreeStateCheckbox.state", e -> {
            this.modified();
            this.activateSubEditor();
        });
        this.myComponent.add((Component)this.myActivated, DatabaseUIUtils.createRowConstraints(0));
        this.myComponent.add((Component)new Spacer(), DatabaseUIUtils.createSimpleConstraints(0, 1, 5));
    }

    @Override
    protected void setEnabled(boolean state) {
        DbEmbeddedObjectEditor.setEnabled((JComponent)this.myActivated, state);
    }

    @NotNull
    public ThreeStateCheckBox getActivatedBox() {
        ThreeStateCheckBox threeStateCheckBox = this.myActivated;
        if (threeStateCheckBox == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(2);
        }
        return threeStateCheckBox;
    }

    private void activateSubEditor() {
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(4);
        }
        return fieldSize;
    }

    @Override
    protected void applyImpl() {
        ThreeStateCheckBox.State activated = this.myActivated.getState();
        DbEmbeddedObjectModelState state = (DbEmbeddedObjectModelState)this.getState();
        state.setActivated(this.getController().getModelController(), activated == ThreeStateCheckBox.State.SELECTED);
        state.setInconsistent(activated == ThreeStateCheckBox.State.DONT_CARE);
    }

    @Override
    protected void resetImpl() {
        DbModelRef curRef;
        DbEmbeddedObjectModelState state = (DbEmbeddedObjectModelState)this.getState();
        DbModelRef tgtRef = state.getTargetRef();
        DbModelRef dbModelRef = curRef = this.mySubEditor == null ? null : this.mySubEditor.getModelRef();
        if (!Objects.equals(tgtRef, curRef)) {
            if (this.mySubEditor != null) {
                this.mySubEditor.unregister(false);
                this.myComponent.remove(this.mySubEditor.getComponent());
            }
            DbCompoundEditor dbCompoundEditor = this.mySubEditor = tgtRef == null ? null : this.createEditor(tgtRef);
            if (this.mySubEditor != null) {
                this.mySubEditor.register();
                this.mySubEditor.getComponent().setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                this.myComponent.add((Component)this.mySubEditor.getComponent(), DatabaseUIUtils.createRowConstraints(1));
                this.activateSubEditor();
            }
        }
        ThreeStateCheckBox.State activated = state.isInconsistent() ? ThreeStateCheckBox.State.DONT_CARE : (state.isActivated() ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED);
        this.myActivated.setState(activated);
    }

    @NotNull
    private DbCompoundEditor<T, DbObjectModelState<T>> createEditor(@NotNull DbModelRef<T, DbObjectModelState<T>> tgtModel) {
        if (tgtModel == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(5);
        }
        DbFormCompoundEditor<T, DbObjectModelState<T>> editor2 = this.createEditorImpl(tgtModel);
        editor2.reset();
        editor2.register();
        DbFormCompoundEditor<T, DbObjectModelState<T>> dbFormCompoundEditor = editor2;
        if (dbFormCompoundEditor == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(6);
        }
        return dbFormCompoundEditor;
    }

    @NotNull
    protected DbFormCompoundEditor<T, DbObjectModelState<T>> createEditorImpl(@NotNull DbModelRef<T, DbObjectModelState<T>> tgtModel) {
        if (tgtModel == null) {
            DbEmbeddedObjectEditor.$$$reportNull$$$0(7);
        }
        Condition<DbModelRef<?, ?>> filter = ((DbEmbeddedObjectModelApplier)this.getApplier()).getFilter();
        return new DbFormCompoundEditor<T, DbObjectModelState<T>>(this.getController(), tgtModel, filter);
    }

    @Override
    public boolean isEmpty() {
        return this.mySubEditor == null || this.mySubEditor.isEmpty();
    }

    @Nullable
    public DbCompoundEditor<?, DbObjectModelState<T>> getSubEditor() {
        return this.mySubEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbEmbeddedObjectEditor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgtModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbEmbeddedObjectEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivatedBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

